/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.app;

import java.rmi.RemoteException;
import org.tentackle.dbms.rmi.RemoteDbConnectionImpl;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.dbms.rmi.RmiServer;
import org.tentackle.log.Logger;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.persist.LockManager;
import org.tentackle.persist.app.AbstractServerApplication;
import org.tentackle.validate.Validator;
import org.tentackle.validate.ValidatorCache;

public abstract class ServerApplication
extends AbstractServerApplication {
    private static final Logger LOGGER = Logger.get(ServerApplication.class);
    private final Class<? extends RemoteDbConnectionImpl> connectionClass;
    private RmiServer rmiServer;

    public static ServerApplication getServerApplication() {
        return (ServerApplication)ServerApplication.getRunningApplication();
    }

    public ServerApplication(String name, String version, Class<? extends RemoteDbConnectionImpl> connectionClass) {
        super(name, version);
        this.connectionClass = connectionClass;
    }

    public RmiServer getRmiServer() {
        return this.rmiServer;
    }

    @Override
    protected void startup() {
        super.startup();
        LOGGER.fine("start RMI services");
        this.startRmiServer();
    }

    protected void initializeScripting() {
        super.initializeScripting();
        this.validateValidators();
    }

    protected void validateValidators() {
        LOGGER.info("validating validators");
        for (String pdoName : PdoFactory.getInstance().getPersistenceMapper().getMap().keySet()) {
            Class pdoClass = PdoFactory.getInstance().create(pdoName).getEffectiveClass();
            for (Validator validator : ValidatorCache.getInstance().getFieldValidators(pdoClass)) {
                validator.validate();
            }
        }
    }

    protected RmiServer createRmiServer(Class<? extends RemoteDbConnectionImpl> connectionClass) {
        return new RmiServer(this.getSessionInfo(), connectionClass);
    }

    @Override
    protected void finishStartup() {
        if (!this.getSession().isRemote()) {
            LockManager.getInstance().initialize(this.getSession());
        }
        super.finishStartup();
        this.rmiServer = this.createRmiServer(this.connectionClass);
    }

    protected void startRmiServer() {
        this.rmiServer.start();
    }

    @Override
    protected void cleanup() {
        for (RemoteDbSessionImpl session : RemoteDbSessionImpl.getOpenSessions()) {
            try {
                session.close();
            }
            catch (RuntimeException | RemoteException rex) {
                LOGGER.warning("closing pending session " + session + " failed:", (Throwable)rex);
            }
        }
        RemoteDbSessionImpl.stopCleanupThread();
        if (this.rmiServer != null) {
            this.rmiServer.stop();
            this.rmiServer = null;
        }
        super.cleanup();
    }
}

