/*
 * NumberPoolRemoteDelegateImpl.java
 *
 */

package org.tentackle.persist.ns.rmi;

import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.persist.ns.NumberPoolPersistenceImpl;
import java.rmi.RemoteException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegateImpl;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;


/**
 * Remote delegate implementation for {@link NumberPoolPersistenceImpl}.
 */
public class NumberPoolRemoteDelegateImpl
             extends AbstractPersistentObjectRemoteDelegateImpl<NumberPool,NumberPoolPersistenceImpl>
             implements NumberPoolRemoteDelegate {


  /**
   * Creates the remote delegate for {@link NumberPoolPersistenceImpl}.
   *
   * @param session the RMI session
   * @param persistenceClass the persistence implementation class
   * @param pdoClass the pdo interface class
   */
  public NumberPoolRemoteDelegateImpl(RemoteDbSessionImpl session, Class<NumberPoolPersistenceImpl> persistenceClass, Class<NumberPool> pdoClass) {
    super(session, persistenceClass, pdoClass);
  }

  // @wurblet inclrmi Include --missingok .$classname/methods

  //<editor-fold defaultstate="collapsed" desc="code 'inclrmi' generated by wurblet Include">//GEN-BEGIN:inclrmi


  @Override
  public NumberPool selectByUniqueDomainKey(DomainContext context, String name) throws RemoteException {
    try {
      return newInstance(context).selectByUniqueDomainKey(name);
    }
    catch (RuntimeException e) {
      throw createException(e);
    }
  }

  @Override
  public NumberPool selectByNameRealm(DomainContext context, String name, String realm) throws RemoteException {
    try {
      return newInstance(context).selectByNameRealm(name, realm);
    }
    catch (RuntimeException e) {
      throw createException(e);
    }
  }

  //</editor-fold>//GEN-END:inclrmi

}
