/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.lock;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tentackle.app.Application;
import org.tentackle.common.Service;
import org.tentackle.dbms.Db;
import org.tentackle.log.Logger;
import org.tentackle.misc.Holder;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.LockException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.LockManager;
import org.tentackle.persist.TokenLock;
import org.tentackle.persist.lock.DbTokenLock;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionUtilities;

@Service(value=LockManager.class)
public class DefaultLockManager
implements LockManager {
    private static final Logger LOGGER = Logger.get(DefaultLockManager.class);
    private final boolean enabled;
    private final Map<PdoKey, Lock> lockMap;
    private final Map<TransactionKey, Map<PdoKey, Lock>> createdLocksInFlight;
    private final Map<TransactionKey, Map<PdoKey, Lock>> updatedLocksInFlight;
    private final Map<TransactionKey, Map<PdoKey, Lock>> removedLocksInFlight;
    private boolean rebuild;

    public DefaultLockManager() {
        Application application = Application.getInstance();
        this.enabled = application != null && application.isServer() && !application.getSession().isRemote();
        this.lockMap = new HashMap<PdoKey, Lock>();
        this.createdLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, Lock>>();
        this.updatedLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, Lock>>();
        this.removedLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, Lock>>();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void cleanupUserTokens(Db session, long userId) {
        if (this.enabled) {
            DomainContext context = Pdo.createDomainContext((Session)session);
            this.getLocks(userId).forEach(tokenLock -> {
                DbTokenLock dbTokenLock = (DbTokenLock)tokenLock;
                try {
                    session.transaction("cleanup user locks", () -> {
                        try {
                            dbTokenLock.setSession((Session)session);
                            this.remove(dbTokenLock, context);
                            Object var4_4 = null;
                            return var4_4;
                        }
                        finally {
                            dbTokenLock.setSession(null);
                        }
                    });
                }
                catch (RuntimeException rx) {
                    LOGGER.severe("cleanup stale locktoken failed", (Throwable)rx);
                }
            });
        }
    }

    @Override
    public void initialize(Db session) {
        if (this.enabled) {
            DomainContext context = Pdo.createDomainContext((Session)session);
            for (DbTokenLock lock : this.createTokenLock(session).selectAllObjects()) {
                try {
                    session.transaction("initialize lockmanager", () -> {
                        this.remove(lock, context);
                        return null;
                    });
                }
                catch (RuntimeException rx) {
                    LOGGER.severe("removing locktoken failed", (Throwable)rx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentDomainObject<T>> TokenLock getLock(T pdo) {
        Map<PdoKey, Lock> map = this.lockMap;
        synchronized (map) {
            Lock lock = this.lockMap.get(new PdoKey(pdo));
            return lock == null ? null : lock.tokenLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TokenLock> getLocks(long userId) {
        Map<PdoKey, Lock> map = this.lockMap;
        synchronized (map) {
            return this.lockMap.values().stream().map(Lock::tokenLock).filter(tokenLock -> tokenLock.getLockedBy() == userId).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TokenLock> getLocks() {
        Map<PdoKey, Lock> map = this.lockMap;
        synchronized (map) {
            return this.lockMap.values().stream().map(Lock::tokenLock).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentDomainObject<T>> void update(T pdo) {
        if (this.enabled) {
            try {
                Map<PdoKey, Lock> map = this.lockMap;
                synchronized (map) {
                    PdoKey key = new PdoKey(pdo);
                    Lock lock = this.lockMap.get(key);
                    boolean locked = pdo.isTokenLocked();
                    if (lock == null && locked) {
                        Db db = (Db)pdo.getSession();
                        db.assertTxRunning();
                        DbTokenLock dbTokenLock = this.createTokenLock(db);
                        try {
                            dbTokenLock.setId(key.pdoId);
                            dbTokenLock.setSerial(1L);
                            dbTokenLock.setPdoClassId(key.classId);
                            dbTokenLock.setLockedBy(pdo.getEditedBy());
                            dbTokenLock.setLockedSince(pdo.getEditedSince());
                            dbTokenLock.setLockExpiry(pdo.getEditedExpiry());
                            dbTokenLock.insertPlain();
                            List names = pdo.getDomainContext().getNames();
                            lock = new Lock(dbTokenLock, (String)names.get(names.size() - 1));
                            this.lockMap.put(key, lock);
                            this.addCreatedLock(lock);
                        }
                        finally {
                            dbTokenLock.setSession(null);
                        }
                    }
                    if (lock != null) {
                        Db db = (Db)pdo.getSession();
                        if (lock.tainted) {
                            LOGGER.warning("{0} is tainted -> within {1}", new Object[]{lock, pdo.getDomainContext().toDiagnosticString()});
                        } else if (!pdo.getDomainContext().isWithinContext(lock.contextName)) {
                            throw new LockException((Session)db, lock.contextName);
                        }
                        DbTokenLock dbTokenLock = lock.tokenLock;
                        if (locked) {
                            if (dbTokenLock.getLockedBy() != pdo.getEditedBy() || !Objects.equals(dbTokenLock.getLockedSince(), pdo.getEditedSince()) || !Objects.equals(dbTokenLock.getLockExpiry(), pdo.getEditedExpiry())) {
                                db.assertTxRunning();
                                dbTokenLock.setSession((Session)db);
                                this.addUpdatedLock(lock);
                                try {
                                    dbTokenLock.setLockedBy(pdo.getEditedBy());
                                    dbTokenLock.setLockedSince(pdo.getEditedSince());
                                    dbTokenLock.setLockExpiry(pdo.getEditedExpiry());
                                    dbTokenLock.updatePlain();
                                }
                                finally {
                                    dbTokenLock.setSession(null);
                                }
                            }
                        } else {
                            db.assertTxRunning();
                            dbTokenLock.setSession((Session)db);
                            try {
                                dbTokenLock.deleteObject();
                                this.lockMap.remove(key);
                                this.addRemovedLock(lock);
                            }
                            finally {
                                dbTokenLock.setSession(null);
                            }
                        }
                    }
                }
            }
            catch (LockException lx) {
                throw lx;
            }
            catch (RuntimeException rx) {
                LOGGER.severe("trigger re-initialization of lock manager -> PLEASE FIX THE ROOT-CAUSE A.S.A.P.", (Throwable)rx);
                this.rebuild = true;
                throw rx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Db session, long txNumber) {
        if (this.enabled) {
            TransactionKey txKey = new TransactionKey(session, txNumber);
            Map<PdoKey, Lock> map = this.lockMap;
            synchronized (map) {
                Map<PdoKey, Lock> createdLocks = this.createdLocksInFlight.get(txKey);
                if (createdLocks != null) {
                    for (PdoKey key : createdLocks.keySet()) {
                        this.lockMap.remove(key);
                    }
                }
                this.createdLocksInFlight.remove(txKey);
                Map<PdoKey, Lock> updatedLocks = this.updatedLocksInFlight.get(txKey);
                if (updatedLocks != null) {
                    this.lockMap.putAll(updatedLocks);
                }
                this.updatedLocksInFlight.remove(txKey);
                Map<PdoKey, Lock> removedLocks = this.removedLocksInFlight.get(txKey);
                if (removedLocks != null) {
                    this.lockMap.putAll(removedLocks);
                }
                this.removedLocksInFlight.remove(txKey);
                this.rebuildIfFailed(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Db session, long txNumber) {
        if (this.enabled) {
            TransactionKey txKey = new TransactionKey(session, txNumber);
            Map<PdoKey, Lock> map = this.lockMap;
            synchronized (map) {
                this.createdLocksInFlight.remove(txKey);
                this.updatedLocksInFlight.remove(txKey);
                this.removedLocksInFlight.remove(txKey);
                this.rebuildIfFailed(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(DbTokenLock dbTokenLock, DomainContext context) {
        Object poStr;
        String className = SessionUtilities.getInstance().getClassName(dbTokenLock.getPdoClassId());
        if (className == null) {
            throw new PersistenceException(context.getSession(), "no PDO class for classId " + dbTokenLock.getPdoClassId());
        }
        PdoKey pdoKey = new PdoKey(dbTokenLock);
        Map<PdoKey, Lock> map = this.lockMap;
        synchronized (map) {
            Lock lock = this.lockMap.get(pdoKey);
            if (lock != null && !context.isWithinContext(lock.contextName)) {
                context = context.clone(lock.contextName);
            }
        }
        PersistentDomainObject pdo = Pdo.create((String)className, (DomainContext)context).select(dbTokenLock.getId());
        if (pdo == null) {
            poStr = className + "[" + dbTokenLock.getId() + "]";
            LOGGER.severe("missing {0} for id {1} in {2}", new Object[]{className, dbTokenLock.getId(), context.getSession()});
            Map<PdoKey, Lock> map2 = this.lockMap;
            synchronized (map2) {
                this.lockMap.remove(pdoKey);
            }
        } else {
            AbstractPersistentObject po = (AbstractPersistentObject)pdo.getPersistenceDelegate();
            poStr = po.toGenericString();
            po.clearTokenLock();
            po.updateTokenLockOnly();
        }
        if (!dbTokenLock.isDeleted()) {
            dbTokenLock.deleteObject();
        }
        LOGGER.warning("stale tokenlock removed for {0}, userId {1}, since {2}, expiry {3}", new Object[]{poStr, dbTokenLock.getLockedBy(), dbTokenLock.getLockedSince(), dbTokenLock.getLockExpiry()});
    }

    protected DbTokenLock createTokenLock(Db session) {
        return new DbTokenLock(session);
    }

    protected void reloadLocks(Db session) {
        HashMap<PdoKey, Lock> oldLockMap = new HashMap<PdoKey, Lock>(this.lockMap);
        Holder taintCountHolder = new Holder((Object)0);
        this.lockMap.clear();
        this.createTokenLock(session).selectAllObjects().forEach(dbTokenLock -> {
            Lock lock;
            PdoKey pdoKey = new PdoKey((DbTokenLock)dbTokenLock);
            Lock oldLock = (Lock)oldLockMap.get(pdoKey);
            if (oldLock != null) {
                lock = new Lock((DbTokenLock)dbTokenLock, oldLock.contextName);
            } else {
                lock = new Lock((DbTokenLock)dbTokenLock);
                taintCountHolder.accept((Object)((Integer)taintCountHolder.get() + 1));
            }
            this.lockMap.put(pdoKey, lock);
        });
        int taintCount = (Integer)taintCountHolder.get();
        if (taintCount > 0) {
            LOGGER.warning("{0} locks reloaded in total, {1} tainted!", new Object[]{this.lockMap.size(), taintCount});
        } else {
            LOGGER.info("{0} locks reloaded", new Object[]{this.lockMap.size()});
        }
    }

    private void addCreatedLock(Lock lock) {
        Map<PdoKey, Lock> removedLocks;
        DbTokenLock dbTokenLock = lock.tokenLock;
        TransactionKey txKey = new TransactionKey(dbTokenLock.getSession());
        PdoKey key = new PdoKey(dbTokenLock);
        this.createdLocksInFlight.computeIfAbsent(txKey, tk -> new HashMap()).put(key, lock);
        Map<PdoKey, Lock> updatedLocks = this.updatedLocksInFlight.get(txKey);
        if (updatedLocks != null) {
            updatedLocks.remove(key);
        }
        if ((removedLocks = this.removedLocksInFlight.get(txKey)) != null) {
            removedLocks.remove(key);
        }
    }

    private void addUpdatedLock(Lock lock) {
        DbTokenLock dbTokenLock = lock.tokenLock;
        DbTokenLock copyTokenLock = this.createTokenLock(dbTokenLock.getSession());
        copyTokenLock.setId(dbTokenLock.getId());
        copyTokenLock.setSerial(dbTokenLock.getSerial());
        copyTokenLock.setPdoClassId(dbTokenLock.getPdoClassId());
        copyTokenLock.setLockedBy(dbTokenLock.getLockedBy());
        copyTokenLock.setLockedSince(dbTokenLock.getLockedSince());
        copyTokenLock.setLockExpiry(dbTokenLock.getLockExpiry());
        this.updatedLocksInFlight.computeIfAbsent(new TransactionKey(dbTokenLock.getSession()), tk -> new HashMap()).putIfAbsent(new PdoKey(copyTokenLock), new Lock(copyTokenLock, lock.contextName));
    }

    private void addRemovedLock(Lock lock) {
        Map<PdoKey, Lock> createdLocks;
        DbTokenLock dbTokenLock = lock.tokenLock;
        TransactionKey txKey = new TransactionKey(dbTokenLock.getSession());
        PdoKey pdoKey = new PdoKey(dbTokenLock);
        Map<PdoKey, Lock> updatedLocks = this.updatedLocksInFlight.get(txKey);
        if (updatedLocks != null) {
            updatedLocks.remove(pdoKey);
        }
        if ((createdLocks = this.createdLocksInFlight.get(txKey)) != null && createdLocks.remove(pdoKey) != null) {
            return;
        }
        this.removedLocksInFlight.computeIfAbsent(txKey, tk -> new HashMap()).put(pdoKey, lock);
    }

    private void rebuildIfFailed(Db session) {
        if (this.rebuild && this.isTxMapEmpty(this.createdLocksInFlight) && this.isTxMapEmpty(this.updatedLocksInFlight) && this.isTxMapEmpty(this.removedLocksInFlight)) {
            this.reloadLocks(session);
            this.rebuild = false;
        }
    }

    private boolean isTxMapEmpty(Map<TransactionKey, Map<PdoKey, Lock>> txMap) {
        txMap.keySet().removeIf(txKey -> txKey.sessionRef.get() == null);
        return txMap.isEmpty();
    }

    private record PdoKey(int classId, long pdoId) {
        PdoKey(DbTokenLock lock) {
            this(lock.getPdoClassId(), lock.getPdoId());
        }

        PdoKey(PersistentDomainObject pdo) {
            this(pdo.getClassId(), pdo.getId());
        }
    }

    private record Lock(DbTokenLock tokenLock, String contextName, boolean tainted) {
        Lock(DbTokenLock tokenLock, String contextName) {
            this(tokenLock, contextName, false);
        }

        Lock(DbTokenLock tokenLock) {
            this(tokenLock, "", true);
        }

        @Override
        public String toString() {
            return this.tokenLock.toDiagnosticString();
        }
    }

    private static class TransactionKey {
        final long txNo;
        final WeakReference<Db> sessionRef;

        private TransactionKey(Db session, long txNo) {
            this.txNo = txNo;
            this.sessionRef = new WeakReference<Db>(session);
        }

        private TransactionKey(Db session) {
            this(session, session.getTxNumber());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionKey that = (TransactionKey)o;
            return this.txNo == that.txNo;
        }

        public int hashCode() {
            return Objects.hash(this.txNo);
        }
    }
}

