/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DbObjectClassVariables;
import org.tentackle.dbms.StatementId;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoMethodCache;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.Join;
import org.tentackle.persist.PersistentClassVariablesFactory;
import org.tentackle.persist.security.SecurityPersistenceImpl;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.permissions.ReadPermission;
import org.tentackle.security.permissions.ViewPermission;
import org.tentackle.session.SessionUtilities;

public class PersistentObjectClassVariables<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends DbObjectClassVariables<P> {
    public static final String PROPERTY_CHECKSECURITY = "checksecurity";
    public final Class<T> pdoClass;
    public final PdoMethodCache<T> methodCache;
    public final List<Join<T, ?>> eagerJoins;
    public final String pdoClassBaseName;
    public final String tableAlias;
    public final PersistentObjectClassVariables<? super T, ? super P> superClassVariables;
    public final StatementId selectByNormTextStatementId = new StatementId();
    public final StatementId selectByInvertedNormTextStatementId = new StatementId();
    public final StatementId selectByNormTextCursorStatementId = new StatementId();
    public final StatementId selectByInvertedNormTextCursorStatementId = new StatementId();
    public final StatementId selectAllStatementId = new StatementId();
    public final StatementId selectAllWithExpiredTableSerialsStatementId = new StatementId();
    public final StatementId selectLatestStatementId = new StatementId();
    public final StatementId selectAllCursorStatementId = new StatementId();
    public final StatementId updateTokenLockStatementId = new StatementId();
    public final StatementId updateTokenLockOnlyStatementId = new StatementId();
    public final StatementId selectTokenLockStatementId = new StatementId();
    public final StatementId transferTokenLockStatementId = new StatementId();
    private PersistentObjectClassVariables<? super T, ? super P> topSuperClassVariables;
    private boolean topSuperClassVariablesPending = true;
    private String effectiveTableName;
    private boolean effectiveTableNamePending = true;
    private String effectiveTableAlias;
    private boolean effectiveTableAliasPending = true;
    private List<Join<? super T, ?>> effectiveEagerJoins;
    private boolean effectiveEagerJoinsPending = true;
    private boolean securityEnabled;
    private boolean securityEnabledPending = true;
    private Method createAttributesInSnapshotMethod;
    private Method revertAttributesToSnapshotMethod;
    private Method createComponentsInSnapshotMethod;
    private Method revertComponentsToSnapshotMethod;
    private String sqlColumnNames;
    private String sqlClassIdCondition;

    public static <T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>> PersistentObjectClassVariables<T, P> create(Class<T> pdoClass, Class<P> poClass, String tableAlias, PersistentObjectClassVariables<? super T, ? super P> superClassVariables, List<Join<T, ?>> eagerJoins) {
        return PersistentClassVariablesFactory.getInstance().pdoCv(pdoClass, poClass, tableAlias, superClassVariables, eagerJoins);
    }

    public static <T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>> PersistentObjectClassVariables<T, P> create(Class<T> pdoClass, Class<P> poClass, String tableAlias) {
        return PersistentClassVariablesFactory.getInstance().pdoCv(pdoClass, poClass, tableAlias);
    }

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String tableAlias, PersistentObjectClassVariables<? super T, ? super P> superClassVariables, List<Join<T, ?>> eagerJoins) {
        super(poClass, SessionUtilities.getInstance().determineClassId(pdoClass), SessionUtilities.getInstance().determineTablename(pdoClass));
        this.pdoClass = pdoClass;
        this.methodCache = new PdoMethodCache(pdoClass);
        this.tableAlias = tableAlias;
        this.superClassVariables = superClassVariables;
        this.eagerJoins = eagerJoins;
        this.pdoClassBaseName = pdoClass.getSimpleName();
    }

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String tableAlias) {
        this(pdoClass, poClass, tableAlias, null, null);
    }

    public String getColumnNames(Supplier<List<String>> columnNamesSupplier) {
        return this.getColumnNames(columnNamesSupplier.get());
    }

    public String getColumnNames(List<String> columnNames) {
        if (this.sqlColumnNames == null) {
            StringBuilder buf = new StringBuilder();
            for (String name : columnNames) {
                if (!buf.isEmpty()) {
                    buf.append(',');
                }
                buf.append(this.getColumnName(name));
            }
            this.sqlColumnNames = buf.toString();
        }
        return this.sqlColumnNames;
    }

    public String getSqlClassIdCondition(List<Integer> classIds) {
        if (this.sqlClassIdCondition == null) {
            this.sqlClassIdCondition = this.tableName == null ? this.createSqlClassIdCondition(classIds, true) : "";
        }
        return this.sqlClassIdCondition;
    }

    public String createSqlClassIdCondition(List<Integer> classIds, boolean withAlias) {
        StringBuilder buf = new StringBuilder();
        if (this.superClassVariables != null && classIds != null && !classIds.isEmpty()) {
            buf.append(" AND ");
            if (withAlias) {
                buf.append(this.getColumnName("classid"));
            } else {
                buf.append("classid");
            }
            if (classIds.size() == 1) {
                buf.append('=');
            } else {
                buf.append(" IN(");
            }
            boolean needComma = false;
            for (int classId : classIds) {
                if (needComma) {
                    buf.append(',');
                } else {
                    needComma = true;
                }
                buf.append(classId);
            }
            if (classIds.size() > 1) {
                buf.append(')');
            }
        }
        return buf.toString();
    }

    public List<Join<? super T, ?>> getEagerJoins() {
        if (this.effectiveEagerJoinsPending) {
            PersistentObjectClassVariables<? super T, ? super P> cv = this;
            ArrayList egList = null;
            do {
                if (cv.eagerJoins == null || cv.eagerJoins.isEmpty()) continue;
                if (egList == null) {
                    egList = new ArrayList();
                }
                egList.addAll(cv.eagerJoins);
            } while ((cv = cv.superClassVariables) != null);
            this.effectiveEagerJoins = egList;
            this.effectiveEagerJoinsPending = false;
        }
        return this.effectiveEagerJoins;
    }

    public String getTableName() {
        if (this.effectiveTableNamePending) {
            String name = this.tableName;
            if (name == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null && (name = superCV.tableName) == null) {
                    superCV = superCV.superClassVariables;
                }
            }
            this.effectiveTableName = name;
            this.effectiveTableNamePending = false;
        }
        return this.effectiveTableName;
    }

    public String getTableAlias() {
        if (this.effectiveTableAliasPending) {
            String alias = this.tableAlias;
            if (alias == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null && (alias = superCV.tableAlias) == null) {
                    superCV = superCV.superClassVariables;
                }
            }
            this.effectiveTableAlias = alias;
            this.effectiveTableAliasPending = false;
        }
        return this.effectiveTableAlias;
    }

    public String getColumnName(String name) {
        StringBuilder buf = new StringBuilder();
        String alias = this.getTableAlias();
        if (alias != null) {
            buf.append(alias).append('.');
        }
        buf.append(name);
        return buf.toString();
    }

    public PersistentObjectClassVariables<? super T, ? super P> getTopSuperClassVariables() {
        if (this.topSuperClassVariablesPending) {
            PersistentObjectClassVariables<? super T, ? super P> variables = this;
            while (variables.superClassVariables != null) {
                variables = variables.superClassVariables;
            }
            this.topSuperClassVariables = variables;
            this.topSuperClassVariablesPending = false;
        }
        return this.topSuperClassVariables;
    }

    public boolean isSecurityEnabled() {
        if (this.securityEnabledPending) {
            String prop = this.getProperty(PROPERTY_CHECKSECURITY);
            this.securityEnabled = prop == null || !prop.equals("no") && !prop.equals("off") && !prop.equals("false") && !prop.equals("disabled") && !prop.equals("0");
            this.securityEnabledPending = false;
        }
        return this.securityEnabled;
    }

    public boolean isReferenced(Db db, long id) {
        PersistentObjectClassVariables<? super T, ? super P> cv = this;
        boolean referenced = false;
        while (!referenced && cv != null) {
            referenced = cv.isReferencedImpl(db, id, cv.foreignReferences);
            cv = cv.superClassVariables;
        }
        return referenced;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.pdoClass.getName());
        buf.append("/").append(super.toString());
        if (!this.isSecurityEnabled()) {
            buf.append("/*NOSECURITY*");
        }
        return buf.toString();
    }

    public boolean isAbstract() {
        return this.classId == 0;
    }

    public boolean isReadAllowed(DomainContext context) {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isReadAllowed() {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isWriteAllowed(DomainContext context) {
        return this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isWriteAllowed() {
        return this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isReadAllowed(AbstractPersistentObject<?, ?> object) {
        if (this.isSecurityEnabled()) {
            ReadPermission readPermission = SecurityFactory.getInstance().getReadPermission();
            if (object.isRootEntity()) {
                return object.isPermissionAccepted((Permission)readPermission);
            }
            if (object.getRootClassId() > 0 && object.getRootId() > 0L) {
                return SecurityFactory.getInstance().getSecurityManager().evaluate(object.getBaseContext(), (Permission)readPermission, object.getRootClassId(), object.getRootId()).isAccepted();
            }
        }
        return true;
    }

    public boolean isWriteAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.isSecurityEnabled() || object.isRootEntity() && object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isViewAllowed(AbstractPersistentObject<?, ?> object) {
        if (this.isSecurityEnabled()) {
            ViewPermission viewPermission = SecurityFactory.getInstance().getViewPermission();
            if (object.isRootEntity()) {
                return object.isPermissionAccepted((Permission)viewPermission);
            }
            if (object.getRootClassId() > 0 && object.getRootId() > 0L) {
                return SecurityFactory.getInstance().getSecurityManager().evaluate(object.getBaseContext(), (Permission)viewPermission, object.getRootClassId(), object.getRootId()).isAccepted();
            }
        }
        return true;
    }

    public boolean isEditAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.isSecurityEnabled() || object.isRootEntity() && object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getEditPermission());
    }

    public Method getCreateAttributesInSnapshotMethod() throws NoSuchMethodException {
        if (this.createAttributesInSnapshotMethod == null) {
            this.createAttributesInSnapshotMethod = this.findSnapshotMethod("createAttributesInSnapshot", this.clazz);
        }
        return this.createAttributesInSnapshotMethod;
    }

    public Method getRevertAttributesToSnapshotMethod() throws NoSuchMethodException {
        if (this.revertAttributesToSnapshotMethod == null) {
            this.revertAttributesToSnapshotMethod = this.findSnapshotMethod("revertAttributesToSnapshot", this.clazz);
        }
        return this.revertAttributesToSnapshotMethod;
    }

    public Method getCreateComponentsInSnapshotMethod() throws NoSuchMethodException {
        if (this.createComponentsInSnapshotMethod == null) {
            this.createComponentsInSnapshotMethod = this.findSnapshotMethod("createComponentsInSnapshot", this.clazz);
        }
        return this.createComponentsInSnapshotMethod;
    }

    public Method getRevertComponentsToSnapshotMethod() throws NoSuchMethodException {
        if (this.revertComponentsToSnapshotMethod == null) {
            this.revertComponentsToSnapshotMethod = this.findSnapshotMethod("revertComponentsToSnapshot", this.clazz);
        }
        return this.revertComponentsToSnapshotMethod;
    }

    protected Method findSnapshotMethod(String methodName, Class<?> clazz) throws NoSuchMethodException {
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, clazz);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    protected int determineReferencePriority(Class<? extends AbstractDbObject<?>> clazz) {
        PdoCache cache = Pdo.getPdoCache(clazz);
        if (cache != null) {
            return cache.isPreloading() ? 1 : 2;
        }
        return 3;
    }

    protected boolean checkClassPermission(DomainContext context, Permission permission) {
        try {
            return !this.isSecurityEnabled() || SecurityFactory.getInstance().getSecurityManager().evaluate(context, permission, this.classId, 0L).isAccepted();
        }
        catch (RuntimeException ex) {
            return false;
        }
    }
}

