/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.common.Service;
import org.tentackle.pdo.AdminExtension;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.PdoRemoteSessionAdapter;
import org.tentackle.persist.rmi.AdminExtensionAdapterRemoteDelegate;
import org.tentackle.session.PersistenceException;

@Service(value=AdminExtension.class)
public class AdminExtensionAdapter
implements AdminExtension {
    private DomainContext context;
    private AdminExtensionAdapterRemoteDelegate adminExt;

    public void setDomainContext(DomainContext context) {
        if (this.context != null) {
            throw new PersistenceException("context can be set only once!");
        }
        this.context = context;
        try {
            PdoRemoteSessionAdapter adapter = (PdoRemoteSessionAdapter)context.getSession().getRemoteSession();
            this.adminExt = (AdminExtensionAdapterRemoteDelegate)adapter.getRemoteDbSession().getRemoteDelegate(this.getClass().getName());
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public List<AdminExtension.SessionData> getSessions() {
        try {
            return this.adminExt.getSessions(this.context);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public int kill(long userId, long sessionGroupId, String applicationName, long applicationId) {
        try {
            return this.adminExt.kill(this.context, userId, sessionGroupId, applicationName, applicationId);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public void determineContextId() {
    }

    public long getContextId() {
        return this.context.getContextId();
    }

    public DomainContext getBaseContext() {
        return this.getDomainContext();
    }

    public DomainContext createValidContext() {
        throw new PersistenceException("illegal attempt to create a context");
    }

    public boolean isDomainContextImmutable() {
        return true;
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        if (!contextImmutable) {
            throw new PersistenceException("illegal attempt to set domain context to mutable");
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }
}

