/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.ns;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberPoolPersistence;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.persist.ns.rmi.NumberPoolRemoteDelegate;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;

@PersistentObjectService(value=NumberPool.class)
public class NumberPoolPersistenceImpl
extends AbstractPersistentObject<NumberPool, NumberPoolPersistenceImpl>
implements NumberPoolPersistence {
    private static final long serialVersionUID = 1L;
    public static final PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> CLASSVARIABLES = PersistentObjectClassVariables.create(NumberPool.class, NumberPoolPersistenceImpl.class, "npool", null, null);
    public static final String CN_NAME = "name";
    public static final String CN_REALM = "realm";
    public static final String CN_DESCRIPTION = "description";
    public static final String CN_ONLINE = "poolonline";
    public static final String CN_LOWWATERMARK = "lowmark";
    public static final String CN_REQUESTSIZE = "reqsize";
    public static final String CN_UPLINK = "uplink";
    private String name;
    private String namePersisted;
    private String realm;
    private String realmPersisted;
    private String description;
    private String descriptionPersisted;
    private boolean online;
    private boolean onlinePersisted;
    private long lowWaterMark;
    private long lowWaterMarkPersisted;
    private long requestSize;
    private long requestSizePersisted;
    private String uplink;
    private String uplinkPersisted;
    private static final StatementId SELECT_BY_UNIQUE_DOMAIN_KEY_STMT = new StatementId();
    private TrackedList<NumberRange> numberRangeList;
    private boolean numberRangeListLoaded;
    private transient TrackedList<NumberRange> numberRangeListSnapshot;
    private static final StatementId SELECT_BY_NAME_REALM_STMT = new StatementId();

    @Override
    public PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public NumberPoolPersistenceImpl(NumberPool pdo, DomainContext context) {
        super(pdo, context);
    }

    public NumberPoolPersistenceImpl(NumberPool pdo, Session session) {
        super(pdo, session);
    }

    public NumberPoolPersistenceImpl(NumberPool pdo) {
        super(pdo);
    }

    public NumberPoolPersistenceImpl() {
    }

    @Override
    public boolean isUpdatingSerialEvenIfNotModified() {
        return false;
    }

    @Override
    public NumberPoolRemoteDelegate getRemoteDelegate() {
        return (NumberPoolRemoteDelegate)super.getRemoteDelegate();
    }

    @Override
    public boolean isRootEntity() {
        return true;
    }

    public boolean isTracked() {
        return true;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (!modified) {
            this.namePersisted = this.name;
            this.realmPersisted = this.realm;
            this.descriptionPersisted = this.description;
            this.onlinePersisted = this.online;
            this.lowWaterMarkPersisted = this.lowWaterMark;
            this.requestSizePersisted = this.requestSize;
            this.uplinkPersisted = this.uplink;
        }
    }

    public boolean differsPersisted() {
        return super.differsPersisted() || !Objects.equals(this.namePersisted, this.name) || !Objects.equals(this.realmPersisted, this.realm) || !Objects.equals(this.descriptionPersisted, this.description) || this.onlinePersisted != this.online || this.lowWaterMarkPersisted != this.lowWaterMark || this.requestSizePersisted != this.requestSize || !Objects.equals(this.uplinkPersisted, this.uplink);
    }

    public boolean attributesModified() {
        return this.isForcedModified() || this.differsPersisted();
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_NAME);
            rs.configureColumn(CN_REALM);
            rs.configureColumn(CN_DESCRIPTION);
            rs.configureColumn(CN_ONLINE);
            rs.configureColumn(CN_LOWWATERMARK);
            rs.configureColumn(CN_REQUESTSIZE);
            rs.configureColumn(CN_UPLINK);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.name = rs.getString();
        this.realm = rs.getString(true);
        this.description = rs.getString();
        this.online = rs.getBoolean();
        this.lowWaterMark = rs.getLong();
        this.requestSize = rs.getLong();
        this.uplink = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setString(++ndx, this.name);
        st.setString(++ndx, this.realm, true);
        st.setString(++ndx, this.description);
        st.setBoolean(++ndx, this.online);
        st.setLong(++ndx, this.lowWaterMark);
        st.setLong(++ndx, this.requestSize);
        st.setString(++ndx, this.uplink);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (name,realm,description,poolonline,lowmark,reqsize,uplink,id,serial) VALUES (?,?,?,?,?,?,?,?,?) ";
    }

    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET name=?,realm=?,description=?,poolonline=?,lowmark=?,reqsize=?,uplink=?,serial=serial+1 WHERE id=? AND serial=?";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.assertMutable();
        if (!Objects.equals(this.name, name)) {
            this.firePropertyChange(CN_NAME, this.name, name);
        }
        this.name = name;
    }

    public boolean isNameModified() {
        return !Objects.equals(this.name, this.namePersisted);
    }

    public String getNamePersisted() {
        return this.namePersisted;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.assertMutable();
        if (!Objects.equals(this.realm, realm)) {
            this.firePropertyChange(CN_REALM, this.realm, realm);
        }
        this.realm = realm;
    }

    public boolean isRealmModified() {
        return !Objects.equals(this.realm, this.realmPersisted);
    }

    public String getRealmPersisted() {
        return this.realmPersisted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.assertMutable();
        if (!Objects.equals(this.description, description)) {
            this.firePropertyChange(CN_DESCRIPTION, this.description, description);
        }
        this.description = description;
    }

    public boolean isDescriptionModified() {
        return !Objects.equals(this.description, this.descriptionPersisted);
    }

    public String getDescriptionPersisted() {
        return this.descriptionPersisted;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.assertMutable();
        if (this.online != online) {
            this.firePropertyChange("online", this.online, online);
        }
        this.online = online;
    }

    public boolean isOnlineModified() {
        return this.online != this.onlinePersisted;
    }

    public boolean isOnlinePersisted() {
        return this.onlinePersisted;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setLowWaterMark(long lowWaterMark) {
        this.assertMutable();
        if (this.lowWaterMark != lowWaterMark) {
            this.firePropertyChange("lowWaterMark", this.lowWaterMark, lowWaterMark);
        }
        this.lowWaterMark = lowWaterMark;
    }

    public boolean isLowWaterMarkModified() {
        return this.lowWaterMark != this.lowWaterMarkPersisted;
    }

    public long getLowWaterMarkPersisted() {
        return this.lowWaterMarkPersisted;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public void setRequestSize(long requestSize) {
        this.assertMutable();
        if (this.requestSize != requestSize) {
            this.firePropertyChange("requestSize", this.requestSize, requestSize);
        }
        this.requestSize = requestSize;
    }

    public boolean isRequestSizeModified() {
        return this.requestSize != this.requestSizePersisted;
    }

    public long getRequestSizePersisted() {
        return this.requestSizePersisted;
    }

    public String getUplink() {
        return this.uplink;
    }

    public void setUplink(String uplink) {
        this.assertMutable();
        if (!Objects.equals(this.uplink, uplink)) {
            this.firePropertyChange(CN_UPLINK, this.uplink, uplink);
        }
        this.uplink = uplink;
    }

    public boolean isUplinkModified() {
        return !Objects.equals(this.uplink, this.uplinkPersisted);
    }

    public String getUplinkPersisted() {
        return this.uplinkPersisted;
    }

    protected void revertAttributesToSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.revertAttributesToSnapshot(snapshot);
        this.name = snapshot.name;
        this.namePersisted = snapshot.namePersisted;
        this.realm = snapshot.realm;
        this.realmPersisted = snapshot.realmPersisted;
        this.description = snapshot.description;
        this.descriptionPersisted = snapshot.descriptionPersisted;
        this.online = snapshot.online;
        this.onlinePersisted = snapshot.onlinePersisted;
        this.lowWaterMark = snapshot.lowWaterMark;
        this.lowWaterMarkPersisted = snapshot.lowWaterMarkPersisted;
        this.requestSize = snapshot.requestSize;
        this.requestSizePersisted = snapshot.requestSizePersisted;
        this.uplink = snapshot.uplink;
        this.uplinkPersisted = snapshot.uplinkPersisted;
    }

    public NumberPool selectByUniqueDomainKey(String name) {
        if (this.getSession().isRemote()) {
            try {
                NumberPool obj = this.getRemoteDelegate().selectByUniqueDomainKey(this.getDomainContext(), name);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_UNIQUE_DOMAIN_KEY_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx, name);
        return (NumberPool)this.executeFirstPdoQuery(st);
    }

    public TrackedList<NumberRange> getNumberRangeList() {
        if (!this.numberRangeListLoaded) {
            this.numberRangeList = this.isNew() ? new TrackedArrayList(false) : ((NumberRange)this.on(NumberRange.class)).selectByNumberPoolId(this.getId());
            for (NumberRange obj : this.numberRangeList) {
                obj.setNumberPool((NumberPool)this.me());
            }
            if (this.isImmutable()) {
                this.numberRangeList.setImmutable(true);
            }
            this.numberRangeListLoaded = true;
        }
        return this.numberRangeList;
    }

    public TrackedList<NumberRange> getNumberRangeListBlunt() {
        if (!this.numberRangeListLoaded) {
            this.numberRangeList = new TrackedArrayList(false);
            if (this.isImmutable()) {
                this.numberRangeList.setImmutable(true);
            }
            this.numberRangeListLoaded = true;
        }
        return this.numberRangeList;
    }

    public boolean isNumberRangeListLoaded() {
        return this.numberRangeListLoaded;
    }

    public void setSession(Session session) {
        super.setSession(session);
        session.applyTo(this.numberRangeList);
    }

    @Override
    public void setDomainContext(DomainContext context) {
        super.setDomainContext(context);
        context.applyTo(this.numberRangeList);
    }

    public void deleteReferencingRelations() {
        super.deleteReferencingRelations();
        this.deleteReferencingRelations(true);
    }

    private void deleteReferencingRelations(boolean delete) {
        if (delete) {
            this.delete(this.getNumberRangeList());
        }
        if (this.numberRangeList != null && this.numberRangeList.isSomeRemoved()) {
            this.delete(this.numberRangeList.getRemovedObjects());
        }
    }

    public void saveReferencingRelations(boolean update) {
        super.saveReferencingRelations(update);
        if (update) {
            this.deleteReferencingRelations(false);
        }
        if (this.numberRangeList != null) {
            this.getDomainContext().applyTo(this.numberRangeList);
            for (NumberRange obj : this.numberRangeList) {
                obj.setNumberPool((NumberPool)this.me());
            }
            NumberPoolPersistenceImpl.save(this.numberRangeList, true);
        }
    }

    @Override
    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        List<ValidationResult> results = super.validate(validationPath, scope);
        if (this.numberRangeList != null) {
            results.addAll(ValidationUtilities.getInstance().validateCollection(this.numberRangeList, validationPath + ".numberRangeList", scope));
        }
        return results;
    }

    public void setImmutable(boolean immutable) {
        super.setImmutable(immutable);
        if (this.numberRangeList != null) {
            this.numberRangeList.setImmutable(immutable);
        }
    }

    public boolean isModified() {
        return super.isModified() || this.isModified(this.numberRangeList);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        IdentifiableMap components = new IdentifiableMap();
        this.addComponents(components, onlyLoaded);
        return components;
    }

    @Override
    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded) {
        int count = 0;
        count += super.addComponents(components, onlyLoaded);
        if (!onlyLoaded || this.numberRangeListLoaded) {
            count += this.addComponents(components, (Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList(), onlyLoaded);
        }
        return count;
    }

    @Override
    public void insertPlainWithComponents() {
        this.insertPlain();
        this.insertPlainWithComponents((Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList());
    }

    @Override
    public void deletePlainWithComponents() {
        this.deletePlainWithComponents((Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList());
        this.deletePlain();
    }

    public void markDeleted() {
        super.markDeleted();
        this.markDeleted(this.numberRangeList);
    }

    protected void createComponentsInSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.createComponentsInSnapshot(snapshot);
        snapshot.numberRangeListSnapshot = TrackedList.createSnapshot(this.numberRangeList);
    }

    protected void revertComponentsToSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.revertComponentsToSnapshot(snapshot);
        this.numberRangeList = TrackedList.revertToSnapshot(this.numberRangeList, snapshot.numberRangeListSnapshot);
        this.numberRangeListLoaded = snapshot.numberRangeListLoaded;
    }

    public NumberPool selectByNameRealm(String name, String realm) {
        if (this.getSession().isRemote()) {
            try {
                NumberPool obj = this.getRemoteDelegate().selectByNameRealm(this.getDomainContext(), name, realm);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_NAME_REALM_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_REALM));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        st.setString(ndx, realm, true);
        return (NumberPool)this.executeFirstPdoQuery(st);
    }

    public void reloadRanges() {
        this.numberRangeListLoaded = false;
        this.numberRangeList = null;
    }
}

