/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.security;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Objects;
import org.tentackle.dbms.ModificationType;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.log.Logger;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.persist.security.rmi.SecurityRemoteDelegate;
import org.tentackle.security.pdo.Security;
import org.tentackle.security.pdo.SecurityPersistence;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionUtilities;

@PersistentObjectService(value=Security.class)
public class SecurityPersistenceImpl
extends AbstractPersistentObject<Security, SecurityPersistenceImpl>
implements SecurityPersistence {
    private static final long serialVersionUID = -1178387730540795339L;
    private static final Logger LOGGER = Logger.get(SecurityPersistenceImpl.class);
    public static final PersistentObjectClassVariables<Security, SecurityPersistenceImpl> CLASSVARIABLES = PersistentObjectClassVariables.create(Security.class, SecurityPersistenceImpl.class, "scrty", null, null);
    public static final String CN_OBJECTCLASSNAME = "objectclass";
    public static final String CN_OBJECTCLASSID = "objectclassid";
    public static final String CN_OBJECTID = "objectid";
    public static final String CN_DOMAINCONTEXTCLASSID = "contextclassid";
    public static final String CN_DOMAINCONTEXTID = "contextid";
    public static final String CN_GRANTEECLASSID = "granteeclassid";
    public static final String CN_GRANTEEID = "granteeid";
    public static final String CN_PRIORITY = "secprio";
    public static final String CN_PERMISSIONS = "permissions";
    public static final String CN_ALLOWED = "allowed";
    public static final String CN_MESSAGE = "message";
    private String objectClassName;
    private int objectClassId;
    private long objectId;
    private int domainContextClassId;
    private long domainContextId;
    private int granteeClassId;
    private long granteeId;
    private int priority;
    private String permissions;
    private boolean allowed;
    private String message;
    private static PdoCache<Security> cache;
    private static final StatementId SELECT_BY_GRANTEE_STMT;
    private static final StatementId SELECT_BY_OBJECT_STMT;
    private static final StatementId SELECT_BY_OBJECT_CLASS_STMT;
    private static final StatementId SELECT_BY_DOMAIN_CONTEXT_STMT;
    private static final StatementId DELETE_BY_GRANTEE_STMT;
    private static final StatementId DELETE_BY_OBJECT_STMT;
    private static final StatementId DELETE_BY_OBJECT_CLASS_STMT;
    private static final StatementId DELETE_BY_DOMAIN_CONTEXT_STMT;

    @Override
    public PersistentObjectClassVariables<Security, SecurityPersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public SecurityPersistenceImpl(Security pdo, DomainContext context) {
        super(pdo, context);
    }

    public SecurityPersistenceImpl(Security pdo, Session session) {
        super(pdo, session);
    }

    public SecurityPersistenceImpl(Security pdo) {
        super(pdo);
    }

    public SecurityPersistenceImpl() {
    }

    public PersistentDomainObject<?> getObject() {
        if (this.objectId != 0L && this.objectClassId != 0) {
            try {
                return Pdo.create((String)this.objectClassName, (DomainContext)this.getDomainContext()).select(this.objectId);
            }
            catch (RuntimeException e) {
                LOGGER.warning("can't get secured object for " + this.objectClassName + ", " + this.objectId);
            }
        }
        return null;
    }

    @Override
    public void assertRootContextIsAccepted() {
    }

    public void setObject(PersistentDomainObject<?> object) {
        if (object == null) {
            this.setObjectId(0L);
            this.setObjectClassName(null);
        } else {
            this.setObjectId(object.getPersistenceDelegate().getId());
            this.setObjectClassName(object.getClass().getName());
        }
    }

    public PersistentDomainObject<?> getGrantee() {
        return this.granteeId == 0L ? null : Pdo.create((String)SessionUtilities.getInstance().getClassName(this.granteeClassId), (DomainContext)this.getDomainContext()).selectCached(this.granteeId);
    }

    public void setGrantee(PersistentDomainObject<?> grantee) {
        if (grantee == null) {
            this.setGranteeId(0L);
            this.setGranteeClassId(0);
        } else {
            this.setGranteeId(grantee.getPersistenceDelegate().getId());
            this.setGranteeClassId(grantee.getPersistenceDelegate().getClassId());
        }
    }

    public PersistentDomainObject<?> getDomainContextObject() {
        return this.domainContextId == 0L ? null : Pdo.create((String)SessionUtilities.getInstance().getClassName(this.domainContextClassId), (DomainContext)this.getDomainContext()).selectCached(this.domainContextId);
    }

    public void setDomainContextObject(PersistentDomainObject<?> contextObject) {
        if (contextObject == null) {
            this.setDomainContextId(0L);
            this.setDomainContextClassId(0);
        } else {
            this.setDomainContextId(contextObject.getPersistenceDelegate().getId());
            this.setDomainContextClassId(contextObject.getPersistenceDelegate().getClassId());
        }
    }

    public String toString() {
        return "Security ID=" + this.getId() + ", objectClass=" + this.objectClassName + ", objectId=" + this.objectId + ", contextId=" + this.domainContextId + ", contextClassId=" + this.domainContextClassId + ", granteeId=" + this.granteeId + ", granteeClass=" + this.granteeClassId + ", priority=" + this.priority + ", permissions='" + this.permissions + "', allowed=" + this.allowed + ", message='" + this.message + "'";
    }

    public void assertRemoteSecurityManagerInitialized() {
        try {
            this.getRemoteDelegate().assertRemoteSecurityManagerInitialized(this.getDomainContext());
        }
        catch (RemoteException e) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
        }
    }

    public Class<?> getObjectClass() {
        String className = this.objectClassId != 0 ? SessionUtilities.getInstance().getClassName(this.objectClassId) : this.objectClassName;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new PersistenceException((Identifiable)this, (Throwable)ex);
        }
    }

    private static synchronized PdoCache<Security> createCache() {
        if (cache == null) {
            cache = Pdo.createPdoCache(Security.class, (boolean)true, (boolean)true, (boolean)false);
            Pdo.listen(ev -> cache.expire(ev.getSerial()), (Class[])new Class[]{Security.class});
        }
        return cache;
    }

    @Override
    public PdoCache<Security> getCache() {
        return cache == null ? SecurityPersistenceImpl.createCache() : cache;
    }

    public boolean isCountingModification(ModificationType modType) {
        return true;
    }

    @Override
    public boolean isReadAllowed() {
        return true;
    }

    @Override
    public boolean expireCache(long maxSerial) {
        this.getCache().expire(maxSerial);
        return true;
    }

    @Override
    public Security selectCachedOnly(long id) {
        return (Security)this.getCache().select(this.getDomainContext(), id, false);
    }

    @Override
    public Security selectCached(long id) {
        return (Security)this.getCache().select(this.getDomainContext(), id);
    }

    @Override
    public List<Security> selectAllCached() {
        return this.getCache().selectAll(this.getDomainContext());
    }

    public List<Security> selectByGrantee(int granteeClassId, long granteeId) {
        if (this.getSession().isRemote()) {
            try {
                List<Security> list = this.getRemoteDelegate().selectByGrantee(this.getDomainContext(), granteeClassId, granteeId);
                this.configureRemoteObjects(this.getDomainContext(), list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_GRANTEE_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_GRANTEECLASSID));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_GRANTEEID));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            String orderSuffix = this.orderBy();
            if (orderSuffix != null && !orderSuffix.isEmpty()) {
                sql.append(" ORDER BY ").append(orderSuffix);
            }
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, granteeClassId);
        st.setLong(ndx, granteeId);
        return this.executeListQuery(st);
    }

    public TrackedList<Security> selectByObject(int objectClassId, long objectId) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<Security> list = this.getRemoteDelegate().selectByObject(this.getDomainContext(), objectClassId, objectId);
                this.configureRemoteObjects(this.getDomainContext(), list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_OBJECT_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_OBJECTCLASSID));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_OBJECTID));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            String orderSuffix = this.orderBy();
            if (orderSuffix != null && !orderSuffix.isEmpty()) {
                sql.append(" ORDER BY ").append(orderSuffix);
            }
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx, objectId);
        return this.executeTrackedListQuery(st);
    }

    public TrackedList<Security> selectByObjectClass(String objectClassName) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<Security> list = this.getRemoteDelegate().selectByObjectClass(this.getDomainContext(), objectClassName);
                this.configureRemoteObjects(this.getDomainContext(), list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_OBJECT_CLASS_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_OBJECTCLASSNAME));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            String orderSuffix = this.orderBy();
            if (orderSuffix != null && !orderSuffix.isEmpty()) {
                sql.append(" ORDER BY ").append(orderSuffix);
            }
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx, objectClassName);
        return this.executeTrackedListQuery(st);
    }

    public TrackedList<Security> selectByDomainContext(int domainContextClassId, long domainContextId) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<Security> list = this.getRemoteDelegate().selectByDomainContext(this.getDomainContext(), domainContextClassId, domainContextId);
                this.configureRemoteObjects(this.getDomainContext(), list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_DOMAIN_CONTEXT_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_DOMAINCONTEXTCLASSID));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_DOMAINCONTEXTID));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            String orderSuffix = this.orderBy();
            if (orderSuffix != null && !orderSuffix.isEmpty()) {
                sql.append(" ORDER BY ").append(orderSuffix);
            }
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, domainContextClassId);
        st.setLong(ndx, domainContextId);
        return this.executeTrackedListQuery(st);
    }

    public int deleteByGrantee(int granteeClassId, long granteeId) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().deleteByGrantee(granteeClassId, granteeId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        if (!this.getClassVariables().isWriteAllowed(this.getDomainContext())) {
            throw new PersistenceException("deleteByGrantee denied by security rules");
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_GRANTEE_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_GRANTEECLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_GRANTEEID);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, granteeClassId);
        st.setLong(ndx, granteeId);
        return st.executeUpdate();
    }

    public int deleteByObject(int objectClassId, long objectId) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().deleteByObject(objectClassId, objectId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        if (!this.getClassVariables().isWriteAllowed(this.getDomainContext())) {
            throw new PersistenceException("deleteByObject denied by security rules");
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_OBJECT_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSNAME);
            sql.append(" IS NULL");
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTID);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx, objectId);
        return st.executeUpdate();
    }

    public int deleteByObjectClass(String objectClassName) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().deleteByObjectClass(objectClassName);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        if (!this.getClassVariables().isWriteAllowed(this.getDomainContext())) {
            throw new PersistenceException("deleteByObjectClass denied by security rules");
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_OBJECT_CLASS_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSNAME);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, 0);
        st.setString(ndx, objectClassName);
        return st.executeUpdate();
    }

    public int deleteByDomainContext(int domainContextClassId, long domainContextId) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().deleteByDomainContext(domainContextClassId, domainContextId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        if (!this.getClassVariables().isWriteAllowed(this.getDomainContext())) {
            throw new PersistenceException("deleteByDomainContext denied by security rules");
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_DOMAIN_CONTEXT_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_DOMAINCONTEXTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_DOMAINCONTEXTID);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setInt(ndx++, domainContextClassId);
        st.setLong(ndx, domainContextId);
        return st.executeUpdate();
    }

    @Override
    public SecurityRemoteDelegate getRemoteDelegate() {
        return (SecurityRemoteDelegate)super.getRemoteDelegate();
    }

    @Override
    public boolean isRootEntity() {
        return true;
    }

    public boolean isTracked() {
        return true;
    }

    @Override
    public String orderBy() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getColumnName(CN_PRIORITY)).append(" ASC");
        return sql.toString();
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_OBJECTCLASSNAME);
            rs.configureColumn(CN_OBJECTCLASSID);
            rs.configureColumn(CN_OBJECTID);
            rs.configureColumn(CN_DOMAINCONTEXTCLASSID);
            rs.configureColumn(CN_DOMAINCONTEXTID);
            rs.configureColumn(CN_GRANTEECLASSID);
            rs.configureColumn(CN_GRANTEEID);
            rs.configureColumn(CN_PRIORITY);
            rs.configureColumn(CN_PERMISSIONS);
            rs.configureColumn(CN_ALLOWED);
            rs.configureColumn(CN_MESSAGE);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.objectClassName = rs.getString();
        this.objectClassId = rs.getInt();
        this.objectId = rs.getLong();
        this.domainContextClassId = rs.getInt();
        this.domainContextId = rs.getLong();
        this.granteeClassId = rs.getInt();
        this.granteeId = rs.getLong();
        this.priority = rs.getInt();
        this.permissions = rs.getString();
        this.allowed = rs.getBoolean();
        this.message = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setString(++ndx, this.objectClassName);
        st.setInt(++ndx, this.objectClassId);
        st.setLong(++ndx, this.objectId);
        st.setInt(++ndx, this.domainContextClassId);
        st.setLong(++ndx, this.domainContextId);
        st.setInt(++ndx, this.granteeClassId);
        st.setLong(++ndx, this.granteeId);
        st.setInt(++ndx, this.priority);
        st.setString(++ndx, this.permissions);
        st.setBoolean(++ndx, this.allowed);
        st.setString(++ndx, this.message);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (objectclass,objectclassid,objectid,contextclassid,contextid,granteeclassid,granteeid,secprio,permissions,allowed,message,id,serial) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    }

    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET objectclass=?,objectclassid=?,objectid=?,contextclassid=?,contextid=?,granteeclassid=?,granteeid=?,secprio=?,permissions=?,allowed=?,message=?,serial=serial+1 WHERE id=? AND serial=?";
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.assertMutable();
        if (!Objects.equals(this.objectClassName, objectClassName)) {
            this.setModified(true);
        }
        this.objectClassName = objectClassName;
    }

    public int getObjectClassId() {
        return this.objectClassId;
    }

    public void setObjectClassId(int objectClassId) {
        this.assertMutable();
        if (this.objectClassId != objectClassId) {
            this.setModified(true);
        }
        this.objectClassId = objectClassId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.assertMutable();
        if (this.objectId != objectId) {
            this.setModified(true);
        }
        this.objectId = objectId;
    }

    public int getDomainContextClassId() {
        return this.domainContextClassId;
    }

    public void setDomainContextClassId(int domainContextClassId) {
        this.assertMutable();
        if (this.domainContextClassId != domainContextClassId) {
            this.setModified(true);
        }
        this.domainContextClassId = domainContextClassId;
    }

    public long getDomainContextId() {
        return this.domainContextId;
    }

    public void setDomainContextId(long domainContextId) {
        this.assertMutable();
        if (this.domainContextId != domainContextId) {
            this.setModified(true);
        }
        this.domainContextId = domainContextId;
    }

    public int getGranteeClassId() {
        return this.granteeClassId;
    }

    public void setGranteeClassId(int granteeClassId) {
        this.assertMutable();
        if (this.granteeClassId != granteeClassId) {
            this.setModified(true);
        }
        this.granteeClassId = granteeClassId;
    }

    public long getGranteeId() {
        return this.granteeId;
    }

    public void setGranteeId(long granteeId) {
        this.assertMutable();
        if (this.granteeId != granteeId) {
            this.setModified(true);
        }
        this.granteeId = granteeId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.assertMutable();
        if (this.priority != priority) {
            this.setModified(true);
        }
        this.priority = priority;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.assertMutable();
        if (!Objects.equals(this.permissions, permissions)) {
            this.setModified(true);
        }
        this.permissions = permissions;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.assertMutable();
        if (this.allowed != allowed) {
            this.setModified(true);
        }
        this.allowed = allowed;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.assertMutable();
        if (!Objects.equals(this.message, message)) {
            this.setModified(true);
        }
        this.message = message;
    }

    protected void revertAttributesToSnapshot(SecurityPersistenceImpl snapshot) {
        super.revertAttributesToSnapshot(snapshot);
        this.objectClassName = snapshot.objectClassName;
        this.objectClassId = snapshot.objectClassId;
        this.objectId = snapshot.objectId;
        this.domainContextClassId = snapshot.domainContextClassId;
        this.domainContextId = snapshot.domainContextId;
        this.granteeClassId = snapshot.granteeClassId;
        this.granteeId = snapshot.granteeId;
        this.priority = snapshot.priority;
        this.permissions = snapshot.permissions;
        this.allowed = snapshot.allowed;
        this.message = snapshot.message;
    }

    static {
        SELECT_BY_GRANTEE_STMT = new StatementId();
        SELECT_BY_OBJECT_STMT = new StatementId();
        SELECT_BY_OBJECT_CLASS_STMT = new StatementId();
        SELECT_BY_DOMAIN_CONTEXT_STMT = new StatementId();
        DELETE_BY_GRANTEE_STMT = new StatementId();
        DELETE_BY_OBJECT_STMT = new StatementId();
        DELETE_BY_OBJECT_CLASS_STMT = new StatementId();
        DELETE_BY_DOMAIN_CONTEXT_STMT = new StatementId();
    }
}

