/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.common.Timestamp;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.rmi.AbstractDbObjectRemoteDelegateImpl;
import org.tentackle.dbms.rmi.DbObjectResult;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.dbms.rmi.RemoteDelegate;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.pdo.TokenLockInfo;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegate;
import org.tentackle.persist.rmi.RemoteResultSetCursor;
import org.tentackle.persist.rmi.RemoteResultSetCursorImpl;
import org.tentackle.session.Session;

public class AbstractPersistentObjectRemoteDelegateImpl<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends AbstractDbObjectRemoteDelegateImpl<P>
implements AbstractPersistentObjectRemoteDelegate<T, P> {
    private static final String ILLEGAL_METHOD_TEXT = "remote method not allowed for PDOs";
    protected final Class<T> pdoClass;
    protected T pdo;

    public AbstractPersistentObjectRemoteDelegateImpl(RemoteDbSessionImpl serverSession, Class<P> persistenceClass, Class<T> pdoClass) {
        super(serverSession, persistenceClass);
        this.pdoClass = pdoClass;
    }

    public void initialize() {
        try {
            this.pdo = this.newInstance(Pdo.createDomainContext((Session)this.getSession()));
        }
        catch (RuntimeException e) {
            this.pdo = this.newInstance(null);
        }
        this.dbObject = (AbstractPersistentObject)this.pdo.getPersistenceDelegate();
    }

    protected T newInstance(DomainContext context) {
        if (context != null) {
            context.setSession((Session)this.getSession());
        }
        PersistentDomainObject newPdo = context == null ? Pdo.create(this.pdoClass, (Session)this.getSession()) : Pdo.create(this.pdoClass, (DomainContext)context);
        ((AbstractDbObject)newPdo.getPersistenceDelegate()).setOverloadable(true);
        return (T)newPdo;
    }

    protected void setDomainContext(DomainContext context) {
        if (context != null) {
            context.setSession((Session)this.getSession());
        }
        ((AbstractPersistentObject)this.dbObject).setDomainContext(context);
    }

    public P selectObject(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public P selectObjectForUpdate(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public List<P> selectAllObjects() throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void dummyUpdate(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void updateSerial(long id, long serial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void updateAndSetSerial(long id, long serial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void updateSerialAndTableSerial(long id, long serial, long tableSerial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void updatePlain(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void deletePlain(long id, long serial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public void insertPlain(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public DbObjectResult updateObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public DbObjectResult insertObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public DbObjectResult deleteObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public P persistObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public DbObjectResult saveObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public boolean isReferenced(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    public List<IdSerialTuple> selectAllIdSerial() throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public T persistImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            return po.persist();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long saveImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            po.save();
            return po.getTableSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long deleteImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            po.delete();
            po.markDeleted();
            return po.getTableSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectAll(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectAll();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public T select(DomainContext cb, long id, boolean locked) throws RemoteException {
        try {
            return ((AbstractPersistentObject)this.newInstance(cb).getPersistenceDelegate()).select(id, locked);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectByNormText(DomainContext cb, String normText) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectByNormText(normText);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public RemoteResultSetCursor<T> selectByNormTextAsCursor(DomainContext cb, String normText) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return this.createRemoteResultSetCursorDelegate(((AbstractPersistentObject)this.dbObject).selectByNormTextAsCursor(normText));
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectAllForCache(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectAllCached();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public T selectForCache(DomainContext cb, long id) throws RemoteException {
        try {
            return (T)this.newInstance(cb).getPersistenceDelegate().selectCached(id);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public RemoteResultSetCursor<T> selectAllAsCursor(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return this.createRemoteResultSetCursorDelegate(((AbstractPersistentObject)this.dbObject).selectAllAsCursor());
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectAllWithExpiredTableSerials(DomainContext cb, long oldSerial) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectAllWithExpiredTableSerials(oldSerial);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean isReferenced(DomainContext cb, long id) throws RemoteException {
        try {
            PersistentDomainObject obj = this.newInstance(cb).select(id);
            return obj != null && obj.isReferenced();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public TokenLockInfo updateTokenLock(long id, Timestamp tokenExpiry, long userId, Timestamp curTime) throws RemoteException {
        try {
            ((AbstractPersistentObject)this.dbObject).setId(id);
            ((AbstractPersistentObject)this.dbObject).updateTokenLock(tokenExpiry, userId, curTime);
            return new TokenLockInfo((PersistentObject)this.dbObject);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public T transferTokenLock(T pdo, long userId) throws RemoteException {
        try {
            return (T)pdo.transferTokenLock(userId);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void updateTokenLockOnly(long id, long editedBy, Timestamp editedSince, Timestamp editedExpiry) throws RemoteException {
        try {
            ((AbstractPersistentObject)this.dbObject).setId(id);
            ((AbstractPersistentObject)this.dbObject).setEditedBy(editedBy);
            ((AbstractPersistentObject)this.dbObject).setEditedSince(editedSince);
            ((AbstractPersistentObject)this.dbObject).setEditedExpiry(editedExpiry);
            ((AbstractPersistentObject)this.dbObject).updateTokenLockOnly();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    public RemoteResultSetCursor<T> createRemoteResultSetCursorDelegate(ScrollableResource<T> cursor) throws RemoteException {
        try {
            RemoteResultSetCursor cursorDelegate = (RemoteResultSetCursor)this.getServerSession().createRemoteDelegate(RemoteResultSetCursor.class, RemoteResultSetCursorImpl.class, this.pdoClass, null, new Object[]{cursor});
            this.getServerSession().exportRemoteDelegate((RemoteDelegate)cursorDelegate);
            return cursorDelegate;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException | RemoteException ex) {
            throw this.createException(ex);
        }
    }
}

