/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.common.Timestamp;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.dbms.rmi.RemoteDelegateImpl;
import org.tentackle.log.Logger;
import org.tentackle.pdo.AdminExtension;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.AdminExtensionAdapter;
import org.tentackle.persist.rmi.AdminExtensionAdapterRemoteDelegate;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityManager;
import org.tentackle.security.SecurityResult;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;

public class AdminExtensionAdapterRemoteDelegateImpl
extends RemoteDelegateImpl<AdminExtensionAdapter>
implements AdminExtensionAdapterRemoteDelegate {
    private static final Logger LOGGER = Logger.get(AdminExtensionAdapterRemoteDelegateImpl.class);

    public AdminExtensionAdapterRemoteDelegateImpl(RemoteDbSessionImpl session, Class<AdminExtensionAdapter> clazz) {
        super(session, clazz);
    }

    @Override
    public List<AdminExtension.SessionData> getSessions(DomainContext context) throws RemoteException {
        try {
            context.setSession((Session)this.getSession());
            this.checkPermission(context);
            ArrayList<AdminExtension.SessionData> sessions = new ArrayList<AdminExtension.SessionData>();
            for (RemoteDbSessionImpl remoteSession : RemoteDbSessionImpl.getOpenSessions()) {
                sessions.add(new SessionDataImpl(remoteSession));
            }
            sessions.sort((o1, o2) -> {
                int rv = Compare.compare((Comparable)((Object)o1.getUserName()), (Comparable)((Object)o2.getUserName()));
                if (rv == 0) {
                    rv = Long.compare(o1.getSessionNumber(), o2.getSessionNumber());
                }
                return rv;
            });
            return sessions;
        }
        catch (RuntimeException ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public int kill(DomainContext context, long userId, long sessionGroupId, String applicationName, long applicationId) throws RemoteException {
        LOGGER.warning("killing session(s) for userId {0}, groupId {1}, application {2}, applicationId {3}", new Object[]{userId, sessionGroupId, applicationName, applicationId});
        try {
            context.setSession((Session)this.getSession());
            this.checkPermission(context);
            int count = 0;
            for (RemoteDbSessionImpl openSession : RemoteDbSessionImpl.getOpenSessions()) {
                if (openSession.getClientSessionInfo().getUserId() != userId || sessionGroupId != 0L && (long)openSession.getSession().getSessionGroupId() != sessionGroupId || applicationName != null && !Objects.equals(openSession.getClientSessionInfo().getApplicationName(), applicationName) || applicationId != 0L && openSession.getClientSessionInfo().getApplicationId() != applicationId) continue;
                Db db = openSession.getSession();
                if (db != null) {
                    db.setOwnerThread(Thread.currentThread());
                }
                openSession.close();
                ++count;
            }
            return count;
        }
        catch (RuntimeException ex) {
            throw this.createException(ex);
        }
    }

    private void checkPermission(DomainContext context) {
        SecurityFactory sf = SecurityFactory.getInstance();
        SecurityManager sm = sf.getSecurityManager();
        SecurityResult sr = sm.evaluate(context, (Permission)sf.getExecutePermission(), this.getServicedClass());
        if (!sr.isAccepted()) {
            throw new SecurityException(sr.explain("no execute permission for " + this.getServicedClass().getName()));
        }
    }

    private static class SessionDataImpl
    implements AdminExtension.SessionData,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final NumberFormat OFFSET_FMT = new DecimalFormat("+#0.#");
        private final long userId;
        private final String userName;
        private final Timestamp since;
        private final String applicationName;
        private final long applicationId;
        private final String clientVersion;
        private final String locale;
        private final String vmInfo;
        private final String osInfo;
        private final String hostInfo;
        private final String timeZone;
        private final String clientHost;
        private final long sessionNumber;
        private final long sessionGroup;
        private final String options;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionDataImpl(RemoteDbSessionImpl remoteSession) {
            SessionInfo info = remoteSession.getClientSessionInfo();
            this.userId = info.getUserId();
            this.userName = info.getUserName();
            this.since = new Timestamp(info.getSince());
            this.applicationName = info.getApplicationName();
            this.applicationId = info.getApplicationId();
            this.clientVersion = info.getClientVersion() == null ? "?" : info.getClientVersion();
            this.locale = info.getLocale() == null ? "?" : info.getLocale().toString();
            this.vmInfo = info.getVmInfo();
            this.osInfo = info.getOsInfo();
            this.hostInfo = info.getHostInfo();
            double tzOffsetH = (double)info.getTimeZone().getOffset(System.currentTimeMillis()) / 3600000.0;
            NumberFormat numberFormat = OFFSET_FMT;
            synchronized (numberFormat) {
                this.timeZone = info.getTimeZone() == null ? "?" : info.getTimeZone().getID() + " (" + OFFSET_FMT.format(tzOffsetH) + "h)";
            }
            this.clientHost = remoteSession.getClientHostString();
            this.sessionNumber = remoteSession.getSessionNumber();
            this.sessionGroup = remoteSession.getSession().getSessionGroupId();
            this.options = remoteSession.getOptions();
        }

        public long getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public Timestamp getSince() {
            return this.since;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public long getApplicationId() {
            return this.applicationId;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getVmInfo() {
            return this.vmInfo;
        }

        public String getOsInfo() {
            return this.osInfo;
        }

        public String getHostInfo() {
            return this.hostInfo;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getClientHost() {
            return this.clientHost;
        }

        public long getSessionNumber() {
            return this.sessionNumber;
        }

        public long getSessionGroup() {
            return this.sessionGroup;
        }

        public String getOptions() {
            return this.options;
        }
    }
}

