/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.lock;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.Service;
import org.tentackle.dbms.Db;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.LockManager;
import org.tentackle.persist.TokenLock;
import org.tentackle.persist.lock.DbTokenLock;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionUtilities;

@Service(value=LockManager.class)
public class DefaultLockManager
implements LockManager {
    private static final Logger LOGGER = Logger.get(DefaultLockManager.class);
    private final boolean enabled = AbstractApplication.isServer();
    private final Map<PdoKey, DbTokenLock> lockMap = new HashMap<PdoKey, DbTokenLock>();
    private final Map<TransactionKey, Map<PdoKey, DbTokenLock>> createdLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, DbTokenLock>>();
    private final Map<TransactionKey, Map<PdoKey, DbTokenLock>> updatedLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, DbTokenLock>>();
    private final Map<TransactionKey, Map<PdoKey, DbTokenLock>> removedLocksInFlight = new HashMap<TransactionKey, Map<PdoKey, DbTokenLock>>();
    private boolean rebuild;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void cleanupUserTokens(Db session, long userId) {
        if (this.enabled) {
            DomainContext context = Pdo.createDomainContext((Session)session);
            this.getLocks(userId).forEach(tokenLock -> {
                DbTokenLock lock = (DbTokenLock)tokenLock;
                try {
                    session.transaction("cleanup user locks", () -> {
                        try {
                            lock.setSession((Session)session);
                            this.remove(lock, context);
                            Object var4_4 = null;
                            return var4_4;
                        }
                        finally {
                            lock.setSession(null);
                        }
                    });
                }
                catch (RuntimeException rx) {
                    LOGGER.severe("cleanup stale locktoken failed", (Throwable)rx);
                }
            });
        }
    }

    @Override
    public void initialize(Db session) {
        if (this.enabled) {
            DomainContext context = Pdo.createDomainContext((Session)session);
            for (DbTokenLock lock : this.createTokenLock(session).selectAllObjects()) {
                try {
                    session.transaction("initialize lockmanager", () -> {
                        this.remove(lock, context);
                        return null;
                    });
                }
                catch (RuntimeException rx) {
                    LOGGER.severe("removing locktoken failed", (Throwable)rx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentDomainObject<T>> TokenLock getLock(T pdo) {
        Map<PdoKey, DbTokenLock> map = this.lockMap;
        synchronized (map) {
            return this.lockMap.get(new PdoKey(pdo.getClassId(), pdo.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TokenLock> getLocks(long userId) {
        Map<PdoKey, DbTokenLock> map = this.lockMap;
        synchronized (map) {
            return this.lockMap.values().stream().filter(lock -> lock.getLockedBy() == userId).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TokenLock> getLocks() {
        Map<PdoKey, DbTokenLock> map = this.lockMap;
        synchronized (map) {
            return new ArrayList<TokenLock>(this.lockMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentDomainObject<T>> void update(T pdo) {
        if (this.enabled) {
            try {
                Map<PdoKey, DbTokenLock> map = this.lockMap;
                synchronized (map) {
                    PdoKey key = new PdoKey(pdo);
                    DbTokenLock lock = this.lockMap.get(key);
                    boolean locked = pdo.isTokenLocked();
                    if (lock == null && locked) {
                        Db db = (Db)pdo.getSession();
                        db.assertTxRunning();
                        lock = this.createTokenLock(db);
                        try {
                            lock.setId(key.pdoId);
                            lock.setSerial(1L);
                            lock.setPdoClassId(key.classId);
                            lock.setLockedBy(pdo.getEditedBy());
                            lock.setLockedSince(pdo.getEditedSince());
                            lock.setLockExpiry(pdo.getEditedExpiry());
                            lock.insertPlain();
                            this.lockMap.put(key, lock);
                            this.addCreatedLock(lock);
                        }
                        finally {
                            lock.setSession(null);
                        }
                    }
                    if (lock != null) {
                        if (locked) {
                            if (lock.getLockedBy() != pdo.getEditedBy() || !Objects.equals(lock.getLockedSince(), pdo.getEditedSince()) || !Objects.equals(lock.getLockExpiry(), pdo.getEditedExpiry())) {
                                Db db = (Db)pdo.getSession();
                                db.assertTxRunning();
                                lock.setSession((Session)db);
                                this.addUpdatedLock(lock);
                                try {
                                    lock.setLockedBy(pdo.getEditedBy());
                                    lock.setLockedSince(pdo.getEditedSince());
                                    lock.setLockExpiry(pdo.getEditedExpiry());
                                    lock.updatePlain();
                                }
                                finally {
                                    lock.setSession(null);
                                }
                            }
                        } else {
                            Db db = (Db)pdo.getSession();
                            db.assertTxRunning();
                            lock.setSession((Session)db);
                            try {
                                lock.deleteObject();
                                this.lockMap.remove(key);
                                this.addRemovedLock(lock);
                            }
                            finally {
                                lock.setSession(null);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException rx) {
                LOGGER.severe("trigger re-initialization of lock manager", (Throwable)rx);
                this.rebuild = true;
                throw rx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Db session, long txNumber) {
        if (this.enabled) {
            TransactionKey txKey = new TransactionKey(session, txNumber);
            Map<PdoKey, DbTokenLock> map = this.lockMap;
            synchronized (map) {
                Map<PdoKey, DbTokenLock> createdLocks = this.createdLocksInFlight.get(txKey);
                if (createdLocks != null) {
                    for (PdoKey pdoKey : createdLocks.keySet()) {
                        this.lockMap.remove(pdoKey);
                    }
                }
                this.createdLocksInFlight.remove(txKey);
                Map<PdoKey, DbTokenLock> updatedLocks = this.updatedLocksInFlight.get(txKey);
                if (updatedLocks != null) {
                    for (Map.Entry<PdoKey, DbTokenLock> entry : updatedLocks.entrySet()) {
                        this.lockMap.put(entry.getKey(), entry.getValue());
                    }
                }
                this.updatedLocksInFlight.remove(txKey);
                Map<PdoKey, DbTokenLock> map2 = this.removedLocksInFlight.get(txKey);
                if (map2 != null) {
                    for (Map.Entry<PdoKey, DbTokenLock> entry : map2.entrySet()) {
                        this.lockMap.put(entry.getKey(), entry.getValue());
                    }
                }
                this.removedLocksInFlight.remove(txKey);
                this.rebuildIfFailed(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Db session, long txNumber) {
        if (this.enabled) {
            TransactionKey txKey = new TransactionKey(session, txNumber);
            Map<PdoKey, DbTokenLock> map = this.lockMap;
            synchronized (map) {
                this.createdLocksInFlight.remove(txKey);
                this.updatedLocksInFlight.remove(txKey);
                this.removedLocksInFlight.remove(txKey);
                this.rebuildIfFailed(session);
            }
        }
    }

    protected void remove(DbTokenLock lock, DomainContext context) {
        String className = SessionUtilities.getInstance().getClassName(lock.getPdoClassId());
        if (className == null) {
            throw new PersistenceException(context.getSession(), "no PDO class for classId " + lock.getPdoClassId());
        }
        PersistentDomainObject pdo = Pdo.create((String)className, (DomainContext)context).select(lock.getId());
        if (pdo == null) {
            throw new PersistenceException(context.getSession(), "no " + className + " for id " + lock.getId());
        }
        AbstractPersistentObject po = (AbstractPersistentObject)pdo.getPersistenceDelegate();
        po.clearTokenLock();
        po.updateTokenLockOnly();
        if (!lock.isDeleted()) {
            lock.deleteObject();
        }
        LOGGER.warning("stale tokenlock removed for {0}, userId {1}, since {2}, expiry {3}", new Object[]{po.toGenericString(), lock.getLockedBy(), lock.getLockedSince(), lock.getLockExpiry()});
    }

    protected DbTokenLock createTokenLock(Db session) {
        return new DbTokenLock(session);
    }

    protected void reloadLocks(Db session) {
        this.lockMap.clear();
        this.createTokenLock(session).selectAllObjects().forEach(lock -> this.lockMap.put(new PdoKey((DbTokenLock)lock), (DbTokenLock)lock));
    }

    private void addCreatedLock(DbTokenLock lock) {
        Map<PdoKey, DbTokenLock> removedLocks;
        TransactionKey txKey = new TransactionKey(lock.getSession());
        PdoKey key = new PdoKey(lock);
        this.createdLocksInFlight.computeIfAbsent(txKey, tk -> new HashMap()).put(key, lock);
        Map<PdoKey, DbTokenLock> updatedLocks = this.updatedLocksInFlight.get(txKey);
        if (updatedLocks != null) {
            updatedLocks.remove(key);
        }
        if ((removedLocks = this.removedLocksInFlight.get(txKey)) != null) {
            removedLocks.remove(key);
        }
    }

    private void addUpdatedLock(DbTokenLock lock) {
        DbTokenLock copy = this.createTokenLock(lock.getSession());
        copy.setId(lock.getId());
        copy.setSerial(lock.getSerial());
        copy.setPdoClassId(lock.getPdoClassId());
        copy.setLockedBy(lock.getLockedBy());
        copy.setLockedSince(lock.getLockedSince());
        copy.setLockExpiry(lock.getLockExpiry());
        this.updatedLocksInFlight.computeIfAbsent(new TransactionKey(lock.getSession()), tk -> new HashMap()).putIfAbsent(new PdoKey(copy), copy);
    }

    private void addRemovedLock(DbTokenLock lock) {
        Map<PdoKey, DbTokenLock> createdLocks;
        TransactionKey txKey = new TransactionKey(lock.getSession());
        PdoKey pdoKey = new PdoKey(lock);
        Map<PdoKey, DbTokenLock> updatedLocks = this.updatedLocksInFlight.get(txKey);
        if (updatedLocks != null) {
            updatedLocks.remove(pdoKey);
        }
        if ((createdLocks = this.createdLocksInFlight.get(txKey)) != null && createdLocks.remove(pdoKey) != null) {
            return;
        }
        this.removedLocksInFlight.computeIfAbsent(txKey, tk -> new HashMap()).put(pdoKey, lock);
    }

    private void rebuildIfFailed(Db session) {
        if (this.rebuild && this.isTxMapEmpty(this.createdLocksInFlight) && this.isTxMapEmpty(this.updatedLocksInFlight) && this.isTxMapEmpty(this.removedLocksInFlight)) {
            this.reloadLocks(session);
            this.rebuild = false;
            LOGGER.warning("lock manager re-initialized");
        }
    }

    private boolean isTxMapEmpty(Map<TransactionKey, Map<PdoKey, DbTokenLock>> txMap) {
        Iterator<TransactionKey> iter = txMap.keySet().iterator();
        while (iter.hasNext()) {
            TransactionKey txKey = iter.next();
            if (txKey.sessionRef.get() != null) continue;
            iter.remove();
        }
        return txMap.isEmpty();
    }

    private static class TransactionKey {
        final long txNo;
        final WeakReference<Db> sessionRef;

        public TransactionKey(Db session, long txNo) {
            this.txNo = txNo;
            this.sessionRef = new WeakReference<Db>(session);
        }

        public TransactionKey(Db session) {
            this(session, session.getTxNumber());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionKey that = (TransactionKey)o;
            return this.txNo == that.txNo;
        }

        public int hashCode() {
            return Objects.hash(this.txNo);
        }
    }

    private static class PdoKey {
        final int classId;
        final long pdoId;

        PdoKey(int classId, long pdoId) {
            this.classId = classId;
            this.pdoId = pdoId;
        }

        PdoKey(DbTokenLock lock) {
            this.classId = lock.getPdoClassId();
            this.pdoId = lock.getPdoId();
        }

        PdoKey(PersistentDomainObject pdo) {
            this.classId = pdo.getClassId();
            this.pdoId = pdo.getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PdoKey key = (PdoKey)o;
            return this.classId == key.classId && this.pdoId == key.pdoId;
        }

        public int hashCode() {
            return Objects.hash(this.classId, this.pdoId);
        }
    }
}

