/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.sql.JoinType;

public class Join<T extends PersistentDomainObject<T>, J extends PersistentDomainObject<J>> {
    private static final String ENDS_WITH_ID = ".id";
    private final JoinType type;
    private final String columnName;
    private final String joinedColumnName;
    private final Class<J> joinedClass;
    private final String joinAlias;
    private final BiConsumer<T, J> joiner;
    private final List<Join<J, ?>> joins;
    private final boolean listJoin;
    private final boolean explicitIdAliasRequired;
    private final Map<T, Set<J>> lastJoinedPdoMap;
    private final String extraSql;

    public Join(JoinType type, String columnName, String joinedColumnName, Class<J> joinedClass, String joinAlias, String extraSql, BiConsumer<T, J> joiner) {
        this.type = type;
        this.columnName = columnName;
        this.joinedColumnName = joinedColumnName;
        this.joinedClass = joinedClass;
        this.joinAlias = joinAlias;
        this.joiner = joiner;
        this.extraSql = extraSql;
        this.joins = new ArrayList();
        this.lastJoinedPdoMap = new HashMap<T, Set<J>>();
        this.listJoin = columnName.endsWith(ENDS_WITH_ID);
        this.explicitIdAliasRequired = !this.listJoin && ((AbstractPersistentObject)PdoFactory.getInstance().createPersistenceDelegate(joinedClass.getName())).isExplicitIdAliasRequiredInJoins();
    }

    public Join(JoinType type, String columnName, String joinedColumnName, Class<J> joinedClass, String joinAlias, BiConsumer<T, J> joiner) {
        this(type, columnName, joinedColumnName, joinedClass, joinAlias, null, joiner);
    }

    public JoinType getType() {
        return this.type;
    }

    public boolean isListJoin() {
        return this.listJoin;
    }

    public boolean isExplicitIdAliasRequired() {
        return this.explicitIdAliasRequired;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getJoinedColumnName() {
        return this.joinedColumnName;
    }

    public Class<J> getJoinedClass() {
        return this.joinedClass;
    }

    public String getJoinAlias() {
        return this.joinAlias;
    }

    public BiConsumer<T, J> getJoiner() {
        return this.joiner;
    }

    public String getExtraSql() {
        return this.extraSql;
    }

    public Join<T, J> addJoin(Join<J, ?> join) {
        this.joins.add(join);
        return this;
    }

    public List<Join<J, ?>> getJoins() {
        return this.joins;
    }

    public void initialize() {
        this.lastJoinedPdoMap.clear();
    }

    public J createJoinedPdo(T pdo) {
        return (J)Pdo.create(this.joinedClass, (DomainContext)pdo.getPersistenceDelegate().getDomainContext());
    }

    public void join(T pdo, J pdoToJoin) {
        Set lastJoined = this.lastJoinedPdoMap.computeIfAbsent(pdo, k -> new HashSet());
        if (lastJoined.add(pdoToJoin)) {
            this.joiner.accept(pdo, pdoToJoin);
        }
    }
}

