/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.misc.DateHelper;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.PropertySupport;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.LockException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PdoMethodCache;
import org.tentackle.pdo.PdoMethodCacheProvider;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.pdo.TokenLockInfo;
import org.tentackle.persist.Join;
import org.tentackle.persist.JoinedSelect;
import org.tentackle.persist.LockManager;
import org.tentackle.persist.NormText;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.persist.ResultSetCursor;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegate;
import org.tentackle.persist.rmi.RemoteResultSetCursor;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityException;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityResult;
import org.tentackle.session.NotFoundException;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionHolder;
import org.tentackle.session.SessionUtilities;
import org.tentackle.validate.ValidationFailedException;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.scope.ChangeableScope;
import org.tentackle.validate.scope.MandatoryScope;
import org.tentackle.validate.scope.PersistenceScope;

public abstract class AbstractPersistentObject<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends AbstractDbObject<P>
implements PersistentObject<T>,
EffectiveClassProvider<T>,
PdoMethodCacheProvider<T>,
Cloneable {
    private static final long serialVersionUID = 1921941642168910515L;
    private transient boolean contextImmutable;
    private T pdo;
    private boolean persistable = true;
    private long editedBy;
    private org.tentackle.common.Timestamp editedSince;
    private org.tentackle.common.Timestamp editedExpiry;
    private String normText;
    private long rootId;
    private int rootClassId;
    private transient boolean validated;
    private boolean renewTokenLock;
    private transient long cacheAccessCount;
    private transient long cacheAccessTime;
    private transient boolean expired;
    private transient List<WeakReference<T>> snapshots;
    private transient boolean objectIsCopy;
    private transient boolean objectIsSnapshot;
    public static final String CN_EDITEDBY = "editedby";
    public static final String AN_EDITEDBY = "editedBy";
    public static final String CN_EDITEDEXPIRY = "editedexpiry";
    public static final String AN_EDITEDEXPIRY = "editedExpiry";
    public static final String CN_EDITEDSINCE = "editedsince";
    public static final String AN_EDITEDSINCE = "editedSince";
    public static final String CN_NORMTEXT = "normtext";
    public static final String AN_NORMTEXT = "normText";
    public static final String CN_ROOTID = "rootid";
    public static final String AN_ROOTID = "rootId";
    public static final String CN_ROOTCLASSID = "rootclassid";
    public static final String AN_ROOTCLASSID = "rootClassId";
    public static final String TX_SAVE_COPY_IN_CONTEXT = "save copy in context";
    public static final String TX_DELETE_ALL_IN_CONTEXT = "delete all in context";
    public static final String TX_TRANSFER_TOKENLOCK = "transfer lock";
    public static final String TX_UPDATE_TOKENLOCK = "update lock";
    public static final String TX_UPDATE_TOKENLOCK_ONLY = "update lock only";

    public AbstractPersistentObject(T pdo, DomainContext context) {
        this.pdo = pdo;
        this.setDomainContext(context);
    }

    public AbstractPersistentObject(T pdo, Session session) {
        super((Db)session);
        this.pdo = pdo;
    }

    public AbstractPersistentObject(T pdo) {
        this.pdo = pdo;
    }

    public AbstractPersistentObject() {
    }

    public DomainDelegate<T> getDomainDelegate() {
        return this.pdo.getDomainDelegate();
    }

    public T getPdo() {
        return this.pdo;
    }

    public T me() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public Class<T> getEffectiveClass() {
        return this.pdo.getEffectiveClass();
    }

    public List<Class<? super T>> getEffectiveSuperClasses() {
        return this.pdo.getEffectiveSuperClasses();
    }

    public PdoMethodCache<T> getPdoMethodCache() {
        return this.getClassVariables().methodCache;
    }

    protected final P clone() {
        try {
            return (P)((AbstractPersistentObject)super.clone());
        }
        catch (CloneNotSupportedException cnx) {
            throw new UnsupportedOperationException(cnx.getMessage(), cnx);
        }
    }

    public T createSnapshot() {
        PersistentDomainObject snapshot = PdoFactory.getInstance().create(this.getPdoClass(), (PersistentObject)this.clone());
        PersistentObject persistentSnapshot = snapshot.getPersistenceDelegate();
        persistentSnapshot.setDomainContext(this.getDomainContext());
        try {
            this.getClassVariables().getCreateAttributesInSnapshotMethod().invoke((Object)this, persistentSnapshot);
            this.getClassVariables().getCreateComponentsInSnapshotMethod().invoke((Object)this, persistentSnapshot);
            this.addSnapshot(snapshot);
            snapshot.setCopy(false);
            return (T)snapshot;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new PersistenceException((Identifiable)this, "creating snapshot incorrectly implemented", (Throwable)ex);
        }
    }

    protected void createAttributesInSnapshot(AbstractPersistentObject snapshot) {
        super.createAttributesInSnapshot((AbstractDbObject)snapshot);
        snapshot.objectIsSnapshot = true;
    }

    protected void createComponentsInSnapshot(AbstractPersistentObject snapshot) {
    }

    public void revertToSnapshot(T snapshot) {
        if (snapshot != null) {
            this.assertValidSnapshot(snapshot);
            this.applySnapshot(snapshot);
        }
    }

    public T copy() {
        PersistentDomainObject copiedPdo = this.on();
        AbstractPersistentObject copiedPo = (AbstractPersistentObject)copiedPdo.getPersistenceDelegate();
        DomainContext ctx = copiedPo.getDomainContext();
        copiedPo.objectIsCopy = true;
        copiedPo.applySnapshot((PersistentDomainObject)this.pdo.createSnapshot());
        copiedPo.setModified(true);
        copiedPo.setDomainContext(ctx);
        return (T)copiedPdo;
    }

    private void applySnapshot(T snapshot) {
        PersistentObject persistentSnapshot = snapshot.getPersistenceDelegate();
        try {
            this.getClassVariables().getRevertAttributesToSnapshotMethod().invoke((Object)this, persistentSnapshot);
            this.getClassVariables().getRevertComponentsToSnapshotMethod().invoke((Object)this, persistentSnapshot);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new PersistenceException((Identifiable)this, "reverting snapshot incorrectly implemented", (Throwable)ex);
        }
    }

    protected void revertAttributesToSnapshot(AbstractPersistentObject snapshot) {
        super.revertAttributesToSnapshot((AbstractDbObject)snapshot);
        this.contextImmutable = snapshot.contextImmutable;
        this.cacheAccessCount = snapshot.cacheAccessCount;
        this.cacheAccessTime = snapshot.cacheAccessTime;
        this.expired = snapshot.expired;
        this.snapshots = snapshot.snapshots;
        this.normText = snapshot.normText;
        this.validated = snapshot.validated;
        this.persistable = snapshot.persistable;
    }

    protected void revertComponentsToSnapshot(AbstractPersistentObject snapshot) {
    }

    public boolean isSnapshot() {
        return this.objectIsSnapshot;
    }

    public boolean isCopy() {
        return this.objectIsCopy;
    }

    public void setCopy(boolean copy) {
        this.objectIsCopy = copy;
        if (copy) {
            this.snapshots = null;
            this.objectIsSnapshot = false;
        }
    }

    public List<T> getSnapshots() {
        ArrayList<PersistentDomainObject> shots = new ArrayList<PersistentDomainObject>();
        if (this.snapshots != null) {
            Iterator<WeakReference<T>> iterator = this.snapshots.iterator();
            while (iterator.hasNext()) {
                PersistentDomainObject snapshot = (PersistentDomainObject)iterator.next().get();
                if (snapshot == null) {
                    iterator.remove();
                    continue;
                }
                shots.add(snapshot);
            }
        }
        return shots;
    }

    public void discardSnapshot(T snapshot) {
        int index = this.getSnapshotIndex(snapshot);
        if (index < 0) {
            throw new PersistenceException((Identifiable)this, "not my snapshot");
        }
        this.snapshots.remove(index);
    }

    public void discardSnapshots() {
        this.snapshots = null;
    }

    protected void addSnapshot(T snapshot) {
        if (this.snapshots == null) {
            this.snapshots = new ArrayList<WeakReference<T>>();
        } else if (this.getSnapshotIndex(snapshot) >= 0) {
            throw new PersistenceException((Identifiable)this, "snapshot already added");
        }
        this.snapshots.add(new WeakReference<T>(snapshot));
    }

    protected void assertValidSnapshot(T snapshot) {
        if (!snapshot.isSnapshot()) {
            throw new PersistenceException((Identifiable)this, "not a snapshot");
        }
        if (!this.isCopy() && this.getSnapshotIndex(snapshot) < 0) {
            throw new PersistenceException((Identifiable)this, "not my snapshot");
        }
    }

    private int getSnapshotIndex(T snapshot) {
        if (this.snapshots != null) {
            int index = 0;
            Iterator<WeakReference<T>> iterator = this.snapshots.iterator();
            while (iterator.hasNext()) {
                PersistentDomainObject shot = (PersistentDomainObject)iterator.next().get();
                if (shot == null) {
                    iterator.remove();
                    continue;
                }
                if (shot == snapshot) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    protected void assertNotCached() {
        if (this.isCached()) {
            throw new PersistenceException((Identifiable)this, "object is a cached");
        }
    }

    protected void assertMutable() {
        super.assertMutable();
        if (this.isSnapshot()) {
            throw new PersistenceException((Identifiable)this, (Throwable)new ImmutableException("object is a snapshot"));
        }
    }

    public boolean isPersistable() {
        return this.persistable && super.isPersistable() && this.getDomainContext() != null && !this.isAbstract();
    }

    public void setPersistable(boolean persistable) {
        this.persistable = persistable;
    }

    protected void assertPersistable() {
        if (!this.isPersistable()) {
            StringBuilder buf = new StringBuilder();
            if (this.isImmutable()) {
                buf.append("immutable ");
            }
            if (this.isAbstract()) {
                buf.append("abstract ");
            }
            if (this.getDomainContext() == null) {
                buf.append("contextless ");
            }
            buf.append("object is not persistable");
            throw new PersistenceException((Identifiable)this, buf.toString());
        }
    }

    protected PropertySupport createPropertySupport() {
        return new PropertySupport(this.pdo);
    }

    public boolean isRootEntity() {
        return false;
    }

    public boolean isRootIdProvided() {
        return false;
    }

    public long getRootId() {
        return this.rootId;
    }

    public void setRootId(long rootId) {
        this.rootId = rootId;
    }

    public boolean isRootClassIdProvided() {
        return false;
    }

    public int getRootClassId() {
        return this.rootClassId;
    }

    public void setRootClassId(int rootClassId) {
        this.rootClassId = rootClassId;
    }

    public <C extends PersistentDomainObject<C>> boolean isRootEntityOf(C component) {
        return this.isRootEntity() && component != null && component.getRootId() == this.getId() && component.getRootClassId() == this.getClassId();
    }

    public boolean isNormTextProvided() {
        return false;
    }

    protected void assertNormTextProvided() {
        if (!this.isNormTextProvided()) {
            throw new PersistenceException((Identifiable)this, "entity does not provide a normtext column");
        }
    }

    public void setNormText(String normText) {
        this.assertMutable();
        if (!Objects.equals(this.normText, normText)) {
            this.setModified(true);
        }
        this.normText = normText;
    }

    public String getNormText() {
        return this.normText;
    }

    public StringBuilder createAttributesNormText() {
        return null;
    }

    public StringBuilder createRelationsNormText() {
        return null;
    }

    public void updateNormText() {
        if (this.isNormTextProvided()) {
            StringBuilder ntBuf = this.createAttributesNormText();
            StringBuilder relBuf = this.createRelationsNormText();
            if (ntBuf != null) {
                if (relBuf != null) {
                    ntBuf.append((CharSequence)relBuf);
                }
            } else {
                ntBuf = relBuf;
            }
            if (ntBuf != null) {
                ntBuf.insert(0, ',');
                this.setNormText(StringHelper.normalize((String)ntBuf.toString()));
            } else {
                this.setNormText(null);
            }
        }
    }

    public boolean isDomainContextImmutable() {
        return this.contextImmutable;
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        this.contextImmutable = contextImmutable;
    }

    protected void assertDomainContextMutable() {
        if (this.isDomainContextImmutable()) {
            throw new PersistenceException((Identifiable)this, "domain context is immutable");
        }
    }

    public void setDomainContext(DomainContext context) {
        if (this.getDomainContext() != context) {
            if (context == null) {
                throw new IllegalArgumentException("domain context cannot be cleared to null");
            }
            this.assertDomainContextMutable();
            if (this.isRootEntity()) {
                this.setSessionHolder((SessionHolder)context.getRootContext(this.pdo));
            } else {
                this.setSessionHolder((SessionHolder)context);
            }
            this.determineContextId();
        }
    }

    public DomainContext getDomainContext() {
        return (DomainContext)this.getSessionHolder();
    }

    public void determineContextId() {
    }

    public long getContextId() {
        return -1L;
    }

    public String getSqlContextCondition() {
        return null;
    }

    public String getSqlClassIdCondition() {
        if (this.isClassIdRequiredInWhereClause()) {
            return " AND " + this.getTopSuperTableAlias() + ".classid=?";
        }
        return null;
    }

    public DomainContext getBaseContext() {
        return this.getDomainContext();
    }

    public DomainContext createValidContext() {
        Object session = Session.getCurrentSession();
        session = session != null ? null : this.getSession();
        return Pdo.createDomainContext((Session)session);
    }

    public PersistentObjectClassVariables<T, P> getClassVariables() {
        throw new PersistenceException((Identifiable)this, "classvariables undefined for " + this.getClass());
    }

    public String getTableName() {
        return this.getClassVariables().getTableName();
    }

    public String getTableAlias() {
        return this.getClassVariables().getTableAlias();
    }

    public String getColumnName(String name) {
        return this.getClassVariables().getColumnName(name);
    }

    public String getTopSuperTableAlias() {
        return this.getClassVariables().getTopSuperClassVariables().getTableAlias();
    }

    public String getTopSuperTableName() {
        return this.getClassVariables().getTopSuperClassVariables().getTableName();
    }

    public Class<T> getPdoClass() {
        return this.getClassVariables().pdoClass;
    }

    public boolean isAbstract() {
        return this.getClassVariables().isAbstract();
    }

    public void assertNotAbstract() {
        if (this.isAbstract()) {
            throw new PersistenceException((Identifiable)this, "operation not allowed for abstract entities");
        }
    }

    public int getValidClassId() {
        this.assertNotAbstract();
        return super.getClassId();
    }

    public boolean isClassIdRequiredInWhereClause() {
        return false;
    }

    public boolean isExplicitIdAliasRequiredInJoins() {
        return false;
    }

    public boolean isComposite() {
        return false;
    }

    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        if (this.isComposite()) {
            throw new PersistenceException("method not implemented");
        }
        return new IdentifiableMap(this.getPdo());
    }

    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded) {
        return components.add(this.getPdo()) == null ? 1 : 0;
    }

    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, Collection<? extends PersistentDomainObject<?>> objects, boolean onlyLoaded) {
        int count = 0;
        for (PersistentDomainObject<?> object : objects) {
            count += ((AbstractPersistentObject)object.getPersistenceDelegate()).addComponents(components, onlyLoaded);
        }
        return count;
    }

    public void deletePlainWithComponents() {
        this.assertNotRemote();
        if (this.isComposite()) {
            throw new PersistenceException((Identifiable)this, "local part of the method not implemented");
        }
        this.deletePlain();
    }

    public int deletePlainWithComponents(Collection<? extends PersistentDomainObject<?>> objects) {
        int count = 0;
        if (objects != null && !objects.isEmpty()) {
            Session session = null;
            long txVoucher = 0L;
            try {
                for (PersistentDomainObject<?> obj : objects) {
                    if (obj == null) continue;
                    if (session == null) {
                        session = obj.getSession();
                        if (session == null) {
                            throw new PersistenceException(obj, "db is null");
                        }
                        txVoucher = session.begin("delete plain with components collection");
                    } else if (obj.getSession() != session) {
                        throw new PersistenceException(obj, "unexpected db connection: " + obj.getSession() + ", expected: " + session);
                    }
                    ((AbstractPersistentObject)obj.getPersistenceDelegate()).deletePlainWithComponents();
                    ++count;
                }
                if (session != null) {
                    session.commit(txVoucher);
                }
            }
            catch (RuntimeException rex) {
                if (session != null) {
                    session.rollback(txVoucher);
                }
                throw rex;
            }
        }
        return count;
    }

    public void insertPlainWithComponents() {
        this.assertNotRemote();
        if (this.isComposite()) {
            throw new PersistenceException((Identifiable)this, "local part of the method not implemented");
        }
        this.insertPlain();
    }

    public int insertPlainWithComponents(Collection<? extends PersistentDomainObject<?>> objects) {
        int count = 0;
        if (objects != null && !objects.isEmpty()) {
            Session session = null;
            long txVoucher = 0L;
            try {
                for (PersistentDomainObject<?> obj : objects) {
                    if (obj == null) continue;
                    if (session == null) {
                        session = obj.getSession();
                        if (session == null) {
                            throw new PersistenceException(obj, "db is null");
                        }
                        txVoucher = session.begin("insert plain with components collection");
                    } else if (obj.getSession() != session) {
                        throw new PersistenceException(obj, "unexpected db connection: " + obj.getSession() + ", expected: " + session);
                    }
                    ((AbstractPersistentObject)obj.getPersistenceDelegate()).insertPlainWithComponents();
                    ++count;
                }
                if (session != null) {
                    session.commit(txVoucher);
                }
            }
            catch (RuntimeException rex) {
                if (session != null) {
                    session.rollback(txVoucher);
                }
                throw rex;
            }
        }
        return count;
    }

    public T findDuplicate() {
        PersistentDomainObject otherPdo;
        T thisPdo = this.getPdo();
        Object key = thisPdo.getDomainDelegate().getUniqueDomainKey();
        if (key != null && (otherPdo = thisPdo.getDomainDelegate().findByUniqueDomainKey(key)) != null && !otherPdo.equals(thisPdo)) {
            return (T)otherPdo;
        }
        return null;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getCacheAccessTime() {
        return this.cacheAccessTime;
    }

    public long getCacheAccessCount() {
        return this.cacheAccessCount;
    }

    public void markCacheAccess() {
        ++this.cacheAccessCount;
        this.cacheAccessTime = System.currentTimeMillis();
        this.editedBy = 0L;
    }

    public boolean isCached() {
        return this.cacheAccessCount > 0L;
    }

    public SecurityResult getSecurityResult(Permission permission) {
        return SecurityFactory.getInstance().getSecurityManager().evaluate(this.getBaseContext(), permission, this.getClassId(), this.getId());
    }

    public boolean isPermissionAccepted(Permission permission) {
        return this.getSecurityResult(permission).isAccepted();
    }

    public T selectByTemplate(AbstractPersistentObject<T, P> template) {
        return this.select(template.getId());
    }

    public JoinedSelect<T> getEagerJoinedSelect() {
        List eagerJoins = this.getEagerJoins();
        return eagerJoins != null && !eagerJoins.isEmpty() ? new JoinedSelect(eagerJoins) : null;
    }

    public P readFromResultSetWrapper(ResultSetWrapper rs) {
        AbstractPersistentObject po = (AbstractPersistentObject)super.readFromResultSetWrapper(rs);
        if (po.isAbstract()) {
            int classId = po.getClassId();
            if (classId == 0) {
                throw new PersistenceException((Identifiable)po, "class id is 0 in " + po.toGenericString());
            }
            String className = SessionUtilities.getInstance().getClassName(classId);
            if (className == null) {
                throw new PersistenceException((Identifiable)po, "no such PDO class for classId " + classId + " in " + po.toGenericString());
            }
            po = (AbstractPersistentObject)Pdo.create((String)className, (DomainContext)this.getDomainContext()).getPersistenceDelegate();
            po = po.readFromResultSetWrapper(rs);
        }
        if (po.getContextId() >= 0L || po.getDomainContext() == null) {
            long domainContextId;
            long l = domainContextId = po.getDomainContext() == null ? -1L : po.getDomainContext().getContextId();
            if (domainContextId != po.getContextId()) {
                po.setDomainContext(po.createValidContext());
            }
        }
        return (P)po;
    }

    public void executeQueryToList(PreparedStatementWrapper st, JoinedSelect<T> js, List<T> list) {
        this.assertRootContextIsAccepted();
        try (ResultSetWrapper rs = st.executeQuery();){
            this.executeQueryToList(rs, js, list);
        }
    }

    public void executeQueryToList(ResultSetWrapper rs, JoinedSelect<T> js, List<T> list) {
        if (js == null) {
            while (rs.next()) {
                AbstractPersistentObject nextPo = (AbstractPersistentObject)this.newInstance();
                nextPo = nextPo.readFromResultSetWrapper(rs);
                PersistentDomainObject nextPdo = Pdo.create(nextPo.getPdoClass(), (PersistentObject)nextPo);
                if ((nextPdo = this.derivePdoFromPo(nextPdo, nextPo)) == null) continue;
                list.add(nextPdo);
            }
        } else {
            js.initialize(list);
            while (rs.next()) {
                this.readJoinedRow(rs, js);
            }
        }
    }

    public List<T> executeListQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        ArrayList list = new ArrayList();
        this.executeQueryToList(st, js, list);
        return list;
    }

    public List<T> executeListQuery(PreparedStatementWrapper st) {
        return this.executeListQuery(st, null);
    }

    public TrackedList<T> executeTrackedListQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        TrackedArrayList list = new TrackedArrayList();
        this.executeQueryToList(st, js, (List<T>)list);
        list.setModified(false);
        return list;
    }

    public TrackedList<T> executeTrackedListQuery(PreparedStatementWrapper st) {
        return this.executeTrackedListQuery(st, null);
    }

    public List<Join<? super T, ?>> getEagerJoins() {
        ArrayList eagerJoins = null;
        PersistentObjectClassVariables cv = this.getClassVariables();
        while (cv != null) {
            if (cv.eagerJoins != null && !cv.eagerJoins.isEmpty()) {
                if (eagerJoins == null) {
                    eagerJoins = new ArrayList();
                }
                eagerJoins.addAll(cv.eagerJoins);
            }
            cv = cv.superClassVariables;
        }
        return eagerJoins;
    }

    public void readJoinedRow(ResultSetWrapper rs, JoinedSelect<T> js) {
        Object nextPdo;
        rs.startSkip();
        AbstractPersistentObject nextPo = (AbstractPersistentObject)this.newInstance();
        nextPo = nextPo.readFromResultSetWrapper(rs);
        if (js.currentPdo() == null || js.currentPdo().getPersistenceDelegate().getId() != nextPo.getId()) {
            nextPdo = Pdo.create(nextPo.getPdoClass(), (PersistentObject)nextPo);
            PersistentDomainObject knownPdo = js.nextPdo((PersistentDomainObject)(nextPdo = this.derivePdoFromPo(nextPdo, nextPo)));
            if (knownPdo != nextPdo) {
                nextPdo = knownPdo;
                nextPo = (AbstractPersistentObject)nextPdo.getPersistenceDelegate();
            }
        } else {
            nextPdo = js.currentPdo();
        }
        rs.skip(nextPo.getColumnCount());
        for (Join<T, ?> join : js.getJoins()) {
            this.readJoin(rs, nextPdo, join);
        }
    }

    private <J extends PersistentDomainObject<J>> void readJoin(ResultSetWrapper rs, J nextPdo, Join<? super J, ?> join) {
        int columnCount;
        Object joinedPdo = join.createJoinedPdo(nextPdo);
        AbstractPersistentObject joinedPo = (AbstractPersistentObject)joinedPdo.getPersistenceDelegate();
        if (rs.getObject(rs.findColumn("id")) != null && (joinedPdo = (joinedPo = joinedPo.readFromResultSetWrapper(rs)).derivePdoFromPo(joinedPdo, joinedPo)) != null) {
            join.join(nextPdo, joinedPdo);
        }
        int n = columnCount = joinedPo != null ? joinedPo.getColumnCount() : 0;
        if (join.isExplicitIdAliasRequired()) {
            ++columnCount;
        }
        rs.skip(columnCount);
        for (Join<?, ?> subJoin : join.getJoins()) {
            this.readJoin(rs, (J)joinedPdo, (Join<? super J, ?>)subJoin);
        }
    }

    public T executeFirstPdoQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        this.assertRootContextIsAccepted();
        T pDo = null;
        try (ResultSetWrapper rs = st.executeQuery();){
            if (js == null) {
                if (rs.next()) {
                    AbstractDbObject po = this.readFromResultSetWrapper(rs);
                    pDo = this.derivePdoFromPo(this.pdo, po);
                }
            } else {
                js.initialize(null);
                while (pDo == null && rs.next()) {
                    this.readJoinedRow(rs, js);
                    pDo = js.getLastPdo();
                }
                if (pDo == null) {
                    pDo = js.currentPdo();
                }
            }
            T t = pDo;
            return t;
        }
    }

    public T executeFirstPdoQuery(PreparedStatementWrapper st) {
        return this.executeFirstPdoQuery(st, null);
    }

    public T select(long id, boolean forUpdate) {
        T obj = null;
        if (id > 0L) {
            if (this.getSession().isRemote()) {
                try {
                    DomainContext context = this.getDomainContext();
                    obj = this.getRemoteDelegate().select(context, id, forUpdate);
                    this.configureRemoteObject(context, obj);
                }
                catch (RemoteException e) {
                    throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
                }
            } else {
                StatementId stmtId;
                if (forUpdate) {
                    this.getSession().assertTxRunning();
                    stmtId = this.getClassVariables().selectForUpdateStatementId;
                } else {
                    stmtId = this.getClassVariables().selectObjectStatementId;
                }
                JoinedSelect<T> js = this.getEagerJoinedSelect();
                PreparedStatementWrapper st = this.getPreparedStatement(stmtId, () -> {
                    StringBuilder sql = new StringBuilder(this.createSelectSql(forUpdate));
                    if (js != null) {
                        js.createJoinedSql(this.pdo, sql);
                    }
                    return sql.toString();
                });
                int ndx = 1;
                if (js != null) {
                    ndx = this.setClassIdsInStatement(js, st, ndx);
                }
                st.setLong(ndx, id);
                obj = this.executeFirstPdoQuery(st, js);
            }
        }
        return obj;
    }

    protected int setClassIdsInStatement(JoinedSelect<T> js, PreparedStatementWrapper st, int ndx) {
        for (Join<T, ?> join : js.getJoins()) {
            if (!join.getJoins().isEmpty()) {
                throw new PersistenceException((Identifiable)this, "eager relations cannot be cascaded");
            }
            PersistentDomainObject joinedPdo = Pdo.create(join.getJoinedClass());
            AbstractPersistentObject joinPD = (AbstractPersistentObject)joinedPdo.getPersistenceDelegate();
            if (!joinPD.isClassIdRequiredInWhereClause()) continue;
            st.setInt(ndx++, joinPD.getClassId());
        }
        return ndx;
    }

    public T select(long id) {
        return this.select(id, false);
    }

    public T reload() {
        return (T)Pdo.create(this.getPdo()).select(this.getId());
    }

    public T reloadForUpdate() {
        return (T)Pdo.create(this.getPdo()).selectForUpdate(this.getId());
    }

    public T selectForUpdate(long id) {
        return this.select(id, true);
    }

    public T derivePdoFromPo(T pdo, P po) {
        T derivedPdo;
        if (po == pdo.getPersistenceDelegate()) {
            derivedPdo = pdo;
        } else if (pdo.isAbstract()) {
            derivedPdo = ((AbstractPersistentObject)po).getPdo();
        } else {
            throw new PersistenceException((Identifiable)this, "misconfigured PDO inheritance");
        }
        DomainContext context = this.getDomainContext();
        if (((AbstractPersistentObject)po).isRootEntity()) {
            po.setSessionHolder((SessionHolder)context.getRootContext(derivedPdo));
            if (!((AbstractPersistentObject)po).isReadAllowed()) {
                return null;
            }
        } else if (((AbstractPersistentObject)po).getRootId() != 0L && ((AbstractPersistentObject)po).getRootId() != context.getRootId() || ((AbstractPersistentObject)po).getRootClassId() != 0 && ((AbstractPersistentObject)po).getRootClassId() != context.getRootClassId()) {
            po.setFinallyImmutable();
            if (((AbstractPersistentObject)po).getRootId() != 0L && ((AbstractPersistentObject)po).getRootClassId() != 0) {
                SecurityResult sr = SecurityFactory.getInstance().getSecurityManager().evaluate(context, (Permission)SecurityFactory.getInstance().getReadPermission(), ((AbstractPersistentObject)po).getRootClassId(), ((AbstractPersistentObject)po).getRootId());
                if (sr.isAccepted()) {
                    return derivedPdo;
                }
                return null;
            }
            throw new SecurityException(po, "unexpected root context " + context.getRootClassId() + "[" + context.getRootId() + "], expected " + ((AbstractPersistentObject)po).getRootClassId() + "[" + ((AbstractPersistentObject)po).getRootId() + "]");
        }
        return derivedPdo;
    }

    public void assertRootContextIsAccepted() {
        SecurityResult result;
        DomainContext context = this.getDomainContext();
        if (context.isRootContext() && !(result = SecurityFactory.getInstance().getSecurityManager().evaluate(context, (Permission)SecurityFactory.getInstance().getReadPermission(), context.getRootClassId(), context.getRootId())).isAccepted()) {
            throw new SecurityException((Identifiable)this, result.explain("no read permission for root-entity " + context.getRootClassId() + "[" + context.getRootId() + "]"));
        }
    }

    public StringBuilder createSelectAllInnerSql() {
        StringBuilder sql = new StringBuilder();
        String alias = this.getTableAlias();
        sql.append(alias).append('.').append("*").append(" FROM ").append(this.getTableName()).append(this.getBackend().sqlAsBeforeTableAlias()).append(alias).append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSelectAllIdSerialInnerSql() {
        StringBuilder sql = new StringBuilder();
        String alias = this.getTopSuperTableAlias();
        sql.append(alias).append('.').append("id").append(",").append(alias).append('.').append("serial").append(" FROM ").append(this.getTableName()).append(this.getBackend().sqlAsBeforeTableAlias()).append(alias).append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSelectAllByIdInnerSql() {
        StringBuilder sql = this.createSelectAllInnerSql();
        sql.append(" AND ").append(this.getTopSuperTableAlias()).append('.').append("id").append("=?");
        return sql;
    }

    public StringBuilder createSelectIdInnerSql(PersistentObjectClassVariables<? super T, ? super P> classVariables, boolean withAlias) {
        StringBuilder sql = new StringBuilder();
        String tName = classVariables.getTableName();
        String tAlias = classVariables.getTableAlias();
        if (withAlias) {
            sql.append(tAlias).append('.');
        }
        sql.append("id").append(" FROM ").append(tName);
        if (withAlias) {
            sql.append(this.getBackend().sqlAsBeforeTableAlias()).append(tAlias);
        }
        sql.append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSelectIdInnerSql(boolean withAlias) {
        return this.createSelectIdInnerSql((PersistentObjectClassVariables<? super T, ? super P>)this.getClassVariables(), withAlias);
    }

    public StringBuilder createSelectIdInnerSql() {
        return this.createSelectIdInnerSql((PersistentObjectClassVariables<? super T, ? super P>)this.getClassVariables(), true);
    }

    public String createSelectByNormTextSql(boolean not) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append((CharSequence)this.createSelectAllInnerSql());
        String condition = this.getSqlClassIdCondition();
        if (condition != null) {
            sql.append(condition);
        }
        if ((condition = this.getSqlContextCondition()) != null) {
            sql.append(condition);
        }
        sql.append(" AND ").append(this.getTopSuperTableAlias()).append('.').append(CN_NORMTEXT);
        if (not) {
            sql.append(" NOT LIKE ?");
        } else {
            sql.append(" LIKE ?");
        }
        String orderSuffix = this.orderBy();
        if (orderSuffix != null) {
            sql.append(" ORDER BY ").append(orderSuffix);
        }
        return sql.toString();
    }

    public String createSelectSerialSql() {
        return "SELECT serial FROM " + this.getTopSuperTableName() + " WHERE id=?";
    }

    public String createSelectMaxIdSql() {
        return "SELECT " + this.getBackend().sqlFunction("MAX", "id") + " FROM " + this.getTopSuperTableName();
    }

    public String createSelectMaxTableSerialSql() {
        return "SELECT " + this.getBackend().sqlFunction("MAX", "tableserial") + " FROM " + this.getTopSuperTableName();
    }

    public String createDummyUpdateSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET id=id WHERE id=?";
    }

    public String createUpdateSerialSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET serial=serial+1 WHERE id=? AND serial=?";
    }

    public String createUpdateSerialAndTableSerialSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET serial=serial+1,tableserial=? WHERE id=? AND serial=?";
    }

    public String createSelectExpiredTableSerials1Sql() {
        return "SELECT id,tableserial FROM " + this.getTopSuperTableName() + " WHERE tableserial>? ORDER BY tableserial,id";
    }

    public String createSelectExpiredTableSerials2Sql() {
        return "SELECT id,tableserial FROM " + this.getTopSuperTableName() + " WHERE tableserial>? AND tableserial<=? ORDER BY tableserial,id";
    }

    public ResultSetWrapper resultByNormText(String text, JoinedSelect<T> js) {
        long contextId;
        NormText nt = new NormText(text);
        if (nt.isMatchingAll()) {
            return this.resultAll(js);
        }
        this.assertRootContextIsAccepted();
        this.assertNormTextProvided();
        this.getSession().assertNotRemote();
        StatementId stmtId = nt.isInverted() ? this.getClassVariables().selectByInvertedNormTextStatementId : this.getClassVariables().selectByNormTextStatementId;
        PreparedStatementWrapper st = this.getPreparedStatement(stmtId, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectByNormTextSql(nt.isInverted()));
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = this.setClassIdsInStatement(js, st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        st.setString(ndx, nt.getPattern());
        return st.executeQuery();
    }

    public ResultSetWrapper resultByNormTextCursor(String text, JoinedSelect<T> js) {
        long contextId;
        NormText nt = new NormText(text);
        if (nt.isMatchingAll()) {
            return this.resultAllCursor(js);
        }
        this.assertRootContextIsAccepted();
        this.assertNormTextProvided();
        this.getSession().assertNotRemote();
        StatementId stmtId = nt.isInverted() ? this.getClassVariables().selectByInvertedNormTextCursorStatementId : this.getClassVariables().selectByNormTextCursorStatementId;
        PreparedStatementWrapper st = this.getPreparedStatement(stmtId, 1004, 1007, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectByNormTextSql(nt.isInverted()));
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
                sql.append(" ORDER BY ").append(this.getColumnName("id"));
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = this.setClassIdsInStatement(js, st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        st.setString(ndx, nt.getPattern());
        return st.executeQuery();
    }

    public List<T> selectByNormText(String text) {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                List list = this.getRemoteDelegate().selectByNormText(context, text);
                this.configureRemoteObjects(context, list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        ArrayList list = new ArrayList();
        try (ResultSetWrapper rs = this.resultByNormText(text, js);){
            this.executeQueryToList(rs, js, list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public ScrollableResource<T> selectByNormTextAsCursor(String text) {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                RemoteResultSetCursor remoteCursor = this.getRemoteDelegate().selectByNormTextAsCursor(context, text);
                return new ResultSetCursor(context, remoteCursor);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        return new ResultSetCursor<T>(this.pdo, this.resultByNormTextCursor(text, js), js);
    }

    public String createSelectAllSql() {
        String orderSuffix;
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append((CharSequence)this.createSelectAllInnerSql());
        String condition = this.getSqlClassIdCondition();
        if (condition != null) {
            sql.append(condition);
        }
        if ((condition = this.getSqlContextCondition()) != null) {
            sql.append(condition);
        }
        if ((orderSuffix = this.orderBy()) != null) {
            sql.append(" ORDER BY ");
            sql.append(orderSuffix);
        }
        return sql.toString();
    }

    public String createSelectAllWithExpiredTableSerialsSql() {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append((CharSequence)this.createSelectAllInnerSql());
        sql.append(" AND ").append("tableserial").append(">?");
        String condition = this.getSqlClassIdCondition();
        if (condition != null) {
            sql.append(condition);
        }
        if ((condition = this.getSqlContextCondition()) != null) {
            sql.append(condition);
        }
        sql.append(" ORDER BY ");
        String orderSuffix = this.orderBy();
        if (orderSuffix != null) {
            sql.append(orderSuffix);
        } else {
            sql.append("tableserial").append(",").append("id");
        }
        return sql.toString();
    }

    public ResultSetWrapper resultAll(JoinedSelect<T> js) {
        long contextId;
        this.getSession().assertNotRemote();
        this.assertRootContextIsAccepted();
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectAllStatementId, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectAllSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = this.setClassIdsInStatement(js, st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx, contextId);
        }
        return st.executeQuery();
    }

    public ResultSetWrapper resultAllWithExpiredTableSerials(JoinedSelect<T> js, long oldSerial) {
        long contextId;
        this.getSession().assertNotRemote();
        this.assertRootContextIsAccepted();
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectAllWithExpiredTableSerialsStatementId, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectAllWithExpiredTableSerialsSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
            }
            return sql.toString();
        });
        st.setLong(1, oldSerial);
        int ndx = 2;
        if (js != null) {
            ndx = this.setClassIdsInStatement(js, st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx, contextId);
        }
        return st.executeQuery();
    }

    public ResultSetWrapper resultAllCursor(JoinedSelect<T> js) {
        long contextId;
        this.getSession().assertNotRemote();
        this.assertRootContextIsAccepted();
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectAllCursorStatementId, 1004, 1007, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectAllSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
                sql.append(" ORDER BY ").append(this.getColumnName("id"));
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = this.setClassIdsInStatement(js, st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx, contextId);
        }
        return st.executeQuery();
    }

    public List<T> selectAll() {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                List list = this.getRemoteDelegate().selectAll(context);
                this.configureRemoteObjects(context, list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        ArrayList list = new ArrayList();
        try (ResultSetWrapper rs = this.resultAll(js);){
            this.executeQueryToList(rs, js, list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public List<T> selectAllWithExpiredTableSerials(long oldSerial) {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                List list = this.getRemoteDelegate().selectAllWithExpiredTableSerials(context, oldSerial);
                this.configureRemoteObjects(context, list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        ArrayList list = new ArrayList();
        try (ResultSetWrapper rs = this.resultAllWithExpiredTableSerials(js, oldSerial);){
            this.executeQueryToList(rs, js, list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public ScrollableResource<T> selectAllAsCursor() {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                return new ResultSetCursor(context, this.getRemoteDelegate().selectAllAsCursor(context));
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        return new ResultSetCursor<T>(this.pdo, this.resultAllCursor(js), js);
    }

    public PdoCache<T> getCache() {
        return null;
    }

    public boolean expireCache(long maxSerial) {
        return false;
    }

    public T selectCached(long id) {
        return this.select(id);
    }

    public T selectCachedOnly(long id) {
        return this.select(id);
    }

    public List<T> selectAllCached() {
        return this.selectAll();
    }

    public List<T> selectAllForCache() {
        List<T> list;
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                list = this.getRemoteDelegate().selectAllForCache(context);
                this.configureRemoteObjects(context, list);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            list = this.selectAll();
        }
        return list;
    }

    public T selectForCache(long id) {
        T obj;
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                obj = this.getRemoteDelegate().selectForCache(context, id);
                this.configureRemoteObject(context, obj);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            obj = this.select(id);
        }
        return obj;
    }

    public long countModification() {
        long tableSerial = super.countModification();
        if (tableSerial >= 0L) {
            this.expireCache(tableSerial);
        }
        return tableSerial;
    }

    public <R extends PersistentDomainObject<R>> boolean addReferencingClass(Class<R> clazz, String methodName) {
        return this.getClassVariables().addReferencingClass(this.getPersistenceClass(clazz), methodName);
    }

    public <R extends PersistentDomainObject<R>> boolean removeReferencingClass(Class<R> clazz, String methodName) {
        return this.getClassVariables().removeReferencingClass(this.getPersistenceClass(clazz), methodName);
    }

    public <R extends PersistentDomainObject<R>> Class<? extends AbstractPersistentObject<?, ?>> getPersistenceClass(Class<R> clazz) {
        Class<?> persistenceClass = Pdo.create(clazz).getPersistenceDelegate().getClass();
        if (AbstractPersistentObject.class.isAssignableFrom(persistenceClass)) {
            return persistenceClass;
        }
        throw new PersistenceException((Identifiable)this, "persistence class not compatible: " + persistenceClass);
    }

    public boolean isReferenced() {
        if (this.getSession().isRemote()) {
            if (this.isNew()) {
                return false;
            }
            try {
                return this.getRemoteDelegate().isReferenced(this.getDomainContext(), this.getId());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return super.isReferenced();
    }

    public boolean containsPattern(String pattern) {
        return this.getNormText() != null && pattern != null && this.getNormText().contains(pattern);
    }

    public String orderBy() {
        return null;
    }

    protected void initModification(char modType) {
        super.initModification(modType);
        this.clearTokenLock();
    }

    protected void finishModification(char modType) {
        super.finishModification(modType);
        this.setRenewTokenLockRequested(false);
    }

    protected void finishNotUpdated(char modType) {
        if (this.isTokenLockProvided()) {
            if (this.clearTokenLock()) {
                this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()), this.getContextUserId(), this.getEditedSince());
            } else {
                this.updateTokenLock(null);
            }
            this.setRenewTokenLockRequested(false);
        }
    }

    public long getContextUserId() {
        long userId = this.getDomainContext().getSessionInfo().getUserId();
        if (userId == 0L) {
            throw new PersistenceException((Identifiable)this, "userId is 0");
        }
        return userId;
    }

    public boolean clearTokenLock() {
        if (this.isTokenLockProvided()) {
            if (this.isRenewTokenLockRequested()) {
                long userId = this.getContextUserId();
                this.setEditedExpiry(DateHelper.now((long)this.getTokenLockTimeout()));
                if (this.getEditedSince() == null || userId != this.getEditedBy() || this.getEditedExpiry() == null) {
                    this.setEditedSince(DateHelper.now());
                }
                this.setEditedBy(userId);
                return true;
            }
            this.setEditedBy(0L);
            this.setEditedExpiry(null);
        }
        return false;
    }

    public void setRenewTokenLockRequested(boolean renewTokenLock) {
        if (renewTokenLock && !this.isTokenLockableByMe()) {
            throw new LockException((Session)this.getSession(), new TokenLockInfo(this.getEditedBy(), this.getEditedSince(), this.getEditedExpiry()));
        }
        this.renewTokenLock = renewTokenLock;
    }

    public boolean isRenewTokenLockRequested() {
        return this.renewTokenLock;
    }

    protected boolean isUpdateNecessary() {
        return super.isUpdateNecessary() || this.getEditedBy() != 0L || this.isRenewTokenLockRequested();
    }

    public void updateObject() {
        this.updateNormText();
        super.updateObject();
        if (this.isTokenLockProvided()) {
            LockManager.getInstance().update(this.pdo);
        }
    }

    public void insertObject() {
        this.updateNormText();
        super.insertObject();
        if (this.isTokenLockProvided()) {
            LockManager.getInstance().update(this.pdo);
        }
    }

    public void deleteObject() {
        super.deleteObject();
        if (this.isTokenLockProvided()) {
            LockManager.getInstance().update(this.pdo);
        }
    }

    public void newId() {
        super.newId();
        if (!this.isRootEntity()) {
            DomainContext context = this.getDomainContext();
            if (this.isRootIdProvided()) {
                this.setRootId(context.getRootId());
            }
            if (this.isRootClassIdProvided()) {
                this.setRootClassId(context.getRootClassId());
            }
        }
    }

    public boolean updateRootContext() {
        if (this.isRootEntity()) {
            DomainContext context = this.getDomainContext();
            context.getRootContext(this.pdo);
            return true;
        }
        return false;
    }

    public void configureRemoteObject(DomainContext context, T obj) {
        if (obj != null) {
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            if (po.isRootEntity()) {
                po.setSession(context.getSession());
                po.setSessionHolder((SessionHolder)po.getDomainContext().getRootContext(obj));
            } else {
                DomainContext poContext = po.getDomainContext();
                if (poContext.getRootId() == context.getRootId() && poContext.getRootClassId() == context.getRootClassId()) {
                    po.setDomainContext(context);
                }
            }
            po.validated = true;
        }
    }

    public void configureRemoteObjects(DomainContext context, Collection<T> objects) {
        if (objects != null) {
            for (PersistentDomainObject obj : objects) {
                this.configureRemoteObject(context, obj);
            }
        }
    }

    protected void assertRootContext() {
        if (!this.getDomainContext().isRootContext()) {
            throw new PersistenceException((Identifiable)this, "unexpected non-root domain context");
        }
    }

    protected <X extends PersistentDomainObject<X>> void markDeleted(Collection<X> pdos) {
        if (pdos != null) {
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isNew()) continue;
                po.markDeleted();
            }
        }
    }

    protected void markDeleted(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).markDeleted();
        }
    }

    protected <X extends PersistentDomainObject<X>> void delete(Collection<X> pdos) {
        if (pdos != null) {
            Db session = null;
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isVirgin()) continue;
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PdoRuntimeException(pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PdoRuntimeException(pDo, "unexpected session: " + po.getSession() + ", expected: " + (Session)session);
                }
                po.deleteImpl();
            }
            if (pdos instanceof TrackedList) {
                ((TrackedList)pdos).setModified(false);
            }
        }
    }

    protected void delete(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).deleteImpl();
        }
    }

    protected <X extends PersistentDomainObject<X>> void deleteMissingInCollection(Collection<X> oldCollection, Collection<X> newCollection) {
        if (oldCollection != null && !oldCollection.isEmpty()) {
            Db session = null;
            for (PersistentDomainObject pDo : oldCollection) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isVirgin() || newCollection != null && newCollection.contains(pDo)) continue;
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PersistenceException((Identifiable)pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PersistenceException((Identifiable)pDo, "unexpected session: " + po.getSession() + ", expected: " + (Session)session);
                }
                po.deleteImpl();
            }
        }
    }

    public void assertRootEntity() {
        if (!this.isRootEntity()) {
            throw new PersistenceException((Identifiable)this, "not a root-entity");
        }
    }

    public void delete() {
        this.assertRootEntity();
        if (!this.getSession().isRemote()) {
            this.assertWritePermission();
        }
        this.deleteImpl();
    }

    protected void deleteImpl() {
        this.snapshots = null;
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            try {
                this.prepareDelete();
                this.getRemoteDelegate().deleteImpl(this.pdo);
                this.setPersistable(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.deleteObject();
        }
    }

    public void save() {
        this.assertRootEntity();
        if (!this.getSession().isRemote()) {
            this.assertWritePermission();
        }
        this.saveImpl();
    }

    protected void saveImpl() {
        this.snapshots = null;
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            this.clearOnRemoteSave();
            this.prepareSave();
            try {
                this.getRemoteDelegate().saveImpl(this.pdo);
                this.setPersistable(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            if (!this.isValidated()) {
                this.validate();
            }
            super.saveObject();
        }
    }

    public static <X extends PersistentDomainObject<X>> void save(Collection<X> pdos, boolean modifiedOnly) {
        if (pdos != null) {
            Db session = null;
            for (PersistentDomainObject pDo : pdos) {
                if (pDo == null) continue;
                AbstractPersistentObject po = (AbstractPersistentObject)pDo.getPersistenceDelegate();
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PdoRuntimeException(pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PdoRuntimeException(pDo, "unexpected session: " + po.getSession() + ", expected: " + (Session)session);
                }
                if (po.isPersistable()) {
                    if (modifiedOnly && !po.isModified()) continue;
                    po.saveImpl();
                    continue;
                }
                if (po.isNew()) continue;
                po.deleteImpl();
            }
            if (pdos instanceof TrackedList) {
                ((TrackedList)pdos).setModified(false);
            }
        }
    }

    public static void save(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).saveImpl();
        }
    }

    public T persist() {
        this.assertRootEntity();
        if (!this.getSession().isRemote()) {
            this.assertWritePermission();
        }
        return this.persistImpl();
    }

    public T persistTokenLocked() {
        this.setRenewTokenLockRequested(true);
        return this.persist();
    }

    protected T persistImpl() {
        this.snapshots = null;
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            this.clearOnRemoteSave();
            this.prepareSave();
            try {
                T persistedPdo = this.getRemoteDelegate().persistImpl(this.pdo);
                this.configureRemoteObject(this.getDomainContext(), persistedPdo);
                return persistedPdo;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (!this.isValidated()) {
            this.validate();
        }
        if (super.persistObject() != this) {
            throw new PersistenceException((Identifiable)this, "local persist does not return same object");
        }
        return this.pdo;
    }

    public boolean isUpdatingSerialEvenIfNotModified() {
        return this.isRootEntity();
    }

    protected <X extends PersistentDomainObject<X>> boolean isModified(Collection<X> pdos) {
        if (pdos instanceof TrackedList && ((TrackedList)pdos).isModified()) {
            return true;
        }
        if (pdos != null) {
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || !(po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTokenLockProvided() {
        return false;
    }

    protected void assertTokenLockProvided() {
        if (!this.isTokenLockProvided()) {
            throw new PersistenceException((Identifiable)this, "entity does not provide the edited-token columns");
        }
    }

    public long getTokenLockTimeout() {
        return this.isTokenLockProvided() ? 3600000L : 0L;
    }

    public String createUpdateTokenLockSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET editedby=?,editedsince=?,editedexpiry=? WHERE id=? AND  (editedby=? OR editedby=0 OR editedexpiry<? OR editedexpiry IS NULL) ";
    }

    public String createUpdateTokenLockWithCountSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET serial=serial+1,tableserial=?,editedby=?,editedsince=?,editedexpiry=? WHERE id=? AND  (editedby=? OR editedby=0 OR editedexpiry<? OR editedexpiry IS NULL) ";
    }

    public String createUpdateTokenLockOnlySql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET editedby=?,editedsince=?,editedexpiry=? WHERE id=?";
    }

    public String createSelectTokenLockSql() {
        this.assertTokenLockProvided();
        return "SELECT editedby,editedsince,editedexpiry FROM " + this.getTopSuperTableName() + " WHERE id=?";
    }

    public String createTransferTokenLockSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET serial=serial+1,editedby=? WHERE id=? AND serial=?";
    }

    public String createTransferTokenLockWithTableSerialSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET serial=serial+1,editedby=?,tableserial=? WHERE id=? AND serial=?";
    }

    public long getEditedBy() {
        return this.editedBy;
    }

    public void setEditedBy(long editedBy) {
        this.editedBy = editedBy;
    }

    public void requestTokenLock() {
        this.getSession().transaction("lock", () -> {
            this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()));
            return null;
        });
    }

    public void releaseTokenLock() {
        this.getSession().transaction("unlock", () -> {
            this.updateTokenLock(null);
            return null;
        });
    }

    public boolean isTokenLocked() {
        this.assertTokenLockProvided();
        return !this.isNew() && this.getEditedBy() != 0L && DateHelper.toMillis((Date)this.getEditedExpiry()) > System.currentTimeMillis();
    }

    public boolean isTokenLockedBy(long userId) {
        return this.isTokenLocked() && this.getEditedBy() == userId;
    }

    public boolean isTokenLockedByMe() {
        return this.isTokenLockedBy(this.getContextUserId());
    }

    public boolean isTokenLockableByMe() {
        return !this.isTokenLocked() || this.getEditedBy() == this.getContextUserId();
    }

    public org.tentackle.common.Timestamp getEditedSince() {
        return this.editedSince;
    }

    public void setEditedSince(org.tentackle.common.Timestamp editedSince) {
        this.editedSince = editedSince;
    }

    public org.tentackle.common.Timestamp getEditedExpiry() {
        return this.editedExpiry;
    }

    public void setEditedExpiry(org.tentackle.common.Timestamp editedExpiry) {
        this.editedExpiry = editedExpiry;
    }

    public <U extends PersistentDomainObject<U>> U getTokenLockObject() {
        AbstractApplication application = AbstractApplication.getRunningApplication();
        return (U)(application == null ? null : application.getUser(this.getDomainContext(), this.getEditedBy()));
    }

    public <U extends PersistentDomainObject<U>> void setTokenLockObject(U obj) {
        this.setEditedBy(obj == null ? 0L : obj.getPersistenceDelegate().getId());
    }

    public boolean isCountingModificationForTokenLock() {
        return false;
    }

    public void updateTokenLock(org.tentackle.common.Timestamp tokenExpiry, long userId, org.tentackle.common.Timestamp curTime) {
        block15: {
            Db db = this.getSession();
            if (db.isRemote()) {
                try {
                    TokenLockInfo token = this.getRemoteDelegate().updateTokenLock(this.getId(), tokenExpiry, userId, curTime);
                    token.applyTo((PersistentObject)this);
                }
                catch (RemoteException e) {
                    LockException lx;
                    TokenLockInfo token;
                    RuntimeException rex = PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
                    if (rex instanceof LockException && (token = (lx = (LockException)rex).getTokenLockInfo()) != null) {
                        token.applyTo((PersistentObject)this);
                    }
                    throw rex;
                }
            }
            this.assertTokenLockProvided();
            this.assertNotCached();
            this.assertPersistable();
            this.assertRootEntity();
            this.assertWritePermission();
            if (db.isPersistenceOperationAllowed((AbstractDbObject)this, 'U')) {
                long txVoucher = db.begin(TX_UPDATE_TOKENLOCK);
                try {
                    PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().updateTokenLockStatementId, this::createUpdateTokenLockSql);
                    long newUser = tokenExpiry != null ? userId : 0L;
                    st.setLong(1, newUser);
                    st.setTimestamp(2, (Timestamp)curTime);
                    st.setTimestamp(3, (Timestamp)tokenExpiry);
                    st.setLong(4, this.getId());
                    st.setLong(5, userId);
                    st.setTimestamp(6, (Timestamp)curTime);
                    if (st.executeUpdate() == 1) {
                        this.setEditedBy(newUser);
                        this.setEditedSince(curTime);
                        this.setEditedExpiry(tokenExpiry);
                        LockManager.getInstance().update(this.pdo);
                        db.commit(txVoucher);
                        break block15;
                    }
                    st = this.getPreparedStatement(this.getClassVariables().selectTokenLockStatementId, this::createSelectTokenLockSql);
                    st.setLong(1, this.getId());
                    ResultSetWrapper rs = st.executeQuery();
                    try {
                        if (rs.next()) {
                            this.setEditedBy(rs.getLong(CN_EDITEDBY));
                            this.setEditedSince(rs.getTimestamp(CN_EDITEDSINCE));
                            this.setEditedExpiry(rs.getTimestamp(CN_EDITEDEXPIRY));
                            throw new LockException((Session)db, new TokenLockInfo(this.getEditedBy(), this.getEditedSince(), this.getEditedExpiry()));
                        }
                        throw new NotFoundException((Identifiable)this, "could not retrieve token lock", -1L);
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (PersistenceException px) {
                    this.setPersistable(false);
                    db.rollback(txVoucher);
                    px.updateDbObject((Identifiable)this);
                    throw px;
                }
                catch (RuntimeException ex) {
                    this.setPersistable(false);
                    db.rollback(txVoucher);
                    throw new PersistenceException((Identifiable)this, (Throwable)ex);
                }
            }
        }
    }

    public void updateTokenLock(org.tentackle.common.Timestamp tokenExpiry) {
        this.updateTokenLock(tokenExpiry, this.getDomainContext().getSessionInfo().getUserId(), DateHelper.now());
    }

    public void updateTokenLockOnly() {
        Db db = this.getSession();
        if (db.isRemote()) {
            try {
                this.getRemoteDelegate().updateTokenLockOnly(this.getId(), this.getEditedBy(), this.getEditedSince(), this.getEditedExpiry());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertNotCached();
        this.assertPersistable();
        this.assertRootEntity();
        this.assertWritePermission();
        long txVoucher = db.begin(TX_UPDATE_TOKENLOCK);
        try {
            if (db.isPersistenceOperationAllowed((AbstractDbObject)this, 'U')) {
                PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().updateTokenLockOnlyStatementId, this::createUpdateTokenLockOnlySql);
                st.setLong(1, this.getEditedBy());
                st.setTimestamp(2, (Timestamp)this.getEditedSince());
                st.setTimestamp(3, (Timestamp)this.getEditedExpiry());
                st.setLong(4, this.getId());
                this.assertThisRowAffected(st.executeUpdate());
                LockManager.getInstance().update(this.pdo);
                db.commit(txVoucher);
            }
        }
        catch (PersistenceException px) {
            this.setPersistable(false);
            db.rollback(txVoucher);
            px.updateDbObject((Identifiable)this);
            throw px;
        }
        catch (RuntimeException ex) {
            this.setPersistable(false);
            db.rollback(txVoucher);
            throw new PersistenceException((Identifiable)this, (Throwable)ex);
        }
    }

    public T transferTokenLock(long userId) {
        Db db = this.getSession();
        if (db.isRemote()) {
            try {
                T tPdo = this.getRemoteDelegate().transferTokenLock(this.pdo, userId);
                this.configureRemoteObject(this.getDomainContext(), tPdo);
                return tPdo;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertNotCached();
        this.assertPersistable();
        this.assertRootEntity();
        this.assertWritePermission();
        if (db.isPersistenceOperationAllowed((AbstractDbObject)this, 'U')) {
            long txVoucher = db.begin(TX_TRANSFER_TOKENLOCK);
            try {
                boolean withTableSerial = this.isTableSerialProvided();
                PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().transferTokenLockStatementId, () -> withTableSerial ? this.createTransferTokenLockWithTableSerialSql() : this.createTransferTokenLockSql());
                long newTableSerial = this.countModification();
                if (withTableSerial) {
                    this.setTableSerial(newTableSerial);
                }
                int ndx = 0;
                st.setLong(++ndx, userId);
                this.setEditedBy(userId);
                if (withTableSerial) {
                    st.setLong(++ndx, this.getTableSerial());
                }
                st.setLong(++ndx, this.getId());
                st.setLong(++ndx, this.getSerial());
                this.assertThisRowAffected(st.executeUpdate());
                this.setSerial(this.getSerial() + 1L);
                if (userId != 0L) {
                    this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()), userId, DateHelper.now());
                }
                LockManager.getInstance().update(this.pdo);
                db.commit(txVoucher);
            }
            catch (PersistenceException px) {
                this.setPersistable(false);
                db.rollback(txVoucher);
                px.updateDbObject((Identifiable)this);
                throw px;
            }
            catch (RuntimeException ex) {
                this.setPersistable(false);
                db.rollback(txVoucher);
                throw new PersistenceException((Identifiable)this, (Throwable)ex);
            }
        }
        return this.pdo;
    }

    public Object getTransientData() {
        return null;
    }

    public void setTransientData(Object data) {
    }

    public AbstractPersistentObjectRemoteDelegate<T, P> getRemoteDelegate() {
        return (AbstractPersistentObjectRemoteDelegate)super.getRemoteDelegate();
    }

    public Class<? extends ValidationScope>[] getDefaultScopes() {
        return new Class[]{PersistenceScope.class, MandatoryScope.class, ChangeableScope.class};
    }

    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        return ValidationUtilities.getInstance().validate(this.getPdo(), validationPath, scope);
    }

    public void validate() {
        this.validated = false;
        String validationPath = ValidationUtilities.getInstance().getDefaultValidationPath(this.pdo);
        List<ValidationResult> results = this.validate(validationPath, (ValidationScope)ValidationScopeFactory.getInstance().getPersistenceScope());
        if (ValidationUtilities.getInstance().hasFailed(results)) {
            throw new ValidationFailedException("validation of " + this.pdo.toGenericString() + " as " + validationPath + " failed:\n" + ValidationUtilities.getInstance().resultsToString(results), results);
        }
        this.validated = true;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        this.validated = !modified;
    }

    public boolean isReadAllowed() {
        return this.getClassVariables().isReadAllowed(this);
    }

    public boolean isWriteAllowed() {
        return this.getClassVariables().isWriteAllowed(this);
    }

    public boolean isViewAllowed() {
        return this.getClassVariables().isViewAllowed(this);
    }

    public boolean isEditAllowed() {
        return this.getClassVariables().isEditAllowed(this);
    }

    protected void assertWritePermission() {
        if (!this.isWriteAllowed()) {
            throw new SecurityException((Identifiable)this, "no write permission");
        }
    }

    protected void assertReadPermission() {
        if (!this.isReadAllowed()) {
            throw new SecurityException((Identifiable)this, "no read permission");
        }
    }
}

