/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.app;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.dbms.ConnectionManager;
import org.tentackle.dbms.ConnectionManagerProvider;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DefaultDbPool;
import org.tentackle.dbms.MpxConnectionManager;
import org.tentackle.log.Logger;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolProvider;

public abstract class AbstractServerApplication
extends AbstractApplication
implements SessionPoolProvider,
ConnectionManagerProvider {
    private static final Logger LOGGER = Logger.get(AbstractServerApplication.class);
    private SessionPool sessionPool;
    private ConnectionManager connectionManager;
    private boolean runsInContainer;

    public AbstractServerApplication(String name) {
        super(name);
        this.detectContainer();
    }

    public SessionPool getSessionPool() {
        return this.sessionPool;
    }

    protected boolean isServerImpl() {
        return true;
    }

    protected void setSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            throw new IllegalArgumentException("session info must not be null");
        }
        if (this.getSessionInfo() != null) {
            throw new PersistenceException("session info already set, cannot be changed in a running server");
        }
        sessionInfo.setImmutable(true);
        super.setSessionInfo(sessionInfo);
    }

    protected void configurePreferences() {
        super.configurePreferences();
        PersistedPreferencesFactory.getInstance().setSystemOnly(true);
    }

    protected void finishStartup() {
        super.finishStartup();
        this.connectionManager = this.createConnectionManager();
        this.sessionPool = this.createSessionPool();
    }

    public SessionPool createSessionPool() {
        return new DefaultDbPool(this.getConnectionManager(), this.getSessionInfo()){

            public Db getSession() {
                Db db = super.getSession();
                SessionInfo sessionInfo = this.getSessionInfo().clone();
                db.setSessionInfo(sessionInfo);
                sessionInfo.setUserId(0L);
                sessionInfo.setUserClassId(0);
                sessionInfo.setUserName(null);
                return db;
            }
        };
    }

    public Db getSession() {
        return (Db)super.getSession();
    }

    protected ConnectionManager createConnectionManager() {
        return new MpxConnectionManager(this.getSession().getBackendInfo(), this.getSession().getSessionId() + 1);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected void configureSessionInfo(SessionInfo sessionInfo) {
        Properties sessionProps = null;
        try {
            sessionProps = sessionInfo.getProperties();
        }
        catch (PersistenceException e1) {
            sessionInfo.setProperties(this.getProperties());
        }
        if (sessionProps != null) {
            for (String key : this.getProperties().stringPropertyNames()) {
                sessionProps.setProperty(key, this.getProperties().getProperty(key));
            }
            sessionInfo.setProperties(sessionProps);
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)this)).getClass()));
        }
        sessionInfo.applyProperties();
    }

    protected void startup() {
        LOGGER.fine("register application server");
        this.register();
        LOGGER.fine("initialize application server");
        this.initialize();
        LOGGER.fine("login to backend");
        this.login();
        LOGGER.fine("configure application server");
        this.configure();
        LOGGER.fine("finish startup");
        this.finishStartup();
    }

    protected void login() {
        String username = this.getProperty("user");
        char[] password = StringHelper.toCharArray((String)this.getProperty("password"));
        String sessionPropsName = this.getProperty("backend");
        SessionInfo sessionInfo = this.createSessionInfo(username, password, sessionPropsName);
        this.configureSessionInfo(sessionInfo);
        Db serverDb = (Db)this.createSession(sessionInfo);
        serverDb.makeCurrent();
        this.setSessionInfo(sessionInfo);
        this.setDomainContext(this.createDomainContext((Session)serverDb));
    }

    protected void cleanup() {
        super.cleanup();
        if (this.sessionPool != null) {
            this.sessionPool.shutdown();
            this.sessionPool = null;
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        if (this.isRunningInContainer()) {
            this.deregisterJdbcDrivers(Thread.currentThread().getContextClassLoader());
        }
    }

    public boolean isRunningInContainer() {
        return this.runsInContainer;
    }

    protected boolean isSystemExitNecessaryToStop() {
        return !this.isRunningInContainer();
    }

    protected void detectContainer() {
        this.runsInContainer = false;
        try {
            new InitialContext().lookup("java:comp/env");
            this.runsInContainer = true;
            LOGGER.info("container detected");
        }
        catch (NamingException ex) {
            LOGGER.info("not running within a container");
        }
    }

    protected void deregisterJdbcDrivers(ClassLoader cl) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() == cl) {
                try {
                    LOGGER.info("deregistering JDBC driver {0}", new Object[]{driver});
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException sx) {
                    LOGGER.severe("failed to deregister JDBC driver {0}", new Object[]{driver, sx});
                }
                continue;
            }
            LOGGER.fine("JDBC driver {0} skipped because it does not belong to this app's ClassLoader", new Object[]{driver});
        }
    }
}

