/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.common.PathFactory;
import org.tentackle.model.Relation;
import org.tentackle.persist.wurblet.Join;
import org.tentackle.persist.wurblet.JoinPath;
import org.tentackle.persist.wurblet.WurbletArgument;

public class JoinPathFactory
implements PathFactory<JoinPath, Join> {
    public JoinPath create(List<Join> elements, List<JoinPath> paths) {
        return new JoinPath(elements, paths);
    }

    public JoinPath create(List<Join> elements, JoinPath path) {
        ArrayList<Join> allElements = new ArrayList<Join>(elements);
        allElements.addAll(path.getElements());
        return new JoinPath(allElements, path.getPaths());
    }

    public List<JoinPath> createPaths(List<WurbletArgument> arguments) {
        List<JoinPath> paths = new ArrayList();
        for (WurbletArgument argument : arguments) {
            if (!argument.isPath()) continue;
            ArrayList<Join> joins = new ArrayList<Join>();
            for (Relation relation : argument.getRelations()) {
                joins.add(new Join(relation));
            }
            paths.add(new JoinPath(joins, null));
        }
        paths = this.merge(paths);
        int index = 1;
        for (JoinPath path : paths) {
            this.namePath("j_" + index++, path);
        }
        return paths;
    }

    private void namePath(String prefix, JoinPath path) {
        int index = 1;
        String lastPrefix = prefix;
        if (path.getElements().size() == 1) {
            path.getElements().get(0).setName(prefix);
        } else {
            for (Join join : path.getElements()) {
                lastPrefix = prefix + "_" + index++;
                join.setName(lastPrefix);
            }
        }
        index = 1;
        for (JoinPath subPath : path.getPaths()) {
            this.namePath(lastPrefix + "_" + index++, subPath);
        }
    }
}

