// wurblet generated by Wurbelizer 8.2.2.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for related entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoRelations
 *     [--loadcomponents|--noloadcomponents]
 *     [--insertcomponents|--noinsertcomponents]
 *     [--deletecomponents|--nodeletecomponents]
 *     [--nori] [--noselects] [--nodeletes]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--loadcomponents|--noloadcomponents:</em> force (no) generation of loadComponents().</li>
 * <li><em>--insertcomponents|--noinsertcomponents:</em> force (no) generation of insertPlainWithComponents().</li>
 * <li><em>--deletecomponents|--nodeletecomponents:</em> force (no) generation of deletePlainWithComponents().</li>
 * <li><em>--nori:</em> don't generate PdoIsReferencing wurblet anchors and addReferencingClass() invocations.</li>
 * <li><em>--noselects:</em> don't generate PdoSelect... wurblet anchors.</li>
 * <li><em>--nodeletes:</em> don't generate PdoDelete... wurblet anchors.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoRelations extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();

    String pdoName = null;
    try {
      // in implementation
      pdoName = getPdoClassName();
    }
    catch (WurbelException we) {
      // in interface
      pdoName = getClassName();
    }

    boolean generateDeclarations                    = false;
    boolean generateIsModified                      = false;
    boolean generateIsComposite                     = false;
    boolean generateSaveReferencingRelations        = false;
    boolean generateSaveReferencedRelations         = false;
    boolean generateDeleteReferencingRelations      = false;
    boolean generateDeleteReferencedRelations       = false;
    boolean generateLazyDeleteReferencingRelations  = false;
    boolean generateLazyDeleteReferencedRelations   = false;
    boolean generateSetSession                      = false;
    Boolean generateLoadComponents                  = null;
    Boolean generateInsertComponents                = null;
    Boolean generateDeleteComponents                = null;
    boolean generateMarkDeleted                     = false;
    boolean generateIsReferencing                   = true;
    boolean generateAddReferencing                  = false;
    boolean generateSelects                         = true;
    boolean generateDeletes                         = true;
    boolean generateValidate                        = false;
    boolean generateSetImmutable                    = false;
    boolean generateSnapshot                        = false;
    boolean generateClearOnRemoteSave               = false;
    boolean generateAlignComponents                 = false;

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
        generateAddReferencing = true;
        break;
      }
    }

    for (String arg: getOptionArgs())  {
      if (arg.equals("noloadcomponents")) {
        generateLoadComponents = false;
      }
      else if (arg.equals("noinsertcomponents")) {
        generateInsertComponents = false;
      }
      else if (arg.equals("nodeletecomponents")) {
        generateDeleteComponents = false;
      }
      else if (arg.equals("loadcomponents")) {
        generateLoadComponents = true;
      }
      else if (arg.equals("insertcomponents")) {
        generateInsertComponents = true;
      }
      else if (arg.equals("deletecomponents")) {
        generateDeleteComponents = true;
      }
      else if (arg.equals("nori")) {
        generateIsReferencing = false;
        generateAddReferencing = false;
      }
      else if (arg.equals("noselects")) {
        generateSelects = false;
      }
      else if (arg.equals("nodeletes")) {
        generateDeletes = false;
      }
    }

    // check which methods need generation
    for (Relation rel: getEntity().getRelations()) {
      if (rel.getSelectionType() == SelectionType.LAZY ||
          rel.getSelectionType() == SelectionType.EAGER)  {
        generateDeclarations = true;
        if (!rel.isSelectionCached()) {
          generateSetSession = true;
        }
      }
      if (rel.isComposite()) {
        generateIsComposite         = true;
        generateDeclarations        = true;
        generateIsModified          = true;
        generateSetSession          = true;
        generateMarkDeleted         = true;
        generateValidate            = true;
        generateSnapshot            = true;
        generateSetImmutable        = true;

        if (rel.getRelationType() == RelationType.OBJECT) {
          generateSaveReferencedRelations = true;
          generateDeleteReferencedRelations = true;
          generateLazyDeleteReferencedRelations = true;
        }
        else  { // LIST
          generateSaveReferencingRelations = true;
          generateDeleteReferencingRelations = true;
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            generateLazyDeleteReferencingRelations = true;
            if (rel.getCountAttribute() != null) {
              generateAlignComponents = true;
            }
          }
        }
      }
      if (rel.isClearOnRemoteSave()) {
        generateClearOnRemoteSave = true;
      }
    }

    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    if (generateLoadComponents == null) {
      generateLoadComponents = generateIsComposite;
    }
    if (generateInsertComponents == null) {
      generateInsertComponents = generateIsComposite;
    }
    if (generateDeleteComponents == null) {
      generateDeleteComponents = generateIsComposite && (!useDatabaseRefInt || getEntity().isRootEntity());
    }


    // dump what we read from source
    out.print(source[0]); // 157:2 = "  /**   * # Relations for "
    out.print(pdoName);
    out.print(source[1]); // 159:32 = ":   *"
    for (Relation rel: getEntity().getRelations()) {
      out.print(source[2]); // 163:2 = "   * "
      out.print(rel);
      out.print(source[3]); // 164:12 = ""
    }
    out.print(source[4]); // 167:2 = "   */"

    if (generateDeclarations) {
      // declarations
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite())  {
          String type = rel.getDeclaredJavaType(false);
          String transientModifier = isRelationTransient(rel) ? "transient " : "";
          out.print(source[5]); // 177:2 = "  // "
          out.print(rel);
          out.print(source[6]); // 179:12 = ""
          if (rel.isComposite()) {
            out.print(source[7]); // 182:2 = "  @Persistent("
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[8]); // 183:64 = ")"
          }
          out.print(source[9]); // 186:2 = "  private "
          out.print(transientModifier);
          out.print(type);
          out.print(source[10]); // 187:39 = " "
          out.print(rel.getVariableName());
          out.print(source[11]); // 187:65 = ";"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[12]); // 190:2 = "  private "
            out.print(transientModifier);
            out.print(source[13]); // 191:31 = "boolean "
            out.print(rel.getVariableName());
            out.print(source[14]); // 191:64 = "Loaded;"
          }
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
              out.print(source[15]); // 196:2 = "  private transient "
              out.print(type);
              out.print(source[16]); // 197:28 = " "
              out.print(rel.getVariableName());
              out.print(source[17]); // 197:54 = "Snapshot;"
            }
            if (rel.getRelationType() == RelationType.OBJECT) {
              out.print(source[18]); // 201:2 = "  private long "
              out.print(rel.getVariableName());
              out.print(source[19]); // 202:40 = "RemovedId;"
            }
          }
        }

        if (rel.getNmName() != null) {
          String nmVar;
          if (rel.getNmMethodName() != null) {
            nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
          }
          else  {
            nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
          }
          out.print(source[20]); // 216:2 = "  private transient TrackedList<"
          out.print(rel.getNmRelation().getDeclaredJavaType(false));
          out.print(source[21]); // 217:82 = "> "
          out.print(nmVar);
          out.print(source[22]); // 217:93 = ";"
        }
      }
    }

    if (generateClearOnRemoteSave) {
      out.print(source[23]); // 224:2 = "  @Override  public void clearOnRemote..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isClearOnRemoteSave()) {
          out.print(source[24]); // 231:2 = "    "
          out.print(rel.getVariableName());
          out.print(source[25]); // 232:29 = " = null;"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[26]); // 235:2 = "    "
            out.print(rel.getVariableName());
            out.print(source[27]); // 236:29 = "Loaded = false;"
          }
        }
      }
      out.print(source[28]); // 241:2 = "  }"
    }



    // generate getter/setter
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String effType = rel.getJavaType();
      String scope = rel.getAccessScope().toString();
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        scope = attr.getOptions().getAccessScope().toString();
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }
      if (rel.getForeignRelation() != null) {
        String linkMethodName = rel.getForeignRelation().getLinkMethodName();
        if (linkMethodName != null && !rel.getSetterName().equals(linkMethodName)) {
          // don't generate setter impl if linkmethodname is not default from model
          createSetter = false;
        }
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == null || " + checkNull;
        }
        out.print(source[29]); // 293:2 = "  @Override"
        if (rel.getForeignEntity().isAbstract()) { // needs a cast
        out.print(source[30]); // 298:2 = "  @SuppressWarnings("unchecked")"
        }
        out.print(source[31]); // 302:2 = "  "
        out.print(scope);
        out.print(source[32]); // 303:11 = " "
        out.print(type);
        out.print(source[33]); // 303:20 = " "
        out.print(rel.getGetterName());
        out.print(source[34]); // 303:44 = "()  {"
        if (rel.getSelectionType() == SelectionType.ALWAYS) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isSelectionCached()) {
              out.print(source[35]); // 308:2 = "    "
              out.print(var);
              out.print(source[36]); // 309:11 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[37]); // 309:47 = ";"
            }
            else {
              out.print(source[38]); // 313:2 = "    "
              out.print(type);
              out.print(source[39]); // 314:12 = " "
              out.print(var);
              out.print(source[40]); // 314:20 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[41]); // 314:56 = ";"
            }
            if (rel.isReferenced()) {
              if (rel.getLinkMethodIndex() != null) {
                out.print(source[42]); // 319:2 = "    int ndx = 0;"
              }
              out.print(source[43]); // 323:2 = "    for ("
              out.print(rel.getClassName());
              out.print(source[44]); // 324:31 = " obj: "
              out.print(var);
              out.print(source[45]); // 324:44 = ")  {      obj."
              out.print(createRelationUpdateReferenceCode(rel));
              out.print(source[46]); // 325:52 = ";    }"
            }
            out.print(source[47]); // 329:2 = "    return "
            out.print(var);
            out.print(source[48]); // 330:18 = ";"
          }
          else  {
            if (rel.isComposite()) {
              out.print(source[49]); // 335:2 = "    "
              out.print(var);
              out.print(source[50]); // 336:11 = " = "
              out.print(checkNull);
              out.print(source[51]); // 336:27 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[52]); // 336:70 = ";"
              if (rel.isReferenced()) {
                out.print(source[53]); // 339:2 = "    if ("
                out.print(var);
                out.print(source[54]); // 340:15 = " != null) {      "
                out.print(var);
                out.print(source[55]); // 341:13 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[56]); // 341:56 = ";    }"
              }
              if (rel.isProcessed()) {
                out.print(source[57]); // 346:2 = "    "
                out.print(var);
                out.print(source[58]); // 347:11 = " = process"
                out.print(rel.getMethodNameSuffix());
                out.print(source[59]); // 347:50 = "("
                out.print(var);
                out.print(source[60]); // 347:58 = ");"
              }
              out.print(source[61]); // 350:2 = "    return "
              out.print(var);
              out.print(source[62]); // 351:18 = ";"
            }
            else  {
              if (rel.isReferenced()) {
                out.print(source[63]); // 356:2 = "    "
                out.print(type);
                out.print(source[64]); // 357:12 = " obj = "
                out.print(checkNull);
                out.print(source[65]); // 357:32 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[66]); // 357:75 = ";    if (obj != null) {      obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[67]); // 359:52 = ";    }    return obj;"
              }
              else {
                out.print(source[68]); // 365:2 = "    return "
                out.print(checkNull);
                out.print(source[69]); // 366:24 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[70]); // 366:67 = ";"
              }
            }
          }
        }
        else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[71]); // 373:2 = "    if (!"
          out.print(var);
          out.print(source[72]); // 374:16 = "Loaded) {"
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.LIST) {
              String condition = "isNew()";
              Attribute countAttribute = rel.getCountAttribute();
              if (countAttribute != null) {
                condition += " || " + countAttribute.getName() + " == 0";
              }
              out.print(source[73]); // 383:2 = "      "
              out.print(var);
              out.print(source[74]); // 384:13 = " = "
              out.print(condition);
              out.print(source[75]); // 384:29 = " ? new "
              out.print(effType);
              out.print(source[76]); // 384:47 = "("
              out.print(rel.isTracked() ? "false" : "");
              out.print(source[77]); // 384:82 = ") : "
              out.print(createRelationSelectCode(rel));
              out.print(source[78]); // 384:119 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[79]); // 388:2 = "      int ndx = 0;"
                }
                out.print(source[80]); // 392:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[81]); // 393:33 = " obj: "
                out.print(var);
                out.print(source[82]); // 393:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[83]); // 394:54 = ";      }"
              }
            }
            else  {
              out.print(source[84]); // 400:2 = "      "
              out.print(var);
              out.print(source[85]); // 401:13 = " =  "
              out.print(checkNull);
              out.print(source[86]); // 401:30 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[87]); // 401:73 = ";"
              if (rel.isReferenced()) {
                out.print(source[88]); // 404:2 = "      if ("
                out.print(var);
                out.print(source[89]); // 405:17 = " != null) {        "
                out.print(var);
                out.print(source[90]); // 406:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[91]); // 406:58 = ";      }"
              }
            }
            if (rel.getRelationType() == RelationType.LIST) {
              if (rel.isTracked()) {
                out.print(source[92]); // 413:2 = "      if (isImmutable()) {        "
                out.print(var);
                out.print(source[93]); // 415:15 = ".setImmutable(true);      }"
              }
            }
            else  {
              out.print(source[94]); // 421:2 = "      if (isImmutable() && "
              out.print(var);
              out.print(source[95]); // 422:34 = " != null) {        "
              out.print(var);
              out.print(source[96]); // 423:15 = ".setImmutable(true);      }"
            }
            if (rel.isProcessed()) {
              out.print(source[97]); // 428:2 = "      "
              out.print(var);
              out.print(source[98]); // 429:13 = " = process"
              out.print(rel.getMethodNameSuffix());
              out.print(source[99]); // 429:52 = "("
              out.print(var);
              out.print(source[100]); // 429:60 = ");"
            }
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[101]); // 435:2 = "      "
              out.print(var);
              out.print(source[102]); // 436:13 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[103]); // 436:49 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[104]); // 440:2 = "      int ndx = 0;"
                }
                out.print(source[105]); // 444:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[106]); // 445:33 = " obj: "
                out.print(var);
                out.print(source[107]); // 445:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[108]); // 446:54 = ";      }"
              }
            }
            else  {
              out.print(source[109]); // 452:2 = "      "
              out.print(var);
              out.print(source[110]); // 453:13 = " = "
              out.print(checkNull);
              out.print(source[111]); // 453:29 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[112]); // 453:72 = ";"
              if (rel.isReferenced()) {
                out.print(source[113]); // 456:2 = "      if ("
                out.print(var);
                out.print(source[114]); // 457:17 = " != null) {        "
                out.print(var);
                out.print(source[115]); // 458:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[116]); // 458:58 = ";      }"
              }
            }
          }
          out.print(source[117]); // 464:2 = "      "
          out.print(var);
          out.print(source[118]); // 465:13 = "Loaded = true;"
          if (nmRel != null) {
            out.print(source[119]); // 468:2 = "      "
            out.print(var);
            out.print(source[120]); // 469:13 = ".addListener(new TrackedListListener<"
            out.print(rel.getClassName());
            out.print(source[121]); // 469:72 = ">() {        @Override        public ..."
            out.print(rel.getClassName());
            out.print(source[122]); // 472:48 = " element) {          get"
            out.print(nmName);
            out.print(source[123]); // 473:23 = "().addIfAbsent(element."
            out.print(nmRel.getGetterName());
            out.print(source[124]); // 473:71 = "());        }        @Override      ..."
            out.print(rel.getClassName());
            out.print(source[125]); // 477:50 = " element) {          get"
            out.print(nmName);
            out.print(source[126]); // 478:23 = "().remove(element."
            out.print(nmRel.getGetterName());
            out.print(source[127]); // 478:66 = "());        }      });"
          }
          out.print(source[128]); // 483:2 = "    }    return "
          out.print(var);
          out.print(source[129]); // 485:18 = ";"
        }
        out.print(source[130]); // 488:2 = "  }"
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
            out.print(source[131]); // 493:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[132]); // 496:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[133]); // 498:21 = " "
            out.print(rel.getComment());
            out.print(source[134]); // 498:42 = "   */  "
            out.print(scope);
            out.print(source[135]); // 500:11 = " "
            out.print(type);
            out.print(source[136]); // 500:20 = " "
            out.print(rel.getGetterName());
            out.print(source[137]); // 500:44 = "Blunt() {    if (!"
            out.print(var);
            out.print(source[138]); // 501:16 = "Loaded) {      "
            out.print(var);
            out.print(source[139]); // 502:13 = " = new "
            out.print(effType);
            out.print(source[140]); // 502:31 = "("
            out.print(rel.isTracked() ? "false" : "");
            out.print(source[141]); // 502:66 = ");      if (isImmutable()) {        "
            out.print(var);
            out.print(source[142]); // 504:15 = ".setImmutable(true);      }      "
            out.print(var);
            out.print(source[143]); // 506:13 = "Loaded = true;    }    return "
            out.print(var);
            out.print(source[144]); // 508:18 = ";  }"
          }
          else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized()) {
            out.print(source[145]); // 513:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[146]); // 516:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[147]); // 518:21 = " "
            out.print(rel.getComment());
            out.print(source[148]); // 518:42 = "   */  "
            out.print(scope);
            out.print(source[149]); // 520:11 = " "
            out.print(type);
            out.print(source[150]); // 520:20 = " "
            out.print(rel.getGetterName());
            out.print(source[151]); // 520:44 = "Blunt() {    return "
            out.print(var);
            out.print(source[152]); // 521:18 = ";  }"
          }
        }

        if (nmRel != null) {
          String nmType = nmRel.getDeclaredJavaType(false);
          out.print(source[153]); // 529:2 = "  @Override  public TrackedList<"
          out.print(nmType);
          out.print(source[154]); // 532:31 = "> get"
          out.print(nmName);
          out.print(source[155]); // 532:46 = "() {    if ("
          out.print(nmVar);
          out.print(source[156]); // 533:17 = " == null) {      "
          out.print(nmVar);
          out.print(source[157]); // 534:15 = " = new TrackedArrayList<"
          out.print(nmType);
          out.print(source[158]); // 534:49 = ">() {        @Override        public ..."
          out.print(rel.getGetterName());
          out.print(source[159]); // 538:40 = "().isModified();        }      };   ..."
          out.print(rel.getForeignEntity());
          out.print(source[160]); // 542:37 = " obj: "
          out.print(rel.getGetterName());
          out.print(source[161]); // 542:66 = "()) {        "
          out.print(nmVar);
          out.print(source[162]); // 543:17 = ".add(obj."
          out.print(nmRel.getGetterName());
          out.print(source[163]); // 543:51 = "());      }      "
          out.print(nmVar);
          out.print(source[164]); // 546:15 = ".addListener(new TrackedListListener<"
          out.print(nmType);
          out.print(source[165]); // 546:62 = ">() {        @Override        public ..."
          out.print(nmType);
          out.print(source[166]); // 549:36 = " element) {          "
          out.print(rel.getClassName());
          out.print(source[167]); // 550:32 = " obj = on("
          out.print(rel.getClassName());
          out.print(source[168]); // 550:64 = ".class);          obj."
          out.print(nmRel.getSetterName());
          out.print(source[169]); // 551:39 = "(element);          getNmLinks().add(ob..."
          out.print(nmType);
          out.print(source[170]); // 556:38 = " element) {          for (Iterator<"
          out.print(rel.getClassName());
          out.print(source[171]); // 557:46 = "> iter = "
          out.print(rel.getGetterName());
          out.print(source[172]); // 557:78 = "().iterator(); iter.hasNext(); ) {     ..."
          out.print(rel.getClassName());
          out.print(source[173]); // 558:34 = " obj = iter.next();            if (Obje..."
          out.print(nmRel.getGetterName());
          out.print(source[174]); // 559:60 = "(), element)) {              iter.remov..."
          out.print(nmVar);
          out.print(source[175]); // 567:20 = ";  }"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
          if (rel.getAccessScope() == AccessScope.PUBLIC) {
            out.print(source[176]); // 575:2 = "  @Override"
          }
          else {
            out.print(source[177]); // 581:2 = "  /**   * Returns whether "
            out.print(rel.getName());
            out.print(source[178]); // 584:38 = " is loaded.   *   * @return true if "
            out.print(rel.getGetterName());
            out.print(source[179]); // 586:45 = "() invoked at least once   */"
          }
          out.print(source[180]); // 590:2 = "  "
          out.print(scope);
          out.print(source[181]); // 591:11 = " boolean is"
          out.print(StringHelper.firstToUpper(var));
          out.print(source[182]); // 591:56 = "Loaded() {    return "
          out.print(var);
          out.print(source[183]); // 592:18 = "Loaded;  }"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
        out.print(source[184]); // 602:2 = "  @Override"
        if (linkMethodIndex != null) {
          out.print(source[185]); // 607:2 = "  "
          out.print(scope);
          out.print(source[186]); // 608:11 = " void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[187]); // 608:65 = "("
          out.print(type);
          out.print(source[188]); // 608:74 = " "
          out.print(var);
          out.print(source[189]); // 608:82 = ", int index)  {"
        }
        else {
          out.print(source[190]); // 612:2 = "  "
          out.print(scope);
          out.print(source[191]); // 613:11 = " void "
          out.print(rel.getSetterName());
          out.print(source[192]); // 613:40 = "("
          out.print(type);
          out.print(source[193]); // 613:49 = " "
          out.print(var);
          out.print(source[194]); // 613:57 = ")  {"
        }
        if (!rel.isReversed()) {
          out.print(source[195]); // 617:2 = "    assertMutable();"
        }
        if ((rel.getRelationType() == RelationType.LIST && !rel.isReversed()) ||
            rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[196]); // 624:2 = "    if (!attributesModified()) {      s..."
            out.print(var);
            out.print(source[197]); // 626:46 = ", "
            out.print(var);
            out.print(source[198]); // 626:55 = "));    }"
          }
          out.print(source[199]); // 630:2 = "    this."
          out.print(var);
          out.print(source[200]); // 631:16 = " = "
          out.print(var);
          out.print(source[201]); // 631:26 = ";"
          if (linkMethodIndex != null) {
            out.print(source[202]); // 634:2 = "    set"
            out.print(StringHelper.firstToUpper(linkMethodIndex));
            out.print(source[203]); // 635:53 = "(index);"
          }
        }
        if (rel.getRelationType() == RelationType.OBJECT) {
          if (rel.isComposite())  {
            if (attr != null && !attr.getDataType().isPrimitive()) {
              out.print(source[204]); // 642:2 = "    "
              out.print(attr.getJavaType());
              out.print(source[205]); // 643:26 = " oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[206]); // 643:85 = ";"
            }
            else {
              out.print(source[207]); // 647:2 = "    long oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[208]); // 648:67 = ";"
            }
          }
          out.print(source[209]); // 652:2 = "    "
          out.print(createRelationSetFirstArgMethodName(rel));
          out.print(source[210]); // 653:48 = "("
          out.print(var);
          out.print(source[211]); // 653:56 = " == null ? "
          out.print(nullVal);
          out.print(source[212]); // 653:78 = " : "
          out.print(var);
          out.print(source[213]); // 653:88 = ".getId());"
        }
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[214]); // 657:2 = "    "
          out.print(var);
          out.print(source[215]); // 658:11 = "Loaded = true;"
        }
        if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite())  {
          if (attr != null && !attr.getDataType().isPrimitive()) {
            out.print(source[216]); // 663:2 = "    if (oldId != null && oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[217]); // 664:64 = "RemovedId == 0 && !Objects.equals("
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[218]); // 664:148 = ", oldId)) {      "
            out.print(rel.getVariableName());
            out.print(source[219]); // 665:31 = "RemovedId = oldId;    }"
          }
          else {
            out.print(source[220]); // 670:2 = "    if (oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[221]); // 671:47 = "RemovedId == 0 && "
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[222]); // 671:115 = " != oldId) {      "
            out.print(rel.getVariableName());
            out.print(source[223]); // 672:31 = "RemovedId = oldId;    }"
          }
        }
        out.print(source[224]); // 677:2 = "  }"
      }

      if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() &&
          (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
            out.print(source[225]); // 684:2 = "  /**   * Sets "
            out.print(var);
            out.print(source[226]); // 687:17 = " without setting any attributes.   *  ..."
            out.print(var);
            out.print(source[227]); // 689:20 = " "
            out.print(rel.getComment());
            out.print(source[228]); // 689:41 = "   */  "
            out.print(scope);
            out.print(source[229]); // 691:11 = " void "
            out.print(rel.getSetterName());
            out.print(source[230]); // 691:40 = "Blunt("
            out.print(type);
            out.print(source[231]); // 691:54 = " "
            out.print(var);
            out.print(source[232]); // 691:62 = ") {    this."
            out.print(var);
            out.print(source[233]); // 692:16 = " = "
            out.print(var);
            out.print(source[234]); // 692:26 = ";    "
            out.print(var);
            out.print(source[235]); // 693:11 = "Loaded = true;  }"
      }

    }


    // gerenate setSession and setDomainContext for referenced objects (necessary for RMI)
    if (generateSetSession)  {
      out.print(source[236]); // 703:2 = "  @Override  public void setSession(Se..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[237]); // 714:2 = "    session.applyTo("
               out.print(rel.getVariableName());
               out.print(source[238]); // 715:45 = ");"
        }
      }
      out.print(source[239]); // 719:2 = "  }  @Override  public void setDomain..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[240]); // 731:2 = "    context.applyTo("
               out.print(rel.getVariableName());
               out.print(source[241]); // 732:45 = ");"
        }
      }
      out.print(source[242]); // 736:2 = "  }"
    }



    // generate code to remove delete composite relations

    if (generateDeleteReferencingRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[243]); // 747:2 = "  /**   * Deletes all referencing comp..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (!rel.isTracked()) {
                throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
              }
              String var = rel.getVariableName();
              out.print(source[244]); // 761:2 = "    if ("
              out.print(var);
              out.print(source[245]); // 762:15 = " != null && "
              out.print(var);
              out.print(source[246]); // 762:34 = ".isSomeRemoved()) {      delete("
              out.print(var);
              out.print(source[247]); // 763:20 = ".getRemovedObjects());    }"
            }
          }
          out.print(source[248]); // 768:2 = "  }"
      }
      else { // no database ref. integrity
        if (generateLazyDeleteReferencingRelations)  {
          out.print(source[249]); // 774:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                if (rel.isTracked())  {
                  out.print(source[250]); // 799:2 = "    if (delete) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[251]); // 803:2 = "      delete("
                    out.print(rel.getGetterName());
                    out.print(source[252]); // 804:36 = "());"
                  }
                  else {
                    out.print(source[253]); // 808:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[254]); // 809:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[255]); // 810:39 = ";"
                  }
                  out.print(source[256]); // 813:2 = "    }    if ("
                  out.print(var);
                  out.print(source[257]); // 815:15 = " != null && "
                  out.print(var);
                  out.print(source[258]); // 815:34 = ".isSomeRemoved()) {      delete("
                  out.print(var);
                  out.print(source[259]); // 816:20 = ".getRemovedObjects());    }"
                }  // end if isTracked
                else  {
                  out.print(source[260]); // 821:2 = "    if (delete || "
                  out.print(var);
                  out.print(source[261]); // 822:25 = " != null) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[262]); // 825:2 = "      markDeleted("
                    out.print(rel.getGetterName());
                    out.print(source[263]); // 826:41 = "());      deleteMissingInCollection("
                    out.print(createRelationSelectCode(rel));
                    out.print(source[264]); // 827:65 = ", "
                    out.print(var);
                    out.print(source[265]); // 827:74 = ");"
                  } // end isDeleteCascade
                  else {
                    out.print(source[266]); // 831:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[267]); // 832:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[268]); // 833:39 = ";"
                  }
                  out.print(source[269]); // 836:2 = "    }"
                }
              }
            } // end composite
          }
          out.print(source[270]); // 843:2 = "  }"
        } // end if generateLazyDeleteReferencingRelations

        else  {   // no lazy loading at all
        out.print(source[271]); // 849:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.isDeletionCascaded()) {
                out.print(source[272]); // 859:2 = "    delete("
                out.print(rel.getGetterName());
                out.print(source[273]); // 860:34 = "());"
              }
              else {
                out.print(source[274]); // 864:2 = "    markDeleted("
                out.print(var);
                out.print(source[275]); // 865:23 = ");    "
                out.print(createRelationDeleteCode(rel));
                out.print(source[276]); // 866:37 = ";"
              }
            }
          }
          out.print(source[277]); // 871:2 = "  }"
        }
      } // end w/o db-integrity
    }


    if (generateDeleteReferencedRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[278]); // 881:2 = "  /**   * Deletes all referenced compo..."
        for (Relation rel: getEntity().getRelations()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            if (!rel.isTracked()) {
              throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
            }
            // remove the old deleted composite too, if set
            // we need to replace <varname>Id by <varname>RemovedId in the select statement
            String var = rel.getVariableName();
            String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
            out.print(source[279]); // 898:2 = "    if ("
            out.print(rel.getVariableName());
            out.print(source[280]); // 899:33 = "RemovedId != 0) {      "
            out.print(rel.getClassName());
            out.print(source[281]); // 900:28 = " old = "
            out.print(selectStmt);
            out.print(source[282]); // 900:49 = ";      if (old != null) {        old.d..."
            out.print(rel.getVariableName());
            out.print(source[283]); // 903:33 = "RemovedId = 0;      }    }"
          }
        }
        out.print(source[284]); // 909:2 = "  }"
      }
      else  {
        if (generateLazyDeleteReferencedRelations)  {
          out.print(source[285]); // 915:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                out.print(source[286]); // 939:2 = "    if (delete && "
                out.print(rel.getGetterName());
                out.print(source[287]); // 940:41 = "() != null && !"
                out.print(var);
                out.print(source[288]); // 940:63 = ".isVirgin()) {      delete("
                out.print(var);
                out.print(source[289]); // 941:20 = ");    }"
              }
              // remove the old deleted composite too, if set
              // we need to replace <varname>Id by <varname>RemovedId in the select statement
              String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
              out.print(source[290]); // 948:2 = "    if ("
              out.print(rel.getVariableName());
              out.print(source[291]); // 949:33 = "RemovedId != 0) {      "
              out.print(rel.getClassName());
              out.print(source[292]); // 950:28 = " old = "
              out.print(selectStmt);
              out.print(source[293]); // 950:49 = ";      if (old != null) {        old.d..."
              out.print(rel.getVariableName());
              out.print(source[294]); // 953:33 = "RemovedId = 0;      }    }"
            } // end composite
          }
          out.print(source[295]); // 959:2 = "  }"
        } // end if generateLazyDeleteReferencedRelations

        else  {   // no lazy loading at all
        out.print(source[296]); // 965:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.ALWAYS) {
                throw new WurbelException("internal wurblet logic error");
              }
              else {
                out.print(source[297]); // 978:2 = "    if ("
                out.print(var);
                out.print(source[298]); // 979:15 = " != null) {      delete("
                out.print(var);
                out.print(source[299]); // 980:20 = ");    }"
              }
            }
          }
          out.print(source[300]); // 986:2 = "  }"
        }
      }
    }


    // save composite relations

    if (generateSaveReferencingRelations)  {
      out.print(source[301]); // 997:2 = "  @Override  public void saveReferenci..."
      if (useDatabaseRefInt) {
        out.print(source[302]); // 1005:2 = "      deleteRemovedReferencingRelations(..."
      }
      else  {
        out.print(source[303]); // 1010:2 = "      deleteReferencingRelations("
        out.print(generateLazyDeleteReferencingRelations ? "false" : "");
        out.print(source[304]); // 1011:90 = ");"
      }
      out.print(source[305]); // 1014:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          if (rel.isProcessed()) {
            out.print(source[306]); // 1021:2 = "    "
            out.print(var);
            out.print(source[307]); // 1022:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[308]); // 1022:50 = "("
            out.print(var);
            out.print(source[309]); // 1022:58 = ");"
          }
          out.print(source[310]); // 1025:2 = "    if ("
          out.print(var);
          out.print(source[311]); // 1026:15 = " != null) {      getDomainContext().app..."
          out.print(var);
          out.print(source[312]); // 1027:40 = ");"
          if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
            out.print(source[313]); // 1030:2 = "      int ndx = 0;"
          }
          out.print(source[314]); // 1034:2 = "      for ("
          out.print(rel.getClassName());
          out.print(source[315]); // 1035:33 = " obj: "
          out.print(var);
          out.print(source[316]); // 1035:46 = ")  {        obj."
          out.print(createRelationLinkCode(rel));
          out.print(source[317]); // 1036:43 = ";"
          boolean firstSkipped = false;
          for (MethodArgument ma: rel.getMethodArgs()) {
            if (firstSkipped)  {
              out.print(source[318]); // 1041:2 = "        obj."
              out.print(ma.getSetterMethod());
              out.print(source[319]); // 1042:36 = "("
              out.print(ma.getMethodArgument());
              out.print(source[320]); // 1042:63 = ");"
            }
            firstSkipped = true;
          }
          out.print(source[321]); // 1047:2 = "      }      save("
          out.print(var);
          out.print(source[322]); // 1049:18 = ", "
          out.print(rel.isTracked() ? "true" : "false");
          out.print(source[323]); // 1049:58 = ");    }"
        }
      }
      out.print(source[324]); // 1054:2 = "  }"
    }


    if (generateSaveReferencedRelations)  {
      out.print(source[325]); // 1061:2 = "  @Override  public void saveReference..."
      if (getEntity().isRootEntity()) {
        // need a valid id to store in rootId of composite object relations
        out.print(source[326]); // 1068:2 = "    reserveId();"
      }
      out.print(source[327]); // 1072:2 = "    super.saveReferencedRelations(update..."
      if (useDatabaseRefInt) {
        out.print(source[328]); // 1077:2 = "      deleteRemovedReferencedRelations()..."
      }
      else  {
        out.print(source[329]); // 1082:2 = "      deleteReferencedRelations("
        out.print(generateLazyDeleteReferencedRelations ? "false" : "");
        out.print(source[330]); // 1083:88 = ");"
      }
      out.print(source[331]); // 1086:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[332]); // 1092:2 = "    getDomainContext().applyTo("
          out.print(var);
          out.print(source[333]); // 1093:38 = ");"
          if (rel.isProcessed()) {
            out.print(source[334]); // 1096:2 = "    "
            out.print(var);
            out.print(source[335]); // 1097:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[336]); // 1097:50 = "("
            out.print(var);
            out.print(source[337]); // 1097:58 = ");"
          }
          if (rel.isTracked())  {
            out.print(source[338]); // 1101:2 = "    if ("
            out.print(var);
            out.print(source[339]); // 1102:15 = " != null && "
            out.print(var);
            out.print(source[340]); // 1102:34 = ".isModified()) {      save("
            out.print(var);
            out.print(source[341]); // 1103:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[342]); // 1104:50 = "("
            out.print(var);
            out.print(source[343]); // 1104:58 = ".getId());    }"
          }
          else  {
            out.print(source[344]); // 1109:2 = "    if ("
            out.print(var);
            out.print(source[345]); // 1110:15 = " != null) {      save("
            out.print(var);
            out.print(source[346]); // 1111:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[347]); // 1112:50 = "("
            out.print(var);
            out.print(source[348]); // 1112:58 = ".getId());    }"
          }
        }
      }
      out.print(source[349]); // 1118:2 = "  }"
    }



    // generate code to validate
    if (generateValidate)  {
      out.print(source[350]); // 1127:2 = "  @Override  public List<ValidationRes..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[351]); // 1136:2 = "    if ("
          out.print(var);
          out.print(source[352]); // 1137:15 = " != null) {"
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[353]); // 1140:2 = "      results.addAll(ValidationUtilities..."
            out.print(rel.getVariableName());
            out.print(source[354]); // 1142:41 = ", validationPath + "."
            out.print(var);
            out.print(source[355]); // 1142:69 = "", scope));"
          }
          else  {
            out.print(source[356]); // 1146:2 = "      results.addAll("
            out.print(rel.getVariableName());
            out.print(source[357]); // 1147:46 = ".validate(validationPath + "."
            out.print(var);
            out.print(source[358]); // 1147:82 = "", scope));"
          }
          out.print(source[359]); // 1150:2 = "    }"
        }
      }
      out.print(source[360]); // 1155:2 = "    return results;  }"
    }



    // generate code to check set the immutable flag
    if (generateSetImmutable)  {
      out.print(source[361]); // 1165:2 = "  @Override  public void setImmutable(..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          out.print(source[362]); // 1173:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[363]); // 1174:33 = " != null) {      "
          out.print(rel.getVariableName());
          out.print(source[364]); // 1175:31 = ".setImmutable(immutable);    }"
        }
      }
      out.print(source[365]); // 1180:2 = "  }"
    }



    // generate code to check for modifications
    if (generateIsModified)  {
      out.print(source[366]); // 1189:2 = "  @Override  public boolean isModified..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[367]); // 1198:2 = "           || isModified("
            out.print(rel.getVariableName());
            out.print(source[368]); // 1199:50 = ")"
          }
          else  {
            out.print(source[369]); // 1203:2 = "           || "
            out.print(rel.getVariableName());
            out.print(source[370]); // 1204:39 = " != null && "
            out.print(rel.getVariableName());
            out.print(source[371]); // 1204:76 = ".isModified()"
          }
        }
      }
      out.print(source[372]); // 1209:2 = "           ;  }"
    }

    if (generateAlignComponents) {
      out.print(source[373]); // 1216:2 = "  @Override  protected void alignCompo..."
      for (Relation rel: getEntity().getRelations()) {
        Attribute countAttribute = rel.getCountAttribute();
        if (countAttribute != null) {
          out.print(source[374]); // 1225:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[375]); // 1226:33 = " != null) {      "
          out.print(countAttribute.getSetterName());
          out.print(source[376]); // 1227:40 = "("
          out.print(rel.getVariableName());
          out.print(source[377]); // 1227:66 = ".size());    }"
        }
      }
      out.print(source[378]); // 1232:2 = "  }"
    }

    if (getEntity().isDeeplyReferenced()) {
      List<Relation> deepRelations = new ArrayList<>();
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite() && rel.getForeignEntity().isDeeplyReferenced()) {
          deepRelations.add(rel);
        }
      }
      if (!deepRelations.isEmpty()) {
        out.print(source[379]); // 1245:2 = "  @Override  public boolean isReferenc..."
        for (Relation rel: deepRelations) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[380]); // 1256:2 = "    for ("
            out.print(rel.getForeignEntity());
            out.print(source[381]); // 1257:35 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[382]); // 1257:64 = "()) {      if (obj.isReferenced()) {  ..."
          }
          else {
            out.print(source[383]); // 1265:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[384]); // 1266:31 = "() != null && "
            out.print(rel.getGetterName());
            out.print(source[385]); // 1266:68 = "().isReferenced()) {      return true;..."
          }
        }
        out.print(source[386]); // 1272:2 = "    return false;  }"
      }
    }



    // override isComposite()
    if (generateIsComposite)  {
      out.print(source[387]); // 1284:2 = "  @Override  public boolean isComposit..."
    }


    //  load all components
    if (generateLoadComponents)  {

      out.print(source[388]); // 1298:2 = "  @Override  public IdentifiableMap<? ..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[389]); // 1316:2 = "    if (!onlyLoaded || "
            out.print(var);
            out.print(source[390]); // 1317:30 = "Loaded) {"
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[391]); // 1320:2 = "      count += addComponents(components,..."
              out.print(rel.getGetterName());
              out.print(source[392]); // 1321:64 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[393]); // 1325:2 = "      if ("
              out.print(rel.getGetterName());
              out.print(source[394]); // 1326:33 = "() != null) {        count += ((Abstrac..."
              out.print(var);
              out.print(source[395]); // 1327:57 = ".getPersistenceDelegate()).addComponents..."
            }
            out.print(source[396]); // 1331:2 = "    }"
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[397]); // 1337:2 = "    count += addComponents(components, "
              out.print(rel.getGetterName());
              out.print(source[398]); // 1338:62 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[399]); // 1342:2 = "    if ("
              out.print(rel.getGetterName());
              out.print(source[400]); // 1343:31 = "() != null) {      count += ((AbstractP..."
              out.print(var);
              out.print(source[401]); // 1344:55 = ".getPersistenceDelegate()).addComponents..."
            }
          }
        }
      }
      out.print(source[402]); // 1351:2 = "    return count;  }"
    }



    //  insert all components
    if (generateInsertComponents)  {

      out.print(source[403]); // 1362:2 = "  @Override  public void insertPlainWi..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[404]); // 1370:2 = "    if ("
          out.print(rel.getGetterName());
          out.print(source[405]); // 1371:31 = "() != null) {      ((AbstractPersistent..."
          out.print(var);
          out.print(source[406]); // 1372:46 = ".getPersistenceDelegate()).insertPlainWi..."
        }
      }
      out.print(source[407]); // 1377:2 = "    insertPlain();"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          out.print(source[408]); // 1383:2 = "    insertPlainWithComponents("
          out.print(rel.getGetterName());
          out.print(source[409]); // 1384:53 = "());"
        }
      }
      out.print(source[410]); // 1388:2 = "  }"
    }


    //  delete all components
    if (generateDeleteComponents)  {

      out.print(source[411]); // 1397:2 = "  @Override  public void deletePlainWi..."
      if (useDatabaseRefInt) {
        out.print(source[412]); // 1403:2 = "    // components are deleted via databa..."
      }
      else {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
            out.print(source[413]); // 1411:2 = "    deletePlainWithComponents("
            out.print(rel.getGetterName());
            out.print(source[414]); // 1412:53 = "());"
          }
        }
      }
      out.print(source[415]); // 1417:2 = "    deletePlain();"
      if (!useDatabaseRefInt) {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[416]); // 1424:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[417]); // 1425:31 = "() != null) {      ((AbstractPersistent..."
            out.print(var);
            out.print(source[418]); // 1426:46 = ".getPersistenceDelegate()).deletePlainWi..."
          }
        }
      }
      out.print(source[419]); // 1432:2 = "  }"
    }



    // mark object and all components deleted
    if (generateMarkDeleted)  {
      out.print(source[420]); // 1441:2 = "  @Override  public void markDeleted()..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[421]); // 1450:2 = "    markDeleted("
          out.print(var);
          out.print(source[422]); // 1451:23 = ");"
        }
      }
      out.print(source[423]); // 1455:2 = "  }"
    }


    // generate snapshot methods
    if (generateSnapshot) {
      out.print(source[424]); // 1463:2 = "  /**   * Updates the components in sn..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[425]); // 1471:100 = " snapshot) {    super.createComponentsI..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() &&
            (rel.getRelationType() == RelationType.OBJECT || rel.isTracked())) {
              out.print(source[426]); // 1478:2 = "    if ("
              out.print(var);
              out.print(source[427]); // 1479:15 = " != null) {      snapshot."
              out.print(var);
              out.print(source[428]); // 1480:22 = "Snapshot = "
              out.print(var);
              out.print(source[429]); // 1480:40 = ".createSnapshot();    }"
        }
      }
      out.print(source[430]); // 1485:2 = "  }  /**   * Reverts all components o..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[431]); // 1493:100 = " snapshot) {    super.revertComponentsT..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          Relation nmRel = rel.getNmRelation();
          String nmVar = null;
          if (nmRel != null) {
            if (rel.getNmMethodName() != null) {
              nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
            }
            else  {
              nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
            }
          }
          out.print(source[432]); // 1509:2 = "    "
          out.print(var);
          out.print(source[433]); // 1510:11 = " = snapshot."
          out.print(var);
          out.print(source[434]); // 1510:30 = ";"
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[435]); // 1514:2 = "    if ("
              out.print(var);
              out.print(source[436]); // 1515:15 = " != null) {      "
              out.print(var);
              out.print(source[437]); // 1516:13 = ".revertToSnapshot(snapshot."
              out.print(var);
              out.print(source[438]); // 1516:47 = "Snapshot);    }"
            }
          }
          else  {
            out.print(source[439]); // 1522:2 = "    if ("
            out.print(var);
            out.print(source[440]); // 1523:15 = " != null) {      "
            out.print(var);
            out.print(source[441]); // 1524:13 = ".revertToSnapshot(snapshot."
            out.print(var);
            out.print(source[442]); // 1524:47 = "Snapshot);    }"
          }
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[443]); // 1529:2 = "    "
            out.print(var);
            out.print(source[444]); // 1530:11 = "Loaded = snapshot."
            out.print(var);
            out.print(source[445]); // 1530:36 = "Loaded;"
          }
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[446]); // 1534:2 = "    "
            out.print(var);
            out.print(source[447]); // 1535:11 = "RemovedId = snapshot."
            out.print(var);
            out.print(source[448]); // 1535:39 = "RemovedId;"
          }
          if (nmVar != null) {
            out.print(source[449]); // 1539:2 = "    "
            out.print(nmVar);
            out.print(source[450]); // 1540:13 = " = null;"
          }
        }
      }
      out.print(source[451]); // 1545:2 = "  }"
    }


    if (generateIsReferencing && isEntityPersistable()) {
      for (Relation rel: getEntity().getTableRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          String tagName = "isReferencing" + rel.getClassName() + "By" +
                           StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[452]); // 1558:2 = "  // Determines whether any "
                           out.print(pdoName);
                           out.print(source[453]); // 1560:39 = " references given "
                           out.print(rel.getClassName());
                           out.print(source[454]); // 1560:79 = "  // @wurblet "
                           out.print(tagName);
                           out.print(source[455]); // 1561:26 = " PdoIsReferencing "
                           out.print(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[456]); // 1561:99 = ""
        }
      }
    }

    if (generateSelects && isEntityPersistable()) {
      Set<String> wurbletArgSet = new HashSet<>();   // to avoid duplicates if args= is used
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null) {
            // force tracked even if related object is not tracked
            String trackedOption = rel.isTracked() ? "--tracked " : "";
            String joins = "";
            if (rel.getNmName() != null) {
              Relation join = rel.getNmRelation();
              if (join != null && join.getRelationType() == RelationType.OBJECT &&
                  join.getSelectionType() == SelectionType.LAZY &&
                  !join.isComposite() && join.isSerialized()) {
                joins = " *" + rel.getNmName();
              }
            }
            // add eager joins, if any
            for (Relation eRel: getEntity().getRelationsIncludingInherited()) {
              if (eRel.getSelectionType() == SelectionType.EAGER) {
                joins += " *" + eRel.getName();
              }
            }

            String extraWurbletOptions = rel.getSelectionWurbletArguments();
            if (extraWurbletOptions == null) {
              extraWurbletOptions = "";
            }
            else {
              extraWurbletOptions = " " + extraWurbletOptions;
            }
            String wurbletArgs = createRelationWurbletArgString(rel);
            if (wurbletArgSet.add(wurbletArgs)) {
              out.print(source[457]); // 1603:2 = "  // selects "
              out.print(rel);
              out.print(source[458]); // 1605:20 = ""
              if (rel.isReversed()) {
                out.print(source[459]); // 1608:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[460]); // 1609:54 = " PdoSelectUnique "
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[461]); // 1609:118 = ""
              }
              else {
                out.print(source[462]); // 1613:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[463]); // 1614:54 = " PdoSelectList "
                out.print(trackedOption);
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[464]); // 1614:133 = ""
              }
            }
          }
        }
      }
    }

    if (generateDeletes && isEntityPersistable()) {
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null && rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[465]); // 1631:2 = "  // deletes "
            out.print(rel);
            out.print(source[466]); // 1633:20 = "  // @wurblet "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[467]); // 1634:58 = " PdoDeleteBy "
            out.print(createRelationWurbletArgString(rel));
            out.print(source[468]); // 1634:110 = ""
          }
        }
      }
    }

    if (generateAddReferencing) {
      List<Relation> refRels = new ArrayList<>();
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          refRels.add(rel);
        }
      }
      if (!refRels.isEmpty()) {
        out.print(source[469]); // 1651:2 = "  // add referencing classes and their ..."
        if (getEntity().isAbstract()) {
          out.print(source[470]); // 1657:2 = "    @SuppressWarnings("unchecked")"
        }
        out.print(source[471]); // 1661:2 = "    AbstractPersistentObject<?,?> po = (..."
        out.print(pdoName);
        out.print(source[472]); // 1663:30 = ".class).getPersistenceDelegate();"
      // register referencing classes and the methods
      for (Relation rel: refRels) {
        String methodName = "isReferencing" + rel.getClassName() + "By" +
                            StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
        for (Entity leaf: rel.getEntity().getLeafEntities()) {
          out.print(source[473]); // 1670:2 = "    po.addReferencingClass("
          out.print(leaf.getName());
          out.print(source[474]); // 1671:45 = ".class, ""
          out.print(methodName);
          out.print(source[475]); // 1671:68 = "");"
        }
      }
      out.print(source[476]); // 1675:2 = "  }"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
