// wurblet generated by Wurbelizer 8.2.2.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk&gt;:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    boolean isPdo;
    try {
      pdoClass = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
    }

    if (isRemote() && isPdo) {
      new RemoteIncludes(this);   // create RMI-files if they don't exist yet
      String delegateType = pdoClass + "RemoteDelegate";
      if (getEntity().isAbstract()) {
        delegateType += "<T,P>";
      }
      out.print(source[0]); // 50:2 = "  @Override  public "
      out.print(delegateType);
      out.print(source[1]); // 53:25 = " getRemoteDelegate() {    return ("
      out.print(delegateType);
      out.print(source[2]); // 54:28 = ") super.getRemoteDelegate();  }"
    }

    if (getEntity().isAbstract()) {
      if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
        out.print(source[3]); // 61:2 = "  @Override  public boolean isExplicit..."
      }
    }
    else {
      if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[4]); // 72:2 = "  @Override  public boolean isClassIdR..."
      }
    }

    boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

    boolean readOnly = getEntity().getOptions().isReadOnly();
    if (readOnly) {
      out.print(source[5]); // 86:2 = "  @Override  public boolean isImmutabl..."
    }

    if (getEntity().getSuperEntity() == null) {

      if (getEntity().getOptions().isRoot()) {
        out.print(source[6]); // 98:2 = "  @Override  public boolean isRootEnti..."
      }

      if (getEntity().getOptions().isTableSerialProvided()) {
        out.print(source[7]); // 108:2 = "  @Override  public boolean isTableSer..."
      }

      if (getEntity().getOptions().isTokenLockProvided()) {
        out.print(source[8]); // 118:2 = "  @Override  public boolean isTokenLoc..."
      }

      if (getEntity().getOptions().isNormTextProvided()) {
        out.print(source[9]); // 128:2 = "  @Override  public boolean isNormText..."
      }

      if (getEntity().getOptions().isRootIdProvided()) {
        out.print(source[10]); // 138:2 = "  @Override  public boolean isRootIdPr..."
      }
      else {
        Attribute rootAttribute = getEntity().getRootAttribute();
        if (rootAttribute != null) {

          out.print(source[11]); // 150:2 = "  @Override  public long getRootId() {..."
          out.print(rootAttribute.getName());
          out.print(source[12]); // 154:38 = ";  }"
        }
      }

      if (getEntity().getOptions().isRootClassIdProvided()) {
        out.print(source[13]); // 161:2 = "  @Override  public boolean isRootClas..."
      }
      else {
        Entity rootEntity = getEntity().getRootEntity();
        if (rootEntity != null) {
          out.print(source[14]); // 172:2 = "  @Override  public int getRootClassId..."
          out.print(rootEntity.getClassId());
          out.print(source[15]); // 176:38 = ";  }"
        }
      }

      if (isTracked())  {
        out.print(source[16]); // 183:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[17]); // 194:2 = "  @Override  public void setModified(b..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod())    {
          if (isFullTracked()) {
            out.print(source[18]); // 204:2 = "      "
            out.print(attr.getName());
            out.print(source[19]); // 205:24 = "Persisted = "
            out.print(attr.getName());
            out.print(source[20]); // 205:54 = ";"
          }
          else {
            out.print(source[21]); // 209:2 = "      "
            out.print(attr.getName());
            out.print(source[22]); // 210:24 = "Modified = false;"
          }
        }
      }
      out.print(source[23]); // 215:2 = "    }  }"
    }


    if (isFullTracked()) {
      out.print(source[24]); // 223:2 = "  @Override  public boolean differsPer..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod() && !attr.getOptions().isDerived() &&
            !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
          if (attr.getDataType().isPrimitive()) {
            out.print(source[25]); // 233:2 = "           || "
            out.print(attr.getName());
            out.print(source[26]); // 234:32 = "Persisted != "
            out.print(attr.getName());
            out.print(source[27]); // 234:63 = ""
          }
          else {
            out.print(source[28]); // 238:2 = "           || !Objects.equals("
            out.print(attr.getName());
            out.print(source[29]); // 239:48 = "Persisted, "
            out.print(attr.getName());
            out.print(source[30]); // 239:77 = ")"
          }
        }
      }
      out.print(source[31]); // 244:2 = "           ;  }  @Override  public b..."
    }

    if (!getEntity().getInheritanceType().isMappingToNoTable()) {
      String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
      if (orderBy != null) {
        out.print(source[32]); // 258:2 = "  @Override  public String orderBy() {..."
        out.print(orderBy);
        out.print(source[33]); // 263:18 = ";    return sql.toString();  }"
      }
      out.print(source[34]); // 268:2 = "  @Override  public void getFields(Res..."
      boolean needIfClause = false;
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            needIfClause = true;
            break;
          }
        }
      }
      if (needIfClause) {
        out.print(source[35]); // 284:2 = "    if (rs.configureSection(CLASSVARIABL..."
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isDerived())  {
            for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
              String name = attr.getName().toUpperCase() + sp.getPostfix();
              out.print(source[36]); // 291:2 = "      rs.configureColumn(CN_"
              out.print(name);
              out.print(source[37]); // 292:36 = ");"
            }
          }
        }
        out.print(source[38]); // 297:2 = "    }"
      }
      else {
        out.print(source[39]); // 302:2 = "    rs.configureSection(CLASSVARIABLES);..."
      }
      out.print(source[40]); // 306:2 = "    if (rs.getRow() <= 0) {      throw ..."
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          String getterMethod = createJdbcGetterName(attr);
          String name = attr.getName().toUpperCase();
          boolean useSetter = isSetGetRequired(attr);

          if (attr.getDataType() == DataType.BINARY) {
            // Binary getter takes additional buffer size argument
            if (useSetter)  {
              out.print(source[41]); // 320:2 = "    "
              out.print(attr.getSetterName());
              out.print(source[42]); // 321:28 = "(rs."
              out.print(getterMethod);
              out.print(source[43]); // 321:48 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[44]); // 321:78 = "));"
            }
            else  {
              out.print(source[45]); // 325:2 = "    "
              out.print(attr.getName());
              out.print(source[46]); // 326:22 = " = rs."
              out.print(getterMethod);
              out.print(source[47]); // 326:44 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[48]); // 326:74 = ");"
            }
          }

          else  {
            String rsGetter = "rs." + getterMethod + "(";
            boolean needComma = false;
            if (attr.getOptions().isWithTimezone()) {
              rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
              needComma = true;
            }
            if (attr.getOptions().isMapNull()) {
              if (needComma) {
                rsGetter += ", ";
              }
              rsGetter += "true";
              needComma = true;
            }
            rsGetter += ")";

            String modelCode = getModelCode(attr, rsGetter);

            if (attr.getOptions().isTrimRead()) {
              modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSizeWithDefault() + ")";
            }

            if (useSetter) {
              modelCode = attr.getSetterName() + "(" + modelCode + ")";
            }
            else  {
              modelCode = attr.getName() + " = " + modelCode;
            }
            out.print(source[49]); // 359:2 = "    "
            out.print(modelCode);
            out.print(source[50]); // 360:17 = ";"
            if (attr.getOptions().isUTC()) {
              if (useSetter) {
                modelCode = attr.getGetterName() + "()";
              }
              else  {
                modelCode = attr.getName();
              }
              out.print(source[51]); // 369:2 = "    if ("
              out.print(modelCode);
              out.print(source[52]); // 370:21 = " != null) {      "
              out.print(modelCode);
              out.print(source[53]); // 371:19 = ".setUTC(true);    }"
            }
          }
        }
      }
      out.print(source[54]); // 378:2 = "  }"
      if (!readOnly) {
        if (multiInheritance) {
          out.print(source[55]); // 383:2 = "  /**   * Sets the values of all "
          out.print(pdoClass);
          out.print(source[56]); // 386:40 = "-columns in the given statement.   *  ..."
          out.print(pdoClass);
          out.print(source[57]); // 391:34 = "(PreparedStatementWrapper st) {    int ..."
        }
        else  {
          out.print(source[58]); // 396:2 = "  @Override  public int setFields(Prep..."
        }

        for (Attribute attr: getEntity().getMappedAttributes()) {
          if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly())  {
            String setterName = createJdbcSetterName(attr);

            String modelCode;
            if (isSetGetRequired(attr)) {
              modelCode = attr.getGetterName() + "()";
            }
            else {
              modelCode = attr.getName();
            }

            String jdbcCode = getJdbcCode(attr, modelCode);

            if (attr.getOptions().isTrimWrite()) {
              jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSizeWithDefault() + ")";
            }

            jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
            if (attr.getOptions().isWithTimezone()) {
              jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
            }
            if (attr.getOptions().isMapNull()) {
              jdbcCode += ", true)";
            }
            else  {
              jdbcCode += ")";
            }
            out.print(source[59]); // 432:2 = "    "
            out.print(jdbcCode);
            out.print(source[60]); // 433:16 = ";"

            // for multi column types, such as BMoney/DMoney
            for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
              out.print(source[61]); // 438:2 = "    ++ndx;"
            }
          }
        }

        if (multiInheritance && getEntity().getSuperEntity() != null) {
          out.print(source[62]); // 446:2 = "    st.setLong(++ndx, getId());"
        }
        out.print(source[63]); // 450:2 = "    return ndx;  }"
      }
    }

    if (getEntity().getInheritanceType().isMappingToOwnTable()) {

      List<Attribute> attributes = multiInheritance ?
                                      getEntity().getTableAttributes() : getEntity().getAttributesIncludingInherited();
      List<String> names = new ArrayList<>();

      if (!readOnly) {
        for (Attribute attr: attributes)  {
          if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly()) {
            for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
              String name = attr.getName().toUpperCase() + sp.getPostfix();
              names.add(name);
            }
          }
        }

        if (multiInheritance) {
          out.print(source[64]); // 474:2 = "  /**   * Creates the SQL code for the..."
          out.print(pdoClass);
          out.print(source[65]); // 477:46 = " insert statement.   *   * @return the..."
          out.print(pdoClass);
          out.print(source[66]); // 481:43 = "() {"
        }
        else  {
          out.print(source[67]); // 485:2 = "  @Override  public String createInser..."
        }
        out.print(source[68]); // 491:2 = "    return Backend.SQL_INSERT_INTO + "
        out.print(multiInheritance ? "CLASSVARIABLES." : "");
        out.print(source[69]); // 492:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."

        int count = 0;
        for (String name: names) {
          String lineSep = count == names.size() - 1 ? " +" : " + Backend.SQL_COMMA +";
          out.print(source[70]); // 498:2 = "           CN_"
          out.print(name);
          out.print(lineSep);
          out.print(source[71]); // 499:33 = ""
          count++;
        }
        out.print(source[72]); // 503:2 = "           Backend.SQL_INSERT_VALUES +"
        while (--count > 0)	{
          out.print(source[73]); // 507:2 = "           Backend.SQL_PAR_COMMA +"
        }
        out.print(source[74]); // 511:2 = "           Backend.SQL_PAR + Backend.SQL..."

        names.clear();
        for (Attribute attr: attributes)  {
          if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
            for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
              String name = attr.getName().toUpperCase() + sp.getPostfix();
              names.add(name);
            }
          }
        }

        if (multiInheritance) {
          out.print(source[75]); // 527:2 = "  /**   * Creates the SQL code for the..."
          out.print(pdoClass);
          out.print(source[76]); // 530:46 = " update statement.   *   * @return the..."
          out.print(pdoClass);
          out.print(source[77]); // 534:43 = "() {"
        }
        else  {
          out.print(source[78]); // 538:2 = "  @Override  public String createUpdat..."
        }
        out.print(source[79]); // 544:2 = "    return Backend.SQL_UPDATE + "
        out.print(multiInheritance ? "CLASSVARIABLES." : "");
        out.print(source[80]); // 545:77 = "getTableName() + Backend.SQL_SET +"
        boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
        int ncnt = 0;
        for (String name: names) {
          ncnt++;
          if (!checkSerial && ncnt == names.size()) {
            out.print(source[81]); // 552:2 = "           CN_"
            out.print(name);
            out.print(source[82]); // 553:22 = " + Backend.SQL_EQUAL_PAR +"
          }
          else {
            out.print(source[83]); // 557:2 = "           CN_"
            out.print(name);
            out.print(source[84]); // 558:22 = " + Backend.SQL_EQUAL_PAR_COMMA +"
          }
        }

        if (ncnt == 0 && !checkSerial) {
          // special case: no attributes and no checkserial
          out.print(source[85]); // 565:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
        }

        if (checkSerial) {
          out.print(source[86]); // 571:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
        }
        else  {
          out.print(source[87]); // 578:2 = "           Backend.SQL_WHERE + CN_ID + B..."
        }
        out.print(source[88]); // 582:2 = "  }"
      }
    }

    if (multiInheritance) {
      // create joinable sql selects with table aliases
      Entity topEntity = getEntity().getTopSuperEntity();
      List<Entity> chain = topEntity.getInheritanceChain(getEntity());
      List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
      String topImplClass = deriveClassNameForEntity(topEntity);

      if (!readOnly) {
        out.print(source[89]); // 596:2 = "  /**   * Creates the SQL code for the..."
        out.print(pdoClass);
        out.print(source[90]); // 599:46 = " delete statement.   *   * @return the..."
        out.print(pdoClass);
        out.print(source[91]); // 603:43 = "() {"
        if (getEntity().isRootOfInheritanceHierarchy()) {
          out.print(source[92]); // 606:2 = "    return Backend.SQL_DELETE + Backend...."
        }
        else  {
          out.print(source[93]); // 613:2 = "    return Backend.SQL_DELETE + Backend...."
        }
        out.print(source[94]); // 618:2 = "  }"
      }
      out.print(source[95]); // 622:2 = "  @Override  public StringBuilder crea..."
      boolean needComma = false;
      for (Entity entity: chain) {
        String implClass = deriveClassNameForEntity(entity);
        out.print(source[96]); // 631:2 = "    sql."
        out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
        out.print(source[97]); // 632:57 = "append("
        out.print(implClass);
        out.print(source[98]); // 632:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
        needComma = true;
        if (entity == topEntity) {
          for (Entity sub: subs) {
            implClass = deriveClassNameForEntity(sub);
            out.print(source[99]); // 638:2 = "    sql.append(Backend.SQL_COMMA).append..."
            out.print(implClass);
            out.print(source[100]); // 639:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
          }
        }
      }
      out.print(source[101]); // 644:2 = "    sql.append(Backend.SQL_FROM);    sq..."
      out.print(topImplClass);
      out.print(source[102]); // 646:31 = ".CLASSVARIABLES.getTableName()).       ..."
      out.print(topImplClass);
      out.print(source[103]); // 647:76 = ".CLASSVARIABLES.getTableAlias());"
      if (chain.size() > 1) {
        for (Entity entity: chain.subList(1, chain.size())) {
          String implClass = deriveClassNameForEntity(entity);
          out.print(source[104]); // 652:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[105]); // 654:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[106]); // 654:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[107]); // 655:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[108]); // 656:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
      }

      for (Entity sub: subs) {
        String implClass = deriveClassNameForEntity(sub);
        out.print(source[109]); // 663:2 = "    sql.append(getBackend().sqlJoin(Join..."
        out.print(implClass);
        out.print(source[110]); // 665:28 = ".CLASSVARIABLES.getTableName(), "
        out.print(implClass);
        out.print(source[111]); // 665:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
        out.print(topImplClass);
        out.print(source[112]); // 666:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
        out.print(implClass);
        out.print(source[113]); // 667:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
      }
      out.print(source[114]); // 670:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
      String implClass = deriveClassNameForEntity(topEntity);
      out.print(source[115]); // 676:2 = "  @Override  public StringBuilder crea..."
      out.print(implClass);
      out.print(source[116]); // 682:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

      if (getEntity().isRootOfInheritanceHierarchy()) {
        out.print(source[117]); // 689:2 = "  @Override  protected void updateImpl..."
        out.print(pdoClass);
        out.print(source[118]); // 693:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[119]); // 694:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[120]); // 700:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[121]); // 701:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[122]); // 707:122 = ");    st.setLong(1, getId());    st.se..."
      }
      else  {
        out.print(source[123]); // 715:2 = "  @Override  protected void updateImpl..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[124]); // 718:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[125]); // 721:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[126]); // 722:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[127]); // 727:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[128]); // 730:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[129]); // 731:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[130]); // 736:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[131]); // 738:122 = ");    st.setLong(1, getId());    asser..."
      }
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet()) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[132]); // 753:2 = "  /**   * no accessor methods for "
          out.print(attr);
          out.print(source[133]); // 756:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[134]); // 757:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[135]); // 769:2 = "  // "
          out.print(attr);
          out.print(source[136]); // 771:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.getOptions().isHidden()) {
            out.print(source[137]); // 776:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[138]); // 779:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[139]); // 781:48 = "   */"
          }
          else {
            out.print(source[140]); // 786:2 = "  @Override"
          }
          out.print(source[141]); // 791:2 = "  "
          out.print(protection);
          out.print(source[142]); // 792:16 = " "
          out.print(type);
          out.print(source[143]); // 792:25 = " "
          out.print(getter);
          out.print(source[144]); // 792:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[145]); // 793:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[146]); // 799:2 = "  // "
          out.print(attr);
          out.print(source[147]); // 801:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.getOptions().isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[148]); // 814:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[149]); // 817:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[150]); // 819:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[151]); // 819:66 = "   */"
          }
          else {
            out.print(source[152]); // 824:2 = "  @Override"
          }
          out.print(source[153]); // 829:2 = "  "
          out.print(setterProtection);
          out.print(source[154]); // 830:22 = " void "
          out.print(setter);
          out.print(source[155]); // 830:38 = "("
          out.print(type);
          out.print(source[156]); // 830:47 = " "
          out.print(attr.getName());
          out.print(source[157]); // 830:66 = ") {    assertMutable();"
          if (isTracked())  {
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[158]); // 836:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[159]); // 837:31 = " != "
                out.print(attr.getName());
                out.print(source[160]); // 837:53 = ") {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[161]); // 838:60 = ", this."
                out.print(attr.getName());
                out.print(source[162]); // 838:85 = ", "
                out.print(attr.getName());
                out.print(source[163]); // 838:105 = ");    }"
              }
              else {
                out.print(source[164]); // 843:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[165]); // 844:47 = ", "
                out.print(attr.getName());
                out.print(source[166]); // 844:67 = ")) {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[167]); // 845:60 = ", this."
                out.print(attr.getName());
                out.print(source[168]); // 845:85 = ", "
                out.print(attr.getName());
                out.print(source[169]); // 845:105 = ");    }"
              }
            }
            else {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[170]); // 852:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[171]); // 853:31 = " != "
                out.print(attr.getName());
                out.print(source[172]); // 853:53 = ") {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[173]); // 857:2 = "      "
                  out.print(attr.getName());
                  out.print(source[174]); // 858:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[175]); // 859:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[176]); // 859:85 = ", "
                  out.print(attr.getName());
                  out.print(source[177]); // 859:105 = ");"
                }
                out.print(source[178]); // 862:2 = "    }"
              }
              else  {
                out.print(source[179]); // 867:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[180]); // 868:47 = ", "
                out.print(attr.getName());
                out.print(source[181]); // 868:67 = ")) {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[182]); // 872:2 = "      "
                  out.print(attr.getName());
                  out.print(source[183]); // 873:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[184]); // 874:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[185]); // 874:85 = ", "
                  out.print(attr.getName());
                  out.print(source[186]); // 874:105 = ");"
                }
                out.print(source[187]); // 877:2 = "    }"
              }
            }
          }
          out.print(source[188]); // 883:2 = "    this."
          out.print(attr.getName());
          out.print(source[189]); // 884:27 = " = "
          out.print(attr.getName());
          out.print(source[190]); // 884:48 = ";"
          if (type.equals("Timestamp")) {
            out.print(source[191]); // 887:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[192]); // 888:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[193]); // 888:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[194]); // 892:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[195]); // 893:39 = ");"
          }
          out.print(source[196]); // 896:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.getOptions().isHidden()) {
              out.print(source[197]); // 901:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[198]); // 904:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[199]); // 906:30 = " has been modified   */"
            }
            else {
              out.print(source[200]); // 911:2 = "  @Override"
            }
            out.print(source[201]); // 916:2 = "  "
            out.print(protection);
            out.print(source[202]); // 917:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[203]); // 917:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[204]); // 921:2 = "    return "
                out.print(attr.getName());
                out.print(source[205]); // 922:29 = " != "
                out.print(attr.getName());
                out.print(source[206]); // 922:51 = "Persisted;"
              }
              else {
                out.print(source[207]); // 926:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[208]); // 927:45 = ", "
                out.print(attr.getName());
                out.print(source[209]); // 927:65 = "Persisted);"
              }
            }
            else {
              out.print(source[210]); // 932:2 = "    return "
              out.print(attr.getName());
              out.print(source[211]); // 933:29 = "Modified;"
            }
            out.print(source[212]); // 936:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.getOptions().isHidden()) {
              out.print(source[213]); // 943:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[214]); // 946:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[215]); // 953:2 = "  @Override"
            }
            out.print(source[216]); // 958:2 = "  "
            out.print(protection);
            out.print(source[217]); // 959:16 = " "
            out.print(attr.getJavaType());
            out.print(source[218]); // 959:39 = " "
            out.print(getter);
            out.print(source[219]); // 959:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[220]); // 960:29 = "Persisted;  }"
          }
        }
      }
    }

    if (isPdo && generateSnapshot) {

      // createAttributesInSnapshot isnt necessary anymore since 2.2.x

      boolean needRevertAttributes = false;
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isSetGet()) {
          needRevertAttributes = true;
          break;
        }
      }

      if (needRevertAttributes) {
        out.print(source[221]); // 981:2 = "  /**   * Copies all attributes from a..."
        out.print(mainClass);
        out.print(getEntity().isAbstract() ? "<T,?>" : "");
        out.print(source[222]); // 988:100 = " snapshot) {    super.revertAttributesT..."
        for (Attribute attr: getEntity().getAttributes()) {
          if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet())    {
            String name = attr.getName();
            out.print(source[223]); // 994:2 = "    // "
            out.print(attr.getOptions().getComment());
            out.print(source[224]); // 995:41 = "    "
            out.print(name);
            out.print(source[225]); // 996:12 = " = snapshot."
            out.print(name);
            out.print(source[226]); // 996:32 = ";"
            if (isAttracked()) {
              if (isFullTracked()) {
                out.print(source[227]); // 1000:2 = "    "
                out.print(name);
                out.print(source[228]); // 1001:12 = "Persisted = snapshot."
                out.print(name);
                out.print(source[229]); // 1001:41 = "Persisted;"
              }
              else {
                out.print(source[230]); // 1005:2 = "    "
                out.print(name);
                out.print(source[231]); // 1006:12 = "Modified = snapshot."
                out.print(name);
                out.print(source[232]); // 1006:40 = "Modified;"
              }
            }
          }
        }
        out.print(source[233]); // 1012:2 = "  }"
      }
    }

    if (generateSelectByUDK) {
      List<Attribute> udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        List<Attribute> superUdk = null;
        if (getEntity().getSuperEntity() != null) {
          superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
        }
        if (superUdk == null || !udk.equals(superUdk)) {
          Set<Entity> components = getEntity().getAllComponents();
          StringBuilder attribs = new StringBuilder();
          for (Attribute attribute: udk) {
            if (attribs.length() != 0) {
              attribs.append(" ");
            }
            if (components.contains(attribute.getEntity())) {
              attribs.append(attribute.getEntity()).append(".");
            }
            attribs.append(attribute.getName());
          }
          out.print(source[234]); // 1037:2 = "  // selects by unique domain key  // ..."
          out.print(attribs);
          out.print(source[235]); // 1040:66 = ""
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
