/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.tentackle.buildsupport.codegen.AbstractGenerator;
import org.tentackle.buildsupport.codegen.GeneratedFile;
import org.tentackle.buildsupport.codegen.TemplateModel;
import org.tentackle.common.NamingRules;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.wurblet.ModelWurblet;
import org.wurbelizer.wurbel.HeapStream;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelTerminationException;
import org.wurbelizer.wurbel.Wurbler;

public class RemoteIncludes {
    private final ModelWurblet wurblet;
    private final Entity entity;
    private final String className;
    private final String packageName;
    private final String superClassName;
    private final HeapStream interfaceStream;
    private final HeapStream implementationStream;
    private final String popInterface;
    private final String remotePackage;
    private final String remoteInterface;
    private final String remoteImplPackage;
    private final String remoteImplementation;
    private TemplatePars templatePars;

    public RemoteIncludes(ModelWurblet wurblet) throws WurbelException {
        this.wurblet = wurblet;
        this.className = wurblet.getClassName();
        this.entity = wurblet.getEntity();
        this.superClassName = this.entity != null && this.entity.getSuperEntityName() != null ? this.entity.getSuperEntityName() : StringHelper.getPlainClassName((String)wurblet.getSuperClassName());
        this.packageName = wurblet.getPackageName();
        this.popInterface = this.determinePopInterface(wurblet);
        NamingRules namingRules = NamingRules.getInstance();
        Wurbler container = wurblet.getContainer();
        if (wurblet.isOperation()) {
            this.remotePackage = namingRules.getOperationRemoteInterfacePackageName(this.packageName);
            this.remoteInterface = namingRules.getOperationRemoteInterface(this.popInterface);
            this.remoteImplPackage = namingRules.getOperationRemoteImplementationPackageName(this.packageName);
            this.remoteImplementation = namingRules.getOperationRemoteImplementation(this.popInterface);
        } else {
            this.remotePackage = namingRules.getPdoRemoteInterfacePackageName(this.packageName);
            this.remoteInterface = namingRules.getPdoRemoteInterface(this.popInterface);
            this.remoteImplPackage = namingRules.getPdoRemoteImplementationPackageName(this.packageName);
            this.remoteImplementation = namingRules.getPdoRemoteImplementation(this.popInterface);
        }
        String dirName = container.getProperty("wurblet", "dirname");
        String packagePath = this.packageName.replace('.', File.separatorChar);
        int ndx = dirName.indexOf(packagePath);
        String pathPrefix = ndx > 0 ? dirName.substring(0, ndx) : "";
        String remoteDirName = pathPrefix + File.separator + this.remotePackage.replace('.', File.separatorChar);
        String remoteImplDirName = pathPrefix + File.separator + this.remoteImplPackage.replace('.', File.separatorChar);
        this.interfaceStream = new HeapStream(container, this.remoteInterface + "/methods");
        this.checkFile(remoteDirName, this.remoteInterface, "RemoteInterface.ftl");
        this.implementationStream = new HeapStream(container, this.remoteImplementation + "/methods");
        this.checkFile(remoteImplDirName, this.remoteImplementation, "RemoteImplementation.ftl");
    }

    public void discard() {
        this.implementationStream.discard();
        this.interfaceStream.discard();
    }

    public PrintStream getInterfaceStream() {
        return this.interfaceStream.getStream();
    }

    public PrintStream getImplementationStream() {
        return this.implementationStream.getStream();
    }

    private String determinePopInterface(ModelWurblet wurblet) throws WurbelException {
        String popInterface = null;
        try {
            popInterface = wurblet.getPdoClassName();
        }
        catch (WurbelException wurbelException) {
            // empty catch block
        }
        if (popInterface == null) {
            popInterface = wurblet.getClassName();
        }
        return popInterface;
    }

    private void checkFile(String dirName, String remoteName, String templateName) throws WurbelException {
        File dir = new File(dirName);
        File file = new File(dir, remoteName + ".java");
        if (!file.exists()) {
            dir.mkdirs();
            if (this.templatePars == null) {
                this.templatePars = new TemplatePars(this);
            }
            try {
                new GeneratedFile(this.templatePars.generator.createFreemarkerConfiguration(), (Map)this.templatePars.model, templateName, file).generate();
            }
            catch (TemplateException | IOException e) {
                throw new WurbelTerminationException("cannot generate " + String.valueOf(file) + " from " + templateName, e);
            }
        }
    }

    private final class TemplatePars {
        private final TemplateModel model;
        private final AbstractGenerator generator;

        private TemplatePars(final RemoteIncludes remoteIncludes) throws WurbelException {
            String superImplementation;
            String superPackage;
            String superInterface;
            NamingRules namingRules = NamingRules.getInstance();
            String popPackage = remoteIncludes.wurblet.determinePackageName(remoteIncludes.popInterface);
            String superImplPackage = switch (remoteIncludes.superClassName) {
                case "AbstractPersistentObject" -> {
                    superInterface = "AbstractPersistentObjectRemoteDelegate";
                    superPackage = "org.tentackle.persist.rmi";
                    superImplementation = "AbstractPersistentObjectRemoteDelegateImpl";
                    yield "org.tentackle.persist.rmi";
                }
                case "AbstractPersistentOperation" -> {
                    superInterface = "AbstractPersistentOperationRemoteDelegate";
                    superPackage = "org.tentackle.persist.rmi";
                    superImplementation = "AbstractPersistentOperationRemoteDelegateImpl";
                    yield "org.tentackle.persist.rmi";
                }
                case "AbstractDbObject" -> {
                    superInterface = "AbstractDbObjectRemoteDelegate";
                    superPackage = "org.tentackle.dbms.rmi";
                    superImplementation = "AbstractDbObjectRemoteDelegateImpl";
                    yield "org.tentackle.dbms.rmi";
                }
                default -> {
                    String superClassPackageName = remoteIncludes.wurblet.determinePackageName(remoteIncludes.superClassName);
                    if (remoteIncludes.wurblet.isOperation()) {
                        superInterface = namingRules.getOperationRemoteInterface(remoteIncludes.superClassName);
                        superPackage = namingRules.getOperationRemoteInterfacePackageName(superClassPackageName);
                        superImplementation = namingRules.getOperationRemoteImplementation(remoteIncludes.superClassName);
                        yield namingRules.getOperationRemoteImplementationPackageName(superClassPackageName);
                    }
                    superInterface = namingRules.getPdoRemoteInterface(remoteIncludes.superClassName);
                    superPackage = namingRules.getPdoRemoteInterfacePackageName(superClassPackageName);
                    superImplementation = namingRules.getPdoRemoteImplementation(remoteIncludes.superClassName);
                    yield namingRules.getPdoRemoteImplementationPackageName(superClassPackageName);
                }
            };
            this.model = new TemplateModel();
            if (remoteIncludes.wurblet.isOperation()) {
                this.model.putValue("operationInterface", (Object)remoteIncludes.popInterface);
                this.model.putValue("operationPackage", (Object)popPackage);
                String sourceText = remoteIncludes.wurblet.getContainer().getProperty("wurblet", "filecontents");
                this.model.putValue("abstractOperation", (Object)(sourceText != null && Pattern.compile("\\s+extends\\s+" + remoteIncludes.popInterface + "\\s*<").matcher(sourceText).find() ? 1 : 0));
            } else {
                this.model.putValue("pdoInterface", (Object)remoteIncludes.popInterface);
                this.model.putValue("pdoPackage", (Object)popPackage);
                this.model.putValue("pdoInheritance", remoteIncludes.entity != null ? remoteIncludes.entity.getInheritanceType() : "");
            }
            this.model.putValue("persistenceImplementation", (Object)remoteIncludes.className);
            this.model.putValue("persistenceImplPackage", (Object)remoteIncludes.packageName);
            this.model.putValue("remoteInterface", (Object)remoteIncludes.remoteInterface);
            this.model.putValue("remotePackage", (Object)remoteIncludes.remotePackage);
            this.model.putValue("remoteImplementation", (Object)remoteIncludes.remoteImplementation);
            this.model.putValue("remoteImplPackage", (Object)remoteIncludes.remoteImplPackage);
            this.model.putValue("superInterface", (Object)superInterface);
            this.model.putValue("superPackage", (Object)superPackage);
            this.model.putValue("superImplementation", (Object)superImplementation);
            this.model.putValue("superImplPackage", (Object)superImplPackage);
            Object templateDir = remoteIncludes.wurblet.getContainer().getProperty("extra", "templateDir");
            if (templateDir == null) {
                String projectRoot = remoteIncludes.wurblet.getContainer().getProperty("extra", "projectRoot");
                if (projectRoot == null) {
                    throw new WurbelTerminationException("neither the WurbletProperty \"templateDir\" nor \"projectRoot\" were set.");
                }
                templateDir = projectRoot + File.separator + "templates" + File.separator + (remoteIncludes.wurblet.isOperation() ? "operation" : "pdo");
            }
            this.generator = new AbstractGenerator(this){};
            this.generator.setTemplateDirectory(new File((String)templateDir));
        }
    }
}

