/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.wurblet.AnnotationOption;
import org.wurbelizer.wurbel.WurbelException;

public class PdoRelations
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + String.valueOf((Object)this) + " failed", t);
        }
    }

    private void wurbel() throws WurbelException, ModelException {
        String var;
        boolean useDatabaseRefInt;
        String mainClass = this.getClassName();
        String pdoName = null;
        try {
            pdoName = this.getPdoClassName();
        }
        catch (WurbelException we) {
            pdoName = this.getClassName();
        }
        boolean generateDeclarations = false;
        boolean generateIsModified = false;
        boolean generateIsComposite = false;
        boolean generateSaveReferencingRelations = false;
        boolean generateSaveReferencedRelations = false;
        boolean generateDeleteReferencingRelations = false;
        boolean generateDeleteReferencedRelations = false;
        boolean generateLazyDeleteReferencingRelations = false;
        boolean generateLazyDeleteReferencedRelations = false;
        boolean generateSetSession = false;
        Boolean generateLoadComponents = null;
        Boolean generateInsertComponents = null;
        Boolean generateDeleteComponents = null;
        boolean generateMarkDeleted = false;
        boolean generateIsReferencing = true;
        boolean generateAddReferencing = false;
        boolean generateSelects = true;
        boolean generateDeletes = true;
        Boolean generateValidate = null;
        boolean generateSetImmutable = false;
        boolean generateSnapshot = false;
        boolean generateClearOnRemoteSave = false;
        boolean generateAlignComponents = false;
        boolean generateCreateNormText = false;
        boolean generateMock = false;
        boolean isEffectivelyComposite = this.getEntity().isEffectivelyComposite();
        for (Object rel : this.getEntity().getReferencingRelations()) {
            if (rel.isComposite() || rel.getRelationType() != RelationType.OBJECT || rel.getForeignEntity() == null || !rel.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
            generateAddReferencing = true;
            break;
        }
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("noloadcomponents")) {
                generateLoadComponents = false;
                continue;
            }
            if (arg.equals("noinsertcomponents")) {
                generateInsertComponents = false;
                continue;
            }
            if (arg.equals("nodeletecomponents")) {
                generateDeleteComponents = false;
                continue;
            }
            if (arg.equals("novalidate")) {
                generateValidate = false;
                continue;
            }
            if (arg.equals("loadcomponents")) {
                generateLoadComponents = true;
                continue;
            }
            if (arg.equals("insertcomponents")) {
                generateInsertComponents = true;
                continue;
            }
            if (arg.equals("deletecomponents")) {
                generateDeleteComponents = true;
                continue;
            }
            if (arg.equals("nori")) {
                generateIsReferencing = false;
                generateAddReferencing = false;
                continue;
            }
            if (arg.equals("noselects")) {
                generateSelects = false;
                continue;
            }
            if (arg.equals("nodeletes")) {
                generateDeletes = false;
                continue;
            }
            if (!"mock".equals(arg)) continue;
            generateMock = true;
        }
        for (Object rel : this.getEntity().getRelations()) {
            if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                generateDeclarations = true;
                if (!rel.isSelectionCached()) {
                    generateSetSession = true;
                }
            }
            if (rel.isPartOfNormText()) {
                generateCreateNormText = true;
            }
            if (rel.isComposite()) {
                generateIsComposite = true;
                generateDeclarations = true;
                generateIsModified = true;
                generateSetSession = true;
                generateMarkDeleted = isEffectivelyComposite;
                generateSnapshot = true;
                generateSetImmutable = true;
                if (generateValidate == null && this.getAnnotationOptions(rel.getAnnotations(), "Validate").isEmpty()) {
                    generateValidate = true;
                }
                if (!rel.isEmbedding()) {
                    if (rel.getRelationType() == RelationType.OBJECT) {
                        generateSaveReferencedRelations = true;
                        generateDeleteReferencedRelations = true;
                        generateLazyDeleteReferencedRelations = true;
                    } else {
                        generateSaveReferencingRelations = true;
                        generateDeleteReferencingRelations = true;
                        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                            generateLazyDeleteReferencingRelations = true;
                            if (rel.getCountAttribute() != null) {
                                generateAlignComponents = true;
                            }
                        }
                    }
                }
            }
            if (!rel.isClearOnRemoteSave()) continue;
            generateClearOnRemoteSave = true;
        }
        boolean bl = useDatabaseRefInt = this.getEntity().getIntegrity().isCompositesCheckedByDatabase() && Boolean.FALSE.equals(this.getEntity().isDeletionCascaded());
        if (generateLoadComponents == null) {
            generateLoadComponents = generateIsComposite;
        }
        if (generateInsertComponents == null) {
            generateInsertComponents = generateIsComposite && isEffectivelyComposite;
        }
        if (generateDeleteComponents == null) {
            generateDeleteComponents = generateIsComposite && isEffectivelyComposite && (!useDatabaseRefInt || this.getEntity().isRootEntity());
        }
        if (generateDeclarations || generateMock) {
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite() || generateMock) {
                    String type = rel.getDeclaredJavaType(false);
                    String transientModifier = this.isRelationTransient((Relation)rel) ? "transient " : "";
                    this.out.print(this.source[0]);
                    this.out.print(rel);
                    this.out.print(this.source[1]);
                    this.out.print(transientModifier);
                    this.out.print(type);
                    this.out.print(this.source[2]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[3]);
                    if (!generateMock) {
                        if (!(rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER || rel.getForeignRelation() != null && rel.getForeignRelation().isEmbedding())) {
                            this.out.print(this.source[4]);
                            this.out.print(transientModifier);
                            this.out.print(this.source[5]);
                            this.out.print(rel.getVariableName());
                            this.out.print(this.source[6]);
                        }
                        if (rel.isComposite()) {
                            if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
                                this.out.print(this.source[7]);
                                this.out.print(type);
                                this.out.print(this.source[8]);
                                this.out.print(rel.getVariableName());
                                this.out.print(this.source[9]);
                            }
                            if (rel.getRelationType() == RelationType.OBJECT && !rel.isEmbedding()) {
                                this.out.print(this.source[10]);
                                this.out.print(rel.getVariableName());
                                this.out.print(this.source[11]);
                            }
                        }
                    }
                }
                if (rel.getNmName() == null) continue;
                Object nmVar = rel.getNmMethodName() != null ? StringHelper.firstToLower((String)rel.getNmMethodName()) : StringHelper.firstToLower((String)rel.getNmName()) + "List";
                this.out.print(this.source[12]);
                this.out.print(rel.getNmRelation().getDeclaredJavaType(false));
                this.out.print(this.source[13]);
                this.out.print((String)nmVar);
                this.out.print(this.source[14]);
            }
        }
        if (generateClearOnRemoteSave && !generateMock) {
            this.out.print(this.source[15]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isClearOnRemoteSave()) continue;
                this.out.print(this.source[16]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[17]);
                if (rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
                this.out.print(this.source[18]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[19]);
            }
            this.out.print(this.source[20]);
        }
        for (Object rel : this.getEntity().getRelations()) {
            String linkMethodName;
            var = rel.getVariableName();
            String type = rel.getDeclaredJavaType(false);
            String effType = rel.getJavaType();
            String scope = rel.getAccessScope().toString();
            boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
            boolean isEmbeddingFromParent = rel.getForeignRelation() != null && rel.getForeignRelation().isEmbedding();
            boolean createGetter = !rel.isWriteOnly();
            boolean createSetter = !(rel.isReadOnly() || rel.getSelectionType() == SelectionType.ALWAYS && !rel.isSelectionCached() || rel.isComposite() && rel.getRelationType() != RelationType.OBJECT);
            Attribute attr = rel.getAttribute();
            if (attr != null) {
                scope = attr.getOptions().getAccessScope().toString();
                hidden |= attr.isHidden();
                createGetter &= !attr.getOptions().isWriteOnly();
                createSetter &= !attr.getOptions().isReadOnly();
            }
            if (rel.getForeignRelation() != null && (linkMethodName = rel.getForeignRelation().getLinkMethodName()) != null && !rel.getSetterName().equals(linkMethodName)) {
                createSetter = false;
            }
            Relation nmRel = rel.getNmRelation();
            Object nmName = null;
            Object nmVar = null;
            if (nmRel != null) {
                if (rel.getNmMethodName() != null) {
                    nmName = StringHelper.firstToUpper((String)rel.getNmMethodName());
                    nmVar = StringHelper.firstToLower((String)rel.getNmMethodName());
                } else {
                    nmName = StringHelper.firstToUpper((String)rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
                    nmVar = StringHelper.firstToLower((String)rel.getNmName()) + "List";
                }
            }
            if (createGetter) {
                String checkNull = ((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument() + " == 0";
                if (attr != null && !attr.getDataType().isPrimitive()) {
                    checkNull = ((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument() + " == null || " + checkNull;
                }
                this.out.print(this.source[21]);
                if (hidden) {
                    this.out.print(this.source[22]);
                    this.out.print(rel);
                    this.out.print(this.source[23]);
                    this.out.print(var);
                    this.out.print(this.source[24]);
                    this.out.print(rel.getComment());
                    this.out.print(this.source[25]);
                    this.out.print(rel.getOrdinal());
                    this.out.print(this.source[26]);
                    this.out.print(StringHelper.toDoubleQuotes((String)rel.getComment()));
                    this.out.print(this.source[27]);
                } else {
                    this.out.print(this.source[28]);
                }
                if (rel.getForeignEntity().isAbstract()) {
                    this.out.print(this.source[29]);
                }
                if (!generateMock) {
                    for (String annotation : rel.getAnnotations()) {
                        AnnotationOption anno = new AnnotationOption(annotation);
                        if (!anno.isHidden() || anno.isSetterOnly()) continue;
                        this.out.print(this.source[30]);
                        this.out.print(anno.getAnnotation());
                        this.out.print(this.source[31]);
                    }
                }
                this.out.print(this.source[32]);
                this.out.print(scope);
                this.out.print(this.source[33]);
                this.out.print(type);
                this.out.print(this.source[34]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[35]);
                if (generateMock) {
                    this.out.print(this.source[36]);
                    this.out.print(var);
                    this.out.print(this.source[37]);
                } else {
                    if (rel.getSelectionType() == SelectionType.ALWAYS) {
                        if (rel.getRelationType() == RelationType.LIST) {
                            if (rel.isSelectionCached()) {
                                this.out.print(this.source[38]);
                                this.out.print(var);
                                this.out.print(this.source[39]);
                                this.out.print(this.createRelationSelectCode((Relation)rel));
                                this.out.print(this.source[40]);
                            } else {
                                this.out.print(this.source[41]);
                                this.out.print(type);
                                this.out.print(this.source[42]);
                                this.out.print(var);
                                this.out.print(this.source[43]);
                                this.out.print(this.createRelationSelectCode((Relation)rel));
                                this.out.print(this.source[44]);
                            }
                            if (rel.isReferenced()) {
                                if (rel.getLinkMethodIndex() != null) {
                                    this.out.print(this.source[45]);
                                }
                                this.out.print(this.source[46]);
                                this.out.print(rel.getClassName());
                                this.out.print(this.source[47]);
                                this.out.print(var);
                                this.out.print(this.source[48]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[49]);
                            }
                            this.out.print(this.source[50]);
                            this.out.print(var);
                            this.out.print(this.source[51]);
                        } else if (rel.isComposite()) {
                            this.out.print(this.source[52]);
                            this.out.print(var);
                            this.out.print(this.source[53]);
                            this.out.print(checkNull);
                            this.out.print(this.source[54]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[55]);
                            if (rel.isReferenced()) {
                                this.out.print(this.source[56]);
                                this.out.print(var);
                                this.out.print(this.source[57]);
                                this.out.print(var);
                                this.out.print(this.source[58]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[59]);
                            }
                            if (rel.isProcessed()) {
                                this.out.print(this.source[60]);
                                this.out.print(var);
                                this.out.print(this.source[61]);
                                this.out.print(rel.getMethodNameSuffix());
                                this.out.print(this.source[62]);
                                this.out.print(var);
                                this.out.print(this.source[63]);
                            }
                            this.out.print(this.source[64]);
                            this.out.print(var);
                            this.out.print(this.source[65]);
                        } else if (rel.isReferenced()) {
                            this.out.print(this.source[66]);
                            this.out.print(type);
                            this.out.print(this.source[67]);
                            this.out.print(checkNull);
                            this.out.print(this.source[68]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[69]);
                            this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                            this.out.print(this.source[70]);
                        } else {
                            this.out.print(this.source[71]);
                            this.out.print(checkNull);
                            this.out.print(this.source[72]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[73]);
                        }
                    } else if (rel.isEmbedding() || isEmbeddingFromParent) {
                        if (rel.isEmbedding()) {
                            this.out.print(this.source[74]);
                            this.out.print(var);
                            this.out.print(this.source[75]);
                            this.out.print(rel.getSetterName());
                            this.out.print(this.source[76]);
                            this.out.print(rel.getForeignEntity());
                            this.out.print(this.source[77]);
                        }
                        this.out.print(this.source[78]);
                        this.out.print(var);
                        this.out.print(this.source[79]);
                    } else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        this.out.print(this.source[80]);
                        this.out.print(var);
                        this.out.print(this.source[81]);
                        if (rel.isComposite()) {
                            if (rel.getRelationType() == RelationType.LIST) {
                                Object condition = "isNew()";
                                Attribute countAttribute = rel.getCountAttribute();
                                if (countAttribute != null) {
                                    condition = (String)condition + " || " + countAttribute.getName() + " == 0";
                                }
                                this.out.print(this.source[82]);
                                this.out.print(var);
                                this.out.print(this.source[83]);
                                this.out.print((String)condition);
                                this.out.print(this.source[84]);
                                this.out.print(effType);
                                this.out.print(this.source[85]);
                                this.out.print(rel.isTracked() ? "false" : "");
                                this.out.print(this.source[86]);
                                this.out.print(this.createRelationSelectCode((Relation)rel));
                                this.out.print(this.source[87]);
                                if (rel.isReferenced()) {
                                    if (rel.getLinkMethodIndex() != null) {
                                        this.out.print(this.source[88]);
                                    }
                                    this.out.print(this.source[89]);
                                    this.out.print(rel.getClassName());
                                    this.out.print(this.source[90]);
                                    this.out.print(var);
                                    this.out.print(this.source[91]);
                                    this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                    this.out.print(this.source[92]);
                                }
                            } else {
                                this.out.print(this.source[93]);
                                this.out.print(var);
                                this.out.print(this.source[94]);
                                this.out.print(checkNull);
                                this.out.print(this.source[95]);
                                this.out.print(this.createRelationSelectCode((Relation)rel));
                                this.out.print(this.source[96]);
                                if (rel.isReferenced()) {
                                    this.out.print(this.source[97]);
                                    this.out.print(var);
                                    this.out.print(this.source[98]);
                                    this.out.print(var);
                                    this.out.print(this.source[99]);
                                    this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                    this.out.print(this.source[100]);
                                }
                            }
                            if (rel.isProcessed()) {
                                this.out.print(this.source[101]);
                                this.out.print(var);
                                this.out.print(this.source[102]);
                                this.out.print(rel.getMethodNameSuffix());
                                this.out.print(this.source[103]);
                                this.out.print(var);
                                this.out.print(this.source[104]);
                            }
                            if (rel.getRelationType() == RelationType.LIST) {
                                if (rel.isTracked()) {
                                    if (rel.isImmutable()) {
                                        this.out.print(this.source[105]);
                                        this.out.print(var);
                                        this.out.print(this.source[106]);
                                    } else {
                                        this.out.print(this.source[107]);
                                        this.out.print(var);
                                        this.out.print(this.source[108]);
                                    }
                                }
                            } else if (rel.isImmutable()) {
                                this.out.print(this.source[109]);
                                this.out.print(var);
                                this.out.print(this.source[110]);
                            } else {
                                this.out.print(this.source[111]);
                                this.out.print(var);
                                this.out.print(this.source[112]);
                                this.out.print(var);
                                this.out.print(this.source[113]);
                            }
                        } else if (rel.getRelationType() == RelationType.LIST) {
                            this.out.print(this.source[114]);
                            this.out.print(var);
                            this.out.print(this.source[115]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[116]);
                            if (rel.isReferenced()) {
                                if (rel.getLinkMethodIndex() != null) {
                                    this.out.print(this.source[117]);
                                }
                                this.out.print(this.source[118]);
                                this.out.print(rel.getClassName());
                                this.out.print(this.source[119]);
                                this.out.print(var);
                                this.out.print(this.source[120]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[121]);
                            }
                        } else {
                            this.out.print(this.source[122]);
                            this.out.print(var);
                            this.out.print(this.source[123]);
                            this.out.print(checkNull);
                            this.out.print(this.source[124]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[125]);
                            if (rel.isReferenced()) {
                                this.out.print(this.source[126]);
                                this.out.print(var);
                                this.out.print(this.source[127]);
                                this.out.print(var);
                                this.out.print(this.source[128]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[129]);
                            }
                        }
                        this.out.print(this.source[130]);
                        this.out.print(var);
                        this.out.print(this.source[131]);
                        if (nmRel != null) {
                            this.out.print(this.source[132]);
                            this.out.print(var);
                            this.out.print(this.source[133]);
                            this.out.print(rel.getClassName());
                            this.out.print(this.source[134]);
                            this.out.print((String)nmName);
                            this.out.print(this.source[135]);
                            this.out.print(nmRel.getGetterName());
                            this.out.print(this.source[136]);
                            this.out.print(rel.getClassName());
                            this.out.print(this.source[137]);
                            this.out.print((String)nmName);
                            this.out.print(this.source[138]);
                            this.out.print(nmRel.getGetterName());
                            this.out.print(this.source[139]);
                        }
                        this.out.print(this.source[140]);
                        this.out.print(var);
                        this.out.print(this.source[141]);
                    }
                    this.out.print(this.source[142]);
                    if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
                            if (rel.isBluntDeclared()) {
                                this.out.print(this.source[143]);
                            } else {
                                this.out.print(this.source[144]);
                                this.out.print(var);
                                this.out.print(this.source[145]);
                                this.out.print(var);
                                this.out.print(this.source[146]);
                                this.out.print(rel.getComment());
                                this.out.print(this.source[147]);
                            }
                            this.out.print(this.source[148]);
                            this.out.print(scope);
                            this.out.print(this.source[149]);
                            this.out.print(type);
                            this.out.print(this.source[150]);
                            this.out.print(rel.getGetterName());
                            this.out.print(this.source[151]);
                            this.out.print(var);
                            this.out.print(this.source[152]);
                            this.out.print(var);
                            this.out.print(this.source[153]);
                            this.out.print(effType);
                            this.out.print(this.source[154]);
                            this.out.print(rel.isTracked() ? "false" : "");
                            this.out.print(this.source[155]);
                            this.out.print(var);
                            this.out.print(this.source[156]);
                            this.out.print(var);
                            this.out.print(this.source[157]);
                            this.out.print(var);
                            this.out.print(this.source[158]);
                        } else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() && !isEmbeddingFromParent) {
                            if (rel.isBluntDeclared()) {
                                this.out.print(this.source[159]);
                            } else {
                                this.out.print(this.source[160]);
                                this.out.print(var);
                                this.out.print(this.source[161]);
                                this.out.print(var);
                                this.out.print(this.source[162]);
                                this.out.print(rel.getComment());
                                this.out.print(this.source[163]);
                            }
                            this.out.print(this.source[164]);
                            this.out.print(scope);
                            this.out.print(this.source[165]);
                            this.out.print(type);
                            this.out.print(this.source[166]);
                            this.out.print(rel.getGetterName());
                            this.out.print(this.source[167]);
                            this.out.print(var);
                            this.out.print(this.source[168]);
                        }
                    }
                }
                if (nmRel != null) {
                    String nmType = nmRel.getDeclaredJavaType(false);
                    if (rel.getNmScope() == AccessScope.PUBLIC) {
                        this.out.print(this.source[169]);
                    } else {
                        this.out.print(this.source[170]);
                        this.out.print(nmRel.getDeclaredJavaType(false));
                        this.out.print(this.source[171]);
                        this.out.print(rel);
                        this.out.print(this.source[172]);
                        this.out.print(nmRel.getVariableName());
                        this.out.print(this.source[173]);
                    }
                    this.out.print(this.source[174]);
                    this.out.print(rel.getNmScope());
                    this.out.print(this.source[175]);
                    this.out.print(nmType);
                    this.out.print(this.source[176]);
                    this.out.print((String)nmName);
                    this.out.print(this.source[177]);
                    if (!generateMock) {
                        this.out.print(this.source[178]);
                        this.out.print((String)nmVar);
                        this.out.print(this.source[179]);
                        this.out.print((String)nmVar);
                        this.out.print(this.source[180]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[181]);
                        this.out.print(rel.getForeignEntity());
                        this.out.print(this.source[182]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[183]);
                        this.out.print((String)nmVar);
                        this.out.print(this.source[184]);
                        this.out.print(nmRel.getGetterName());
                        this.out.print(this.source[185]);
                        this.out.print((String)nmVar);
                        this.out.print(this.source[186]);
                        this.out.print(nmType);
                        this.out.print(this.source[187]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[188]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[189]);
                        this.out.print(nmRel.getSetterName());
                        this.out.print(this.source[190]);
                        this.out.print(nmType);
                        this.out.print(this.source[191]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[192]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[193]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[194]);
                        this.out.print(nmRel.getGetterName());
                        this.out.print(this.source[195]);
                    }
                    this.out.print(this.source[196]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[197]);
                }
                if (!generateMock && rel.isComposite() && (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
                    if (rel.getAccessScope() == AccessScope.PUBLIC) {
                        this.out.print(this.source[198]);
                    } else {
                        this.out.print(this.source[199]);
                        this.out.print(rel.getName());
                        this.out.print(this.source[200]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[201]);
                    }
                    this.out.print(this.source[202]);
                    this.out.print(scope);
                    this.out.print(this.source[203]);
                    this.out.print(StringHelper.firstToUpper((String)var));
                    this.out.print(this.source[204]);
                    this.out.print(var);
                    this.out.print(this.source[205]);
                }
            }
            if (!createSetter) continue;
            if (generateMock) {
                this.out.print(this.source[206]);
                if (!hidden) {
                    this.out.print(this.source[207]);
                }
                this.out.print(this.source[208]);
                this.out.print(scope);
                this.out.print(this.source[209]);
                this.out.print(rel.getSetterName());
                this.out.print(this.source[210]);
                this.out.print(type);
                this.out.print(this.source[211]);
                this.out.print(var);
                this.out.print(this.source[212]);
                this.out.print(var);
                this.out.print(this.source[213]);
                this.out.print(var);
                this.out.print(this.source[214]);
            } else {
                String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
                String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
                this.out.print(this.source[215]);
                if (hidden) {
                    this.out.print(this.source[216]);
                    this.out.print(rel);
                    this.out.print(this.source[217]);
                    this.out.print(var);
                    this.out.print(this.source[218]);
                    this.out.print(rel.getComment());
                    this.out.print(this.source[219]);
                    if (linkMethodIndex != null) {
                        this.out.print(this.source[220]);
                    }
                    this.out.print(this.source[221]);
                } else {
                    this.out.print(this.source[222]);
                }
                for (String annotation : rel.getAnnotations()) {
                    AnnotationOption anno = new AnnotationOption(annotation);
                    if (!anno.isHidden() || !anno.isSetterOnly() && !anno.isSetterAndGetter()) continue;
                    this.out.print(this.source[223]);
                    this.out.print(anno.getAnnotation());
                    this.out.print(this.source[224]);
                }
                if (linkMethodIndex != null) {
                    this.out.print(this.source[225]);
                    this.out.print(scope);
                    this.out.print(this.source[226]);
                    this.out.print(rel.getForeignRelation().getLinkMethodName());
                    this.out.print(this.source[227]);
                    this.out.print(type);
                    this.out.print(this.source[228]);
                    this.out.print(var);
                    this.out.print(this.source[229]);
                } else {
                    String linkMethodName2 = rel.getSetterName();
                    if (rel.getForeignRelation() != null && rel.getForeignRelation().getLinkMethodName() != null) {
                        linkMethodName2 = rel.getForeignRelation().getLinkMethodName();
                    }
                    this.out.print(this.source[230]);
                    this.out.print(scope);
                    this.out.print(this.source[231]);
                    this.out.print(linkMethodName2);
                    this.out.print(this.source[232]);
                    this.out.print(type);
                    this.out.print(this.source[233]);
                    this.out.print(var);
                    this.out.print(this.source[234]);
                }
                if (rel.getRelationType() == RelationType.LIST && !rel.isReversed() || rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
                    if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
                        if (rel.isEmbedding()) {
                            this.out.print(this.source[235]);
                            this.out.print(var);
                            this.out.print(this.source[236]);
                            this.out.print(var);
                            this.out.print(this.source[237]);
                            this.out.print(var);
                            this.out.print(this.source[238]);
                        } else {
                            this.out.print(this.source[239]);
                            this.out.print(var);
                            this.out.print(this.source[240]);
                            this.out.print(var);
                            this.out.print(this.source[241]);
                        }
                    }
                    this.out.print(this.source[242]);
                    this.out.print(var);
                    this.out.print(this.source[243]);
                    this.out.print(var);
                    this.out.print(this.source[244]);
                    if (rel.isReferenced()) {
                        this.out.print(this.source[245]);
                        this.out.print(var);
                        this.out.print(this.source[246]);
                        if (rel.isEmbedding()) {
                            if (this.getEntity().isEmbedded()) {
                                this.out.print(this.source[247]);
                                this.out.print(var);
                                this.out.print(this.source[248]);
                                this.out.print(rel.getName().toUpperCase(Locale.ROOT));
                                this.out.print(this.source[249]);
                            } else {
                                this.out.print(this.source[250]);
                                this.out.print(var);
                                this.out.print(this.source[251]);
                                this.out.print(rel.getName().toUpperCase(Locale.ROOT));
                                this.out.print(this.source[252]);
                            }
                        }
                        this.out.print(this.source[253]);
                        this.out.print(var);
                        this.out.print(this.source[254]);
                        this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                        this.out.print(this.source[255]);
                    } else if (rel.isEmbedding()) {
                        if (this.getEntity().isEmbedded()) {
                            this.out.print(this.source[256]);
                            this.out.print(var);
                            this.out.print(this.source[257]);
                            this.out.print(var);
                            this.out.print(this.source[258]);
                            this.out.print(rel.getName().toUpperCase(Locale.ROOT));
                            this.out.print(this.source[259]);
                        } else {
                            this.out.print(this.source[260]);
                            this.out.print(var);
                            this.out.print(this.source[261]);
                            this.out.print(var);
                            this.out.print(this.source[262]);
                            this.out.print(rel.getName().toUpperCase(Locale.ROOT));
                            this.out.print(this.source[263]);
                        }
                    }
                    if (linkMethodIndex != null) {
                        this.out.print(this.source[264]);
                        this.out.print(this.createAccessorCode(this.getEntity(), linkMethodIndex, true));
                        this.out.print(this.source[265]);
                    }
                }
                if (rel.getRelationType() == RelationType.OBJECT && !isEmbeddingFromParent && !rel.isEmbedding()) {
                    if (rel.isComposite()) {
                        if (attr != null && !attr.getDataType().isPrimitive()) {
                            this.out.print(this.source[266]);
                            this.out.print(attr.getJavaType());
                            this.out.print(this.source[267]);
                            this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                            this.out.print(this.source[268]);
                        } else {
                            this.out.print(this.source[269]);
                            this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                            this.out.print(this.source[270]);
                        }
                    }
                    this.out.print(this.source[271]);
                    this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                    this.out.print(this.source[272]);
                    this.out.print(var);
                    this.out.print(this.source[273]);
                    this.out.print(nullVal);
                    this.out.print(this.source[274]);
                    this.out.print(var);
                    this.out.print(this.source[275]);
                }
                if (!(rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER || isEmbeddingFromParent)) {
                    this.out.print(this.source[276]);
                    this.out.print(var);
                    this.out.print(this.source[277]);
                }
                if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite()) {
                    if (attr != null && !attr.getDataType().isPrimitive()) {
                        this.out.print(this.source[278]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[279]);
                        this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                        this.out.print(this.source[280]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[281]);
                    } else if (!rel.isEmbedding()) {
                        this.out.print(this.source[282]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[283]);
                        this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                        this.out.print(this.source[284]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[285]);
                    }
                }
                this.out.print(this.source[286]);
            }
            if (rel.getRelationType() != RelationType.OBJECT || !rel.isSerialized() || isEmbeddingFromParent || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
            this.out.print(this.source[287]);
            this.out.print(var);
            this.out.print(this.source[288]);
            this.out.print(var);
            this.out.print(this.source[289]);
            this.out.print(rel.getComment());
            this.out.print(this.source[290]);
            this.out.print(scope);
            this.out.print(this.source[291]);
            this.out.print(rel.getSetterName());
            this.out.print(this.source[292]);
            this.out.print(type);
            this.out.print(this.source[293]);
            this.out.print(var);
            this.out.print(this.source[294]);
            this.out.print(var);
            this.out.print(this.source[295]);
            this.out.print(var);
            this.out.print(this.source[296]);
            this.out.print(var);
            this.out.print(this.source[297]);
        }
        if (generateSetSession) {
            this.out.print(this.source[298]);
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.isSelectionCached() || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER && !rel.isComposite()) continue;
                this.out.print(this.source[299]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[300]);
            }
            this.out.print(this.source[301]);
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.isSelectionCached() || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER && !rel.isComposite()) continue;
                this.out.print(this.source[302]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[303]);
            }
            this.out.print(this.source[304]);
        }
        if (generateDeleteReferencingRelations && !generateMock) {
            if (useDatabaseRefInt) {
                this.out.print(this.source[305]);
                for (Object rel : this.getEntity().getRelations()) {
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    if (!rel.isTracked()) {
                        throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
                    }
                    var = rel.getVariableName();
                    this.out.print(this.source[306]);
                    this.out.print(var);
                    this.out.print(this.source[307]);
                    this.out.print(var);
                    this.out.print(this.source[308]);
                    this.out.print(var);
                    this.out.print(this.source[309]);
                }
                this.out.print(this.source[310]);
            } else if (generateLazyDeleteReferencingRelations) {
                this.out.print(this.source[311]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
                    if (rel.isTracked()) {
                        this.out.print(this.source[312]);
                        if (rel.isDeletionCascaded()) {
                            this.out.print(this.source[313]);
                            this.out.print(rel.getGetterName());
                            this.out.print(this.source[314]);
                        } else {
                            this.out.print(this.source[315]);
                            this.out.print(var);
                            this.out.print(this.source[316]);
                            this.out.print(this.createRelationDeleteCode((Relation)rel));
                            this.out.print(this.source[317]);
                        }
                        this.out.print(this.source[318]);
                        this.out.print(var);
                        this.out.print(this.source[319]);
                        this.out.print(var);
                        this.out.print(this.source[320]);
                        this.out.print(var);
                        this.out.print(this.source[321]);
                        continue;
                    }
                    this.out.print(this.source[322]);
                    this.out.print(var);
                    this.out.print(this.source[323]);
                    if (rel.isDeletionCascaded()) {
                        this.out.print(this.source[324]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[325]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[326]);
                        this.out.print(var);
                        this.out.print(this.source[327]);
                    } else {
                        this.out.print(this.source[328]);
                        this.out.print(var);
                        this.out.print(this.source[329]);
                        this.out.print(this.createRelationDeleteCode((Relation)rel));
                        this.out.print(this.source[330]);
                    }
                    this.out.print(this.source[331]);
                }
                this.out.print(this.source[332]);
            } else {
                this.out.print(this.source[333]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    if (rel.isDeletionCascaded()) {
                        this.out.print(this.source[334]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[335]);
                        continue;
                    }
                    this.out.print(this.source[336]);
                    this.out.print(var);
                    this.out.print(this.source[337]);
                    this.out.print(this.createRelationDeleteCode((Relation)rel));
                    this.out.print(this.source[338]);
                }
                this.out.print(this.source[339]);
            }
        }
        if (generateDeleteReferencedRelations && !generateMock) {
            if (useDatabaseRefInt) {
                this.out.print(this.source[340]);
                for (Object rel : this.getEntity().getRelations()) {
                    if (!rel.isComposite() || rel.isEmbedding() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (!rel.isTracked()) {
                        throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
                    }
                    var = rel.getVariableName();
                    selectStmt = this.createRelationSelectCode((Relation)rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
                    this.out.print(this.source[341]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[342]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[343]);
                    this.out.print(selectStmt);
                    this.out.print(this.source[344]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[345]);
                }
                this.out.print(this.source[346]);
            } else if (generateLazyDeleteReferencedRelations) {
                this.out.print(this.source[347]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        this.out.print(this.source[348]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[349]);
                        this.out.print(var);
                        this.out.print(this.source[350]);
                        this.out.print(var);
                        this.out.print(this.source[351]);
                    }
                    selectStmt = this.createRelationSelectCode((Relation)rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
                    this.out.print(this.source[352]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[353]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[354]);
                    this.out.print(selectStmt);
                    this.out.print(this.source[355]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[356]);
                }
                this.out.print(this.source[357]);
            } else {
                this.out.print(this.source[358]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.isEmbedding() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (rel.getSelectionType() == SelectionType.ALWAYS) {
                        throw new WurbelException("internal wurblet logic error");
                    }
                    this.out.print(this.source[359]);
                    this.out.print(var);
                    this.out.print(this.source[360]);
                    this.out.print(var);
                    this.out.print(this.source[361]);
                }
                this.out.print(this.source[362]);
            }
        }
        if (generateSaveReferencingRelations && !generateMock) {
            this.out.print(this.source[363]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[364]);
            } else {
                this.out.print(this.source[365]);
                this.out.print(generateLazyDeleteReferencingRelations ? "false" : "");
                this.out.print(this.source[366]);
            }
            this.out.print(this.source[367]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                if (rel.isProcessed()) {
                    this.out.print(this.source[368]);
                    this.out.print(var);
                    this.out.print(this.source[369]);
                    this.out.print(rel.getMethodNameSuffix());
                    this.out.print(this.source[370]);
                    this.out.print(var);
                    this.out.print(this.source[371]);
                }
                this.out.print(this.source[372]);
                this.out.print(var);
                this.out.print(this.source[373]);
                this.out.print(var);
                this.out.print(this.source[374]);
                if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
                    this.out.print(this.source[375]);
                }
                this.out.print(this.source[376]);
                this.out.print(rel.getClassName());
                this.out.print(this.source[377]);
                this.out.print(var);
                this.out.print(this.source[378]);
                this.out.print(this.createRelationLinkCode((Relation)rel));
                this.out.print(this.source[379]);
                boolean firstSkipped = false;
                for (MethodArgument ma : rel.getMethodArgs()) {
                    if (firstSkipped) {
                        this.out.print(this.source[380]);
                        this.out.print(ma.getSetterMethod());
                        this.out.print(this.source[381]);
                        this.out.print(ma.getMethodArgument());
                        this.out.print(this.source[382]);
                    }
                    firstSkipped = true;
                }
                this.out.print(this.source[383]);
                this.out.print(var);
                this.out.print(this.source[384]);
                this.out.print(rel.isTracked() ? "true" : "false");
                this.out.print(this.source[385]);
            }
            this.out.print(this.source[386]);
        }
        if (generateSaveReferencedRelations && !generateMock) {
            this.out.print(this.source[387]);
            if (this.getEntity().isRootEntity()) {
                this.out.print(this.source[388]);
            }
            this.out.print(this.source[389]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[390]);
            } else {
                this.out.print(this.source[391]);
                this.out.print(generateLazyDeleteReferencedRelations ? "false" : "");
                this.out.print(this.source[392]);
            }
            this.out.print(this.source[393]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isEmbedding() || rel.getRelationType() != RelationType.OBJECT) continue;
                this.out.print(this.source[394]);
                this.out.print(var);
                this.out.print(this.source[395]);
                if (rel.isProcessed()) {
                    this.out.print(this.source[396]);
                    this.out.print(var);
                    this.out.print(this.source[397]);
                    this.out.print(rel.getMethodNameSuffix());
                    this.out.print(this.source[398]);
                    this.out.print(var);
                    this.out.print(this.source[399]);
                }
                if (rel.isTracked()) {
                    this.out.print(this.source[400]);
                    this.out.print(var);
                    this.out.print(this.source[401]);
                    this.out.print(var);
                    this.out.print(this.source[402]);
                    this.out.print(var);
                    this.out.print(this.source[403]);
                    this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                    this.out.print(this.source[404]);
                    this.out.print(var);
                    this.out.print(this.source[405]);
                    continue;
                }
                this.out.print(this.source[406]);
                this.out.print(var);
                this.out.print(this.source[407]);
                this.out.print(var);
                this.out.print(this.source[408]);
                this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                this.out.print(this.source[409]);
                this.out.print(var);
                this.out.print(this.source[410]);
            }
            this.out.print(this.source[411]);
        }
        if (Boolean.TRUE.equals(generateValidate)) {
            this.out.print(this.source[412]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite()) continue;
                if (this.getAnnotationOptions(rel.getAnnotations(), "Validate").isEmpty()) {
                    this.out.print(this.source[413]);
                    this.out.print(var);
                    this.out.print(this.source[414]);
                    if (rel.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[415]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[416]);
                        this.out.print(var);
                        this.out.print(this.source[417]);
                    } else {
                        this.out.print(this.source[418]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[419]);
                        this.out.print(var);
                        this.out.print(this.source[420]);
                    }
                    this.out.print(this.source[421]);
                    continue;
                }
                this.out.print(this.source[422]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[423]);
            }
            this.out.print(this.source[424]);
        }
        if (generateSetImmutable && !generateMock) {
            this.out.print(this.source[425]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isComposite()) continue;
                this.out.print(this.source[426]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[427]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[428]);
            }
            this.out.print(this.source[429]);
        }
        if (generateIsModified && !generateMock) {
            this.out.print(this.source[430]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isComposite()) continue;
                if (rel.getRelationType() == RelationType.LIST) {
                    this.out.print(this.source[431]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[432]);
                    continue;
                }
                this.out.print(this.source[433]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[434]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[435]);
            }
            this.out.print(this.source[436]);
        }
        if (generateAlignComponents && !generateMock) {
            this.out.print(this.source[437]);
            for (Object rel : this.getEntity().getRelations()) {
                Attribute countAttribute = rel.getCountAttribute();
                if (countAttribute == null) continue;
                this.out.print(this.source[438]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[439]);
                this.out.print(countAttribute.getSetterName());
                this.out.print(this.source[440]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[441]);
            }
            this.out.print(this.source[442]);
        }
        if (this.getEntity().isDeeplyReferenced()) {
            Iterator<Relation> deepRelations = new ArrayList();
            for (Relation rel2 : this.getEntity().getRelations()) {
                if (!rel2.isComposite() || !rel2.getForeignEntity().isDeeplyReferenced()) continue;
                deepRelations.add(rel2);
            }
            if (!deepRelations.isEmpty()) {
                Object rel;
                this.out.print(this.source[443]);
                rel = deepRelations.iterator();
                while (rel.hasNext()) {
                    Relation rel2;
                    rel2 = (Relation)rel.next();
                    if (rel2.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[444]);
                        this.out.print(rel2.getForeignEntity());
                        this.out.print(this.source[445]);
                        this.out.print(rel2.getGetterName());
                        this.out.print(this.source[446]);
                        continue;
                    }
                    this.out.print(this.source[447]);
                    this.out.print(rel2.getGetterName());
                    this.out.print(this.source[448]);
                    this.out.print(rel2.getGetterName());
                    this.out.print(this.source[449]);
                }
                this.out.print(this.source[450]);
            }
        }
        if (generateIsComposite) {
            this.out.print(this.source[451]);
        }
        if (generateLoadComponents.booleanValue() && !generateMock) {
            this.out.print(this.source[452]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite()) continue;
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[453]);
                    this.out.print(var);
                    this.out.print(this.source[454]);
                    if (rel.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[455]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[456]);
                    } else {
                        this.out.print(this.source[457]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[458]);
                        this.out.print(var);
                        this.out.print(this.source[459]);
                    }
                    this.out.print(this.source[460]);
                    continue;
                }
                if (rel.getRelationType() == RelationType.LIST) {
                    this.out.print(this.source[461]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[462]);
                    continue;
                }
                if (rel.isEmbedding()) {
                    this.out.print(this.source[463]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[464]);
                    continue;
                }
                this.out.print(this.source[465]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[466]);
                this.out.print(var);
                this.out.print(this.source[467]);
            }
            this.out.print(this.source[468]);
        }
        if (generateInsertComponents.booleanValue() && !generateMock) {
            this.out.print(this.source[469]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isEmbedding() || rel.getRelationType() != RelationType.OBJECT) continue;
                this.out.print(this.source[470]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[471]);
                this.out.print(var);
                this.out.print(this.source[472]);
            }
            this.out.print(this.source[473]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                this.out.print(this.source[474]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[475]);
            }
            this.out.print(this.source[476]);
        }
        if (generateDeleteComponents.booleanValue() && !generateMock) {
            this.out.print(this.source[477]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[478]);
            } else {
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    this.out.print(this.source[479]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[480]);
                }
            }
            this.out.print(this.source[481]);
            if (!useDatabaseRefInt) {
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.isEmbedding() || rel.getRelationType() != RelationType.OBJECT) continue;
                    this.out.print(this.source[482]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[483]);
                    this.out.print(var);
                    this.out.print(this.source[484]);
                }
            }
            this.out.print(this.source[485]);
        }
        if (generateMarkDeleted && !generateMock) {
            this.out.print(this.source[486]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isEmbedding()) continue;
                this.out.print(this.source[487]);
                this.out.print(var);
                this.out.print(this.source[488]);
            }
            this.out.print(this.source[489]);
        }
        if (generateSnapshot && !generateMock) {
            this.out.print(this.source[490]);
            this.out.print(mainClass);
            this.out.print(this.getEntity().isAbstract() ? "<T,?>" : "");
            this.out.print(this.source[491]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isShallow()) continue;
                if (rel.getRelationType() == RelationType.LIST) {
                    if (!rel.isTracked()) continue;
                    this.out.print(this.source[492]);
                    this.out.print(var);
                    this.out.print(this.source[493]);
                    this.out.print(var);
                    this.out.print(this.source[494]);
                    continue;
                }
                this.out.print(this.source[495]);
                this.out.print(var);
                this.out.print(this.source[496]);
                this.out.print(var);
                this.out.print(this.source[497]);
            }
            this.out.print(this.source[498]);
            this.out.print(mainClass);
            this.out.print(this.getEntity().isAbstract() ? "<T,?>" : "");
            this.out.print(this.source[499]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isShallow()) continue;
                Relation nmRel = rel.getNmRelation();
                Object nmVar = null;
                if (nmRel != null) {
                    nmVar = rel.getNmMethodName() != null ? StringHelper.firstToLower((String)rel.getNmMethodName()) : StringHelper.firstToLower((String)rel.getNmName()) + "List";
                }
                if (rel.getRelationType() == RelationType.LIST) {
                    if (rel.isTracked()) {
                        this.out.print(this.source[500]);
                        this.out.print(var);
                        this.out.print(this.source[501]);
                        this.out.print(var);
                        this.out.print(this.source[502]);
                        this.out.print(var);
                        this.out.print(this.source[503]);
                    }
                } else {
                    this.out.print(this.source[504]);
                    this.out.print(var);
                    this.out.print(this.source[505]);
                    this.out.print(var);
                    this.out.print(this.source[506]);
                    this.out.print(var);
                    this.out.print(this.source[507]);
                }
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[508]);
                    this.out.print(var);
                    this.out.print(this.source[509]);
                    this.out.print(var);
                    this.out.print(this.source[510]);
                }
                if (rel.getRelationType() == RelationType.OBJECT && !rel.isEmbedding()) {
                    this.out.print(this.source[511]);
                    this.out.print(var);
                    this.out.print(this.source[512]);
                    this.out.print(var);
                    this.out.print(this.source[513]);
                }
                if (nmVar == null) continue;
                this.out.print(this.source[514]);
                this.out.print((String)nmVar);
                this.out.print(this.source[515]);
            }
            this.out.print(this.source[516]);
        }
        if (generateCreateNormText && !generateMock) {
            this.out.print(this.source[517]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isPartOfNormText()) continue;
                if (rel.getRelationType() == RelationType.OBJECT) {
                    this.out.print(this.source[518]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[519]);
                    continue;
                }
                this.out.print(this.source[520]);
                this.out.print(rel.getClassName());
                this.out.print(this.source[521]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[522]);
            }
            this.out.print(this.source[523]);
        }
        if (generateIsReferencing && !generateMock) {
            List relations = null;
            if (this.isEntityPersistable()) {
                relations = this.getEntity().getTableRelations();
            } else if (this.getEntity().isEmbedded()) {
                relations = this.getEntity().getRelations();
            }
            if (relations != null) {
                for (Relation rel2 : this.getEntity().getTableRelations()) {
                    if (rel2.isComposite() || rel2.getRelationType() != RelationType.OBJECT || rel2.getEmbeddingEntity() != null || rel2.getForeignRelation() != null && rel2.getForeignRelation().isComposite() || rel2.getForeignEntity() == null || !rel2.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
                    Attribute attr = this.getFirstMethodAttribute(rel2);
                    String tagName = "isReferencing" + rel2.getClassName() + "By" + StringHelper.firstToUpper((String)attr.getName());
                    this.out.print(this.source[524]);
                    this.out.print(pdoName);
                    this.out.print(this.source[525]);
                    this.out.print(rel2.getClassName());
                    this.out.print(this.source[526]);
                    this.out.print(tagName);
                    this.out.print(this.source[527]);
                    this.out.print(attr.getName());
                    this.out.print(this.source[528]);
                }
            }
        }
        if (generateSelects && this.isEntityPersistable() && !generateMock) {
            HashSet wurbletArgSet = new HashSet();
            for (Relation rel2 : this.getEntity().getReferencingRelations()) {
                Object join;
                Attribute attribute;
                if (rel2.getRelationType() != RelationType.LIST || (attribute = rel2.getForeignAttribute()) == null) continue;
                String trackedOption = rel2.isTracked() ? "--tracked " : "";
                Object joins = "";
                if (rel2.getNmName() != null && (join = rel2.getNmRelation()) != null && join.getRelationType() == RelationType.OBJECT && join.getSelectionType() == SelectionType.LAZY && !join.isComposite() && join.isSerialized()) {
                    joins = " *" + rel2.getNmName();
                }
                join = this.getEntity().getRelationsIncludingInherited().iterator();
                while (join.hasNext()) {
                    Relation eRel = (Relation)join.next();
                    if (eRel.getSelectionType() != SelectionType.EAGER) continue;
                    joins = (String)joins + " *" + eRel.getName();
                }
                Object extraWurbletOptions = rel2.getSelectionWurbletArguments();
                extraWurbletOptions = extraWurbletOptions == null ? "" : " " + (String)extraWurbletOptions;
                String wurbletArgs = this.createRelationWurbletArgString(rel2);
                if (!wurbletArgSet.add(wurbletArgs)) continue;
                this.out.print(this.source[529]);
                this.out.print(rel2);
                this.out.print(this.source[530]);
                if (rel2.isReversed()) {
                    this.out.print(this.source[531]);
                    this.out.print(this.createRelationSelectMethodName(rel2));
                    this.out.print(this.source[532]);
                    this.out.print(wurbletArgs);
                    this.out.print((String)joins);
                    this.out.print((String)extraWurbletOptions);
                    this.out.print(this.source[533]);
                    continue;
                }
                this.out.print(this.source[534]);
                this.out.print(this.createRelationSelectMethodName(rel2));
                this.out.print(this.source[535]);
                this.out.print(trackedOption);
                this.out.print(wurbletArgs);
                this.out.print((String)joins);
                this.out.print((String)extraWurbletOptions);
                this.out.print(this.source[536]);
            }
        }
        if (generateDeletes && this.isEntityPersistable() && !generateMock) {
            for (Object rel : this.getEntity().getReferencingRelations()) {
                Attribute attribute;
                if (rel.getAccessScope() != AccessScope.PUBLIC || rel.getRelationType() != RelationType.LIST || (attribute = rel.getForeignAttribute()) == null || !rel.isComposite() || rel.isDeletionCascaded() || useDatabaseRefInt) continue;
                this.out.print(this.source[537]);
                this.out.print(rel);
                this.out.print(this.source[538]);
                this.out.print(this.createListRelationDeleteMethodName((Relation)rel));
                this.out.print(this.source[539]);
                this.out.print(this.createRelationWurbletArgString((Relation)rel));
                this.out.print(this.source[540]);
            }
        }
        if (generateAddReferencing && !generateMock) {
            ArrayList<Relation> refRels = new ArrayList<Relation>();
            for (Relation rel2 : this.getEntity().getReferencingRelations()) {
                if (rel2.isComposite() || rel2.getRelationType() != RelationType.OBJECT || rel2.getForeignRelation() != null && rel2.getForeignRelation().isComposite() || rel2.getForeignEntity() == null || !rel2.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
                if (rel2.isEmbedded()) {
                    for (List embeddingPath : rel2.getEntity().getEmbeddingPaths()) {
                        Object pathStr = "";
                        Entity embeddingEntity = null;
                        for (Relation embeddingRel : embeddingPath) {
                            pathStr = (String)pathStr + embeddingRel.getGetterName() + ".";
                            if (embeddingEntity != null) continue;
                            embeddingEntity = embeddingRel.getEntity();
                        }
                        refRels.add(rel2.createEmbedded(embeddingEntity, (String)pathStr, ""));
                    }
                    continue;
                }
                refRels.add(rel2);
            }
            if (!refRels.isEmpty()) {
                this.out.print(this.source[541]);
                if (this.getEntity().isAbstract()) {
                    this.out.print(this.source[542]);
                }
                this.out.print(this.source[543]);
                this.out.print(pdoName);
                this.out.print(this.source[544]);
                for (Relation rel2 : refRels) {
                    String methodName = "isReferencing" + rel2.getClassName() + "By" + StringHelper.firstToUpper((String)this.getFirstMethodAttribute(rel2).getName());
                    if (rel2.getEmbeddingEntity() != null) {
                        methodName = rel2.getPathName() + methodName;
                        this.out.print(this.source[545]);
                        this.out.print(rel2.getEmbeddingEntity().getName());
                        this.out.print(this.source[546]);
                        this.out.print(methodName);
                        this.out.print(this.source[547]);
                        continue;
                    }
                    for (Entity leaf : rel2.getEntity().getLeafEntities()) {
                        this.out.print(this.source[548]);
                        this.out.print(leaf.getName());
                        this.out.print(this.source[549]);
                        this.out.print(methodName);
                        this.out.print(this.source[550]);
                    }
                }
                this.out.print(this.source[551]);
            }
        }
    }
}

