// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generates the remote delegate invocation code.
 * <p>
 * In order for this wurblet to work, the method must be annotated with @RemoteMethod.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; RemoteMethod [--this] [--nocontext] [--instance=&lt;object&gt;]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--this:</em> add the PDO itself to the method parameters.</li>
 * <li><em>--nocontext:</em> don't pass the DomainContext.</li>
 * <li><em>--instance=&lt;object&gt;:</em> object to invoke the method on in the remote implementation.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class RemoteMethod extends DbModelWurblet {

  public RemoteMethod() {
    setConfiguration("missingModelOk");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String instanceName   = null;
    boolean addThis       = false;
    boolean noContext     = false;

    for (String arg: getOptionArgs())  {
      if (arg.startsWith("instance=")) {
        instanceName = arg.substring(9);
      }
      else if (arg.equals("this")) {
        addThis = true;
      }
      else if (arg.equals("nocontext")) {
        noContext = true;
      }
    }

    String methodName = getMethodName();

    String className = getClassName();
    if (className == null)  {
      throw new WurbelException("can't determine <classname>");
    }

    String packageName = getPackageName();
    if (packageName == null)  {
      throw new WurbelException("can't determine <packagename>");
    }

    boolean isPdoOrOperation = false;
    String pdoClassName = null;
    try {
      pdoClassName = getPdoClassName();
      isPdoOrOperation = true;
    }
    catch (WurbelException wx) {
      // not a pdo or operation -> low level object
    }

    if (isRemote()) {

      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplementationStream();
      PrintStream remoteOut = genInc.getInterfaceStream();

      // load the info file
      String infoName = (packageName + "." + className + "." + methodName).replace('.', '/') +
                        RemoteMethodInfo.INFO_FILE_EXTENSION;
      RemoteMethodInfo info = null;
      try {
        info = RemoteMethodInfo.readInfo(getContainer().getAnalyzeFile(infoName));
      }
      catch (IOException ex) {
        if (getContainer().getAnalyzeFile(AnalyzeProcessor.COMPILE_ERROR_LOG).exists()) {
          genInc.discard();
          throw new WurbelDiscardException("reading info '" + infoName + "' failed", ex);
        }
        else {
          throw new WurbelException("reading info '" + infoName + "' failed (@RemoteMethod annotation missing?)", ex);
        }
      }

      RemoteMethodHelper helper = new RemoteMethodHelper(info, pdoClassName, addThis);

      boolean returningObject     = helper.isReturningObject();
      boolean returningCollection = helper.isReturningCollection();
      boolean returningCursor     = helper.isReturningCursor();
      boolean returningVoid       = helper.isReturningVoid();

      // get the real method name
      methodName = helper.getMethodName();

      if (helper.isStaticMethod()) {
        throw new WurbelException("static methods cannot be --remote");
      }

      // generate strings
      String iparms  = helper.getInvocationParameterString();
      String riparms = helper.getRemoteInvocationParameterString();
      String dparms  = helper.getDeclarationParameterString();

      if (isPdoOrOperation && !addThis && !noContext) {
        if (iparms.length() > 0) {
          iparms = "getDomainContext(), " + iparms;
        }
        else {
          iparms = "getDomainContext()";
        }

        if (dparms.length() > 0) {
          dparms = "DomainContext context, " + dparms;
        }
        else  {
          dparms = "DomainContext context";
        }
      }

      String returnType = helper.getReturnType();
      String genType = helper.getGenericReturnType();

      String firstName  = helper.getFirstName();
      boolean firstIsDb = helper.isFirstInstanceOfDb();
      boolean firstIsDomainContext = helper.isFirstInstanceOfDomainContext();

      String remoteDelegateName = isOperation() ?
          NamingRules.getInstance().getOperationRemoteInterface(pdoClassName != null ? pdoClassName : className) :
          NamingRules.getInstance().getPdoRemoteInterface(pdoClassName != null ? pdoClassName : className);
      String imethod = "getRemoteDelegate()";

      String setDomainContext = "setDomainContext(" + firstName + ")";

      String apply = null;
      if (returningObject) {
        apply = "configureRemoteObject(getDomainContext(), obj)";
      }
      else if (returningCollection) {
        apply = "configureRemoteObjects(getDomainContext(), list)";
      }

      // always use a fresh pdo because we don't know what the app is really doing with it
      String dbObject = "newInstance(" + (firstIsDomainContext ? firstName : "context") + ")";
      if (!isPdoOrOperation || noContext) {
        dbObject = "dbObject";
      }
      if (addThis) {
        dbObject = "obj";
      }
      else if (instanceName != null) {
        dbObject = instanceName;
      }

      out.print(source[0]); // 153:2 = "    if (getSession().isRemote())  {    ..."


      if (returningObject) {
        String poType = isGenerified() ? "P" : getClassName();
        remoteOut.print(source[1]); // 162:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[2]); // 163:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[3]); // 163:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[4]); // 163:42 = ") throws RemoteException;"
        implOut.print(source[5]); // 164:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[6]); // 167:23 = " "
        implOut.print(methodName);
        implOut.print(source[7]); // 167:38 = "("
        implOut.print(dparms);
        implOut.print(source[8]); // 167:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[9]); // 171:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[10]); // 172:26 = ";"
        }
        if (addThis) {
          implOut.print(source[11]); // 176:2 = "      (("
          implOut.print(poType);
          implOut.print(source[12]); // 177:18 = ") obj.getPersistenceDelegate()).setOverl..."
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[13]); // 182:2 = "      "
          implOut.print(statement);
          implOut.print(source[14]); // 183:19 = ";"
        }
        implOut.print(source[15]); // 186:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[16]); // 187:25 = "."
        implOut.print(methodName);
        implOut.print(source[17]); // 187:40 = "("
        implOut.print(riparms);
        implOut.print(source[18]); // 187:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[19]); // 193:6 = "        "
        out.print(returnType);
        out.print(source[20]); // 194:22 = " obj = "
        out.print(imethod);
        out.print(source[21]); // 194:40 = "."
        out.print(methodName);
        out.print(source[22]); // 194:55 = "("
        out.print(iparms);
        out.print(source[23]); // 194:66 = ");        "
        out.print(apply);
        out.print(source[24]); // 195:17 = ";        return obj;"
      }


      else if (returningCollection) {
        remoteOut.print(source[25]); // 203:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[26]); // 204:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[27]); // 204:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[28]); // 204:42 = ") throws RemoteException;"
        implOut.print(source[29]); // 205:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[30]); // 208:23 = " "
        implOut.print(methodName);
        implOut.print(source[31]); // 208:38 = "("
        implOut.print(dparms);
        implOut.print(source[32]); // 208:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[33]); // 212:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[34]); // 213:26 = ";"
        }
        if (addThis) {
          implOut.print(source[35]); // 217:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[36]); // 222:2 = "      "
          implOut.print(statement);
          implOut.print(source[37]); // 223:19 = ";"
        }
        implOut.print(source[38]); // 226:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[39]); // 227:25 = "."
        implOut.print(methodName);
        implOut.print(source[40]); // 227:40 = "("
        implOut.print(riparms);
        implOut.print(source[41]); // 227:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[42]); // 233:6 = "        "
        out.print(returnType);
        out.print(source[43]); // 234:22 = " list = "
        out.print(imethod);
        out.print(source[44]); // 234:41 = "."
        out.print(methodName);
        out.print(source[45]); // 234:56 = "("
        out.print(iparms);
        out.print(source[46]); // 234:67 = ");        "
        out.print(apply);
        out.print(source[47]); // 235:17 = ";        return list;"
      }


      else if (returningCursor) {
        remoteOut.print(source[48]); // 243:16 = "  RemoteResultSetCursor"
        remoteOut.print(genType);
        remoteOut.print(source[49]); // 244:34 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[50]); // 244:49 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[51]); // 244:60 = ") throws RemoteException;"
        implOut.print(source[52]); // 245:14 = "  @Override  public RemoteResultSetCur..."
        implOut.print(genType);
        implOut.print(source[53]); // 248:41 = " "
        implOut.print(methodName);
        implOut.print(source[54]); // 248:56 = "("
        implOut.print(dparms);
        implOut.print(source[55]); // 248:67 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[56]); // 252:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[57]); // 253:26 = ";"
        }
        if (addThis) {
          implOut.print(source[58]); // 257:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[59]); // 262:2 = "      "
          implOut.print(statement);
          implOut.print(source[60]); // 263:19 = ";"
        }
        implOut.print(source[61]); // 266:2 = "      return createRemoteResultSetCursor..."
        implOut.print(dbObject);
        implOut.print(source[62]); // 267:61 = "."
        implOut.print(methodName);
        implOut.print(source[63]); // 267:76 = "("
        implOut.print(riparms);
        implOut.print(source[64]); // 267:88 = "));    }    catch (Exception e) {    ..."
        if (isPdoOrOperation) {
          out.print(source[65]); // 276:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[66]); // 278:32 = "."
          out.print(methodName);
          out.print(source[67]); // 278:47 = "("
          out.print(iparms);
          out.print(source[68]); // 278:58 = "));"
        }
        else  {
          out.print(source[69]); // 282:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[70]); // 284:32 = "."
          out.print(methodName);
          out.print(source[71]); // 284:47 = "("
          out.print(iparms);
          out.print(source[72]); // 284:58 = "));"
        }
      }

      else if (returningVoid) {
        remoteOut.print(source[73]); // 291:16 = "  void "
        remoteOut.print(methodName);
        remoteOut.print(source[74]); // 292:21 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[75]); // 292:32 = ") throws RemoteException;"
        implOut.print(source[76]); // 293:14 = "  @Override  public void "
        implOut.print(methodName);
        implOut.print(source[77]); // 296:28 = "("
        implOut.print(dparms);
        implOut.print(source[78]); // 296:39 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[79]); // 300:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[80]); // 301:26 = ";"
        }
        if (addThis) {
          implOut.print(source[81]); // 305:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[82]); // 310:2 = "      "
          implOut.print(statement);
          implOut.print(source[83]); // 311:19 = ";"
        }
        implOut.print(source[84]); // 314:2 = "      "
        implOut.print(dbObject);
        implOut.print(source[85]); // 315:18 = "."
        implOut.print(methodName);
        implOut.print(source[86]); // 315:33 = "("
        implOut.print(riparms);
        implOut.print(source[87]); // 315:45 = ");    }    catch (Exception e) {     ..."
        out.print(source[88]); // 321:6 = "        "
        out.print(imethod);
        out.print(source[89]); // 322:19 = "."
        out.print(methodName);
        out.print(source[90]); // 322:34 = "("
        out.print(iparms);
        out.print(source[91]); // 322:45 = ");        return;"
      }


      else  {
        remoteOut.print(source[92]); // 330:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[93]); // 331:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[94]); // 331:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[95]); // 331:42 = ") throws RemoteException;"
        implOut.print(source[96]); // 332:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[97]); // 335:23 = " "
        implOut.print(methodName);
        implOut.print(source[98]); // 335:38 = "("
        implOut.print(dparms);
        implOut.print(source[99]); // 335:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[100]); // 339:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[101]); // 340:26 = ";"
        }
        if (addThis) {
          implOut.print(source[102]); // 344:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[103]); // 349:2 = "      "
          implOut.print(statement);
          implOut.print(source[104]); // 350:19 = ";"
        }
        implOut.print(source[105]); // 353:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[106]); // 354:25 = "."
        implOut.print(methodName);
        implOut.print(source[107]); // 354:40 = "("
        implOut.print(riparms);
        implOut.print(source[108]); // 354:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[109]); // 360:6 = "        return "
        out.print(imethod);
        out.print(source[110]); // 361:26 = "."
        out.print(methodName);
        out.print(source[111]); // 361:41 = "("
        out.print(iparms);
        out.print(source[112]); // 361:52 = ");"
      }
      out.print(source[113]); // 364:2 = "      }      catch (RemoteException e) ..."
    }
    else  {
      out.print(source[114]); // 373:2 = "    // remote code generation disabled"
    }
  }

  // ----------------- end wurblet code -----------------
}
