// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to select an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoSelectUnique
 *     [--private] [--noif] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     [--sort] [--lock]
 *     &lt;expression&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>--sort:</em> sort according to orderBy()-method.</li>
 * <li><em>--lock:</em> generates SELECT FOR UPDATE.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoSelectUnique extends DbModelWurblet {

  public PdoSelectUnique() {
    setConfiguration("pathAllowed");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    assertEntityNotEmbedded();
    assertEntityIsPersistable();

    String className  = getClassName();
    String methodName = getMethodName();
    String pdoName    = getPdoClassName();
    String pdoType    = pdoName;
    String returnType = pdoName;
    String poType     = className;
    String classVar   = null;

    if (isGenerified()) {
      returnType = "T";
      poType = "P";
    }

    boolean sort        = false;
    boolean lock        = false;
    String  append      = null;
    boolean noif        = false;
    String  scope       = "public";

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
        noif = true;
      }
      else if (arg.equals("noif")) {
        noif = true;
      }
      else if (arg.equals("sort")) {
        if (isWithDefaultSorting()) {
          if (isWithSorting()) {
            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
          }
          sort = true;
        }
        else {
          throw new WurbelException("no sorting configured in model for " + getEntity());
        }
      }
      else if (arg.equals("lock")) {
        lock = true;
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (scope.equals("private")) {
      setRemote(false);
      noif = true;
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    if (methodName == null) {
      throw new WurbelException("can't determine <methodname>");
    }
    if (getExpressionArguments().isEmpty() && !sort && !isWithSorting() && append == null && getContextAttribute() == null) {
      throw new WurbelException("no keys given");
    }

    String params = buildMethodParameters();
    String iparms = buildInvocationParameters();
    String statementId = createStatementId();
    String reflMethod = getGuardName() + "Method";
    boolean needLimit = sort || append != null || createOrderBy() != null;
    String alias = getEntity().getTopSuperEntity().getTableAlias();
    String poImpl = deriveClassNameForEntity(getEntity());

    List<JoinPath> joinPaths = getJoinPaths();
    boolean withJoins = !joinPaths.isEmpty();
    boolean needSuppressWarnings = withJoins && isAbstractJoinPath(joinPaths);

    if (!noif) {
      out.print(source[0]); // 111:2 = "  @Override"
    }
    if (needSuppressWarnings) {
      out.print(source[1]); // 116:2 = "  @SuppressWarnings({"unchecked", "rawty..."
    }
    out.print(source[2]); // 120:2 = "  "
    out.print(scope);
    out.print(source[3]); // 121:11 = " "
    out.print(returnType);
    out.print(source[4]); // 121:26 = " "
    out.print(methodName);
    out.print(source[5]); // 121:41 = "("
    out.print(as(params));
    out.print(source[6]); // 121:56 = ") {"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplementationStream();
      PrintStream remoteOut = genInc.getInterfaceStream();

      if (isPdoProvidingArguments()) {
        out.print(source[7]); // 130:2 = "    if (getSession().isRemote())  {    ..."
        remoteOut.print(source[8]); // 133:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[9]); // 134:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[10]); // 134:31 = "("
        remoteOut.print(pcs(params, returnType + " obj"));
        remoteOut.print(source[11]); // 134:68 = ") throws RemoteException;"
        implOut.print(source[12]); // 135:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[13]); // 138:23 = " "
        implOut.print(methodName);
        implOut.print(source[14]); // 138:38 = "("
        implOut.print(pcs(params, returnType + " obj"));
        implOut.print(source[15]); // 138:75 = ") throws RemoteException {    try {   ..."
        implOut.print(poType);
        implOut.print(source[16]); // 141:18 = ") obj.getPersistenceDelegate()).setOverl..."
        implOut.print(methodName);
        implOut.print(source[17]); // 142:31 = "("
        implOut.print(iparms);
        implOut.print(source[18]); // 142:42 = ");    }    catch (RuntimeException e) ..."
        out.print(source[19]); // 148:6 = "        "
        out.print(returnType);
        out.print(source[20]); // 149:22 = " obj = getRemoteDelegate()."
        out.print(methodName);
        out.print(source[21]); // 149:63 = "("
        out.print(pcs(iparms, "me()"));
        out.print(source[22]); // 149:87 = ");        configureRemoteObject(getDoma..."
      }
      else {
        out.print(source[23]); // 160:2 = "    if (getSession().isRemote())  {    ..."
        remoteOut.print(source[24]); // 163:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[25]); // 164:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[26]); // 164:31 = "("
        remoteOut.print(pcs(params, "DomainContext context"));
        remoteOut.print(source[27]); // 164:72 = ") throws RemoteException;"
        implOut.print(source[28]); // 165:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[29]); // 168:23 = " "
        implOut.print(methodName);
        implOut.print(source[30]); // 168:38 = "("
        implOut.print(pcs(params, "DomainContext context"));
        implOut.print(source[31]); // 168:79 = ") throws RemoteException {    try {   ..."
        implOut.print(methodName);
        implOut.print(source[32]); // 170:48 = "("
        implOut.print(iparms);
        implOut.print(source[33]); // 170:59 = ");    }    catch (RuntimeException e) ..."
        out.print(source[34]); // 176:6 = "        "
        out.print(returnType);
        out.print(source[35]); // 177:22 = " obj = getRemoteDelegate()."
        out.print(methodName);
        out.print(source[36]); // 177:63 = "("
        out.print(pcs(iparms, "getDomainContext()"));
        out.print(source[37]); // 177:101 = ");        configureRemoteObject(getDoma..."
      }
    } // end if remote

    if (withJoins) {
      out.print(createJoins());
    }
    if (lock) {
      out.print(source[38]); // 193:2 = "    getSession().assertTxRunning();"
    }
    out.print(source[39]); // 197:2 = "    PreparedStatementWrapper st = getPre..."
    out.print(classVar);
    out.print(statementId);
    out.print(source[40]); // 198:82 = ",      b -> {        StringBuilder sql..."
    if (getEntity().getSuperEntity() != null && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[41]); // genwhere.incl:3:2 = "        sql.append(getSqlClassIdConditio..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[42]); // genwhere.incl:10:2 = "        sql.append(Backend.SQL_AND)    ..."
        out.print(getColumnNameConstant(getContextAttribute(), 0));
        out.print(source[43]); // genwhere.incl:12:70 = ")           .append(Backend.SQL_EQUAL_P..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[44]); // genwhere.incl:22:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[45]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[46]); // genwhere.incl:31:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  boolean isEmbeddingRelation = false;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    if (rel.isEmbedded()) {
                      isEmbeddingRelation = true;
                      leftAttribute = '"' + arg.getEmbeddingColumnPrefix() + rel.getMethodArgs().get(0).getAttribute().getColumnName() + '"';
                    }
                    else {
                      leftAttribute = getColumnNameConstant(rel.getAttribute(), 0);
                    }
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = getColumnNameConstant(rel.getForeignAttribute(), 0);
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() || isEmbeddingRelation ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append(getColumnNameConstant(mattr, 0)).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (int columnIndex = 1; columnIndex < getEffectiveDataType(attr).getColumnCount(null); columnIndex++) {
                        buf.append("           .append(Backend.SQL_AND)\n")
                           .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                           .append(rightClass).append(getColumnNameConstant(attr, columnIndex)).append("))\n")
                           .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append(getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEmbeddingPath() == null ? attr.getEntity() : attr.getEmbeddingPath().get(0));
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(");
                  if (attr.getEmbeddingPath() != null) {
                    try {
                      buf.append('"').append(attr.getColumnName(null, columnIndex)).append("\"))\n");
                    }
                    catch(ModelException mx) {
                      throw new WurbelException("cannot determine embedded column name", mx);
                    }
                  }
                  else {
                    buf.append(compKeyClass).append('.').append(getColumnNameConstant(attr, columnIndex)).append("))\n");
                  }
                  buf.append("           ").append(createRelopCode(arg)).append(";\n");
                }
              }
            }
            else {
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  if (isPathAllowed()) {
                    if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                       buf.append("        sql.append(");
                       buf.append(deriveClassNameForEntity(attr.getEntity()));
                       buf.append(".CLASSVARIABLES.getColumnName(");
                       buf.append(getColumnNameConstant(attr, columnIndex)).append("));\n");
                    }
                    else  {
                      if (isPdo()) {
                        buf.append("        sql.append(getColumnName(");
                        if (attr.isEmbedded()) {
                          buf.append('"').append(attr.getColumnName()).append('"');
                        }
                        else {
                          buf.append(getColumnNameConstant(attr, columnIndex));
                        }
                        buf.append("));\n");
                      }
                      else  {
                        buf.append("        sql.append(").append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                      }
                    }
                  }
                  else  {
                    buf.append("        sql.append(");
                    if (attr.isEmbedded()) {
                      buf.append("getColumnPrefix() + ");
                    }
                    buf.append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                  }
                  buf.append("        sql").append(createRelopCode(arg)).append(";\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[47]); // genwhere.incl:245:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[48]); // genwhere.incl:248:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[49]); // genwhere.incl:253:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[50]); // genwhere.incl:263:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[51]); // genwhere.incl:265:25 = ";"
    }
    out.print(source[52]); // 201:37 = "        b.buildSelectSql(sql, "
    out.print(lock ? "true" : "false");
    out.print(source[53]); // 202:57 = ", "
    out.print(needLimit ? 1 : 0);
    out.print(source[54]); // 202:80 = ", 0);"
    if (sort) {
      out.print(source[55]); // 205:2 = "        String orderSuffix = orderBy();..."
    }
    if (append != null)  {
      out.print(source[56]); // 213:2 = "        sql.append(' ').append("
      out.print(append);
      out.print(source[57]); // 214:41 = ");"
    }
    if (withJoins) {
      out.print(source[58]); // 218:2 = "        js.createJoinedSql(me(), sql);"
    }
    out.print(source[59]); // 222:2 = "        return sql.toString();      } ..."
    if (needLimit) {
      out.print(source[60]); // 228:2 = "    int ndx = getBackend().setLeadingSel..."
    }
    else  {
      out.print(source[61]); // 233:2 = "    int ndx = 1;"
    }

    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }

    if (getContextAttribute() != null) {
      out.print(source[62]); // gensetpar.incl:7:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute().getDataType()));
      out.print(source[63]); // gensetpar.incl:8:68 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[64]); // gensetpar.incl:8:111 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                out.print(source[65]); // gensetpar.incl:21:2 = "    "
                out.print(createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                out.print(source[66]); // gensetpar.incl:22:77 = ";"
              }
            }
          }
        }
      }

      if (!par.isValueLiterally()) {
        out.print(source[67]); // gensetpar.incl:31:2 = "    "
        out.print(createWhereSetPars(par));
        out.print(source[68]); // gensetpar.incl:32:31 = ";"
      }
    }
    if (needLimit) {
      out.print(source[69]); // 242:2 = "    getBackend().setTrailingSelectParame..."
    }
    if (withJoins) {
      out.print(source[70]); // 247:2 = "    return executeFirstPdoQuery(st, js);..."
    }
    else  {
      out.print(source[71]); // 252:2 = "    return executeFirstPdoQuery(st);"
    }
    out.print(source[72]); // 256:2 = "  }"
    if (classVar.isEmpty()) {
      out.print(source[73]); // 260:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[74]); // 262:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------

  @Override
  public String process(String code) {
    int ref = code.lastIndexOf("ndx");
    int pos = code.lastIndexOf("(ndx++,");
    if (pos >= 0 && ref == pos + 1) {
      // remove unnecessary last ++
      code = code.substring(0, pos + 4) + code.substring(pos + 6);
    }
    else {
      // remove unnecessary last ndx +=
      pos = code.lastIndexOf("ndx += st.set(");   // ndx += st.set(DT_POSITION3D, ndx, dropPosition, false, null);
      if (pos >= 0 && ref > pos) {
        code = code.substring(0, pos) + code.substring(pos + 7);
      }
      else {
        pos = code.lastIndexOf(", ndx++, ");   // st.set(SqlType....., ndx++, value.get...)
        if (pos >= 0 && ref > pos) {
          code = code.substring(0, pos + 5) + code.substring(pos + 7);
        }
      }
    }
    return code;
  }
}
