// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for setting up a PdoCache for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoCache
 *     [--secure] [--preload] [--mutable] [--udk]
 *     [--strategy=LRU|LFU|FORGET] [--maxsize=&lt;n&gt;] [--keepquota=&lt;p&gt;] [--configure=&lt;method&gt;]
 *     [index1] [index2] ...
 * <p>
 * arguments:
 * <ul>
 * <li><em>--secure:</em> if cache must check read permission for each access (default is no check).</li>
 * <li><em>--preload:</em> the first access will load all entities at once.</li>
 * <li><em>--mutable:</em> generates a non-shared cache, i.e. mutable PDOs (by default a shared readonly cache is generated).</li>
 * <li><em>--udk:</em> add index for the unique domain key.</li>
 * <li><em>--strategy=LRU|LFU|FORGET:</em> the caching strategy (default is FORGET).</li>
 * <li><em>--maxsize=&lt;n&gt;:</em> the cache size (if not preloaded).</li>
 * <li><em>--keepquota=&lt;p&gt;:</em> percentage of entries to keep when applying caching strategy. Default is 50.</li>
 * <li><em>--configure=&lt;method&gt;:</em> an optional method to further configure the cache.</li>
 * <li><em>--index&lt;n&gt;:</em> additional unique indexes. By default, only the ID-index will be created.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoCache extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {

    // main class
    String pdoName     = getPdoClassName();
    boolean isAbstract = getEntity().isAbstract();
    String pdoType     = isAbstract ? "T" : pdoName;

    boolean secure     = false;
    boolean preload    = false;
    boolean mutable    = false;
    boolean delayed    = true;
    boolean genudk     = false;

    String strategy    = null;
    Integer maxSize    = null;
    Integer keepQuota  = null;
    String configure   = null;

    for (String arg: getOptionArgs())  {
      if (arg.equals("preload")) {
        preload = true;
      }
      else if (arg.equals("secure")) {
        secure = true;
      }
      else if (arg.equals("mutable")) {
        mutable = true;
      }
      else if (arg.equals("immediate")) {
        delayed = false;
      }
      else if (arg.equals("udk")) {
        genudk = true;
      }
      else if (arg.startsWith("strategy=")) {
        strategy = arg.substring(9).toUpperCase(Locale.ROOT);
      }
      else if (arg.startsWith("maxsize=")) {
        maxSize = Integer.valueOf(arg.substring(8));
      }
      else if (arg.startsWith("keepquota=")) {
        keepQuota = Integer.valueOf(arg.substring(10));
      }
      else if (arg.startsWith("configure=")) {
        configure = arg.substring(10);
      }
    }

    if (secure && !getEntity().isRootEntity()) {
      throw new WurbelException(getEntity() + " is not a root-entity");
    }
    if (getEntity().getInheritanceType() == InheritanceType.PLAIN) {
      throw new WurbelException("only concrete (leaf) entity types can be cached within a PLAIN inheritance hierarchy");
    }

    List<Attribute> udk = null;
    String udkType = null;
    String udkName = null;
    String udkSuffix = null;
    if (genudk) {
      udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        if (udk.size() == 1) {
          udkType = getNonPrimitiveJavaType(udk.get(0));
          udkName = udk.get(0).getName();
          udkSuffix = udk.get(0).getMethodNameSuffix();
        }
        else {
          udkType = getEntity().getName() + "UDK";
          udkName = "udk";
          udkSuffix = "UniqueDomainKey";
          udkType = getEntity().getName() + "." + udkType;
        }
      }
      else {
        udk = null;
        genudk = false;
      }
    }

    StringBuilder listenNames = new StringBuilder();
    if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
      for (Entity leaf : getEntity().getLeafEntities()) {
        if (!listenNames.isEmpty()) {
          listenNames.append(", ");
        }
        listenNames.append(leaf.getName()).append(".class");
      }
    }
    else {
      listenNames.append(pdoName).append(".class");
    }

    out.print(source[0]); // 119:2 = "  /** Holder of the PDO cache singleton...."
    if (isAbstract) {
      out.print(source[1]); // 124:2 = "    private static final PdoCache<? exte..."
      out.print(pdoName);
      out.print(source[2]); // 125:55 = "<?>> CACHE = createCache();"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = getNonPrimitiveJavaType(key.getAttribute());
        out.print(source[3]); // 130:2 = "    private static final PdoCacheIndex<?..."
        out.print(pdoName);
        out.print(source[4]); // 131:60 = "<?>, "
        out.print(type);
        out.print(source[5]); // 131:73 = "> "
        out.print(name.toUpperCase(Locale.ROOT) + "_INDEX");
        out.print(source[6]); // 131:119 = " = create"
        out.print(StringHelper.firstToUpper(name));
        out.print(source[7]); // 131:163 = "Index();"
      }

      if (genudk) {
        out.print(source[8]); // 136:2 = "    private static final PdoCacheIndex<?..."
        out.print(pdoName);
        out.print(source[9]); // 137:60 = "<?>, "
        out.print(udkType);
        out.print(source[10]); // 137:76 = "> UDK_INDEX = createUdkIndex();"
      }
      out.print(source[11]); // 140:2 = "    @SuppressWarnings("unchecked")    ..."
      out.print(pdoName);
      out.print(source[12]); // 143:41 = "<X>> PdoCache<X> createCache() {      P..."
      out.print(pdoName);
      out.print(source[13]); // 144:70 = ".class, "
      out.print(preload ? "true" : "false");
      out.print(source[14]); // 144:108 = ", "
      out.print(mutable ? "false" : "true");
      out.print(source[15]); // 144:140 = ", "
      out.print(secure ? "true" : "false");
      out.print(source[16]); // 144:171 = ");      Pdo.listen(cache::expire, "
      out.print(listenNames);
      out.print(source[17]); // 145:47 = ");"
      if (strategy != null) {
        out.print(source[18]); // 148:2 = "      cache.setStrategy(PdoCacheStrategy..."
        out.print(strategy);
        out.print(source[19]); // 149:53 = ");"
      }
      if (maxSize != null) {
        out.print(source[20]); // 153:2 = "      cache.setMaxSize("
        out.print(maxSize);
        out.print(source[21]); // 154:34 = ");"
      }
      if (keepQuota != null) {
        out.print(source[22]); // 158:2 = "      cache.setKeepQuota("
        out.print(keepQuota);
        out.print(source[23]); // 159:38 = ");"
      }
      if (configure != null) {
        out.print(source[24]); // 163:2 = "      "
        out.print(configure);
        out.print(source[25]); // 164:19 = "(cache);"
      }
      out.print(source[26]); // 167:2 = "      return cache;    }"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = getNonPrimitiveJavaType(key.getAttribute());
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplementationStream();
          PrintStream remoteOut = genInc.getInterfaceStream();
          remoteOut.print(source[27]); // 180:16 = "  T selectBy"
          remoteOut.print(suffix);
          remoteOut.print(source[28]); // 181:22 = "ForCache(DomainContext context, "
          remoteOut.print(type);
          remoteOut.print(source[29]); // 181:62 = " "
          remoteOut.print(name);
          remoteOut.print(source[30]); // 181:71 = ") throws RemoteException;"
          implOut.print(source[31]); // 182:14 = "  @Override  public T selectBy"
          implOut.print(suffix);
          implOut.print(source[32]); // 185:29 = "ForCache(DomainContext context, "
          implOut.print(type);
          implOut.print(source[33]); // 185:69 = " "
          implOut.print(name);
          implOut.print(source[34]); // 185:78 = ") throws RemoteException {    try {   ..."
          implOut.print(suffix);
          implOut.print(source[35]); // 187:58 = "("
          implOut.print(name);
          implOut.print(source[36]); // 187:67 = ");    }    catch (RuntimeException e) ..."
          out.print(source[37]); // 193:6 = "    @SuppressWarnings("unchecked")    ..."
          out.print(pdoName);
          out.print(source[38]); // 196:41 = "<X>> PdoCacheIndex<X, "
          out.print(type);
          out.print(source[39]); // 196:71 = "> create"
          out.print(StringHelper.firstToUpper(name));
          out.print(source[40]); // 196:114 = "Index() {      return Pdo.createCacheIn..."
          out.print(pdoName);
          out.print(source[41]); // 197:46 = ":"
          out.print(name);
          out.print(source[42]); // 197:55 = "",                                  (co..."
          out.print(name);
          out.print(source[43]); // 198:52 = ") -> (X) Pdo.create("
          out.print(pdoName);
          out.print(source[44]); // 198:83 = ".class, context).selectBy"
          out.print(suffix);
          out.print(source[45]); // 198:118 = "ForCache("
          out.print(name);
          out.print(source[46]); // 198:135 = "),                                  "
          out.print(pdoName);
          out.print(source[47]); // 199:45 = "::get"
          out.print(suffix);
          out.print(source[48]); // 199:60 = ");    }"
        } // end isRemote
        else {
          out.print(source[49]); // 204:2 = "    @SuppressWarnings("unchecked")    ..."
          out.print(pdoName);
          out.print(source[50]); // 207:41 = "<X>> PdoCacheIndex<X, "
          out.print(type);
          out.print(source[51]); // 207:71 = "> create"
          out.print(StringHelper.firstToUpper(name));
          out.print(source[52]); // 207:114 = "Index() {      return Pdo.createCacheIn..."
          out.print(pdoName);
          out.print(source[53]); // 208:46 = ":"
          out.print(name);
          out.print(source[54]); // 208:55 = "",                                  (co..."
          out.print(name);
          out.print(source[55]); // 209:52 = ") -> (X) Pdo.create("
          out.print(pdoName);
          out.print(source[56]); // 209:83 = ".class, context).findBy"
          out.print(suffix);
          out.print(source[57]); // 209:116 = "("
          out.print(name);
          out.print(source[58]); // 209:125 = "),                                  "
          out.print(pdoName);
          out.print(source[59]); // 210:45 = "::get"
          out.print(suffix);
          out.print(source[60]); // 210:60 = ");    }"
        }
      }

      if (genudk) {
        out.print(source[61]); // 217:2 = "    @SuppressWarnings("unchecked")    ..."
        out.print(pdoName);
        out.print(source[62]); // 220:41 = "<X>> PdoCacheIndex<X, "
        out.print(udkType);
        out.print(source[63]); // 220:74 = "> createUdkIndex() {      return Pdo.cr..."
        out.print(pdoName);
        out.print(source[64]); // 221:46 = ":UDK","
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplementationStream();
          PrintStream remoteOut = genInc.getInterfaceStream();
          remoteOut.print(source[65]); // 228:16 = "  T selectByUniqueDomainKeyForCache(Doma..."
          remoteOut.print(udkType);
          remoteOut.print(source[66]); // 229:70 = " "
          remoteOut.print(udkName);
          remoteOut.print(source[67]); // 229:82 = ") throws RemoteException;"
          implOut.print(source[68]); // 230:14 = "  @Override  public T selectByUniqueDo..."
          implOut.print(udkType);
          implOut.print(source[69]); // 233:77 = " "
          implOut.print(udkName);
          implOut.print(source[70]); // 233:89 = ") throws RemoteException {    try {   ..."
          implOut.print(udkName);
          implOut.print(source[71]); // 235:75 = ");    }    catch (RuntimeException e) ..."
          out.print(source[72]); // 241:6 = "                                  (conte..."
          out.print(udkName);
          out.print(source[73]); // 242:55 = ") -> (X) Pdo.create("
          out.print(pdoName);
          out.print(source[74]); // 242:86 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[75]); // 242:146 = "),"
        }
        else {
          out.print(source[76]); // 246:2 = "                                  (conte..."
          out.print(udkName);
          out.print(source[77]); // 247:55 = ") -> (X) Pdo.create("
          out.print(pdoName);
          out.print(source[78]); // 247:86 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[79]); // 247:138 = "),"
        }
        out.print(source[80]); // 250:2 = "                                  "
        out.print(pdoName);
        out.print(source[81]); // 251:45 = "::get"
        out.print(udkSuffix);
        out.print(source[82]); // 251:63 = ");    }"
      }
      out.print(source[83]); // 255:2 = "  }"

    }   // end isAbstract() ----------------------------------------------------------------
    else {

      out.print(source[84]); // 262:2 = "    private static final PdoCache<"
      out.print(pdoName);
      out.print(source[85]); // 263:45 = "> CACHE = createCache();"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = getNonPrimitiveJavaType(key.getAttribute());
        out.print(source[86]); // 268:2 = "    private static final PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[87]); // 269:50 = ", "
        out.print(type);
        out.print(source[88]); // 269:60 = "> "
        out.print(name.toUpperCase(Locale.ROOT) + "_INDEX");
        out.print(source[89]); // 269:106 = " = create"
        out.print(StringHelper.firstToUpper(name));
        out.print(source[90]); // 269:150 = "Index();"
      }

      if (genudk) {
        out.print(source[91]); // 274:2 = "    private static final PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[92]); // 275:50 = ", "
        out.print(udkType);
        out.print(source[93]); // 275:63 = "> UDK_INDEX = createUdkIndex();"
      }
      out.print(source[94]); // 278:2 = "    private static PdoCache<"
      out.print(pdoName);
      out.print(source[95]); // 280:39 = "> createCache() {      PdoCache<"
      out.print(pdoName);
      out.print(source[96]); // 281:26 = "> cache = Pdo.createPdoCache("
      out.print(pdoName);
      out.print(source[97]); // 281:66 = ".class, "
      out.print(preload ? "true" : "false");
      out.print(source[98]); // 281:104 = ", "
      out.print(mutable ? "false" : "true");
      out.print(source[99]); // 281:136 = ", "
      out.print(secure ? "true" : "false");
      out.print(source[100]); // 281:167 = ");      Pdo.listen(cache::expire, "
      out.print(listenNames);
      out.print(source[101]); // 282:47 = ");"
      if (strategy != null) {
        out.print(source[102]); // 285:2 = "      cache.setStrategy(PdoCacheStrategy..."
        out.print(strategy);
        out.print(source[103]); // 286:53 = ");"
      }
      if (maxSize != null) {
        out.print(source[104]); // 290:2 = "      cache.setMaxSize("
        out.print(maxSize);
        out.print(source[105]); // 291:34 = ");"
      }
      if (keepQuota != null) {
        out.print(source[106]); // 295:2 = "      cache.setKeepQuota("
        out.print(keepQuota);
        out.print(source[107]); // 296:38 = ");"
      }
      if (configure != null) {
        out.print(source[108]); // 300:2 = "      "
        out.print(configure);
        out.print(source[109]); // 301:19 = "(cache);"
      }
      out.print(source[110]); // 304:2 = "      return cache;    }"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = getNonPrimitiveJavaType(key.getAttribute());
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplementationStream();
          PrintStream remoteOut = genInc.getInterfaceStream();
          remoteOut.print(source[111]); // 317:16 = "  "
          remoteOut.print(pdoType);
          remoteOut.print(source[112]); // 318:13 = " selectBy"
          remoteOut.print(suffix);
          remoteOut.print(source[113]); // 318:32 = "ForCache(DomainContext context, "
          remoteOut.print(type);
          remoteOut.print(source[114]); // 318:72 = " "
          remoteOut.print(name);
          remoteOut.print(source[115]); // 318:81 = ") throws RemoteException;"
          implOut.print(source[116]); // 319:14 = "  @Override  public "
          implOut.print(pdoType);
          implOut.print(source[117]); // 322:20 = " selectBy"
          implOut.print(suffix);
          implOut.print(source[118]); // 322:39 = "ForCache(DomainContext context, "
          implOut.print(type);
          implOut.print(source[119]); // 322:79 = " "
          implOut.print(name);
          implOut.print(source[120]); // 322:88 = ") throws RemoteException {    try {   ..."
          implOut.print(suffix);
          implOut.print(source[121]); // 324:58 = "("
          implOut.print(name);
          implOut.print(source[122]); // 324:67 = ");    }    catch (RuntimeException e) ..."
          out.print(source[123]); // 330:6 = "    private static PdoCacheIndex<"
          out.print(pdoName);
          out.print(source[124]); // 332:44 = ", "
          out.print(type);
          out.print(source[125]); // 332:54 = "> create"
          out.print(StringHelper.firstToUpper(name));
          out.print(source[126]); // 332:97 = "Index() {      return Pdo.createCacheIn..."
          out.print(pdoName);
          out.print(source[127]); // 333:46 = ":"
          out.print(name);
          out.print(source[128]); // 333:55 = "",                                  (co..."
          out.print(name);
          out.print(source[129]); // 334:52 = ") -> Pdo.create("
          out.print(pdoName);
          out.print(source[130]); // 334:79 = ".class, context).selectBy"
          out.print(suffix);
          out.print(source[131]); // 334:114 = "ForCache("
          out.print(name);
          out.print(source[132]); // 334:131 = "),                                  "
          out.print(pdoName);
          out.print(source[133]); // 335:45 = "::get"
          out.print(suffix);
          out.print(source[134]); // 335:60 = ");    }"
        } // end isRemote
        else {
          out.print(source[135]); // 340:2 = "    private static PdoCacheIndex<"
          out.print(pdoName);
          out.print(source[136]); // 342:44 = ", "
          out.print(type);
          out.print(source[137]); // 342:54 = "> create"
          out.print(StringHelper.firstToUpper(name));
          out.print(source[138]); // 342:97 = "Index() {      return Pdo.createCacheIn..."
          out.print(pdoName);
          out.print(source[139]); // 343:46 = ":"
          out.print(name);
          out.print(source[140]); // 343:55 = "",                                  (co..."
          out.print(name);
          out.print(source[141]); // 344:52 = ") -> Pdo.create("
          out.print(pdoName);
          out.print(source[142]); // 344:79 = ".class, context).findBy"
          out.print(suffix);
          out.print(source[143]); // 344:112 = "("
          out.print(name);
          out.print(source[144]); // 344:121 = "),                                  "
          out.print(pdoName);
          out.print(source[145]); // 345:45 = "::get"
          out.print(suffix);
          out.print(source[146]); // 345:60 = ");    }"
        }
      }

      if (genudk) {
        out.print(source[147]); // 352:2 = "    private static PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[148]); // 354:44 = ", "
        out.print(udkType);
        out.print(source[149]); // 354:57 = "> createUdkIndex() {      return Pdo.cr..."
        out.print(pdoName);
        out.print(source[150]); // 355:46 = ":UDK","
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplementationStream();
          PrintStream remoteOut = genInc.getInterfaceStream();
          remoteOut.print(source[151]); // 362:16 = "  "
          remoteOut.print(pdoType);
          remoteOut.print(source[152]); // 363:13 = " selectByUniqueDomainKeyForCache(DomainC..."
          remoteOut.print(udkType);
          remoteOut.print(source[153]); // 363:80 = " "
          remoteOut.print(udkName);
          remoteOut.print(source[154]); // 363:92 = ") throws RemoteException;"
          implOut.print(source[155]); // 364:14 = "  @Override  public "
          implOut.print(pdoType);
          implOut.print(source[156]); // 367:20 = " selectByUniqueDomainKeyForCache(DomainC..."
          implOut.print(udkType);
          implOut.print(source[157]); // 367:87 = " "
          implOut.print(udkName);
          implOut.print(source[158]); // 367:99 = ") throws RemoteException {    try {   ..."
          implOut.print(udkName);
          implOut.print(source[159]); // 369:75 = ");    }    catch (RuntimeException e) ..."
          out.print(source[160]); // 375:6 = "                                  (conte..."
          out.print(udkName);
          out.print(source[161]); // 376:55 = ") -> Pdo.create("
          out.print(pdoName);
          out.print(source[162]); // 376:82 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[163]); // 376:142 = "),"
        }
        else {
          out.print(source[164]); // 380:2 = "                                  (conte..."
          out.print(udkName);
          out.print(source[165]); // 381:55 = ") -> Pdo.create("
          out.print(pdoName);
          out.print(source[166]); // 381:82 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[167]); // 381:134 = "),"
        }
        out.print(source[168]); // 384:2 = "                                  "
        out.print(pdoName);
        out.print(source[169]); // 385:45 = "::get"
        out.print(udkSuffix);
        out.print(source[170]); // 385:63 = ");    }"
      }
      out.print(source[171]); // 389:2 = "  }"
    }

    String filterBegin = "";
    String filterEnd = "";

    if (getEntity().isAbstract()) {
      filterBegin = "filterByClassId(";
      filterEnd = ")";

      if (getEntity().getSuperEntity() == null) {
        out.print(source[172]); // 402:2 = "  private boolean isValidClassId(T pdo)..."
      }
      else {
        out.print(source[173]); // 422:2 = "  private boolean isValidClassId(T pdo)..."
      }
    }

    out.print(source[174]); // 439:2 = "  @Override"
    if (isAbstract) {
      out.print(source[175]); // 444:2 = "  @SuppressWarnings("unchecked")"
    }
    out.print(source[176]); // 448:2 = "  public PdoCache<"
    out.print(pdoType);
    out.print(source[177]); // 449:29 = "> getCache() {"
    if (isAbstract) {
      out.print(source[178]); // 452:2 = "    return (PdoCache<"
      out.print(pdoType);
      out.print(source[179]); // 453:32 = ">) CacheHolder.CACHE;"
    }
    else {
      out.print(source[180]); // 457:2 = "    return CacheHolder.CACHE;"
    }
    out.print(source[181]); // 461:2 = "  }  @Override  public boolean isCoun..."
    out.print(pdoType);
    out.print(source[182]); // 481:20 = " selectCachedOnly(long id) {    return ..."
    out.print(filterBegin);
    out.print(source[183]); // 482:26 = "getCache().select(getDomainContext(), id..."
    out.print(filterEnd);
    out.print(source[184]); // 482:87 = ";  }  @Override  public "
    out.print(pdoType);
    out.print(source[185]); // 486:20 = " selectCached(long id) {    return "
    out.print(filterBegin);
    out.print(source[186]); // 487:26 = "getCache().select(getDomainContext(), id..."
    out.print(filterEnd);
    out.print(source[187]); // 487:80 = ";  }"
    for (WurbletArgument key: getExpressionArguments()) {
      String name = key.getMethodArgumentName();
      String type = getNonPrimitiveJavaType(key.getAttribute());
      String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
      String indexCast = getEntity().isAbstract() ? ("(PdoCacheIndex<T, " + type + ">) ") : "";
      String indexName = "CacheHolder." + name.toUpperCase(Locale.ROOT) + "_INDEX";
      String indexMethod = "getCacheIndex" + StringHelper.firstToUpper(name);
      out.print(source[188]); // 497:2 = "  /**   * Gets the index for "
      out.print(name);
      out.print(source[189]); // 500:32 = ".   *   * @return the index for "
      out.print(type);
      out.print(source[190]); // 502:36 = " "
      out.print(name);
      out.print(source[191]); // 502:45 = "   */"
      if (isAbstract) {
        out.print(source[192]); // 506:2 = "  @SuppressWarnings("unchecked")"
      }
      out.print(source[193]); // 510:2 = "  protected PdoCacheIndex<"
      out.print(pdoType);
      out.print(source[194]); // 511:37 = ", "
      out.print(type);
      out.print(source[195]); // 511:47 = "> "
      out.print(indexMethod);
      out.print(source[196]); // 511:64 = "() {    return "
      out.print(indexCast);
      out.print(indexName);
      out.print(source[197]); // 512:37 = ";  }  /**   * Selects from cache by ..."
      out.print(name);
      out.print(source[198]); // 516:35 = " but does not load from db if not in cac..."
      out.print(name);
      out.print(source[199]); // 518:21 = " the unique key   * @return the pdo, nu..."
      out.print(pdoType);
      out.print(source[200]); // 522:20 = " selectCachedOnlyBy"
      out.print(suffix);
      out.print(source[201]); // 522:49 = "("
      out.print(type);
      out.print(source[202]); // 522:58 = " "
      out.print(name);
      out.print(source[203]); // 522:67 = ")  {    return "
      out.print(filterBegin);
      out.print(source[204]); // 523:26 = "getCache().select("
      out.print(indexMethod);
      out.print(source[205]); // 523:59 = "(), getDomainContext(), "
      out.print(name);
      out.print(source[206]); // 523:91 = ", false)"
      out.print(filterEnd);
      out.print(source[207]); // 523:112 = ";  }  /**   * Selects via cache by "
      out.print(name);
      out.print(source[208]); // 527:34 = ".   *   * @param "
      out.print(name);
      out.print(source[209]); // 529:21 = " the unique key   * @return the pdo, nu..."
      out.print(pdoType);
      out.print(source[210]); // 533:20 = " selectCachedBy"
      out.print(suffix);
      out.print(source[211]); // 533:45 = "("
      out.print(type);
      out.print(source[212]); // 533:54 = " "
      out.print(name);
      out.print(source[213]); // 533:63 = ")  {    return "
      out.print(filterBegin);
      out.print(source[214]); // 534:26 = "getCache().select("
      out.print(indexMethod);
      out.print(source[215]); // 534:59 = "(), getDomainContext(), "
      out.print(name);
      out.print(source[216]); // 534:91 = ")"
      out.print(filterEnd);
      out.print(source[217]); // 534:105 = ";  }  /**   * Selects via remote cac..."
      out.print(name);
      out.print(source[218]); // 538:41 = ", if session is remote.   *   * @param..."
      out.print(name);
      out.print(source[219]); // 540:21 = " the unique key   * @return the pdo, nu..."
      out.print(pdoType);
      out.print(source[220]); // 544:20 = " selectBy"
      out.print(suffix);
      out.print(source[221]); // 544:39 = "ForCache("
      out.print(type);
      out.print(source[222]); // 544:56 = " "
      out.print(name);
      out.print(source[223]); // 544:65 = ") {    "
      out.print(pdoType);
      out.print(source[224]); // 545:15 = " obj;    if (getSession().isRemote()) {..."
      out.print(suffix);
      out.print(source[225]); // 549:52 = "ForCache(context, "
      out.print(name);
      out.print(source[226]); // 549:78 = ");        configureRemoteObject(context..."
      out.print(suffix);
      out.print(source[227]); // 557:33 = "("
      out.print(name);
      out.print(source[228]); // 557:42 = ");    }    return "
      out.print(filterBegin);
      out.print(source[229]); // 559:26 = "obj"
      out.print(filterEnd);
      out.print(source[230]); // 559:42 = ";  }"
    }

    if (genudk) {
      String indexCast = isAbstract ? ("(PdoCacheIndex<T, " + udkType + ">) ") : "";
      String indexMethod = "getCacheIndexUdk";
      out.print(source[231]); // 567:2 = "  /**   * Gets the index for the uniqu..."
      out.print(udkType);
      out.print(source[232]); // 572:39 = " "
      out.print(udkName);
      out.print(source[233]); // 572:51 = "   */"
      if (isAbstract) {
        out.print(source[234]); // 576:2 = "  @SuppressWarnings("unchecked")"
      }
      out.print(source[235]); // 580:2 = "  protected PdoCacheIndex<"
      out.print(pdoType);
      out.print(source[236]); // 581:37 = ", "
      out.print(udkType);
      out.print(source[237]); // 581:50 = "> "
      out.print(indexMethod);
      out.print(source[238]); // 581:67 = "() {    return "
      out.print(indexCast);
      out.print(source[239]); // 582:24 = "CacheHolder.UDK_INDEX;  }  /**   * S..."
      out.print(udkName);
      out.print(source[240]); // 588:24 = " the unique domain key   * @return the ..."
      out.print(pdoType);
      out.print(source[241]); // 592:20 = " selectCachedOnlyByUniqueDomainKey("
      out.print(udkType);
      out.print(source[242]); // 592:66 = " "
      out.print(udkName);
      out.print(source[243]); // 592:78 = ")  {    return "
      out.print(filterBegin);
      out.print(source[244]); // 593:26 = "getCache().select("
      out.print(indexMethod);
      out.print(source[245]); // 593:59 = "(), getDomainContext(), "
      out.print(udkName);
      out.print(source[246]); // 593:94 = ", false)"
      out.print(filterEnd);
      out.print(source[247]); // 593:115 = ";  }  /**   * Selects via cache by u..."
      out.print(udkName);
      out.print(source[248]); // 599:24 = " the unique key   * @return the pdo, nu..."
      out.print(pdoType);
      out.print(source[249]); // 603:20 = " selectCachedByUniqueDomainKey("
      out.print(udkType);
      out.print(source[250]); // 603:62 = " "
      out.print(udkName);
      out.print(source[251]); // 603:74 = ")  {    return "
      out.print(filterBegin);
      out.print(source[252]); // 604:26 = "getCache().select("
      out.print(indexMethod);
      out.print(source[253]); // 604:59 = "(), getDomainContext(), "
      out.print(udkName);
      out.print(source[254]); // 604:94 = ")"
      out.print(filterEnd);
      out.print(source[255]); // 604:108 = ";  }  /**   * Selects via remote cac..."
      out.print(udkName);
      out.print(source[256]); // 610:24 = " the unique key   * @return the pdo, nu..."
      out.print(pdoType);
      out.print(source[257]); // 614:20 = " selectByUniqueDomainKeyForCache("
      out.print(udkType);
      out.print(source[258]); // 614:64 = " "
      out.print(udkName);
      out.print(source[259]); // 614:76 = ") {    "
      out.print(pdoType);
      out.print(source[260]); // 615:15 = " obj;    if (getSession().isRemote()) {..."
      out.print(udkName);
      out.print(source[261]); // 619:86 = ");        configureRemoteObject(context..."
      out.print(udkName);
      out.print(source[262]); // 627:50 = ");    }    return "
      out.print(filterBegin);
      out.print(source[263]); // 629:26 = "obj"
      out.print(filterEnd);
      out.print(source[264]); // 629:42 = ";  }"
    }

    out.print(source[265]); // 634:2 = "  @Override  public List<"
    out.print(pdoType);
    out.print(source[266]); // 637:25 = "> selectAllCached() {    return "
    out.print(filterBegin);
    out.print(source[267]); // 638:26 = "getCache().selectAll(getDomainContext())..."
    out.print(filterEnd);
    out.print(source[268]); // 638:79 = ";  }"
  }

  // ----------------- end wurblet code -----------------
}
