// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk] [--noisroot] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * <li><em>--noisroot:</em> don't generate isRootEntity() method.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    try {
      pdoClass = getPdoClassName();
    }
    catch (WurbelException we) {
      // not a PDO -> isPdo() is false and pdoClass isn't used for low-level db-objects by this wurblet
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;
    boolean generateIsRoot = true;
    boolean generateMock = false;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
      else if ("noisroot".equals(arg)) {
        generateIsRoot = false;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    boolean generateCreateNormText = false;
    boolean generatePresetVirgin = false;
    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isPartOfNormText())  {
        generateCreateNormText = true;
      }
      if (attr.getOptions().getNewValue() != null) {
        generatePresetVirgin = true;
      }
    }
    if (!generateCreateNormText) {
      for (Attribute attr: getEntity().getEmbeddedAttributes())  {
        if (attr.getOptions().isPartOfNormText())  {
          generateCreateNormText = true;
          break;
        }
      }
    }

    if (!generateMock) {
      if (isRemote()) {
        new RemoteIncludes(this);   // create RMI-files if they don't exist yet
        String delegateType = NamingRules.getInstance().getPdoRemoteInterface(isPdo() ? pdoClass : mainClass);
        if (getEntity().isAbstract()) {
          delegateType += "<T,P>";
        }
        out.print(source[0]); // 78:2 = "  @Override  public "
        out.print(delegateType);
        out.print(source[1]); // 81:25 = " getRemoteDelegate() {    return ("
        out.print(delegateType);
        out.print(source[2]); // 82:28 = ") super.getRemoteDelegate();  }"
      }

      if (getEntity().isAbstract()) {
        if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
          out.print(source[3]); // 89:2 = "  @Override  public boolean isExplicit..."
        }
      }

      if (getEntity().getSuperEntity() != null &&
          (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE || getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI)) {
        List<Entity> leafs = getEntity().getLeafEntities();
        if (!leafs.isEmpty()) {
          int[] classIds = new int[leafs.size()];
          int ndx = 0;
          for (Entity leaf : leafs) {
            classIds[ndx++] = leaf.getClassId();
          }
          Arrays.sort(classIds);    // predictable order
          StringBuilder buf = new StringBuilder();
          boolean needComma = false;
          for (int classId : classIds) {
            if (needComma) {
              buf.append(", ");
            }
            else {
              needComma = true;
            }
            buf.append(classId);
          }
          out.print(source[4]); // 120:2 = "  private static final List<Integer> VA..."
          out.print(buf);
          out.print(source[5]); // 122:70 = ");  @Override  public List<Integer> g..."
        }
      }

      boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

      boolean readOnly = getEntity().getOptions().isReadOnly();
      if (readOnly) {
        out.print(source[6]); // 136:2 = "  @Override  public boolean isImmutabl..."
      }

      if (getEntity().getSuperEntity() == null) {

        if (generateIsRoot && getEntity().getOptions().isRoot()) {
          out.print(source[7]); // 153:2 = "  @Override  public boolean isRootEnti..."
        }

        if (getEntity().isEmbedded()) {
          out.print(source[8]); // 163:2 = "  @Override  public boolean isEmbedded..."
        }

        if (getEntity().getOptions().isTableSerialProvided()) {
          out.print(source[9]); // 173:2 = "  @Override  public boolean isTableSer..."
        }

        if (getEntity().getOptions().isTokenLockProvided()) {
          out.print(source[10]); // 183:2 = "  @Override  public boolean isTokenLoc..."
        }

        if (getEntity().getOptions().isNormTextProvided()) {
          out.print(source[11]); // 193:2 = "  @Override  public boolean isNormText..."
        }

        if (getEntity().getOptions().isRootIdProvided()) {
          out.print(source[12]); // 203:2 = "  @Override  public boolean isRootIdPr..."
        }
        else if (!getEntity().isEmbedded()) {
          Attribute rootAttribute = getEntity().getRootAttribute();
          if (rootAttribute != null) {

            out.print(source[13]); // 215:2 = "  @Override  public long getRootId() {..."
            out.print(rootAttribute.getName());
            out.print(source[14]); // 219:38 = ";  }"
          }
        }

        if (getEntity().getOptions().isRootClassIdProvided()) {
          out.print(source[15]); // 226:2 = "  @Override  public boolean isRootClas..."
        }
        else if (!getEntity().isEmbedded()) {
          Entity rootEntity = getEntity().getRootEntity();
          if (rootEntity != null) {
            out.print(source[16]); // 237:2 = "  @Override  public int getRootClassId..."
            out.print(rootEntity.getClassId());
            out.print(source[17]); // 241:38 = ";  }"
          }
        }

        if (isTracked())  {
          out.print(source[18]); // 248:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[19]); // 259:2 = "  @Override  public void setModified(b..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute())    {
            if (isFullTracked()) {
              out.print(source[20]); // 269:2 = "      "
              out.print(attr.getName());
              out.print(source[21]); // 270:24 = "Persisted = "
              out.print(attr.getName());
              out.print(source[22]); // 270:54 = ";"
            }
            else {
              out.print(source[23]); // 274:2 = "      "
              out.print(attr.getName());
              out.print(source[24]); // 275:24 = "Modified = false;"
            }
          }
        }
        out.print(source[25]); // 280:2 = "    }  }"
      }


      if (isFullTracked()) {
        out.print(source[26]); // 288:2 = "  @Override  public boolean differsPer..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute() &&
              !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
            if (attr.getDataType().isPrimitive()) {
              out.print(source[27]); // 298:2 = "           || "
              out.print(attr.getName());
              out.print(source[28]); // 299:32 = "Persisted != "
              out.print(attr.getName());
              out.print(source[29]); // 299:63 = ""
            }
            else {
              out.print(source[30]); // 303:2 = "           || !Objects.equals("
              out.print(attr.getName());
              out.print(source[31]); // 304:48 = "Persisted, "
              out.print(attr.getName());
              out.print(source[32]); // 304:77 = ")"
            }
          }
        }
        out.print(source[33]); // 309:2 = "           ;  }  @Override  public b..."
      }

      if (!getEntity().getInheritanceType().isMappingToNoTable() || getEntity().isEmbedded()) {
        if (getEntity().isEmbedded()) {
          out.print(source[34]); // 322:2 = "  @Override  public void configureEmbe..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[35]); // 329:2 = "    ((AbstractPersistentObject<?,?>) "
              out.print(rel.getGetterName());
              out.print(source[36]); // 330:60 = "().getPersistenceDelegate()).configureEm..."
            }
          }

          for (Attribute attr: getEntity().getMappedAttributes())  {
            if (!attr.getOptions().isMute())  {
              DataType<?> effectiveType = getEffectiveDataType(attr);
              if (effectiveType.isColumnCountBackendSpecific()) {
                out.print(source[37]); // 339:2 = "    rs.configureColumns("
                out.print(effectiveType.getDataTypeConstant());
                out.print(source[38]); // 340:63 = ", getColumnPrefix() + "
                out.print(getColumnNameConstant(attr, -1));
                out.print(source[39]); // 340:120 = ");"
              }
              else {
                for (int columnIndex = 0; columnIndex < effectiveType.getColumnCount(null); columnIndex++) {
                  out.print(source[40]); // 345:2 = "    rs.configureColumn(getColumnPrefix()..."
                  out.print(getColumnNameConstant(attr, columnIndex));
                  out.print(source[41]); // 346:87 = ");"
                }
              }
            }
          }
          out.print(source[42]); // 352:2 = "  }"
        }
        else {
          String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
          if (orderBy != null) {
            out.print(source[43]); // 359:2 = "  @Override  public String orderBy() {..."
            out.print(orderBy);
            out.print(source[44]); // 364:18 = ";    return sql.toString();  }"
          }
        }
        out.print(source[45]); // 370:2 = "  @Override  public void getFields(Res..."

        boolean needConfig = false;

        if (!getEntity().isEmbedded()) {
          out.print(source[46]); // 379:2 = "    super.getFields(rs);"
          for (Attribute attr: getEntity().getMappedAttributes())  {
            if (!attr.getOptions().isMute())  {
              needConfig = true;
              break;
            }
          }
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              needConfig = true;
              break;
            }
          }
        }

        if (needConfig) {
          out.print(source[47]); // 397:2 = "    if (rs.configureSection(CLASSVARIABL..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[48]); // 402:2 = "      ((AbstractPersistentObject<?,?>) "
              out.print(rel.getGetterName());
              out.print(source[49]); // 403:62 = "().getPersistenceDelegate()).configureEm..."
            }
          }

          for (Attribute attr: getEntity().getMappedAttributes())  {
            if (!attr.getOptions().isMute())  {
              DataType<?> effectiveType = getEffectiveDataType(attr);
              if (effectiveType.isColumnCountBackendSpecific()) {
                out.print(source[50]); // 412:2 = "      rs.configureColumns("
                out.print(effectiveType.getDataTypeConstant());
                out.print(source[51]); // 413:65 = ", "
                out.print(getColumnNameConstant(attr, -1));
                out.print(source[52]); // 413:102 = ");"
              }
              else {
                for (int columnIndex = 0; columnIndex < effectiveType.getColumnCount(null); columnIndex++) {
                  out.print(source[53]); // 418:2 = "      rs.configureColumn("
                  out.print(getColumnNameConstant(attr, columnIndex));
                  out.print(source[54]); // 419:69 = ");"
                }
              }
            }
          }
          out.print(source[55]); // 425:2 = "    }"
        }
        else if (!getEntity().isEmbedded()) {
          out.print(source[56]); // 430:2 = "    rs.configureSection(CLASSVARIABLES);..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[57]); // 435:2 = "    ((AbstractPersistentObject<?,?>) "
              out.print(rel.getGetterName());
              out.print(source[58]); // 436:60 = "().getPersistenceDelegate()).configureEm..."
            }
          }
        }

        for (Relation rel: getEntity().getRelations()) {
          if (rel.isEmbedding()) {
            out.print(source[59]); // 444:2 = "    ((AbstractPersistentObject<?,?>) "
            out.print(rel.getGetterName());
            out.print(source[60]); // 445:60 = "().getPersistenceDelegate()).getFields(r..."
          }
        }

        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isMute())  {
            String name = attr.getName().toUpperCase(Locale.ROOT);
            boolean useSetter = isAttributeDerived(attr);
            DataType<?> dataType = getEffectiveDataType(attr);
            if (dataType.isPredefined()) {
              String getterMethod = createJdbcGetterName(attr);
              if ("Binary".equals(attr.getDataType().getJavaType())) {
                // Binary getter takes additional buffer size argument
                int bufsize = attr.getSize() == null ? 0 : attr.getSize();
                if (useSetter)  {
                  out.print(source[61]); // 461:2 = "    "
                  out.print(attr.getSetterName());
                  out.print(source[62]); // 462:28 = "(rs."
                  out.print(getterMethod);
                  out.print(source[63]); // 462:48 = "("
                  out.print(bufsize);
                  out.print(source[64]); // 462:60 = "));"
                }
                else  {
                  out.print(source[65]); // 466:2 = "    "
                  out.print(attr.getName());
                  out.print(source[66]); // 467:22 = " = rs."
                  out.print(getterMethod);
                  out.print(source[67]); // 467:44 = "("
                  out.print(bufsize);
                  out.print(source[68]); // 467:56 = ");"
                }
              }
              else  {
                String rsGetter = "rs." + getterMethod + "(";
                boolean needComma = false;
                if (attr.getOptions().isWithTimezone()) {
                  rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                  needComma = true;
                }
                if (attr.getOptions().isMapNull()) {
                  if (needComma) {
                    rsGetter += ", ";
                  }
                  rsGetter += "true";
                  needComma = true;
                }
                rsGetter += ")";

                String modelCode = getModelCode(attr, rsGetter);

                if (attr.getOptions().isTrimRead() && attr.getSize() != null) {
                  modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSize() + ")";
                }

                if (useSetter) {
                  modelCode = attr.getSetterName() + "(" + modelCode + ")";
                }
                else  {
                  modelCode = attr.getName() + " = " + modelCode;
                }
                out.print(source[69]); // 499:2 = "    "
                out.print(modelCode);
                out.print(source[70]); // 500:17 = ";"
                if (attr.getOptions().isUTC()) {
                  if (useSetter) {
                    modelCode = attr.getGetterName() + "()";
                  }
                  else  {
                    modelCode = attr.getName();
                  }
                  out.print(source[71]); // 509:2 = "    if ("
                  out.print(modelCode);
                  out.print(source[72]); // 510:21 = " != null) {      "
                  out.print(modelCode);
                  out.print(source[73]); // 511:19 = ".setUTC(true);    }"
                }
              }
            }
            else {    // application specific type
              String rsGetter = "rs.get(" + dataType.getDataTypeConstant() + ", " + attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
              String modelCode = getModelCode(attr, rsGetter);
              if (useSetter) {
                modelCode = attr.getSetterName() + "(" + modelCode + ")";
              }
              else  {
                modelCode = attr.getName() + " = " + modelCode;
              }
              out.print(source[74]); // 526:2 = "    "
              out.print(modelCode);
              out.print(source[75]); // 527:17 = ";"
            }
          }
        }
        out.print(source[76]); // 532:2 = "  }"
        if (!readOnly) {
          if (multiInheritance) {
            out.print(source[77]); // 537:2 = "  /**   * Sets the values of all "
            out.print(pdoClass);
            out.print(source[78]); // 540:40 = "-columns in the given statement.   *  ..."
            out.print(pdoClass);
            out.print(source[79]); // 545:34 = "(PreparedStatementWrapper st) {    int ..."
          }
          else  {
            if (getEntity().isEmbedded()) {
              out.print(source[80]); // 551:2 = "  @Override  public int setEmbeddedFie..."
            }
            else {
              out.print(source[81]); // 558:2 = "  @Override  public int setFields(Prep..."
            }
          }

          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[82]); // 569:2 = "    ndx = ((AbstractPersistentObject<?,?..."
              out.print(rel.getGetterName());
              out.print(source[83]); // 570:66 = "().getPersistenceDelegate()).setEmbedded..."
            }
          }

          for (Attribute attr: getEntity().getMappedAttributes()) {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly())  {
              boolean useGetter = isAttributeDerived(attr);
              DataType<?> dataType = getEffectiveDataType(attr);
              if (dataType.isPredefined()) {
                String setterName = createJdbcSetterName(dataType);

                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }

                String jdbcCode = getJdbcCode(attr, modelCode);

                if (attr.getOptions().isTrimWrite() && attr.getSize() != null) {
                  jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSize() + ")";
                }

                jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
                if (attr.getOptions().isWithTimezone()) {
                  jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                }
                if (attr.getOptions().isMapNull()) {
                  jdbcCode += ", true)";
                }
                else  {
                  jdbcCode += ")";
                }
                out.print(source[84]); // 606:2 = "    "
                out.print(jdbcCode);
                out.print(source[85]); // 607:16 = ";"

                // for multi column types, such as BMoney or application specific types
                int diff = getEffectiveDataType(attr).getColumnCount(null) - 1;
                if (diff == 1) {
                  out.print(source[86]); // 613:2 = "    ndx++;"
                }
                else if (diff > 1) {
                  out.print(source[87]); // 618:2 = "    ndx += "
                  out.print(diff);
                  out.print(source[88]); // 619:19 = ";"
                }
              }
              else {    // application specific type
                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }
                String jdbcCode = "ndx += st.set(" + dataType.getDataTypeConstant() + ", ndx + 1, " +
                                  getJdbcCode(attr, modelCode) + ", " +
                                  attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
                                  out.print(source[89]); // 634:2 = "    "
                                  out.print(jdbcCode);
                                  out.print(source[90]); // 635:16 = ";"
              }
            }
          }

          if (multiInheritance && getEntity().getSuperEntity() != null) {
            out.print(source[91]); // 642:2 = "    st.setLong(++ndx, getId());"
          }
          out.print(source[92]); // 646:2 = "    return ndx;  }"
        }
      }

      if (getEntity().getInheritanceType().isMappingToOwnTable() || getEntity().isEmbedded()) {

        List<Attribute> attributes = multiInheritance ? getEntity().getTableAttributes().stream().filter(a -> !a.isEmbedded()).toList() :
                                                        getEntity().getAttributesIncludingInherited();
        List<String> names = new ArrayList<>();                         // column name constants CN_...
        Map<Attribute, DataType<?>> bsAttrs = new LinkedHashMap<>();    // backend-specific attributes requires special handling
        if (!readOnly) {
          for (Attribute attr: attributes)  {
            DataType<?> effectiveType = getEffectiveDataType(attr);
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly()) {
              if (effectiveType.isColumnCountBackendSpecific()) {
                bsAttrs.put(attr, effectiveType);     // remember for later below...
                names.add(effectiveType.getDataTypeConstant() + ".createColumnNamesAsString(backend, " + getColumnNameConstant(attr, -1) + ", Backend.SQL_COMMA)");
              }
              else {
                for (int columnIndex = 0; columnIndex < effectiveType.getColumnCount(null); columnIndex++) {
                  names.add(getColumnNameConstant(attr, columnIndex));
                }
              }
            }
          }

          if (multiInheritance) {
            out.print(source[93]); // 676:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[94]); // 679:46 = " insert statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[95]); // 683:43 = "(Backend backend) {"
          }
          else  {
            out.print(source[96]); // 687:2 = "  @Override  public String createInser..."
          }

          if (getEntity().isEmbedded()) {
            out.print(source[97]); // 695:2 = "    return"
          }
          else {
            out.print(source[98]); // 700:2 = "    return Backend.SQL_INSERT_INTO + "
            out.print(multiInheritance ? "CLASSVARIABLES." : "");
            out.print(source[99]); // 701:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."
          }

          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[100]); // 707:2 = "           ((AbstractPersistentObject<?,..."
              out.print(rel.getGetterName());
              out.print(source[101]); // 708:67 = "().getPersistenceDelegate()).createInser..."
            }
          }

          int count = 0;
          String prefix = getEntity().isEmbedded() ? "getColumnPrefix() + " : "";

          for (String name: names) {
            String lineSep = count == names.size() - 1 ? (getEntity().isEmbedded() ? " + Backend.SQL_COMMA;" : " +") : " + Backend.SQL_COMMA +";
            out.print(source[102]); // 718:2 = "           "
            out.print(prefix);
            out.print(name);
            out.print(lineSep);
            out.print(source[103]); // 719:40 = ""
            count++;
          }

          if (!getEntity().isEmbedded()) {
            out.print(source[104]); // 725:2 = "           Backend.SQL_INSERT_VALUES +"
            count = names.size() - bsAttrs.size() - 1 + getEmbeddedTableAttributes().size();
            if (count == 1) {
              out.print(source[105]); // 730:2 = "           Backend.SQL_PAR_COMMA +"
            }
            else if (count > 1) {
              out.print(source[106]); // 735:2 = "           Backend.SQL_PAR_COMMA.repeat(..."
              out.print(count);
              out.print(source[107]); // 736:49 = ") +"
            }

            boolean onlyBsAttrs = count < 0;    // only backend-specific datatypes -> subtract 1 from last bs entry
            Map<DataType<?>, Integer> typeCountMap = new HashMap<>();
            for (Map.Entry<Attribute, DataType<?>> entry : bsAttrs.entrySet()) {
              DataType<?> dataType = entry.getValue();
              Integer typeCount = typeCountMap.get(dataType);
              if (typeCount == null) {
                typeCountMap.put(dataType, 1);
              }
              else {
                typeCountMap.put(dataType, typeCount + 1);
              }
            }

            count = 0;
            for (Map.Entry<DataType<?>, Integer> entry : typeCountMap.entrySet()) {
              count++;
              DataType<?> dataType = entry.getKey();
              int typeCount = entry.getValue();
              String factor = typeCount > 1 ? " * " + typeCount : "";
              if (onlyBsAttrs && count >= typeCountMap.size()) {
                factor += " - 1";
              }
              out.print(source[108]); // 762:2 = "           Backend.SQL_PAR_COMMA.repeat(..."
              out.print(dataType.getDataTypeConstant());
              out.print(source[109]); // 763:74 = ".getColumnCount(backend)"
              out.print(factor);
              out.print(source[110]); // 763:108 = ") +"
            }
            out.print(source[111]); // 766:2 = "           Backend.SQL_PAR + Backend.SQL..."
          }
          out.print(source[112]); // 770:2 = "  }"

          names.clear();
          for (Attribute attr: attributes)  {
            DataType<?> effectiveType = getEffectiveDataType(attr);
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
              if (effectiveType.isColumnCountBackendSpecific()) {
                names.add(effectiveType.getDataTypeConstant() + ".createColumnNamesAsString(backend, " + getColumnNameConstant(attr, -1) + ", Backend.SQL_EQUAL_PAR_COMMA)");
              }
              else {
                for (int columnIndex = 0; columnIndex < effectiveType.getColumnCount(null); columnIndex++) {
                  names.add(getColumnNameConstant(attr, columnIndex));
                }
              }
            }
          }

          if (multiInheritance) {
            out.print(source[113]); // 790:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[114]); // 793:46 = " update statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[115]); // 797:43 = "(Backend backend) {"
          }
          else  {
            out.print(source[116]); // 801:2 = "  @Override  public String createUpdat..."
          }

          if (getEntity().isEmbedded()) {
            out.print(source[117]); // 809:2 = "    return"
          }
          else {
            out.print(source[118]); // 814:2 = "    return Backend.SQL_UPDATE + "
            out.print(multiInheritance ? "CLASSVARIABLES." : "");
            out.print(source[119]); // 815:77 = "getTableName() + Backend.SQL_SET +"
          }

          for (Relation rel: getEntity().getRelations()) {
            if (rel.isEmbedding()) {
              out.print(source[120]); // 821:2 = "           ((AbstractPersistentObject<?,..."
              out.print(rel.getGetterName());
              out.print(source[121]); // 822:67 = "().getPersistenceDelegate()).createUpdat..."
            }
          }

          boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
          int ncnt = 0;
          for (String name: names) {
            ncnt++;
            if (!checkSerial && ncnt == names.size()) {
              out.print(source[122]); // 832:2 = "           "
              out.print(prefix);
              out.print(name);
              out.print(source[123]); // 833:29 = " + Backend.SQL_EQUAL_PAR +"
            }
            else {
              String tailStr = getEntity().isEmbedded() && ncnt == names.size() ? ";" : " +";
              out.print(source[124]); // 838:2 = "           "
              out.print(prefix);
              out.print(name);
              out.print(source[125]); // 839:29 = " + Backend.SQL_EQUAL_PAR_COMMA"
              out.print(tailStr);
              out.print(source[126]); // 839:70 = ""
            }
          }

          if (!getEntity().isEmbedded()) {
            if (ncnt == 0 && !checkSerial) {
              // special case: no attributes and no checkserial
              out.print(source[127]); // 847:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
            }

            if (checkSerial) {
              out.print(source[128]); // 853:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
            }
            else  {
              out.print(source[129]); // 860:2 = "           Backend.SQL_WHERE + CN_ID + B..."
            }
          }
          out.print(source[130]); // 865:2 = "  }"
        }
      }

      if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE && getEntity().getSuperEntity() != null) {
        // for all single table inherited subclasses (not the top one)
        out.print(source[131]); // 873:2 = "  @Override  public StringBuilder crea..."
        // part 1: all entities starting from topmost to me
        Entity topEntity = getEntity().getTopSuperEntity();
        List<Entity> superEntities = topEntity.getInheritanceChain(getEntity());
        for (Entity superEntity : superEntities) {
          out.print(source[132]); // 885:2 = "         names.addAll("
          out.print(deriveClassNameForEntity(superEntity));
          out.print(source[133]); // 886:63 = ".mappedColumns(backend));"
        }
        // part 2: all sub entities of me
        List<Entity> subEntities = getEntity().getAllSubEntities();
        for (Entity subEntity : subEntities) {
          out.print(source[134]); // 892:2 = "         names.addAll("
          out.print(deriveClassNameForEntity(subEntity));
          out.print(source[135]); // 893:61 = ".mappedColumns(backend));"
        }
        out.print(source[136]); // 896:2 = "         return names;       }))      ..."
      }

      else if (multiInheritance) {
        // create joinable sql selects with table aliases
        Entity topEntity = getEntity().getTopSuperEntity();
        List<Entity> chain = topEntity.getInheritanceChain(getEntity());
        List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
        String topImplClass = deriveClassNameForEntity(topEntity);

        if (!readOnly) {
          out.print(source[137]); // 915:2 = "  /**   * Creates the SQL code for the..."
          out.print(pdoClass);
          out.print(source[138]); // 918:46 = " delete statement.   *   * @return the..."
          out.print(pdoClass);
          out.print(source[139]); // 922:43 = "() {"
          if (getEntity().isRootOfInheritanceHierarchy()) {
            out.print(source[140]); // 925:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          else  {
            out.print(source[141]); // 932:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          out.print(source[142]); // 937:2 = "  }"
        }
        out.print(source[143]); // 941:2 = "  @Override  public StringBuilder crea..."
        boolean needComma = false;
        for (Entity entity: chain) {
          String implClass = deriveClassNameForEntity(entity);
          if (isMuteOptionSet(entity)) {
            out.print(source[144]); // 951:2 = "    sql."
            out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
            out.print(source[145]); // 952:57 = "append("
            out.print(implClass);
            out.print(source[146]); // 952:77 = ".CLASSVARIABLES.getColumnNames("
            out.print(implClass);
            out.print(source[147]); // 952:121 = ".mappedColumns(backend)));"
          }
          else {
            out.print(source[148]); // 956:2 = "    sql."
            out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
            out.print(source[149]); // 957:57 = "append("
            out.print(implClass);
            out.print(source[150]); // 957:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
          }
          needComma = true;
          if (entity == topEntity) {
            for (Entity sub: subs) {
              implClass = deriveClassNameForEntity(sub);
              if (isMuteOptionSet(sub)) {
                out.print(source[151]); // 965:2 = "    sql.append(Backend.SQL_COMMA).append..."
                out.print(implClass);
                out.print(source[152]); // 966:54 = ".CLASSVARIABLES.getColumnNames("
                out.print(implClass);
                out.print(source[153]); // 966:98 = ".mappedColumns(backend)));"
              }
              else {
                out.print(source[154]); // 970:2 = "    sql.append(Backend.SQL_COMMA).append..."
                out.print(implClass);
                out.print(source[155]); // 971:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
              }
            }
          }
        }
        out.print(source[156]); // 977:2 = "    sql.append(Backend.SQL_FROM);    sq..."
        out.print(topImplClass);
        out.print(source[157]); // 979:31 = ".CLASSVARIABLES.getTableName()).       ..."
        out.print(topImplClass);
        out.print(source[158]); // 980:71 = ".CLASSVARIABLES.getTableAlias());"
        if (chain.size() > 1) {
          for (Entity entity: chain.subList(1, chain.size())) {
            String implClass = deriveClassNameForEntity(entity);
            out.print(source[159]); // 985:2 = "    sql.append(backend.sqlJoin(JoinType...."
            out.print(implClass);
            out.print(source[160]); // 987:28 = ".CLASSVARIABLES.getTableName(), "
            out.print(implClass);
            out.print(source[161]); // 987:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
            out.print(topImplClass);
            out.print(source[162]); // 988:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
            out.print(implClass);
            out.print(source[163]); // 989:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
          }
        }

        for (Entity sub: subs) {
          String implClass = deriveClassNameForEntity(sub);
          out.print(source[164]); // 996:2 = "    sql.append(backend.sqlJoin(JoinType...."
          out.print(implClass);
          out.print(source[165]); // 998:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[166]); // 998:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[167]); // 999:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[168]); // 1000:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
        out.print(source[169]); // 1003:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
        String implClass = deriveClassNameForEntity(topEntity);
        out.print(source[170]); // 1009:2 = "  @Override  public StringBuilder crea..."
        out.print(implClass);
        out.print(source[171]); // 1015:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

        if (getEntity().isRootOfInheritanceHierarchy()) {
          out.print(source[172]); // 1022:2 = "  @Override  protected void updateImpl..."
          out.print(pdoClass);
          out.print(source[173]); // 1026:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[174]); // 1027:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[175]); // 1033:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[176]); // 1034:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[177]); // 1040:157 = "());    st.setLong(1, getId());    st...."
        }
        else  {
          out.print(source[178]); // 1048:2 = "  @Override  protected void updateImpl..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[179]); // 1051:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[180]); // 1054:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[181]); // 1055:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[182]); // 1060:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[183]); // 1063:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[184]); // 1064:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[185]); // 1069:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[186]); // 1071:157 = "());    st.setLong(1, getId());    ass..."
        }
      } // end multiinheritance

      else if (isMuteOptionSet(getEntity()) && !getEntity().isEmbedded()) {
        out.print(source[187]); // 1081:2 = "  @Override  public StringBuilder crea..."
      }

    } // end !mock

    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isMute()) {
        continue;   // skip
      }
      if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr)) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[188]); // 1106:2 = "  /*   * no accessor methods for "
          out.print(attr);
          out.print(source[189]); // 1109:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[190]); // 1110:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[191]); // 1122:2 = "  // "
          out.print(attr);
          out.print(source[192]); // 1124:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.isHidden()) {
            out.print(source[193]); // 1129:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[194]); // 1132:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[195]); // 1134:48 = "   */  @Persistent(ordinal="
            out.print(attr.getOrdinal());
            out.print(source[196]); // 1136:44 = ", comment="
            out.print(StringHelper.toDoubleQuotes(attr.getOptions().getComment()));
            out.print(source[197]); // 1136:117 = ")"
          }
          else {
            out.print(source[198]); // 1140:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[199]); // 1148:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[200]); // 1149:26 = ""
            }
          }
          out.print(source[201]); // 1153:2 = "  "
          out.print(protection);
          out.print(source[202]); // 1154:16 = " "
          out.print(type);
          out.print(source[203]); // 1154:25 = " "
          out.print(getter);
          out.print(source[204]); // 1154:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[205]); // 1155:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[206]); // 1161:2 = "  // "
          out.print(attr);
          out.print(source[207]); // 1163:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[208]); // 1176:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[209]); // 1179:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[210]); // 1181:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[211]); // 1181:66 = "   */"
          }
          else {
            out.print(source[212]); // 1186:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
              out.print(source[213]); // 1194:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[214]); // 1195:26 = ""
            }
          }
          out.print(source[215]); // 1199:2 = "  "
          out.print(setterProtection);
          out.print(source[216]); // 1200:22 = " void "
          out.print(setter);
          out.print(source[217]); // 1200:38 = "("
          out.print(type);
          out.print(source[218]); // 1200:47 = " "
          out.print(attr.getName());
          out.print(source[219]); // 1200:66 = ") {"
          if (type.equals("Timestamp")) {
            out.print(source[220]); // 1203:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[221]); // 1204:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[222]); // 1204:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[223]); // 1208:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[224]); // 1209:39 = ");"
          }
          if (generateMock) {
            out.print(source[225]); // 1213:2 = "    this."
            out.print(attr.getName());
            out.print(source[226]); // 1214:27 = " = "
            out.print(attr.getName());
            out.print(source[227]); // 1214:48 = ";"
          }
          else {
            if (isTracked())  {
              if (isFullTracked()) {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[228]); // 1221:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[229]); // 1222:31 = " != "
                  out.print(attr.getName());
                  out.print(source[230]); // 1222:53 = ") {      assertMutable();      firePro..."
                  out.print(attr.getName().toUpperCase(Locale.ROOT));
                  out.print(source[231]); // 1224:71 = ", this."
                  out.print(attr.getName());
                  out.print(source[232]); // 1224:96 = ", "
                  out.print(attr.getName());
                  out.print(source[233]); // 1224:116 = ");      this."
                  out.print(attr.getName());
                  out.print(source[234]); // 1225:29 = " = "
                  out.print(attr.getName());
                  out.print(source[235]); // 1225:50 = ";    }"
                }
                else {
                  out.print(source[236]); // 1230:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[237]); // 1231:47 = ", "
                  out.print(attr.getName());
                  out.print(source[238]); // 1231:67 = ")) {      assertMutable();      firePr..."
                  out.print(attr.getName().toUpperCase(Locale.ROOT));
                  out.print(source[239]); // 1233:71 = ", this."
                  out.print(attr.getName());
                  out.print(source[240]); // 1233:96 = ", "
                  out.print(attr.getName());
                  out.print(source[241]); // 1233:116 = ");      this."
                  out.print(attr.getName());
                  out.print(source[242]); // 1234:29 = " = "
                  out.print(attr.getName());
                  out.print(source[243]); // 1234:50 = ";    }"
                }
              }
              else {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[244]); // 1241:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[245]); // 1242:31 = " != "
                  out.print(attr.getName());
                  out.print(source[246]); // 1242:53 = ") {      setModified(true);      this...."
                  out.print(attr.getName());
                  out.print(source[247]); // 1244:29 = " = "
                  out.print(attr.getName());
                  out.print(source[248]); // 1244:50 = ";"
                  if (isAttracked()) {
                    out.print(source[249]); // 1247:2 = "      "
                    out.print(attr.getName());
                    out.print(source[250]); // 1248:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase(Locale.ROOT));
                    out.print(source[251]); // 1249:71 = ", this."
                    out.print(attr.getName());
                    out.print(source[252]); // 1249:96 = ", "
                    out.print(attr.getName());
                    out.print(source[253]); // 1249:116 = ");"
                  }
                  out.print(source[254]); // 1252:2 = "    }"
                }
                else  {
                  out.print(source[255]); // 1257:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[256]); // 1258:47 = ", "
                  out.print(attr.getName());
                  out.print(source[257]); // 1258:67 = ")) {      setModified(true);      this..."
                  out.print(attr.getName());
                  out.print(source[258]); // 1260:29 = " = "
                  out.print(attr.getName());
                  out.print(source[259]); // 1260:50 = ";"
                  if (isAttracked()) {
                    out.print(source[260]); // 1263:2 = "      "
                    out.print(attr.getName());
                    out.print(source[261]); // 1264:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase(Locale.ROOT));
                    out.print(source[262]); // 1265:71 = ", this."
                    out.print(attr.getName());
                    out.print(source[263]); // 1265:96 = ", "
                    out.print(attr.getName());
                    out.print(source[264]); // 1265:116 = ");"
                  }
                  out.print(source[265]); // 1268:2 = "    }"
                }
              }
            }
            else {
              out.print(source[266]); // 1275:2 = "    assertMutable();    this."
              out.print(attr.getName());
              out.print(source[267]); // 1277:27 = " = "
              out.print(attr.getName());
              out.print(source[268]); // 1277:48 = ";"
            }
          }
          out.print(source[269]); // 1281:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[270]); // 1286:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[271]); // 1289:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[272]); // 1291:30 = " has been modified   */"
            }
            else {
              out.print(source[273]); // 1296:2 = "  @Override"
            }
            out.print(source[274]); // 1301:2 = "  "
            out.print(protection);
            out.print(source[275]); // 1302:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[276]); // 1302:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[277]); // 1306:2 = "    return "
                out.print(attr.getName());
                out.print(source[278]); // 1307:29 = " != "
                out.print(attr.getName());
                out.print(source[279]); // 1307:51 = "Persisted;"
              }
              else {
                out.print(source[280]); // 1311:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[281]); // 1312:45 = ", "
                out.print(attr.getName());
                out.print(source[282]); // 1312:65 = "Persisted);"
              }
            }
            else {
              out.print(source[283]); // 1317:2 = "    return "
              out.print(attr.getName());
              out.print(source[284]); // 1318:29 = "Modified;"
            }
            out.print(source[285]); // 1321:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[286]); // 1328:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[287]); // 1331:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[288]); // 1338:2 = "  @Override"
            }
            out.print(source[289]); // 1343:2 = "  "
            out.print(protection);
            out.print(source[290]); // 1344:16 = " "
            out.print(attr.getJavaType());
            out.print(source[291]); // 1344:39 = " "
            out.print(getter);
            out.print(source[292]); // 1344:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[293]); // 1345:29 = "Persisted;  }"
          }
        }
      }
    }

    if (!generateMock) {
      if (isPdo() && generateSnapshot) {

        // createAttributesInSnapshot isnt necessary anymore since 2.2.x, because all attributes are either immutable or frozen
        // therefore, modifying an attribute requires changing the object reference

        boolean needRevertAttributes = false;
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isMute() && !isAttributeDerived(attr) && !attr.getOptions().isShallow()) {
            needRevertAttributes = true;
            break;
          }
        }

        if (needRevertAttributes) {
          out.print(source[294]); // 1368:2 = "  /**   * Copies all attributes from a..."
          out.print(mainClass);
          out.print(getEntity().isAbstract() ? "<T,?>" : "");
          out.print(source[295]); // 1375:100 = " snapshot) {    super.revertAttributesT..."
          for (Attribute attr: getEntity().getAttributes()) {
            if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr) && !attr.getOptions().isShallow() && !attr.getOptions().isMute())    {
              String name = attr.getName();
              out.print(source[296]); // 1381:2 = "    "
              out.print(name);
              out.print(source[297]); // 1382:12 = " = snapshot."
              out.print(name);
              out.print(source[298]); // 1382:32 = ";"
              if (isAttracked()) {
                if (isFullTracked()) {
                  out.print(source[299]); // 1386:2 = "    "
                  out.print(name);
                  out.print(source[300]); // 1387:12 = "Persisted = snapshot."
                  out.print(name);
                  out.print(source[301]); // 1387:41 = "Persisted;"
                }
                else {
                  out.print(source[302]); // 1391:2 = "    "
                  out.print(name);
                  out.print(source[303]); // 1392:12 = "Modified = snapshot."
                  out.print(name);
                  out.print(source[304]); // 1392:40 = "Modified;"
                }
              }
            }
          }
          out.print(source[305]); // 1398:2 = "  }"
        }
      }

      if (generateCreateNormText) {
        out.print(source[306]); // 1405:2 = "  @Override  public StringBuilder crea..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (attr.getOptions().isPartOfNormText())  {
            out.print(source[307]); // 1416:2 = "    buf.append("
            out.print(attr.getGetterName());
            out.print(source[308]); // 1417:39 = "()).append(',');"
          }
        }

        for (Relation rel: getEntity().getRelations()) {
          if (rel.isEmbedding()) {
            boolean hasNormText = false;
            for (Attribute attr: rel.getForeignEntity().getAttributes())  {
              if (attr.getOptions().isPartOfNormText())  {
                hasNormText = true;
                break;
              }
            }
            if (!hasNormText) {
              for (Attribute attr: rel.getForeignEntity().getEmbeddedAttributes())  {
                if (attr.getOptions().isPartOfNormText())  {
                  hasNormText = true;
                  break;
                }
              }
            }
            if (hasNormText) {
              out.print(source[309]); // 1440:2 = "    buf.append(Objects.requireNonNullEls..."
              out.print(rel.getGetterName());
              out.print(source[310]); // 1441:98 = "().getPersistenceDelegate()).createAttri..."
            }
          }
        }
        out.print(source[311]); // 1446:2 = "    return buf;  }"
      }

      if (generatePresetVirgin) {
        out.print(source[312]); // 1453:2 = "  @Override  protected void presetVirg..."
        for (Attribute attr: getEntity().getAttributes())  {
          String newValue = attr.getOptions().getNewValue();
          if (newValue != null)  {
            out.print(source[313]); // 1461:2 = "    "
            out.print(attr.getName());
            out.print(source[314]); // 1462:22 = " = "
            out.print(newValue);
            out.print(source[315]); // 1462:37 = ";"
          }
        }
        out.print(source[316]); // 1466:2 = "  }"
      }

      if (generateSelectByUDK) {
        List<Attribute> udk = getEntity().getUniqueDomainKey();
        if (!udk.isEmpty()) {
          List<Attribute> superUdk = null;
          if (getEntity().getSuperEntity() != null) {
            superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
          }
          if (superUdk == null || !udk.equals(superUdk)) {
            Set<Entity> components = getEntity().getAllComponents();
            StringBuilder attribs = new StringBuilder();
            for (Attribute attribute: udk) {
              if (attribs.length() != 0) {
                attribs.append(" ");
              }
              if (components.contains(attribute.getEntity())) {
                attribs.append(attribute.getEntity()).append(".");
              }
              attribs.append(attribute.getName());
            }
            out.print(source[317]); // 1490:2 = "  // selects by unique domain key  // ..."
            out.print(attribs);
            out.print(source[318]); // 1493:66 = ""
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
