// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to update low-level persistent objects.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DbUpdateBy [--private] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     &lt;expression&gt; | &lt;values&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * <li><em>&lt;values&gt;:</em> the attributes to be updated.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class DbUpdateBy extends DbModelWurblet {

  public DbUpdateBy() {
    setConfiguration("groupArgs");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    String className = getClassName();
    String methodName = getMethodName();

    String  classVar    = null;
    String  append      = null;
    String  scope       = "public";

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
        setRemote(false);
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    String params = buildMethodParameters();
    String iparms = buildInvocationParameters();
    String statementId = createStatementId();

    out.print(source[0]); // 54:2 = "  "
    out.print(scope);
    out.print(source[1]); // 55:11 = " int "
    out.print(methodName);
    out.print(source[2]); // 55:30 = "("
    out.print(params);
    out.print(source[3]); // 55:41 = ") {"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplementationStream();
      PrintStream remoteOut = genInc.getInterfaceStream();
      out.print(source[4]); // 62:2 = "    if (getSession().isRemote())  {    ..."
      remoteOut.print(source[5]); // 65:16 = "  int "
      remoteOut.print(methodName);
      remoteOut.print(source[6]); // 66:20 = "("
      remoteOut.print(params);
      remoteOut.print(source[7]); // 66:31 = ") throws RemoteException;"
      implOut.print(source[8]); // 67:14 = "  @Override  public int "
      implOut.print(methodName);
      implOut.print(source[9]); // 70:27 = "("
      implOut.print(params);
      implOut.print(source[10]); // 70:38 = ") throws RemoteException {"
      implOut.print(source[11]); // 71:14 = "    try {      return dbObject."
      implOut.print(methodName);
      implOut.print(source[12]); // 73:36 = "("
      implOut.print(iparms);
      implOut.print(source[13]); // 73:47 = ");    }    catch (RuntimeException e) ..."
      out.print(source[14]); // 79:6 = "        return getRemoteDelegate()."
      out.print(methodName);
      out.print(source[15]); // 80:49 = "("
      out.print(iparms);
      out.print(source[16]); // 80:60 = ");      }      catch (RemoteException ..."
    } // end if remote
     out.print(source[17]); // 89:2 = "    PreparedStatementWrapper st = getPre..."
     out.print(classVar);
     out.print(statementId);
     out.print(source[18]); // 90:82 = ",      b -> {        StringBuilder sql..."
    boolean isFirstSetKey = true;
    for (WurbletArgument key: getExtraArguments())  {
      Attribute attr = key.getAttribute();
      DataType<?> dataType = getEffectiveDataType(attr);
      if (isFirstSetKey) {
        isFirstSetKey = false;
      }
      else  {
        out.print(source[19]); // genupdate.incl:10:2 = "        sql.append(Backend.SQL_COMMA);"
      }
      if (dataType.isColumnCountBackendSpecific()) {
        out.print(source[20]); // genupdate.incl:15:2 = "        sql.append("
        out.print(dataType.getDataTypeConstant());
        out.print(source[21]); // genupdate.incl:16:53 = ".createColumnNamesAsString(b, "
        out.print(getColumnNameConstant(attr, -1));
        out.print(source[22]); // genupdate.incl:16:118 = ", Backend.SQL_EQUAL_PAR)).append(Backend..."
      }
      else {
        for (int columnIndex = 0; columnIndex < dataType.getColumnCount(null); columnIndex++) {
          out.print(source[23]); // genupdate.incl:21:2 = "        sql.append("
          out.print(getColumnNameConstant(attr, columnIndex));
          out.print(source[24]); // genupdate.incl:22:63 = ").append(Backend.SQL_EQUAL_PAR);"
        }
      }
    }
    out.print(source[25]); // 93:38 = "        sql.append(Backend.SQL_WHEREALL)..."
    if (getEntity().getSuperEntity() != null && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[26]); // genwhere.incl:3:2 = "        sql.append(getSqlClassIdConditio..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[27]); // genwhere.incl:10:2 = "        sql.append(Backend.SQL_AND)    ..."
        out.print(getColumnNameConstant(getContextAttribute(), 0));
        out.print(source[28]); // genwhere.incl:12:70 = ")           .append(Backend.SQL_EQUAL_P..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[29]); // genwhere.incl:22:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[30]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[31]); // genwhere.incl:31:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  boolean isEmbeddingRelation = false;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    if (rel.isEmbedded()) {
                      isEmbeddingRelation = true;
                      leftAttribute = '"' + arg.getEmbeddingColumnPrefix() + rel.getMethodArgs().get(0).getAttribute().getColumnName() + '"';
                    }
                    else {
                      leftAttribute = getColumnNameConstant(rel.getAttribute(), 0);
                    }
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = getColumnNameConstant(rel.getForeignAttribute(), 0);
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() || isEmbeddingRelation ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append(getColumnNameConstant(mattr, 0)).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (int columnIndex = 1; columnIndex < getEffectiveDataType(attr).getColumnCount(null); columnIndex++) {
                        buf.append("           .append(Backend.SQL_AND)\n")
                           .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                           .append(rightClass).append(getColumnNameConstant(attr, columnIndex)).append("))\n")
                           .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append(getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEmbeddingPath() == null ? attr.getEntity() : attr.getEmbeddingPath().get(0));
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(");
                  if (attr.getEmbeddingPath() != null) {
                    try {
                      buf.append('"').append(attr.getColumnName(null, columnIndex)).append("\"))\n");
                    }
                    catch(ModelException mx) {
                      throw new WurbelException("cannot determine embedded column name", mx);
                    }
                  }
                  else {
                    buf.append(compKeyClass).append('.').append(getColumnNameConstant(attr, columnIndex)).append("))\n");
                  }
                  buf.append("           ").append(createRelopCode(arg)).append(";\n");
                }
              }
            }
            else {
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  if (isPathAllowed()) {
                    if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                       buf.append("        sql.append(");
                       buf.append(deriveClassNameForEntity(attr.getEntity()));
                       buf.append(".CLASSVARIABLES.getColumnName(");
                       buf.append(getColumnNameConstant(attr, columnIndex)).append("));\n");
                    }
                    else  {
                      if (isPdo()) {
                        buf.append("        sql.append(getColumnName(");
                        if (attr.isEmbedded()) {
                          buf.append('"').append(attr.getColumnName()).append('"');
                        }
                        else {
                          buf.append(getColumnNameConstant(attr, columnIndex));
                        }
                        buf.append("));\n");
                      }
                      else  {
                        buf.append("        sql.append(").append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                      }
                    }
                  }
                  else  {
                    buf.append("        sql.append(");
                    if (attr.isEmbedded()) {
                      buf.append("getColumnPrefix() + ");
                    }
                    buf.append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                  }
                  buf.append("        sql").append(createRelopCode(arg)).append(";\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[32]); // genwhere.incl:245:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[33]); // genwhere.incl:248:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[34]); // genwhere.incl:253:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[35]); // genwhere.incl:263:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[36]); // genwhere.incl:265:25 = ";"
    }
    if (append != null) {
      out.print(source[37]); // 98:2 = "        sql.append("
      out.print(append);
      out.print(source[38]); // 99:29 = ");"
    }
    out.print(source[39]); // 102:2 = "        return sql.toString();      } ..."
    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }

    if (getContextAttribute() != null) {
      out.print(source[40]); // gensetpar.incl:7:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute().getDataType()));
      out.print(source[41]); // gensetpar.incl:8:68 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[42]); // gensetpar.incl:8:111 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                out.print(source[43]); // gensetpar.incl:21:2 = "    "
                out.print(createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                out.print(source[44]); // gensetpar.incl:22:77 = ";"
              }
            }
          }
        }
      }

      if (!par.isValueLiterally()) {
        out.print(source[45]); // gensetpar.incl:31:2 = "    "
        out.print(createWhereSetPars(par));
        out.print(source[46]); // gensetpar.incl:32:31 = ";"
      }
    }
    out.print(source[47]); // 107:38 = "    return st.executeUpdate();  }"
    if (classVar.isEmpty()) {
      out.print(source[48]); // 112:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[49]); // 114:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------

  @Override
  public String process(String code) {
    int ref = code.lastIndexOf("ndx");
    int pos = code.lastIndexOf("(ndx++,");
    if (pos >= 0 && ref == pos + 1) {
      // remove unnecessary last ++
      code = code.substring(0, pos + 4) + code.substring(pos + 6);
    }
    else {
      // remove unnecessary last ndx +=
      pos = code.lastIndexOf("ndx += st.set(");   // ndx += st.set(DT_POSITION3D, ndx, dropPosition, false, null);
      if (pos >= 0 && ref > pos) {
        code = code.substring(0, pos) + code.substring(pos + 7);
      }
      else {
        pos = code.lastIndexOf(", ndx++, ");   // st.set(SqlType....., ndx++, value.get...)
        if (pos >= 0 && ref > pos) {
          code = code.substring(0, pos + 5) + code.substring(pos + 7);
        }
      }
    }
    return code;
  }
}
