// wurblet generated by Wurbelizer 21.6.1.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generates the code to setup the class-variables for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ClassVariables
 * <p>
 * For more options, see {@link DbModelWurblet}.
 */
public class ClassVariables extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {
    String pdoName    = getPdoClassName();
    String className  = getClassName();
    boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;
    Entity superEntity = getEntity().getSuperEntity();
    List<Entity> subEntities = getEntity().getSubEntities();
    out.print(source[0]); // 17:2 = "  /** Variables common to all instances ..."
    out.print(className);
    out.print(source[1]); // 18:56 = ". */"
    if (getEntity().isAbstract() && getEntity().getInheritanceType().isMappingToNoTable()) {  // PLAIN
    out.print(source[2]); // 21:2 = "  /** no classvariables for "
    out.print(getEntity().getInheritanceType());
    out.print(source[3]); // 22:64 = " inheritance. */"
    }
    else  {
      String cvType = "PersistentObjectClassVariables";
      if (!getEntity().isAbstract()) {
        cvType += "<" + pdoName + ", " + className + ">";
      }
      String alias = getEntity().getTableAlias();
      String strAlias = alias != null ? "\"" + alias + "\"" : "null";
      String superCV = "null";

      List<Relation> joins = getEagerRelations();

      if (superEntity != null && !superEntity.getInheritanceType().isMappingToNoTable() ||
          !subEntities.isEmpty()) {
        if (superEntity != null) {
          superCV = deriveClassNameForEntity(superEntity) + ".CLASSVARIABLES";
          out.print(source[4]); // 40:2 = "  @SuppressWarnings({"unchecked", "rawty..."
        }
        else {
          out.print(source[5]); // 45:2 = "  @SuppressWarnings({"unchecked", "rawty..."
        }
      }
      else if (joins != null) {
        out.print(source[6]); // 51:2 = "  @SuppressWarnings({"unchecked", "rawty..."
      }
      out.print(source[7]); // 55:2 = "  public static final "
      out.print(cvType);
      out.print(source[8]); // 56:32 = " CLASSVARIABLES =            Persistent..."
      out.print(pdoName);
      out.print(source[9]); // 58:31 = ".class,                    "
      out.print(className);
      out.print(source[10]); // 59:33 = ".class,                    "
      out.print(strAlias);
      out.print(source[11]); // 60:32 = ",                    "
      out.print(superCV);
      out.print(source[12]); // 61:31 = ","
      if (joins != null) {
        String poImpl = deriveClassNameForEntity(getEntity());
        out.print(source[13]); // 65:2 = "                    List.of("
        int joinCount = 0;
        for (Relation join: joins) {
          if (join.getMethodArgs().size() > 1) {
            throw new ModelException("eager relations with 'args=...' are currently not supported", join);
          }
          joinCount++;
          String joinClass = join.getForeignEntity().getName();
          String joinAlias = join.getForeignEntity().getTopSuperEntity().getTableAlias();
          if (join.getForeignEntity().isAbstract()) {
            if (join.getRelationType() == RelationType.LIST) {
              out.print(source[14]); // 78:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[15]); // 79:58 = ".id", "e_"
              out.print(joinCount);
              out.print(source[16]); // 79:80 = "."
              out.print(join.getForeignAttribute().getColumnName());
              out.print(source[17]); // 79:127 = "", "
              out.print(joinClass);
              out.print(source[18]); // 79:143 = ".class, "e_"
              out.print(joinCount);
              out.print(source[19]); // 79:167 = "",                        ("
              out.print(pdoName);
              out.print(source[20]); // 80:36 = " "
              out.print(alias);
              out.print(source[21]); // 80:46 = ", "
              out.print(joinClass);
              out.print(source[22]); // 80:61 = " "
              out.print(joinAlias);
              out.print(source[23]); // 80:75 = ") -> {                          "
              out.print(poImpl);
              out.print(source[24]); // 81:36 = " po = ("
              out.print(poImpl);
              out.print(source[25]); // 81:53 = ") "
              out.print(alias);
              out.print(source[26]); // 81:64 = ".getPersistenceDelegate();             ..."
              out.print(join.getGetterName());
              out.print(source[27]); // 82:53 = "Blunt().add("
              out.print(joinAlias);
              out.print(source[28]); // 82:78 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[29]); // 84:63 = ""
            }
            else {
              out.print(source[30]); // 88:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[31]); // 89:58 = "."
              out.print(join.getAttribute().getColumnName());
              out.print(source[32]); // 89:98 = "", "e_"
              out.print(joinCount);
              out.print(source[33]); // 89:117 = ".id", "
              out.print(joinClass);
              out.print(source[34]); // 89:136 = ".class, "e_"
              out.print(joinCount);
              out.print(source[35]); // 89:160 = "",                        ("
              out.print(pdoName);
              out.print(source[36]); // 90:36 = " "
              out.print(alias);
              out.print(source[37]); // 90:46 = ", "
              out.print(joinClass);
              out.print(source[38]); // 90:61 = " "
              out.print(joinAlias);
              out.print(source[39]); // 90:75 = ") -> {                          "
              out.print(alias);
              out.print(source[40]); // 91:35 = "."
              out.print(join.getSetterName());
              out.print(source[41]); // 91:60 = "("
              out.print(joinAlias);
              out.print(source[42]); // 91:74 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[43]); // 93:63 = ""
            }
          }
          else  { // non-abstract
            if (join.getRelationType() == RelationType.LIST) {
              out.print(source[44]); // 99:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[45]); // 100:58 = ".id", "e_"
              out.print(joinCount);
              out.print(source[46]); // 100:80 = "."
              out.print(join.getForeignAttribute().getColumnName());
              out.print(source[47]); // 100:127 = "", "
              out.print(joinClass);
              out.print(source[48]); // 100:143 = ".class, "e_"
              out.print(joinCount);
              out.print(source[49]); // 100:167 = "",                        ("
              out.print(alias);
              out.print(source[50]); // 101:34 = ", "
              out.print(joinAlias);
              out.print(source[51]); // 101:49 = ") -> {"
              if (join.isReversed()) {
                out.print(source[52]); // 104:2 = "                          (("
                out.print(poImpl);
                out.print(source[53]); // 105:38 = ") "
                out.print(alias);
                out.print(source[54]); // 105:49 = ".getPersistenceDelegate())."
                out.print(join.getSetterName());
                out.print(join.isSerialized()?"Blunt":"");
                out.print(source[55]); // 105:134 = "("
                out.print(joinAlias);
                out.print(source[56]); // 105:148 = ");"
              }
              else {
                out.print(source[57]); // 109:2 = "                          (("
                out.print(poImpl);
                out.print(source[58]); // 110:38 = ") "
                out.print(alias);
                out.print(source[59]); // 110:49 = ".getPersistenceDelegate())."
                out.print(join.getGetterName());
                out.print(source[60]); // 110:100 = "Blunt().addBlunt("
                out.print(joinAlias);
                out.print(source[61]); // 110:130 = ");"
                if (join.getLinkMethodName() != null) {
                  String joinImpl = deriveClassNameForEntity(join.getForeignEntity());
                  out.print(source[62]); // 114:2 = "                          (("
                  out.print(joinImpl);
                  out.print(source[63]); // 115:40 = ") "
                  out.print(joinAlias);
                  out.print(source[64]); // 115:55 = ".getPersistenceDelegate())."
                  out.print(createRelationUpdateReferenceCode(join, alias, true));
                  out.print(source[65]); // 115:138 = ";"
                }
              }
              out.print(source[66]); // 119:2 = "                        }              ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[67]); // 121:63 = ""
            }
            else {
              out.print(source[68]); // 125:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[69]); // 126:58 = "."
              out.print(join.getAttribute().getColumnName());
              out.print(source[70]); // 126:98 = "", "e_"
              out.print(joinCount);
              out.print(source[71]); // 126:117 = ".id", "
              out.print(joinClass);
              out.print(source[72]); // 126:136 = ".class, "e_"
              out.print(joinCount);
              out.print(source[73]); // 126:160 = "",                        ("
              out.print(alias);
              out.print(source[74]); // 127:34 = ", "
              out.print(joinAlias);
              out.print(source[75]); // 127:49 = ") -> {                          "
              out.print(alias);
              out.print(source[76]); // 128:35 = "."
              out.print(join.getSetterName());
              out.print(join.isSerialized()?"Blunt":"");
              out.print(source[77]); // 128:94 = "("
              out.print(joinAlias);
              out.print(source[78]); // 128:108 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[79]); // 130:63 = ""
            }
          }
        }
        out.print(source[80]); // 135:2 = "                    )                );..."
      }
      else {
        out.print(source[81]); // 141:2 = "                    null);"
      }
      out.print(source[82]); // 145:2 = "  @Override"
      if (getEntity().isAbstract()) {
        out.print(source[83]); // 150:2 = "  @SuppressWarnings("unchecked")"
      }
      out.print(source[84]); // 154:2 = "  public "
      out.print(cvType);
      out.print(getEntity().isAbstract() ? "<T,P>" : "");
      out.print(source[85]); // 155:62 = " getClassVariables() {    return CLASSV..."
    }
  }

  // ----------------- end wurblet code -----------------
}
