// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generates the remote delegate invocation code.
 * <p>
 * In order for this wurblet to work, the method must be annotated with @RemoteMethod.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; RemoteMethod [--this] [--nocontext] [--instance=&lt;object&gt;]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--this:</em> add the PDO itself to the method parameters.</li>
 * <li><em>--nocontext:</em> don't pass the DomainContext.</li>
 * <li><em>--instance=&lt;object&gt;:</em> object to invoke the method on in the remote implementation.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class RemoteMethod extends DbModelWurblet {

  public RemoteMethod() {
    setConfiguration("missingModelOk");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String instanceName   = null;
    boolean addThis       = false;
    boolean noContext     = false;

    for (String arg: getOptionArgs())  {
      if (arg.startsWith("instance=")) {
        instanceName = arg.substring(9);
      }
      else if (arg.equals("this")) {
        addThis = true;
      }
      else if (arg.equals("nocontext")) {
        noContext = true;
      }
    }

    String methodName = getMethodName();

    String className = getClassName();
    if (className == null)  {
      throw new WurbelException("can't determine <classname>");
    }

    String packageName = getPackageName();
    if (packageName == null)  {
      throw new WurbelException("can't determine <packagename>");
    }

    boolean isPdo = false;
    String pdoClassName = null;
    try {
      pdoClassName = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException wx) {
      // no pdo
    }

    if (isRemote()) {

      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplStream();
      PrintStream remoteOut = genInc.getRemoteStream();

      // load the info file
      String infoName = (packageName + "." + className + "." + methodName).replace('.', '/') +
                        RemoteMethodInfo.INFO_FILE_EXTENSION;
      RemoteMethodInfo info = null;
      try {
        info = RemoteMethodInfo.readInfo(getContainer().getAnalyzeFile(infoName));
      }
      catch (IOException ex) {
        if (getContainer().getAnalyzeFile(AnalyzeProcessor.COMPILE_ERROR_LOG).exists()) {
          genInc.discard();
          throw new WurbelDiscardException("reading info '" + infoName + "' failed", ex);
        }
        else {
          throw new WurbelException("reading info '" + infoName + "' failed (@RemoteMethod annotation missing?)", ex);
        }
      }

      RemoteMethodHelper helper = new RemoteMethodHelper(info, pdoClassName, addThis);

      boolean returningObject     = helper.isReturningObject();
      boolean returningCollection = helper.isReturningCollection();
      boolean returningCursor     = helper.isReturningCursor();
      boolean returningVoid       = helper.isReturningVoid();

      // get the real method name
      methodName = helper.getMethodName();

      if (helper.isStaticMethod()) {
        throw new WurbelException("static methods cannot be --remote");
      }

      // generate strings
      String iparms  = helper.getInvocationParameterString();
      String riparms = helper.getRemoteInvocationParameterString();
      String dparms  = helper.getDeclarationParameterString();

      if (isPdo && !addThis && !noContext) {
        if (iparms.length() > 0) {
          iparms = "getDomainContext(), " + iparms;
        }
        else {
          iparms = "getDomainContext()";
        }

        if (dparms.length() > 0) {
          dparms = "DomainContext context, " + dparms;
        }
        else  {
          dparms = "DomainContext context";
        }
      }

      String returnType = helper.getReturnType();
      String genType = helper.getGenericReturnType();

      String firstName  = helper.getFirstName();
      boolean firstIsDb = helper.isFirstInstanceOfDb();
      boolean firstIsDomainContext = helper.isFirstInstanceOfDomainContext();

      String remoteDelegateName = (pdoClassName != null ? pdoClassName : className) + "RemoteDelegate";
      String imethod = "getRemoteDelegate()";

      String setDomainContext = "setDomainContext(" + firstName + ")";

      String apply = null;
      if (returningObject) {
        apply = "configureRemoteObject(getDomainContext(), obj)";
      }
      else if (returningCollection) {
        apply = "configureRemoteObjects(getDomainContext(), list)";
      }

      // always use a fresh pdo because we don't know what the app is really doing with it
      String dbObject = "newInstance(" + (firstIsDomainContext ? firstName : "context") + ")";
      if (!isPdo || noContext) {
        dbObject = "dbObject";
      }
      if (addThis) {
        dbObject = "obj";
      }
      else if (instanceName != null) {
        dbObject = instanceName;
      }

      out.print(source[0]); // 151:2 = "    if (getSession().isRemote())  {    ..."


      if (returningObject) {
        remoteOut.print(source[1]); // 159:16 = "  "
        remoteOut.print(className);
        remoteOut.print(source[2]); // 160:15 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[3]); // 160:30 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[4]); // 160:41 = ") throws RemoteException;"
        implOut.print(source[5]); // 161:14 = "  @Override  public "
        implOut.print(className);
        implOut.print(source[6]); // 164:22 = " "
        implOut.print(methodName);
        implOut.print(source[7]); // 164:37 = "("
        implOut.print(dparms);
        implOut.print(source[8]); // 164:48 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[9]); // 168:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[10]); // 169:26 = ";"
        }
        if (addThis) {
          implOut.print(source[11]); // 173:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[12]); // 178:2 = "      "
          implOut.print(statement);
          implOut.print(source[13]); // 179:19 = ";"
        }
        implOut.print(source[14]); // 182:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[15]); // 183:25 = "."
        implOut.print(methodName);
        implOut.print(source[16]); // 183:40 = "("
        implOut.print(riparms);
        implOut.print(source[17]); // 183:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[18]); // 189:6 = "        "
        out.print(className);
        out.print(source[19]); // 190:21 = " obj = "
        out.print(imethod);
        out.print(source[20]); // 190:39 = "."
        out.print(methodName);
        out.print(source[21]); // 190:54 = "("
        out.print(iparms);
        out.print(source[22]); // 190:65 = ");        "
        out.print(apply);
        out.print(source[23]); // 191:17 = ";        return obj;"
      }


      if (returningCollection) {
        remoteOut.print(source[24]); // 199:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[25]); // 200:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[26]); // 200:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[27]); // 200:42 = ") throws RemoteException;"
        implOut.print(source[28]); // 201:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[29]); // 204:23 = " "
        implOut.print(methodName);
        implOut.print(source[30]); // 204:38 = "("
        implOut.print(dparms);
        implOut.print(source[31]); // 204:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[32]); // 208:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[33]); // 209:26 = ";"
        }
        if (addThis) {
          implOut.print(source[34]); // 213:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[35]); // 218:2 = "      "
          implOut.print(statement);
          implOut.print(source[36]); // 219:19 = ";"
        }
        implOut.print(source[37]); // 222:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[38]); // 223:25 = "."
        implOut.print(methodName);
        implOut.print(source[39]); // 223:40 = "("
        implOut.print(riparms);
        implOut.print(source[40]); // 223:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[41]); // 229:6 = "        "
        out.print(returnType);
        out.print(source[42]); // 230:22 = " list = "
        out.print(imethod);
        out.print(source[43]); // 230:41 = "."
        out.print(methodName);
        out.print(source[44]); // 230:56 = "("
        out.print(iparms);
        out.print(source[45]); // 230:67 = ");        "
        out.print(apply);
        out.print(source[46]); // 231:17 = ";        return list;"
      }


      else if (returningCursor) {
        remoteOut.print(source[47]); // 239:16 = "  RemoteResultSetCursor"
        remoteOut.print(genType);
        remoteOut.print(source[48]); // 240:34 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[49]); // 240:49 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[50]); // 240:60 = ") throws RemoteException;"
        implOut.print(source[51]); // 241:14 = "  @Override  public RemoteResultSetCur..."
        implOut.print(genType);
        implOut.print(source[52]); // 244:41 = " "
        implOut.print(methodName);
        implOut.print(source[53]); // 244:56 = "("
        implOut.print(dparms);
        implOut.print(source[54]); // 244:67 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[55]); // 248:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[56]); // 249:26 = ";"
        }
        if (addThis) {
          implOut.print(source[57]); // 253:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[58]); // 258:2 = "      "
          implOut.print(statement);
          implOut.print(source[59]); // 259:19 = ";"
        }
        implOut.print(source[60]); // 262:2 = "      return createRemoteResultSetCursor..."
        implOut.print(dbObject);
        implOut.print(source[61]); // 263:61 = "."
        implOut.print(methodName);
        implOut.print(source[62]); // 263:76 = "("
        implOut.print(riparms);
        implOut.print(source[63]); // 263:88 = "));    }    catch (Exception e) {    ..."
        if (isPdo) {
          out.print(source[64]); // 272:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[65]); // 274:32 = "."
          out.print(methodName);
          out.print(source[66]); // 274:47 = "("
          out.print(iparms);
          out.print(source[67]); // 274:58 = "));"
        }
        else  {
          out.print(source[68]); // 278:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[69]); // 280:32 = "."
          out.print(methodName);
          out.print(source[70]); // 280:47 = "("
          out.print(iparms);
          out.print(source[71]); // 280:58 = "));"
        }
      }

      else if (returningVoid) {
        remoteOut.print(source[72]); // 287:16 = "  void "
        remoteOut.print(methodName);
        remoteOut.print(source[73]); // 288:21 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[74]); // 288:32 = ") throws RemoteException;"
        implOut.print(source[75]); // 289:14 = "  @Override  public void "
        implOut.print(methodName);
        implOut.print(source[76]); // 292:28 = "("
        implOut.print(dparms);
        implOut.print(source[77]); // 292:39 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[78]); // 296:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[79]); // 297:26 = ";"
        }
        if (addThis) {
          implOut.print(source[80]); // 301:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[81]); // 306:2 = "      "
          implOut.print(statement);
          implOut.print(source[82]); // 307:19 = ";"
        }
        implOut.print(source[83]); // 310:2 = "      "
        implOut.print(dbObject);
        implOut.print(source[84]); // 311:18 = "."
        implOut.print(methodName);
        implOut.print(source[85]); // 311:33 = "("
        implOut.print(riparms);
        implOut.print(source[86]); // 311:45 = ");    }    catch (Exception e) {     ..."
        out.print(source[87]); // 317:6 = "        "
        out.print(imethod);
        out.print(source[88]); // 318:19 = "."
        out.print(methodName);
        out.print(source[89]); // 318:34 = "("
        out.print(iparms);
        out.print(source[90]); // 318:45 = ");        return;"
      }


      else  {
        remoteOut.print(source[91]); // 326:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[92]); // 327:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[93]); // 327:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[94]); // 327:42 = ") throws RemoteException;"
        implOut.print(source[95]); // 328:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[96]); // 331:23 = " "
        implOut.print(methodName);
        implOut.print(source[97]); // 331:38 = "("
        implOut.print(dparms);
        implOut.print(source[98]); // 331:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[99]); // 335:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[100]); // 336:26 = ";"
        }
        if (addThis) {
          implOut.print(source[101]); // 340:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[102]); // 345:2 = "      "
          implOut.print(statement);
          implOut.print(source[103]); // 346:19 = ";"
        }
        implOut.print(source[104]); // 349:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[105]); // 350:25 = "."
        implOut.print(methodName);
        implOut.print(source[106]); // 350:40 = "("
        implOut.print(riparms);
        implOut.print(source[107]); // 350:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[108]); // 356:6 = "        return "
        out.print(imethod);
        out.print(source[109]); // 357:26 = "."
        out.print(methodName);
        out.print(source[110]); // 357:41 = "("
        out.print(iparms);
        out.print(source[111]); // 357:52 = ");"
      }
      out.print(source[112]); // 360:2 = "      }      catch (RemoteException e) ..."
    }
    else  {
      out.print(source[113]); // 369:2 = "    // remote code generation disabled"
    }
  }

  // ----------------- end wurblet code -----------------
}
