// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to select a list of entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoSelectList
 *     [--private] [--noif] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     [--sort] [--lock] [--resultset] [--cursor] [--bounded] [--limit] [--offset]
 *     &lt;expression&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>--sort:</em> sort according to orderBy()-method.</li>
 * <li><em>--lock:</em> generates SELECT FOR UPDATE.</li>
 * <li><em>--limit:</em> adds a parameter to limit the number of objects.</li>
 * <li><em>--offset:</em> adds a parameter to skip the first objects.</li>
 * <li><em>--resultset:</em> returns the ResultSetWrapper instead of a List.</li>
 * <li><em>--cursor:</em> returns a ScrollableResource instead of a List.</li>
 * <li><em>--bounded:</em> returns a bounded List&lt;? extends mainClass&gt; instead of List&lt;mainClass&gt;.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoSelectList extends DbModelWurblet {

  public PdoSelectList() {
    setConfiguration("pathAllowed");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    assertEntityIsPersistable();

    String className  = getClassName();
    String methodName = getMethodName();
    String pdoName    = getPdoClassName();
    String pdoType    = pdoName;
    String poType     = className;
    if (isGenerified()) {
      pdoType = "T";
      poType = "P";
    }

    boolean sort        = false;
    boolean lock        = false;
    String  append      = null;
    boolean limit       = false;
    boolean offset      = false;
    boolean bounded     = false;
    String  cursor      = null;
    boolean resultSet   = false;
    boolean noif        = false;
    String  scope       = "public";

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
      }
      else if (arg.equals("sort")) {
        if (isWithDefaultSorting()) {
          if (isWithSorting()) {
            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
          }
          sort = true;
        }
        else {
          throw new WurbelException("no sorting configured in model for " + getEntity());
        }
      }
      else if (arg.equals("noif")) {
        noif = true;
      }
      else if (arg.equals("lock")) {
        lock = true;
      }
      else if (arg.equals("limit")) {
        limit = true;
      }
      else if (arg.equals("offset")) {
        offset = true;
      }
      else if (arg.equals("bounded")) {
        bounded = true;
      }
      else if (arg.equals("resultset")) {
        resultSet = true;
      }
      else if (arg.equals("cursor")) {
        cursor = "ScrollableResource<" + pdoName + ">";
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
    }

    if (scope.equals("private")) {
      setRemote(false);
      noif = true;
    }

    if (resultSet) {
      setRemote(false);     // disable remoting for sure
    }

    if (cursor != null) {
      if (resultSet) {
        throw new WurbelException("resultset not allowed with cursor");
      }
      if (isTracked()) {
        throw new WurbelException("tracked not available with cursors!");
      }
      if (isWithJoins()) {
        List<WurbletArgument> sortKeys = getSortingArguments();
        if (sortKeys.isEmpty() || !sortKeys.get(0).getAttribute().getColumnName().equals(Constants.CN_ID)) {
          throw new WurbelException("cursors with joins must be sorted by ID");
        }
      }
    }


    String params = buildMethodParameters(limit, offset);
    String iparms = buildInvocationParameters(limit, offset);
    String statementId = createStatementId();
    String reflMethod = getGuardName() + "Method";
    String poImpl = deriveClassNameForEntity(getEntity());

    String listType = resultSet ? "ResultSetWrapper" :
                        (cursor != null ?
                          ("ScrollableResource<" + (bounded ? "? extends " : "") + pdoType + ">") :
                          ((isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">"));
    String varListType = cursor != null ? cursor : ((isTracked() ? "TrackedList" : "List") + "<" + pdoType + ">");
    String rmiListType = cursor != null ? cursor : ((isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">");
    String alias = getEntity().getTopSuperEntity().getTableAlias();

    out.print(source[0]); // 135:2 = "  private static final StatementId "
    out.print(statementId);
    out.print(source[1]); // 137:50 = " = new StatementId();"
    if (!noif) {
      out.print(source[2]); // 141:2 = "  @Override"
    }
    out.print(source[3]); // 145:2 = "  "
    out.print(scope);
    out.print(source[4]); // 146:11 = " "
    out.print(listType);
    out.print(source[5]); // 146:24 = " "
    out.print(methodName);
    out.print(source[6]); // 146:39 = "("
    out.print(as(params));
    out.print(source[7]); // 146:54 = ") {"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplStream();
      PrintStream remoteOut = genInc.getRemoteStream();
      out.print(source[8]); // 153:2 = "    if (getSession().isRemote())  {    ..."
      if (cursor != null) {
        remoteOut.print(source[9]); // 159:16 = "  RemoteResultSetCursor "
        remoteOut.print(methodName);
        remoteOut.print(source[10]); // 160:38 = "("
        remoteOut.print(pcs(params, "DomainContext context"));
        remoteOut.print(source[11]); // 160:79 = ") throws RemoteException;"
        implOut.print(source[12]); // 161:14 = "  @Override  public RemoteResultSetCur..."
        implOut.print(methodName);
        implOut.print(source[13]); // 164:45 = "("
        implOut.print(pcs(params, "DomainContext context"));
        implOut.print(source[14]); // 164:86 = ") throws RemoteException {    try {   ..."
        implOut.print(methodName);
        implOut.print(source[15]); // 168:72 = "("
        implOut.print(iparms);
        implOut.print(source[16]); // 168:83 = "));    }    catch (RuntimeException e)..."
        out.print(source[17]); // 174:6 = "        return new ResultSetCursor<>(get..."
        out.print(methodName);
        out.print(source[18]); // 176:26 = "("
        out.print(pcs(iparms, "getDomainContext()"));
        out.print(source[19]); // 176:64 = "));"
      } // end if cursor
      else {
        remoteOut.print(source[20]); // 181:16 = "  "
        remoteOut.print(rmiListType);
        remoteOut.print(source[21]); // 182:17 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[22]); // 182:32 = "("
        remoteOut.print(pcs(params, "DomainContext context"));
        remoteOut.print(source[23]); // 182:73 = ") throws RemoteException;"
        implOut.print(source[24]); // 183:14 = "  @Override  public "
        implOut.print(rmiListType);
        implOut.print(source[25]); // 186:24 = " "
        implOut.print(methodName);
        implOut.print(source[26]); // 186:39 = "("
        implOut.print(pcs(params, "DomainContext context"));
        implOut.print(source[27]); // 186:80 = ") throws RemoteException {    try {   ..."
        implOut.print(methodName);
        implOut.print(source[28]); // 189:36 = "("
        implOut.print(iparms);
        implOut.print(source[29]); // 189:47 = ");    }    catch (RuntimeException e) ..."
        out.print(source[30]); // 195:6 = "        "
        out.print(listType);
        out.print(source[31]); // 196:20 = " list = getRemoteDelegate()."
        out.print(methodName);
        out.print(source[32]); // 196:62 = "("
        out.print(pcs(iparms, "getDomainContext()"));
        out.print(source[33]); // 196:100 = ");        configureRemoteObjects(getDom..."
      }
      out.print(source[34]); // 201:2 = "      }      catch (RemoteException e) ..."
    } // end if remote

    if (isWithJoins()) {
      out.print(createJoins());
    }
    if (lock) {
      out.print(source[35]); // 214:2 = "    getSession().assertTxRunning();"
    }
    out.print(source[36]); // 218:2 = "    PreparedStatementWrapper st = getPre..."
    out.print(statementId);
    out.print(source[37]); // 219:70 = ",      () -> {        StringBuilder sq..."
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[38]); // genwhere.incl:3:2 = "        boolean classIdRequired = isClas..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[39]); // genwhere.incl:15:2 = "        sql.append(Backend.SQL_AND);   ..."
        out.print(getContextAttribute().getName().toUpperCase());
        out.print(source[40]); // genwhere.incl:17:71 = ");        sql.append(Backend.SQL_EQUAL_..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[41]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[42]); // genwhere.incl:32:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[43]); // genwhere.incl:36:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = "CN_" + rel.getAttribute().getName().toUpperCase();
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = "CN_" + rel.getForeignAttribute().getName().toUpperCase();
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append("CN_").append(mattr.getName().toUpperCase()).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                        String name = attr.getName().toUpperCase() + sp.getPostfix();
                        boolean mainColumn = sp.getPostfix().isEmpty();
                        if (!mainColumn) {
                          buf.append("           .append(Backend.SQL_AND)\n")
                             .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                             .append(rightClass).append("CN_").append(name).append("))\n")
                             .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                        }
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append("CN_").append(methodArg.getAttribute().getName().toUpperCase()).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEntity());
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                buf.append("        sql.append(").append(compKeyClass).
                    append(".CLASSVARIABLES.getColumnName(").
                    append(compKeyClass).append(".CN_").append(name).append("))\n");
                if (mainColumn) {
                  buf.append("           .append(").append(arg.getRelop()).append(");\n");
                }
                else {
                  buf.append("           .append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }
            else {
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (isPathAllowed()) {
                  if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                     buf.append("        sql.append(");
                     buf.append(deriveClassNameForEntity(attr.getEntity()));
                     buf.append(".CLASSVARIABLES.getColumnName(CN_");
                     buf.append(name).append("));\n");
                  }
                  else  {
                    if (isPdo()) {
                      buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                    }
                    else  {
                      buf.append("        sql.append(CN_").append(name).append(");\n");
                    }
                  }
                }
                else  {
                  buf.append("        sql.append(CN_").append(name).append(");\n");
                }
                if (mainColumn) {
                  buf.append("        sql.append(").append(arg.getRelop()).append(");\n");
                }
                else  {
                  buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[44]); // genwhere.incl:237:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[45]); // genwhere.incl:240:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[46]); // genwhere.incl:245:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[47]); // genwhere.incl:255:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[48]); // genwhere.incl:257:25 = ";"
    }
    out.print(source[49]); // 222:37 = "        getBackend().buildSelectSql(sql,..."
    out.print(lock ? "true" : "false");
    out.print(source[50]); // 223:68 = ", "
    out.print(limit ? "limit" : "0");
    out.print(source[51]); // 223:95 = ", "
    out.print(offset ? "offset" : "0");
    out.print(source[52]); // 223:124 = ");"

    if (sort) {
      out.print(source[53]); // 227:2 = "        String orderSuffix = orderBy();..."
    }
    if (append != null)  {
      out.print(source[54]); // 235:2 = "        sql.append(' ');        sql.app..."
      out.print(append);
      out.print(source[55]); // 237:29 = ");"
    }
    if (isWithJoins()) {
      out.print(source[56]); // 241:2 = "        js.createJoinedSql(me(), sql);"
    }
    out.print(source[57]); // 245:2 = "        return sql.toString();      } ..."
    if (limit || offset) {
      out.print(source[58]); // 251:2 = "    int ndx = getBackend().setLeadingSel..."
      out.print(limit ? "limit" : "0");
      out.print(source[59]); // 252:83 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[60]); // 252:112 = ");"
    }
    else  {
      out.print(source[61]); // 256:2 = "    int ndx = 1;"
    }

    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[62]); // gensetpar.incl:6:2 = "    if (isClassIdRequiredInWhereClause()..."
    }
    if (getContextAttribute() != null) {
      out.print(source[63]); // gensetpar.incl:13:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute()));
      out.print(source[64]); // gensetpar.incl:14:54 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[65]); // gensetpar.incl:14:97 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                if (attr.getOptions().isMapNull())  {
                  out.print(source[66]); // gensetpar.incl:28:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[67]); // gensetpar.incl:29:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[68]); // gensetpar.incl:29:111 = ", true);"
                }
                else  {
                  out.print(source[69]); // gensetpar.incl:33:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[70]); // gensetpar.incl:34:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[71]); // gensetpar.incl:34:111 = ");"
                }
                // for multi column types, such as BMoney/DMoney
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
                  out.print(source[72]); // gensetpar.incl:39:2 = "    ndx++;"
                }
              }
            }
          }
        }
      }


      if (!par.isValueLiterally()) {
        Attribute attr = par.getAttribute();
        if (attr.getOptions().isMapNull())  {
          out.print(source[73]); // gensetpar.incl:53:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[74]); // gensetpar.incl:54:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[75]); // gensetpar.incl:54:86 = ", true);"
        }
        else  {
          out.print(source[76]); // gensetpar.incl:58:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[77]); // gensetpar.incl:59:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[78]); // gensetpar.incl:59:86 = ");"
        }
        // for multi column types, such as BMoney/DMoney
        for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
          out.print(source[79]); // gensetpar.incl:64:2 = "    ndx++;"
        }
      }
    }
    if (limit || offset) {
      out.print(source[80]); // 265:2 = "    getBackend().setTrailingSelectParame..."
      out.print(limit ? "limit" : "0");
      out.print(source[81]); // 266:79 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[82]); // 266:108 = ");"
    }

    if (resultSet) {
      out.print(source[83]); // 271:2 = "    return st.executeQuery();"
    }
    else  {
      if (cursor != null) {
        out.print(source[84]); // 277:2 = "    ResultSetWrapper rs = st.executeQuer..."
        if (isWithJoins()) {
          out.print(source[85]); // 281:2 = "    return new ResultSetCursor<>(me(), r..."
        }
        else  {
          out.print(source[86]); // 286:2 = "    return new ResultSetCursor<>(me(), r..."
        }
      } // end if cursor
      else  { // list
        if (isTracked())  {
          if (isWithJoins()) {
            out.print(source[87]); // 294:2 = "    return executeTrackedListQuery(st, j..."
          }
          else  {
            out.print(source[88]); // 299:2 = "    return executeTrackedListQuery(st);..."
          }
        }
        else  {
          if (isWithJoins()) {
            out.print(source[89]); // 306:2 = "    return executeListQuery(st, js);"
          }
          else  {
            out.print(source[90]); // 311:2 = "    return executeListQuery(st);"
          }
        }
      }   // end if list
    }   // end !resultset
       out.print(source[91]); // 318:2 = "  }"
  }

  // ----------------- end wurblet code -----------------

  @Override
  public String process(String code) {
    int ref = code.lastIndexOf("ndx");
    int pos = code.lastIndexOf("(ndx++,");
    if (pos >= 0 && ref == pos + 1) {
      // remove unnecessary last ++
      return code.substring(0, pos + 4) + code.substring(pos + 6);
    }
    return code;
  }
}
