// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for related entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoRelations
 *     [--loadcomponents|--noloadcomponents]
 *     [--insertcomponents|--noinsertcomponents]
 *     [--deletecomponents|--nodeletecomponents]
 *     [--nori] [--noselects] [--nodeletes]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--loadcomponents|--noloadcomponents:</em> force (no) generation of loadComponents().</li>
 * <li><em>--insertcomponents|--noinsertcomponents:</em> force (no) generation of insertPlainWithComponents().</li>
 * <li><em>--deletecomponents|--nodeletecomponents:</em> force (no) generation of deletePlainWithComponents().</li>
 * <li><em>--nori:</em> don't generate PdoIsReferencing wurblet anchors and addReferencingClass() invocations.</li>
 * <li><em>--noselects:</em> don't generate PdoSelect... wurblet anchors.</li>
 * <li><em>--nodeletes:</em> don't generate PdoDelete... wurblet anchors.</li>
 * <li><em>--novalidate:</em> don't generate validate method.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoRelations extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();

    String pdoName = null;
    try {
      // in implementation
      pdoName = getPdoClassName();
    }
    catch (WurbelException we) {
      // in interface
      pdoName = getClassName();
    }

    boolean generateDeclarations                    = false;
    boolean generateIsModified                      = false;
    boolean generateIsComposite                     = false;
    boolean generateSaveReferencingRelations        = false;
    boolean generateSaveReferencedRelations         = false;
    boolean generateDeleteReferencingRelations      = false;
    boolean generateDeleteReferencedRelations       = false;
    boolean generateLazyDeleteReferencingRelations  = false;
    boolean generateLazyDeleteReferencedRelations   = false;
    boolean generateSetSession                      = false;
    Boolean generateLoadComponents                  = null;
    Boolean generateInsertComponents                = null;
    Boolean generateDeleteComponents                = null;
    boolean generateMarkDeleted                     = false;
    boolean generateIsReferencing                   = true;
    boolean generateAddReferencing                  = false;
    boolean generateSelects                         = true;
    boolean generateDeletes                         = true;
    Boolean generateValidate                        = null;
    boolean generateSetImmutable                    = false;
    boolean generateSnapshot                        = false;
    boolean generateClearOnRemoteSave               = false;
    boolean generateAlignComponents                 = false;

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
        generateAddReferencing = true;
        break;
      }
    }

    for (String arg: getOptionArgs())  {
      if (arg.equals("noloadcomponents")) {
        generateLoadComponents = false;
      }
      else if (arg.equals("noinsertcomponents")) {
        generateInsertComponents = false;
      }
      else if (arg.equals("nodeletecomponents")) {
        generateDeleteComponents = false;
      }
      else if (arg.equals("novalidate")) {
        generateValidate = false;
      }
      else if (arg.equals("loadcomponents")) {
        generateLoadComponents = true;
      }
      else if (arg.equals("insertcomponents")) {
        generateInsertComponents = true;
      }
      else if (arg.equals("deletecomponents")) {
        generateDeleteComponents = true;
      }
      else if (arg.equals("nori")) {
        generateIsReferencing = false;
        generateAddReferencing = false;
      }
      else if (arg.equals("noselects")) {
        generateSelects = false;
      }
      else if (arg.equals("nodeletes")) {
        generateDeletes = false;
      }
    }

    // check which methods need generation
    for (Relation rel: getEntity().getRelations()) {
      if (rel.getSelectionType() == SelectionType.LAZY ||
          rel.getSelectionType() == SelectionType.EAGER)  {
        generateDeclarations = true;
        if (!rel.isSelectionCached()) {
          generateSetSession = true;
        }
      }
      if (rel.isComposite()) {
        generateIsComposite         = true;
        generateDeclarations        = true;
        generateIsModified          = true;
        generateSetSession          = true;
        generateMarkDeleted         = true;
        generateSnapshot            = true;
        generateSetImmutable        = true;

        if (generateValidate == null) {
          generateValidate = true;
        }

        if (rel.getRelationType() == RelationType.OBJECT) {
          generateSaveReferencedRelations = true;
          generateDeleteReferencedRelations = true;
          generateLazyDeleteReferencedRelations = true;
        }
        else  { // LIST
          generateSaveReferencingRelations = true;
          generateDeleteReferencingRelations = true;
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            generateLazyDeleteReferencingRelations = true;
            if (rel.getCountAttribute() != null) {
              generateAlignComponents = true;
            }
          }
        }
      }
      if (rel.isClearOnRemoteSave()) {
        generateClearOnRemoteSave = true;
      }
    }

    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    if (generateLoadComponents == null) {
      generateLoadComponents = generateIsComposite;
    }
    if (generateInsertComponents == null) {
      generateInsertComponents = generateIsComposite;
    }
    if (generateDeleteComponents == null) {
      generateDeleteComponents = generateIsComposite && (!useDatabaseRefInt || getEntity().isRootEntity());
    }

    if (generateDeclarations) {
      // declarations
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite())  {
          String type = rel.getDeclaredJavaType(false);
          String transientModifier = isRelationTransient(rel) ? "transient " : "";
          out.print(source[0]); // 168:2 = "  // "
          out.print(rel);
          out.print(source[1]); // 170:12 = "  private "
          out.print(transientModifier);
          out.print(type);
          out.print(source[2]); // 171:39 = " "
          out.print(rel.getVariableName());
          out.print(source[3]); // 171:65 = ";"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[4]); // 174:2 = "  private "
            out.print(transientModifier);
            out.print(source[5]); // 175:31 = "boolean "
            out.print(rel.getVariableName());
            out.print(source[6]); // 175:64 = "Loaded;"
          }
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
              out.print(source[7]); // 180:2 = "  private transient "
              out.print(type);
              out.print(source[8]); // 181:28 = " "
              out.print(rel.getVariableName());
              out.print(source[9]); // 181:54 = "Snapshot;"
            }
            if (rel.getRelationType() == RelationType.OBJECT) {
              out.print(source[10]); // 185:2 = "  private long "
              out.print(rel.getVariableName());
              out.print(source[11]); // 186:40 = "RemovedId;"
            }
          }
        }

        if (rel.getNmName() != null) {
          String nmVar;
          if (rel.getNmMethodName() != null) {
            nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
          }
          else  {
            nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
          }
          out.print(source[12]); // 200:2 = "  private transient TrackedList<"
          out.print(rel.getNmRelation().getDeclaredJavaType(false));
          out.print(source[13]); // 201:82 = "> "
          out.print(nmVar);
          out.print(source[14]); // 201:93 = ";"
        }
      }
    }

    if (generateClearOnRemoteSave) {
      out.print(source[15]); // 208:2 = "  @Override  public void clearOnRemote..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isClearOnRemoteSave()) {
          out.print(source[16]); // 215:2 = "    "
          out.print(rel.getVariableName());
          out.print(source[17]); // 216:29 = " = null;"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[18]); // 219:2 = "    "
            out.print(rel.getVariableName());
            out.print(source[19]); // 220:29 = "Loaded = false;"
          }
        }
      }
      out.print(source[20]); // 225:2 = "  }"
    }



    // generate getter/setter
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String effType = rel.getJavaType();
      String scope = rel.getAccessScope().toString();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        scope = attr.getOptions().getAccessScope().toString();
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }
      if (rel.getForeignRelation() != null) {
        String linkMethodName = rel.getForeignRelation().getLinkMethodName();
        if (linkMethodName != null && !rel.getSetterName().equals(linkMethodName)) {
          // don't generate setter impl if linkmethodname is not default from model
          createSetter = false;
        }
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == null || " + checkNull;
        }
        out.print(source[21]); // 279:2 = ""
        if (!hidden) {
          out.print(source[22]); // 283:2 = "  @Override"
        }
        if (rel.getForeignEntity().isAbstract()) { // needs a cast
        out.print(source[23]); // 288:2 = "  @SuppressWarnings("unchecked")"
        }
        out.print(source[24]); // 292:2 = "  "
        out.print(scope);
        out.print(source[25]); // 293:11 = " "
        out.print(type);
        out.print(source[26]); // 293:20 = " "
        out.print(rel.getGetterName());
        out.print(source[27]); // 293:44 = "()  {"
        if (rel.getSelectionType() == SelectionType.ALWAYS) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isSelectionCached()) {
              out.print(source[28]); // 298:2 = "    "
              out.print(var);
              out.print(source[29]); // 299:11 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[30]); // 299:47 = ";"
            }
            else {
              out.print(source[31]); // 303:2 = "    "
              out.print(type);
              out.print(source[32]); // 304:12 = " "
              out.print(var);
              out.print(source[33]); // 304:20 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[34]); // 304:56 = ";"
            }
            if (rel.isReferenced()) {
              if (rel.getLinkMethodIndex() != null) {
                out.print(source[35]); // 309:2 = "    int ndx = 0;"
              }
              out.print(source[36]); // 313:2 = "    for ("
              out.print(rel.getClassName());
              out.print(source[37]); // 314:31 = " obj: "
              out.print(var);
              out.print(source[38]); // 314:44 = ")  {      obj."
              out.print(createRelationUpdateReferenceCode(rel));
              out.print(source[39]); // 315:52 = ";    }"
            }
            out.print(source[40]); // 319:2 = "    return "
            out.print(var);
            out.print(source[41]); // 320:18 = ";"
          }
          else  {
            if (rel.isComposite()) {
              out.print(source[42]); // 325:2 = "    "
              out.print(var);
              out.print(source[43]); // 326:11 = " = "
              out.print(checkNull);
              out.print(source[44]); // 326:27 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[45]); // 326:70 = ";"
              if (rel.isReferenced()) {
                out.print(source[46]); // 329:2 = "    if ("
                out.print(var);
                out.print(source[47]); // 330:15 = " != null) {      "
                out.print(var);
                out.print(source[48]); // 331:13 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[49]); // 331:56 = ";    }"
              }
              if (rel.isProcessed()) {
                out.print(source[50]); // 336:2 = "    "
                out.print(var);
                out.print(source[51]); // 337:11 = " = process"
                out.print(rel.getMethodNameSuffix());
                out.print(source[52]); // 337:50 = "("
                out.print(var);
                out.print(source[53]); // 337:58 = ");"
              }
              out.print(source[54]); // 340:2 = "    return "
              out.print(var);
              out.print(source[55]); // 341:18 = ";"
            }
            else  {
              if (rel.isReferenced()) {
                out.print(source[56]); // 346:2 = "    "
                out.print(type);
                out.print(source[57]); // 347:12 = " obj = "
                out.print(checkNull);
                out.print(source[58]); // 347:32 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[59]); // 347:75 = ";    if (obj != null) {      obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[60]); // 349:52 = ";    }    return obj;"
              }
              else {
                out.print(source[61]); // 355:2 = "    return "
                out.print(checkNull);
                out.print(source[62]); // 356:24 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[63]); // 356:67 = ";"
              }
            }
          }
        }
        else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[64]); // 363:2 = "    if (!"
          out.print(var);
          out.print(source[65]); // 364:16 = "Loaded) {"
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.LIST) {
              String condition = "isNew()";
              Attribute countAttribute = rel.getCountAttribute();
              if (countAttribute != null) {
                condition += " || " + countAttribute.getName() + " == 0";
              }
              out.print(source[66]); // 373:2 = "      "
              out.print(var);
              out.print(source[67]); // 374:13 = " = "
              out.print(condition);
              out.print(source[68]); // 374:29 = " ? new "
              out.print(effType);
              out.print(source[69]); // 374:47 = "("
              out.print(rel.isTracked() ? "false" : "");
              out.print(source[70]); // 374:82 = ") : "
              out.print(createRelationSelectCode(rel));
              out.print(source[71]); // 374:119 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[72]); // 378:2 = "      int ndx = 0;"
                }
                out.print(source[73]); // 382:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[74]); // 383:33 = " obj: "
                out.print(var);
                out.print(source[75]); // 383:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[76]); // 384:54 = ";      }"
              }
            }
            else  {
              out.print(source[77]); // 390:2 = "      "
              out.print(var);
              out.print(source[78]); // 391:13 = " =  "
              out.print(checkNull);
              out.print(source[79]); // 391:30 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[80]); // 391:73 = ";"
              if (rel.isReferenced()) {
                out.print(source[81]); // 394:2 = "      if ("
                out.print(var);
                out.print(source[82]); // 395:17 = " != null) {        "
                out.print(var);
                out.print(source[83]); // 396:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[84]); // 396:58 = ";      }"
              }
            }

            if (rel.isProcessed()) {
              out.print(source[85]); // 403:2 = "      "
              out.print(var);
              out.print(source[86]); // 404:13 = " = process"
              out.print(rel.getMethodNameSuffix());
              out.print(source[87]); // 404:52 = "("
              out.print(var);
              out.print(source[88]); // 404:60 = ");"
            }

            if (rel.getRelationType() == RelationType.LIST) {
              if (rel.isTracked()) {
                if (rel.isImmutable()) {
                  out.print(source[89]); // 411:2 = "      "
                  out.print(var);
                  out.print(source[90]); // 412:13 = ".setImmutable(true);"
                }
                else {
                  out.print(source[91]); // 416:2 = "      if (isImmutable()) {        "
                  out.print(var);
                  out.print(source[92]); // 418:15 = ".setImmutable(true);      }"
                }
              }
            }
            else  {
              if (rel.isImmutable()) {
                out.print(source[93]); // 426:2 = "      "
                out.print(var);
                out.print(source[94]); // 427:13 = ".setImmutable(true, true);"
              }
              else {
                out.print(source[95]); // 431:2 = "      if (isImmutable() && "
                out.print(var);
                out.print(source[96]); // 432:34 = " != null) {        "
                out.print(var);
                out.print(source[97]); // 433:15 = ".setImmutable(true);      }"
              }
            }
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[98]); // 441:2 = "      "
              out.print(var);
              out.print(source[99]); // 442:13 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[100]); // 442:49 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[101]); // 446:2 = "      int ndx = 0;"
                }
                out.print(source[102]); // 450:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[103]); // 451:33 = " obj: "
                out.print(var);
                out.print(source[104]); // 451:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[105]); // 452:54 = ";      }"
              }
            }
            else  {
              out.print(source[106]); // 458:2 = "      "
              out.print(var);
              out.print(source[107]); // 459:13 = " = "
              out.print(checkNull);
              out.print(source[108]); // 459:29 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[109]); // 459:72 = ";"
              if (rel.isReferenced()) {
                out.print(source[110]); // 462:2 = "      if ("
                out.print(var);
                out.print(source[111]); // 463:17 = " != null) {        "
                out.print(var);
                out.print(source[112]); // 464:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[113]); // 464:58 = ";      }"
              }
            }
          }
          out.print(source[114]); // 470:2 = "      "
          out.print(var);
          out.print(source[115]); // 471:13 = "Loaded = true;"
          if (nmRel != null) {
            out.print(source[116]); // 474:2 = "      "
            out.print(var);
            out.print(source[117]); // 475:13 = ".addListener(new TrackedListListener<>()..."
            out.print(rel.getClassName());
            out.print(source[118]); // 478:48 = " element) {          get"
            out.print(nmName);
            out.print(source[119]); // 479:23 = "().addIfAbsent(element."
            out.print(nmRel.getGetterName());
            out.print(source[120]); // 479:71 = "());        }        @Override      ..."
            out.print(rel.getClassName());
            out.print(source[121]); // 483:50 = " element) {          get"
            out.print(nmName);
            out.print(source[122]); // 484:23 = "().remove(element."
            out.print(nmRel.getGetterName());
            out.print(source[123]); // 484:66 = "());        }      });"
          }
          out.print(source[124]); // 489:2 = "    }    return "
          out.print(var);
          out.print(source[125]); // 491:18 = ";"
        }
        out.print(source[126]); // 494:2 = "  }"
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
            out.print(source[127]); // 499:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[128]); // 502:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[129]); // 504:21 = " "
            out.print(rel.getComment());
            out.print(source[130]); // 504:42 = "   */  "
            out.print(scope);
            out.print(source[131]); // 506:11 = " "
            out.print(type);
            out.print(source[132]); // 506:20 = " "
            out.print(rel.getGetterName());
            out.print(source[133]); // 506:44 = "Blunt() {    if (!"
            out.print(var);
            out.print(source[134]); // 507:16 = "Loaded) {      "
            out.print(var);
            out.print(source[135]); // 508:13 = " = new "
            out.print(effType);
            out.print(source[136]); // 508:31 = "("
            out.print(rel.isTracked() ? "false" : "");
            out.print(source[137]); // 508:66 = ");      if (isImmutable()) {        "
            out.print(var);
            out.print(source[138]); // 510:15 = ".setImmutable(true);      }      "
            out.print(var);
            out.print(source[139]); // 512:13 = "Loaded = true;    }    return "
            out.print(var);
            out.print(source[140]); // 514:18 = ";  }"
          }
          else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized()) {
            out.print(source[141]); // 519:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[142]); // 522:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[143]); // 524:21 = " "
            out.print(rel.getComment());
            out.print(source[144]); // 524:42 = "   */  "
            out.print(scope);
            out.print(source[145]); // 526:11 = " "
            out.print(type);
            out.print(source[146]); // 526:20 = " "
            out.print(rel.getGetterName());
            out.print(source[147]); // 526:44 = "Blunt() {    return "
            out.print(var);
            out.print(source[148]); // 527:18 = ";  }"
          }
        }

        if (nmRel != null) {
          String nmType = nmRel.getDeclaredJavaType(false);
          out.print(source[149]); // 535:2 = "  @Override  public TrackedList<"
          out.print(nmType);
          out.print(source[150]); // 538:31 = "> get"
          out.print(nmName);
          out.print(source[151]); // 538:46 = "() {    if ("
          out.print(nmVar);
          out.print(source[152]); // 539:17 = " == null) {      "
          out.print(nmVar);
          out.print(source[153]); // 540:15 = " = new TrackedArrayList<>() {        @..."
          out.print(rel.getGetterName());
          out.print(source[154]); // 544:40 = "().isModified();        }      };   ..."
          out.print(rel.getForeignEntity());
          out.print(source[155]); // 548:37 = " obj: "
          out.print(rel.getGetterName());
          out.print(source[156]); // 548:66 = "()) {        "
          out.print(nmVar);
          out.print(source[157]); // 549:17 = ".add(obj."
          out.print(nmRel.getGetterName());
          out.print(source[158]); // 549:51 = "());      }      "
          out.print(nmVar);
          out.print(source[159]); // 552:15 = ".addListener(new TrackedListListener<>()..."
          out.print(nmType);
          out.print(source[160]); // 555:36 = " element) {          "
          out.print(rel.getClassName());
          out.print(source[161]); // 556:32 = " obj = on("
          out.print(rel.getClassName());
          out.print(source[162]); // 556:64 = ".class);          obj."
          out.print(nmRel.getSetterName());
          out.print(source[163]); // 557:39 = "(element);          getNmLinks().add(ob..."
          out.print(nmType);
          out.print(source[164]); // 562:38 = " element) {          for (Iterator<"
          out.print(rel.getClassName());
          out.print(source[165]); // 563:46 = "> iter = "
          out.print(rel.getGetterName());
          out.print(source[166]); // 563:78 = "().iterator(); iter.hasNext(); ) {     ..."
          out.print(rel.getClassName());
          out.print(source[167]); // 564:34 = " obj = iter.next();            if (Obje..."
          out.print(nmRel.getGetterName());
          out.print(source[168]); // 565:60 = "(), element)) {              iter.remov..."
          out.print(nmVar);
          out.print(source[169]); // 573:20 = ";  }"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
          if (rel.getAccessScope() == AccessScope.PUBLIC) {
            out.print(source[170]); // 581:2 = "  @Override"
          }
          else {
            out.print(source[171]); // 587:2 = "  /**   * Returns whether "
            out.print(rel.getName());
            out.print(source[172]); // 590:38 = " is loaded.   *   * @return true if "
            out.print(rel.getGetterName());
            out.print(source[173]); // 592:45 = "() invoked at least once   */"
          }
          out.print(source[174]); // 596:2 = "  "
          out.print(scope);
          out.print(source[175]); // 597:11 = " boolean is"
          out.print(StringHelper.firstToUpper(var));
          out.print(source[176]); // 597:56 = "Loaded() {    return "
          out.print(var);
          out.print(source[177]); // 598:18 = "Loaded;  }"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
        out.print(source[178]); // 608:2 = ""
        if (!hidden) {
          out.print(source[179]); // 612:2 = "  @Override"
        }
        if (linkMethodIndex != null) {
          out.print(source[180]); // 617:2 = "  "
          out.print(scope);
          out.print(source[181]); // 618:11 = " void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[182]); // 618:65 = "("
          out.print(type);
          out.print(source[183]); // 618:74 = " "
          out.print(var);
          out.print(source[184]); // 618:82 = ", int index)  {"
        }
        else {
          out.print(source[185]); // 622:2 = "  "
          out.print(scope);
          out.print(source[186]); // 623:11 = " void "
          out.print(rel.getSetterName());
          out.print(source[187]); // 623:40 = "("
          out.print(type);
          out.print(source[188]); // 623:49 = " "
          out.print(var);
          out.print(source[189]); // 623:57 = ")  {"
        }
        if (!rel.isReversed()) {
          out.print(source[190]); // 627:2 = "    assertMutable();"
        }
        if ((rel.getRelationType() == RelationType.LIST && !rel.isReversed()) ||
            rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[191]); // 634:2 = "    if (!attributesModified()) {      s..."
            out.print(var);
            out.print(source[192]); // 636:46 = ", "
            out.print(var);
            out.print(source[193]); // 636:55 = "));    }"
          }
          out.print(source[194]); // 640:2 = "    this."
          out.print(var);
          out.print(source[195]); // 641:16 = " = "
          out.print(var);
          out.print(source[196]); // 641:26 = ";"
          if (linkMethodIndex != null) {
            out.print(source[197]); // 644:2 = "    set"
            out.print(StringHelper.firstToUpper(linkMethodIndex));
            out.print(source[198]); // 645:53 = "(index);"
          }
        }
        if (rel.getRelationType() == RelationType.OBJECT) {
          if (rel.isComposite())  {
            if (attr != null && !attr.getDataType().isPrimitive()) {
              out.print(source[199]); // 652:2 = "    "
              out.print(attr.getJavaType());
              out.print(source[200]); // 653:26 = " oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[201]); // 653:85 = ";"
            }
            else {
              out.print(source[202]); // 657:2 = "    long oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[203]); // 658:67 = ";"
            }
          }
          out.print(source[204]); // 662:2 = "    "
          out.print(createRelationSetFirstArgMethodName(rel));
          out.print(source[205]); // 663:48 = "("
          out.print(var);
          out.print(source[206]); // 663:56 = " == null ? "
          out.print(nullVal);
          out.print(source[207]); // 663:78 = " : "
          out.print(var);
          out.print(source[208]); // 663:88 = ".getId());"
        }
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[209]); // 667:2 = "    "
          out.print(var);
          out.print(source[210]); // 668:11 = "Loaded = true;"
        }
        if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite())  {
          if (attr != null && !attr.getDataType().isPrimitive()) {
            out.print(source[211]); // 673:2 = "    if (oldId != null && oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[212]); // 674:64 = "RemovedId == 0 && !Objects.equals("
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[213]); // 674:148 = ", oldId)) {      "
            out.print(rel.getVariableName());
            out.print(source[214]); // 675:31 = "RemovedId = oldId;    }"
          }
          else {
            out.print(source[215]); // 680:2 = "    if (oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[216]); // 681:47 = "RemovedId == 0 && "
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[217]); // 681:115 = " != oldId) {      "
            out.print(rel.getVariableName());
            out.print(source[218]); // 682:31 = "RemovedId = oldId;    }"
          }
        }
        out.print(source[219]); // 687:2 = "  }"
      }

      if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() &&
          (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
            out.print(source[220]); // 694:2 = "  /**   * Sets "
            out.print(var);
            out.print(source[221]); // 697:17 = " without setting any attributes.   *  ..."
            out.print(var);
            out.print(source[222]); // 699:20 = " "
            out.print(rel.getComment());
            out.print(source[223]); // 699:41 = "   */  "
            out.print(scope);
            out.print(source[224]); // 701:11 = " void "
            out.print(rel.getSetterName());
            out.print(source[225]); // 701:40 = "Blunt("
            out.print(type);
            out.print(source[226]); // 701:54 = " "
            out.print(var);
            out.print(source[227]); // 701:62 = ") {    this."
            out.print(var);
            out.print(source[228]); // 702:16 = " = "
            out.print(var);
            out.print(source[229]); // 702:26 = ";    "
            out.print(var);
            out.print(source[230]); // 703:11 = "Loaded = true;  }"
      }

    }


    // gerenate setSession and setDomainContext for referenced objects (necessary for RMI)
    if (generateSetSession)  {
      out.print(source[231]); // 713:2 = "  @Override  public void setSession(Se..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[232]); // 724:2 = "    session.applyTo("
               out.print(rel.getVariableName());
               out.print(source[233]); // 725:45 = ");"
        }
      }
      out.print(source[234]); // 729:2 = "  }  @Override  public void setDomain..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[235]); // 741:2 = "    context.applyTo("
               out.print(rel.getVariableName());
               out.print(source[236]); // 742:45 = ");"
        }
      }
      out.print(source[237]); // 746:2 = "  }"
    }



    // generate code to remove delete composite relations

    if (generateDeleteReferencingRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[238]); // 757:2 = "  /**   * Deletes all referencing comp..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (!rel.isTracked()) {
                throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
              }
              String var = rel.getVariableName();
              out.print(source[239]); // 771:2 = "    if ("
              out.print(var);
              out.print(source[240]); // 772:15 = " != null && "
              out.print(var);
              out.print(source[241]); // 772:34 = ".isSomeRemoved()) {      delete("
              out.print(var);
              out.print(source[242]); // 773:20 = ".getRemovedObjects());    }"
            }
          }
          out.print(source[243]); // 778:2 = "  }"
      }
      else { // no database ref. integrity
        if (generateLazyDeleteReferencingRelations)  {
          out.print(source[244]); // 784:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                if (rel.isTracked())  {
                  out.print(source[245]); // 809:2 = "    if (delete) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[246]); // 813:2 = "      delete("
                    out.print(rel.getGetterName());
                    out.print(source[247]); // 814:36 = "());"
                  }
                  else {
                    out.print(source[248]); // 818:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[249]); // 819:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[250]); // 820:39 = ";"
                  }
                  out.print(source[251]); // 823:2 = "    }    if ("
                  out.print(var);
                  out.print(source[252]); // 825:15 = " != null && "
                  out.print(var);
                  out.print(source[253]); // 825:34 = ".isSomeRemoved()) {      delete("
                  out.print(var);
                  out.print(source[254]); // 826:20 = ".getRemovedObjects());    }"
                }  // end if isTracked
                else  {
                  out.print(source[255]); // 831:2 = "    if (delete || "
                  out.print(var);
                  out.print(source[256]); // 832:25 = " != null) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[257]); // 835:2 = "      markDeleted("
                    out.print(rel.getGetterName());
                    out.print(source[258]); // 836:41 = "());      deleteMissingInCollection("
                    out.print(createRelationSelectCode(rel));
                    out.print(source[259]); // 837:65 = ", "
                    out.print(var);
                    out.print(source[260]); // 837:74 = ");"
                  } // end isDeleteCascade
                  else {
                    out.print(source[261]); // 841:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[262]); // 842:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[263]); // 843:39 = ";"
                  }
                  out.print(source[264]); // 846:2 = "    }"
                }
              }
            } // end composite
          }
          out.print(source[265]); // 853:2 = "  }"
        } // end if generateLazyDeleteReferencingRelations

        else  {   // no lazy loading at all
        out.print(source[266]); // 859:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.isDeletionCascaded()) {
                out.print(source[267]); // 869:2 = "    delete("
                out.print(rel.getGetterName());
                out.print(source[268]); // 870:34 = "());"
              }
              else {
                out.print(source[269]); // 874:2 = "    markDeleted("
                out.print(var);
                out.print(source[270]); // 875:23 = ");    "
                out.print(createRelationDeleteCode(rel));
                out.print(source[271]); // 876:37 = ";"
              }
            }
          }
          out.print(source[272]); // 881:2 = "  }"
        }
      } // end w/o db-integrity
    }


    if (generateDeleteReferencedRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[273]); // 891:2 = "  /**   * Deletes all referenced compo..."
        for (Relation rel: getEntity().getRelations()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            if (!rel.isTracked()) {
              throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
            }
            // remove the old deleted composite too, if set
            // we need to replace <varname>Id by <varname>RemovedId in the select statement
            String var = rel.getVariableName();
            String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
            out.print(source[274]); // 908:2 = "    if ("
            out.print(rel.getVariableName());
            out.print(source[275]); // 909:33 = "RemovedId != 0) {      "
            out.print(rel.getClassName());
            out.print(source[276]); // 910:28 = " old = "
            out.print(selectStmt);
            out.print(source[277]); // 910:49 = ";      if (old != null) {        old.d..."
            out.print(rel.getVariableName());
            out.print(source[278]); // 913:33 = "RemovedId = 0;      }    }"
          }
        }
        out.print(source[279]); // 919:2 = "  }"
      }
      else  {
        if (generateLazyDeleteReferencedRelations)  {
          out.print(source[280]); // 925:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                out.print(source[281]); // 949:2 = "    if (delete && "
                out.print(rel.getGetterName());
                out.print(source[282]); // 950:41 = "() != null && !"
                out.print(var);
                out.print(source[283]); // 950:63 = ".isVirgin()) {      delete("
                out.print(var);
                out.print(source[284]); // 951:20 = ");    }"
              }
              // remove the old deleted composite too, if set
              // we need to replace <varname>Id by <varname>RemovedId in the select statement
              String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
              out.print(source[285]); // 958:2 = "    if ("
              out.print(rel.getVariableName());
              out.print(source[286]); // 959:33 = "RemovedId != 0) {      "
              out.print(rel.getClassName());
              out.print(source[287]); // 960:28 = " old = "
              out.print(selectStmt);
              out.print(source[288]); // 960:49 = ";      if (old != null) {        old.d..."
              out.print(rel.getVariableName());
              out.print(source[289]); // 963:33 = "RemovedId = 0;      }    }"
            } // end composite
          }
          out.print(source[290]); // 969:2 = "  }"
        } // end if generateLazyDeleteReferencedRelations

        else  {   // no lazy loading at all
        out.print(source[291]); // 975:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.ALWAYS) {
                throw new WurbelException("internal wurblet logic error");
              }
              else {
                out.print(source[292]); // 988:2 = "    if ("
                out.print(var);
                out.print(source[293]); // 989:15 = " != null) {      delete("
                out.print(var);
                out.print(source[294]); // 990:20 = ");    }"
              }
            }
          }
          out.print(source[295]); // 996:2 = "  }"
        }
      }
    }


    // save composite relations

    if (generateSaveReferencingRelations)  {
      out.print(source[296]); // 1007:2 = "  @Override  public void saveReferenci..."
      if (useDatabaseRefInt) {
        out.print(source[297]); // 1015:2 = "      deleteRemovedReferencingRelations(..."
      }
      else  {
        out.print(source[298]); // 1020:2 = "      deleteReferencingRelations("
        out.print(generateLazyDeleteReferencingRelations ? "false" : "");
        out.print(source[299]); // 1021:90 = ");"
      }
      out.print(source[300]); // 1024:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          if (rel.isProcessed()) {
            out.print(source[301]); // 1031:2 = "    "
            out.print(var);
            out.print(source[302]); // 1032:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[303]); // 1032:50 = "("
            out.print(var);
            out.print(source[304]); // 1032:58 = ");"
          }
          out.print(source[305]); // 1035:2 = "    if ("
          out.print(var);
          out.print(source[306]); // 1036:15 = " != null) {      getDomainContext().app..."
          out.print(var);
          out.print(source[307]); // 1037:40 = ");"
          if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
            out.print(source[308]); // 1040:2 = "      int ndx = 0;"
          }
          out.print(source[309]); // 1044:2 = "      for ("
          out.print(rel.getClassName());
          out.print(source[310]); // 1045:33 = " obj: "
          out.print(var);
          out.print(source[311]); // 1045:46 = ")  {        obj."
          out.print(createRelationLinkCode(rel));
          out.print(source[312]); // 1046:43 = ";"
          boolean firstSkipped = false;
          for (MethodArgument ma: rel.getMethodArgs()) {
            if (firstSkipped)  {
              out.print(source[313]); // 1051:2 = "        obj."
              out.print(ma.getSetterMethod());
              out.print(source[314]); // 1052:36 = "("
              out.print(ma.getMethodArgument());
              out.print(source[315]); // 1052:63 = ");"
            }
            firstSkipped = true;
          }
          out.print(source[316]); // 1057:2 = "      }      save("
          out.print(var);
          out.print(source[317]); // 1059:18 = ", "
          out.print(rel.isTracked() ? "true" : "false");
          out.print(source[318]); // 1059:58 = ");    }"
        }
      }
      out.print(source[319]); // 1064:2 = "  }"
    }


    if (generateSaveReferencedRelations)  {
      out.print(source[320]); // 1071:2 = "  @Override  public void saveReference..."
      if (getEntity().isRootEntity()) {
        // need a valid id to store in rootId of composite object relations
        out.print(source[321]); // 1078:2 = "    reserveId();"
      }
      out.print(source[322]); // 1082:2 = "    super.saveReferencedRelations(update..."
      if (useDatabaseRefInt) {
        out.print(source[323]); // 1087:2 = "      deleteRemovedReferencedRelations()..."
      }
      else  {
        out.print(source[324]); // 1092:2 = "      deleteReferencedRelations("
        out.print(generateLazyDeleteReferencedRelations ? "false" : "");
        out.print(source[325]); // 1093:88 = ");"
      }
      out.print(source[326]); // 1096:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[327]); // 1102:2 = "    getDomainContext().applyTo("
          out.print(var);
          out.print(source[328]); // 1103:38 = ");"
          if (rel.isProcessed()) {
            out.print(source[329]); // 1106:2 = "    "
            out.print(var);
            out.print(source[330]); // 1107:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[331]); // 1107:50 = "("
            out.print(var);
            out.print(source[332]); // 1107:58 = ");"
          }
          if (rel.isTracked())  {
            out.print(source[333]); // 1111:2 = "    if ("
            out.print(var);
            out.print(source[334]); // 1112:15 = " != null && "
            out.print(var);
            out.print(source[335]); // 1112:34 = ".isModified()) {      save("
            out.print(var);
            out.print(source[336]); // 1113:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[337]); // 1114:50 = "("
            out.print(var);
            out.print(source[338]); // 1114:58 = ".getId());    }"
          }
          else  {
            out.print(source[339]); // 1119:2 = "    if ("
            out.print(var);
            out.print(source[340]); // 1120:15 = " != null) {      save("
            out.print(var);
            out.print(source[341]); // 1121:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[342]); // 1122:50 = "("
            out.print(var);
            out.print(source[343]); // 1122:58 = ".getId());    }"
          }
        }
      }
      out.print(source[344]); // 1128:2 = "  }"
    }



    // generate code to validate
    if (Boolean.TRUE.equals(generateValidate))  {
      out.print(source[345]); // 1137:2 = "  @Override  public List<ValidationRes..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[346]); // 1146:2 = "    if ("
          out.print(var);
          out.print(source[347]); // 1147:15 = " != null) {"
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[348]); // 1150:2 = "      results.addAll(ValidationUtilities..."
            out.print(rel.getVariableName());
            out.print(source[349]); // 1152:41 = ", validationPath + "."
            out.print(var);
            out.print(source[350]); // 1152:69 = "", scope));"
          }
          else  {
            out.print(source[351]); // 1156:2 = "      results.addAll("
            out.print(rel.getVariableName());
            out.print(source[352]); // 1157:46 = ".validate(validationPath + "."
            out.print(var);
            out.print(source[353]); // 1157:82 = "", scope));"
          }
          out.print(source[354]); // 1160:2 = "    }"
        }
      }
      out.print(source[355]); // 1165:2 = "    return results;  }"
    }



    // generate code to check set the immutable flag
    if (generateSetImmutable)  {
      out.print(source[356]); // 1175:2 = "  @Override  public void setImmutable(..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          out.print(source[357]); // 1183:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[358]); // 1184:33 = " != null) {      "
          out.print(rel.getVariableName());
          out.print(source[359]); // 1185:31 = ".setImmutable(immutable);    }"
        }
      }
      out.print(source[360]); // 1190:2 = "  }"
    }



    // generate code to check for modifications
    if (generateIsModified)  {
      out.print(source[361]); // 1199:2 = "  @Override  public boolean isModified..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[362]); // 1208:2 = "           || isModified("
            out.print(rel.getVariableName());
            out.print(source[363]); // 1209:50 = ")"
          }
          else  {
            out.print(source[364]); // 1213:2 = "           || "
            out.print(rel.getVariableName());
            out.print(source[365]); // 1214:39 = " != null && "
            out.print(rel.getVariableName());
            out.print(source[366]); // 1214:76 = ".isModified()"
          }
        }
      }
      out.print(source[367]); // 1219:2 = "           ;  }"
    }

    if (generateAlignComponents) {
      out.print(source[368]); // 1226:2 = "  @Override  protected void alignCompo..."
      for (Relation rel: getEntity().getRelations()) {
        Attribute countAttribute = rel.getCountAttribute();
        if (countAttribute != null) {
          out.print(source[369]); // 1235:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[370]); // 1236:33 = " != null) {      "
          out.print(countAttribute.getSetterName());
          out.print(source[371]); // 1237:40 = "("
          out.print(rel.getVariableName());
          out.print(source[372]); // 1237:66 = ".size());    }"
        }
      }
      out.print(source[373]); // 1242:2 = "  }"
    }

    if (getEntity().isDeeplyReferenced()) {
      List<Relation> deepRelations = new ArrayList<>();
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite() && rel.getForeignEntity().isDeeplyReferenced()) {
          deepRelations.add(rel);
        }
      }
      if (!deepRelations.isEmpty()) {
        out.print(source[374]); // 1255:2 = "  @Override  public boolean isReferenc..."
        for (Relation rel: deepRelations) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[375]); // 1266:2 = "    for ("
            out.print(rel.getForeignEntity());
            out.print(source[376]); // 1267:35 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[377]); // 1267:64 = "()) {      if (obj.isReferenced()) {  ..."
          }
          else {
            out.print(source[378]); // 1275:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[379]); // 1276:31 = "() != null && "
            out.print(rel.getGetterName());
            out.print(source[380]); // 1276:68 = "().isReferenced()) {      return true;..."
          }
        }
        out.print(source[381]); // 1282:2 = "    return false;  }"
      }
    }



    // override isComposite()
    if (generateIsComposite)  {
      out.print(source[382]); // 1294:2 = "  @Override  public boolean isComposit..."
    }


    //  load all components
    if (generateLoadComponents)  {

      out.print(source[383]); // 1308:2 = "  @Override  public IdentifiableMap<? ..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[384]); // 1326:2 = "    if (!onlyLoaded || "
            out.print(var);
            out.print(source[385]); // 1327:30 = "Loaded) {"
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[386]); // 1330:2 = "      count += addComponents(components,..."
              out.print(rel.getGetterName());
              out.print(source[387]); // 1331:64 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[388]); // 1335:2 = "      if ("
              out.print(rel.getGetterName());
              out.print(source[389]); // 1336:33 = "() != null) {        count += ((Abstrac..."
              out.print(var);
              out.print(source[390]); // 1337:57 = ".getPersistenceDelegate()).addComponents..."
            }
            out.print(source[391]); // 1341:2 = "    }"
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[392]); // 1347:2 = "    count += addComponents(components, "
              out.print(rel.getGetterName());
              out.print(source[393]); // 1348:62 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[394]); // 1352:2 = "    if ("
              out.print(rel.getGetterName());
              out.print(source[395]); // 1353:31 = "() != null) {      count += ((AbstractP..."
              out.print(var);
              out.print(source[396]); // 1354:55 = ".getPersistenceDelegate()).addComponents..."
            }
          }
        }
      }
      out.print(source[397]); // 1361:2 = "    return count;  }"
    }



    //  insert all components
    if (generateInsertComponents)  {

      out.print(source[398]); // 1372:2 = "  @Override  public void insertPlainWi..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[399]); // 1380:2 = "    if ("
          out.print(rel.getGetterName());
          out.print(source[400]); // 1381:31 = "() != null) {      ((AbstractPersistent..."
          out.print(var);
          out.print(source[401]); // 1382:46 = ".getPersistenceDelegate()).insertPlainWi..."
        }
      }
      out.print(source[402]); // 1387:2 = "    insertPlain();"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          out.print(source[403]); // 1393:2 = "    insertPlainWithComponents("
          out.print(rel.getGetterName());
          out.print(source[404]); // 1394:53 = "());"
        }
      }
      out.print(source[405]); // 1398:2 = "  }"
    }


    //  delete all components
    if (generateDeleteComponents)  {

      out.print(source[406]); // 1407:2 = "  @Override  public void deletePlainWi..."
      if (useDatabaseRefInt) {
        out.print(source[407]); // 1413:2 = "    // components are deleted via databa..."
      }
      else {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
            out.print(source[408]); // 1421:2 = "    deletePlainWithComponents("
            out.print(rel.getGetterName());
            out.print(source[409]); // 1422:53 = "());"
          }
        }
      }
      out.print(source[410]); // 1427:2 = "    deletePlain();"
      if (!useDatabaseRefInt) {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[411]); // 1434:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[412]); // 1435:31 = "() != null) {      ((AbstractPersistent..."
            out.print(var);
            out.print(source[413]); // 1436:46 = ".getPersistenceDelegate()).deletePlainWi..."
          }
        }
      }
      out.print(source[414]); // 1442:2 = "  }"
    }



    // mark object and all components deleted
    if (generateMarkDeleted)  {
      out.print(source[415]); // 1451:2 = "  @Override  public void markDeleted()..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[416]); // 1460:2 = "    markDeleted("
          out.print(var);
          out.print(source[417]); // 1461:23 = ");"
        }
      }
      out.print(source[418]); // 1465:2 = "  }"
    }


    // generate snapshot methods
    if (generateSnapshot) {
      out.print(source[419]); // 1473:2 = "  /**   * Updates the components in sn..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[420]); // 1481:100 = " snapshot) {    super.createComponentsI..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[421]); // 1489:2 = "    snapshot."
              out.print(var);
              out.print(source[422]); // 1490:20 = "Snapshot = TrackedList.createSnapshot("
              out.print(var);
              out.print(source[423]); // 1490:65 = ");"
            }
          }
          else {
            out.print(source[424]); // 1495:2 = "    snapshot."
            out.print(var);
            out.print(source[425]); // 1496:20 = "Snapshot = Pdo.createSnapshot("
            out.print(var);
            out.print(source[426]); // 1496:57 = ");"
          }
        }
      }
      out.print(source[427]); // 1501:2 = "  }  /**   * Reverts all components o..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[428]); // 1509:100 = " snapshot) {    super.revertComponentsT..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          Relation nmRel = rel.getNmRelation();
          String nmVar = null;
          if (nmRel != null) {
            if (rel.getNmMethodName() != null) {
              nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
            }
            else  {
              nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
            }
          }
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[429]); // 1527:2 = "    "
              out.print(var);
              out.print(source[430]); // 1528:11 = " = TrackedList.revertToSnapshot("
              out.print(var);
              out.print(source[431]); // 1528:50 = ", snapshot."
              out.print(var);
              out.print(source[432]); // 1528:68 = "Snapshot);"
            }
          }
          else {
            out.print(source[433]); // 1533:2 = "    "
            out.print(var);
            out.print(source[434]); // 1534:11 = " = Pdo.revertToSnapshot("
            out.print(var);
            out.print(source[435]); // 1534:42 = ", snapshot."
            out.print(var);
            out.print(source[436]); // 1534:60 = "Snapshot);"
          }

          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[437]); // 1539:2 = "    "
            out.print(var);
            out.print(source[438]); // 1540:11 = "Loaded = snapshot."
            out.print(var);
            out.print(source[439]); // 1540:36 = "Loaded;"
          }
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[440]); // 1544:2 = "    "
            out.print(var);
            out.print(source[441]); // 1545:11 = "RemovedId = snapshot."
            out.print(var);
            out.print(source[442]); // 1545:39 = "RemovedId;"
          }
          if (nmVar != null) {
            out.print(source[443]); // 1549:2 = "    "
            out.print(nmVar);
            out.print(source[444]); // 1550:13 = " = null;"
          }
        }
      }
      out.print(source[445]); // 1555:2 = "  }"
    }


    if (generateIsReferencing && isEntityPersistable()) {
      for (Relation rel: getEntity().getTableRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          String tagName = "isReferencing" + rel.getClassName() + "By" +
                           StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[446]); // 1568:2 = "  // Determines whether any "
                           out.print(pdoName);
                           out.print(source[447]); // 1570:39 = " references given "
                           out.print(rel.getClassName());
                           out.print(source[448]); // 1570:79 = "  // @wurblet "
                           out.print(tagName);
                           out.print(source[449]); // 1571:26 = " PdoIsReferencing "
                           out.print(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[450]); // 1571:99 = ""
        }
      }
    }

    if (generateSelects && isEntityPersistable()) {
      Set<String> wurbletArgSet = new HashSet<>();   // to avoid duplicates if args= is used
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null) {
            // force tracked even if related object is not tracked
            String trackedOption = rel.isTracked() ? "--tracked " : "";
            String joins = "";
            if (rel.getNmName() != null) {
              Relation join = rel.getNmRelation();
              if (join != null && join.getRelationType() == RelationType.OBJECT &&
                  join.getSelectionType() == SelectionType.LAZY &&
                  !join.isComposite() && join.isSerialized()) {
                joins = " *" + rel.getNmName();
              }
            }
            // add eager joins, if any
            for (Relation eRel: getEntity().getRelationsIncludingInherited()) {
              if (eRel.getSelectionType() == SelectionType.EAGER) {
                joins += " *" + eRel.getName();
              }
            }

            String extraWurbletOptions = rel.getSelectionWurbletArguments();
            if (extraWurbletOptions == null) {
              extraWurbletOptions = "";
            }
            else {
              extraWurbletOptions = " " + extraWurbletOptions;
            }
            String wurbletArgs = createRelationWurbletArgString(rel);
            if (wurbletArgSet.add(wurbletArgs)) {
              out.print(source[451]); // 1613:2 = "  // selects "
              out.print(rel);
              out.print(source[452]); // 1615:20 = ""
              if (rel.isReversed()) {
                out.print(source[453]); // 1618:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[454]); // 1619:54 = " PdoSelectUnique "
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[455]); // 1619:118 = ""
              }
              else {
                out.print(source[456]); // 1623:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[457]); // 1624:54 = " PdoSelectList "
                out.print(trackedOption);
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[458]); // 1624:133 = ""
              }
            }
          }
        }
      }
    }

    if (generateDeletes && isEntityPersistable()) {
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null && rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[459]); // 1641:2 = "  // deletes "
            out.print(rel);
            out.print(source[460]); // 1643:20 = "  // @wurblet "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[461]); // 1644:58 = " PdoDeleteBy "
            out.print(createRelationWurbletArgString(rel));
            out.print(source[462]); // 1644:110 = ""
          }
        }
      }
    }

    if (generateAddReferencing) {
      List<Relation> refRels = new ArrayList<>();
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          refRels.add(rel);
        }
      }
      if (!refRels.isEmpty()) {
        out.print(source[463]); // 1661:2 = "  // add referencing classes and their ..."
        if (getEntity().isAbstract()) {
          out.print(source[464]); // 1667:2 = "    @SuppressWarnings("unchecked")"
        }
        out.print(source[465]); // 1671:2 = "    AbstractPersistentObject<?,?> po = (..."
        out.print(pdoName);
        out.print(source[466]); // 1673:30 = ".class).getPersistenceDelegate();"
      // register referencing classes and the methods
      for (Relation rel: refRels) {
        String methodName = "isReferencing" + rel.getClassName() + "By" +
                            StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
        for (Entity leaf: rel.getEntity().getLeafEntities()) {
          out.print(source[467]); // 1680:2 = "    po.addReferencingClass("
          out.print(leaf.getName());
          out.print(source[468]); // 1681:45 = ".class, ""
          out.print(methodName);
          out.print(source[469]); // 1681:68 = "");"
        }
      }
      out.print(source[470]); // 1685:2 = "  }"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
