// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * <li><em>--noisroot:</em> don't generate isRoot method.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    boolean isPdo;
    try {
      pdoClass = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;
    boolean generateIsRoot = true;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
      else if ("noisroot".equals(arg)) {
        generateIsRoot = false;
      }
    }

    if (isRemote()) {
      new RemoteIncludes(this);   // create RMI-files if they don't exist yet
      String delegateType = (isPdo() ? pdoClass : mainClass) + "RemoteDelegate";
      if (getEntity().isAbstract()) {
        delegateType += "<T,P>";
      }
      out.print(source[0]); // 55:2 = "  @Override  public "
      out.print(delegateType);
      out.print(source[1]); // 58:25 = " getRemoteDelegate() {    return ("
      out.print(delegateType);
      out.print(source[2]); // 59:28 = ") super.getRemoteDelegate();  }"
    }

    if (getEntity().isAbstract()) {
      if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
        out.print(source[3]); // 66:2 = "  @Override  public boolean isExplicit..."
      }
    }
    else {
      if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[4]); // 77:2 = "  @Override  public boolean isClassIdR..."
      }
    }

    boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

    if (getEntity().getSuperEntity() == null) {

      if (generateIsRoot && getEntity().getOptions().isRoot()) {
        out.print(source[5]); // 92:2 = "  @Override  public boolean isRootEnti..."
      }

      if (getEntity().getOptions().isTableSerialProvided()) {
        out.print(source[6]); // 102:2 = "  @Override  public boolean isTableSer..."
      }

      if (getEntity().getOptions().isTokenLockProvided()) {
        out.print(source[7]); // 112:2 = "  @Override  public boolean isTokenLoc..."
      }

      if (getEntity().getOptions().isNormTextProvided()) {
        out.print(source[8]); // 122:2 = "  @Override  public boolean isNormText..."
      }

      if (getEntity().getOptions().isRootIdProvided()) {
        out.print(source[9]); // 132:2 = "  @Override  public boolean isRootIdPr..."
      }
      else {
        Attribute rootAttribute = getEntity().getRootAttribute();
        if (rootAttribute != null) {

          out.print(source[10]); // 144:2 = "  @Override  public long getRootId() {..."
          out.print(rootAttribute.getName());
          out.print(source[11]); // 148:38 = ";  }"
        }
      }

      if (getEntity().getOptions().isRootClassIdProvided()) {
        out.print(source[12]); // 155:2 = "  @Override  public boolean isRootClas..."
      }
      else {
        Entity rootEntity = getEntity().getRootEntity();
        if (rootEntity != null) {
          out.print(source[13]); // 166:2 = "  @Override  public int getRootClassId..."
          out.print(rootEntity.getClassId());
          out.print(source[14]); // 170:38 = ";  }"
        }
      }

      if (isTracked())  {
        out.print(source[15]); // 177:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[16]); // 188:2 = "  @Override  public void setModified(b..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod())    {
          if (isFullTracked()) {
            out.print(source[17]); // 198:2 = "      "
            out.print(attr.getName());
            out.print(source[18]); // 199:24 = "Persisted = "
            out.print(attr.getName());
            out.print(source[19]); // 199:54 = ";"
          }
          else {
            out.print(source[20]); // 203:2 = "      "
            out.print(attr.getName());
            out.print(source[21]); // 204:24 = "Modified = false;"
          }
        }
      }
      out.print(source[22]); // 209:2 = "    }  }"
    }


    if (isFullTracked()) {
      out.print(source[23]); // 217:2 = "  @Override  public boolean differsPer..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod() && !attr.getOptions().isDerived() &&
            !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
          if (attr.getDataType().isPrimitive()) {
            out.print(source[24]); // 227:2 = "           || "
            out.print(attr.getName());
            out.print(source[25]); // 228:32 = "Persisted != "
            out.print(attr.getName());
            out.print(source[26]); // 228:63 = ""
          }
          else {
            out.print(source[27]); // 232:2 = "           || !Objects.equals("
            out.print(attr.getName());
            out.print(source[28]); // 233:48 = "Persisted, "
            out.print(attr.getName());
            out.print(source[29]); // 233:77 = ")"
          }
        }
      }
      out.print(source[30]); // 238:2 = "           ;  }  @Override  public b..."
    }

    if (!getEntity().getInheritanceType().isMappingToNoTable()) {
      String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
      if (orderBy != null) {
        out.print(source[31]); // 252:2 = "  @Override  public String orderBy() {..."
        out.print(orderBy);
        out.print(source[32]); // 257:18 = ";    return sql.toString();  }"
      }
      out.print(source[33]); // 262:2 = "  @Override  public void getFields(Res..."
      boolean needIfClause = false;
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            needIfClause = true;
            break;
          }
        }
      }
      if (needIfClause) {
        out.print(source[34]); // 278:2 = "    if (rs.configureSection(CLASSVARIABL..."
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isDerived())  {
            for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
              String name = attr.getName().toUpperCase() + sp.getPostfix();
              out.print(source[35]); // 285:2 = "      rs.configureColumn(CN_"
              out.print(name);
              out.print(source[36]); // 286:36 = ");"
            }
          }
        }
        out.print(source[37]); // 291:2 = "    }"
      }
      else {
        out.print(source[38]); // 296:2 = "    rs.configureSection(CLASSVARIABLES);..."
      }
      out.print(source[39]); // 300:2 = "    if (rs.getRow() <= 0) {      throw ..."
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          String getterMethod = createJdbcGetterName(attr);
          String name = attr.getName().toUpperCase();
          boolean useSetter = isSetGetRequired(attr);

          if (attr.getDataType() == DataType.BINARY) {
            // Binary getter takes additional buffer size argument
            if (useSetter)  {
              out.print(source[40]); // 314:2 = "    "
              out.print(attr.getSetterName());
              out.print(source[41]); // 315:28 = "(rs."
              out.print(getterMethod);
              out.print(source[42]); // 315:48 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[43]); // 315:78 = "));"
            }
            else  {
              out.print(source[44]); // 319:2 = "    "
              out.print(attr.getName());
              out.print(source[45]); // 320:22 = " = rs."
              out.print(getterMethod);
              out.print(source[46]); // 320:44 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[47]); // 320:74 = ");"
            }
          }

          else  {
            String rsGetter = "rs." + getterMethod + "(";
            boolean needComma = false;
            if (attr.getOptions().isWithTimezone()) {
              rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
              needComma = true;
            }
            if (attr.getOptions().isMapNull()) {
              if (needComma) {
                rsGetter += ", ";
              }
              rsGetter += "true";
              needComma = true;
            }
            rsGetter += ")";

            String modelCode = getModelCode(attr, rsGetter);

            if (attr.getOptions().isTrimRead()) {
              modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSizeWithDefault() + ")";
            }

            if (useSetter) {
              modelCode = attr.getSetterName() + "(" + modelCode + ")";
            }
            else  {
              modelCode = attr.getName() + " = " + modelCode;
            }
            out.print(source[48]); // 353:2 = "    "
            out.print(modelCode);
            out.print(source[49]); // 354:17 = ";"
            if (attr.getOptions().isUTC()) {
              if (useSetter) {
                modelCode = attr.getGetterName() + "()";
              }
              else  {
                modelCode = attr.getName();
              }
              out.print(source[50]); // 363:2 = "    if ("
              out.print(modelCode);
              out.print(source[51]); // 364:21 = " != null) {      "
              out.print(modelCode);
              out.print(source[52]); // 365:19 = ".setUTC(true);    }"
            }
          }
        }
      }
      out.print(source[53]); // 372:2 = "  }"
      if (multiInheritance) {
        out.print(source[54]); // 376:2 = "  /**   * Sets the values of all "
        out.print(pdoClass);
        out.print(source[55]); // 379:40 = "-columns in the given statement.   *  ..."
        out.print(pdoClass);
        out.print(source[56]); // 384:34 = "(PreparedStatementWrapper st) {    int ..."
      }
      else  {
        out.print(source[57]); // 389:2 = "  @Override  public int setFields(Prep..."
      }

      for (Attribute attr: getEntity().getMappedAttributes()) {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly())  {
          String setterName = createJdbcSetterName(attr);

          String modelCode;
          if (isSetGetRequired(attr)) {
            modelCode = attr.getGetterName() + "()";
          }
          else {
            modelCode = attr.getName();
          }

          String jdbcCode = getJdbcCode(attr, modelCode);

          if (attr.getOptions().isTrimWrite()) {
            jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSizeWithDefault() + ")";
          }

          jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
          if (attr.getOptions().isWithTimezone()) {
            jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
          }
          if (attr.getOptions().isMapNull()) {
            jdbcCode += ", true)";
          }
          else  {
            jdbcCode += ")";
          }
          out.print(source[58]); // 425:2 = "    "
          out.print(jdbcCode);
          out.print(source[59]); // 426:16 = ";"

          // for multi column types, such as BMoney/DMoney
          for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
            out.print(source[60]); // 431:2 = "    ++ndx;"
          }
        }
      }

      if (multiInheritance && getEntity().getSuperEntity() != null) {
        out.print(source[61]); // 439:2 = "    st.setLong(++ndx, getId());"
      }
      out.print(source[62]); // 443:2 = "    return ndx;  }"
    }

    if (getEntity().getInheritanceType().isMappingToOwnTable()) {

      List<String> names = new ArrayList<>();
      List<Attribute> attributes = multiInheritance ?
                                      getEntity().getTableAttributes() : getEntity().getAttributesIncludingInherited();
      for (Attribute attr: attributes)  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly()) {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            String name = attr.getName().toUpperCase() + sp.getPostfix();
            names.add(name);
          }
        }
      }

      if (multiInheritance) {
        out.print(source[63]); // 464:2 = "  /**   * Creates the SQL code for the..."
        out.print(pdoClass);
        out.print(source[64]); // 467:46 = " insert statement.   *   * @return the..."
        out.print(pdoClass);
        out.print(source[65]); // 471:43 = "() {"
      }
      else  {
        out.print(source[66]); // 475:2 = "  @Override  public String createInser..."
      }
      out.print(source[67]); // 481:2 = "    return Backend.SQL_INSERT_INTO + "
      out.print(multiInheritance ? "CLASSVARIABLES." : "");
      out.print(source[68]); // 482:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."

      int count = 0;
      for (String name: names) {
        String lineSep = count == names.size() - 1 ? " +" : " + Backend.SQL_COMMA +";
        out.print(source[69]); // 488:2 = "           CN_"
        out.print(name);
        out.print(lineSep);
        out.print(source[70]); // 489:33 = ""
        count++;
      }
      out.print(source[71]); // 493:2 = "           Backend.SQL_INSERT_VALUES +"
      while (--count > 0)	{
        out.print(source[72]); // 497:2 = "           Backend.SQL_PAR_COMMA +"
      }
      out.print(source[73]); // 501:2 = "           Backend.SQL_PAR + Backend.SQL..."

      names.clear();
      for (Attribute attr: attributes)  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            String name = attr.getName().toUpperCase() + sp.getPostfix();
            names.add(name);
          }
        }
      }

      if (multiInheritance) {
        out.print(source[74]); // 517:2 = "  /**   * Creates the SQL code for the..."
        out.print(pdoClass);
        out.print(source[75]); // 520:46 = " update statement.   *   * @return the..."
        out.print(pdoClass);
        out.print(source[76]); // 524:43 = "() {"
      }
      else  {
        out.print(source[77]); // 528:2 = "  @Override  public String createUpdat..."
      }
      out.print(source[78]); // 534:2 = "    return Backend.SQL_UPDATE + "
      out.print(multiInheritance ? "CLASSVARIABLES." : "");
      out.print(source[79]); // 535:77 = "getTableName() + Backend.SQL_SET +"
      boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
      int ncnt = 0;
      for (String name: names) {
        ncnt++;
        if (!checkSerial && ncnt == names.size()) {
          out.print(source[80]); // 542:2 = "           CN_"
          out.print(name);
          out.print(source[81]); // 543:22 = " + Backend.SQL_EQUAL_PAR +"
        }
        else {
          out.print(source[82]); // 547:2 = "           CN_"
          out.print(name);
          out.print(source[83]); // 548:22 = " + Backend.SQL_EQUAL_PAR_COMMA +"
        }
      }

      if (ncnt == 0 && !checkSerial) {
        // special case: no attributes and no checkserial
        out.print(source[84]); // 555:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
      }

      if (checkSerial) {
        out.print(source[85]); // 561:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
      }
      else  {
        out.print(source[86]); // 568:2 = "           Backend.SQL_WHERE + CN_ID + B..."
      }
      out.print(source[87]); // 572:2 = "  }"
    }

    if (multiInheritance) {
      // create joinable sql selects with table aliases
      Entity topEntity = getEntity().getTopSuperEntity();
      List<Entity> chain = topEntity.getInheritanceChain(getEntity());
      List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
      String topImplClass = deriveClassNameForEntity(topEntity);
      out.print(source[88]); // 583:2 = "  /**   * Creates the SQL code for the..."
      out.print(pdoClass);
      out.print(source[89]); // 586:46 = " delete statement.   *   * @return the..."
      out.print(pdoClass);
      out.print(source[90]); // 590:43 = "() {"
      if (getEntity().isRootOfInheritanceHierarchy()) {
        out.print(source[91]); // 593:2 = "    return Backend.SQL_DELETE + Backend...."
      }
      else  {
        out.print(source[92]); // 600:2 = "    return Backend.SQL_DELETE + Backend...."
      }
      out.print(source[93]); // 605:2 = "  }  @Override  public StringBuilder ..."
      boolean needComma = false;
      for (Entity entity: chain) {
        String implClass = deriveClassNameForEntity(entity);
        out.print(source[94]); // 615:2 = "    sql."
        out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
        out.print(source[95]); // 616:57 = "append("
        out.print(implClass);
        out.print(source[96]); // 616:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
        needComma = true;
        if (entity == topEntity) {
          for (Entity sub: subs) {
            implClass = deriveClassNameForEntity(sub);
            out.print(source[97]); // 622:2 = "    sql.append(Backend.SQL_COMMA).append..."
            out.print(implClass);
            out.print(source[98]); // 623:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
          }
        }
      }
      out.print(source[99]); // 628:2 = "    sql.append(Backend.SQL_FROM);    sq..."
      out.print(topImplClass);
      out.print(source[100]); // 630:31 = ".CLASSVARIABLES.getTableName()).       ..."
      out.print(topImplClass);
      out.print(source[101]); // 631:76 = ".CLASSVARIABLES.getTableAlias());"
      if (chain.size() > 1) {
        for (Entity entity: chain.subList(1, chain.size())) {
          String implClass = deriveClassNameForEntity(entity);
          out.print(source[102]); // 636:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[103]); // 638:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[104]); // 638:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[105]); // 639:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[106]); // 640:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
      }

      for (Entity sub: subs) {
        String implClass = deriveClassNameForEntity(sub);
        out.print(source[107]); // 647:2 = "    sql.append(getBackend().sqlJoin(Join..."
        out.print(implClass);
        out.print(source[108]); // 649:28 = ".CLASSVARIABLES.getTableName(), "
        out.print(implClass);
        out.print(source[109]); // 649:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
        out.print(topImplClass);
        out.print(source[110]); // 650:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
        out.print(implClass);
        out.print(source[111]); // 651:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
      }
      out.print(source[112]); // 654:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
      String implClass = deriveClassNameForEntity(topEntity);
      out.print(source[113]); // 660:2 = "  @Override  public StringBuilder crea..."
      out.print(implClass);
      out.print(source[114]); // 666:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

      if (getEntity().isRootOfInheritanceHierarchy()) {
        out.print(source[115]); // 673:2 = "  @Override  protected void updateImpl..."
        out.print(pdoClass);
        out.print(source[116]); // 677:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[117]); // 678:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[118]); // 684:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[119]); // 685:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[120]); // 691:122 = ");    st.setLong(1, getId());    st.se..."
      }
      else  {
        out.print(source[121]); // 699:2 = "  @Override  protected void updateImpl..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[122]); // 702:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[123]); // 705:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[124]); // 706:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[125]); // 711:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[126]); // 714:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[127]); // 715:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[128]); // 720:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[129]); // 722:122 = ");    st.setLong(1, getId());    asser..."
      }
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet()) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[130]); // 737:2 = "  /*   * no accessor methods for "
          out.print(attr);
          out.print(source[131]); // 740:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[132]); // 741:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[133]); // 753:2 = "  // "
          out.print(attr);
          out.print(source[134]); // 755:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.isHidden()) {
            out.print(source[135]); // 760:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[136]); // 763:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[137]); // 765:48 = "   */"
          }
          else {
            out.print(source[138]); // 770:2 = "  @Override"
          }
          out.print(source[139]); // 775:2 = "  "
          out.print(protection);
          out.print(source[140]); // 776:16 = " "
          out.print(type);
          out.print(source[141]); // 776:25 = " "
          out.print(getter);
          out.print(source[142]); // 776:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[143]); // 777:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[144]); // 783:2 = "  // "
          out.print(attr);
          out.print(source[145]); // 785:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[146]); // 798:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[147]); // 801:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[148]); // 803:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[149]); // 803:66 = "   */"
          }
          else {
            out.print(source[150]); // 808:2 = "  @Override"
          }
          out.print(source[151]); // 813:2 = "  "
          out.print(setterProtection);
          out.print(source[152]); // 814:22 = " void "
          out.print(setter);
          out.print(source[153]); // 814:38 = "("
          out.print(type);
          out.print(source[154]); // 814:47 = " "
          out.print(attr.getName());
          out.print(source[155]); // 814:66 = ") {    assertMutable();"
          if (isTracked())  {
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[156]); // 820:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[157]); // 821:31 = " != "
                out.print(attr.getName());
                out.print(source[158]); // 821:53 = ") {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[159]); // 822:60 = ", this."
                out.print(attr.getName());
                out.print(source[160]); // 822:85 = ", "
                out.print(attr.getName());
                out.print(source[161]); // 822:105 = ");    }"
              }
              else {
                out.print(source[162]); // 827:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[163]); // 828:47 = ", "
                out.print(attr.getName());
                out.print(source[164]); // 828:67 = ")) {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[165]); // 829:60 = ", this."
                out.print(attr.getName());
                out.print(source[166]); // 829:85 = ", "
                out.print(attr.getName());
                out.print(source[167]); // 829:105 = ");    }"
              }
            }
            else {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[168]); // 836:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[169]); // 837:31 = " != "
                out.print(attr.getName());
                out.print(source[170]); // 837:53 = ") {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[171]); // 841:2 = "      "
                  out.print(attr.getName());
                  out.print(source[172]); // 842:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[173]); // 843:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[174]); // 843:85 = ", "
                  out.print(attr.getName());
                  out.print(source[175]); // 843:105 = ");"
                }
                out.print(source[176]); // 846:2 = "    }"
              }
              else  {
                out.print(source[177]); // 851:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[178]); // 852:47 = ", "
                out.print(attr.getName());
                out.print(source[179]); // 852:67 = ")) {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[180]); // 856:2 = "      "
                  out.print(attr.getName());
                  out.print(source[181]); // 857:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[182]); // 858:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[183]); // 858:85 = ", "
                  out.print(attr.getName());
                  out.print(source[184]); // 858:105 = ");"
                }
                out.print(source[185]); // 861:2 = "    }"
              }
            }
          }
          out.print(source[186]); // 867:2 = "    this."
          out.print(attr.getName());
          out.print(source[187]); // 868:27 = " = "
          out.print(attr.getName());
          out.print(source[188]); // 868:48 = ";"
          if (type.equals("Timestamp")) {
            out.print(source[189]); // 871:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[190]); // 872:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[191]); // 872:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[192]); // 876:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[193]); // 877:39 = ");"
          }
          out.print(source[194]); // 880:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[195]); // 885:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[196]); // 888:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[197]); // 890:30 = " has been modified   */"
            }
            else {
              out.print(source[198]); // 895:2 = "  @Override"
            }
            out.print(source[199]); // 900:2 = "  "
            out.print(protection);
            out.print(source[200]); // 901:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[201]); // 901:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[202]); // 905:2 = "    return "
                out.print(attr.getName());
                out.print(source[203]); // 906:29 = " != "
                out.print(attr.getName());
                out.print(source[204]); // 906:51 = "Persisted;"
              }
              else {
                out.print(source[205]); // 910:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[206]); // 911:45 = ", "
                out.print(attr.getName());
                out.print(source[207]); // 911:65 = "Persisted);"
              }
            }
            else {
              out.print(source[208]); // 916:2 = "    return "
              out.print(attr.getName());
              out.print(source[209]); // 917:29 = "Modified;"
            }
            out.print(source[210]); // 920:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[211]); // 927:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[212]); // 930:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[213]); // 937:2 = "  @Override"
            }
            out.print(source[214]); // 942:2 = "  "
            out.print(protection);
            out.print(source[215]); // 943:16 = " "
            out.print(attr.getJavaType());
            out.print(source[216]); // 943:39 = " "
            out.print(getter);
            out.print(source[217]); // 943:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[218]); // 944:29 = "Persisted;  }"
          }
        }
      }
    }

    if (isPdo && generateSnapshot) {

      // createAttributesInSnapshot isnt necessary anymore since 2.2.x

      boolean needRevertAttributes = false;
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isSetGet() && !attr.getOptions().isShallow()) {
          needRevertAttributes = true;
          break;
        }
      }

      if (needRevertAttributes) {
        out.print(source[219]); // 965:2 = "  /**   * Copies all attributes from a..."
        out.print(mainClass);
        out.print(getEntity().isAbstract() ? "<T,?>" : "");
        out.print(source[220]); // 972:100 = " snapshot) {    super.revertAttributesT..."
        for (Attribute attr: getEntity().getAttributes()) {
          if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet() && !attr.getOptions().isShallow())    {
            String name = attr.getName();
            out.print(source[221]); // 978:2 = "    "
            out.print(name);
            out.print(source[222]); // 979:12 = " = snapshot."
            out.print(name);
            out.print(source[223]); // 979:32 = ";"
            if (isAttracked()) {
              if (isFullTracked()) {
                out.print(source[224]); // 983:2 = "    "
                out.print(name);
                out.print(source[225]); // 984:12 = "Persisted = snapshot."
                out.print(name);
                out.print(source[226]); // 984:41 = "Persisted;"
              }
              else {
                out.print(source[227]); // 988:2 = "    "
                out.print(name);
                out.print(source[228]); // 989:12 = "Modified = snapshot."
                out.print(name);
                out.print(source[229]); // 989:40 = "Modified;"
              }
            }
          }
        }
        out.print(source[230]); // 995:2 = "  }"
      }
    }

    if (generateSelectByUDK) {
      List<Attribute> udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        List<Attribute> superUdk = null;
        if (getEntity().getSuperEntity() != null) {
          superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
        }
        if (superUdk == null || !udk.equals(superUdk)) {
          Set<Entity> components = getEntity().getAllComponents();
          StringBuilder attribs = new StringBuilder();
          for (Attribute attribute: udk) {
            if (attribs.length() != 0) {
              attribs.append(" ");
            }
            if (components.contains(attribute.getEntity())) {
              attribs.append(attribute.getEntity()).append(".");
            }
            attribs.append(attribute.getName());
          }
          out.print(source[231]); // 1020:2 = "  // selects by unique domain key  // ..."
          out.print(attribs);
          out.print(source[232]); // 1023:66 = ""
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
