// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to declare the attributes of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Declare [--protected] [--annotations]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--protected:</em> makes the fields protected (default is private).</li>
 * <li><em>--annotations:</em> to generate annotations. Default is no generation as they will be generated for the methods.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class Declare extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    String[] args = getContainer().getArgs();   // cmd line args

    String protection = "private";
    boolean generateAnnotations = false;

    for (String arg: getOptionArgs())  {
      if (arg.equals("protected")) {
        protection = "protected";
      }
      else if (arg.equals("annotations")) {
        generateAnnotations = true;
      }
    }

    for (Attribute attr: getEntity().getAttributes()) {
      if (!attr.getOptions().isNoDeclare())    {
        out.print(source[0]); // 34:2 = "  /** "
        out.print(attr.getOptions().getComment());
        out.print(source[1]); // 36:40 = ". */"
        if (generateAnnotations) {
          for (String annotation: attr.getOptions().getAnnotations()) {
            out.print(source[2]); // 40:2 = "  "
            out.print(annotation);
            out.print(source[3]); // 41:16 = ""
          }
        }

        if (attr.getOptions().getInitialValue() != null) {
          out.print(source[4]); // 47:2 = "  "
          out.print(protection);
          out.print(source[5]); // 48:16 = " "
          out.print(attr.getJavaType());
          out.print(source[6]); // 48:39 = " "
          out.print(attr.getName());
          out.print(source[7]); // 48:58 = " = "
          out.print(attr.getOptions().getInitialValue());
          out.print(source[8]); // 48:100 = ";"

        }
        else {
          out.print(source[9]); // 53:2 = "  "
          out.print(protection);
          out.print(source[10]); // 54:16 = " "
          out.print(attr.getJavaType());
          out.print(source[11]); // 54:39 = " "
          out.print(attr.getName());
          out.print(source[12]); // 54:58 = ";"
        }
        if (isAttracked()) {
          if (isFullTracked()) {
            out.print(source[13]); // 59:2 = "  /** the last persisted value of "
            out.print(attr);
            out.print(source[14]); // 60:42 = ". */  "
            out.print(protection);
            out.print(source[15]); // 61:16 = " "
            out.print(attr.getJavaType());
            out.print(source[16]); // 61:39 = " "
            out.print(attr.getName());
            out.print(source[17]); // 61:58 = "Persisted;"
          }
          else {
            out.print(source[18]); // 65:2 = "  /** true if "
            out.print(attr);
            out.print(source[19]); // 66:22 = " has been modified. */  "
            out.print(protection);
            out.print(source[20]); // 67:16 = " boolean "
            out.print(attr.getName());
            out.print(source[21]); // 67:43 = "Modified;"
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
