// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for setting up a PdoCache for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoCache
 *     [--cache=&lt;classname&gt;] [--secure] [--public] [--preload]
 *     [--mutable] [--noreg] [--udk] [--bounded]
 *     [--strategy=LRU|LFU|FORGET] [--maxsize=&lt;n&gt;] [--keepquota=&lt;p&gt;] [--configure=&lt;method&gt;]
 *     [index1] [index2] ...
 * <p>
 * arguments:
 * <ul>
 * <li><em>--cache=&lt;classname&gt;:</em> sets the cache-class. Defaults to PdoCache.</li>
 * <li><em>--secure:</em> if cache must check read permission for each access (default is no check).</li>
 * <li><em>--public:</em> makes the cache and indexes public (default is private).</li>
 * <li><em>--preload:</em> the first access will load all entities at once.</li>
 * <li><em>--mutable:</em> generates a non-shared cache, i.e. mutable PDOs (by default a shared readonly cache is generated).</li>
 * <li><em>--noreg:</em> will not register the cache globally (default is to use the factory).</li>
 * <li><em>--udk:</em> add index for the unique domain key.</li>
 * <li><em>--bounded:</em> creates List&lt;? extends T&gt; for selectAllCached instead of List&lt;T&gt;.</li>
 * <li><em>--strategy=LRU|LFU|FORGET:</em> the caching strategy (default is FORGET).</li>
 * <li><em>--maxsize=&lt;n&gt;:</em> the cache size (if not preloaded).</li>
 * <li><em>--keepquota=&lt;p&gt;:</em> percentage of entries to keep when applying caching strategy. Default is 50.</li>
 * <li><em>--configure=&lt;method&gt;:</em> an optional method to further configure the cache.</li>
 * <li><em>--index&lt;n&gt;:</em> additional unique indexes. By default, only the ID-index will be created.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoCache extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {

    // main class
    String pdoName     = getPdoClassName();

    boolean secure     = false;
    boolean preload    = false;
    boolean mutable    = false;
    boolean delayed    = true;
    boolean noreg      = false;
    boolean genudk     = false;
    boolean bounded    = false;

    String cache       = "PdoCache";
    String scope       = "private";

    String strategy    = null;
    Integer maxSize    = null;
    Integer keepQuota  = null;
    String configure   = null;

    for (String arg: getOptionArgs())  {
      if (arg.equals("preload")) {
        preload = true;
      }
      else if (arg.equals("secure")) {
        secure = true;
      }
      else if (arg.equals("mutable")) {
        mutable = true;
      }
      else if (arg.equals("immediate")) {
        delayed = false;
      }
      else if (arg.equals("public")) {
        scope = "public";
      }
      else if (arg.equals("noreg")) {
        noreg = true;
      }
      else if (arg.equals("bounded")) {
        bounded = true;
      }
      else if (arg.equals("udk")) {
        genudk = true;
      }
      else if (arg.startsWith("cache=")) {
        cache = arg.substring(6);
      }
      else if (arg.startsWith("strategy=")) {
        strategy = arg.substring(9).toUpperCase();
      }
      else if (arg.startsWith("maxsize=")) {
        maxSize = Integer.valueOf(arg.substring(8));
      }
      else if (arg.startsWith("keepquota=")) {
        keepQuota = Integer.valueOf(arg.substring(10));
      }
      else if (arg.startsWith("configure=")) {
        configure = arg.substring(10);
      }
    }

    if (secure && !getEntity().isRootEntity()) {
      throw new WurbelException(getEntity() + " is not a root-entity");
    }

    // align args
    if (!cache.equals("PdoCache"))  {
      noreg = true;
    }

    List<Attribute> udk = null;
    String udkType = null;
    String udkName = null;
    String udkSuffix = null;
    if (genudk) {
      udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        if (udk.size() == 1) {
          udkType = udk.get(0).getJavaType();
          udkName = udk.get(0).getName();
          udkSuffix = udk.get(0).getMethodNameSuffix();
        }
        else {
          udkType = getEntity().getName() + "UDK";
          udkName = "udk";
          udkSuffix = "UniqueDomainKey";
          udkType = getEntity().getName() + "." + udkType;
        }
      }
      else {
        udk = null;
        genudk = false;
      }
    }


    if (getEntity().isAbstract()) {
      List<Entity> leafs = getEntity().getLeafEntities();
      out.print(source[0]); // 131:2 = "  @Override  @SuppressWarnings("unchec..."
      boolean first = true;
      for (Entity leaf: leafs) {
        if (first)  {
          out.print(source[1]); // 140:2 = "    T pdo = (T) Pdo.create("
          out.print(leaf);
          out.print(source[2]); // 141:35 = ".class, getDomainContext()).selectCached..."
          first = false;
        }
        else {
          out.print(source[3]); // 146:2 = "    if (pdo == null) {      pdo = (T) P..."
          out.print(leaf);
          out.print(source[4]); // 148:35 = ".class, getDomainContext()).selectCached..."
        }
      }
      out.print(source[5]); // 153:2 = "    return pdo;  }  @Override  @Supp..."
      first = true;
      for (Entity leaf: leafs) {
        if (first)  {
          out.print(source[6]); // 164:2 = "    T pdo = (T) Pdo.create("
          out.print(leaf);
          out.print(source[7]); // 165:35 = ".class, getDomainContext()).selectCached..."
          first = false;
        }
        else {
          out.print(source[8]); // 170:2 = "    if (pdo == null) {      pdo = (T) P..."
          out.print(leaf);
          out.print(source[9]); // 172:35 = ".class, getDomainContext()).selectCached..."
        }
      }
      out.print(source[10]); // 177:2 = "    return pdo;  }"

      if (preload) {
        out.print(source[11]); // 183:2 = "  @Override  @SuppressWarnings("unchec..."
        for (Entity leaf: leafs) {
          out.print(source[12]); // 191:2 = "    pdos.addAll((Collection<? extends T>..."
          out.print(leaf);
          out.print(source[13]); // 192:61 = ".class, getDomainContext()).selectAllCac..."
        }
        out.print(source[14]); // 195:2 = "    return pdos;  }"
      }

      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        out.print(source[15]); // 205:2 = "  @Override  @SuppressWarnings("unchec..."
        out.print(suffix);
        out.print(source[16]); // 209:35 = "("
        out.print(type);
        out.print(source[17]); // 209:44 = " "
        out.print(name);
        out.print(source[18]); // 209:53 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[19]); // 214:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[20]); // 215:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[21]); // 215:87 = "("
            out.print(name);
            out.print(source[22]); // 215:96 = ");"
            first = false;
          }
          else {
            out.print(source[23]); // 220:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[24]); // 222:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[25]); // 222:87 = "("
            out.print(name);
            out.print(source[26]); // 222:96 = ");    }"
          }
        }
        out.print(source[27]); // 227:2 = "    return pdo;  }  @Override  @Supp..."
        out.print(suffix);
        out.print(source[28]); // 233:39 = "("
        out.print(type);
        out.print(source[29]); // 233:48 = " "
        out.print(key.getName());
        out.print(source[30]); // 233:66 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[31]); // 238:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[32]); // 239:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[33]); // 239:91 = "("
            out.print(key.getName());
            out.print(source[34]); // 239:109 = ");"
            first = false;
          }
          else {
            out.print(source[35]); // 244:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[36]); // 246:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[37]); // 246:91 = "("
            out.print(key.getName());
            out.print(source[38]); // 246:109 = ");    }"
          }
        }
        out.print(source[39]); // 251:2 = "    return pdo;  }"
      }

      if (genudk) {
        out.print(source[40]); // 258:2 = "  @Override  @SuppressWarnings("unchec..."
        out.print(udkType);
        out.print(source[41]); // 262:52 = " "
        out.print(udkName);
        out.print(source[42]); // 262:64 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[43]); // 267:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[44]); // 268:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[45]); // 268:104 = ");"
            first = false;
          }
          else {
            out.print(source[46]); // 273:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[47]); // 275:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[48]); // 275:104 = ");    }"
          }
        }
        out.print(source[49]); // 280:2 = "    return pdo;  }  @Override  @Supp..."
        out.print(udkType);
        out.print(source[50]); // 286:56 = " "
        out.print(udkName);
        out.print(source[51]); // 286:68 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[52]); // 291:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[53]); // 292:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[54]); // 292:108 = ");"
            first = false;
          }
          else {
            out.print(source[55]); // 297:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[56]); // 299:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[57]); // 299:108 = ");    }"
          }
        }
        out.print(source[58]); // 304:2 = "    return pdo;  }"
      }
    }
    else  {
      out.print(source[59]); // 311:2 = "  /** the cache. */  "
      out.print(scope);
      out.print(source[60]); // 314:11 = " static "
      out.print(cache);
      out.print(source[61]); // 314:28 = "<"
      out.print(pdoName);
      out.print(source[62]); // 314:40 = "> cache;"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        out.print(source[63]); // 319:2 = "  /** index for "
        out.print(name);
        out.print(source[64]); // 321:24 = ". */  "
        out.print(scope);
        out.print(source[65]); // 322:11 = " static PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[66]); // 322:44 = ", "
        out.print(type);
        out.print(source[67]); // 322:54 = "> "
        out.print(name);
        out.print(source[68]); // 322:64 = "Index;"
      }

      if (genudk) {
        out.print(source[69]); // 327:2 = "  /** index for the unique domain key. ..."
        out.print(scope);
        out.print(source[70]); // 330:11 = " static PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[71]); // 330:44 = ", "
        out.print(udkType);
        out.print(source[72]); // 330:57 = "> udkIndex;"
      }
      out.print(source[73]); // 333:2 = "  /**   * Creates the cache singleton ..."
      out.print(cache);
      out.print(source[74]); // 340:39 = "<"
      out.print(pdoName);
      out.print(source[75]); // 340:51 = "> createCache() {    if (cache == null)..."
      if (noreg) {
        out.print(source[76]); // 344:2 = "      cache = new "
        out.print(cache);
        out.print(source[77]); // 345:27 = "<"
        out.print(pdoName);
        out.print(source[78]); // 345:39 = "> ("
        out.print(pdoName);
        out.print(source[79]); // 345:53 = ".class, "
        out.print(preload ? "true" : "false");
        out.print(source[80]); // 345:91 = ", "
        out.print(mutable ? "false" : "true");
        out.print(source[81]); // 345:123 = ", "
        out.print(secure ? "true" : "false");
        out.print(source[82]); // 345:154 = ");"
      }
      else {
        out.print(source[83]); // 349:2 = "      cache = Pdo.createPdoCache("
        out.print(pdoName);
        out.print(source[84]); // 350:44 = ".class, "
        out.print(preload ? "true" : "false");
        out.print(source[85]); // 350:82 = ", "
        out.print(mutable ? "false" : "true");
        out.print(source[86]); // 350:114 = ", "
        out.print(secure ? "true" : "false");
        out.print(source[87]); // 350:145 = ");"
      }

      if (strategy != null) {
        out.print(source[88]); // 355:2 = "      cache.setStrategy(PdoCacheStrategy..."
        out.print(strategy);
        out.print(source[89]); // 356:53 = ");"
      }

      if (maxSize != null) {
        out.print(source[90]); // 361:2 = "      cache.setMaxSize("
        out.print(maxSize);
        out.print(source[91]); // 362:34 = ");"
      }

      if (keepQuota != null) {
        out.print(source[92]); // 367:2 = "      cache.setKeepQuota("
        out.print(keepQuota);
        out.print(source[93]); // 368:38 = ");"
      }

      if (configure != null) {
        out.print(source[94]); // 373:2 = "      "
        out.print(configure);
        out.print(source[95]); // 374:19 = "(cache);"
      }

      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (isRemote()) {
          suffix += "ForCache";
        }
        out.print(source[96]); // 385:2 = "      "
        out.print(name);
        out.print(source[97]); // 387:14 = "Index = new PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[98]); // 387:51 = ", "
        out.print(type);
        out.print(source[99]); // 387:61 = ">(""
        out.print(pdoName);
        out.print(source[100]); // 387:75 = ":"
        out.print(name);
        out.print(source[101]); // 387:84 = "") {          @Override          publ..."
        out.print(pdoName);
        out.print(source[102]); // 390:28 = " select(DomainContext context, "
        out.print(type);
        out.print(source[103]); // 390:67 = " "
        out.print(name);
        out.print(source[104]); // 390:76 = ") {            return Pdo.create("
        out.print(pdoName);
        out.print(source[105]); // 391:41 = ".class, context).selectBy"
        out.print(suffix);
        out.print(source[106]); // 391:76 = "("
        out.print(name);
        out.print(source[107]); // 391:85 = ");          }          @Override    ..."
        out.print(type);
        out.print(source[108]); // 395:25 = " extract("
        out.print(pdoName);
        out.print(source[109]); // 395:45 = " pdo) {            return pdo.get"
        out.print(suffix);
        out.print(source[110]); // 396:36 = "();          }        };"
      }

      if (genudk) {
        out.print(source[111]); // 403:2 = "      udkIndex = new PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[112]); // 405:46 = ", "
        out.print(udkType);
        out.print(source[113]); // 405:59 = ">(""
        out.print(pdoName);
        out.print(source[114]); // 405:73 = ":UDK") {          @Override          ..."
        out.print(pdoName);
        out.print(source[115]); // 408:28 = " select(DomainContext context, "
        out.print(udkType);
        out.print(source[116]); // 408:70 = " "
        out.print(udkName);
        out.print(source[117]); // 408:82 = ") {"
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplStream();
          PrintStream remoteOut = genInc.getRemoteStream();
          remoteOut.print(source[118]); // 415:16 = "  "
          remoteOut.print(pdoName);
          remoteOut.print(source[119]); // 416:13 = " selectByUniqueDomainKeyForCache(DomainC..."
          remoteOut.print(udkType);
          remoteOut.print(source[120]); // 416:80 = " "
          remoteOut.print(udkName);
          remoteOut.print(source[121]); // 416:92 = ") throws RemoteException;"
          implOut.print(source[122]); // 417:14 = "  @Override  public "
          implOut.print(pdoName);
          implOut.print(source[123]); // 420:20 = " selectByUniqueDomainKeyForCache(DomainC..."
          implOut.print(udkType);
          implOut.print(source[124]); // 420:87 = " "
          implOut.print(udkName);
          implOut.print(source[125]); // 420:99 = ") throws RemoteException {    try {   ..."
          implOut.print(udkName);
          implOut.print(source[126]); // 422:75 = ");    }    catch (Exception e) {     ..."
          out.print(source[127]); // 428:6 = "            return Pdo.create("
          out.print(pdoName);
          out.print(source[128]); // 429:41 = ".class, context).findByUniqueDomainKeyFo..."
          out.print(udkName);
          out.print(source[129]); // 429:99 = ");"
        }
        else {
          out.print(source[130]); // 433:2 = "            return Pdo.create("
          out.print(pdoName);
          out.print(source[131]); // 434:41 = ".class, context).findByUniqueDomainKey("
          out.print(udkName);
          out.print(source[132]); // 434:91 = ");"
        }
        out.print(source[133]); // 437:2 = "          }          @Override       ..."
        out.print(udkType);
        out.print(source[134]); // 441:28 = " extract("
        out.print(pdoName);
        out.print(source[135]); // 441:48 = " pdo) {            return pdo.get"
        out.print(udkSuffix);
        out.print(source[136]); // 442:39 = "();          }        };"
      }

      out.print(source[137]); // 448:2 = "      ModificationTracker.getInstance()..."
      out.print(pdoName);
      out.print(source[138]); // 450:91 = ".class) {        @Override        pub..."
      if (delayed)  {
        out.print(source[139]); // 456:2 = "          cache.expire(ev.getSerial()); ..."
      }
      else {
        out.print(source[140]); // 461:2 = "          cache.expire(ev.getSession(), ..."
      }
      out.print(source[141]); // 465:2 = "        }      });    }    return cac..."
      out.print(bounded ? "? extends " : "");
      out.print(pdoName);
      out.print(source[142]); // 473:60 = "> getCache() {    return cache == null ..."
      out.print(pdoName);
      out.print(source[143]); // 494:20 = " selectCachedOnly(long id) {    return ..."
      out.print(pdoName);
      out.print(source[144]); // 499:20 = " selectCached(long id) {    return getC..."
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        out.print(source[145]); // 507:2 = "  /**   * Selects from cache by "
        out.print(name);
        out.print(source[146]); // 510:35 = " but does not load from db if not in cac..."
        out.print(name);
        out.print(source[147]); // 512:21 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[148]); // 516:20 = " selectCachedOnlyBy"
        out.print(suffix);
        out.print(source[149]); // 516:49 = "("
        out.print(type);
        out.print(source[150]); // 516:58 = " "
        out.print(name);
        out.print(source[151]); // 516:67 = ")  {    return getCache().select("
        out.print(name);
        out.print(source[152]); // 517:37 = "Index, getDomainContext(), "
        out.print(name);
        out.print(source[153]); // 517:72 = ", false);  }  /**   * Selects via ca..."
        out.print(name);
        out.print(source[154]); // 521:34 = ".   *   * @param "
        out.print(name);
        out.print(source[155]); // 523:21 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[156]); // 527:20 = " selectCachedBy"
        out.print(suffix);
        out.print(source[157]); // 527:45 = "("
        out.print(type);
        out.print(source[158]); // 527:54 = " "
        out.print(name);
        out.print(source[159]); // 527:63 = ")  {    return getCache().select("
        out.print(name);
        out.print(source[160]); // 528:37 = "Index, getDomainContext(), "
        out.print(name);
        out.print(source[161]); // 528:72 = ");  }"
      }

      if (genudk) {
        out.print(source[162]); // 534:2 = "  /**   * Selects from cache by unique..."
        out.print(udkName);
        out.print(source[163]); // 539:24 = " the unique domain key   * @return the ..."
        out.print(pdoName);
        out.print(source[164]); // 543:20 = " selectCachedOnlyByUniqueDomainKey("
        out.print(udkType);
        out.print(source[165]); // 543:66 = " "
        out.print(udkName);
        out.print(source[166]); // 543:78 = ")  {    return getCache().select(udkInd..."
        out.print(udkName);
        out.print(source[167]); // 544:70 = ", false);  }  /**   * Selects via ca..."
        out.print(udkName);
        out.print(source[168]); // 550:24 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[169]); // 554:20 = " selectCachedByUniqueDomainKey("
        out.print(udkType);
        out.print(source[170]); // 554:62 = " "
        out.print(udkName);
        out.print(source[171]); // 554:74 = ")  {    return getCache().select(udkInd..."
        out.print(udkName);
        out.print(source[172]); // 555:70 = ");  }  /**   * Selects via remote ca..."
        out.print(udkName);
        out.print(source[173]); // 561:24 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[174]); // 565:20 = " findByUniqueDomainKeyForCache("
        out.print(udkType);
        out.print(source[175]); // 565:62 = " "
        out.print(udkName);
        out.print(source[176]); // 565:74 = ") {    "
        out.print(pdoName);
        out.print(source[177]); // 566:15 = " obj;    if (getSession().isRemote()) {..."
        out.print(udkName);
        out.print(source[178]); // 570:86 = ");        configureRemoteObject(context..."
        out.print(udkName);
        out.print(source[179]); // 578:50 = ");    }    return obj;  }"
      }

      if (preload)  {
        out.print(source[180]); // 586:2 = "  @Override  public List<"
        out.print(bounded ? "? extends " : "");
        out.print(pdoName);
        out.print(source[181]); // 589:56 = "> selectAllCached() {    return getCach..."
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
