// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk&gt;:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    boolean isPdo;
    try {
      pdoClass = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
    }

    if (isRemote() && isPdo) {
      new RemoteIncludes(this);   // create RMI-files if they don't exist yet
      String delegateType = pdoClass + "RemoteDelegate";
      if (getEntity().isAbstract()) {
        delegateType += "<T,P>";
      }
      out.print(source[0]); // 50:2 = "  @Override  public "
      out.print(delegateType);
      out.print(source[1]); // 53:25 = " getRemoteDelegate() {    return ("
      out.print(delegateType);
      out.print(source[2]); // 54:28 = ") super.getRemoteDelegate();  }"
    }

    if (getEntity().isAbstract()) {
      if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
        out.print(source[3]); // 61:2 = "  @Override  public boolean isExplicit..."
      }
    }
    else {
      if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[4]); // 72:2 = "  @Override  public boolean isClassIdR..."
      }
    }

    boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

    if (getEntity().getSuperEntity() == null) {

      if (getEntity().getOptions().isRoot()) {
        out.print(source[5]); // 87:2 = "  @Override  public boolean isRootEnti..."
      }

      if (getEntity().getOptions().isTableSerialProvided()) {
        out.print(source[6]); // 97:2 = "  @Override  public boolean isTableSer..."
      }

      if (getEntity().getOptions().isTokenLockProvided()) {
        out.print(source[7]); // 107:2 = "  @Override  public boolean isTokenLoc..."
      }

      if (getEntity().getOptions().isNormTextProvided()) {
        out.print(source[8]); // 117:2 = "  @Override  public boolean isNormText..."
      }

      if (getEntity().getOptions().isRootIdProvided()) {
        out.print(source[9]); // 127:2 = "  @Override  public boolean isRootIdPr..."
      }
      else {
        Attribute rootAttribute = getEntity().getRootAttribute();
        if (rootAttribute != null) {

          out.print(source[10]); // 139:2 = "  @Override  public long getRootId() {..."
          out.print(rootAttribute.getName());
          out.print(source[11]); // 143:38 = ";  }"
        }
      }

      if (getEntity().getOptions().isRootClassIdProvided()) {
        out.print(source[12]); // 150:2 = "  @Override  public boolean isRootClas..."
      }
      else {
        Entity rootEntity = getEntity().getRootEntity();
        if (rootEntity != null) {
          out.print(source[13]); // 161:2 = "  @Override  public int getRootClassId..."
          out.print(rootEntity.getClassId());
          out.print(source[14]); // 165:38 = ";  }"
        }
      }

      if (isTracked())  {
        out.print(source[15]); // 172:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[16]); // 183:2 = "  @Override  public void setModified(b..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod())    {
          if (isFullTracked()) {
            out.print(source[17]); // 193:2 = "      "
            out.print(attr.getName());
            out.print(source[18]); // 194:24 = "Persisted = "
            out.print(attr.getName());
            out.print(source[19]); // 194:54 = ";"
          }
          else {
            out.print(source[20]); // 198:2 = "      "
            out.print(attr.getName());
            out.print(source[21]); // 199:24 = "Modified = false;"
          }
        }
      }
      out.print(source[22]); // 204:2 = "    }  }"
    }


    if (isFullTracked()) {
      out.print(source[23]); // 212:2 = "  @Override  public boolean differsPer..."
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isNoMethod() && !attr.getOptions().isDerived() &&
            !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
          if (attr.getDataType().isPrimitive()) {
            out.print(source[24]); // 222:2 = "           || "
            out.print(attr.getName());
            out.print(source[25]); // 223:32 = "Persisted != "
            out.print(attr.getName());
            out.print(source[26]); // 223:63 = ""
          }
          else {
            out.print(source[27]); // 227:2 = "           || !Objects.equals("
            out.print(attr.getName());
            out.print(source[28]); // 228:48 = "Persisted, "
            out.print(attr.getName());
            out.print(source[29]); // 228:77 = ")"
          }
        }
      }
      out.print(source[30]); // 233:2 = "           ;  }  @Override  public b..."
    }

    if (!getEntity().getInheritanceType().isMappingToNoTable()) {
      String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
      if (orderBy != null) {
        out.print(source[31]); // 247:2 = "  @Override  public String orderBy() {..."
        out.print(orderBy);
        out.print(source[32]); // 252:18 = ";    return sql.toString();  }"
      }
      out.print(source[33]); // 257:2 = "  @Override  public void getFields(Res..."
      boolean needIfClause = false;
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            needIfClause = true;
            break;
          }
        }
      }
      if (needIfClause) {
        out.print(source[34]); // 273:2 = "    if (rs.configureSection(CLASSVARIABL..."
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isDerived())  {
            for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
              String name = attr.getName().toUpperCase() + sp.getPostfix();
              out.print(source[35]); // 280:2 = "      rs.configureColumn(CN_"
              out.print(name);
              out.print(source[36]); // 281:36 = ");"
            }
          }
        }
        out.print(source[37]); // 286:2 = "    }"
      }
      else {
        out.print(source[38]); // 291:2 = "    rs.configureSection(CLASSVARIABLES);..."
      }
      out.print(source[39]); // 295:2 = "    if (rs.getRow() <= 0) {      throw ..."
      for (Attribute attr: getEntity().getMappedAttributes())  {
        if (!attr.getOptions().isDerived())  {
          String getterMethod = createJdbcGetterName(attr);
          String name = attr.getName().toUpperCase();
          boolean useSetter = isSetGetRequired(attr);

          if (attr.getDataType() == DataType.BINARY) {
            // Binary getter takes additional buffer size argument
            if (useSetter)  {
              out.print(source[40]); // 309:2 = "    "
              out.print(attr.getSetterName());
              out.print(source[41]); // 310:28 = "(rs."
              out.print(getterMethod);
              out.print(source[42]); // 310:48 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[43]); // 310:78 = "));"
            }
            else  {
              out.print(source[44]); // 314:2 = "    "
              out.print(attr.getName());
              out.print(source[45]); // 315:22 = " = rs."
              out.print(getterMethod);
              out.print(source[46]); // 315:44 = "("
              out.print(attr.getSizeWithDefault());
              out.print(source[47]); // 315:74 = ");"
            }
          }

          else  {
            String rsGetter = "rs." + getterMethod + "(";
            boolean needComma = false;
            if (attr.getOptions().isWithTimezone()) {
              rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
              needComma = true;
            }
            if (attr.getOptions().isMapNull()) {
              if (needComma) {
                rsGetter += ", ";
              }
              rsGetter += "true";
              needComma = true;
            }
            rsGetter += ")";

            String modelCode = getModelCode(attr, rsGetter);

            if (attr.getOptions().isTrimRead()) {
              modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSizeWithDefault() + ")";
            }

            if (useSetter) {
              modelCode = attr.getSetterName() + "(" + modelCode + ")";
            }
            else  {
              modelCode = attr.getName() + " = " + modelCode;
            }
            out.print(source[48]); // 348:2 = "    "
            out.print(modelCode);
            out.print(source[49]); // 349:17 = ";"
            if (attr.getOptions().isUTC()) {
              if (useSetter) {
                modelCode = attr.getGetterName() + "()";
              }
              else  {
                modelCode = attr.getName();
              }
              out.print(source[50]); // 358:2 = "    if ("
              out.print(modelCode);
              out.print(source[51]); // 359:21 = " != null) {      "
              out.print(modelCode);
              out.print(source[52]); // 360:19 = ".setUTC(true);    }"
            }
          }
        }
      }
      out.print(source[53]); // 367:2 = "  }"
      if (multiInheritance) {
        out.print(source[54]); // 371:2 = "  /**   * Sets the values of all "
        out.print(pdoClass);
        out.print(source[55]); // 374:40 = "-columns in the given statement.   *  ..."
        out.print(pdoClass);
        out.print(source[56]); // 379:34 = "(PreparedStatementWrapper st) {    int ..."
      }
      else  {
        out.print(source[57]); // 384:2 = "  @Override  public int setFields(Prep..."
      }

      for (Attribute attr: getEntity().getMappedAttributes()) {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly())  {
          String setterName = createJdbcSetterName(attr);

          String modelCode;
          if (isSetGetRequired(attr)) {
            modelCode = attr.getGetterName() + "()";
          }
          else {
            modelCode = attr.getName();
          }

          String jdbcCode = getJdbcCode(attr, modelCode);

          if (attr.getOptions().isTrimWrite()) {
            jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSizeWithDefault() + ")";
          }

          jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
          if (attr.getOptions().isWithTimezone()) {
            jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
          }
          if (attr.getOptions().isMapNull()) {
            jdbcCode += ", true)";
          }
          else  {
            jdbcCode += ")";
          }
          out.print(source[58]); // 420:2 = "    "
          out.print(jdbcCode);
          out.print(source[59]); // 421:16 = ";"

          // for multi column types, such as BMoney/DMoney
          for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
            out.print(source[60]); // 426:2 = "    ++ndx;"
          }
        }
      }

      if (multiInheritance && getEntity().getSuperEntity() != null) {
        out.print(source[61]); // 434:2 = "    st.setLong(++ndx, getId());"
      }
      out.print(source[62]); // 438:2 = "    return ndx;  }"
    }

    if (getEntity().getInheritanceType().isMappingToOwnTable()) {

      List<String> names = new ArrayList<>();
      List<Attribute> attributes = multiInheritance ?
                                      getEntity().getTableAttributes() : getEntity().getAttributesIncludingInherited();
      for (Attribute attr: attributes)  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly()) {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            String name = attr.getName().toUpperCase() + sp.getPostfix();
            names.add(name);
          }
        }
      }

      if (multiInheritance) {
        out.print(source[63]); // 459:2 = "  /**   * Creates the SQL code for the..."
        out.print(pdoClass);
        out.print(source[64]); // 462:46 = " insert statement.   *   * @return the..."
        out.print(pdoClass);
        out.print(source[65]); // 466:43 = "() {"
      }
      else  {
        out.print(source[66]); // 470:2 = "  @Override  public String createInser..."
      }
      out.print(source[67]); // 476:2 = "    return Backend.SQL_INSERT_INTO + "
      out.print(multiInheritance ? "CLASSVARIABLES." : "");
      out.print(source[68]); // 477:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."

      int count = 0;
      for (String name: names) {
        String lineSep = count == names.size() - 1 ? " +" : " + Backend.SQL_COMMA +";
        out.print(source[69]); // 483:2 = "           CN_"
        out.print(name);
        out.print(lineSep);
        out.print(source[70]); // 484:33 = ""
        count++;
      }
      out.print(source[71]); // 488:2 = "           Backend.SQL_INSERT_VALUES +"
      while (--count > 0)	{
        out.print(source[72]); // 492:2 = "           Backend.SQL_PAR_COMMA +"
      }
      out.print(source[73]); // 496:2 = "           Backend.SQL_PAR + Backend.SQL..."

      names.clear();
      for (Attribute attr: attributes)  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            String name = attr.getName().toUpperCase() + sp.getPostfix();
            names.add(name);
          }
        }
      }

      if (multiInheritance) {
        out.print(source[74]); // 512:2 = "  /**   * Creates the SQL code for the..."
        out.print(pdoClass);
        out.print(source[75]); // 515:46 = " update statement.   *   * @return the..."
        out.print(pdoClass);
        out.print(source[76]); // 519:43 = "() {"
      }
      else  {
        out.print(source[77]); // 523:2 = "  @Override  public String createUpdat..."
      }
      out.print(source[78]); // 529:2 = "    return Backend.SQL_UPDATE + "
      out.print(multiInheritance ? "CLASSVARIABLES." : "");
      out.print(source[79]); // 530:77 = "getTableName() + Backend.SQL_SET +"
      boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
      int ncnt = 0;
      for (String name: names) {
        ncnt++;
        if (!checkSerial && ncnt == names.size()) {
          out.print(source[80]); // 537:2 = "           CN_"
          out.print(name);
          out.print(source[81]); // 538:22 = " + Backend.SQL_EQUAL_PAR +"
        }
        else {
          out.print(source[82]); // 542:2 = "           CN_"
          out.print(name);
          out.print(source[83]); // 543:22 = " + Backend.SQL_EQUAL_PAR_COMMA +"
        }
      }

      if (ncnt == 0 && !checkSerial) {
        // special case: no attributes and no checkserial
        out.print(source[84]); // 550:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
      }

      if (checkSerial) {
        out.print(source[85]); // 556:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
      }
      else  {
        out.print(source[86]); // 563:2 = "           Backend.SQL_WHERE + CN_ID + B..."
      }
      out.print(source[87]); // 567:2 = "  }"
    }

    if (multiInheritance) {
      // create joinable sql selects with table aliases
      Entity topEntity = getEntity().getTopSuperEntity();
      List<Entity> chain = topEntity.getInheritanceChain(getEntity());
      List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
      String topImplClass = deriveClassNameForEntity(topEntity);
      out.print(source[88]); // 578:2 = "  /**   * Creates the SQL code for the..."
      out.print(pdoClass);
      out.print(source[89]); // 581:46 = " delete statement.   *   * @return the..."
      out.print(pdoClass);
      out.print(source[90]); // 585:43 = "() {"
      if (getEntity().isRootOfInheritanceHierarchy()) {
        out.print(source[91]); // 588:2 = "    return Backend.SQL_DELETE + Backend...."
      }
      else  {
        out.print(source[92]); // 595:2 = "    return Backend.SQL_DELETE + Backend...."
      }
      out.print(source[93]); // 600:2 = "  }  @Override  public StringBuilder ..."
      boolean needComma = false;
      for (Entity entity: chain) {
        String implClass = deriveClassNameForEntity(entity);
        out.print(source[94]); // 610:2 = "    sql."
        out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
        out.print(source[95]); // 611:57 = "append("
        out.print(implClass);
        out.print(source[96]); // 611:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
        needComma = true;
        if (entity == topEntity) {
          for (Entity sub: subs) {
            implClass = deriveClassNameForEntity(sub);
            out.print(source[97]); // 617:2 = "    sql.append(Backend.SQL_COMMA).append..."
            out.print(implClass);
            out.print(source[98]); // 618:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
          }
        }
      }
      out.print(source[99]); // 623:2 = "    sql.append(Backend.SQL_FROM);    sq..."
      out.print(topImplClass);
      out.print(source[100]); // 625:31 = ".CLASSVARIABLES.getTableName()).       ..."
      out.print(topImplClass);
      out.print(source[101]); // 626:76 = ".CLASSVARIABLES.getTableAlias());"
      if (chain.size() > 1) {
        for (Entity entity: chain.subList(1, chain.size())) {
          String implClass = deriveClassNameForEntity(entity);
          out.print(source[102]); // 631:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[103]); // 633:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[104]); // 633:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[105]); // 634:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[106]); // 635:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
      }

      for (Entity sub: subs) {
        String implClass = deriveClassNameForEntity(sub);
        out.print(source[107]); // 642:2 = "    sql.append(getBackend().sqlJoin(Join..."
        out.print(implClass);
        out.print(source[108]); // 644:28 = ".CLASSVARIABLES.getTableName(), "
        out.print(implClass);
        out.print(source[109]); // 644:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
        out.print(topImplClass);
        out.print(source[110]); // 645:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
        out.print(implClass);
        out.print(source[111]); // 646:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
      }
      out.print(source[112]); // 649:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
      String implClass = deriveClassNameForEntity(topEntity);
      out.print(source[113]); // 655:2 = "  @Override  public StringBuilder crea..."
      out.print(implClass);
      out.print(source[114]); // 661:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

      if (getEntity().isRootOfInheritanceHierarchy()) {
        out.print(source[115]); // 668:2 = "  @Override  protected void updateImpl..."
        out.print(pdoClass);
        out.print(source[116]); // 672:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[117]); // 673:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[118]); // 679:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[119]); // 680:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(pdoClass);
        out.print(source[120]); // 686:122 = ");    st.setLong(1, getId());    st.se..."
      }
      else  {
        out.print(source[121]); // 694:2 = "  @Override  protected void updateImpl..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[122]); // 697:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[123]); // 700:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[124]); // 701:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[125]); // 706:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[126]); // 709:122 = ");    setFields"
        out.print(pdoClass);
        out.print(source[127]); // 710:25 = "(st);    assertThisRowAffected(st.execu..."
        out.print(getEntity().isAbstract()?"P":mainClass);
        out.print(source[128]); // 715:93 = "> classVariables,                      ..."
        out.print(pdoClass);
        out.print(source[129]); // 717:122 = ");    st.setLong(1, getId());    asser..."
      }
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet()) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[130]); // 732:2 = "  /**   * no accessor methods for "
          out.print(attr);
          out.print(source[131]); // 735:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[132]); // 736:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[133]); // 748:2 = "  // "
          out.print(attr);
          out.print(source[134]); // 750:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.getOptions().isHidden()) {
            out.print(source[135]); // 755:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[136]); // 758:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[137]); // 760:48 = "   */"
          }
          else {
            out.print(source[138]); // 765:2 = "  @Override"
          }
          out.print(source[139]); // 770:2 = "  "
          out.print(protection);
          out.print(source[140]); // 771:16 = " "
          out.print(type);
          out.print(source[141]); // 771:25 = " "
          out.print(getter);
          out.print(source[142]); // 771:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[143]); // 772:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[144]); // 778:2 = "  // "
          out.print(attr);
          out.print(source[145]); // 780:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.getOptions().isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[146]); // 793:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[147]); // 796:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[148]); // 798:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[149]); // 798:66 = "   */"
          }
          else {
            out.print(source[150]); // 803:2 = "  @Override"
          }
          out.print(source[151]); // 808:2 = "  "
          out.print(setterProtection);
          out.print(source[152]); // 809:22 = " void "
          out.print(setter);
          out.print(source[153]); // 809:38 = "("
          out.print(type);
          out.print(source[154]); // 809:47 = " "
          out.print(attr.getName());
          out.print(source[155]); // 809:66 = ") {    assertMutable();"
          if (isTracked())  {
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[156]); // 815:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[157]); // 816:31 = " != "
                out.print(attr.getName());
                out.print(source[158]); // 816:53 = ") {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[159]); // 817:60 = ", this."
                out.print(attr.getName());
                out.print(source[160]); // 817:85 = ", "
                out.print(attr.getName());
                out.print(source[161]); // 817:105 = ");    }"
              }
              else {
                out.print(source[162]); // 822:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[163]); // 823:47 = ", "
                out.print(attr.getName());
                out.print(source[164]); // 823:67 = ")) {      firePropertyChange(AN_"
                out.print(attr.getName().toUpperCase());
                out.print(source[165]); // 824:60 = ", this."
                out.print(attr.getName());
                out.print(source[166]); // 824:85 = ", "
                out.print(attr.getName());
                out.print(source[167]); // 824:105 = ");    }"
              }
            }
            else {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[168]); // 831:2 = "    if (this."
                out.print(attr.getName());
                out.print(source[169]); // 832:31 = " != "
                out.print(attr.getName());
                out.print(source[170]); // 832:53 = ") {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[171]); // 836:2 = "      "
                  out.print(attr.getName());
                  out.print(source[172]); // 837:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[173]); // 838:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[174]); // 838:85 = ", "
                  out.print(attr.getName());
                  out.print(source[175]); // 838:105 = ");"
                }
                out.print(source[176]); // 841:2 = "    }"
              }
              else  {
                out.print(source[177]); // 846:2 = "    if (!Objects.equals(this."
                out.print(attr.getName());
                out.print(source[178]); // 847:47 = ", "
                out.print(attr.getName());
                out.print(source[179]); // 847:67 = ")) {      setModified(true);"
                if (isAttracked()) {
                  out.print(source[180]); // 851:2 = "      "
                  out.print(attr.getName());
                  out.print(source[181]); // 852:24 = "Modified = true;      firePropertyChang..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[182]); // 853:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[183]); // 853:85 = ", "
                  out.print(attr.getName());
                  out.print(source[184]); // 853:105 = ");"
                }
                out.print(source[185]); // 856:2 = "    }"
              }
            }
          }
          out.print(source[186]); // 862:2 = "    this."
          out.print(attr.getName());
          out.print(source[187]); // 863:27 = " = "
          out.print(attr.getName());
          out.print(source[188]); // 863:48 = ";"
          if (type.equals("Timestamp")) {
            out.print(source[189]); // 866:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[190]); // 867:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[191]); // 867:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[192]); // 871:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[193]); // 872:39 = ");"
          }
          out.print(source[194]); // 875:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.getOptions().isHidden()) {
              out.print(source[195]); // 880:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[196]); // 883:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[197]); // 885:30 = " has been modified   */"
            }
            else {
              out.print(source[198]); // 890:2 = "  @Override"
            }
            out.print(source[199]); // 895:2 = "  "
            out.print(protection);
            out.print(source[200]); // 896:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[201]); // 896:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[202]); // 900:2 = "    return "
                out.print(attr.getName());
                out.print(source[203]); // 901:29 = " != "
                out.print(attr.getName());
                out.print(source[204]); // 901:51 = "Persisted;"
              }
              else {
                out.print(source[205]); // 905:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[206]); // 906:45 = ", "
                out.print(attr.getName());
                out.print(source[207]); // 906:65 = "Persisted);"
              }
            }
            else {
              out.print(source[208]); // 911:2 = "    return "
              out.print(attr.getName());
              out.print(source[209]); // 912:29 = "Modified;"
            }
            out.print(source[210]); // 915:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.getOptions().isHidden()) {
              out.print(source[211]); // 922:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[212]); // 925:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[213]); // 932:2 = "  @Override"
            }
            out.print(source[214]); // 937:2 = "  "
            out.print(protection);
            out.print(source[215]); // 938:16 = " "
            out.print(attr.getJavaType());
            out.print(source[216]); // 938:39 = " "
            out.print(getter);
            out.print(source[217]); // 938:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[218]); // 939:29 = "Persisted;  }"
          }
        }
      }
    }

    if (isPdo && generateSnapshot) {

      // createAttributesInSnapshot isnt necessary anymore since 2.2.x

      boolean needRevertAttributes = false;
      for (Attribute attr: getEntity().getAttributes())  {
        if (!attr.getOptions().isDerived() && !attr.getOptions().isSetGet()) {
          needRevertAttributes = true;
          break;
        }
      }

      if (needRevertAttributes) {
        out.print(source[219]); // 960:2 = "  /**   * Copies all attributes from a..."
        out.print(mainClass);
        out.print(getEntity().isAbstract() ? "<T,?>" : "");
        out.print(source[220]); // 967:100 = " snapshot) {    super.revertAttributesT..."
        for (Attribute attr: getEntity().getAttributes()) {
          if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isSetGet())    {
            String name = attr.getName();
            out.print(source[221]); // 973:2 = "    // "
            out.print(attr.getOptions().getComment());
            out.print(source[222]); // 974:41 = "    "
            out.print(name);
            out.print(source[223]); // 975:12 = " = snapshot."
            out.print(name);
            out.print(source[224]); // 975:32 = ";"
            if (isAttracked()) {
              if (isFullTracked()) {
                out.print(source[225]); // 979:2 = "    "
                out.print(name);
                out.print(source[226]); // 980:12 = "Persisted = snapshot."
                out.print(name);
                out.print(source[227]); // 980:41 = "Persisted;"
              }
              else {
                out.print(source[228]); // 984:2 = "    "
                out.print(name);
                out.print(source[229]); // 985:12 = "Modified = snapshot."
                out.print(name);
                out.print(source[230]); // 985:40 = "Modified;"
              }
            }
          }
        }
        out.print(source[231]); // 991:2 = "  }"
      }
    }

    if (generateSelectByUDK) {
      List<Attribute> udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        List<Attribute> superUdk = null;
        if (getEntity().getSuperEntity() != null) {
          superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
        }
        if (superUdk == null || !udk.equals(superUdk)) {
          Set<Entity> components = getEntity().getAllComponents();
          StringBuilder attribs = new StringBuilder();
          for (Attribute attribute: udk) {
            if (attribs.length() != 0) {
              attribs.append(" ");
            }
            if (components.contains(attribute.getEntity())) {
              attribs.append(attribute.getEntity()).append(".");
            }
            attribs.append(attribute.getName());
          }
          out.print(source[232]); // 1016:2 = "  // selects by unique domain key  // ..."
          out.print(attribs);
          out.print(source[233]); // 1019:66 = ""
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
