// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to declare the attributes of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Declare [--protected] [--annotations]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--protected:</em> makes the fields protected (default is private).</li>
 * <li><em>--annotations:</em> to generate annotations. Default is no generation as they will be generated for the methods.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class Declare extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    String[] args = getContainer().getArgs();   // cmd line args

    boolean isPdo;
    try {
      getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    String protection = "private";
    boolean generateAnnotations = false;

    for (String arg: getOptionArgs())  {
      if (arg.equals("protected")) {
        protection = "protected";
      }
      else if (arg.equals("annotations")) {
        generateAnnotations = true;
      }
    }

    for (Attribute attr: getEntity().getAttributes()) {
      if (!attr.getOptions().isNoDeclare())    {
        out.print(source[0]); // 43:2 = "  /** "
        out.print(attr.getOptions().getComment());
        out.print(source[1]); // 45:40 = ". */"
        if (generateAnnotations) {
          for (String annotation: attr.getOptions().getAnnotations()) {
            out.print(source[2]); // 49:2 = "  "
            out.print(annotation);
            out.print(source[3]); // 50:16 = ""
          }
        }
        if (isPdo) {
          out.print(source[4]); // 55:2 = "  @Persistent("
          out.print(StringHelper.toDoubleQuotes(attr.getOptions().getComment()));
          out.print(source[5]); // 56:78 = ")"
        }
        out.print(source[6]); // 59:2 = "  "
        out.print(protection);
        out.print(source[7]); // 60:16 = " "
        out.print(attr.getJavaType());
        out.print(source[8]); // 60:39 = " "
        out.print(attr.getName());
        out.print(source[9]); // 60:58 = ";"
        if (isAttracked()) {
          if (isFullTracked()) {
            out.print(source[10]); // 64:2 = "  /** the last persisted value of "
            out.print(attr);
            out.print(source[11]); // 65:42 = ". */  "
            out.print(protection);
            out.print(source[12]); // 66:16 = " "
            out.print(attr.getJavaType());
            out.print(source[13]); // 66:39 = " "
            out.print(attr.getName());
            out.print(source[14]); // 66:58 = "Persisted;"
          }
          else {
            out.print(source[15]); // 70:2 = "  /** true if "
            out.print(attr);
            out.print(source[16]); // 71:22 = " has been modified. */  "
            out.print(protection);
            out.print(source[17]); // 72:16 = " boolean "
            out.print(attr.getName());
            out.print(source[18]); // 72:43 = "Modified;"
          }
        }

        if (!attr.getOptions().isSetGet() && attr.getDataType().isMutable()) {
          out.print(source[19]); // 78:2 = "  /** the snapshot of "
          out.print(attr);
          out.print(source[20]); // 79:30 = ". */  private transient "
          out.print(attr.getJavaType());
          out.print(source[21]); // 80:42 = " "
          out.print(attr.getName());
          out.print(source[22]); // 80:61 = "Snapshot;"
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
