// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generates the remote delegate invocation code.
 * <p>
 * In order for this wurblet to work, the method must be annotated with @RemoteMethod.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; RemoteMethod [--this] [--nocontext] [--instance=&lt;object&gt;]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--this:</em> add the PDO itself to the method parameters.</li>
 * <li><em>--nocontext:</em> don't pass the DomainContext.</li>
 * <li><em>--instance=&lt;object&gt;:</em> object to invoke the method on in the remote implementation.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class RemoteMethod extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String instanceName   = null;
    boolean addThis       = false;
    boolean noContext     = false;

    for (String arg: getOptionArgs())  {
      if (arg.startsWith("instance=")) {
        instanceName = arg.substring(9);
      }
      else if (arg.equals("this")) {
        addThis = true;
      }
      else if (arg.equals("nocontext")) {
        noContext = true;
      }
    }

    String methodName = getMethodName();

    String className = getClassName();
    if (className == null)  {
      throw new WurbelException("can't determine <classname>");
    }

    String packageName = getPackageName();
    if (packageName == null)  {
      throw new WurbelException("can't determine <packagename>");
    }

    boolean isPdo = false;
    String pdoClassName = null;
    try {
      pdoClassName = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException wx) {
      // no pdo
    }

    if (isRemote()) {

      // load the info file
      String infoName = (packageName + "." + className + "." + methodName).replace('.', '/') +
                        RemoteMethodInfo.INFO_FILE_EXTENSION;
      RemoteMethodInfo info = null;
      try {
        info = RemoteMethodInfo.readInfo(getContainer().getAnalyzeFile(infoName));
      }
      catch (Exception ex) {
        throw new WurbelException("reading info " + infoName + " failed", ex);
      }

      RemoteMethodHelper helper = new RemoteMethodHelper(info, pdoClassName, addThis);

      boolean returningObject     = helper.isReturningObject();
      boolean returningCollection = helper.isReturningCollection();
      boolean returningCursor     = helper.isReturningCursor();
      boolean returningVoid       = helper.isReturningVoid();

      // get the real method name
      methodName = helper.getMethodName();

      if (helper.isStaticMethod()) {
        throw new WurbelException("static methods cannot be --remote");
      }

      // generate strings
      String iparms  = helper.getInvocationParameterString();
      String riparms = helper.getRemoteInvocationParameterString();
      String dparms  = helper.getDeclarationParameterString();

      if (isPdo && !addThis && !noContext) {
        if (iparms.length() > 0) {
          iparms = "getDomainContext(), " + iparms;
        }
        else {
          iparms = "getDomainContext()";
        }

        if (dparms.length() > 0) {
          dparms = "DomainContext context, " + dparms;
        }
        else  {
          dparms = "DomainContext context";
        }
      }

      String returnType = helper.getReturnType();
      String genType = helper.getGenericReturnType();

      String firstName  = helper.getFirstName();
      boolean firstIsDb = helper.isFirstInstanceOfDb();
      boolean firstIsDomainContext = helper.isFirstInstanceOfDomainContext();

      String remoteDelegateName = (pdoClassName != null ? pdoClassName : className) + "RemoteDelegate";
      String imethod = "getRemoteDelegate()";

      String setDomainContext = "setDomainContext(" + firstName + ")";

      String apply = null;
      if (returningObject) {
        apply = "configureRemoteObject(getDomainContext(), obj)";
      }
      else if (returningCollection) {
        apply = "configureRemoteObjects(getDomainContext(), list)";
      }

      // always use a fresh pdo because we don't know what the app is really doing with it
      String dbObject = "newInstance(" + (firstIsDomainContext ? firstName : "context") + ")";
      if (!isPdo || noContext) {
        dbObject = "dbObject";
      }
      if (addThis) {
        dbObject = "obj";
      }
      else if (instanceName != null) {
        dbObject = instanceName;
      }

      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplStream();
      PrintStream remoteOut = genInc.getRemoteStream();
      out.print(source[0]); // 143:2 = "    if (getSession().isRemote())  {    ..."


      if (returningObject) {
        remoteOut.print(source[1]); // 152:16 = "  "
        remoteOut.print(className);
        remoteOut.print(source[2]); // 153:15 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[3]); // 153:30 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[4]); // 153:41 = ") throws RemoteException;"
        implOut.print(source[5]); // 154:14 = "  @Override  public "
        implOut.print(className);
        implOut.print(source[6]); // 157:22 = " "
        implOut.print(methodName);
        implOut.print(source[7]); // 157:37 = "("
        implOut.print(dparms);
        implOut.print(source[8]); // 157:48 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[9]); // 161:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[10]); // 162:26 = ";"
        }
        if (addThis) {
          implOut.print(source[11]); // 166:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[12]); // 171:2 = "      "
          implOut.print(statement);
          implOut.print(source[13]); // 172:19 = ";"
        }
        implOut.print(source[14]); // 175:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[15]); // 176:25 = "."
        implOut.print(methodName);
        implOut.print(source[16]); // 176:40 = "("
        implOut.print(riparms);
        implOut.print(source[17]); // 176:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[18]); // 182:6 = "        "
        out.print(className);
        out.print(source[19]); // 183:21 = " obj = "
        out.print(imethod);
        out.print(source[20]); // 183:39 = "."
        out.print(methodName);
        out.print(source[21]); // 183:54 = "("
        out.print(iparms);
        out.print(source[22]); // 183:65 = ");        "
        out.print(apply);
        out.print(source[23]); // 184:17 = ";        return obj;"
      }


      if (returningCollection) {
        remoteOut.print(source[24]); // 192:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[25]); // 193:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[26]); // 193:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[27]); // 193:42 = ") throws RemoteException;"
        implOut.print(source[28]); // 194:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[29]); // 197:23 = " "
        implOut.print(methodName);
        implOut.print(source[30]); // 197:38 = "("
        implOut.print(dparms);
        implOut.print(source[31]); // 197:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[32]); // 201:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[33]); // 202:26 = ";"
        }
        if (addThis) {
          implOut.print(source[34]); // 206:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[35]); // 211:2 = "      "
          implOut.print(statement);
          implOut.print(source[36]); // 212:19 = ";"
        }
        implOut.print(source[37]); // 215:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[38]); // 216:25 = "."
        implOut.print(methodName);
        implOut.print(source[39]); // 216:40 = "("
        implOut.print(riparms);
        implOut.print(source[40]); // 216:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[41]); // 222:6 = "        "
        out.print(returnType);
        out.print(source[42]); // 223:22 = " list = "
        out.print(imethod);
        out.print(source[43]); // 223:41 = "."
        out.print(methodName);
        out.print(source[44]); // 223:56 = "("
        out.print(iparms);
        out.print(source[45]); // 223:67 = ");        "
        out.print(apply);
        out.print(source[46]); // 224:17 = ";        return list;"
      }


      else if (returningCursor) {
        remoteOut.print(source[47]); // 232:16 = "  RemoteResultSetCursor"
        remoteOut.print(genType);
        remoteOut.print(source[48]); // 233:34 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[49]); // 233:49 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[50]); // 233:60 = ") throws RemoteException;"
        implOut.print(source[51]); // 234:14 = "  @Override  public RemoteResultSetCur..."
        implOut.print(genType);
        implOut.print(source[52]); // 237:41 = " "
        implOut.print(methodName);
        implOut.print(source[53]); // 237:56 = "("
        implOut.print(dparms);
        implOut.print(source[54]); // 237:67 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[55]); // 241:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[56]); // 242:26 = ";"
        }
        if (addThis) {
          implOut.print(source[57]); // 246:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[58]); // 251:2 = "      "
          implOut.print(statement);
          implOut.print(source[59]); // 252:19 = ";"
        }
        implOut.print(source[60]); // 255:2 = "      return createRemoteResultSetCursor..."
        implOut.print(dbObject);
        implOut.print(source[61]); // 256:61 = "."
        implOut.print(methodName);
        implOut.print(source[62]); // 256:76 = "("
        implOut.print(riparms);
        implOut.print(source[63]); // 256:88 = "));    }    catch (Exception e) {    ..."
        if (isPdo) {
          out.print(source[64]); // 265:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[65]); // 267:32 = "."
          out.print(methodName);
          out.print(source[66]); // 267:47 = "("
          out.print(iparms);
          out.print(source[67]); // 267:58 = "));"
        }
        else  {
          out.print(source[68]); // 271:2 = "        return new ResultSetCursor<>(get..."
          out.print(imethod);
          out.print(source[69]); // 273:32 = "."
          out.print(methodName);
          out.print(source[70]); // 273:47 = "("
          out.print(iparms);
          out.print(source[71]); // 273:58 = "));"
        }
      }

      else if (returningVoid) {
        remoteOut.print(source[72]); // 280:16 = "  void "
        remoteOut.print(methodName);
        remoteOut.print(source[73]); // 281:21 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[74]); // 281:32 = ") throws RemoteException;"
        implOut.print(source[75]); // 282:14 = "  @Override  public void "
        implOut.print(methodName);
        implOut.print(source[76]); // 285:28 = "("
        implOut.print(dparms);
        implOut.print(source[77]); // 285:39 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[78]); // 289:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[79]); // 290:26 = ";"
        }
        if (addThis) {
          implOut.print(source[80]); // 294:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[81]); // 299:2 = "      "
          implOut.print(statement);
          implOut.print(source[82]); // 300:19 = ";"
        }
        implOut.print(source[83]); // 303:2 = "      "
        implOut.print(dbObject);
        implOut.print(source[84]); // 304:18 = "."
        implOut.print(methodName);
        implOut.print(source[85]); // 304:33 = "("
        implOut.print(riparms);
        implOut.print(source[86]); // 304:45 = ");    }    catch (Exception e) {     ..."
        out.print(source[87]); // 310:6 = "        "
        out.print(imethod);
        out.print(source[88]); // 311:19 = "."
        out.print(methodName);
        out.print(source[89]); // 311:34 = "("
        out.print(iparms);
        out.print(source[90]); // 311:45 = ");        return;"
      }


      else  {
        remoteOut.print(source[91]); // 319:16 = "  "
        remoteOut.print(returnType);
        remoteOut.print(source[92]); // 320:16 = " "
        remoteOut.print(methodName);
        remoteOut.print(source[93]); // 320:31 = "("
        remoteOut.print(dparms);
        remoteOut.print(source[94]); // 320:42 = ") throws RemoteException;"
        implOut.print(source[95]); // 321:14 = "  @Override  public "
        implOut.print(returnType);
        implOut.print(source[96]); // 324:23 = " "
        implOut.print(methodName);
        implOut.print(source[97]); // 324:38 = "("
        implOut.print(dparms);
        implOut.print(source[98]); // 324:49 = ") throws RemoteException {    try {"
        if (firstIsDomainContext) {
          implOut.print(source[99]); // 328:2 = "      "
          implOut.print(setDomainContext);
          implOut.print(source[100]); // 329:26 = ";"
        }
        if (addThis) {
          implOut.print(source[101]); // 333:2 = "      obj.setSession(getSession());"
        }
        for (String statement: helper.getUpdateDbInParametersStatements()) {
          implOut.print(source[102]); // 338:2 = "      "
          implOut.print(statement);
          implOut.print(source[103]); // 339:19 = ";"
        }
        implOut.print(source[104]); // 342:2 = "      return "
        implOut.print(dbObject);
        implOut.print(source[105]); // 343:25 = "."
        implOut.print(methodName);
        implOut.print(source[106]); // 343:40 = "("
        implOut.print(riparms);
        implOut.print(source[107]); // 343:52 = ");    }    catch (Exception e) {     ..."
        out.print(source[108]); // 349:6 = "        return "
        out.print(imethod);
        out.print(source[109]); // 350:26 = "."
        out.print(methodName);
        out.print(source[110]); // 350:41 = "("
        out.print(iparms);
        out.print(source[111]); // 350:52 = ");"
      }
      out.print(source[112]); // 353:2 = "      }      catch (RemoteException e) ..."
    }
    else  {
      out.print(source[113]); // 363:2 = "    // remote code generation disabled"
    }
  }

  // ----------------- end wurblet code -----------------
}
