// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for related entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoRelations
 *     [--loadcomponents|--noloadcomponents]
 *     [--insertcomponents|--noinsertcomponents]
 *     [--deletecomponents|--nodeletecomponents]
 *     [--nori] [--noselects] [--nodeletes]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--loadcomponents|--noloadcomponents:</em> force (no) generation of loadComponents().</li>
 * <li><em>--insertcomponents|--noinsertcomponents:</em> force (no) generation of insertPlainWithComponents().</li>
 * <li><em>--deletecomponents|--nodeletecomponents:</em> force (no) generation of deletePlainWithComponents().</li>
 * <li><em>--nori:</em> don't generate PdoIsReferencing wurblet anchors and addReferencingClass() invocations.</li>
 * <li><em>--noselects:</em> don't generate PdoSelect... wurblet anchors.</li>
 * <li><em>--nodeletes:</em> don't generate PdoDelete... wurblet anchors.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoRelations extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();

    String pdoName = null;
    try {
      // in implementation
      pdoName = getPdoClassName();
    }
    catch (WurbelException we) {
      // in interface
      pdoName = getClassName();
    }

    boolean generateDeclarations                    = false;
    boolean generateIsModified                      = false;
    boolean generateIsComposite                     = false;
    boolean generateSaveReferencingRelations        = false;
    boolean generateSaveReferencedRelations         = false;
    boolean generateDeleteReferencingRelations      = false;
    boolean generateDeleteReferencedRelations       = false;
    boolean generateLazyDeleteReferencingRelations  = false;
    boolean generateLazyDeleteReferencedRelations   = false;
    boolean generateSetSession                      = false;
    Boolean generateLoadComponents                  = null;
    Boolean generateInsertComponents                = null;
    Boolean generateDeleteComponents                = null;
    boolean generateMarkDeleted                     = false;
    boolean generateIsReferencing                   = true;
    boolean generateAddReferencing                  = false;
    boolean generateSelects                         = true;
    boolean generateDeletes                         = true;
    boolean generateValidate                        = false;
    boolean generateSetImmutable                    = false;
    boolean generateSnapshot                        = false;
    boolean generateClearOnRemoteSave               = false;
    boolean generateIsUpdateNecessary               = false;

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
        generateAddReferencing = true;
        break;
      }
    }

    for (String arg: getOptionArgs())  {
      if (arg.equals("noloadcomponents")) {
        generateLoadComponents = false;
      }
      else if (arg.equals("noinsertcomponents")) {
        generateInsertComponents = false;
      }
      else if (arg.equals("nodeletecomponents")) {
        generateDeleteComponents = false;
      }
      else if (arg.equals("loadcomponents")) {
        generateLoadComponents = true;
      }
      else if (arg.equals("insertcomponents")) {
        generateInsertComponents = true;
      }
      else if (arg.equals("deletecomponents")) {
        generateDeleteComponents = true;
      }
      else if (arg.equals("nori")) {
        generateIsReferencing = false;
        generateAddReferencing = false;
      }
      else if (arg.equals("noselects")) {
        generateSelects = false;
      }
      else if (arg.equals("nodeletes")) {
        generateDeletes = false;
      }
    }

    // check which methods need generation
    for (Relation rel: getEntity().getRelations()) {
      if (rel.getSelectionType() == SelectionType.LAZY ||
          rel.getSelectionType() == SelectionType.EAGER)  {
        generateDeclarations = true;
        generateSetSession   = true;
      }
      if (rel.isComposite()) {
        generateIsComposite         = true;
        generateDeclarations        = true;
        generateIsModified          = true;
        generateSetSession          = true;
        generateMarkDeleted         = true;
        generateValidate            = true;
        generateSnapshot            = true;
        generateSetImmutable        = true;

        if (rel.getRelationType() == RelationType.OBJECT) {
          generateSaveReferencedRelations = true;
          generateDeleteReferencedRelations = true;
          generateLazyDeleteReferencedRelations = true;
        }
        else  { // LIST
          generateSaveReferencingRelations = true;
          generateDeleteReferencingRelations = true;
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            generateLazyDeleteReferencingRelations = true;
            if (rel.getCountAttribute() != null) {
              generateIsUpdateNecessary = true;
            }
          }
        }
      }
      if (rel.isClearOnRemoteSave()) {
        generateClearOnRemoteSave = true;
      }
    }

    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    if (generateLoadComponents == null) {
      generateLoadComponents = generateIsComposite;
    }
    if (generateInsertComponents == null) {
      generateInsertComponents = generateIsComposite;
    }
    if (generateDeleteComponents == null) {
      generateDeleteComponents = generateIsComposite && (!useDatabaseRefInt || getEntity().isRootEntity());
    }


    // dump what we read from source
    out.print(source[0]); // 155:2 = "  /**   * # Relations for "
    out.print(pdoName);
    out.print(source[1]); // 157:32 = ":   *"
    for (Relation rel: getEntity().getRelations()) {
      out.print(source[2]); // 161:2 = "   * "
      out.print(rel);
      out.print(source[3]); // 162:12 = ""
    }
    out.print(source[4]); // 165:2 = "   */"

    if (generateDeclarations) {
      // declarations
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite())  {
          String type = rel.getDeclaredJavaType();
          String transientModifier = isRelationTransient(rel) ? "transient " : "";
          out.print(source[5]); // 175:2 = "  // "
          out.print(rel);
          out.print(source[6]); // 177:12 = ""
          if (rel.isComposite()) {
            out.print(source[7]); // 180:2 = "  @Persistent("
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[8]); // 181:64 = ")"
          }
          out.print(source[9]); // 184:2 = "  private "
          out.print(transientModifier);
          out.print(type);
          out.print(source[10]); // 185:39 = " "
          out.print(rel.getVariableName());
          out.print(source[11]); // 185:65 = ";"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[12]); // 188:2 = "  private "
            out.print(transientModifier);
            out.print(source[13]); // 189:31 = "boolean "
            out.print(rel.getVariableName());
            out.print(source[14]); // 189:64 = "Loaded;"
          }
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
              out.print(source[15]); // 194:2 = "  private transient "
              out.print(type);
              out.print(source[16]); // 195:28 = " "
              out.print(rel.getVariableName());
              out.print(source[17]); // 195:54 = "Snapshot;"
            }
            if (rel.getRelationType() == RelationType.OBJECT) {
              out.print(source[18]); // 199:2 = "  private long "
              out.print(rel.getVariableName());
              out.print(source[19]); // 200:40 = "RemovedId;"
            }
          }
        }

        if (rel.getNmName() != null) {
          String nmVar;
          if (rel.getNmMethodName() != null) {
            nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
          }
          else  {
            nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
          }
          out.print(source[20]); // 214:2 = "  private transient TrackedList<"
          out.print(rel.getNmRelation().getDeclaredJavaType());
          out.print(source[21]); // 215:77 = "> "
          out.print(nmVar);
          out.print(source[22]); // 215:88 = ";"
        }
      }
    }

    if (generateClearOnRemoteSave) {
      out.print(source[23]); // 222:2 = "  @Override  public void clearOnRemote..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isClearOnRemoteSave()) {
          out.print(source[24]); // 229:2 = "    "
          out.print(rel.getVariableName());
          out.print(source[25]); // 230:29 = " = null;"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[26]); // 233:2 = "    "
            out.print(rel.getVariableName());
            out.print(source[27]); // 234:29 = "Loaded = false;"
          }
        }
      }
      out.print(source[28]); // 239:2 = "  }"
    }



    // generate getter/setter
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType();
      String effType = rel.getJavaType();
      String scope = rel.getAccessScope().toString();
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        scope = attr.getOptions().getAccessScope().toString();
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }
      if (rel.getForeignRelation() != null) {
        String linkMethodName = rel.getForeignRelation().getLinkMethodName();
        if (linkMethodName != null && !rel.getSetterName().equals(linkMethodName)) {
          // don't generate setter impl if linkmethodname is not default from model
          createSetter = false;
        }
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == null || " + checkNull;
        }
        out.print(source[29]); // 291:2 = "  @Override"
        if (rel.getForeignEntity().isAbstract()) { // needs a cast
        out.print(source[30]); // 296:2 = "  @SuppressWarnings("unchecked")"
        }
        out.print(source[31]); // 300:2 = "  "
        out.print(scope);
        out.print(source[32]); // 301:11 = " "
        out.print(type);
        out.print(source[33]); // 301:20 = " "
        out.print(rel.getGetterName());
        out.print(source[34]); // 301:44 = "()  {"
        if (rel.getSelectionType() == SelectionType.ALWAYS) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isSelectionCached()) {
              out.print(source[35]); // 306:2 = "    "
              out.print(var);
              out.print(source[36]); // 307:11 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[37]); // 307:47 = ";"
            }
            else {
              out.print(source[38]); // 311:2 = "    "
              out.print(type);
              out.print(source[39]); // 312:12 = " "
              out.print(var);
              out.print(source[40]); // 312:20 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[41]); // 312:56 = ";"
            }
            if (rel.isReferenced()) {
              if (rel.getLinkMethodIndex() != null) {
                out.print(source[42]); // 317:2 = "    int ndx = 0;"
              }
              out.print(source[43]); // 321:2 = "    for ("
              out.print(rel.getClassName());
              out.print(source[44]); // 322:31 = " obj: "
              out.print(var);
              out.print(source[45]); // 322:44 = ")  {      obj."
              out.print(createRelationUpdateReferenceCode(rel));
              out.print(source[46]); // 323:52 = ";    }"
            }
            out.print(source[47]); // 327:2 = "    return "
            out.print(var);
            out.print(source[48]); // 328:18 = ";"
          }
          else  {
            if (rel.isComposite()) {
              out.print(source[49]); // 333:2 = "    "
              out.print(var);
              out.print(source[50]); // 334:11 = " = "
              out.print(checkNull);
              out.print(source[51]); // 334:27 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[52]); // 334:70 = ";"
              if (rel.isReferenced()) {
                out.print(source[53]); // 337:2 = "    if ("
                out.print(var);
                out.print(source[54]); // 338:15 = " != null) {      "
                out.print(var);
                out.print(source[55]); // 339:13 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[56]); // 339:56 = ";    }"
              }
              if (rel.isProcessed()) {
                out.print(source[57]); // 344:2 = "    "
                out.print(var);
                out.print(source[58]); // 345:11 = " = process"
                out.print(rel.getMethodNameSuffix());
                out.print(source[59]); // 345:50 = "("
                out.print(var);
                out.print(source[60]); // 345:58 = ");"
              }
              out.print(source[61]); // 348:2 = "    return "
              out.print(var);
              out.print(source[62]); // 349:18 = ";"
            }
            else  {
              if (rel.isReferenced()) {
                out.print(source[63]); // 354:2 = "    "
                out.print(type);
                out.print(source[64]); // 355:12 = " obj = "
                out.print(checkNull);
                out.print(source[65]); // 355:32 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[66]); // 355:75 = ";    if (obj != null) {      obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[67]); // 357:52 = ";    }    return obj;"
              }
              else {
                out.print(source[68]); // 363:2 = "    return "
                out.print(checkNull);
                out.print(source[69]); // 364:24 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[70]); // 364:67 = ";"
              }
            }
          }
        }
        else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[71]); // 371:2 = "    if (!"
          out.print(var);
          out.print(source[72]); // 372:16 = "Loaded) {"
          if (rel.isComposite())  {
            if (rel.getRelationType() == RelationType.LIST) {
              String condition = "isNew()";
              Attribute countAttribute = rel.getCountAttribute();
              if (countAttribute != null) {
                condition += " || " + countAttribute.getName() + " == 0";
              }
              out.print(source[73]); // 381:2 = "      "
              out.print(var);
              out.print(source[74]); // 382:13 = " = "
              out.print(condition);
              out.print(source[75]); // 382:29 = " ? new "
              out.print(effType);
              out.print(source[76]); // 382:47 = "("
              out.print(rel.isTracked() ? "false" : "");
              out.print(source[77]); // 382:82 = ") : "
              out.print(createRelationSelectCode(rel));
              out.print(source[78]); // 382:119 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[79]); // 386:2 = "      int ndx = 0;"
                }
                out.print(source[80]); // 390:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[81]); // 391:33 = " obj: "
                out.print(var);
                out.print(source[82]); // 391:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[83]); // 392:54 = ";      }"
              }
            }
            else  {
              out.print(source[84]); // 398:2 = "      "
              out.print(var);
              out.print(source[85]); // 399:13 = " =  "
              out.print(checkNull);
              out.print(source[86]); // 399:30 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[87]); // 399:73 = ";"
              if (rel.isReferenced()) {
                out.print(source[88]); // 402:2 = "      if ("
                out.print(var);
                out.print(source[89]); // 403:17 = " != null) {        "
                out.print(var);
                out.print(source[90]); // 404:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[91]); // 404:58 = ";      }"
              }
            }
            if (rel.getRelationType() == RelationType.LIST) {
              if (rel.isTracked()) {
                out.print(source[92]); // 411:2 = "      if (isImmutable()) {        "
                out.print(var);
                out.print(source[93]); // 413:15 = ".setImmutable(true);      }"
              }
            }
            else  {
              out.print(source[94]); // 419:2 = "      if (isImmutable() && "
              out.print(var);
              out.print(source[95]); // 420:34 = " != null) {        "
              out.print(var);
              out.print(source[96]); // 421:15 = ".setImmutable(true);      }"
            }
            if (rel.isProcessed()) {
              out.print(source[97]); // 426:2 = "      "
              out.print(var);
              out.print(source[98]); // 427:13 = " = process"
              out.print(rel.getMethodNameSuffix());
              out.print(source[99]); // 427:52 = "("
              out.print(var);
              out.print(source[100]); // 427:60 = ");"
            }
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[101]); // 433:2 = "      "
              out.print(var);
              out.print(source[102]); // 434:13 = " = "
              out.print(createRelationSelectCode(rel));
              out.print(source[103]); // 434:49 = ";"
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[104]); // 438:2 = "      int ndx = 0;"
                }
                out.print(source[105]); // 442:2 = "      for ("
                out.print(rel.getClassName());
                out.print(source[106]); // 443:33 = " obj: "
                out.print(var);
                out.print(source[107]); // 443:46 = ")  {        obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[108]); // 444:54 = ";      }"
              }
            }
            else  {
              out.print(source[109]); // 450:2 = "      "
              out.print(var);
              out.print(source[110]); // 451:13 = " = "
              out.print(checkNull);
              out.print(source[111]); // 451:29 = " ? null : "
              out.print(createRelationSelectCode(rel));
              out.print(source[112]); // 451:72 = ";"
              if (rel.isReferenced()) {
                out.print(source[113]); // 454:2 = "      if ("
                out.print(var);
                out.print(source[114]); // 455:17 = " != null) {        "
                out.print(var);
                out.print(source[115]); // 456:15 = "."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[116]); // 456:58 = ";      }"
              }
            }
          }
          out.print(source[117]); // 462:2 = "      "
          out.print(var);
          out.print(source[118]); // 463:13 = "Loaded = true;"
          if (nmRel != null) {
            out.print(source[119]); // 466:2 = "      "
            out.print(var);
            out.print(source[120]); // 467:13 = ".addListener(new TrackedListListener<"
            out.print(rel.getClassName());
            out.print(source[121]); // 467:72 = ">() {        @Override        public ..."
            out.print(rel.getClassName());
            out.print(source[122]); // 470:48 = " element) {          get"
            out.print(nmName);
            out.print(source[123]); // 471:23 = "().addIfAbsent(element."
            out.print(nmRel.getGetterName());
            out.print(source[124]); // 471:71 = "());        }        @Override      ..."
            out.print(rel.getClassName());
            out.print(source[125]); // 475:50 = " element) {          get"
            out.print(nmName);
            out.print(source[126]); // 476:23 = "().remove(element."
            out.print(nmRel.getGetterName());
            out.print(source[127]); // 476:66 = "());        }      });"
          }
          out.print(source[128]); // 481:2 = "    }    return "
          out.print(var);
          out.print(source[129]); // 483:18 = ";"
        }
        out.print(source[130]); // 486:2 = "  }"
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
            out.print(source[131]); // 491:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[132]); // 494:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[133]); // 496:21 = " "
            out.print(rel.getComment());
            out.print(source[134]); // 496:42 = "   */  "
            out.print(scope);
            out.print(source[135]); // 498:11 = " "
            out.print(type);
            out.print(source[136]); // 498:20 = " "
            out.print(rel.getGetterName());
            out.print(source[137]); // 498:44 = "Blunt() {    if (!"
            out.print(var);
            out.print(source[138]); // 499:16 = "Loaded) {      "
            out.print(var);
            out.print(source[139]); // 500:13 = " = new "
            out.print(effType);
            out.print(source[140]); // 500:31 = "("
            out.print(rel.isTracked() ? "false" : "");
            out.print(source[141]); // 500:66 = ");      if (isImmutable()) {        "
            out.print(var);
            out.print(source[142]); // 502:15 = ".setImmutable(true);      }      "
            out.print(var);
            out.print(source[143]); // 504:13 = "Loaded = true;    }    return "
            out.print(var);
            out.print(source[144]); // 506:18 = ";  }"
          }
          else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized()) {
            out.print(source[145]); // 511:2 = "  /**   * Gets "
            out.print(var);
            out.print(source[146]); // 514:17 = " without performing a select if not load..."
            out.print(var);
            out.print(source[147]); // 516:21 = " "
            out.print(rel.getComment());
            out.print(source[148]); // 516:42 = "   */  "
            out.print(scope);
            out.print(source[149]); // 518:11 = " "
            out.print(type);
            out.print(source[150]); // 518:20 = " "
            out.print(rel.getGetterName());
            out.print(source[151]); // 518:44 = "Blunt() {    return "
            out.print(var);
            out.print(source[152]); // 519:18 = ";  }"
          }
        }

        if (nmRel != null) {
          out.print(source[153]); // 526:2 = "  @Override  public TrackedList<"
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[154]); // 529:52 = "> get"
          out.print(nmName);
          out.print(source[155]); // 529:67 = "() {    if ("
          out.print(nmVar);
          out.print(source[156]); // 530:17 = " == null) {      "
          out.print(nmVar);
          out.print(source[157]); // 531:15 = " = new TrackedArrayList<"
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[158]); // 531:70 = ">() {        @Override        public ..."
          out.print(rel.getGetterName());
          out.print(source[159]); // 535:40 = "().isModified();        }      };   ..."
          out.print(rel.getForeignEntity());
          out.print(source[160]); // 539:37 = " obj: "
          out.print(rel.getGetterName());
          out.print(source[161]); // 539:66 = "()) {        "
          out.print(nmVar);
          out.print(source[162]); // 540:17 = ".add(obj."
          out.print(nmRel.getGetterName());
          out.print(source[163]); // 540:51 = "());      }      "
          out.print(nmVar);
          out.print(source[164]); // 543:15 = ".addListener(new TrackedListListener<"
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[165]); // 543:83 = ">() {        @Override        public ..."
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[166]); // 546:57 = " element) {          "
          out.print(rel.getClassName());
          out.print(source[167]); // 547:32 = " obj = on("
          out.print(rel.getClassName());
          out.print(source[168]); // 547:64 = ".class);          obj."
          out.print(nmRel.getSetterName());
          out.print(source[169]); // 548:39 = "(element);          getNmLinks().add(ob..."
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[170]); // 553:59 = " element) {          for (Iterator<"
          out.print(rel.getClassName());
          out.print(source[171]); // 554:46 = "> iter = "
          out.print(rel.getGetterName());
          out.print(source[172]); // 554:78 = "().iterator(); iter.hasNext(); ) {     ..."
          out.print(rel.getClassName());
          out.print(source[173]); // 555:34 = " obj = iter.next();            if (Obje..."
          out.print(nmRel.getGetterName());
          out.print(source[174]); // 556:60 = "(), element)) {              iter.remov..."
          out.print(nmVar);
          out.print(source[175]); // 564:20 = ";  }"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
          if (rel.getAccessScope() == AccessScope.PUBLIC) {
            out.print(source[176]); // 572:2 = "  @Override"
          }
          else {
            out.print(source[177]); // 578:2 = "  /**   * Returns whether "
            out.print(rel.getName());
            out.print(source[178]); // 581:38 = " is loaded.   *   * @return true if "
            out.print(rel.getGetterName());
            out.print(source[179]); // 583:45 = "() invoked at least once   */"
          }
          out.print(source[180]); // 587:2 = "  "
          out.print(scope);
          out.print(source[181]); // 588:11 = " boolean is"
          out.print(StringHelper.firstToUpper(var));
          out.print(source[182]); // 588:56 = "Loaded() {    return "
          out.print(var);
          out.print(source[183]); // 589:18 = "Loaded;  }"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
        out.print(source[184]); // 599:2 = "  @Override"
        if (linkMethodIndex != null) {
          out.print(source[185]); // 604:2 = "  "
          out.print(scope);
          out.print(source[186]); // 605:11 = " void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[187]); // 605:65 = "("
          out.print(type);
          out.print(source[188]); // 605:74 = " "
          out.print(var);
          out.print(source[189]); // 605:82 = ", int index)  {"
        }
        else {
          out.print(source[190]); // 609:2 = "  "
          out.print(scope);
          out.print(source[191]); // 610:11 = " void "
          out.print(rel.getSetterName());
          out.print(source[192]); // 610:40 = "("
          out.print(type);
          out.print(source[193]); // 610:49 = " "
          out.print(var);
          out.print(source[194]); // 610:57 = ")  {"
        }
        if (!rel.isReversed()) {
          out.print(source[195]); // 614:2 = "    assertMutable();"
        }
        if ((rel.getRelationType() == RelationType.LIST && !rel.isReversed()) ||
            rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[196]); // 621:2 = "    if (!attributesModified()) {      s..."
            out.print(var);
            out.print(source[197]); // 623:46 = ", "
            out.print(var);
            out.print(source[198]); // 623:55 = "));    }"
          }
          out.print(source[199]); // 627:2 = "    this."
          out.print(var);
          out.print(source[200]); // 628:16 = " = "
          out.print(var);
          out.print(source[201]); // 628:26 = ";"
          if (linkMethodIndex != null) {
            out.print(source[202]); // 631:2 = "    set"
            out.print(StringHelper.firstToUpper(linkMethodIndex));
            out.print(source[203]); // 632:53 = "(index);"
          }
        }
        if (rel.getRelationType() == RelationType.OBJECT) {
          if (rel.isComposite())  {
            if (attr != null && !attr.getDataType().isPrimitive()) {
              out.print(source[204]); // 639:2 = "    "
              out.print(attr.getJavaType());
              out.print(source[205]); // 640:26 = " oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[206]); // 640:85 = ";"
            }
            else {
              out.print(source[207]); // 644:2 = "    long oldId = "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[208]); // 645:67 = ";"
            }
          }
          out.print(source[209]); // 649:2 = "    "
          out.print(createRelationSetFirstArgMethodName(rel));
          out.print(source[210]); // 650:48 = "("
          out.print(var);
          out.print(source[211]); // 650:56 = " == null ? "
          out.print(nullVal);
          out.print(source[212]); // 650:78 = " : "
          out.print(var);
          out.print(source[213]); // 650:88 = ".getId());"
        }
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
          out.print(source[214]); // 654:2 = "    "
          out.print(var);
          out.print(source[215]); // 655:11 = "Loaded = true;"
        }
        if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite())  {
          if (attr != null && !attr.getDataType().isPrimitive()) {
            out.print(source[216]); // 660:2 = "    if (oldId != null && oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[217]); // 661:64 = "RemovedId == 0 && !Objects.equals("
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[218]); // 661:148 = ", oldId)) {      "
            out.print(rel.getVariableName());
            out.print(source[219]); // 662:31 = "RemovedId = oldId;    }"
          }
          else {
            out.print(source[220]); // 667:2 = "    if (oldId != 0 && "
            out.print(rel.getVariableName());
            out.print(source[221]); // 668:47 = "RemovedId == 0 && "
            out.print(rel.getMethodArgs().get(0).getMethodArgument());
            out.print(source[222]); // 668:115 = " != oldId) {      "
            out.print(rel.getVariableName());
            out.print(source[223]); // 669:31 = "RemovedId = oldId;    }"
          }
        }
        out.print(source[224]); // 674:2 = "  }"
      }

      if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() &&
          (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
            out.print(source[225]); // 681:2 = "  /**   * Sets "
            out.print(var);
            out.print(source[226]); // 684:17 = " without setting any attributes.   *  ..."
            out.print(var);
            out.print(source[227]); // 686:20 = " "
            out.print(rel.getComment());
            out.print(source[228]); // 686:41 = "   */  "
            out.print(scope);
            out.print(source[229]); // 688:11 = " void "
            out.print(rel.getSetterName());
            out.print(source[230]); // 688:40 = "Blunt("
            out.print(type);
            out.print(source[231]); // 688:54 = " "
            out.print(var);
            out.print(source[232]); // 688:62 = ") {    this."
            out.print(var);
            out.print(source[233]); // 689:16 = " = "
            out.print(var);
            out.print(source[234]); // 689:26 = ";    "
            out.print(var);
            out.print(source[235]); // 690:11 = "Loaded = true;  }"
      }

    }


    // gerenate setSession for referenced objects (necessary for RMI)
    if (generateSetSession)  {
      out.print(source[236]); // 700:2 = "  @Override  public void setSession(Se..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER || rel.isComposite()) {
          out.print(source[237]); // 708:2 = "    session.applyTo("
          out.print(rel.getVariableName());
          out.print(source[238]); // 709:45 = ");"
        }
      }
      out.print(source[239]); // 713:2 = "  }  @Override  public void setDomain..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER || rel.isComposite()) {
          out.print(source[240]); // 722:2 = "    context.applyTo("
          out.print(rel.getVariableName());
          out.print(source[241]); // 723:45 = ");"
        }
      }
      out.print(source[242]); // 727:2 = "  }"
    }



    // generate code to remove delete composite relations

    if (generateDeleteReferencingRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[243]); // 738:2 = "  /**   * Deletes all referencing comp..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (!rel.isTracked()) {
                throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
              }
              String var = rel.getVariableName();
              out.print(source[244]); // 752:2 = "    if ("
              out.print(var);
              out.print(source[245]); // 753:15 = " != null && "
              out.print(var);
              out.print(source[246]); // 753:34 = ".isSomeRemoved()) {      delete("
              out.print(var);
              out.print(source[247]); // 754:20 = ".getRemovedObjects());    }"
            }
          }
          out.print(source[248]); // 759:2 = "  }"
      }
      else { // no database ref. integrity
        if (generateLazyDeleteReferencingRelations)  {
          out.print(source[249]); // 765:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                if (rel.isTracked())  {
                  out.print(source[250]); // 790:2 = "    if (delete) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[251]); // 794:2 = "      delete("
                    out.print(rel.getGetterName());
                    out.print(source[252]); // 795:36 = "());"
                  }
                  else {
                    out.print(source[253]); // 799:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[254]); // 800:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[255]); // 801:39 = ";"
                  }
                  out.print(source[256]); // 804:2 = "    }    if ("
                  out.print(var);
                  out.print(source[257]); // 806:15 = " != null && "
                  out.print(var);
                  out.print(source[258]); // 806:34 = ".isSomeRemoved()) {      delete("
                  out.print(var);
                  out.print(source[259]); // 807:20 = ".getRemovedObjects());    }"
                }  // end if isTracked
                else  {
                  out.print(source[260]); // 812:2 = "    if (delete || "
                  out.print(var);
                  out.print(source[261]); // 813:25 = " != null) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[262]); // 816:2 = "      markDeleted("
                    out.print(rel.getGetterName());
                    out.print(source[263]); // 817:41 = "());      deleteMissingInCollection("
                    out.print(createRelationSelectCode(rel));
                    out.print(source[264]); // 818:65 = ", "
                    out.print(var);
                    out.print(source[265]); // 818:74 = ");"
                  } // end isDeleteCascade
                  else {
                    out.print(source[266]); // 822:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[267]); // 823:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[268]); // 824:39 = ";"
                  }
                  out.print(source[269]); // 827:2 = "    }"
                }
              }
            } // end composite
          }
          out.print(source[270]); // 834:2 = "  }"
        } // end if generateLazyDeleteReferencingRelations

        else  {   // no lazy loading at all
        out.print(source[271]); // 840:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.isDeletionCascaded()) {
                out.print(source[272]); // 850:2 = "    delete("
                out.print(rel.getGetterName());
                out.print(source[273]); // 851:34 = "());"
              }
              else {
                out.print(source[274]); // 855:2 = "    markDeleted("
                out.print(var);
                out.print(source[275]); // 856:23 = ");    "
                out.print(createRelationDeleteCode(rel));
                out.print(source[276]); // 857:37 = ";"
              }
            }
          }
          out.print(source[277]); // 862:2 = "  }"
        }
      } // end w/o db-integrity
    }


    if (generateDeleteReferencedRelations)  {
      if (useDatabaseRefInt) {
        out.print(source[278]); // 872:2 = "  /**   * Deletes all referenced compo..."
        for (Relation rel: getEntity().getRelations()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            if (!rel.isTracked()) {
              throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
            }
            // remove the old deleted composite too, if set
            // we need to replace <varname>Id by <varname>RemovedId in the select statement
            String var = rel.getVariableName();
            String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
            out.print(source[279]); // 889:2 = "    if ("
            out.print(rel.getVariableName());
            out.print(source[280]); // 890:33 = "RemovedId != 0) {      "
            out.print(rel.getClassName());
            out.print(source[281]); // 891:28 = " old = "
            out.print(selectStmt);
            out.print(source[282]); // 891:49 = ";      if (old != null) {        old.d..."
            out.print(rel.getVariableName());
            out.print(source[283]); // 894:33 = "RemovedId = 0;      }    }"
          }
        }
        out.print(source[284]); // 900:2 = "  }"
      }
      else  {
        if (generateLazyDeleteReferencedRelations)  {
          out.print(source[285]); // 906:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                out.print(source[286]); // 930:2 = "    if (delete && "
                out.print(rel.getGetterName());
                out.print(source[287]); // 931:41 = "() != null && !"
                out.print(var);
                out.print(source[288]); // 931:63 = ".isVirgin()) {      delete("
                out.print(var);
                out.print(source[289]); // 932:20 = ");    }"
              }
              // remove the old deleted composite too, if set
              // we need to replace <varname>Id by <varname>RemovedId in the select statement
              String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
              out.print(source[290]); // 939:2 = "    if ("
              out.print(rel.getVariableName());
              out.print(source[291]); // 940:33 = "RemovedId != 0) {      "
              out.print(rel.getClassName());
              out.print(source[292]); // 941:28 = " old = "
              out.print(selectStmt);
              out.print(source[293]); // 941:49 = ";      if (old != null) {        old.d..."
              out.print(rel.getVariableName());
              out.print(source[294]); // 944:33 = "RemovedId = 0;      }    }"
            } // end composite
          }
          out.print(source[295]); // 950:2 = "  }"
        } // end if generateLazyDeleteReferencedRelations

        else  {   // no lazy loading at all
        out.print(source[296]); // 956:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.ALWAYS) {
                throw new WurbelException("internal wurblet logic error");
              }
              else {
                out.print(source[297]); // 969:2 = "    if ("
                out.print(var);
                out.print(source[298]); // 970:15 = " != null) {      delete("
                out.print(var);
                out.print(source[299]); // 971:20 = ");    }"
              }
            }
          }
          out.print(source[300]); // 977:2 = "  }"
        }
      }
    }


    // save composite relations

    if (generateSaveReferencingRelations)  {
      out.print(source[301]); // 988:2 = "  @Override  public void saveReferenci..."
      if (useDatabaseRefInt) {
        out.print(source[302]); // 996:2 = "      deleteRemovedReferencingRelations(..."
      }
      else  {
        out.print(source[303]); // 1001:2 = "      deleteReferencingRelations("
        out.print(generateLazyDeleteReferencingRelations ? "false" : "");
        out.print(source[304]); // 1002:90 = ");"
      }
      out.print(source[305]); // 1005:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          if (rel.isProcessed()) {
            out.print(source[306]); // 1012:2 = "    "
            out.print(var);
            out.print(source[307]); // 1013:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[308]); // 1013:50 = "("
            out.print(var);
            out.print(source[309]); // 1013:58 = ");"
          }
          out.print(source[310]); // 1016:2 = "    if ("
          out.print(var);
          out.print(source[311]); // 1017:15 = " != null) {      getDomainContext().app..."
          out.print(var);
          out.print(source[312]); // 1018:40 = ");"
          if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
            out.print(source[313]); // 1021:2 = "      int ndx = 0;"
          }
          out.print(source[314]); // 1025:2 = "      for ("
          out.print(rel.getClassName());
          out.print(source[315]); // 1026:33 = " obj: "
          out.print(var);
          out.print(source[316]); // 1026:46 = ")  {        obj."
          out.print(createRelationLinkCode(rel));
          out.print(source[317]); // 1027:43 = ";"
          boolean firstSkipped = false;
          for (MethodArgument ma: rel.getMethodArgs()) {
            if (firstSkipped)  {
              out.print(source[318]); // 1032:2 = "        obj."
              out.print(ma.getSetterMethod());
              out.print(source[319]); // 1033:36 = "("
              out.print(ma.getMethodArgument());
              out.print(source[320]); // 1033:63 = ");"
            }
            firstSkipped = true;
          }
          out.print(source[321]); // 1038:2 = "      }      save("
          out.print(var);
          out.print(source[322]); // 1040:18 = ", "
          out.print(rel.isTracked() ? "true" : "false");
          out.print(source[323]); // 1040:58 = ");    }"
        }
      }
      out.print(source[324]); // 1045:2 = "  }"
    }


    if (generateSaveReferencedRelations)  {
      out.print(source[325]); // 1052:2 = "  @Override  public void saveReference..."
      if (getEntity().isRootEntity()) {
        // need a valid id to store in rootId of composite object relations
        out.print(source[326]); // 1059:2 = "    reserveId();"
      }
      out.print(source[327]); // 1063:2 = "    super.saveReferencedRelations(update..."
      if (useDatabaseRefInt) {
        out.print(source[328]); // 1068:2 = "      deleteRemovedReferencedRelations()..."
      }
      else  {
        out.print(source[329]); // 1073:2 = "      deleteReferencedRelations("
        out.print(generateLazyDeleteReferencedRelations ? "false" : "");
        out.print(source[330]); // 1074:88 = ");"
      }
      out.print(source[331]); // 1077:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[332]); // 1083:2 = "    getDomainContext().applyTo("
          out.print(var);
          out.print(source[333]); // 1084:38 = ");"
          if (rel.isProcessed()) {
            out.print(source[334]); // 1087:2 = "    "
            out.print(var);
            out.print(source[335]); // 1088:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[336]); // 1088:50 = "("
            out.print(var);
            out.print(source[337]); // 1088:58 = ");"
          }
          if (rel.isTracked())  {
            out.print(source[338]); // 1092:2 = "    if ("
            out.print(var);
            out.print(source[339]); // 1093:15 = " != null && "
            out.print(var);
            out.print(source[340]); // 1093:34 = ".isModified()) {      save("
            out.print(var);
            out.print(source[341]); // 1094:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[342]); // 1095:50 = "("
            out.print(var);
            out.print(source[343]); // 1095:58 = ".getId());    }"
          }
          else  {
            out.print(source[344]); // 1100:2 = "    if ("
            out.print(var);
            out.print(source[345]); // 1101:15 = " != null) {      save("
            out.print(var);
            out.print(source[346]); // 1102:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[347]); // 1103:50 = "("
            out.print(var);
            out.print(source[348]); // 1103:58 = ".getId());    }"
          }
        }
      }
      out.print(source[349]); // 1109:2 = "  }"
    }



    // generate code to validate
    if (generateValidate)  {
      out.print(source[350]); // 1118:2 = "  @Override  public List<ValidationRes..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[351]); // 1127:2 = "    if ("
          out.print(var);
          out.print(source[352]); // 1128:15 = " != null) {"
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[353]); // 1131:2 = "      results.addAll(ValidationUtilities..."
            out.print(rel.getVariableName());
            out.print(source[354]); // 1133:41 = ", validationPath + "."
            out.print(var);
            out.print(source[355]); // 1133:69 = "", scope));"
          }
          else  {
            out.print(source[356]); // 1137:2 = "      results.addAll("
            out.print(rel.getVariableName());
            out.print(source[357]); // 1138:46 = ".validate(validationPath + "."
            out.print(var);
            out.print(source[358]); // 1138:82 = "", scope));"
          }
          out.print(source[359]); // 1141:2 = "    }"
        }
      }
      out.print(source[360]); // 1146:2 = "    return results;  }"
    }



    // generate code to check set the immutable flag
    if (generateSetImmutable)  {
      out.print(source[361]); // 1156:2 = "  @Override  public void setImmutable(..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          out.print(source[362]); // 1164:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[363]); // 1165:33 = " != null) {      "
          out.print(rel.getVariableName());
          out.print(source[364]); // 1166:31 = ".setImmutable(immutable);    }"
        }
      }
      out.print(source[365]); // 1171:2 = "  }"
    }



    // generate code to check for modifications
    if (generateIsModified)  {
      out.print(source[366]); // 1180:2 = "  @Override  public boolean isModified..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[367]); // 1189:2 = "           || isModified("
            out.print(rel.getVariableName());
            out.print(source[368]); // 1190:50 = ")"
          }
          else  {
            out.print(source[369]); // 1194:2 = "           || "
            out.print(rel.getVariableName());
            out.print(source[370]); // 1195:39 = " != null && "
            out.print(rel.getVariableName());
            out.print(source[371]); // 1195:76 = ".isModified()"
          }
        }
      }
      out.print(source[372]); // 1200:2 = "           ;  }"
    }

    if (generateIsUpdateNecessary) {
      out.print(source[373]); // 1207:2 = "  @Override  protected boolean isUpdat..."
      for (Relation rel: getEntity().getRelations()) {
        Attribute countAttribute = rel.getCountAttribute();
        if (countAttribute != null) {
          out.print(source[374]); // 1215:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[375]); // 1216:33 = " != null) {      "
          out.print(countAttribute.getSetterName());
          out.print(source[376]); // 1217:40 = "("
          out.print(rel.getVariableName());
          out.print(source[377]); // 1217:66 = ".size());    }"
        }
      }
      out.print(source[378]); // 1222:2 = "    return super.isUpdateNecessary();  ..."
    }

    if (getEntity().isDeeplyReferenced()) {
      List<Relation> deepRelations = new ArrayList<>();
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite() && rel.getForeignEntity().isDeeplyReferenced()) {
          deepRelations.add(rel);
        }
      }
      if (!deepRelations.isEmpty()) {
        out.print(source[379]); // 1236:2 = "  @Override  public boolean isReferenc..."
        for (Relation rel: deepRelations) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[380]); // 1247:2 = "    for ("
            out.print(rel.getForeignEntity());
            out.print(source[381]); // 1248:35 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[382]); // 1248:64 = "()) {      if (obj.isReferenced()) {  ..."
          }
          else {
            out.print(source[383]); // 1256:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[384]); // 1257:31 = "() != null && "
            out.print(rel.getGetterName());
            out.print(source[385]); // 1257:68 = "().isReferenced()) {      return true;..."
          }
        }
        out.print(source[386]); // 1263:2 = "    return false;  }"
      }
    }



    // override isComposite()
    if (generateIsComposite)  {
      out.print(source[387]); // 1275:2 = "  @Override  public boolean isComposit..."
    }


    //  load all components
    if (generateLoadComponents)  {

      out.print(source[388]); // 1289:2 = "  @Override  public IdentifiableMap<? ..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[389]); // 1307:2 = "    if (!onlyLoaded || "
            out.print(var);
            out.print(source[390]); // 1308:30 = "Loaded) {"
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[391]); // 1311:2 = "      count += addComponents(components,..."
              out.print(rel.getGetterName());
              out.print(source[392]); // 1312:64 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[393]); // 1316:2 = "      if ("
              out.print(rel.getGetterName());
              out.print(source[394]); // 1317:33 = "() != null) {        count += ((Abstrac..."
              out.print(var);
              out.print(source[395]); // 1318:57 = ".getPersistenceDelegate()).addComponents..."
            }
            out.print(source[396]); // 1322:2 = "    }"
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[397]); // 1328:2 = "    count += addComponents(components, "
              out.print(rel.getGetterName());
              out.print(source[398]); // 1329:62 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[399]); // 1333:2 = "    if ("
              out.print(rel.getGetterName());
              out.print(source[400]); // 1334:31 = "() != null) {      count += ((AbstractP..."
              out.print(var);
              out.print(source[401]); // 1335:55 = ".getPersistenceDelegate()).addComponents..."
            }
          }
        }
      }
      out.print(source[402]); // 1342:2 = "    return count;  }"
    }



    //  insert all components
    if (generateInsertComponents)  {

      out.print(source[403]); // 1353:2 = "  @Override  public void insertPlainWi..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[404]); // 1361:2 = "    if ("
          out.print(rel.getGetterName());
          out.print(source[405]); // 1362:31 = "() != null) {      ((AbstractPersistent..."
          out.print(var);
          out.print(source[406]); // 1363:46 = ".getPersistenceDelegate()).insertPlainWi..."
        }
      }
      out.print(source[407]); // 1368:2 = "    insertPlain();"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          out.print(source[408]); // 1374:2 = "    insertPlainWithComponents("
          out.print(rel.getGetterName());
          out.print(source[409]); // 1375:53 = "());"
        }
      }
      out.print(source[410]); // 1379:2 = "  }"
    }


    //  delete all components
    if (generateDeleteComponents)  {

      out.print(source[411]); // 1388:2 = "  @Override  public void deletePlainWi..."
      if (useDatabaseRefInt) {
        out.print(source[412]); // 1394:2 = "    // components are deleted via databa..."
      }
      else {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
            out.print(source[413]); // 1402:2 = "    deletePlainWithComponents("
            out.print(rel.getGetterName());
            out.print(source[414]); // 1403:53 = "());"
          }
        }
      }
      out.print(source[415]); // 1408:2 = "    deletePlain();"
      if (!useDatabaseRefInt) {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[416]); // 1415:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[417]); // 1416:31 = "() != null) {      ((AbstractPersistent..."
            out.print(var);
            out.print(source[418]); // 1417:46 = ".getPersistenceDelegate()).deletePlainWi..."
          }
        }
      }
      out.print(source[419]); // 1423:2 = "  }"
    }



    // mark object and all components deleted
    if (generateMarkDeleted)  {
      out.print(source[420]); // 1432:2 = "  @Override  public void markDeleted()..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[421]); // 1441:2 = "    markDeleted("
          out.print(var);
          out.print(source[422]); // 1442:23 = ");"
        }
      }
      out.print(source[423]); // 1446:2 = "  }"
    }


    // generate snapshot methods
    if (generateSnapshot) {
      out.print(source[424]); // 1454:2 = "  /**   * Updates the components in sn..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[425]); // 1462:100 = " snapshot) {    super.createComponentsI..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() &&
            (rel.getRelationType() == RelationType.OBJECT || rel.isTracked())) {
              out.print(source[426]); // 1469:2 = "    if ("
              out.print(var);
              out.print(source[427]); // 1470:15 = " != null) {      snapshot."
              out.print(var);
              out.print(source[428]); // 1471:22 = "Snapshot = "
              out.print(var);
              out.print(source[429]); // 1471:40 = ".createSnapshot();    }"
        }
      }
      out.print(source[430]); // 1476:2 = "  }  /**   * Reverts all components o..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[431]); // 1484:100 = " snapshot) {    super.revertComponentsT..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          Relation nmRel = rel.getNmRelation();
          String nmVar = null;
          if (nmRel != null) {
            if (rel.getNmMethodName() != null) {
              nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
            }
            else  {
              nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
            }
          }
          out.print(source[432]); // 1500:2 = "    "
          out.print(var);
          out.print(source[433]); // 1501:11 = " = snapshot."
          out.print(var);
          out.print(source[434]); // 1501:30 = ";"
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[435]); // 1505:2 = "    if ("
              out.print(var);
              out.print(source[436]); // 1506:15 = " != null) {      "
              out.print(var);
              out.print(source[437]); // 1507:13 = ".revertToSnapshot(snapshot."
              out.print(var);
              out.print(source[438]); // 1507:47 = "Snapshot);    }"
            }
          }
          else  {
            out.print(source[439]); // 1513:2 = "    if ("
            out.print(var);
            out.print(source[440]); // 1514:15 = " != null) {      "
            out.print(var);
            out.print(source[441]); // 1515:13 = ".revertToSnapshot(snapshot."
            out.print(var);
            out.print(source[442]); // 1515:47 = "Snapshot);    }"
          }
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[443]); // 1520:2 = "    "
            out.print(var);
            out.print(source[444]); // 1521:11 = "Loaded = snapshot."
            out.print(var);
            out.print(source[445]); // 1521:36 = "Loaded;"
          }
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[446]); // 1525:2 = "    "
            out.print(var);
            out.print(source[447]); // 1526:11 = "RemovedId = snapshot."
            out.print(var);
            out.print(source[448]); // 1526:39 = "RemovedId;"
          }
          if (nmVar != null) {
            out.print(source[449]); // 1530:2 = "    "
            out.print(nmVar);
            out.print(source[450]); // 1531:13 = " = null;"
          }
        }
      }
      out.print(source[451]); // 1536:2 = "  }"
    }


    if (generateIsReferencing && isEntityPersistable()) {
      for (Relation rel: getEntity().getTableRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          String tagName = "isReferencing" + rel.getClassName() + "By" +
                           StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[452]); // 1549:2 = "  // Determines whether any "
                           out.print(pdoName);
                           out.print(source[453]); // 1551:39 = " references given "
                           out.print(rel.getClassName());
                           out.print(source[454]); // 1551:79 = "  // @wurblet "
                           out.print(tagName);
                           out.print(source[455]); // 1552:26 = " PdoIsReferencing "
                           out.print(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[456]); // 1552:99 = ""
        }
      }
    }

    if (generateSelects && isEntityPersistable()) {
      Set<String> wurbletArgSet = new HashSet<>();   // to avoid duplicates if args= is used
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null) {
            // force tracked even if related object is not tracked
            String trackedOption = rel.isTracked() ? "--tracked " : "";
            String joins = "";
            if (rel.getNmName() != null) {
              Relation join = rel.getNmRelation();
              if (join != null && join.getRelationType() == RelationType.OBJECT &&
                  join.getSelectionType() == SelectionType.LAZY &&
                  !join.isComposite() && join.isSerialized()) {
                joins = " *" + rel.getNmName();
              }
            }
            // add eager joins, if any
            for (Relation eRel: getEntity().getRelationsIncludingInherited()) {
              if (eRel.getSelectionType() == SelectionType.EAGER) {
                joins += " *" + eRel.getName();
              }
            }

            String extraWurbletOptions = rel.getSelectionWurbletArguments();
            if (extraWurbletOptions == null) {
              extraWurbletOptions = "";
            }
            else {
              extraWurbletOptions = " " + extraWurbletOptions;
            }
            String wurbletArgs = createRelationWurbletArgString(rel);
            if (wurbletArgSet.add(wurbletArgs)) {
              out.print(source[457]); // 1594:2 = "  // selects "
              out.print(rel);
              out.print(source[458]); // 1596:20 = ""
              if (rel.isReversed()) {
                out.print(source[459]); // 1599:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[460]); // 1600:54 = " PdoSelectUnique "
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[461]); // 1600:118 = ""
              }
              else {
                out.print(source[462]); // 1604:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[463]); // 1605:54 = " PdoSelectList "
                out.print(trackedOption);
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[464]); // 1605:133 = ""
              }
            }
          }
        }
      }
    }

    if (generateDeletes && isEntityPersistable()) {
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null && rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[465]); // 1622:2 = "  // deletes "
            out.print(rel);
            out.print(source[466]); // 1624:20 = "  // @wurblet "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[467]); // 1625:58 = " PdoDeleteBy "
            out.print(createRelationWurbletArgString(rel));
            out.print(source[468]); // 1625:110 = ""
          }
        }
      }
    }

    if (generateAddReferencing) {
      List<Relation> refRels = new ArrayList<>();
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          refRels.add(rel);
        }
      }
      if (!refRels.isEmpty()) {
        out.print(source[469]); // 1642:2 = "  // add referencing classes and their ..."
        if (getEntity().isAbstract()) {
          out.print(source[470]); // 1648:2 = "    @SuppressWarnings("unchecked")"
        }
        out.print(source[471]); // 1652:2 = "    AbstractPersistentObject<?,?> po = (..."
        out.print(pdoName);
        out.print(source[472]); // 1654:30 = ".class).getPersistenceDelegate();"
      // register referencing classes and the methods
      for (Relation rel: refRels) {
        String methodName = "isReferencing" + rel.getClassName() + "By" +
                            StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
        for (Entity leaf: rel.getEntity().getLeafEntities()) {
          out.print(source[473]); // 1661:2 = "    po.addReferencingClass("
          out.print(leaf.getName());
          out.print(source[474]); // 1662:45 = ".class, ""
          out.print(methodName);
          out.print(source[475]); // 1662:68 = "");"
        }
      }
      out.print(source[476]); // 1666:2 = "  }"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
