// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to check whether a low-level persistent object is referenced.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoIsReferencing [--private] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;] &lt;expression&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoIsReferencing extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    assertEntityIsPersistable();

    String className    = getClassName();
    String methodName   = getMethodName();
    String pdoName      = getPdoClassName();

    String  classVar    = null;
    String  append      = null;
    String  scope       = "public";

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (scope.equals("private")) {
      setRemote(false);
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    if (methodName == null)     throw new WurbelException("can't determine <methodname>");
    if (className == null)      throw new WurbelException("can't determine <classname>");
    if (pdoName == null)        throw new WurbelException("can't determine PDO interface");
    if (getExpressionArguments().isEmpty()) {
      throw new WurbelException("no keys given");
    }

    String params = buildMethodParameters();
    String iparms = buildInvocationParameters();
    String statementId = createStatementId();

    Entity selectingEntity = null;
    for (WurbletArgument key : getExpressionArguments()) {
      if (selectingEntity == null) {
        selectingEntity = key.getAttribute().getEntity();
      }
      else if (!selectingEntity.equals(key.getAttribute().getEntity())) {
        throw new WurbelException("all keys must belong to the same entity");
      }
    }

    out.print(source[0]); // 74:2 = "  "
    out.print(scope);
    out.print(source[1]); // 75:11 = " boolean "
    out.print(methodName);
    out.print(source[2]); // 75:34 = "("
    out.print(params);
    out.print(source[3]); // 75:45 = ") {"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplStream();
      PrintStream remoteOut = genInc.getRemoteStream();
      out.print(source[4]); // 82:2 = "    if (getSession().isRemote())  {    ..."
      if (getContextAttribute() != null)  {
        remoteOut.print(source[5]); // 89:16 = "  boolean "
        remoteOut.print(methodName);
        remoteOut.print(source[6]); // 90:24 = "("
        remoteOut.print(pcs(params, "DomainContext context"));
        remoteOut.print(source[7]); // 90:65 = ") throws RemoteException;"
        implOut.print(source[8]); // 91:14 = "  @Override  public boolean "
        implOut.print(methodName);
        implOut.print(source[9]); // 94:31 = "("
        implOut.print(pcs(params, "DomainContext context"));
        implOut.print(source[10]); // 94:72 = ") throws RemoteException {    try {   ..."
        implOut.print(methodName);
        implOut.print(source[11]); // 97:36 = "("
        implOut.print(iparms);
        implOut.print(source[12]); // 97:47 = ");    }    catch (Exception e) {     ..."
        out.print(source[13]); // 103:6 = "        return getRemoteDelegate()."
        out.print(methodName);
        out.print(source[14]); // 104:49 = "("
        out.print(pcs(iparms, "getDomainContext()"));
        out.print(source[15]); // 104:87 = ");"
      } // end if contextLine != null
      else  {
        remoteOut.print(source[16]); // 109:16 = "  boolean "
        remoteOut.print(methodName);
        remoteOut.print(source[17]); // 110:24 = "("
        remoteOut.print(params);
        remoteOut.print(source[18]); // 110:35 = ") throws RemoteException;"
        implOut.print(source[19]); // 111:14 = "  @Override  public boolean "
        implOut.print(methodName);
        implOut.print(source[20]); // 114:31 = "("
        implOut.print(params);
        implOut.print(source[21]); // 114:42 = ") throws RemoteException {"
        implOut.print(source[22]); // 115:14 = "    try {      return dbObject."
        implOut.print(methodName);
        implOut.print(source[23]); // 117:36 = "("
        implOut.print(iparms);
        implOut.print(source[24]); // 117:47 = ");    }    catch (Exception e) {     ..."
        out.print(source[25]); // 123:6 = "        return getRemoteDelegate()."
        out.print(methodName);
        out.print(source[26]); // 124:49 = "("
        out.print(iparms);
        out.print(source[27]); // 124:60 = ");"
      }
      out.print(source[28]); // 127:2 = "      }      catch (RemoteException e) ..."
    } // end if remote

    String cvars = "false";
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
      cvars = deriveClassNameForEntity(selectingEntity) + ".CLASSVARIABLES, false";
    }
    out.print(source[29]); // 141:2 = "    PreparedStatementWrapper st = getPre..."
    out.print(classVar);
    out.print(statementId);
    out.print(source[30]); // 142:82 = ",      () -> {        StringBuilder sq..."
    out.print(cvars);
    out.print(source[31]); // 144:60 = ");"
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[32]); // genwhere.incl:3:2 = "        boolean classIdRequired = isClas..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[33]); // genwhere.incl:15:2 = "        sql.append(Backend.SQL_AND);   ..."
        out.print(getContextAttribute().getName().toUpperCase());
        out.print(source[34]); // genwhere.incl:17:71 = ");        sql.append(Backend.SQL_EQUAL_..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[35]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[36]); // genwhere.incl:32:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[37]); // genwhere.incl:36:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = "CN_" + rel.getAttribute().getName().toUpperCase();
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = "CN_" + rel.getForeignAttribute().getName().toUpperCase();
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append("CN_").append(mattr.getName().toUpperCase()).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                        String name = attr.getName().toUpperCase() + sp.getPostfix();
                        boolean mainColumn = sp.getPostfix().isEmpty();
                        if (!mainColumn) {
                          buf.append("           .append(Backend.SQL_AND)\n")
                             .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                             .append(rightClass).append("CN_").append(name).append("))\n")
                             .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                        }
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append("CN_").append(methodArg.getAttribute().getName().toUpperCase()).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEntity());
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                buf.append("        sql.append(").append(compKeyClass).
                    append(".CLASSVARIABLES.getColumnName(").
                    append(compKeyClass).append(".CN_").append(name).append("))\n");
                if (mainColumn) {
                  buf.append("           .append(").append(arg.getRelop()).append(");\n");
                }
                else {
                  buf.append("           .append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }
            else {
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (isPathAllowed()) {
                  if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                     buf.append("        sql.append(");
                     buf.append(deriveClassNameForEntity(attr.getEntity()));
                     buf.append(".CLASSVARIABLES.getColumnName(CN_");
                     buf.append(name).append("));\n");
                  }
                  else  {
                    if (isPdo()) {
                      buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                    }
                    else  {
                      buf.append("        sql.append(CN_").append(name).append(");\n");
                    }
                  }
                }
                else  {
                  buf.append("        sql.append(CN_").append(name).append(");\n");
                }
                if (mainColumn) {
                  buf.append("        sql.append(").append(arg.getRelop()).append(");\n");
                }
                else  {
                  buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[38]); // genwhere.incl:237:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[39]); // genwhere.incl:240:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[40]); // genwhere.incl:245:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[41]); // genwhere.incl:255:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[42]); // genwhere.incl:257:25 = ";"
    }
    out.print(source[43]); // 145:37 = "        getBackend().buildSelectSql(sql,..."
    if (append != null) {
      out.print(source[44]); // 149:2 = "        sql.append(' ');        sql.app..."
      out.print(append);
      out.print(source[45]); // 151:29 = ");"
    }
    out.print(source[46]); // 154:2 = "        return sql.toString();      } ..."
    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[47]); // gensetpar.incl:6:2 = "    if (isClassIdRequiredInWhereClause()..."
    }
    if (getContextAttribute() != null) {
      out.print(source[48]); // gensetpar.incl:13:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute()));
      out.print(source[49]); // gensetpar.incl:14:54 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[50]); // gensetpar.incl:14:97 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                if (attr.getOptions().isMapNull())  {
                  out.print(source[51]); // gensetpar.incl:28:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[52]); // gensetpar.incl:29:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[53]); // gensetpar.incl:29:111 = ", true);"
                }
                else  {
                  out.print(source[54]); // gensetpar.incl:33:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[55]); // gensetpar.incl:34:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[56]); // gensetpar.incl:34:111 = ");"
                }
                // for multi column types, such as BMoney/DMoney
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
                  out.print(source[57]); // gensetpar.incl:39:2 = "    ndx++;"
                }
              }
            }
          }
        }
      }


      if (!par.isValueLiterally()) {
        Attribute attr = par.getAttribute();
        if (attr.getOptions().isMapNull())  {
          out.print(source[58]); // gensetpar.incl:53:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[59]); // gensetpar.incl:54:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[60]); // gensetpar.incl:54:86 = ", true);"
        }
        else  {
          out.print(source[61]); // gensetpar.incl:58:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[62]); // gensetpar.incl:59:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[63]); // gensetpar.incl:59:86 = ");"
        }
        // for multi column types, such as BMoney/DMoney
        for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
          out.print(source[64]); // gensetpar.incl:64:2 = "    ndx++;"
        }
      }
    }
    out.print(source[65]); // 159:38 = "    getBackend().setTrailingSelectParame..."
    if (classVar.length() == 0) {
      out.print(source[66]); // 167:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[67]); // 169:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------
}
