// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to copy an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoCopy [--maponly] [--super] [&lt;skiplist&gt;]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--maponly:</em> generates code only for attributes of the entities model file (i.e. not for ID and SERIAL).</li>
 * <li><em>--super:</em> invokes super.copy() to create the object.</li>
 * <li><em>&lt;skiplist&gt;:</em> optional list of attributes and/or relations that must not be copied.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoCopy extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    // main class
    String pdoClass = getEntity().getName();
    char objName = Character.toLowerCase(pdoClass.charAt(0));
    boolean mapOnly = false;
    boolean useSuper = false;

    for (String arg: getOptionArgs()) {
      switch (arg) {
        case "maponly":
          mapOnly = true;
          break;
        case "super":
          useSuper = true;
          break;
      }
    }

    out.print(source[0]); // 36:2 = "  /**   * Creates a copy of this objec..."
    out.print(pdoClass);
    out.print(source[1]); // 43:21 = " copy() {"
    if (useSuper) {
      out.print(source[2]); // 46:2 = "    "
      out.print(pdoClass);
      out.print(source[3]); // 47:16 = " "
      out.print(objName);
      out.print(source[4]); // 47:28 = " = ("
      out.print(pdoClass);
      out.print(source[5]); // 47:44 = ") super.copy();"
    }
    else {
      out.print(source[6]); // 51:2 = "    "
      out.print(pdoClass);
      out.print(source[7]); // 52:16 = " "
      out.print(objName);
      out.print(source[8]); // 52:28 = " = newInstance();"
    }
    for (Attribute attr: getEntity().getAttributes())  {
      String name = attr.getName();
      if (!attr.getOptions().isDerived() && !getArgs().contains(name))  {
        if (attr.getOptions().isSetGet()) {
          if (attr.getDataType().isMutable()) {
            String castStr = attr.getDataType().isDateOrTime() ? ("(" + attr.getJavaType() + ") ") : "";
            out.print(source[9]); // 61:2 = "    "
            out.print(objName);
            out.print(source[10]); // 62:15 = "."
            out.print(attr.getSetterName());
            out.print(source[11]); // 62:40 = "("
            out.print(castStr);
            out.print(attr.getGetterName());
            out.print(source[12]); // 62:76 = "().clone());"
          }
          else  {
            out.print(source[13]); // 66:2 = "    "
            out.print(objName);
            out.print(source[14]); // 67:15 = "."
            out.print(attr.getSetterName());
            out.print(source[15]); // 67:40 = "("
            out.print(attr.getGetterName());
            out.print(source[16]); // 67:65 = "());"
          }
        }
        else  {
          if (attr.getDataType().isMutable()) {
            String castStr = attr.getDataType().isDateOrTime() ? ("(" + attr.getJavaType() + ") ") : "";
            out.print(source[17]); // 74:2 = "    "
            out.print(objName);
            out.print(source[18]); // 75:15 = "."
            out.print(name);
            out.print(source[19]); // 75:24 = " = "
            out.print(castStr);
            out.print(name);
            out.print(source[20]); // 75:46 = ".clone();"
          }
          else  {
            out.print(source[21]); // 79:2 = "    "
            out.print(objName);
            out.print(source[22]); // 80:15 = "."
            out.print(name);
            out.print(source[23]); // 80:24 = " = "
            out.print(name);
            out.print(source[24]); // 80:35 = ";"
          }
        }
      }
    }

    if (!mapOnly)  {
      out.print(source[25]); // 88:2 = "    "
      out.print(objName);
      out.print(source[26]); // 89:15 = ".setId(getId());    "
      out.print(objName);
      out.print(source[27]); // 90:15 = ".setSerial(getSerial());"
    }

    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      if (rel.isComposite() && !getArgs().contains(var)) {
        String type;
        if (rel.getRelationType() == RelationType.LIST) {
          type = (rel.isTracked() ? "TrackedArrayList" : "List") + "<" + rel.getClassName() + ">";
        }
        else  {
          type = rel.getClassName();
        }
        out.print(source[28]); // 104:2 = "    // "
        out.print(rel);
        out.print(source[29]); // 105:14 = "    if ("
        out.print(rel.getGetterName());
        out.print(source[30]); // 106:31 = "() != null) {"
        if (rel.getRelationType() == RelationType.LIST) {
          out.print(source[31]); // 109:2 = "      "
          out.print(objName);
          out.print(source[32]); // 110:17 = "."
          out.print(var);
          out.print(source[33]); // 110:25 = " = ("
          out.print(type);
          out.print(source[34]); // 110:37 = ") AbstractPersistentObject.copyCollectio..."
          out.print(var);
          out.print(source[35]); // 110:86 = ");"
        }
        else  {
          out.print(source[36]); // 114:2 = "      "
          out.print(objName);
          out.print(source[37]); // 115:17 = "."
          out.print(var);
          out.print(source[38]); // 115:25 = " = "
          out.print(var);
          out.print(source[39]); // 115:35 = ".copy();"
        }
        out.print(source[40]); // 118:2 = "    }"
        if (rel.getSelectionType() == SelectionType.LAZY) {
          out.print(source[41]); // 122:2 = "    "
          out.print(objName);
          out.print(source[42]); // 123:15 = "."
          out.print(var);
          out.print(source[43]); // 123:23 = "Loaded = true;"
        }
      }
    }
    out.print(source[44]); // 128:2 = "    "
    out.print(objName);
    out.print(source[45]); // 129:15 = ".setModified(false);    return "
    out.print(objName);
    out.print(source[46]); // 130:22 = ";  }"
  }

  // ----------------- end wurblet code -----------------
}
