// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to select a list of low-level persistent objects.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DbSelectList
 *     [--private] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     [--sort] [--lock] [--resultset] [--bounded] [--limit] [--offset]
 *     &lt;expression&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>--sort:</em> sort according to orderBy()-method.</li>
 * <li><em>--lock:</em> generates SELECT FOR UPDATE.</li>
 * <li><em>--limit:</em> adds a parameter to limit the number of objects.</li>
 * <li><em>--offset:</em> adds a parameter to skip the first objects.</li>
 * <li><em>--resultset:</em> returns the ResultSetWrapper instead of a List.</li>
 * <li><em>--bounded:</em> returns a bounded List&lt;? extends mainClass&gt; instead of List&lt;mainClass&gt;.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class DbSelectList extends DbModelWurblet {

  public DbSelectList() {
    setConfiguration("pathAllowed");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String className = getClassName();
    String methodName = getMethodName();
    String delegateCast = "(" + className + "RemoteDelegate)";

    String  scope       = "public";
    String  classVar    = null;
    boolean sort        = false;
    boolean lock        = false;
    String  append      = null;
    boolean limit       = false;
    boolean offset      = false;
    boolean bounded     = false;
    boolean resultSet   = false;

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
        setRemote(false);
      }
      else if (arg.equals("sort")) {
        if (isWithDefaultSorting()) {
          if (isWithSorting()) {
            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
          }
          sort = true;
        }
        else {
          throw new WurbelException("no sorting configured in model for " + getEntity());
        }
      }
      else if (arg.equals("lock")) {
        lock = true;
      }
      else if (arg.equals("limit")) {
        limit = true;
      }
      else if (arg.equals("offset")) {
        offset = true;
      }
      else if (arg.equals("bounded")) {
        bounded = true;
      }
      else if (arg.equals("resultset")) {
        resultSet = true;
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (resultSet) {
      setRemote(false);     // disable remoting for sure
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    String params = buildMethodParameters(limit, offset);
    String iparms = buildInvocationParameters(limit, offset);
    String statementId = createStatementId();

    String listType     = resultSet ? "ResultSetWrapper" :
                            ((isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + className + ">");
    String varListType  = (isTracked() ? "TrackedArrayList" : "List") + "<" + className + ">";
    String rmiListType  = (isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + (isGenerified() ? "P" : className) + ">";

    out.print(source[0]); // 103:2 = "  "
    out.print(scope);
    out.print(source[1]); // 104:11 = " "
    out.print(listType);
    out.print(source[2]); // 104:24 = " "
    out.print(methodName);
    out.print(source[3]); // 104:39 = "("
    out.print(params);
    out.print(source[4]); // 104:50 = ") {    Db db = getSession();"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut      = genInc.getImplStream();
      PrintStream remoteOut    = genInc.getRemoteStream();
      out.print(source[5]); // 112:2 = "    if (db.isRemote())  {      // invok..."
      remoteOut.print(source[6]); // 116:16 = "  "
      remoteOut.print(rmiListType);
      remoteOut.print(source[7]); // 117:17 = " "
      remoteOut.print(methodName);
      remoteOut.print(source[8]); // 117:32 = "("
      remoteOut.print(params);
      remoteOut.print(source[9]); // 117:43 = ") throws RemoteException;"
      implOut.print(source[10]); // 118:14 = "  @Override  public "
      implOut.print(rmiListType);
      implOut.print(source[11]); // 121:24 = " "
      implOut.print(methodName);
      implOut.print(source[12]); // 121:39 = "("
      implOut.print(params);
      implOut.print(source[13]); // 121:50 = ") throws RemoteException {    try {   ..."
      implOut.print(methodName);
      implOut.print(source[14]); // 123:36 = "("
      implOut.print(iparms);
      implOut.print(source[15]); // 123:47 = ");    }    catch (Exception e) {     ..."
      out.print(source[16]); // 129:6 = "        "
      out.print(listType);
      out.print(source[17]); // 130:20 = " list = ("
      out.print(delegateCast);
      out.print(source[18]); // 130:45 = " getRemoteDelegate()).                "
      out.print(methodName);
      out.print(source[19]); // 131:30 = "("
      out.print(iparms);
      out.print(source[20]); // 131:41 = ");        db.applyTo(list);        ret..."
    } // end if remote
     out.print(source[21]); // 142:2 = "    PreparedStatementWrapper st = getPre..."
     out.print(classVar);
     out.print(statementId);
     out.print(source[22]); // 143:82 = ",      () -> {        StringBuilder sq..."
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[23]); // genwhere.incl:3:2 = "        boolean classIdRequired = isClas..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[24]); // genwhere.incl:15:2 = "        sql.append(Backend.SQL_AND);   ..."
        out.print(getContextAttribute().getName().toUpperCase());
        out.print(source[25]); // genwhere.incl:17:71 = ");        sql.append(Backend.SQL_EQUAL_..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[26]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[27]); // genwhere.incl:32:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[28]); // genwhere.incl:36:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = "CN_" + rel.getAttribute().getName().toUpperCase();
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = "CN_" + rel.getForeignAttribute().getName().toUpperCase();
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append("CN_").append(mattr.getName().toUpperCase()).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                        String name = attr.getName().toUpperCase() + sp.getPostfix();
                        boolean mainColumn = sp.getPostfix().isEmpty();
                        if (!mainColumn) {
                          buf.append("           .append(Backend.SQL_AND)\n")
                             .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                             .append(rightClass).append("CN_").append(name).append("))\n")
                             .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                        }
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append("CN_").append(methodArg.getAttribute().getName().toUpperCase()).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEntity());
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                buf.append("        sql.append(").append(compKeyClass).
                    append(".CLASSVARIABLES.getColumnName(").
                    append(compKeyClass).append(".CN_").append(name).append("))\n");
                if (mainColumn) {
                  buf.append("           .append(").append(arg.getRelop()).append(");\n");
                }
                else {
                  buf.append("           .append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }
            else {
              for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
                String name = attr.getName().toUpperCase() + sp.getPostfix();
                boolean mainColumn = sp.getPostfix().isEmpty();
                if (!mainColumn) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (isPathAllowed()) {
                  if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                     buf.append("        sql.append(");
                     buf.append(deriveClassNameForEntity(attr.getEntity()));
                     buf.append(".CLASSVARIABLES.getColumnName(CN_");
                     buf.append(name).append("));\n");
                  }
                  else  {
                    if (isPdo()) {
                      buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                    }
                    else  {
                      buf.append("        sql.append(CN_").append(name).append(");\n");
                    }
                  }
                }
                else  {
                  buf.append("        sql.append(CN_").append(name).append(");\n");
                }
                if (mainColumn) {
                  buf.append("        sql.append(").append(arg.getRelop()).append(");\n");
                }
                else  {
                  buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[29]); // genwhere.incl:237:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[30]); // genwhere.incl:240:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[31]); // genwhere.incl:245:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[32]); // genwhere.incl:255:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[33]); // genwhere.incl:257:25 = ";"
    }
    out.print(source[34]); // 146:37 = "        getBackend().buildSelectSql(sql,..."
    out.print(lock ? "true" : "false");
    out.print(source[35]); // 147:68 = ", "
    out.print(limit ? "limit" : "0");
    out.print(source[36]); // 147:95 = ", "
    out.print(offset ? "offset" : "0");
    out.print(source[37]); // 147:124 = ");"
    if (sort) {
      out.print(source[38]); // 150:2 = "        String orderSuffix = orderBy();..."
    }
    if (append != null)  {
      out.print(source[39]); // 158:2 = "        sql.append(' ');        sql.app..."
      out.print(append);
      out.print(source[40]); // 160:29 = ");"
    }
    out.print(source[41]); // 163:2 = "        return sql.toString();      } ..."
    if (limit || offset) {
      out.print(source[42]); // 169:2 = "    int ndx = getBackend().setLeadingSel..."
      out.print(limit ? "limit" : "0");
      out.print(source[43]); // 170:83 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[44]); // 170:112 = ");"
    }
    else  {
      out.print(source[45]); // 174:2 = "    int ndx = 1;"
    }
    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[46]); // gensetpar.incl:6:2 = "    if (isClassIdRequiredInWhereClause()..."
    }
    if (getContextAttribute() != null) {
      out.print(source[47]); // gensetpar.incl:13:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute()));
      out.print(source[48]); // gensetpar.incl:14:54 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[49]); // gensetpar.incl:14:97 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                if (attr.getOptions().isMapNull())  {
                  out.print(source[50]); // gensetpar.incl:28:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[51]); // gensetpar.incl:29:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[52]); // gensetpar.incl:29:111 = ", true);"
                }
                else  {
                  out.print(source[53]); // gensetpar.incl:33:2 = "    st."
                  out.print(createJdbcSetterName(attr));
                  out.print(source[54]); // gensetpar.incl:34:37 = "(ndx++, "
                  out.print(getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                  out.print(source[55]); // gensetpar.incl:34:111 = ");"
                }
                // for multi column types, such as BMoney/DMoney
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
                  out.print(source[56]); // gensetpar.incl:39:2 = "    ndx++;"
                }
              }
            }
          }
        }
      }


      if (!par.isValueLiterally()) {
        Attribute attr = par.getAttribute();
        if (attr.getOptions().isMapNull())  {
          out.print(source[57]); // gensetpar.incl:53:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[58]); // gensetpar.incl:54:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[59]); // gensetpar.incl:54:86 = ", true);"
        }
        else  {
          out.print(source[60]); // gensetpar.incl:58:2 = "    st."
          out.print(createJdbcSetterName(attr));
          out.print(source[61]); // gensetpar.incl:59:37 = "(ndx++, "
          out.print(getJdbcCode(attr, par.getJdbcValue()));
          out.print(source[62]); // gensetpar.incl:59:86 = ");"
        }
        // for multi column types, such as BMoney/DMoney
        for (int p = 1; p < attr.getDataType().getSqlTypes().length; p++) {
          out.print(source[63]); // gensetpar.incl:64:2 = "    ndx++;"
        }
      }
    }
    if (limit || offset) {
      out.print(source[64]); // 182:2 = "    getBackend().setTrailingSelectParame..."
      out.print(limit ? "limit" : "0");
      out.print(source[65]); // 183:79 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[66]); // 183:108 = ");"
    }

    if (resultSet) {
      out.print(source[67]); // 188:2 = "    return st.executeQuery();"
    }
    else  {
      out.print(source[68]); // 193:2 = "    try (ResultSetWrapper rs = st.execut..."
      if (isTracked())  {
        out.print(source[69]); // 197:2 = "      "
        out.print(varListType);
        out.print(source[70]); // 198:21 = " list = new TrackedArrayList<>();"
      }
      else  {
        out.print(source[71]); // 202:2 = "      "
        out.print(varListType);
        out.print(source[72]); // 203:21 = " list = new ArrayList<>();"
      }

    // optimization: newInstance() is 10 times slower than new BlahObject()
    out.print(source[73]); // 208:2 = "      boolean derived = getClass() != "
    out.print(className);
    out.print(source[74]); // 209:51 = ".class;      while (rs.next()) {      ..."
    out.print(className);
    out.print(source[75]); // 211:21 = " obj = derived ? newInstance() : new "
    out.print(className);
    out.print(source[76]); // 211:71 = "(db);        obj = obj.readFromResultSe..."
      if (isTracked())  {
        out.print(source[77]); // 219:2 = "      list.setModified(false);"
      }
      out.print(source[78]); // 223:2 = "      return list;    }"
    }
    out.print(source[79]); // 228:2 = "  }"
    if (classVar.length() == 0) {
      out.print(source[80]); // 232:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[81]); // 234:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------
}
