// wurblet generated by Wurbelizer 2.1.0, see http://www.wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generates the code to setup the class-variables for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ClassVariables
 * <p>
 * For more options, see {@link DbModelWurblet}.
 */
public class ClassVariables extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {
    String pdoName    = getPdoClassName();
    String className  = getClassName();
    boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;
    Entity superEntity = getEntity().getSuperEntity();
    List<Entity> subEntities = getEntity().getSubEntities();
    out.print(source[0]); // 17:2 = "  /** Variables common to all instances ..."
    out.print(className);
    out.print(source[1]); // 18:56 = ". */"
    if (getEntity().isAbstract() && getEntity().getInheritanceType().isMappingToNoTable()) {  // PLAIN
    out.print(source[2]); // 21:2 = "  /** no classvariables for "
    out.print(getEntity().getInheritanceType());
    out.print(source[3]); // 22:64 = " inheritance. */"
    }
    else  {
      String cvType = "PersistentObjectClassVariables";
      String cvImpliedType = cvType;
      if (!getEntity().isAbstract()) {
        cvType += "<" + pdoName + ", " + className + ">";
        cvImpliedType += "<>";
      }
      String alias = getEntity().getTableAlias();
      String strAlias = alias != null ? "\"" + alias + "\"" : "null";
      String superCV = "null";

      List<Relation> joins = getEagerRelations();

      if (superEntity != null && !superEntity.getInheritanceType().isMappingToNoTable() ||
          !subEntities.isEmpty()) {
        if (superEntity != null) {
          superCV = deriveClassNameForEntity(superEntity) + ".CLASSVARIABLES";
          out.print(source[4]); // 42:2 = "  @SuppressWarnings({"unchecked", "Field..."
        }
        else {
          out.print(source[5]); // 47:2 = "  @SuppressWarnings("unchecked")"
        }
      }
      else if (joins != null) {
        out.print(source[6]); // 53:2 = "  @SuppressWarnings("unchecked")"
      }
      out.print(source[7]); // 57:2 = "  public static final "
      out.print(cvType);
      out.print(source[8]); // 58:32 = " CLASSVARIABLES =            new "
      out.print(cvImpliedType);
      out.print(source[9]); // 59:33 = "(                    "
      out.print(pdoName);
      out.print(source[10]); // 60:31 = ".class,                    "
      out.print(className);
      out.print(source[11]); // 61:33 = ".class,                    "
      out.print(strAlias);
      out.print(source[12]); // 62:32 = ",                    "
      out.print(superCV);
      out.print(source[13]); // 63:31 = ","
      if (joins != null) {
        String poImpl = deriveClassNameForEntity(getEntity());
        out.print(source[14]); // 67:2 = "                    Arrays.asList("
        int joinCount = 0;
        for (Relation join: joins) {
          if (join.getMethodArgs().size() > 1) {
            throw new ModelException("eager relations with 'args=...' are currently not supported", join);
          }
          joinCount++;
          String joinClass = join.getForeignEntity().getName();
          String joinAlias = join.getForeignEntity().getTopSuperEntity().getTableAlias();
          if (join.getForeignEntity().isAbstract()) {
            if (join.getRelationType() == RelationType.LIST) {
              out.print(source[15]); // 80:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[16]); // 81:58 = ".id", "e_"
              out.print(joinCount);
              out.print(source[17]); // 81:80 = "."
              out.print(join.getForeignAttribute().getColumnName());
              out.print(source[18]); // 81:127 = "", "
              out.print(joinClass);
              out.print(source[19]); // 81:143 = ".class, "e_"
              out.print(joinCount);
              out.print(source[20]); // 81:167 = "",                        ("
              out.print(pdoName);
              out.print(source[21]); // 82:36 = " "
              out.print(alias);
              out.print(source[22]); // 82:46 = ", "
              out.print(joinClass);
              out.print(source[23]); // 82:61 = " "
              out.print(joinAlias);
              out.print(source[24]); // 82:75 = ") -> {                          "
              out.print(poImpl);
              out.print(source[25]); // 83:36 = " po = ("
              out.print(poImpl);
              out.print(source[26]); // 83:53 = ") "
              out.print(alias);
              out.print(source[27]); // 83:64 = ".getPersistenceDelegate();             ..."
              out.print(join.getGetterName());
              out.print(source[28]); // 84:53 = "Blunt().add("
              out.print(joinAlias);
              out.print(source[29]); // 84:78 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[30]); // 86:63 = ""
            }
            else {
              out.print(source[31]); // 90:2 = "                      new Join<>(JoinTyp..."
              out.print(alias);
              out.print(source[32]); // 91:58 = "."
              out.print(join.getAttribute().getColumnName());
              out.print(source[33]); // 91:98 = "", "e_"
              out.print(joinCount);
              out.print(source[34]); // 91:117 = ".id", "
              out.print(joinClass);
              out.print(source[35]); // 91:136 = ".class, "e_"
              out.print(joinCount);
              out.print(source[36]); // 91:160 = "",                        ("
              out.print(pdoName);
              out.print(source[37]); // 92:36 = " "
              out.print(alias);
              out.print(source[38]); // 92:46 = ", "
              out.print(joinClass);
              out.print(source[39]); // 92:61 = " "
              out.print(joinAlias);
              out.print(source[40]); // 92:75 = ") -> {                          "
              out.print(alias);
              out.print(source[41]); // 93:35 = "."
              out.print(join.getSetterName());
              out.print(source[42]); // 93:60 = "("
              out.print(joinAlias);
              out.print(source[43]); // 93:74 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[44]); // 95:63 = ""
            }
          }
          else  { // non-abstract
            if (join.getRelationType() == RelationType.LIST) {
              out.print(source[45]); // 101:2 = "                      new Join<"
              out.print(pdoName);
              out.print(source[46]); // 102:42 = ","
              out.print(joinClass);
              out.print(source[47]); // 102:56 = ">(JoinType.LEFT, ""
              out.print(alias);
              out.print(source[48]); // 102:83 = ".id", "e_"
              out.print(joinCount);
              out.print(source[49]); // 102:105 = "."
              out.print(join.getForeignAttribute().getColumnName());
              out.print(source[50]); // 102:152 = "", "
              out.print(joinClass);
              out.print(source[51]); // 102:168 = ".class, "e_"
              out.print(joinCount);
              out.print(source[52]); // 102:192 = "",                        ("
              out.print(alias);
              out.print(source[53]); // 103:34 = ", "
              out.print(joinAlias);
              out.print(source[54]); // 103:49 = ") -> {"
              if (join.isReversed()) {
                out.print(source[55]); // 106:2 = "                        (("
                out.print(poImpl);
                out.print(source[56]); // 107:36 = ") "
                out.print(alias);
                out.print(source[57]); // 107:47 = ".getPersistenceDelegate())."
                out.print(join.getSetterName());
                out.print(join.isSerialized()?"Blunt":"");
                out.print(source[58]); // 107:132 = "("
                out.print(joinAlias);
                out.print(source[59]); // 107:146 = ");"
              }
              else {
                out.print(source[60]); // 111:2 = "                        (("
                out.print(poImpl);
                out.print(source[61]); // 112:36 = ") "
                out.print(alias);
                out.print(source[62]); // 112:47 = ".getPersistenceDelegate())."
                out.print(join.getGetterName());
                out.print(source[63]); // 112:98 = "Blunt().addBlunt("
                out.print(joinAlias);
                out.print(source[64]); // 112:128 = ");"
                if (join.getLinkMethodName() != null) {
                  String joinImpl = deriveClassNameForEntity(join.getForeignEntity());
                  out.print(source[65]); // 116:2 = "                        (("
                  out.print(joinImpl);
                  out.print(source[66]); // 117:38 = ") "
                  out.print(joinAlias);
                  out.print(source[67]); // 117:53 = ".getPersistenceDelegate())."
                  out.print(createRelationUpdateReferenceCode(join, alias, true));
                  out.print(source[68]); // 117:136 = ";"
                }
              }
              out.print(source[69]); // 121:2 = "                        }              ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[70]); // 123:63 = ""
            }
            else {
              out.print(source[71]); // 127:2 = "                      new Join<"
              out.print(pdoName);
              out.print(source[72]); // 128:42 = ","
              out.print(joinClass);
              out.print(source[73]); // 128:56 = ">(JoinType.LEFT, ""
              out.print(alias);
              out.print(source[74]); // 128:83 = "."
              out.print(join.getAttribute().getColumnName());
              out.print(source[75]); // 128:123 = "", "e_"
              out.print(joinCount);
              out.print(source[76]); // 128:142 = ".id", "
              out.print(joinClass);
              out.print(source[77]); // 128:161 = ".class, "e_"
              out.print(joinCount);
              out.print(source[78]); // 128:185 = "",                        ("
              out.print(alias);
              out.print(source[79]); // 129:34 = ", "
              out.print(joinAlias);
              out.print(source[80]); // 129:49 = ") -> {                          "
              out.print(alias);
              out.print(source[81]); // 130:35 = "."
              out.print(join.getSetterName());
              out.print(join.isSerialized()?"Blunt":"");
              out.print(source[82]); // 130:94 = "("
              out.print(joinAlias);
              out.print(source[83]); // 130:108 = ");                        }           ..."
              out.print(joinCount < joins.size() ? ")," : ")");
              out.print(source[84]); // 132:63 = ""
            }
          }
        }
        out.print(source[85]); // 137:2 = "                    )                );..."
      }
      else {
        out.print(source[86]); // 143:2 = "                    null);"
      }
      out.print(source[87]); // 147:2 = "  @Override"
      if (getEntity().isAbstract()) {
        out.print(source[88]); // 152:2 = "  @SuppressWarnings("unchecked")"
      }
      out.print(source[89]); // 156:2 = "  public "
      out.print(cvType);
      out.print(getEntity().isAbstract() ? "<T,P>" : "");
      out.print(source[90]); // 157:62 = " getClassVariables() {    return CLASSV..."
    }
  }

  // ----------------- end wurblet code -----------------
}
