// wurblet generated by Wurbelizer 17.3.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to update entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoUpdateBy [--private] [--noif] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     &lt;expression&gt; | &lt;values&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * <li><em>&lt;values&gt;:</em> the attributes to be updated.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoUpdateBy extends DbModelWurblet {

  public PdoUpdateBy() {
    setConfiguration("groupArgs");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    assertEntityIsPersistable();

    String className  = getClassName();
    String methodName = getMethodName();
    String pdoName    = getPdoClassName();

    String  classVar  = null;
    String  append    = null;
    boolean noif      = true;
    String  scope     = "public";

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
      }
      else if (arg.equals("noif")) {
        noif = true;
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (scope.equals("private")) {
      setRemote(false);
      noif = true;
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    String params = buildMethodParameters();
    String iparms = buildInvocationParameters();
    String statementId = createStatementId();

    if (!noif) {
      out.print(source[0]); // 67:2 = "  @Override"
    }
    out.print(source[1]); // 71:2 = "  "
    out.print(scope);
    out.print(source[2]); // 72:11 = " int "
    out.print(methodName);
    out.print(source[3]); // 72:30 = "("
    out.print(params);
    out.print(source[4]); // 72:41 = ") {"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut   = genInc.getImplStream();
      PrintStream remoteOut = genInc.getRemoteStream();
      out.print(source[5]); // 79:2 = "    if (getSession().isRemote())  {    ..."
      if (getContextAttribute() != null)  {
        remoteOut.print(source[6]); // 85:16 = "  int "
        remoteOut.print(methodName);
        remoteOut.print(source[7]); // 86:20 = "("
        remoteOut.print(pcs(params, "DomainContext context"));
        remoteOut.print(source[8]); // 86:61 = ") throws RemoteException;"
        implOut.print(source[9]); // 87:14 = "  @Override  public int "
        implOut.print(methodName);
        implOut.print(source[10]); // 90:27 = "("
        implOut.print(pcs(params, "DomainContext context"));
        implOut.print(source[11]); // 90:68 = ") throws RemoteException {    try {   ..."
        implOut.print(methodName);
        implOut.print(source[12]); // 93:36 = "("
        implOut.print(iparms);
        implOut.print(source[13]); // 93:47 = ");    }    catch (RuntimeException e) ..."
        out.print(source[14]); // 99:6 = "        return getRemoteDelegate()."
        out.print(methodName);
        out.print(source[15]); // 100:49 = "("
        out.print(pcs(iparms, "getDomainContext()"));
        out.print(source[16]); // 100:87 = ");"
      }  // end if contextLine
      else  {
        remoteOut.print(source[17]); // 105:16 = "  int "
        remoteOut.print(methodName);
        remoteOut.print(source[18]); // 106:20 = "("
        remoteOut.print(params);
        remoteOut.print(source[19]); // 106:31 = ") throws RemoteException;"
        implOut.print(source[20]); // 107:14 = "  @Override  public int "
        implOut.print(methodName);
        implOut.print(source[21]); // 110:27 = "("
        implOut.print(params);
        implOut.print(source[22]); // 110:38 = ") throws RemoteException {"
        implOut.print(source[23]); // 111:14 = "    try {      return dbObject."
        implOut.print(methodName);
        implOut.print(source[24]); // 113:36 = "("
        implOut.print(iparms);
        implOut.print(source[25]); // 113:47 = ");    }    catch (RuntimeException e) ..."
        out.print(source[26]); // 119:6 = "        return getRemoteDelegate()."
        out.print(methodName);
        out.print(source[27]); // 120:49 = "("
        out.print(iparms);
        out.print(source[28]); // 120:60 = ");"
      }
      out.print(source[29]); // 123:2 = "      }      catch (RemoteException e) ..."
    } // end if remote
     out.print(source[30]); // 132:2 = "    // check security rules at class lev..."
     out.print(methodName);
     out.print(source[31]); // 135:52 = " denied by security rules");    }    P..."
     out.print(classVar);
     out.print(statementId);
     out.print(source[32]); // 137:82 = ",      () -> {        StringBuilder sq..."
    boolean isFirstSetKey = true;
    for (WurbletArgument key: getExtraArguments())  {
      Attribute attr = key.getAttribute();
      if (isFirstSetKey) {
        isFirstSetKey = false;
      }
      else  {
        out.print(source[33]); // genupdate.incl:9:2 = "        sql.append(Backend.SQL_COMMA);"
      }
      for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
        out.print(source[34]); // genupdate.incl:14:2 = "        sql.append("
        out.print(getColumnNameConstant(attr, columnIndex));
        out.print(source[35]); // genupdate.incl:15:63 = ");        sql.append(Backend.SQL_EQUAL_..."
      }
    }
    out.print(source[36]); // 140:38 = "        sql.append(Backend.SQL_WHEREALL)..."
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[37]); // genwhere.incl:3:2 = "        boolean classIdRequired = isClas..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[38]); // genwhere.incl:15:2 = "        sql.append(Backend.SQL_AND);   ..."
        out.print(getColumnNameConstant(getContextAttribute(), 0));
        out.print(source[39]); // genwhere.incl:17:70 = ");        sql.append(Backend.SQL_EQUAL_..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[40]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[41]); // genwhere.incl:32:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[42]); // genwhere.incl:36:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = getColumnNameConstant(rel.getAttribute(), 0);
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = getColumnNameConstant(rel.getForeignAttribute(), 0);
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append(getColumnNameConstant(mattr, 0)).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (int columnIndex = 1; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                        buf.append("           .append(Backend.SQL_AND)\n")
                           .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                           .append(rightClass).append(getColumnNameConstant(attr, columnIndex)).append("))\n")
                           .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append(getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEntity());
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  buf.append("        sql.append(").append(compKeyClass).
                      append(".CLASSVARIABLES.getColumnName(").
                      append(compKeyClass).append('.').append(getColumnNameConstant(attr, columnIndex)).append("))\n").
                      append("           ").append(createRelopCode(arg)).append(";\n");
                }
              }
            }
            else {
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  if (isPathAllowed()) {
                    if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                       buf.append("        sql.append(");
                       buf.append(deriveClassNameForEntity(attr.getEntity()));
                       buf.append(".CLASSVARIABLES.getColumnName(");
                       buf.append(getColumnNameConstant(attr, columnIndex)).append("));\n");
                    }
                    else  {
                      if (isPdo()) {
                        buf.append("        sql.append(getColumnName(").append(getColumnNameConstant(attr, columnIndex)).append("));\n");
                      }
                      else  {
                        buf.append("        sql.append(").append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                      }
                    }
                  }
                  else  {
                    buf.append("        sql.append(").append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                  }
                  buf.append("        sql").append(createRelopCode(arg)).append(";\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[43]); // genwhere.incl:223:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[44]); // genwhere.incl:226:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[45]); // genwhere.incl:231:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[46]); // genwhere.incl:241:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[47]); // genwhere.incl:243:25 = ";"
    }
    if (append != null) {
      out.print(source[48]); // 145:2 = "        sql.append("
      out.print(append);
      out.print(source[49]); // 146:29 = ");"
    }
    out.print(source[50]); // 149:2 = "        return sql.toString();      } ..."
    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }
    if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[51]); // gensetpar.incl:6:2 = "    if (isClassIdRequiredInWhereClause()..."
    }
    if (getContextAttribute() != null) {
      out.print(source[52]); // gensetpar.incl:13:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute().getDataType()));
      out.print(source[53]); // gensetpar.incl:14:68 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[54]); // gensetpar.incl:14:111 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                out.print(source[55]); // gensetpar.incl:27:2 = "    "
                out.print(createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                out.print(source[56]); // gensetpar.incl:28:77 = ";"
              }
            }
          }
        }
      }

      if (!par.isValueLiterally()) {
        out.print(source[57]); // gensetpar.incl:37:2 = "    "
        out.print(createWhereSetPars(par));
        out.print(source[58]); // gensetpar.incl:38:31 = ";"
      }
    }
    out.print(source[59]); // 154:38 = "    return st.executeUpdate();  }"
    if (classVar.length() == 0) {
      out.print(source[60]); // 160:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[61]); // 162:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------

  @Override
  public String process(String code) {
    int ref = code.lastIndexOf("ndx");
    int pos = code.lastIndexOf("(ndx++,");
    if (pos >= 0 && ref == pos + 1) {
      // remove unnecessary last ++
      code = code.substring(0, pos + 4) + code.substring(pos + 6);
    }
    else {
      // remove unnecessary last ndx +=
      pos = code.lastIndexOf("ndx += st.set(");   // ndx += st.set(DT_POSITION3D, ndx, dropPosition, false, null);
      if (pos >= 0 && ref > pos) {
        code = code.substring(0, pos) + code.substring(pos + 7);
      }
      else {
        pos = code.lastIndexOf(", ndx++, ");   // st.set(SqlType....., ndx++, value.get...)
        if (pos >= 0 && ref > pos) {
          code = code.substring(0, pos + 5) + code.substring(pos + 7);
        }
      }
    }
    return code;
  }
}
