// wurblet generated by Wurbelizer 17.3.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for related entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoRelations
 *     [--loadcomponents|--noloadcomponents]
 *     [--insertcomponents|--noinsertcomponents]
 *     [--deletecomponents|--nodeletecomponents]
 *     [--nori] [--noselects] [--nodeletes] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--loadcomponents|--noloadcomponents:</em> force (no) generation of loadComponents().</li>
 * <li><em>--insertcomponents|--noinsertcomponents:</em> force (no) generation of insertPlainWithComponents().</li>
 * <li><em>--deletecomponents|--nodeletecomponents:</em> force (no) generation of deletePlainWithComponents().</li>
 * <li><em>--nori:</em> don't generate PdoIsReferencing wurblet anchors and addReferencingClass() invocations.</li>
 * <li><em>--noselects:</em> don't generate PdoSelect... wurblet anchors.</li>
 * <li><em>--nodeletes:</em> don't generate PdoDelete... wurblet anchors.</li>
 * <li><em>--novalidate:</em> don't generate validate method.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoRelations extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();

    String pdoName = null;
    try {
      // in implementation
      pdoName = getPdoClassName();
    }
    catch (WurbelException we) {
      // in interface
      pdoName = getClassName();
    }

    boolean generateDeclarations                    = false;
    boolean generateIsModified                      = false;
    boolean generateIsComposite                     = false;
    boolean generateSaveReferencingRelations        = false;
    boolean generateSaveReferencedRelations         = false;
    boolean generateDeleteReferencingRelations      = false;
    boolean generateDeleteReferencedRelations       = false;
    boolean generateLazyDeleteReferencingRelations  = false;
    boolean generateLazyDeleteReferencedRelations   = false;
    boolean generateSetSession                      = false;
    Boolean generateLoadComponents                  = null;
    Boolean generateInsertComponents                = null;
    Boolean generateDeleteComponents                = null;
    boolean generateMarkDeleted                     = false;
    boolean generateIsReferencing                   = true;
    boolean generateAddReferencing                  = false;
    boolean generateSelects                         = true;
    boolean generateDeletes                         = true;
    Boolean generateValidate                        = null;
    boolean generateSetImmutable                    = false;
    boolean generateSnapshot                        = false;
    boolean generateClearOnRemoteSave               = false;
    boolean generateAlignComponents                 = false;
    boolean generateCreateNormText                  = false;
    boolean generateMock                            = false;

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
        generateAddReferencing = true;
        break;
      }
    }

    for (String arg: getOptionArgs())  {
      if (arg.equals("noloadcomponents")) {
        generateLoadComponents = false;
      }
      else if (arg.equals("noinsertcomponents")) {
        generateInsertComponents = false;
      }
      else if (arg.equals("nodeletecomponents")) {
        generateDeleteComponents = false;
      }
      else if (arg.equals("novalidate")) {
        generateValidate = false;
      }
      else if (arg.equals("loadcomponents")) {
        generateLoadComponents = true;
      }
      else if (arg.equals("insertcomponents")) {
        generateInsertComponents = true;
      }
      else if (arg.equals("deletecomponents")) {
        generateDeleteComponents = true;
      }
      else if (arg.equals("nori")) {
        generateIsReferencing = false;
        generateAddReferencing = false;
      }
      else if (arg.equals("noselects")) {
        generateSelects = false;
      }
      else if (arg.equals("nodeletes")) {
        generateDeletes = false;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    // check which methods need generation
    for (Relation rel: getEntity().getRelations()) {
      if (rel.getSelectionType() == SelectionType.LAZY ||
          rel.getSelectionType() == SelectionType.EAGER)  {
        generateDeclarations = true;
        if (!rel.isSelectionCached()) {
          generateSetSession = true;
        }
      }
      if (rel.isPartOfNormText()) {
        generateCreateNormText = true;
      }
      if (rel.isComposite()) {
        generateIsComposite         = true;
        generateDeclarations        = true;
        generateIsModified          = true;
        generateSetSession          = true;
        generateMarkDeleted         = true;
        generateSnapshot            = true;
        generateSetImmutable        = true;

        if (generateValidate == null) {
          generateValidate = true;
        }

        if (rel.getRelationType() == RelationType.OBJECT) {
          generateSaveReferencedRelations = true;
          generateDeleteReferencedRelations = true;
          generateLazyDeleteReferencedRelations = true;
        }
        else  { // LIST
          generateSaveReferencingRelations = true;
          generateDeleteReferencingRelations = true;
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            generateLazyDeleteReferencingRelations = true;
            if (rel.getCountAttribute() != null) {
              generateAlignComponents = true;
            }
          }
        }
      }
      if (rel.isClearOnRemoteSave()) {
        generateClearOnRemoteSave = true;
      }
    }

    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    if (generateLoadComponents == null) {
      generateLoadComponents = generateIsComposite;
    }
    if (generateInsertComponents == null) {
      generateInsertComponents = generateIsComposite;
    }
    if (generateDeleteComponents == null) {
      generateDeleteComponents = generateIsComposite && (!useDatabaseRefInt || getEntity().isRootEntity());
    }

    if (generateDeclarations || generateMock) {
      // declarations
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite() || generateMock)  {
          String type = rel.getDeclaredJavaType(false);
          String transientModifier = isRelationTransient(rel) ? "transient " : "";
          out.print(source[0]); // 177:2 = "  // "
          out.print(rel);
          out.print(source[1]); // 179:12 = "  private "
          out.print(transientModifier);
          out.print(type);
          out.print(source[2]); // 180:39 = " "
          out.print(rel.getVariableName());
          out.print(source[3]); // 180:65 = ";"
          if (!generateMock) {
            if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
              out.print(source[4]); // 184:2 = "  private "
              out.print(transientModifier);
              out.print(source[5]); // 185:31 = "boolean "
              out.print(rel.getVariableName());
              out.print(source[6]); // 185:64 = "Loaded;"
            }
            if (rel.isComposite())  {
              if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
                out.print(source[7]); // 190:2 = "  private transient "
                out.print(type);
                out.print(source[8]); // 191:28 = " "
                out.print(rel.getVariableName());
                out.print(source[9]); // 191:54 = "Snapshot;"
              }
              if (rel.getRelationType() == RelationType.OBJECT) {
                out.print(source[10]); // 195:2 = "  private long "
                out.print(rel.getVariableName());
                out.print(source[11]); // 196:40 = "RemovedId;"
              }
            }
          }
        }

        if (rel.getNmName() != null) {
          String nmVar;
          if (rel.getNmMethodName() != null) {
            nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
          }
          else  {
            nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
          }
          out.print(source[12]); // 211:2 = "  private transient TrackedList<"
          out.print(rel.getNmRelation().getDeclaredJavaType(false));
          out.print(source[13]); // 212:82 = "> "
          out.print(nmVar);
          out.print(source[14]); // 212:93 = ";"
        }
      }
    }

    if (generateClearOnRemoteSave && !generateMock) {
      out.print(source[15]); // 219:2 = "  @Override  public void clearOnRemote..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isClearOnRemoteSave()) {
          out.print(source[16]); // 226:2 = "    "
          out.print(rel.getVariableName());
          out.print(source[17]); // 227:29 = " = null;"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[18]); // 230:2 = "    "
            out.print(rel.getVariableName());
            out.print(source[19]); // 231:29 = "Loaded = false;"
          }
        }
      }
      out.print(source[20]); // 236:2 = "  }"
    }



    // generate getter/setter
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String effType = rel.getJavaType();
      String scope = rel.getAccessScope().toString();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        scope = attr.getOptions().getAccessScope().toString();
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }
      if (rel.getForeignRelation() != null) {
        String linkMethodName = rel.getForeignRelation().getLinkMethodName();
        if (linkMethodName != null && !rel.getSetterName().equals(linkMethodName)) {
          // don't generate setter impl if linkmethodname is not default from model
          createSetter = false;
        }
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == null || " + checkNull;
        }
        out.print(source[21]); // 290:2 = ""
        if (hidden) {
          out.print(source[22]); // 294:2 = "  /**   * Gets "
          out.print(rel);
          out.print(source[23]); // 297:17 = ".   *   * @return "
          out.print(var);
          out.print(source[24]); // 299:21 = " "
          out.print(rel.getComment());
          out.print(source[25]); // 299:42 = "   */"
        }
        else {
          out.print(source[26]); // 304:2 = "  @Override"
        }
        if (rel.getForeignEntity().isAbstract()) { // needs a cast
        out.print(source[27]); // 309:2 = "  @SuppressWarnings("unchecked")"
        }
        if (!generateMock) {
          for (String annotation: rel.getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[28]); // 317:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[29]); // 318:26 = ""
            }
          }
        }
        out.print(source[30]); // 323:2 = "  "
        out.print(scope);
        out.print(source[31]); // 324:11 = " "
        out.print(type);
        out.print(source[32]); // 324:20 = " "
        out.print(rel.getGetterName());
        out.print(source[33]); // 324:44 = "()  {"
        if (generateMock) {
          out.print(source[34]); // 327:2 = "    return "
          out.print(var);
          out.print(source[35]); // 328:18 = ";  }"
        }
        else {
          if (rel.getSelectionType() == SelectionType.ALWAYS) {
            if (rel.getRelationType() == RelationType.LIST) {
              if (rel.isSelectionCached()) {
                out.print(source[36]); // 336:2 = "    "
                out.print(var);
                out.print(source[37]); // 337:11 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[38]); // 337:47 = ";"
              }
              else {
                out.print(source[39]); // 341:2 = "    "
                out.print(type);
                out.print(source[40]); // 342:12 = " "
                out.print(var);
                out.print(source[41]); // 342:20 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[42]); // 342:56 = ";"
              }
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[43]); // 347:2 = "    int ndx = 0;"
                }
                out.print(source[44]); // 351:2 = "    for ("
                out.print(rel.getClassName());
                out.print(source[45]); // 352:31 = " obj: "
                out.print(var);
                out.print(source[46]); // 352:44 = ")  {      obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[47]); // 353:52 = ";    }"
              }
              out.print(source[48]); // 357:2 = "    return "
              out.print(var);
              out.print(source[49]); // 358:18 = ";"
            }
            else  {
              if (rel.isComposite()) {
                out.print(source[50]); // 363:2 = "    "
                out.print(var);
                out.print(source[51]); // 364:11 = " = "
                out.print(checkNull);
                out.print(source[52]); // 364:27 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[53]); // 364:70 = ";"
                if (rel.isReferenced()) {
                  out.print(source[54]); // 367:2 = "    if ("
                  out.print(var);
                  out.print(source[55]); // 368:15 = " != null) {      "
                  out.print(var);
                  out.print(source[56]); // 369:13 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[57]); // 369:56 = ";    }"
                }
                if (rel.isProcessed()) {
                  out.print(source[58]); // 374:2 = "    "
                  out.print(var);
                  out.print(source[59]); // 375:11 = " = process"
                  out.print(rel.getMethodNameSuffix());
                  out.print(source[60]); // 375:50 = "("
                  out.print(var);
                  out.print(source[61]); // 375:58 = ");"
                }
                out.print(source[62]); // 378:2 = "    return "
                out.print(var);
                out.print(source[63]); // 379:18 = ";"
              }
              else  {
                if (rel.isReferenced()) {
                  out.print(source[64]); // 384:2 = "    "
                  out.print(type);
                  out.print(source[65]); // 385:12 = " obj = "
                  out.print(checkNull);
                  out.print(source[66]); // 385:32 = " ? null : "
                  out.print(createRelationSelectCode(rel));
                  out.print(source[67]); // 385:75 = ";    if (obj != null) {      obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[68]); // 387:52 = ";    }    return obj;"
                }
                else {
                  out.print(source[69]); // 393:2 = "    return "
                  out.print(checkNull);
                  out.print(source[70]); // 394:24 = " ? null : "
                  out.print(createRelationSelectCode(rel));
                  out.print(source[71]); // 394:67 = ";"
                }
              }
            }
          }
          else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[72]); // 401:2 = "    if (!"
            out.print(var);
            out.print(source[73]); // 402:16 = "Loaded) {"
            if (rel.isComposite())  {
              if (rel.getRelationType() == RelationType.LIST) {
                String condition = "isNew()";
                Attribute countAttribute = rel.getCountAttribute();
                if (countAttribute != null) {
                  condition += " || " + countAttribute.getName() + " == 0";
                }
                out.print(source[74]); // 411:2 = "      "
                out.print(var);
                out.print(source[75]); // 412:13 = " = "
                out.print(condition);
                out.print(source[76]); // 412:29 = " ? new "
                out.print(effType);
                out.print(source[77]); // 412:47 = "("
                out.print(rel.isTracked() ? "false" : "");
                out.print(source[78]); // 412:82 = ") : "
                out.print(createRelationSelectCode(rel));
                out.print(source[79]); // 412:119 = ";"
                if (rel.isReferenced()) {
                  if (rel.getLinkMethodIndex() != null) {
                    out.print(source[80]); // 416:2 = "      int ndx = 0;"
                  }
                  out.print(source[81]); // 420:2 = "      for ("
                  out.print(rel.getClassName());
                  out.print(source[82]); // 421:33 = " obj: "
                  out.print(var);
                  out.print(source[83]); // 421:46 = ")  {        obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[84]); // 422:54 = ";      }"
                }
              }
              else  {
                out.print(source[85]); // 428:2 = "      "
                out.print(var);
                out.print(source[86]); // 429:13 = " =  "
                out.print(checkNull);
                out.print(source[87]); // 429:30 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[88]); // 429:73 = ";"
                if (rel.isReferenced()) {
                  out.print(source[89]); // 432:2 = "      if ("
                  out.print(var);
                  out.print(source[90]); // 433:17 = " != null) {        "
                  out.print(var);
                  out.print(source[91]); // 434:15 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[92]); // 434:58 = ";      }"
                }
              }

              if (rel.isProcessed()) {
                out.print(source[93]); // 441:2 = "      "
                out.print(var);
                out.print(source[94]); // 442:13 = " = process"
                out.print(rel.getMethodNameSuffix());
                out.print(source[95]); // 442:52 = "("
                out.print(var);
                out.print(source[96]); // 442:60 = ");"
              }

              if (rel.getRelationType() == RelationType.LIST) {
                if (rel.isTracked()) {
                  if (rel.isImmutable()) {
                    out.print(source[97]); // 449:2 = "      "
                    out.print(var);
                    out.print(source[98]); // 450:13 = ".setImmutable(true);"
                  }
                  else {
                    out.print(source[99]); // 454:2 = "      if (isImmutable()) {        "
                    out.print(var);
                    out.print(source[100]); // 456:15 = ".setImmutable(true);      }"
                  }
                }
              }
              else  {
                if (rel.isImmutable()) {
                  out.print(source[101]); // 464:2 = "      "
                  out.print(var);
                  out.print(source[102]); // 465:13 = ".setImmutable(true, true);"
                }
                else {
                  out.print(source[103]); // 469:2 = "      if (isImmutable() && "
                  out.print(var);
                  out.print(source[104]); // 470:34 = " != null) {        "
                  out.print(var);
                  out.print(source[105]); // 471:15 = ".setImmutable(true);      }"
                }
              }
            }
            else  {
              if (rel.getRelationType() == RelationType.LIST) {
                out.print(source[106]); // 479:2 = "      "
                out.print(var);
                out.print(source[107]); // 480:13 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[108]); // 480:49 = ";"
                if (rel.isReferenced()) {
                  if (rel.getLinkMethodIndex() != null) {
                    out.print(source[109]); // 484:2 = "      int ndx = 0;"
                  }
                  out.print(source[110]); // 488:2 = "      for ("
                  out.print(rel.getClassName());
                  out.print(source[111]); // 489:33 = " obj: "
                  out.print(var);
                  out.print(source[112]); // 489:46 = ")  {        obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[113]); // 490:54 = ";      }"
                }
              }
              else  {
                out.print(source[114]); // 496:2 = "      "
                out.print(var);
                out.print(source[115]); // 497:13 = " = "
                out.print(checkNull);
                out.print(source[116]); // 497:29 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[117]); // 497:72 = ";"
                if (rel.isReferenced()) {
                  out.print(source[118]); // 500:2 = "      if ("
                  out.print(var);
                  out.print(source[119]); // 501:17 = " != null) {        "
                  out.print(var);
                  out.print(source[120]); // 502:15 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[121]); // 502:58 = ";      }"
                }
              }
            }
            out.print(source[122]); // 508:2 = "      "
            out.print(var);
            out.print(source[123]); // 509:13 = "Loaded = true;"
            if (nmRel != null) {
              out.print(source[124]); // 512:2 = "      "
              out.print(var);
              out.print(source[125]); // 513:13 = ".addListener(new TrackedListListener<>()..."
              out.print(rel.getClassName());
              out.print(source[126]); // 516:48 = " element) {          get"
              out.print(nmName);
              out.print(source[127]); // 517:23 = "().addIfAbsent(element."
              out.print(nmRel.getGetterName());
              out.print(source[128]); // 517:71 = "());        }        @Override      ..."
              out.print(rel.getClassName());
              out.print(source[129]); // 521:50 = " element) {          get"
              out.print(nmName);
              out.print(source[130]); // 522:23 = "().remove(element."
              out.print(nmRel.getGetterName());
              out.print(source[131]); // 522:66 = "());        }      });"
            }
            out.print(source[132]); // 527:2 = "    }    return "
            out.print(var);
            out.print(source[133]); // 529:18 = ";"
          }
          out.print(source[134]); // 532:2 = "  }"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
              if (rel.isBluntDeclared()) {
                out.print(source[135]); // 538:2 = "  @Override"
              }
              else {
                out.print(source[136]); // 544:2 = "  /**   * Gets "
                out.print(var);
                out.print(source[137]); // 547:17 = " without performing a select if not load..."
                out.print(var);
                out.print(source[138]); // 549:21 = " "
                out.print(rel.getComment());
                out.print(source[139]); // 549:42 = "   */"
              }
              out.print(source[140]); // 553:2 = "  "
              out.print(scope);
              out.print(source[141]); // 554:11 = " "
              out.print(type);
              out.print(source[142]); // 554:20 = " "
              out.print(rel.getGetterName());
              out.print(source[143]); // 554:44 = "Blunt() {    if (!"
              out.print(var);
              out.print(source[144]); // 555:16 = "Loaded) {      "
              out.print(var);
              out.print(source[145]); // 556:13 = " = new "
              out.print(effType);
              out.print(source[146]); // 556:31 = "("
              out.print(rel.isTracked() ? "false" : "");
              out.print(source[147]); // 556:66 = ");      if (isImmutable()) {        "
              out.print(var);
              out.print(source[148]); // 558:15 = ".setImmutable(true);      }      "
              out.print(var);
              out.print(source[149]); // 560:13 = "Loaded = true;    }    return "
              out.print(var);
              out.print(source[150]); // 562:18 = ";  }"
            }
            else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized()) {
              if (rel.isBluntDeclared()) {
                out.print(source[151]); // 568:2 = "  @Override"
              }
              else {
                out.print(source[152]); // 574:2 = "  /**   * Gets "
                out.print(var);
                out.print(source[153]); // 577:17 = " without performing a select if not load..."
                out.print(var);
                out.print(source[154]); // 579:21 = " "
                out.print(rel.getComment());
                out.print(source[155]); // 579:42 = "   */"
              }
              out.print(source[156]); // 583:2 = "  "
              out.print(scope);
              out.print(source[157]); // 584:11 = " "
              out.print(type);
              out.print(source[158]); // 584:20 = " "
              out.print(rel.getGetterName());
              out.print(source[159]); // 584:44 = "Blunt() {    return "
              out.print(var);
              out.print(source[160]); // 585:18 = ";  }"
            }
          }
        }

        if (nmRel != null) {
          String nmType = nmRel.getDeclaredJavaType(false);
          out.print(source[161]); // 594:2 = "  @Override  public TrackedList<"
          out.print(nmType);
          out.print(source[162]); // 597:31 = "> get"
          out.print(nmName);
          out.print(source[163]); // 597:46 = "() {"
          if (!generateMock) {
            out.print(source[164]); // 600:2 = "    if ("
            out.print(nmVar);
            out.print(source[165]); // 601:17 = " == null) {      "
            out.print(nmVar);
            out.print(source[166]); // 602:15 = " = new TrackedArrayList<>() {        @..."
            out.print(rel.getGetterName());
            out.print(source[167]); // 606:40 = "().isModified();        }      };   ..."
            out.print(rel.getForeignEntity());
            out.print(source[168]); // 610:37 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[169]); // 610:66 = "()) {        "
            out.print(nmVar);
            out.print(source[170]); // 611:17 = ".add(obj."
            out.print(nmRel.getGetterName());
            out.print(source[171]); // 611:51 = "());      }      "
            out.print(nmVar);
            out.print(source[172]); // 614:15 = ".addListener(new TrackedListListener<>()..."
            out.print(nmType);
            out.print(source[173]); // 617:36 = " element) {          "
            out.print(rel.getClassName());
            out.print(source[174]); // 618:32 = " obj = on("
            out.print(rel.getClassName());
            out.print(source[175]); // 618:64 = ".class);          obj."
            out.print(nmRel.getSetterName());
            out.print(source[176]); // 619:39 = "(element);          getNmLinks().add(ob..."
            out.print(nmType);
            out.print(source[177]); // 624:38 = " element) {          for (Iterator<"
            out.print(rel.getClassName());
            out.print(source[178]); // 625:46 = "> iter = "
            out.print(rel.getGetterName());
            out.print(source[179]); // 625:78 = "().iterator(); iter.hasNext(); ) {     ..."
            out.print(rel.getClassName());
            out.print(source[180]); // 626:34 = " obj = iter.next();            if (Obje..."
            out.print(nmRel.getGetterName());
            out.print(source[181]); // 627:60 = "(), element)) {              iter.remov..."
          }
          out.print(source[182]); // 637:2 = "    return "
          out.print(nmVar);
          out.print(source[183]); // 638:20 = ";  }"
        }

        if (!generateMock && rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
          if (rel.getAccessScope() == AccessScope.PUBLIC) {
            out.print(source[184]); // 646:2 = "  @Override"
          }
          else {
            out.print(source[185]); // 652:2 = "  /**   * Returns whether "
            out.print(rel.getName());
            out.print(source[186]); // 655:38 = " is loaded.   *   * @return true if "
            out.print(rel.getGetterName());
            out.print(source[187]); // 657:45 = "() invoked at least once   */"
          }
          out.print(source[188]); // 661:2 = "  "
          out.print(scope);
          out.print(source[189]); // 662:11 = " boolean is"
          out.print(StringHelper.firstToUpper(var));
          out.print(source[190]); // 662:56 = "Loaded() {    return "
          out.print(var);
          out.print(source[191]); // 663:18 = "Loaded;  }"
        }
      }


      if (createSetter)  {
        if (generateMock) {
          out.print(source[192]); // 672:2 = ""
          if (!hidden) {
            out.print(source[193]); // 676:2 = "  @Override"
          }
          out.print(source[194]); // 680:2 = "  "
          out.print(scope);
          out.print(source[195]); // 681:11 = " void "
          out.print(rel.getSetterName());
          out.print(source[196]); // 681:40 = "("
          out.print(type);
          out.print(source[197]); // 681:49 = " "
          out.print(var);
          out.print(source[198]); // 681:57 = ")  {    this."
          out.print(var);
          out.print(source[199]); // 682:16 = " = "
          out.print(var);
          out.print(source[200]); // 682:26 = ";  }"
        }
        else {
          String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
          String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
          out.print(source[201]); // 689:2 = ""
          if (hidden) {
            out.print(source[202]); // 693:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[203]); // 696:17 = ".   *   * @param "
            out.print(var);
            out.print(source[204]); // 698:20 = " "
            out.print(rel.getComment());
            out.print(source[205]); // 698:41 = ""
        if (linkMethodIndex != null) {
          out.print(source[206]); // 701:2 = "   * @param index the index starting at ..."
        }
        out.print(source[207]); // 705:2 = "   */"
          }
          else {
            out.print(source[208]); // 710:2 = "  @Override"
          }
          for (String annotation: rel.getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
              out.print(source[209]); // 717:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[210]); // 718:26 = ""
            }
          }
          if (linkMethodIndex != null) {
            out.print(source[211]); // 723:2 = "  "
            out.print(scope);
            out.print(source[212]); // 724:11 = " void "
            out.print(rel.getForeignRelation().getLinkMethodName());
            out.print(source[213]); // 724:65 = "("
            out.print(type);
            out.print(source[214]); // 724:74 = " "
            out.print(var);
            out.print(source[215]); // 724:82 = ", int index)  {"
          }
          else {
            String linkMethodName = rel.getSetterName();
            if (rel.getForeignRelation() != null && rel.getForeignRelation().getLinkMethodName() != null) {
              linkMethodName = rel.getForeignRelation().getLinkMethodName();
            }
            out.print(source[216]); // 732:2 = "  "
            out.print(scope);
            out.print(source[217]); // 733:11 = " void "
            out.print(linkMethodName);
            out.print(source[218]); // 733:35 = "("
            out.print(type);
            out.print(source[219]); // 733:44 = " "
            out.print(var);
            out.print(source[220]); // 733:52 = ")  {"
          }
          if (!rel.isReversed()) {
            out.print(source[221]); // 737:2 = "    assertMutable();"
          }
          if ((rel.getRelationType() == RelationType.LIST && !rel.isReversed()) ||
              rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              out.print(source[222]); // 744:2 = "    if (!attributesModified()) {      s..."
              out.print(var);
              out.print(source[223]); // 746:46 = ", "
              out.print(var);
              out.print(source[224]); // 746:55 = "));    }"
            }
            out.print(source[225]); // 750:2 = "    this."
            out.print(var);
            out.print(source[226]); // 751:16 = " = "
            out.print(var);
            out.print(source[227]); // 751:26 = ";"
            if (linkMethodIndex != null) {
              out.print(source[228]); // 754:2 = "    set"
              out.print(StringHelper.firstToUpper(linkMethodIndex));
              out.print(source[229]); // 755:53 = "(index);"
            }
          }
          if (rel.getRelationType() == RelationType.OBJECT) {
            if (rel.isComposite())  {
              if (attr != null && !attr.getDataType().isPrimitive()) {
                out.print(source[230]); // 762:2 = "    "
                out.print(attr.getJavaType());
                out.print(source[231]); // 763:26 = " oldId = "
                out.print(rel.getMethodArgs().get(0).getMethodArgument());
                out.print(source[232]); // 763:85 = ";"
              }
              else {
                out.print(source[233]); // 767:2 = "    long oldId = "
                out.print(rel.getMethodArgs().get(0).getMethodArgument());
                out.print(source[234]); // 768:67 = ";"
              }
            }
            out.print(source[235]); // 772:2 = "    "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[236]); // 773:48 = "("
            out.print(var);
            out.print(source[237]); // 773:56 = " == null ? "
            out.print(nullVal);
            out.print(source[238]); // 773:78 = " : "
            out.print(var);
            out.print(source[239]); // 773:88 = ".getId());"
          }
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[240]); // 777:2 = "    "
            out.print(var);
            out.print(source[241]); // 778:11 = "Loaded = true;"
          }
          if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite())  {
            if (attr != null && !attr.getDataType().isPrimitive()) {
              out.print(source[242]); // 783:2 = "    if (oldId != null && oldId != 0 && "
              out.print(rel.getVariableName());
              out.print(source[243]); // 784:64 = "RemovedId == 0 && !Objects.equals("
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[244]); // 784:148 = ", oldId)) {      "
              out.print(rel.getVariableName());
              out.print(source[245]); // 785:31 = "RemovedId = oldId;    }"
            }
            else {
              out.print(source[246]); // 790:2 = "    if (oldId != 0 && "
              out.print(rel.getVariableName());
              out.print(source[247]); // 791:47 = "RemovedId == 0 && "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[248]); // 791:115 = " != oldId) {      "
              out.print(rel.getVariableName());
              out.print(source[249]); // 792:31 = "RemovedId = oldId;    }"
            }
          }
          out.print(source[250]); // 797:2 = "  }"
        }

        if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[251]); // 804:2 = "  /**   * Sets "
              out.print(var);
              out.print(source[252]); // 807:17 = " without setting any attributes.   *  ..."
              out.print(var);
              out.print(source[253]); // 809:20 = " "
              out.print(rel.getComment());
              out.print(source[254]); // 809:41 = "   */  "
              out.print(scope);
              out.print(source[255]); // 811:11 = " void "
              out.print(rel.getSetterName());
              out.print(source[256]); // 811:40 = "Blunt("
              out.print(type);
              out.print(source[257]); // 811:54 = " "
              out.print(var);
              out.print(source[258]); // 811:62 = ") {    this."
              out.print(var);
              out.print(source[259]); // 812:16 = " = "
              out.print(var);
              out.print(source[260]); // 812:26 = ";    "
              out.print(var);
              out.print(source[261]); // 813:11 = "Loaded = true;  }"
        }
      }
    }


    // gerenate setSession and setDomainContext for referenced objects (necessary for RMI)
    if (generateSetSession)  {
      out.print(source[262]); // 823:2 = "  @Override  public void setSession(Se..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[263]); // 834:2 = "    session.applyTo("
               out.print(rel.getVariableName());
               out.print(source[264]); // 835:45 = ");"
        }
      }
      out.print(source[265]); // 839:2 = "  }  @Override  public void setDomain..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[266]); // 851:2 = "    context.applyTo("
               out.print(rel.getVariableName());
               out.print(source[267]); // 852:45 = ");"
        }
      }
      out.print(source[268]); // 856:2 = "  }"
    }



    // generate code to remove delete composite relations

    if (generateDeleteReferencingRelations && !generateMock)  {
      if (useDatabaseRefInt) {
        out.print(source[269]); // 867:2 = "  /**   * Deletes all referencing comp..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (!rel.isTracked()) {
                throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
              }
              String var = rel.getVariableName();
              out.print(source[270]); // 881:2 = "    if ("
              out.print(var);
              out.print(source[271]); // 882:15 = " != null && "
              out.print(var);
              out.print(source[272]); // 882:34 = ".isSomeRemoved()) {      delete("
              out.print(var);
              out.print(source[273]); // 883:20 = ".getRemovedObjects());    }"
            }
          }
          out.print(source[274]); // 888:2 = "  }"
      }
      else { // no database ref. integrity
        if (generateLazyDeleteReferencingRelations)  {
          out.print(source[275]); // 894:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                if (rel.isTracked())  {
                  out.print(source[276]); // 919:2 = "    if (delete) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[277]); // 923:2 = "      delete("
                    out.print(rel.getGetterName());
                    out.print(source[278]); // 924:36 = "());"
                  }
                  else {
                    out.print(source[279]); // 928:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[280]); // 929:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[281]); // 930:39 = ";"
                  }
                  out.print(source[282]); // 933:2 = "    }    if ("
                  out.print(var);
                  out.print(source[283]); // 935:15 = " != null && "
                  out.print(var);
                  out.print(source[284]); // 935:34 = ".isSomeRemoved()) {      delete("
                  out.print(var);
                  out.print(source[285]); // 936:20 = ".getRemovedObjects());    }"
                }  // end if isTracked
                else  {
                  out.print(source[286]); // 941:2 = "    if (delete || "
                  out.print(var);
                  out.print(source[287]); // 942:25 = " != null) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[288]); // 945:2 = "      markDeleted("
                    out.print(rel.getGetterName());
                    out.print(source[289]); // 946:41 = "());      deleteMissingInCollection("
                    out.print(createRelationSelectCode(rel));
                    out.print(source[290]); // 947:65 = ", "
                    out.print(var);
                    out.print(source[291]); // 947:74 = ");"
                  } // end isDeleteCascade
                  else {
                    out.print(source[292]); // 951:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[293]); // 952:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[294]); // 953:39 = ";"
                  }
                  out.print(source[295]); // 956:2 = "    }"
                }
              }
            } // end composite
          }
          out.print(source[296]); // 963:2 = "  }"
        } // end if generateLazyDeleteReferencingRelations

        else  {   // no lazy loading at all
        out.print(source[297]); // 969:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.isDeletionCascaded()) {
                out.print(source[298]); // 979:2 = "    delete("
                out.print(rel.getGetterName());
                out.print(source[299]); // 980:34 = "());"
              }
              else {
                out.print(source[300]); // 984:2 = "    markDeleted("
                out.print(var);
                out.print(source[301]); // 985:23 = ");    "
                out.print(createRelationDeleteCode(rel));
                out.print(source[302]); // 986:37 = ";"
              }
            }
          }
          out.print(source[303]); // 991:2 = "  }"
        }
      } // end w/o db-integrity
    }


    if (generateDeleteReferencedRelations && !generateMock)  {
      if (useDatabaseRefInt) {
        out.print(source[304]); // 1001:2 = "  /**   * Deletes all referenced compo..."
        for (Relation rel: getEntity().getRelations()) {
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            if (!rel.isTracked()) {
              throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
            }
            // remove the old deleted composite too, if set
            // we need to replace <varname>Id by <varname>RemovedId in the select statement
            String var = rel.getVariableName();
            String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
            out.print(source[305]); // 1018:2 = "    if ("
            out.print(rel.getVariableName());
            out.print(source[306]); // 1019:33 = "RemovedId != 0) {      "
            out.print(rel.getClassName());
            out.print(source[307]); // 1020:28 = " old = "
            out.print(selectStmt);
            out.print(source[308]); // 1020:49 = ";      if (old != null) {        old.d..."
            out.print(rel.getVariableName());
            out.print(source[309]); // 1023:33 = "RemovedId = 0;      }    }"
          }
        }
        out.print(source[310]); // 1029:2 = "  }"
      }
      else  {
        if (generateLazyDeleteReferencedRelations)  {
          out.print(source[311]); // 1035:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                out.print(source[312]); // 1059:2 = "    if (delete && "
                out.print(rel.getGetterName());
                out.print(source[313]); // 1060:41 = "() != null && !"
                out.print(var);
                out.print(source[314]); // 1060:63 = ".isVirgin()) {      delete("
                out.print(var);
                out.print(source[315]); // 1061:20 = ");    }"
              }
              // remove the old deleted composite too, if set
              // we need to replace <varname>Id by <varname>RemovedId in the select statement
              String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
              out.print(source[316]); // 1068:2 = "    if ("
              out.print(rel.getVariableName());
              out.print(source[317]); // 1069:33 = "RemovedId != 0) {      "
              out.print(rel.getClassName());
              out.print(source[318]); // 1070:28 = " old = "
              out.print(selectStmt);
              out.print(source[319]); // 1070:49 = ";      if (old != null) {        old.d..."
              out.print(rel.getVariableName());
              out.print(source[320]); // 1073:33 = "RemovedId = 0;      }    }"
            } // end composite
          }
          out.print(source[321]); // 1079:2 = "  }"
        } // end if generateLazyDeleteReferencedRelations

        else  {   // no lazy loading at all
        out.print(source[322]); // 1085:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.ALWAYS) {
                throw new WurbelException("internal wurblet logic error");
              }
              else {
                out.print(source[323]); // 1098:2 = "    if ("
                out.print(var);
                out.print(source[324]); // 1099:15 = " != null) {      delete("
                out.print(var);
                out.print(source[325]); // 1100:20 = ");    }"
              }
            }
          }
          out.print(source[326]); // 1106:2 = "  }"
        }
      }
    }


    // save composite relations

    if (generateSaveReferencingRelations && !generateMock)  {
      out.print(source[327]); // 1117:2 = "  @Override  public void saveReferenci..."
      if (useDatabaseRefInt) {
        out.print(source[328]); // 1125:2 = "      deleteRemovedReferencingRelations(..."
      }
      else  {
        out.print(source[329]); // 1130:2 = "      deleteReferencingRelations("
        out.print(generateLazyDeleteReferencingRelations ? "false" : "");
        out.print(source[330]); // 1131:90 = ");"
      }
      out.print(source[331]); // 1134:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          if (rel.isProcessed()) {
            out.print(source[332]); // 1141:2 = "    "
            out.print(var);
            out.print(source[333]); // 1142:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[334]); // 1142:50 = "("
            out.print(var);
            out.print(source[335]); // 1142:58 = ");"
          }
          out.print(source[336]); // 1145:2 = "    if ("
          out.print(var);
          out.print(source[337]); // 1146:15 = " != null) {      getDomainContext().app..."
          out.print(var);
          out.print(source[338]); // 1147:40 = ");"
          if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
            out.print(source[339]); // 1150:2 = "      int ndx = 0;"
          }
          out.print(source[340]); // 1154:2 = "      for ("
          out.print(rel.getClassName());
          out.print(source[341]); // 1155:33 = " obj: "
          out.print(var);
          out.print(source[342]); // 1155:46 = ")  {        obj."
          out.print(createRelationLinkCode(rel));
          out.print(source[343]); // 1156:43 = ";"
          boolean firstSkipped = false;
          for (MethodArgument ma: rel.getMethodArgs()) {
            if (firstSkipped)  {
              out.print(source[344]); // 1161:2 = "        obj."
              out.print(ma.getSetterMethod());
              out.print(source[345]); // 1162:36 = "("
              out.print(ma.getMethodArgument());
              out.print(source[346]); // 1162:63 = ");"
            }
            firstSkipped = true;
          }
          out.print(source[347]); // 1167:2 = "      }      save("
          out.print(var);
          out.print(source[348]); // 1169:18 = ", "
          out.print(rel.isTracked() ? "true" : "false");
          out.print(source[349]); // 1169:58 = ");    }"
        }
      }
      out.print(source[350]); // 1174:2 = "  }"
    }


    if (generateSaveReferencedRelations && !generateMock)  {
      out.print(source[351]); // 1181:2 = "  @Override  public void saveReference..."
      if (getEntity().isRootEntity()) {
        // need a valid id to store in rootId of composite object relations
        out.print(source[352]); // 1188:2 = "    reserveId();"
      }
      out.print(source[353]); // 1192:2 = "    super.saveReferencedRelations(update..."
      if (useDatabaseRefInt) {
        out.print(source[354]); // 1197:2 = "      deleteRemovedReferencedRelations()..."
      }
      else  {
        out.print(source[355]); // 1202:2 = "      deleteReferencedRelations("
        out.print(generateLazyDeleteReferencedRelations ? "false" : "");
        out.print(source[356]); // 1203:88 = ");"
      }
      out.print(source[357]); // 1206:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[358]); // 1212:2 = "    getDomainContext().applyTo("
          out.print(var);
          out.print(source[359]); // 1213:38 = ");"
          if (rel.isProcessed()) {
            out.print(source[360]); // 1216:2 = "    "
            out.print(var);
            out.print(source[361]); // 1217:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[362]); // 1217:50 = "("
            out.print(var);
            out.print(source[363]); // 1217:58 = ");"
          }
          if (rel.isTracked())  {
            out.print(source[364]); // 1221:2 = "    if ("
            out.print(var);
            out.print(source[365]); // 1222:15 = " != null && "
            out.print(var);
            out.print(source[366]); // 1222:34 = ".isModified()) {      save("
            out.print(var);
            out.print(source[367]); // 1223:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[368]); // 1224:50 = "("
            out.print(var);
            out.print(source[369]); // 1224:58 = ".getId());    }"
          }
          else  {
            out.print(source[370]); // 1229:2 = "    if ("
            out.print(var);
            out.print(source[371]); // 1230:15 = " != null) {      save("
            out.print(var);
            out.print(source[372]); // 1231:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[373]); // 1232:50 = "("
            out.print(var);
            out.print(source[374]); // 1232:58 = ".getId());    }"
          }
        }
      }
      out.print(source[375]); // 1238:2 = "  }"
    }



    // generate code to validate
    if (Boolean.TRUE.equals(generateValidate))  {
      out.print(source[376]); // 1247:2 = "  @Override  public List<ValidationRes..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[377]); // 1256:2 = "    if ("
          out.print(var);
          out.print(source[378]); // 1257:15 = " != null) {"
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[379]); // 1260:2 = "      results.addAll(ValidationUtilities..."
            out.print(rel.getVariableName());
            out.print(source[380]); // 1262:41 = ", validationPath + "."
            out.print(var);
            out.print(source[381]); // 1262:69 = "", scope));"
          }
          else  {
            out.print(source[382]); // 1266:2 = "      results.addAll("
            out.print(rel.getVariableName());
            out.print(source[383]); // 1267:46 = ".validate(validationPath + "."
            out.print(var);
            out.print(source[384]); // 1267:82 = "", scope));"
          }
          out.print(source[385]); // 1270:2 = "    }"
        }
      }
      out.print(source[386]); // 1275:2 = "    return results;  }"
    }



    // generate code to check set the immutable flag
    if (generateSetImmutable && !generateMock)  {
      out.print(source[387]); // 1285:2 = "  @Override  public void setImmutable(..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          out.print(source[388]); // 1293:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[389]); // 1294:33 = " != null) {      "
          out.print(rel.getVariableName());
          out.print(source[390]); // 1295:31 = ".setImmutable(immutable);    }"
        }
      }
      out.print(source[391]); // 1300:2 = "  }"
    }



    // generate code to check for modifications
    if (generateIsModified && !generateMock)  {
      out.print(source[392]); // 1309:2 = "  @Override  public boolean isModified..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[393]); // 1318:2 = "           || isModified("
            out.print(rel.getVariableName());
            out.print(source[394]); // 1319:50 = ")"
          }
          else  {
            out.print(source[395]); // 1323:2 = "           || "
            out.print(rel.getVariableName());
            out.print(source[396]); // 1324:39 = " != null && "
            out.print(rel.getVariableName());
            out.print(source[397]); // 1324:76 = ".isModified()"
          }
        }
      }
      out.print(source[398]); // 1329:2 = "           ;  }"
    }

    if (generateAlignComponents && !generateMock) {
      out.print(source[399]); // 1336:2 = "  @Override  protected void alignCompo..."
      for (Relation rel: getEntity().getRelations()) {
        Attribute countAttribute = rel.getCountAttribute();
        if (countAttribute != null) {
          out.print(source[400]); // 1345:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[401]); // 1346:33 = " != null) {      "
          out.print(countAttribute.getSetterName());
          out.print(source[402]); // 1347:40 = "("
          out.print(rel.getVariableName());
          out.print(source[403]); // 1347:66 = ".size());    }"
        }
      }
      out.print(source[404]); // 1352:2 = "  }"
    }

    if (getEntity().isDeeplyReferenced()) {
      List<Relation> deepRelations = new ArrayList<>();
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite() && rel.getForeignEntity().isDeeplyReferenced()) {
          deepRelations.add(rel);
        }
      }
      if (!deepRelations.isEmpty()) {
        out.print(source[405]); // 1365:2 = "  @Override  public boolean isReferenc..."
        for (Relation rel: deepRelations) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[406]); // 1376:2 = "    for ("
            out.print(rel.getForeignEntity());
            out.print(source[407]); // 1377:35 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[408]); // 1377:64 = "()) {      if (obj.isReferenced()) {  ..."
          }
          else {
            out.print(source[409]); // 1385:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[410]); // 1386:31 = "() != null && "
            out.print(rel.getGetterName());
            out.print(source[411]); // 1386:68 = "().isReferenced()) {      return true;..."
          }
        }
        out.print(source[412]); // 1392:2 = "    return false;  }"
      }
    }



    // override isComposite()
    if (generateIsComposite)  {
      out.print(source[413]); // 1404:2 = "  @Override  public boolean isComposit..."
    }


    //  load all components
    if (generateLoadComponents && !generateMock)  {

      out.print(source[414]); // 1418:2 = "  @Override  public IdentifiableMap<? ..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[415]); // 1436:2 = "    if (!onlyLoaded || "
            out.print(var);
            out.print(source[416]); // 1437:30 = "Loaded) {"
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[417]); // 1440:2 = "      count += addComponents(components,..."
              out.print(rel.getGetterName());
              out.print(source[418]); // 1441:64 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[419]); // 1445:2 = "      if ("
              out.print(rel.getGetterName());
              out.print(source[420]); // 1446:33 = "() != null) {        count += ((Abstrac..."
              out.print(var);
              out.print(source[421]); // 1447:57 = ".getPersistenceDelegate()).addComponents..."
            }
            out.print(source[422]); // 1451:2 = "    }"
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[423]); // 1457:2 = "    count += addComponents(components, "
              out.print(rel.getGetterName());
              out.print(source[424]); // 1458:62 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[425]); // 1462:2 = "    if ("
              out.print(rel.getGetterName());
              out.print(source[426]); // 1463:31 = "() != null) {      count += ((AbstractP..."
              out.print(var);
              out.print(source[427]); // 1464:55 = ".getPersistenceDelegate()).addComponents..."
            }
          }
        }
      }
      out.print(source[428]); // 1471:2 = "    return count;  }"
    }



    //  insert all components
    if (generateInsertComponents && !generateMock)  {

      out.print(source[429]); // 1482:2 = "  @Override  public void insertPlainWi..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[430]); // 1490:2 = "    if ("
          out.print(rel.getGetterName());
          out.print(source[431]); // 1491:31 = "() != null) {      ((AbstractPersistent..."
          out.print(var);
          out.print(source[432]); // 1492:46 = ".getPersistenceDelegate()).insertPlainWi..."
        }
      }
      out.print(source[433]); // 1497:2 = "    insertPlain();"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          out.print(source[434]); // 1503:2 = "    insertPlainWithComponents("
          out.print(rel.getGetterName());
          out.print(source[435]); // 1504:53 = "());"
        }
      }
      out.print(source[436]); // 1508:2 = "  }"
    }


    //  delete all components
    if (generateDeleteComponents && !generateMock)  {

      out.print(source[437]); // 1517:2 = "  @Override  public void deletePlainWi..."
      if (useDatabaseRefInt) {
        out.print(source[438]); // 1523:2 = "    // components are deleted via databa..."
      }
      else {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
            out.print(source[439]); // 1531:2 = "    deletePlainWithComponents("
            out.print(rel.getGetterName());
            out.print(source[440]); // 1532:53 = "());"
          }
        }
      }
      out.print(source[441]); // 1537:2 = "    deletePlain();"
      if (!useDatabaseRefInt) {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[442]); // 1544:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[443]); // 1545:31 = "() != null) {      ((AbstractPersistent..."
            out.print(var);
            out.print(source[444]); // 1546:46 = ".getPersistenceDelegate()).deletePlainWi..."
          }
        }
      }
      out.print(source[445]); // 1552:2 = "  }"
    }



    // mark object and all components deleted
    if (generateMarkDeleted && !generateMock)  {
      out.print(source[446]); // 1561:2 = "  @Override  public void markDeleted()..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          out.print(source[447]); // 1570:2 = "    markDeleted("
          out.print(var);
          out.print(source[448]); // 1571:23 = ");"
        }
      }
      out.print(source[449]); // 1575:2 = "  }"
    }


    // generate snapshot methods
    if (generateSnapshot && !generateMock) {
      out.print(source[450]); // 1583:2 = "  /**   * Updates the components in sn..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[451]); // 1591:100 = " snapshot) {    super.createComponentsI..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[452]); // 1599:2 = "    snapshot."
              out.print(var);
              out.print(source[453]); // 1600:20 = "Snapshot = TrackedList.createSnapshot("
              out.print(var);
              out.print(source[454]); // 1600:65 = ");"
            }
          }
          else {
            out.print(source[455]); // 1605:2 = "    snapshot."
            out.print(var);
            out.print(source[456]); // 1606:20 = "Snapshot = Pdo.createSnapshot("
            out.print(var);
            out.print(source[457]); // 1606:57 = ");"
          }
        }
      }
      out.print(source[458]); // 1611:2 = "  }  /**   * Reverts all components o..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[459]); // 1619:100 = " snapshot) {    super.revertComponentsT..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          Relation nmRel = rel.getNmRelation();
          String nmVar = null;
          if (nmRel != null) {
            if (rel.getNmMethodName() != null) {
              nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
            }
            else  {
              nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
            }
          }
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[460]); // 1637:2 = "    "
              out.print(var);
              out.print(source[461]); // 1638:11 = " = TrackedList.revertToSnapshot("
              out.print(var);
              out.print(source[462]); // 1638:50 = ", snapshot."
              out.print(var);
              out.print(source[463]); // 1638:68 = "Snapshot);"
            }
          }
          else {
            out.print(source[464]); // 1643:2 = "    "
            out.print(var);
            out.print(source[465]); // 1644:11 = " = Pdo.revertToSnapshot("
            out.print(var);
            out.print(source[466]); // 1644:42 = ", snapshot."
            out.print(var);
            out.print(source[467]); // 1644:60 = "Snapshot);"
          }

          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[468]); // 1649:2 = "    "
            out.print(var);
            out.print(source[469]); // 1650:11 = "Loaded = snapshot."
            out.print(var);
            out.print(source[470]); // 1650:36 = "Loaded;"
          }
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[471]); // 1654:2 = "    "
            out.print(var);
            out.print(source[472]); // 1655:11 = "RemovedId = snapshot."
            out.print(var);
            out.print(source[473]); // 1655:39 = "RemovedId;"
          }
          if (nmVar != null) {
            out.print(source[474]); // 1659:2 = "    "
            out.print(nmVar);
            out.print(source[475]); // 1660:13 = " = null;"
          }
        }
      }
      out.print(source[476]); // 1665:2 = "  }"
    }

    if (generateCreateNormText && !generateMock) {
      out.print(source[477]); // 1671:2 = "  @Override  public StringBuilder crea..."
      for (Relation rel: getEntity().getRelations())  {

        if (rel.isPartOfNormText())  {
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[478]); // 1684:2 = "    buf.append("
            out.print(rel.getGetterName());
            out.print(source[479]); // 1685:38 = "()).append(',');"
          }
          else {
            out.print(source[480]); // 1689:2 = "    for ("
            out.print(rel.getClassName());
            out.print(source[481]); // 1690:31 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[482]); // 1690:60 = "()) {      buf.append(obj).append(',');..."
          }
        }
      }
      out.print(source[483]); // 1697:2 = "    return buf;  }"
    }

    if (generateIsReferencing && isEntityPersistable() && !generateMock) {
      for (Relation rel: getEntity().getTableRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          String tagName = "isReferencing" + rel.getClassName() + "By" +
                           StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[484]); // 1710:2 = "  // Determines whether any "
                           out.print(pdoName);
                           out.print(source[485]); // 1712:39 = " references given "
                           out.print(rel.getClassName());
                           out.print(source[486]); // 1712:79 = "  // @wurblet "
                           out.print(tagName);
                           out.print(source[487]); // 1713:26 = " PdoIsReferencing "
                           out.print(rel.getMethodArgs().get(0).getAttribute().getName());
                           out.print(source[488]); // 1713:99 = ""
        }
      }
    }

    if (generateSelects && isEntityPersistable() && !generateMock) {
      Set<String> wurbletArgSet = new HashSet<>();   // to avoid duplicates if args= is used
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null) {
            // force tracked even if related object is not tracked
            String trackedOption = rel.isTracked() ? "--tracked " : "";
            String joins = "";
            if (rel.getNmName() != null) {
              Relation join = rel.getNmRelation();
              if (join != null && join.getRelationType() == RelationType.OBJECT &&
                  join.getSelectionType() == SelectionType.LAZY &&
                  !join.isComposite() && join.isSerialized()) {
                joins = " *" + rel.getNmName();
              }
            }
            // add eager joins, if any
            for (Relation eRel: getEntity().getRelationsIncludingInherited()) {
              if (eRel.getSelectionType() == SelectionType.EAGER) {
                joins += " *" + eRel.getName();
              }
            }

            String extraWurbletOptions = rel.getSelectionWurbletArguments();
            if (extraWurbletOptions == null) {
              extraWurbletOptions = "";
            }
            else {
              extraWurbletOptions = " " + extraWurbletOptions;
            }
            String wurbletArgs = createRelationWurbletArgString(rel);
            if (wurbletArgSet.add(wurbletArgs)) {
              out.print(source[489]); // 1755:2 = "  // selects "
              out.print(rel);
              out.print(source[490]); // 1757:20 = ""
              if (rel.isReversed()) {
                out.print(source[491]); // 1760:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[492]); // 1761:54 = " PdoSelectUnique "
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[493]); // 1761:118 = ""
              }
              else {
                out.print(source[494]); // 1765:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[495]); // 1766:54 = " PdoSelectList "
                out.print(trackedOption);
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[496]); // 1766:133 = ""
              }
            }
          }
        }
      }
    }

    if (generateDeletes && isEntityPersistable() && !generateMock) {
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null && rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[497]); // 1783:2 = "  // deletes "
            out.print(rel);
            out.print(source[498]); // 1785:20 = "  // @wurblet "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[499]); // 1786:58 = " PdoDeleteBy "
            out.print(createRelationWurbletArgString(rel));
            out.print(source[500]); // 1786:110 = ""
          }
        }
      }
    }

    if (generateAddReferencing && !generateMock) {
      List<Relation> refRels = new ArrayList<>();
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          refRels.add(rel);
        }
      }
      if (!refRels.isEmpty()) {
        out.print(source[501]); // 1803:2 = "  // add referencing classes and their ..."
        if (getEntity().isAbstract()) {
          out.print(source[502]); // 1809:2 = "    @SuppressWarnings("unchecked")"
        }
        out.print(source[503]); // 1813:2 = "    AbstractPersistentObject<?,?> po = (..."
        out.print(pdoName);
        out.print(source[504]); // 1815:30 = ".class).getPersistenceDelegate();"
      // register referencing classes and the methods
      for (Relation rel: refRels) {
        String methodName = "isReferencing" + rel.getClassName() + "By" +
                            StringHelper.firstToUpper(rel.getMethodArgs().get(0).getAttribute().getName());
        for (Entity leaf: rel.getEntity().getLeafEntities()) {
          out.print(source[505]); // 1822:2 = "    po.addReferencingClass("
          out.print(leaf.getName());
          out.print(source[506]); // 1823:45 = ".class, ""
          out.print(methodName);
          out.print(source[507]); // 1823:68 = "");"
        }
      }
      out.print(source[508]); // 1827:2 = "  }"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
