// wurblet generated by Wurbelizer 17.3.2.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for setting up a PdoCache for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoCache
 *     [--cache=&lt;classname&gt;] [--secure] [--public] [--preload]
 *     [--mutable] [--noreg] [--udk] [--bounded]
 *     [--strategy=LRU|LFU|FORGET] [--maxsize=&lt;n&gt;] [--keepquota=&lt;p&gt;] [--configure=&lt;method&gt;]
 *     [index1] [index2] ...
 * <p>
 * arguments:
 * <ul>
 * <li><em>--cache=&lt;classname&gt;:</em> sets the cache-class. Defaults to PdoCache.</li>
 * <li><em>--secure:</em> if cache must check read permission for each access (default is no check).</li>
 * <li><em>--public:</em> makes the cache and indexes public (default is private).</li>
 * <li><em>--preload:</em> the first access will load all entities at once.</li>
 * <li><em>--mutable:</em> generates a non-shared cache, i.e. mutable PDOs (by default a shared readonly cache is generated).</li>
 * <li><em>--noreg:</em> will not register the cache globally (default is to use the factory).</li>
 * <li><em>--udk:</em> add index for the unique domain key.</li>
 * <li><em>--bounded:</em> creates List&lt;? extends T&gt; for selectAllCached instead of List&lt;T&gt;.</li>
 * <li><em>--strategy=LRU|LFU|FORGET:</em> the caching strategy (default is FORGET).</li>
 * <li><em>--maxsize=&lt;n&gt;:</em> the cache size (if not preloaded).</li>
 * <li><em>--keepquota=&lt;p&gt;:</em> percentage of entries to keep when applying caching strategy. Default is 50.</li>
 * <li><em>--configure=&lt;method&gt;:</em> an optional method to further configure the cache.</li>
 * <li><em>--index&lt;n&gt;:</em> additional unique indexes. By default, only the ID-index will be created.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoCache extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {

    // main class
    String pdoName     = getPdoClassName();

    boolean secure     = false;
    boolean preload    = false;
    boolean mutable    = false;
    boolean delayed    = true;
    boolean noreg      = false;
    boolean genudk     = false;
    boolean bounded    = false;

    String cache       = "PdoCache";
    String scope       = "private";

    String strategy    = null;
    Integer maxSize    = null;
    Integer keepQuota  = null;
    String configure   = null;

    for (String arg: getOptionArgs())  {
      if (arg.equals("preload")) {
        preload = true;
      }
      else if (arg.equals("secure")) {
        secure = true;
      }
      else if (arg.equals("mutable")) {
        mutable = true;
      }
      else if (arg.equals("immediate")) {
        delayed = false;
      }
      else if (arg.equals("public")) {
        scope = "public";
      }
      else if (arg.equals("noreg")) {
        noreg = true;
      }
      else if (arg.equals("bounded")) {
        bounded = true;
      }
      else if (arg.equals("udk")) {
        genudk = true;
      }
      else if (arg.startsWith("cache=")) {
        cache = arg.substring(6);
      }
      else if (arg.startsWith("strategy=")) {
        strategy = arg.substring(9).toUpperCase();
      }
      else if (arg.startsWith("maxsize=")) {
        maxSize = Integer.valueOf(arg.substring(8));
      }
      else if (arg.startsWith("keepquota=")) {
        keepQuota = Integer.valueOf(arg.substring(10));
      }
      else if (arg.startsWith("configure=")) {
        configure = arg.substring(10);
      }
    }

    if (secure && !getEntity().isRootEntity()) {
      throw new WurbelException(getEntity() + " is not a root-entity");
    }

    // align args
    if (!cache.equals("PdoCache"))  {
      noreg = true;
    }

    List<Attribute> udk = null;
    String udkType = null;
    String udkName = null;
    String udkSuffix = null;
    if (genudk) {
      udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        if (udk.size() == 1) {
          udkType = udk.get(0).getJavaType();
          udkName = udk.get(0).getName();
          udkSuffix = udk.get(0).getMethodNameSuffix();
        }
        else {
          udkType = getEntity().getName() + "UDK";
          udkName = "udk";
          udkSuffix = "UniqueDomainKey";
          udkType = getEntity().getName() + "." + udkType;
        }
      }
      else {
        udk = null;
        genudk = false;
      }
    }


    if (getEntity().isAbstract()) {
      List<Entity> leafs = getEntity().getLeafEntities();
      out.print(source[0]); // 131:2 = "  @Override  @SuppressWarnings("unchec..."
      boolean first = true;
      for (Entity leaf: leafs) {
        if (first)  {
          out.print(source[1]); // 140:2 = "    T pdo = (T) Pdo.create("
          out.print(leaf);
          out.print(source[2]); // 141:35 = ".class, getDomainContext()).selectCached..."
          first = false;
        }
        else {
          out.print(source[3]); // 146:2 = "    if (pdo == null) {      pdo = (T) P..."
          out.print(leaf);
          out.print(source[4]); // 148:35 = ".class, getDomainContext()).selectCached..."
        }
      }
      out.print(source[5]); // 153:2 = "    return pdo;  }  @Override  @Supp..."
      first = true;
      for (Entity leaf: leafs) {
        if (first)  {
          out.print(source[6]); // 164:2 = "    T pdo = (T) Pdo.create("
          out.print(leaf);
          out.print(source[7]); // 165:35 = ".class, getDomainContext()).selectCached..."
          first = false;
        }
        else {
          out.print(source[8]); // 170:2 = "    if (pdo == null) {      pdo = (T) P..."
          out.print(leaf);
          out.print(source[9]); // 172:35 = ".class, getDomainContext()).selectCached..."
        }
      }
      out.print(source[10]); // 177:2 = "    return pdo;  }"

      if (preload) {
        out.print(source[11]); // 183:2 = "  @Override  @SuppressWarnings("unchec..."
        for (Entity leaf: leafs) {
          out.print(source[12]); // 191:2 = "    pdos.addAll((Collection<? extends T>..."
          out.print(leaf);
          out.print(source[13]); // 192:61 = ".class, getDomainContext()).selectAllCac..."
        }
        out.print(source[14]); // 195:2 = "    return pdos;  }"
      }

      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        out.print(source[15]); // 205:2 = "  @Override  @SuppressWarnings("unchec..."
        out.print(suffix);
        out.print(source[16]); // 209:35 = "("
        out.print(type);
        out.print(source[17]); // 209:44 = " "
        out.print(name);
        out.print(source[18]); // 209:53 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[19]); // 214:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[20]); // 215:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[21]); // 215:87 = "("
            out.print(name);
            out.print(source[22]); // 215:96 = ");"
            first = false;
          }
          else {
            out.print(source[23]); // 220:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[24]); // 222:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[25]); // 222:87 = "("
            out.print(name);
            out.print(source[26]); // 222:96 = ");    }"
          }
        }
        out.print(source[27]); // 227:2 = "    return pdo;  }  @Override  @Supp..."
        out.print(suffix);
        out.print(source[28]); // 233:39 = "("
        out.print(type);
        out.print(source[29]); // 233:48 = " "
        out.print(key.getName());
        out.print(source[30]); // 233:66 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[31]); // 238:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[32]); // 239:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[33]); // 239:91 = "("
            out.print(key.getName());
            out.print(source[34]); // 239:109 = ");"
            first = false;
          }
          else {
            out.print(source[35]); // 244:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[36]); // 246:35 = ".class, getDomainContext()).selectCached..."
            out.print(suffix);
            out.print(source[37]); // 246:91 = "("
            out.print(key.getName());
            out.print(source[38]); // 246:109 = ");    }"
          }
        }
        out.print(source[39]); // 251:2 = "    return pdo;  }"
      }

      if (genudk) {
        out.print(source[40]); // 258:2 = "  @Override  @SuppressWarnings("unchec..."
        out.print(udkType);
        out.print(source[41]); // 262:52 = " "
        out.print(udkName);
        out.print(source[42]); // 262:64 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[43]); // 267:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[44]); // 268:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[45]); // 268:104 = ");"
            first = false;
          }
          else {
            out.print(source[46]); // 273:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[47]); // 275:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[48]); // 275:104 = ");    }"
          }
        }
        out.print(source[49]); // 280:2 = "    return pdo;  }  @Override  @Supp..."
        out.print(udkType);
        out.print(source[50]); // 286:56 = " "
        out.print(udkName);
        out.print(source[51]); // 286:68 = ") {"
        first = true;
        for (Entity leaf: leafs) {
          if (first)  {
            out.print(source[52]); // 291:2 = "    T pdo = (T) Pdo.create("
            out.print(leaf);
            out.print(source[53]); // 292:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[54]); // 292:108 = ");"
            first = false;
          }
          else {
            out.print(source[55]); // 297:2 = "    if (pdo == null) {      pdo = (T) P..."
            out.print(leaf);
            out.print(source[56]); // 299:35 = ".class, getDomainContext()).selectCached..."
            out.print(udkName);
            out.print(source[57]); // 299:108 = ");    }"
          }
        }
        out.print(source[58]); // 304:2 = "    return pdo;  }"
      }
    }
    else  {
      out.print(source[59]); // 311:2 = "  /** the cache. */  "
      out.print(scope);
      out.print(source[60]); // 314:11 = " static "
      out.print(cache);
      out.print(source[61]); // 314:28 = "<"
      out.print(pdoName);
      out.print(source[62]); // 314:40 = "> cache;"
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        out.print(source[63]); // 319:2 = "  /** index for "
        out.print(name);
        out.print(source[64]); // 321:24 = ". */  "
        out.print(scope);
        out.print(source[65]); // 322:11 = " static PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[66]); // 322:44 = ", "
        out.print(type);
        out.print(source[67]); // 322:54 = "> "
        out.print(name);
        out.print(source[68]); // 322:64 = "Index;"
      }

      if (genudk) {
        out.print(source[69]); // 327:2 = "  /** index for the unique domain key. ..."
        out.print(scope);
        out.print(source[70]); // 330:11 = " static PdoCacheIndex<"
        out.print(pdoName);
        out.print(source[71]); // 330:44 = ", "
        out.print(udkType);
        out.print(source[72]); // 330:57 = "> udkIndex;"
      }
      out.print(source[73]); // 333:2 = "  /**   * Creates the cache singleton ..."
      out.print(cache);
      out.print(source[74]); // 340:39 = "<"
      out.print(pdoName);
      out.print(source[75]); // 340:51 = "> createCache() {    if (cache == null)..."
      if (noreg) {
        out.print(source[76]); // 344:2 = "      cache = new "
        out.print(cache);
        out.print(source[77]); // 345:27 = "<"
        out.print(pdoName);
        out.print(source[78]); // 345:39 = "> ("
        out.print(pdoName);
        out.print(source[79]); // 345:53 = ".class, "
        out.print(preload ? "true" : "false");
        out.print(source[80]); // 345:91 = ", "
        out.print(mutable ? "false" : "true");
        out.print(source[81]); // 345:123 = ", "
        out.print(secure ? "true" : "false");
        out.print(source[82]); // 345:154 = ");"
      }
      else {
        out.print(source[83]); // 349:2 = "      cache = Pdo.createPdoCache("
        out.print(pdoName);
        out.print(source[84]); // 350:44 = ".class, "
        out.print(preload ? "true" : "false");
        out.print(source[85]); // 350:82 = ", "
        out.print(mutable ? "false" : "true");
        out.print(source[86]); // 350:114 = ", "
        out.print(secure ? "true" : "false");
        out.print(source[87]); // 350:145 = ");"
      }

      if (strategy != null) {
        out.print(source[88]); // 355:2 = "      cache.setStrategy(PdoCacheStrategy..."
        out.print(strategy);
        out.print(source[89]); // 356:53 = ");"
      }

      if (maxSize != null) {
        out.print(source[90]); // 361:2 = "      cache.setMaxSize("
        out.print(maxSize);
        out.print(source[91]); // 362:34 = ");"
      }

      if (keepQuota != null) {
        out.print(source[92]); // 367:2 = "      cache.setKeepQuota("
        out.print(keepQuota);
        out.print(source[93]); // 368:38 = ");"
      }

      if (configure != null) {
        out.print(source[94]); // 373:2 = "      "
        out.print(configure);
        out.print(source[95]); // 374:19 = "(cache);"
      }

      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplStream();
          PrintStream remoteOut = genInc.getRemoteStream();
          remoteOut.print(source[96]); // 387:16 = "  "
          remoteOut.print(pdoName);
          remoteOut.print(source[97]); // 388:13 = " selectBy"
          remoteOut.print(suffix);
          remoteOut.print(source[98]); // 388:32 = "ForCache(DomainContext context, "
          remoteOut.print(type);
          remoteOut.print(source[99]); // 388:72 = " "
          remoteOut.print(name);
          remoteOut.print(source[100]); // 388:81 = ") throws RemoteException;"
          implOut.print(source[101]); // 389:14 = "  @Override  public "
          implOut.print(pdoName);
          implOut.print(source[102]); // 392:20 = " selectBy"
          implOut.print(suffix);
          implOut.print(source[103]); // 392:39 = "ForCache(DomainContext context, "
          implOut.print(type);
          implOut.print(source[104]); // 392:79 = " "
          implOut.print(name);
          implOut.print(source[105]); // 392:88 = ") throws RemoteException {    try {   ..."
          implOut.print(suffix);
          implOut.print(source[106]); // 394:58 = "("
          implOut.print(name);
          implOut.print(source[107]); // 394:67 = ");    }    catch (RuntimeException e) ..."
          out.print(source[108]); // 400:6 = "      "
          out.print(name);
          out.print(source[109]); // 401:14 = "Index = new PdoCacheIndex<>(""
          out.print(pdoName);
          out.print(source[110]); // 401:54 = ":"
          out.print(name);
          out.print(source[111]); // 401:63 = "") {        @Override        public "
          out.print(pdoName);
          out.print(source[112]); // 403:26 = " select(DomainContext context, "
          out.print(type);
          out.print(source[113]); // 403:65 = " "
          out.print(name);
          out.print(source[114]); // 403:74 = ") {          return Pdo.create("
          out.print(pdoName);
          out.print(source[115]); // 404:39 = ".class, context).selectBy"
          out.print(suffix);
          out.print(source[116]); // 404:74 = "ForCache("
          out.print(name);
          out.print(source[117]); // 404:91 = ");        }        @Override        p..."
          out.print(type);
          out.print(source[118]); // 407:23 = " extract("
          out.print(pdoName);
          out.print(source[119]); // 407:43 = " pdo) {          return pdo.get"
          out.print(suffix);
          out.print(source[120]); // 408:34 = "();        }      };"
        }
        else {
          out.print(source[121]); // 414:2 = "      "
          out.print(name);
          out.print(source[122]); // 415:14 = "Index = new PdoCacheIndex<>(""
          out.print(pdoName);
          out.print(source[123]); // 415:54 = ":"
          out.print(name);
          out.print(source[124]); // 415:63 = "") {        @Override        public "
          out.print(pdoName);
          out.print(source[125]); // 417:26 = " select(DomainContext context, "
          out.print(type);
          out.print(source[126]); // 417:65 = " "
          out.print(name);
          out.print(source[127]); // 417:74 = ") {          return Pdo.create("
          out.print(pdoName);
          out.print(source[128]); // 418:39 = ".class, context).findBy"
          out.print(suffix);
          out.print(source[129]); // 418:72 = "("
          out.print(name);
          out.print(source[130]); // 418:81 = ");        }        @Override        p..."
          out.print(type);
          out.print(source[131]); // 421:23 = " extract("
          out.print(pdoName);
          out.print(source[132]); // 421:43 = " pdo) {          return pdo.get"
          out.print(suffix);
          out.print(source[133]); // 422:34 = "();        }      };"
        }
      }

      if (genudk) {
        out.print(source[134]); // 430:2 = "      udkIndex = new PdoCacheIndex<>(""
        out.print(pdoName);
        out.print(source[135]); // 431:49 = ":UDK") {        @Override        publi..."
        out.print(pdoName);
        out.print(source[136]); // 433:26 = " select(DomainContext context, "
        out.print(udkType);
        out.print(source[137]); // 433:68 = " "
        out.print(udkName);
        out.print(source[138]); // 433:80 = ") {"
        if (isRemote()) {
          RemoteIncludes genInc = new RemoteIncludes(this);
          PrintStream implOut   = genInc.getImplStream();
          PrintStream remoteOut = genInc.getRemoteStream();
          remoteOut.print(source[139]); // 440:16 = "  "
          remoteOut.print(pdoName);
          remoteOut.print(source[140]); // 441:13 = " selectByUniqueDomainKeyForCache(DomainC..."
          remoteOut.print(udkType);
          remoteOut.print(source[141]); // 441:80 = " "
          remoteOut.print(udkName);
          remoteOut.print(source[142]); // 441:92 = ") throws RemoteException;"
          implOut.print(source[143]); // 442:14 = "  @Override  public "
          implOut.print(pdoName);
          implOut.print(source[144]); // 445:20 = " selectByUniqueDomainKeyForCache(DomainC..."
          implOut.print(udkType);
          implOut.print(source[145]); // 445:87 = " "
          implOut.print(udkName);
          implOut.print(source[146]); // 445:99 = ") throws RemoteException {    try {   ..."
          implOut.print(udkName);
          implOut.print(source[147]); // 447:75 = ");    }    catch (RuntimeException e) ..."
          out.print(source[148]); // 453:6 = "          return Pdo.create("
          out.print(pdoName);
          out.print(source[149]); // 454:39 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[150]); // 454:99 = ");"
        }
        else {
          out.print(source[151]); // 458:2 = "          return Pdo.create("
          out.print(pdoName);
          out.print(source[152]); // 459:39 = ".class, context).selectByUniqueDomainKey..."
          out.print(udkName);
          out.print(source[153]); // 459:91 = ");"
        }
        out.print(source[154]); // 462:2 = "        }        @Override        publ..."
        out.print(udkType);
        out.print(source[155]); // 465:26 = " extract("
        out.print(pdoName);
        out.print(source[156]); // 465:46 = " pdo) {          return pdo.get"
        out.print(udkSuffix);
        out.print(source[157]); // 466:37 = "();        }      };"
      }

      if (delayed)  {
        out.print(source[158]); // 473:2 = "      Pdo.listen(ev -> cache.expire(ev.g..."
        out.print(pdoName);
        out.print(source[159]); // 474:64 = ".class);"
      }
      else {
        out.print(source[160]); // 478:2 = "      Pdo.listen(ev -> cache.expire(ev.g..."
        out.print(pdoName);
        out.print(source[161]); // 479:81 = ".class);"
      }
      out.print(source[162]); // 482:2 = "    }    return cache;  }  @Override..."
      out.print(bounded ? "? extends " : "");
      out.print(pdoName);
      out.print(source[163]); // 488:60 = "> getCache() {    return cache == null ..."
      out.print(pdoName);
      out.print(source[164]); // 509:20 = " selectCachedOnly(long id) {    return ..."
      out.print(pdoName);
      out.print(source[165]); // 514:20 = " selectCached(long id) {    return getC..."
      for (WurbletArgument key: getExpressionArguments()) {
        String name = key.getMethodArgumentName();
        String type = key.getAttribute().getJavaType();
        String suffix = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        out.print(source[166]); // 522:2 = "  /**   * Selects from cache by "
        out.print(name);
        out.print(source[167]); // 525:35 = " but does not load from db if not in cac..."
        out.print(name);
        out.print(source[168]); // 527:21 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[169]); // 531:20 = " selectCachedOnlyBy"
        out.print(suffix);
        out.print(source[170]); // 531:49 = "("
        out.print(type);
        out.print(source[171]); // 531:58 = " "
        out.print(name);
        out.print(source[172]); // 531:67 = ")  {    return getCache().select("
        out.print(name);
        out.print(source[173]); // 532:37 = "Index, getDomainContext(), "
        out.print(name);
        out.print(source[174]); // 532:72 = ", false);  }  /**   * Selects via ca..."
        out.print(name);
        out.print(source[175]); // 536:34 = ".   *   * @param "
        out.print(name);
        out.print(source[176]); // 538:21 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[177]); // 542:20 = " selectCachedBy"
        out.print(suffix);
        out.print(source[178]); // 542:45 = "("
        out.print(type);
        out.print(source[179]); // 542:54 = " "
        out.print(name);
        out.print(source[180]); // 542:63 = ")  {    return getCache().select("
        out.print(name);
        out.print(source[181]); // 543:37 = "Index, getDomainContext(), "
        out.print(name);
        out.print(source[182]); // 543:72 = ");  }  /**   * Selects via remote ca..."
        out.print(name);
        out.print(source[183]); // 547:41 = ", if session is remote.   *   * @param..."
        out.print(name);
        out.print(source[184]); // 549:21 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[185]); // 553:20 = " selectBy"
        out.print(suffix);
        out.print(source[186]); // 553:39 = "ForCache("
        out.print(type);
        out.print(source[187]); // 553:56 = " "
        out.print(name);
        out.print(source[188]); // 553:65 = ") {    "
        out.print(pdoName);
        out.print(source[189]); // 554:15 = " obj;    if (getSession().isRemote()) {..."
        out.print(suffix);
        out.print(source[190]); // 558:52 = "ForCache(context, "
        out.print(name);
        out.print(source[191]); // 558:78 = ");        configureRemoteObject(context..."
        out.print(suffix);
        out.print(source[192]); // 566:33 = "("
        out.print(name);
        out.print(source[193]); // 566:42 = ");    }    return obj;  }"
      }

      if (genudk) {
        out.print(source[194]); // 574:2 = "  /**   * Selects from cache by unique..."
        out.print(udkName);
        out.print(source[195]); // 579:24 = " the unique domain key   * @return the ..."
        out.print(pdoName);
        out.print(source[196]); // 583:20 = " selectCachedOnlyByUniqueDomainKey("
        out.print(udkType);
        out.print(source[197]); // 583:66 = " "
        out.print(udkName);
        out.print(source[198]); // 583:78 = ")  {    return getCache().select(udkInd..."
        out.print(udkName);
        out.print(source[199]); // 584:70 = ", false);  }  /**   * Selects via ca..."
        out.print(udkName);
        out.print(source[200]); // 590:24 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[201]); // 594:20 = " selectCachedByUniqueDomainKey("
        out.print(udkType);
        out.print(source[202]); // 594:62 = " "
        out.print(udkName);
        out.print(source[203]); // 594:74 = ")  {    return getCache().select(udkInd..."
        out.print(udkName);
        out.print(source[204]); // 595:70 = ");  }  /**   * Selects via remote ca..."
        out.print(udkName);
        out.print(source[205]); // 601:24 = " the unique key   * @return the pdo, nu..."
        out.print(pdoName);
        out.print(source[206]); // 605:20 = " selectByUniqueDomainKeyForCache("
        out.print(udkType);
        out.print(source[207]); // 605:64 = " "
        out.print(udkName);
        out.print(source[208]); // 605:76 = ") {    "
        out.print(pdoName);
        out.print(source[209]); // 606:15 = " obj;    if (getSession().isRemote()) {..."
        out.print(udkName);
        out.print(source[210]); // 610:86 = ");        configureRemoteObject(context..."
        out.print(udkName);
        out.print(source[211]); // 618:50 = ");    }    return obj;  }"
      }

      if (preload)  {
        out.print(source[212]); // 626:2 = "  @Override  public List<"
        out.print(bounded ? "? extends " : "");
        out.print(pdoName);
        out.print(source[213]); // 629:56 = "> selectAllCached() {    return getCach..."
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
