/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.ComponentInfo;
import org.tentackle.wurblet.JoinPath;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class PdoSelectUnique
extends DbModelWurblet {
    public PdoSelectUnique() {
        this.setConfiguration("pathAllowed");
    }

    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + this + " failed", t);
        }
    }

    private void wurbel() throws WurbelException, ModelException {
        String orderByStr;
        boolean needSuppressWarnings;
        String pdoName;
        this.assertEntityNotEmbedded();
        this.assertEntityIsPersistable();
        String className = this.getClassName();
        String methodName = this.getMethodName();
        String pdoType = pdoName = this.getPdoClassName();
        String returnType = pdoName;
        String poType = className;
        Object classVar = null;
        if (this.isGenerified()) {
            returnType = "T";
            poType = "P";
        }
        boolean sort = false;
        boolean lock = false;
        String append = null;
        boolean noif = false;
        String scope = "public";
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("private")) {
                scope = "private";
                noif = true;
                continue;
            }
            if (arg.equals("noif")) {
                noif = true;
                continue;
            }
            if (arg.equals("sort")) {
                if (this.isWithDefaultSorting()) {
                    if (this.isWithSorting()) {
                        throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                    }
                    sort = true;
                    continue;
                }
                throw new WurbelException("no sorting configured in model for " + this.getEntity());
            }
            if (arg.equals("lock")) {
                lock = true;
                continue;
            }
            if (arg.startsWith("append=")) {
                append = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("classvar=")) continue;
            classVar = arg.substring(9);
        }
        if (scope.equals("private")) {
            this.setRemote(false);
            noif = true;
        }
        classVar = classVar == null ? "" : (String)classVar + ".";
        if (methodName == null) {
            throw new WurbelException("can't determine <methodname>");
        }
        if (this.getExpressionArguments().isEmpty() && !sort && !this.isWithSorting() && append == null && this.getContextAttribute() == null) {
            throw new WurbelException("no keys given");
        }
        String params = this.buildMethodParameters();
        String iparms = this.buildInvocationParameters();
        String statementId = this.createStatementId();
        String reflMethod = this.getGuardName() + "Method";
        boolean needLimit = sort || append != null || this.createOrderBy() != null;
        String alias = this.getEntity().getTopSuperEntity().getTableAlias();
        String poImpl = this.deriveClassNameForEntity(this.getEntity());
        List<JoinPath> joinPaths = this.getJoinPaths();
        boolean withJoins = !joinPaths.isEmpty();
        boolean bl = needSuppressWarnings = withJoins && this.isAbstractJoinPath(joinPaths);
        if (!noif) {
            this.out.print(this.source[0]);
        }
        if (needSuppressWarnings) {
            this.out.print(this.source[1]);
        }
        this.out.print(this.source[2]);
        this.out.print(scope);
        this.out.print(this.source[3]);
        this.out.print(returnType);
        this.out.print(this.source[4]);
        this.out.print(methodName);
        this.out.print(this.source[5]);
        this.out.print(this.as(params));
        this.out.print(this.source[6]);
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplStream();
            PrintStream remoteOut = genInc.getRemoteStream();
            if (this.isPdoProvidingArguments()) {
                this.out.print(this.source[7]);
                remoteOut.print(this.source[8]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[9]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[10]);
                remoteOut.print(this.pcs(params, returnType + " obj"));
                remoteOut.print(this.source[11]);
                implOut.print(this.source[12]);
                implOut.print(returnType);
                implOut.print(this.source[13]);
                implOut.print(methodName);
                implOut.print(this.source[14]);
                implOut.print(this.pcs(params, returnType + " obj"));
                implOut.print(this.source[15]);
                implOut.print(poType);
                implOut.print(this.source[16]);
                implOut.print(methodName);
                implOut.print(this.source[17]);
                implOut.print(iparms);
                implOut.print(this.source[18]);
                this.out.print(this.source[19]);
                this.out.print(returnType);
                this.out.print(this.source[20]);
                this.out.print(methodName);
                this.out.print(this.source[21]);
                this.out.print(this.pcs(iparms, "me()"));
                this.out.print(this.source[22]);
            } else {
                this.out.print(this.source[23]);
                remoteOut.print(this.source[24]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[25]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[26]);
                remoteOut.print(this.pcs(params, "DomainContext context"));
                remoteOut.print(this.source[27]);
                implOut.print(this.source[28]);
                implOut.print(returnType);
                implOut.print(this.source[29]);
                implOut.print(methodName);
                implOut.print(this.source[30]);
                implOut.print(this.pcs(params, "DomainContext context"));
                implOut.print(this.source[31]);
                implOut.print(methodName);
                implOut.print(this.source[32]);
                implOut.print(iparms);
                implOut.print(this.source[33]);
                this.out.print(this.source[34]);
                this.out.print(returnType);
                this.out.print(this.source[35]);
                this.out.print(methodName);
                this.out.print(this.source[36]);
                this.out.print(this.pcs(iparms, "getDomainContext()"));
                this.out.print(this.source[37]);
            }
        }
        if (withJoins) {
            this.out.print(this.createJoins());
        }
        if (lock) {
            this.out.print(this.source[38]);
        }
        this.out.print(this.source[39]);
        this.out.print((String)classVar);
        this.out.print(statementId);
        this.out.print(this.source[40]);
        if (this.getEntity().getSuperEntity() != null && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[41]);
        }
        boolean andPrepended = false;
        if (this.getContextAttribute() != null) {
            andPrepended = true;
            this.out.print(this.source[42]);
            this.out.print(this.getColumnNameConstant(this.getContextAttribute(), 0));
            this.out.print(this.source[43]);
        }
        boolean needParentheses = false;
        if (!this.getExpressionArguments().isEmpty()) {
            needParentheses = this.getExpression().needParenthesesAfterAndOperator();
            if (andPrepended || needParentheses) {
                this.out.print(this.source[44]);
            } else {
                this.out.print(this.source[45]);
                if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[46]);
                }
            }
            CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                public String generate(Object t) throws WurbelException {
                    if (t instanceof WurbletArgumentOperator) {
                        return "        sql.append(Backend." + ((WurbletArgumentOperator)t).getSql() + ");\n";
                    }
                    if (t instanceof WurbletArgumentExpression) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                        buf.append(((WurbletArgumentExpression)t).toCode((CodeGenerator)this));
                        buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        return buf.toString();
                    }
                    if (t instanceof WurbletArgument) {
                        StringBuilder buf = new StringBuilder();
                        WurbletArgument arg = (WurbletArgument)t;
                        Attribute attr = arg.getAttribute();
                        if (arg.isPath()) {
                            Set existsRels = arg.getExistsRelations();
                            if (existsRels != null) {
                                String rightClass;
                                ComponentInfo ci;
                                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                                String comma = "";
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoSelectUnique.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(comma).append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableAlias())\n");
                                }
                                for (Relation rel : existsRels) {
                                    rightClass = PdoSelectUnique.this.deriveClassNameForEntity(rel.getForeignEntity());
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                }
                                buf.append("           .append(Backend.SQL_WHERE)\n");
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoSelectUnique.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(").append(ci.getRootIdColumnName()).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(ci.getRootIdClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID))\n").append("           .append(Backend.SQL_AND)\n");
                                }
                                for (Relation rel : existsRels) {
                                    String rightAttribute;
                                    Object leftAttribute;
                                    boolean isEmbeddingRelation = false;
                                    if (rel.getRelationType() == RelationType.OBJECT) {
                                        if (rel.isEmbedded()) {
                                            isEmbeddingRelation = true;
                                            leftAttribute = "\"" + arg.getEmbeddingColumnPrefix() + ((MethodArgument)rel.getMethodArgs().get(0)).getAttribute().getColumnName() + "\"";
                                        } else {
                                            leftAttribute = PdoSelectUnique.this.getColumnNameConstant(rel.getAttribute(), 0);
                                        }
                                        rightAttribute = "CN_ID";
                                    } else {
                                        leftAttribute = "CN_ID";
                                        rightAttribute = PdoSelectUnique.this.getColumnNameConstant(rel.getForeignAttribute(), 0);
                                    }
                                    String leftClass = rel.getEntity().equals(PdoSelectUnique.this.getEntity()) ? "" : PdoSelectUnique.this.deriveClassNameForEntity(rel.getEntity()) + ".";
                                    String leftClassVariables = leftClass.isEmpty() || isEmbeddingRelation ? "" : leftClass + "CLASSVARIABLES.";
                                    rightClass = rel.getForeignEntity().equals(PdoSelectUnique.this.getEntity()) ? "" : PdoSelectUnique.this.deriveClassNameForEntity(rel.getForeignEntity()) + ".";
                                    buf.append("           .append(").append(leftClassVariables).append("getColumnName(").append((String)leftAttribute).append(")).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(rightAttribute).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    List methodArgs = rel.getMethodArgs();
                                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                                        Attribute mattr = methodArg.getForeignAttribute();
                                        buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(PdoSelectUnique.this.getColumnNameConstant(mattr, 0)).append("))\n");
                                        if (methodArg.isValue()) {
                                            buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            for (int columnIndex = 1; columnIndex < PdoSelectUnique.this.getEffectiveDataType(attr).getColumnCount(null); ++columnIndex) {
                                                buf.append("           .append(Backend.SQL_AND)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex)).append("))\n").append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            }
                                        } else {
                                            buf.append("           .append(Backend.SQL_EQUAL).append(").append(leftClassVariables).append("getColumnName(").append(leftClassVariables).append(PdoSelectUnique.this.getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                                        }
                                        buf.append("           .append(Backend.SQL_AND)\n");
                                    }
                                }
                                buf.deleteCharAt(buf.length() - 1);
                                buf.append(";\n");
                            }
                            String compKeyClass = PdoSelectUnique.this.deriveClassNameForEntity(attr.getEmbeddingPath() == null ? attr.getEntity() : (Entity)attr.getEmbeddingPath().get(0));
                            for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); ++columnIndex) {
                                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (arg.getColumnIndex() != null && columnIndex != arg.getColumnIndex()) continue;
                                buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(");
                                if (attr.getEmbeddingPath() != null) {
                                    try {
                                        buf.append('\"').append(attr.getColumnName(null, columnIndex)).append("\"))\n");
                                    }
                                    catch (ModelException mx) {
                                        throw new WurbelException("cannot determine embedded column name", (Throwable)mx);
                                    }
                                } else {
                                    buf.append(compKeyClass).append('.').append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex)).append("))\n");
                                }
                                buf.append("           ").append(PdoSelectUnique.this.createRelopCode(arg)).append(";\n");
                            }
                        } else {
                            for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); ++columnIndex) {
                                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (arg.getColumnIndex() != null && columnIndex != arg.getColumnIndex()) continue;
                                if (PdoSelectUnique.this.isPathAllowed()) {
                                    if (PdoSelectUnique.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                        buf.append("        sql.append(");
                                        buf.append(PdoSelectUnique.this.deriveClassNameForEntity(attr.getEntity()));
                                        buf.append(".CLASSVARIABLES.getColumnName(");
                                        buf.append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex)).append("));\n");
                                    } else if (PdoSelectUnique.this.isPdo()) {
                                        buf.append("        sql.append(getColumnName(");
                                        if (attr.isEmbedded()) {
                                            buf.append('\"').append(attr.getColumnName()).append('\"');
                                        } else {
                                            buf.append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex));
                                        }
                                        buf.append("));\n");
                                    } else {
                                        buf.append("        sql.append(").append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex)).append(");\n");
                                    }
                                } else {
                                    buf.append("        sql.append(");
                                    if (attr.isEmbedded()) {
                                        buf.append("getColumnPrefix() + ");
                                    }
                                    buf.append(PdoSelectUnique.this.getColumnNameConstant(attr, columnIndex)).append(");\n");
                                }
                                buf.append("        sql").append(PdoSelectUnique.this.createRelopCode(arg)).append(";\n");
                            }
                        }
                        if (arg.isEndOfExistsClause()) {
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        }
                        return buf.toString();
                    }
                    return "        sql.append(" + t + ");\n";
                }
            };
            String code = this.getExpression().toCode((CodeGenerator)generator);
            if (code.endsWith("\n")) {
                code = code.substring(0, code.length() - 1);
            }
            this.out.print(code);
            this.out.print(this.source[47]);
            if (andPrepended || needParentheses) {
                this.out.print(this.source[48]);
            } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[49]);
            }
        }
        if ((orderByStr = this.createOrderBy()) != null) {
            this.out.print(this.source[50]);
            this.out.print(orderByStr);
            this.out.print(this.source[51]);
        }
        this.out.print(this.source[52]);
        this.out.print(lock ? "true" : "false");
        this.out.print(this.source[53]);
        this.out.print(needLimit ? 1 : 0);
        this.out.print(this.source[54]);
        if (sort) {
            this.out.print(this.source[55]);
        }
        if (append != null) {
            this.out.print(this.source[56]);
            this.out.print(append);
            this.out.print(this.source[57]);
        }
        if (withJoins) {
            this.out.print(this.source[58]);
        }
        this.out.print(this.source[59]);
        if (needLimit) {
            this.out.print(this.source[60]);
        } else {
            this.out.print(this.source[61]);
        }
        if (this.isWithJoins()) {
            this.out.print(this.createJoinSetPars());
        }
        if (this.getContextAttribute() != null) {
            this.out.print(this.source[62]);
            this.out.print(this.createJdbcSetterName(this.getContextAttribute().getDataType()));
            this.out.print(this.source[63]);
            this.out.print(this.getContextAttribute().getName());
            this.out.print(this.source[64]);
        }
        for (WurbletArgument par : this.getMethodArguments()) {
            Set existsRels;
            if (par.isPath() && (existsRels = par.getExistsRelations()) != null) {
                for (Relation rel : existsRels) {
                    List methodArgs = rel.getMethodArgs();
                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                        if (!methodArg.isValue()) continue;
                        Attribute attr = methodArg.getForeignAttribute();
                        this.out.print(this.source[65]);
                        this.out.print(this.createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                        this.out.print(this.source[66]);
                    }
                }
            }
            if (par.isValueLiterally()) continue;
            this.out.print(this.source[67]);
            this.out.print(this.createWhereSetPars(par));
            this.out.print(this.source[68]);
        }
        if (needLimit) {
            this.out.print(this.source[69]);
        }
        if (withJoins) {
            this.out.print(this.source[70]);
        } else {
            this.out.print(this.source[71]);
        }
        this.out.print(this.source[72]);
        if (((String)classVar).isEmpty()) {
            this.out.print(this.source[73]);
            this.out.print(statementId);
            this.out.print(this.source[74]);
        }
    }

    public String process(String code) {
        int ref = ((String)code).lastIndexOf("ndx");
        int pos = ((String)code).lastIndexOf("(ndx++,");
        if (pos >= 0 && ref == pos + 1) {
            code = ((String)code).substring(0, pos + 4) + ((String)code).substring(pos + 6);
        } else {
            pos = ((String)code).lastIndexOf("ndx += st.set(");
            if (pos >= 0 && ref > pos) {
                code = ((String)code).substring(0, pos) + ((String)code).substring(pos + 7);
            } else {
                pos = ((String)code).lastIndexOf(", ndx++, ");
                if (pos >= 0 && ref > pos) {
                    code = ((String)code).substring(0, pos + 5) + ((String)code).substring(pos + 7);
                }
            }
        }
        return code;
    }
}

