// wurblet generated by Wurbelizer 17.5.1.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code for related entities.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; PdoRelations
 *     [--loadcomponents|--noloadcomponents]
 *     [--insertcomponents|--noinsertcomponents]
 *     [--deletecomponents|--nodeletecomponents]
 *     [--nori] [--noselects] [--nodeletes] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--loadcomponents|--noloadcomponents:</em> force (no) generation of loadComponents().</li>
 * <li><em>--insertcomponents|--noinsertcomponents:</em> force (no) generation of insertPlainWithComponents().</li>
 * <li><em>--deletecomponents|--nodeletecomponents:</em> force (no) generation of deletePlainWithComponents().</li>
 * <li><em>--nori:</em> don't generate PdoIsReferencing wurblet anchors and addReferencingClass() invocations.</li>
 * <li><em>--noselects:</em> don't generate PdoSelect... wurblet anchors.</li>
 * <li><em>--nodeletes:</em> don't generate PdoDelete... wurblet anchors.</li>
 * <li><em>--novalidate:</em> don't generate validate method.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class PdoRelations extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();

    String pdoName = null;
    try {
      // in implementation
      pdoName = getPdoClassName();
    }
    catch (WurbelException we) {
      // in interface
      pdoName = getClassName();
    }

    boolean generateDeclarations                    = false;
    boolean generateIsModified                      = false;
    boolean generateIsComposite                     = false;
    boolean generateSaveReferencingRelations        = false;
    boolean generateSaveReferencedRelations         = false;
    boolean generateDeleteReferencingRelations      = false;
    boolean generateDeleteReferencedRelations       = false;
    boolean generateLazyDeleteReferencingRelations  = false;
    boolean generateLazyDeleteReferencedRelations   = false;
    boolean generateSetSession                      = false;
    Boolean generateLoadComponents                  = null;
    Boolean generateInsertComponents                = null;
    Boolean generateDeleteComponents                = null;
    boolean generateMarkDeleted                     = false;
    boolean generateIsReferencing                   = true;
    boolean generateAddReferencing                  = false;
    boolean generateSelects                         = true;
    boolean generateDeletes                         = true;
    Boolean generateValidate                        = null;
    boolean generateSetImmutable                    = false;
    boolean generateSnapshot                        = false;
    boolean generateClearOnRemoteSave               = false;
    boolean generateAlignComponents                 = false;
    boolean generateCreateNormText                  = false;
    boolean generateMock                            = false;

    boolean isEffectivelyComposite = getEntity().isEffectivelyComposite();

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
        generateAddReferencing = true;
        break;
      }
    }

    for (String arg: getOptionArgs())  {
      if (arg.equals("noloadcomponents")) {
        generateLoadComponents = false;
      }
      else if (arg.equals("noinsertcomponents")) {
        generateInsertComponents = false;
      }
      else if (arg.equals("nodeletecomponents")) {
        generateDeleteComponents = false;
      }
      else if (arg.equals("novalidate")) {
        generateValidate = false;
      }
      else if (arg.equals("loadcomponents")) {
        generateLoadComponents = true;
      }
      else if (arg.equals("insertcomponents")) {
        generateInsertComponents = true;
      }
      else if (arg.equals("deletecomponents")) {
        generateDeleteComponents = true;
      }
      else if (arg.equals("nori")) {
        generateIsReferencing = false;
        generateAddReferencing = false;
      }
      else if (arg.equals("noselects")) {
        generateSelects = false;
      }
      else if (arg.equals("nodeletes")) {
        generateDeletes = false;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    // check which methods need generation
    for (Relation rel: getEntity().getRelations()) {
      if (rel.getSelectionType() == SelectionType.LAZY ||
          rel.getSelectionType() == SelectionType.EAGER)  {
        generateDeclarations = true;
        if (!rel.isSelectionCached()) {
          generateSetSession = true;
        }
      }
      if (rel.isPartOfNormText()) {
        generateCreateNormText = true;
      }
      if (rel.isComposite()) {
        generateIsComposite         = true;
        generateDeclarations        = true;
        generateIsModified          = true;
        generateSetSession          = true;
        generateMarkDeleted         = isEffectivelyComposite;
        generateSnapshot            = true;
        generateSetImmutable        = true;

        if (generateValidate == null && getAnnotationOptions(rel.getAnnotations(), "Validate").isEmpty()) {
          generateValidate = true;
        }

        if (!rel.isEmbedding()) {
          if (rel.getRelationType() == RelationType.OBJECT) {
            generateSaveReferencedRelations = true;
            generateDeleteReferencedRelations = true;
            generateLazyDeleteReferencedRelations = true;
          }
          else  { // LIST
            generateSaveReferencingRelations = true;
            generateDeleteReferencingRelations = true;
            if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
              generateLazyDeleteReferencingRelations = true;
              if (rel.getCountAttribute() != null) {
                generateAlignComponents = true;
              }
            }
          }
        }
      }
      if (rel.isClearOnRemoteSave()) {
        generateClearOnRemoteSave = true;
      }
    }

    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    if (generateLoadComponents == null) {
      generateLoadComponents = generateIsComposite;
    }
    if (generateInsertComponents == null) {
      generateInsertComponents = generateIsComposite && isEffectivelyComposite;
    }
    if (generateDeleteComponents == null) {
      generateDeleteComponents = generateIsComposite && isEffectivelyComposite && (!useDatabaseRefInt || getEntity().isRootEntity());
    }

    if (generateDeclarations || generateMock) {
      // declarations
      for (Relation rel: getEntity().getRelations()) {
        if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite() || generateMock)  {
          String type = rel.getDeclaredJavaType(false);
          String transientModifier = isRelationTransient(rel) ? "transient " : "";
          out.print(source[0]); // 181:2 = "  // "
          out.print(rel);
          out.print(source[1]); // 183:12 = "  private "
          out.print(transientModifier);
          out.print(type);
          out.print(source[2]); // 184:39 = " "
          out.print(rel.getVariableName());
          out.print(source[3]); // 184:65 = ";"
          if (!generateMock) {
            if ((rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) &&
                (rel.getForeignRelation() == null || !rel.getForeignRelation().isEmbedding()))  {
                  out.print(source[4]); // 189:2 = "  private "
                  out.print(transientModifier);
                  out.print(source[5]); // 190:31 = "boolean "
                  out.print(rel.getVariableName());
                  out.print(source[6]); // 190:64 = "Loaded;"
            }
            if (rel.isComposite())  {
              if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
                out.print(source[7]); // 195:2 = "  private transient "
                out.print(type);
                out.print(source[8]); // 196:28 = " "
                out.print(rel.getVariableName());
                out.print(source[9]); // 196:54 = "Snapshot;"
              }
              if (rel.getRelationType() == RelationType.OBJECT && !rel.isEmbedding()) {
                out.print(source[10]); // 200:2 = "  private long "
                out.print(rel.getVariableName());
                out.print(source[11]); // 201:40 = "RemovedId;"
              }
            }
          }
        }

        if (rel.getNmName() != null) {
          String nmVar;
          if (rel.getNmMethodName() != null) {
            nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
          }
          else  {
            nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
          }
          out.print(source[12]); // 216:2 = "  private transient TrackedList<"
          out.print(rel.getNmRelation().getDeclaredJavaType(false));
          out.print(source[13]); // 217:82 = "> "
          out.print(nmVar);
          out.print(source[14]); // 217:93 = ";"
        }
      }
    }

    if (generateClearOnRemoteSave && !generateMock) {
      out.print(source[15]); // 224:2 = "  @Override  public void clearOnRemote..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isClearOnRemoteSave()) {
          out.print(source[16]); // 231:2 = "    "
          out.print(rel.getVariableName());
          out.print(source[17]); // 232:29 = " = null;"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
            out.print(source[18]); // 235:2 = "    "
            out.print(rel.getVariableName());
            out.print(source[19]); // 236:29 = "Loaded = false;"
          }
        }
      }
      out.print(source[20]); // 241:2 = "  }"
    }



    // generate getter/setter
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String effType = rel.getJavaType();
      String scope = rel.getAccessScope().toString();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean isEmbeddingFromParent = rel.getForeignRelation() != null && rel.getForeignRelation().isEmbedding();
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        scope = attr.getOptions().getAccessScope().toString();
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }
      if (rel.getForeignRelation() != null) {
        String linkMethodName = rel.getForeignRelation().getLinkMethodName();
        if (linkMethodName != null && !rel.getSetterName().equals(linkMethodName)) {
          // don't generate setter impl if linkmethodname is not default from model
          createSetter = false;
        }
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = rel.getMethodArgs().get(0).getMethodArgument() + " == null || " + checkNull;
        }
        out.print(source[21]); // 296:2 = ""
        if (hidden) {
          out.print(source[22]); // 300:2 = "  /**   * Gets "
          out.print(rel);
          out.print(source[23]); // 303:17 = ".   *   * @return "
          out.print(var);
          out.print(source[24]); // 305:21 = " "
          out.print(rel.getComment());
          out.print(source[25]); // 305:42 = "   */  @Persistent(ordinal="
          out.print(rel.getOrdinal());
          out.print(source[26]); // 307:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[27]); // 307:102 = ")"
        }
        else {
          out.print(source[28]); // 311:2 = "  @Override"
        }
        if (rel.getForeignEntity().isAbstract()) { // needs a cast
        out.print(source[29]); // 316:2 = "  @SuppressWarnings("unchecked")"
        }
        if (!generateMock) {
          for (String annotation: rel.getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[30]); // 324:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[31]); // 325:26 = ""
            }
          }
        }
        out.print(source[32]); // 330:2 = "  "
        out.print(scope);
        out.print(source[33]); // 331:11 = " "
        out.print(type);
        out.print(source[34]); // 331:20 = " "
        out.print(rel.getGetterName());
        out.print(source[35]); // 331:44 = "()  {"
        if (generateMock) {
          out.print(source[36]); // 334:2 = "    return "
          out.print(var);
          out.print(source[37]); // 335:18 = ";  }"
        }
        else {
          if (rel.getSelectionType() == SelectionType.ALWAYS) {
            if (rel.getRelationType() == RelationType.LIST) {
              if (rel.isSelectionCached()) {
                out.print(source[38]); // 343:2 = "    "
                out.print(var);
                out.print(source[39]); // 344:11 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[40]); // 344:47 = ";"
              }
              else {
                out.print(source[41]); // 348:2 = "    "
                out.print(type);
                out.print(source[42]); // 349:12 = " "
                out.print(var);
                out.print(source[43]); // 349:20 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[44]); // 349:56 = ";"
              }
              if (rel.isReferenced()) {
                if (rel.getLinkMethodIndex() != null) {
                  out.print(source[45]); // 354:2 = "    int ndx = 0;"
                }
                out.print(source[46]); // 358:2 = "    for ("
                out.print(rel.getClassName());
                out.print(source[47]); // 359:31 = " obj: "
                out.print(var);
                out.print(source[48]); // 359:44 = ")  {      obj."
                out.print(createRelationUpdateReferenceCode(rel));
                out.print(source[49]); // 360:52 = ";    }"
              }
              out.print(source[50]); // 364:2 = "    return "
              out.print(var);
              out.print(source[51]); // 365:18 = ";"
            }
            else  {   // RelationType.OBJECT
              if (rel.isComposite()) {
                out.print(source[52]); // 370:2 = "    "
                out.print(var);
                out.print(source[53]); // 371:11 = " = "
                out.print(checkNull);
                out.print(source[54]); // 371:27 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[55]); // 371:70 = ";"
                if (rel.isReferenced()) {
                  out.print(source[56]); // 374:2 = "    if ("
                  out.print(var);
                  out.print(source[57]); // 375:15 = " != null) {      "
                  out.print(var);
                  out.print(source[58]); // 376:13 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[59]); // 376:56 = ";    }"
                }
                if (rel.isProcessed()) {
                  out.print(source[60]); // 381:2 = "    "
                  out.print(var);
                  out.print(source[61]); // 382:11 = " = process"
                  out.print(rel.getMethodNameSuffix());
                  out.print(source[62]); // 382:50 = "("
                  out.print(var);
                  out.print(source[63]); // 382:58 = ");"
                }
                out.print(source[64]); // 385:2 = "    return "
                out.print(var);
                out.print(source[65]); // 386:18 = ";"
              }
              else  {
                if (rel.isReferenced()) {
                  out.print(source[66]); // 391:2 = "    "
                  out.print(type);
                  out.print(source[67]); // 392:12 = " obj = "
                  out.print(checkNull);
                  out.print(source[68]); // 392:32 = " ? null : "
                  out.print(createRelationSelectCode(rel));
                  out.print(source[69]); // 392:75 = ";    if (obj != null) {      obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[70]); // 394:52 = ";    }    return obj;"
                }
                else {
                  out.print(source[71]); // 400:2 = "    return "
                  out.print(checkNull);
                  out.print(source[72]); // 401:24 = " ? null : "
                  out.print(createRelationSelectCode(rel));
                  out.print(source[73]); // 401:67 = ";"
                }
              }
            }
          }
          else if (rel.isEmbedding() || isEmbeddingFromParent) {
            if (rel.isEmbedding()) {
              out.print(source[74]); // 409:2 = "    if ("
              out.print(var);
              out.print(source[75]); // 410:15 = " == null) {      "
              out.print(rel.getSetterName());
              out.print(source[76]); // 411:29 = "(on("
              out.print(rel.getForeignEntity());
              out.print(source[77]); // 411:59 = ".class));    }"
            }
            out.print(source[78]); // 415:2 = "    return "
            out.print(var);
            out.print(source[79]); // 416:18 = ";"
          }
          else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[80]); // 420:2 = "    if (!"
            out.print(var);
            out.print(source[81]); // 421:16 = "Loaded) {"
            if (rel.isComposite())  {
              if (rel.getRelationType() == RelationType.LIST) {
                String condition = "isNew()";
                Attribute countAttribute = rel.getCountAttribute();
                if (countAttribute != null) {
                  condition += " || " + countAttribute.getName() + " == 0";
                }
                out.print(source[82]); // 430:2 = "      "
                out.print(var);
                out.print(source[83]); // 431:13 = " = "
                out.print(condition);
                out.print(source[84]); // 431:29 = " ? new "
                out.print(effType);
                out.print(source[85]); // 431:47 = "("
                out.print(rel.isTracked() ? "false" : "");
                out.print(source[86]); // 431:82 = ") : "
                out.print(createRelationSelectCode(rel));
                out.print(source[87]); // 431:119 = ";"
                if (rel.isReferenced()) {
                  if (rel.getLinkMethodIndex() != null) {
                    out.print(source[88]); // 435:2 = "      int ndx = 0;"
                  }
                  out.print(source[89]); // 439:2 = "      for ("
                  out.print(rel.getClassName());
                  out.print(source[90]); // 440:33 = " obj: "
                  out.print(var);
                  out.print(source[91]); // 440:46 = ")  {        obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[92]); // 441:54 = ";      }"
                }
              }
              else  {
                out.print(source[93]); // 447:2 = "      "
                out.print(var);
                out.print(source[94]); // 448:13 = " = "
                out.print(checkNull);
                out.print(source[95]); // 448:29 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[96]); // 448:72 = ";"
                if (rel.isReferenced()) {
                  out.print(source[97]); // 451:2 = "      if ("
                  out.print(var);
                  out.print(source[98]); // 452:17 = " != null) {        "
                  out.print(var);
                  out.print(source[99]); // 453:15 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[100]); // 453:58 = ";      }"
                }
              }

              if (rel.isProcessed()) {
                out.print(source[101]); // 460:2 = "      "
                out.print(var);
                out.print(source[102]); // 461:13 = " = process"
                out.print(rel.getMethodNameSuffix());
                out.print(source[103]); // 461:52 = "("
                out.print(var);
                out.print(source[104]); // 461:60 = ");"
              }

              if (rel.getRelationType() == RelationType.LIST) {
                if (rel.isTracked()) {
                  if (rel.isImmutable()) {
                    out.print(source[105]); // 468:2 = "      "
                    out.print(var);
                    out.print(source[106]); // 469:13 = ".setImmutable(true);"
                  }
                  else {
                    out.print(source[107]); // 473:2 = "      if (isImmutable()) {        "
                    out.print(var);
                    out.print(source[108]); // 475:15 = ".setImmutable(true);      }"
                  }
                }
              }
              else  {
                if (rel.isImmutable()) {
                  out.print(source[109]); // 483:2 = "      "
                  out.print(var);
                  out.print(source[110]); // 484:13 = ".setImmutable(true, true);"
                }
                else {
                  out.print(source[111]); // 488:2 = "      if (isImmutable() && "
                  out.print(var);
                  out.print(source[112]); // 489:34 = " != null) {        "
                  out.print(var);
                  out.print(source[113]); // 490:15 = ".setImmutable(true);      }"
                }
              }
            }
            else  {
              if (rel.getRelationType() == RelationType.LIST) {
                out.print(source[114]); // 498:2 = "      "
                out.print(var);
                out.print(source[115]); // 499:13 = " = "
                out.print(createRelationSelectCode(rel));
                out.print(source[116]); // 499:49 = ";"
                if (rel.isReferenced()) {
                  if (rel.getLinkMethodIndex() != null) {
                    out.print(source[117]); // 503:2 = "      int ndx = 0;"
                  }
                  out.print(source[118]); // 507:2 = "      for ("
                  out.print(rel.getClassName());
                  out.print(source[119]); // 508:33 = " obj: "
                  out.print(var);
                  out.print(source[120]); // 508:46 = ")  {        obj."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[121]); // 509:54 = ";      }"
                }
              }
              else  {
                out.print(source[122]); // 515:2 = "      "
                out.print(var);
                out.print(source[123]); // 516:13 = " = "
                out.print(checkNull);
                out.print(source[124]); // 516:29 = " ? null : "
                out.print(createRelationSelectCode(rel));
                out.print(source[125]); // 516:72 = ";"
                if (rel.isReferenced()) {
                  out.print(source[126]); // 519:2 = "      if ("
                  out.print(var);
                  out.print(source[127]); // 520:17 = " != null) {        "
                  out.print(var);
                  out.print(source[128]); // 521:15 = "."
                  out.print(createRelationUpdateReferenceCode(rel));
                  out.print(source[129]); // 521:58 = ";      }"
                }
              }
            }
            out.print(source[130]); // 527:2 = "      "
            out.print(var);
            out.print(source[131]); // 528:13 = "Loaded = true;"
            if (nmRel != null) {
              out.print(source[132]); // 531:2 = "      "
              out.print(var);
              out.print(source[133]); // 532:13 = ".addListener(new TrackedListListener<>()..."
              out.print(rel.getClassName());
              out.print(source[134]); // 535:48 = " element) {          get"
              out.print(nmName);
              out.print(source[135]); // 536:23 = "().addIfAbsent(element."
              out.print(nmRel.getGetterName());
              out.print(source[136]); // 536:71 = "());        }        @Override      ..."
              out.print(rel.getClassName());
              out.print(source[137]); // 540:50 = " element) {          get"
              out.print(nmName);
              out.print(source[138]); // 541:23 = "().remove(element."
              out.print(nmRel.getGetterName());
              out.print(source[139]); // 541:66 = "());        }      });"
            }
            out.print(source[140]); // 546:2 = "    }    return "
            out.print(var);
            out.print(source[141]); // 548:18 = ";"
          }
          out.print(source[142]); // 551:2 = "  }"
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
              if (rel.isBluntDeclared()) {
                out.print(source[143]); // 557:2 = "  @Override"
              }
              else {
                out.print(source[144]); // 563:2 = "  /**   * Gets "
                out.print(var);
                out.print(source[145]); // 566:17 = " without performing a select if not load..."
                out.print(var);
                out.print(source[146]); // 568:21 = " "
                out.print(rel.getComment());
                out.print(source[147]); // 568:42 = "   */"
              }
              out.print(source[148]); // 572:2 = "  "
              out.print(scope);
              out.print(source[149]); // 573:11 = " "
              out.print(type);
              out.print(source[150]); // 573:20 = " "
              out.print(rel.getGetterName());
              out.print(source[151]); // 573:44 = "Blunt() {    if (!"
              out.print(var);
              out.print(source[152]); // 574:16 = "Loaded) {      "
              out.print(var);
              out.print(source[153]); // 575:13 = " = new "
              out.print(effType);
              out.print(source[154]); // 575:31 = "("
              out.print(rel.isTracked() ? "false" : "");
              out.print(source[155]); // 575:66 = ");      if (isImmutable()) {        "
              out.print(var);
              out.print(source[156]); // 577:15 = ".setImmutable(true);      }      "
              out.print(var);
              out.print(source[157]); // 579:13 = "Loaded = true;    }    return "
              out.print(var);
              out.print(source[158]); // 581:18 = ";  }"
            }
            else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() && !isEmbeddingFromParent) {
              if (rel.isBluntDeclared()) {
                out.print(source[159]); // 587:2 = "  @Override"
              }
              else {
                out.print(source[160]); // 593:2 = "  /**   * Gets "
                out.print(var);
                out.print(source[161]); // 596:17 = " without performing a select if not load..."
                out.print(var);
                out.print(source[162]); // 598:21 = " "
                out.print(rel.getComment());
                out.print(source[163]); // 598:42 = "   */"
              }
              out.print(source[164]); // 602:2 = "  "
              out.print(scope);
              out.print(source[165]); // 603:11 = " "
              out.print(type);
              out.print(source[166]); // 603:20 = " "
              out.print(rel.getGetterName());
              out.print(source[167]); // 603:44 = "Blunt() {    return "
              out.print(var);
              out.print(source[168]); // 604:18 = ";  }"
            }
          }
        }

        if (nmRel != null) {
          String nmType = nmRel.getDeclaredJavaType(false);
          if (rel.getNmScope() == AccessScope.PUBLIC) {
            out.print(source[169]); // 614:2 = "  @Override"
          }
          else {
            out.print(source[170]); // 620:2 = "  /**   * Gets list of "
            out.print(nmRel.getDeclaredJavaType(false));
            out.print(source[171]); // 623:54 = " joined via "
            out.print(rel);
            out.print(source[172]); // 623:73 = ".   *   * @return list of "
            out.print(nmRel.getVariableName());
            out.print(source[173]); // 625:49 = "   */"
          }
          out.print(source[174]); // 629:2 = "  "
          out.print(rel.getNmScope());
          out.print(source[175]); // 630:22 = " TrackedList<"
          out.print(nmType);
          out.print(source[176]); // 630:45 = "> get"
          out.print(nmName);
          out.print(source[177]); // 630:60 = "() {"
          if (!generateMock) {
            out.print(source[178]); // 633:2 = "    if ("
            out.print(nmVar);
            out.print(source[179]); // 634:17 = " == null) {      "
            out.print(nmVar);
            out.print(source[180]); // 635:15 = " = new TrackedArrayList<>() {        @..."
            out.print(rel.getGetterName());
            out.print(source[181]); // 639:40 = "().isModified();        }      };   ..."
            out.print(rel.getForeignEntity());
            out.print(source[182]); // 643:37 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[183]); // 643:66 = "()) {        "
            out.print(nmVar);
            out.print(source[184]); // 644:17 = ".add(obj."
            out.print(nmRel.getGetterName());
            out.print(source[185]); // 644:51 = "());      }      "
            out.print(nmVar);
            out.print(source[186]); // 647:15 = ".addListener(new TrackedListListener<>()..."
            out.print(nmType);
            out.print(source[187]); // 650:36 = " element) {          "
            out.print(rel.getClassName());
            out.print(source[188]); // 651:32 = " obj = on("
            out.print(rel.getClassName());
            out.print(source[189]); // 651:64 = ".class);          obj."
            out.print(nmRel.getSetterName());
            out.print(source[190]); // 652:39 = "(element);          getNmLinks().add(ob..."
            out.print(nmType);
            out.print(source[191]); // 657:38 = " element) {          for (Iterator<"
            out.print(rel.getClassName());
            out.print(source[192]); // 658:46 = "> iter = "
            out.print(rel.getGetterName());
            out.print(source[193]); // 658:78 = "().iterator(); iter.hasNext(); ) {     ..."
            out.print(rel.getClassName());
            out.print(source[194]); // 659:34 = " obj = iter.next();            if (Obje..."
            out.print(nmRel.getGetterName());
            out.print(source[195]); // 660:60 = "(), element)) {              iter.remov..."
          }
          out.print(source[196]); // 670:2 = "    return "
          out.print(nmVar);
          out.print(source[197]); // 671:20 = ";  }"
        }

        if (!generateMock && rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
          if (rel.getAccessScope() == AccessScope.PUBLIC) {
            out.print(source[198]); // 679:2 = "  @Override"
          }
          else {
            out.print(source[199]); // 685:2 = "  /**   * Returns whether "
            out.print(rel.getName());
            out.print(source[200]); // 688:38 = " is loaded.   *   * @return true if "
            out.print(rel.getGetterName());
            out.print(source[201]); // 690:45 = "() invoked at least once   */"
          }
          out.print(source[202]); // 694:2 = "  "
          out.print(scope);
          out.print(source[203]); // 695:11 = " boolean is"
          out.print(StringHelper.firstToUpper(var));
          out.print(source[204]); // 695:56 = "Loaded() {    return "
          out.print(var);
          out.print(source[205]); // 696:18 = "Loaded;  }"
        }
      }


      if (createSetter)  {
        if (generateMock) {
          out.print(source[206]); // 705:2 = ""
          if (!hidden) {
            out.print(source[207]); // 709:2 = "  @Override"
          }
          out.print(source[208]); // 713:2 = "  "
          out.print(scope);
          out.print(source[209]); // 714:11 = " void "
          out.print(rel.getSetterName());
          out.print(source[210]); // 714:40 = "("
          out.print(type);
          out.print(source[211]); // 714:49 = " "
          out.print(var);
          out.print(source[212]); // 714:57 = ")  {    this."
          out.print(var);
          out.print(source[213]); // 715:16 = " = "
          out.print(var);
          out.print(source[214]); // 715:26 = ";  }"
        }
        else {
          String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
          String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
          out.print(source[215]); // 722:2 = ""
          if (hidden) {
            out.print(source[216]); // 726:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[217]); // 729:17 = ".   *   * @param "
            out.print(var);
            out.print(source[218]); // 731:20 = " "
            out.print(rel.getComment());
            out.print(source[219]); // 731:41 = ""
        if (linkMethodIndex != null) {
          out.print(source[220]); // 734:2 = "   * @param index the index starting at ..."
        }
        out.print(source[221]); // 738:2 = "   */"
          }
          else {
            out.print(source[222]); // 743:2 = "  @Override"
          }
          for (String annotation: rel.getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
              out.print(source[223]); // 750:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[224]); // 751:26 = ""
            }
          }
          if (linkMethodIndex != null) {
            out.print(source[225]); // 756:2 = "  "
            out.print(scope);
            out.print(source[226]); // 757:11 = " void "
            out.print(rel.getForeignRelation().getLinkMethodName());
            out.print(source[227]); // 757:65 = "("
            out.print(type);
            out.print(source[228]); // 757:74 = " "
            out.print(var);
            out.print(source[229]); // 757:82 = ", int index)  {"
          }
          else {
            String linkMethodName = rel.getSetterName();
            if (rel.getForeignRelation() != null && rel.getForeignRelation().getLinkMethodName() != null) {
              linkMethodName = rel.getForeignRelation().getLinkMethodName();
            }
            out.print(source[230]); // 765:2 = "  "
            out.print(scope);
            out.print(source[231]); // 766:11 = " void "
            out.print(linkMethodName);
            out.print(source[232]); // 766:35 = "("
            out.print(type);
            out.print(source[233]); // 766:44 = " "
            out.print(var);
            out.print(source[234]); // 766:52 = ")  {"
          }
          if ((rel.getRelationType() == RelationType.LIST && !rel.isReversed()) ||
              rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.isEmbedding()) {
                // initial setting (usually via getter) should not mark the embedding object modified!
                out.print(source[235]); // 774:2 = "    if (!attributesModified()) {      s..."
                out.print(var);
                out.print(source[236]); // 776:30 = " != null && !this."
                out.print(var);
                out.print(source[237]); // 776:55 = ".equals("
                out.print(var);
                out.print(source[238]); // 776:70 = "));    }"
              }
              else {
                out.print(source[239]); // 781:2 = "    if (!attributesModified()) {      s..."
                out.print(var);
                out.print(source[240]); // 783:46 = ", "
                out.print(var);
                out.print(source[241]); // 783:55 = "));    }"
              }
            }
            out.print(source[242]); // 788:2 = "    this."
            out.print(var);
            out.print(source[243]); // 789:16 = " = "
            out.print(var);
            out.print(source[244]); // 789:26 = ";"
            if (rel.isReferenced()) {
              out.print(source[245]); // 792:2 = "    if ("
              out.print(var);
              out.print(source[246]); // 793:15 = " != null) {"
              if (rel.isEmbedding()) {
                if (getEntity().isEmbedded()) {
                  out.print(source[247]); // 797:2 = "      ((AbstractPersistentObject<?,?>) "
                  out.print(var);
                  out.print(source[248]); // 798:46 = ".getPersistenceDelegate()).setEmbeddingP..."
                  out.print(rel.getName().toUpperCase(Locale.ROOT));
                  out.print(source[249]); // 798:173 = ");"
                }
                else {
                  out.print(source[250]); // 802:2 = "      ((AbstractPersistentObject<?,?>) "
                  out.print(var);
                  out.print(source[251]); // 803:46 = ".getPersistenceDelegate()).setEmbeddingP..."
                  out.print(rel.getName().toUpperCase(Locale.ROOT));
                  out.print(source[252]); // 803:153 = ");"
                }
              }
              out.print(source[253]); // 807:2 = "      "
              out.print(var);
              out.print(source[254]); // 808:13 = "."
              out.print(createRelationUpdateReferenceCode(rel));
              out.print(source[255]); // 808:56 = ";    }"
            }
            else if (rel.isEmbedding()) {
              if (getEntity().isEmbedded()) {
                out.print(source[256]); // 814:2 = "    if ("
                out.print(var);
                out.print(source[257]); // 815:15 = " != null) {      ((AbstractPersistentOb..."
                out.print(var);
                out.print(source[258]); // 816:46 = ".getPersistenceDelegate()).setEmbeddingP..."
                out.print(rel.getName().toUpperCase(Locale.ROOT));
                out.print(source[259]); // 816:173 = ");    }"
              }
              else {
                out.print(source[260]); // 821:2 = "    if ("
                out.print(var);
                out.print(source[261]); // 822:15 = " != null) {      ((AbstractPersistentOb..."
                out.print(var);
                out.print(source[262]); // 823:46 = ".getPersistenceDelegate()).setEmbeddingP..."
                out.print(rel.getName().toUpperCase(Locale.ROOT));
                out.print(source[263]); // 823:153 = ");    }"
              }
            }

            if (linkMethodIndex != null) {
              out.print(source[264]); // 830:2 = "    "
              out.print(createAccessorCode(getEntity(), linkMethodIndex, true));
              out.print(source[265]); // 831:62 = "(index);"
            }
          }

          if (rel.getRelationType() == RelationType.OBJECT && !isEmbeddingFromParent && !rel.isEmbedding()) {
            if (rel.isComposite())  {
              if (attr != null && !attr.getDataType().isPrimitive()) {
                out.print(source[266]); // 839:2 = "    "
                out.print(attr.getJavaType());
                out.print(source[267]); // 840:26 = " oldId = "
                out.print(rel.getMethodArgs().get(0).getMethodArgument());
                out.print(source[268]); // 840:85 = ";"
              }
              else {
                out.print(source[269]); // 844:2 = "    long oldId = "
                out.print(rel.getMethodArgs().get(0).getMethodArgument());
                out.print(source[270]); // 845:67 = ";"
              }
            }
            out.print(source[271]); // 849:2 = "    "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[272]); // 850:48 = "("
            out.print(var);
            out.print(source[273]); // 850:56 = " == null ? "
            out.print(nullVal);
            out.print(source[274]); // 850:78 = " : "
            out.print(var);
            out.print(source[275]); // 850:88 = ".getId());"
          }
          if ((rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) && !isEmbeddingFromParent) {
            out.print(source[276]); // 854:2 = "    "
            out.print(var);
            out.print(source[277]); // 855:11 = "Loaded = true;"
          }
          if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite())  {
            if (attr != null && !attr.getDataType().isPrimitive()) {
              out.print(source[278]); // 860:2 = "    if (oldId != null && oldId != 0 && "
              out.print(rel.getVariableName());
              out.print(source[279]); // 861:64 = "RemovedId == 0 && !Objects.equals("
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[280]); // 861:148 = ", oldId)) {      "
              out.print(rel.getVariableName());
              out.print(source[281]); // 862:31 = "RemovedId = oldId;    }"
            }
            else if (!rel.isEmbedding()) {
              out.print(source[282]); // 867:2 = "    if (oldId != 0 && "
              out.print(rel.getVariableName());
              out.print(source[283]); // 868:47 = "RemovedId == 0 && "
              out.print(rel.getMethodArgs().get(0).getMethodArgument());
              out.print(source[284]); // 868:115 = " != oldId) {      "
              out.print(rel.getVariableName());
              out.print(source[285]); // 869:31 = "RemovedId = oldId;    }"
            }
          }
          out.print(source[286]); // 874:2 = "  }"
        }

        if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized() && !isEmbeddingFromParent &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[287]); // 881:2 = "  /**   * Sets "
              out.print(var);
              out.print(source[288]); // 884:17 = " without setting any attributes.   *  ..."
              out.print(var);
              out.print(source[289]); // 886:20 = " "
              out.print(rel.getComment());
              out.print(source[290]); // 886:41 = "   */  "
              out.print(scope);
              out.print(source[291]); // 888:11 = " void "
              out.print(rel.getSetterName());
              out.print(source[292]); // 888:40 = "Blunt("
              out.print(type);
              out.print(source[293]); // 888:54 = " "
              out.print(var);
              out.print(source[294]); // 888:62 = ") {    this."
              out.print(var);
              out.print(source[295]); // 889:16 = " = "
              out.print(var);
              out.print(source[296]); // 889:26 = ";    "
              out.print(var);
              out.print(source[297]); // 890:11 = "Loaded = true;  }"
        }
      }
    }


    // gerenate setSession and setDomainContext for referenced objects (necessary for RMI)
    if (generateSetSession)  {
      out.print(source[298]); // 900:2 = "  @Override  public void setSession(Se..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[299]); // 911:2 = "    session.applyTo("
               out.print(rel.getVariableName());
               out.print(source[300]); // 912:45 = ");"
        }
      }
      out.print(source[301]); // 916:2 = "  }  @Override  public void setDomain..."
      for (Relation rel: getEntity().getRelations()) {
        if (!rel.isSelectionCached() &&
            (rel.getSelectionType() == SelectionType.LAZY ||
             rel.getSelectionType() == SelectionType.EAGER ||
             rel.isComposite())) {
               out.print(source[302]); // 928:2 = "    context.applyTo("
               out.print(rel.getVariableName());
               out.print(source[303]); // 929:45 = ");"
        }
      }
      out.print(source[304]); // 933:2 = "  }"
    }



    // generate code to remove delete composite relations

    if (generateDeleteReferencingRelations && !generateMock)  {
      if (useDatabaseRefInt) {
        out.print(source[305]); // 944:2 = "  /**   * Deletes all referencing comp..."
          for (Relation rel: getEntity().getRelations()) {
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (!rel.isTracked()) {
                throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
              }
              String var = rel.getVariableName();
              out.print(source[306]); // 958:2 = "    if ("
              out.print(var);
              out.print(source[307]); // 959:15 = " != null && "
              out.print(var);
              out.print(source[308]); // 959:34 = ".isSomeRemoved()) {      delete("
              out.print(var);
              out.print(source[309]); // 960:20 = ".getRemovedObjects());    }"
            }
          }
          out.print(source[310]); // 965:2 = "  }"
      }
      else { // no database ref. integrity
        if (generateLazyDeleteReferencingRelations)  {
          out.print(source[311]); // 971:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                if (rel.isTracked())  {
                  out.print(source[312]); // 996:2 = "    if (delete) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[313]); // 1000:2 = "      delete("
                    out.print(rel.getGetterName());
                    out.print(source[314]); // 1001:36 = "());"
                  }
                  else {
                    out.print(source[315]); // 1005:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[316]); // 1006:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[317]); // 1007:39 = ";"
                  }
                  out.print(source[318]); // 1010:2 = "    }    if ("
                  out.print(var);
                  out.print(source[319]); // 1012:15 = " != null && "
                  out.print(var);
                  out.print(source[320]); // 1012:34 = ".isSomeRemoved()) {      delete("
                  out.print(var);
                  out.print(source[321]); // 1013:20 = ".getRemovedObjects());    }"
                }  // end if isTracked
                else  {
                  out.print(source[322]); // 1018:2 = "    if (delete || "
                  out.print(var);
                  out.print(source[323]); // 1019:25 = " != null) {"
                  if (rel.isDeletionCascaded()) {
                    out.print(source[324]); // 1022:2 = "      markDeleted("
                    out.print(rel.getGetterName());
                    out.print(source[325]); // 1023:41 = "());      deleteMissingInCollection("
                    out.print(createRelationSelectCode(rel));
                    out.print(source[326]); // 1024:65 = ", "
                    out.print(var);
                    out.print(source[327]); // 1024:74 = ");"
                  } // end isDeleteCascade
                  else {
                    out.print(source[328]); // 1028:2 = "      markDeleted("
                    out.print(var);
                    out.print(source[329]); // 1029:25 = ");      "
                    out.print(createRelationDeleteCode(rel));
                    out.print(source[330]); // 1030:39 = ";"
                  }
                  out.print(source[331]); // 1033:2 = "    }"
                }
              }
            } // end composite
          }
          out.print(source[332]); // 1040:2 = "  }"
        } // end if generateLazyDeleteReferencingRelations

        else  {   // no lazy loading at all
        out.print(source[333]); // 1046:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
              if (rel.isDeletionCascaded()) {
                out.print(source[334]); // 1056:2 = "    delete("
                out.print(rel.getGetterName());
                out.print(source[335]); // 1057:34 = "());"
              }
              else {
                out.print(source[336]); // 1061:2 = "    markDeleted("
                out.print(var);
                out.print(source[337]); // 1062:23 = ");    "
                out.print(createRelationDeleteCode(rel));
                out.print(source[338]); // 1063:37 = ";"
              }
            }
          }
          out.print(source[339]); // 1068:2 = "  }"
        }
      } // end w/o db-integrity
    }


    if (generateDeleteReferencedRelations && !generateMock)  {
      if (useDatabaseRefInt) {
        out.print(source[340]); // 1078:2 = "  /**   * Deletes all referenced compo..."
        for (Relation rel: getEntity().getRelations()) {
          if (rel.isComposite() && !rel.isEmbedding() && rel.getRelationType() == RelationType.OBJECT) {
            if (!rel.isTracked()) {
              throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
            }
            // remove the old deleted composite too, if set
            // we need to replace <varname>Id by <varname>RemovedId in the select statement
            String var = rel.getVariableName();
            String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
            out.print(source[341]); // 1095:2 = "    if ("
            out.print(rel.getVariableName());
            out.print(source[342]); // 1096:33 = "RemovedId != 0) {      "
            out.print(rel.getClassName());
            out.print(source[343]); // 1097:28 = " old = "
            out.print(selectStmt);
            out.print(source[344]); // 1097:49 = ";      if (old != null) {        old.d..."
            out.print(rel.getVariableName());
            out.print(source[345]); // 1100:33 = "RemovedId = 0;      }    }"
          }
        }
        out.print(source[346]); // 1106:2 = "  }"
      }
      else  {
        if (generateLazyDeleteReferencedRelations)  {
          out.print(source[347]); // 1112:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)  {
                out.print(source[348]); // 1136:2 = "    if (delete && "
                out.print(rel.getGetterName());
                out.print(source[349]); // 1137:41 = "() != null && !"
                out.print(var);
                out.print(source[350]); // 1137:63 = ".isVirgin()) {      delete("
                out.print(var);
                out.print(source[351]); // 1138:20 = ");    }"
              }
              // remove the old deleted composite too, if set
              // we need to replace <varname>Id by <varname>RemovedId in the select statement
              String selectStmt = createRelationSelectCode(rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
              out.print(source[352]); // 1145:2 = "    if ("
              out.print(rel.getVariableName());
              out.print(source[353]); // 1146:33 = "RemovedId != 0) {      "
              out.print(rel.getClassName());
              out.print(source[354]); // 1147:28 = " old = "
              out.print(selectStmt);
              out.print(source[355]); // 1147:49 = ";      if (old != null) {        old.d..."
              out.print(rel.getVariableName());
              out.print(source[356]); // 1150:33 = "RemovedId = 0;      }    }"
            } // end composite
          }
          out.print(source[357]); // 1156:2 = "  }"
        } // end if generateLazyDeleteReferencedRelations

        else  {   // no lazy loading at all
        out.print(source[358]); // 1162:2 = "  @Override  public void deleteReferen..."
          for (Relation rel: getEntity().getRelations()) {
            String var = rel.getVariableName();
            if (rel.isComposite() && !rel.isEmbedding() && rel.getRelationType() == RelationType.OBJECT) {
              if (rel.getSelectionType() == SelectionType.ALWAYS) {
                throw new WurbelException("internal wurblet logic error");
              }
              else {
                out.print(source[359]); // 1175:2 = "    if ("
                out.print(var);
                out.print(source[360]); // 1176:15 = " != null) {      delete("
                out.print(var);
                out.print(source[361]); // 1177:20 = ");    }"
              }
            }
          }
          out.print(source[362]); // 1183:2 = "  }"
        }
      }
    }


    // save composite relations

    if (generateSaveReferencingRelations && !generateMock)  {
      out.print(source[363]); // 1194:2 = "  @Override  public void saveReferenci..."
      if (useDatabaseRefInt) {
        out.print(source[364]); // 1202:2 = "      deleteRemovedReferencingRelations(..."
      }
      else  {
        out.print(source[365]); // 1207:2 = "      deleteReferencingRelations("
        out.print(generateLazyDeleteReferencingRelations ? "false" : "");
        out.print(source[366]); // 1208:90 = ");"
      }
      out.print(source[367]); // 1211:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          if (rel.isProcessed()) {
            out.print(source[368]); // 1218:2 = "    "
            out.print(var);
            out.print(source[369]); // 1219:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[370]); // 1219:50 = "("
            out.print(var);
            out.print(source[371]); // 1219:58 = ");"
          }
          out.print(source[372]); // 1222:2 = "    if ("
          out.print(var);
          out.print(source[373]); // 1223:15 = " != null) {      getDomainContext().app..."
          out.print(var);
          out.print(source[374]); // 1224:40 = ");"
          if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
            out.print(source[375]); // 1227:2 = "      int ndx = 0;"
          }
          out.print(source[376]); // 1231:2 = "      for ("
          out.print(rel.getClassName());
          out.print(source[377]); // 1232:33 = " obj: "
          out.print(var);
          out.print(source[378]); // 1232:46 = ")  {        obj."
          out.print(createRelationLinkCode(rel));
          out.print(source[379]); // 1233:43 = ";"
          boolean firstSkipped = false;
          for (MethodArgument ma: rel.getMethodArgs()) {
            if (firstSkipped)  {
              out.print(source[380]); // 1238:2 = "        obj."
              out.print(ma.getSetterMethod());
              out.print(source[381]); // 1239:36 = "("
              out.print(ma.getMethodArgument());
              out.print(source[382]); // 1239:63 = ");"
            }
            firstSkipped = true;
          }
          out.print(source[383]); // 1244:2 = "      }      save("
          out.print(var);
          out.print(source[384]); // 1246:18 = ", "
          out.print(rel.isTracked() ? "true" : "false");
          out.print(source[385]); // 1246:58 = ");    }"
        }
      }
      out.print(source[386]); // 1251:2 = "  }"
    }


    if (generateSaveReferencedRelations && !generateMock)  {
      out.print(source[387]); // 1258:2 = "  @Override  public void saveReference..."
      if (getEntity().isRootEntity()) {
        // need a valid id to store in rootId of composite object relations
        out.print(source[388]); // 1265:2 = "    reserveId();"
      }
      out.print(source[389]); // 1269:2 = "    super.saveReferencedRelations(update..."
      if (useDatabaseRefInt) {
        out.print(source[390]); // 1274:2 = "      deleteRemovedReferencedRelations()..."
      }
      else  {
        out.print(source[391]); // 1279:2 = "      deleteReferencedRelations("
        out.print(generateLazyDeleteReferencedRelations ? "false" : "");
        out.print(source[392]); // 1280:88 = ");"
      }
      out.print(source[393]); // 1283:2 = "    }"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isEmbedding() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[394]); // 1289:2 = "    getDomainContext().applyTo("
          out.print(var);
          out.print(source[395]); // 1290:38 = ");"
          if (rel.isProcessed()) {
            out.print(source[396]); // 1293:2 = "    "
            out.print(var);
            out.print(source[397]); // 1294:11 = " = process"
            out.print(rel.getMethodNameSuffix());
            out.print(source[398]); // 1294:50 = "("
            out.print(var);
            out.print(source[399]); // 1294:58 = ");"
          }
          if (rel.isTracked())  {
            out.print(source[400]); // 1298:2 = "    if ("
            out.print(var);
            out.print(source[401]); // 1299:15 = " != null && "
            out.print(var);
            out.print(source[402]); // 1299:34 = ".isModified()) {      save("
            out.print(var);
            out.print(source[403]); // 1300:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[404]); // 1301:50 = "("
            out.print(var);
            out.print(source[405]); // 1301:58 = ".getId());    }"
          }
          else  {
            out.print(source[406]); // 1306:2 = "    if ("
            out.print(var);
            out.print(source[407]); // 1307:15 = " != null) {      save("
            out.print(var);
            out.print(source[408]); // 1308:18 = ");      "
            out.print(createRelationSetFirstArgMethodName(rel));
            out.print(source[409]); // 1309:50 = "("
            out.print(var);
            out.print(source[410]); // 1309:58 = ".getId());    }"
          }
        }
      }
      out.print(source[411]); // 1315:2 = "  }"
    }



    // generate code to validate
    if (Boolean.TRUE.equals(generateValidate))  {
      out.print(source[412]); // 1324:2 = "  @Override  public List<ValidationRes..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (getAnnotationOptions(rel.getAnnotations(), "Validate").isEmpty()) {
            out.print(source[413]); // 1335:2 = "      if ("
            out.print(var);
            out.print(source[414]); // 1336:17 = " != null) {"
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[415]); // 1339:2 = "        results.addAll(ValidationUtiliti..."
            out.print(rel.getVariableName());
            out.print(source[416]); // 1341:43 = ", validationPath + "."
            out.print(var);
            out.print(source[417]); // 1341:71 = "", scope));"
          }
          else  {
            out.print(source[418]); // 1345:2 = "        results.addAll("
            out.print(rel.getVariableName());
            out.print(source[419]); // 1346:48 = ".validate(validationPath + "."
            out.print(var);
            out.print(source[420]); // 1346:84 = "", scope));"
          }
          out.print(source[421]); // 1349:2 = "      }"
          }
          else {
            out.print(source[422]); // 1354:2 = "      // "
            out.print(rel.getVariableName());
            out.print(source[423]); // 1355:34 = " already validated via @Validate annotat..."
          }
        }
      }
      out.print(source[424]); // 1360:2 = "    }    catch (ValidationFailedExcepti..."
    }



    // generate code to check set the immutable flag
    if (generateSetImmutable && !generateMock)  {
      out.print(source[425]); // 1374:2 = "  @Override  public void setImmutable(..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          out.print(source[426]); // 1382:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[427]); // 1383:33 = " != null) {      "
          out.print(rel.getVariableName());
          out.print(source[428]); // 1384:31 = ".setImmutable(immutable);    }"
        }
      }
      out.print(source[429]); // 1389:2 = "  }"
    }



    // generate code to check for modifications
    if (generateIsModified && !generateMock)  {
      out.print(source[430]); // 1398:2 = "  @Override  public boolean isModified..."
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite()) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[431]); // 1407:2 = "           || isModified("
            out.print(rel.getVariableName());
            out.print(source[432]); // 1408:50 = ")"
          }
          else  {
            out.print(source[433]); // 1412:2 = "           || "
            out.print(rel.getVariableName());
            out.print(source[434]); // 1413:39 = " != null && "
            out.print(rel.getVariableName());
            out.print(source[435]); // 1413:76 = ".isModified()"
          }
        }
      }
      out.print(source[436]); // 1418:2 = "           ;  }"
    }

    if (generateAlignComponents && !generateMock) {
      out.print(source[437]); // 1425:2 = "  @Override  protected void alignCompo..."
      for (Relation rel: getEntity().getRelations()) {
        Attribute countAttribute = rel.getCountAttribute();
        if (countAttribute != null) {
          out.print(source[438]); // 1434:2 = "    if ("
          out.print(rel.getVariableName());
          out.print(source[439]); // 1435:33 = " != null) {      "
          out.print(countAttribute.getSetterName());
          out.print(source[440]); // 1436:40 = "("
          out.print(rel.getVariableName());
          out.print(source[441]); // 1436:66 = ".size());    }"
        }
      }
      out.print(source[442]); // 1441:2 = "  }"
    }

    if (getEntity().isDeeplyReferenced()) {
      List<Relation> deepRelations = new ArrayList<>();
      for (Relation rel: getEntity().getRelations()) {
        if (rel.isComposite() && rel.getForeignEntity().isDeeplyReferenced()) {
          deepRelations.add(rel);
        }
      }
      if (!deepRelations.isEmpty()) {
        out.print(source[443]); // 1454:2 = "  @Override  public boolean isReferenc..."
        for (Relation rel: deepRelations) {
          if (rel.getRelationType() == RelationType.LIST) {
            out.print(source[444]); // 1465:2 = "    for ("
            out.print(rel.getForeignEntity());
            out.print(source[445]); // 1466:35 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[446]); // 1466:64 = "()) {      if (obj.isReferenced()) {  ..."
          }
          else {
            out.print(source[447]); // 1474:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[448]); // 1475:31 = "() != null && "
            out.print(rel.getGetterName());
            out.print(source[449]); // 1475:68 = "().isReferenced()) {      return true;..."
          }
        }
        out.print(source[450]); // 1481:2 = "    return false;  }"
      }
    }



    // override isComposite()
    if (generateIsComposite)  {
      out.print(source[451]); // 1493:2 = "  @Override  public boolean isComposit..."
    }


    //  load all components
    if (generateLoadComponents && !generateMock)  {

      out.print(source[452]); // 1507:2 = "  @Override  public IdentifiableMap<? ..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite()) {
          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[453]); // 1525:2 = "    if (!onlyLoaded || "
            out.print(var);
            out.print(source[454]); // 1526:30 = "Loaded) {"
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[455]); // 1529:2 = "      count += addComponents(components,..."
              out.print(rel.getGetterName());
              out.print(source[456]); // 1530:64 = "(), onlyLoaded);"
            }
            else  {
              out.print(source[457]); // 1534:2 = "      if ("
              out.print(rel.getGetterName());
              out.print(source[458]); // 1535:33 = "() != null) {        count += ((Abstrac..."
              out.print(var);
              out.print(source[459]); // 1536:57 = ".getPersistenceDelegate()).addComponents..."
            }
            out.print(source[460]); // 1540:2 = "    }"
          }
          else  {
            if (rel.getRelationType() == RelationType.LIST) {
              out.print(source[461]); // 1546:2 = "    count += addComponents(components, "
              out.print(rel.getGetterName());
              out.print(source[462]); // 1547:62 = "(), onlyLoaded);"
            }
            else  {
              if (rel.isEmbedding()) {
                out.print(source[463]); // 1552:2 = "    count += ((AbstractPersistentObject<..."
                out.print(rel.getGetterName());
                out.print(source[464]); // 1553:69 = "().getPersistenceDelegate()).addComponen..."
              }
              else {
                out.print(source[465]); // 1557:2 = "    if ("
                out.print(rel.getGetterName());
                out.print(source[466]); // 1558:31 = "() != null) {      count += ((AbstractP..."
                out.print(var);
                out.print(source[467]); // 1559:55 = ".getPersistenceDelegate()).addComponents..."
              }
            }
          }
        }
      }
      out.print(source[468]); // 1567:2 = "    return count;  }"
    }



    //  insert all components
    if (generateInsertComponents && !generateMock)  {

      out.print(source[469]); // 1578:2 = "  @Override  public void insertPlainWi..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isEmbedding() && rel.getRelationType() == RelationType.OBJECT) {
          out.print(source[470]); // 1586:2 = "    if ("
          out.print(rel.getGetterName());
          out.print(source[471]); // 1587:31 = "() != null) {      ((AbstractPersistent..."
          out.print(var);
          out.print(source[472]); // 1588:46 = ".getPersistenceDelegate()).insertPlainWi..."
        }
      }
      out.print(source[473]); // 1593:2 = "    insertPlain();"
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
          out.print(source[474]); // 1599:2 = "    insertPlainWithComponents("
          out.print(rel.getGetterName());
          out.print(source[475]); // 1600:53 = "());"
        }
      }
      out.print(source[476]); // 1604:2 = "  }"
    }


    //  delete all components
    if (generateDeleteComponents && !generateMock)  {

      out.print(source[477]); // 1613:2 = "  @Override  public void deletePlainWi..."
      if (useDatabaseRefInt) {
        out.print(source[478]); // 1619:2 = "    // components are deleted via databa..."
      }
      else {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && rel.getRelationType() == RelationType.LIST) {
            out.print(source[479]); // 1627:2 = "    deletePlainWithComponents("
            out.print(rel.getGetterName());
            out.print(source[480]); // 1628:53 = "());"
          }
        }
      }
      out.print(source[481]); // 1633:2 = "    deletePlain();"
      if (!useDatabaseRefInt) {
        for (Relation rel: getEntity().getRelations()) {
          String var = rel.getVariableName();
          if (rel.isComposite() && !rel.isEmbedding() && rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[482]); // 1640:2 = "    if ("
            out.print(rel.getGetterName());
            out.print(source[483]); // 1641:31 = "() != null) {      ((AbstractPersistent..."
            out.print(var);
            out.print(source[484]); // 1642:46 = ".getPersistenceDelegate()).deletePlainWi..."
          }
        }
      }
      out.print(source[485]); // 1648:2 = "  }"
    }



    // mark object and all components deleted
    if (generateMarkDeleted && !generateMock)  {
      out.print(source[486]); // 1657:2 = "  @Override  public void markDeleted()..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isEmbedding()) {
          out.print(source[487]); // 1666:2 = "    markDeleted("
          out.print(var);
          out.print(source[488]); // 1667:23 = ");"
        }
      }
      out.print(source[489]); // 1671:2 = "  }"
    }


    // generate snapshot methods
    if (generateSnapshot && !generateMock) {
      out.print(source[490]); // 1679:2 = "  /**   * Updates the components in sn..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[491]); // 1687:100 = " snapshot) {    super.createComponentsI..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[492]); // 1695:2 = "    snapshot."
              out.print(var);
              out.print(source[493]); // 1696:20 = "Snapshot = TrackedList.createSnapshot("
              out.print(var);
              out.print(source[494]); // 1696:65 = ");"
            }
          }
          else {
            out.print(source[495]); // 1701:2 = "    snapshot."
            out.print(var);
            out.print(source[496]); // 1702:20 = "Snapshot = Pdo.createSnapshot("
            out.print(var);
            out.print(source[497]); // 1702:57 = ");"
          }
        }
      }
      out.print(source[498]); // 1707:2 = "  }  /**   * Reverts all components o..."
      out.print(mainClass);
      out.print(getEntity().isAbstract() ? "<T,?>" : "");
      out.print(source[499]); // 1715:100 = " snapshot) {    super.revertComponentsT..."
      for (Relation rel: getEntity().getRelations()) {
        String var = rel.getVariableName();
        if (rel.isComposite() && !rel.isShallow()) {
          Relation nmRel = rel.getNmRelation();
          String nmVar = null;
          if (nmRel != null) {
            if (rel.getNmMethodName() != null) {
              nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
            }
            else  {
              nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
            }
          }
          if (rel.getRelationType() == RelationType.LIST) {
            if (rel.isTracked()) {
              out.print(source[500]); // 1733:2 = "    "
              out.print(var);
              out.print(source[501]); // 1734:11 = " = TrackedList.revertToSnapshot("
              out.print(var);
              out.print(source[502]); // 1734:50 = ", snapshot."
              out.print(var);
              out.print(source[503]); // 1734:68 = "Snapshot);"
            }
          }
          else {
            out.print(source[504]); // 1739:2 = "    "
            out.print(var);
            out.print(source[505]); // 1740:11 = " = Pdo.revertToSnapshot("
            out.print(var);
            out.print(source[506]); // 1740:42 = ", snapshot."
            out.print(var);
            out.print(source[507]); // 1740:60 = "Snapshot);"
          }

          if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
            out.print(source[508]); // 1745:2 = "    "
            out.print(var);
            out.print(source[509]); // 1746:11 = "Loaded = snapshot."
            out.print(var);
            out.print(source[510]); // 1746:36 = "Loaded;"
          }
          if (rel.getRelationType() == RelationType.OBJECT && !rel.isEmbedding()) {
            out.print(source[511]); // 1750:2 = "    "
            out.print(var);
            out.print(source[512]); // 1751:11 = "RemovedId = snapshot."
            out.print(var);
            out.print(source[513]); // 1751:39 = "RemovedId;"
          }
          if (nmVar != null) {
            out.print(source[514]); // 1755:2 = "    "
            out.print(nmVar);
            out.print(source[515]); // 1756:13 = " = null;"
          }
        }
      }
      out.print(source[516]); // 1761:2 = "  }"
    }

    if (generateCreateNormText && !generateMock) {
      out.print(source[517]); // 1767:2 = "  @Override  public StringBuilder crea..."
      for (Relation rel: getEntity().getRelations())  {

        if (rel.isPartOfNormText())  {
          if (rel.getRelationType() == RelationType.OBJECT) {
            out.print(source[518]); // 1780:2 = "    buf.append("
            out.print(rel.getGetterName());
            out.print(source[519]); // 1781:38 = "()).append(',');"
          }
          else {
            out.print(source[520]); // 1785:2 = "    for ("
            out.print(rel.getClassName());
            out.print(source[521]); // 1786:31 = " obj: "
            out.print(rel.getGetterName());
            out.print(source[522]); // 1786:60 = "()) {      buf.append(obj).append(',');..."
          }
        }
      }
      out.print(source[523]); // 1793:2 = "    return buf;  }"
    }

    if (generateIsReferencing && !generateMock) {
      List<Relation> relations = null;
      if (isEntityPersistable()) {
        relations = getEntity().getTableRelations();
      }
      else if (getEntity().isEmbedded()) {
        relations = getEntity().getRelations();
      }
      if (relations != null) {
        for (Relation rel: getEntity().getTableRelations()) {
          if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT && rel.getEmbeddingEntity() == null &&
              (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
              rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
            Attribute attr = getFirstMethodAttribute(rel);
            String tagName = "isReferencing" + rel.getClassName() + "By" +
                             StringHelper.firstToUpper(attr.getName());
                             out.print(source[524]); // 1815:2 = "  // Determines whether any "
                             out.print(pdoName);
                             out.print(source[525]); // 1817:39 = " references given "
                             out.print(rel.getClassName());
                             out.print(source[526]); // 1817:79 = "  // @wurblet "
                             out.print(tagName);
                             out.print(source[527]); // 1818:26 = " PdoIsReferencing "
                             out.print(attr.getName());
                             out.print(source[528]); // 1818:62 = ""
          }
        }
      }
    }

    if (generateSelects && isEntityPersistable() && !generateMock) {
      Set<String> wurbletArgSet = new HashSet<>();   // to avoid duplicates if args= is used
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null) {
            // force tracked even if related object is not tracked
            String trackedOption = rel.isTracked() ? "--tracked " : "";
            String joins = "";
            if (rel.getNmName() != null) {
              Relation join = rel.getNmRelation();
              if (join != null && join.getRelationType() == RelationType.OBJECT &&
                  join.getSelectionType() == SelectionType.LAZY &&
                  !join.isComposite() && join.isSerialized()) {
                joins = " *" + rel.getNmName();
              }
            }
            // add eager joins, if any
            for (Relation eRel: getEntity().getRelationsIncludingInherited()) {
              if (eRel.getSelectionType() == SelectionType.EAGER) {
                joins += " *" + eRel.getName();
              }
            }

            String extraWurbletOptions = rel.getSelectionWurbletArguments();
            if (extraWurbletOptions == null) {
              extraWurbletOptions = "";
            }
            else {
              extraWurbletOptions = " " + extraWurbletOptions;
            }
            String wurbletArgs = createRelationWurbletArgString(rel);
            if (wurbletArgSet.add(wurbletArgs)) {
              out.print(source[529]); // 1858:2 = "  // selects "
              out.print(rel);
              out.print(source[530]); // 1860:20 = ""
              if (rel.isReversed()) {
                out.print(source[531]); // 1863:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[532]); // 1864:54 = " PdoSelectUnique "
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[533]); // 1864:118 = ""
              }
              else {
                out.print(source[534]); // 1868:2 = "  // @wurblet "
                out.print(createRelationSelectMethodName(rel));
                out.print(source[535]); // 1869:54 = " PdoSelectList "
                out.print(trackedOption);
                out.print(wurbletArgs);
                out.print(joins);
                out.print(extraWurbletOptions);
                out.print(source[536]); // 1869:133 = ""
              }
            }
          }
        }
      }
    }

    if (generateDeletes && isEntityPersistable() && !generateMock) {
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (rel.getAccessScope() != AccessScope.PUBLIC) {
          continue;   // skip non-public in interfaces
        }
        if (rel.getRelationType() == RelationType.LIST) {
          Attribute attribute = rel.getForeignAttribute();
          if (attribute != null && rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[537]); // 1886:2 = "  // deletes "
            out.print(rel);
            out.print(source[538]); // 1888:20 = "  // @wurblet "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[539]); // 1889:58 = " PdoDeleteBy "
            out.print(createRelationWurbletArgString(rel));
            out.print(source[540]); // 1889:110 = ""
          }
        }
      }
    }

    if (generateAddReferencing && !generateMock) {
      List<Relation> refRels = new ArrayList<>();
      for (Relation rel: getEntity().getReferencingRelations()) {
        if (!rel.isComposite() && rel.getRelationType() == RelationType.OBJECT &&
            (rel.getForeignRelation() == null || !rel.getForeignRelation().isComposite()) &&
            rel.getForeignEntity() != null && rel.getForeignEntity().getIntegrity().isCheckedByApplication()) {
          if (rel.isEmbedded()) {
            for (List<Relation> embeddingPath : rel.getEntity().getEmbeddingPaths()) {
              String pathStr = "";
              Entity embeddingEntity = null;
              for (Relation embeddingRel : embeddingPath) {
                pathStr += embeddingRel.getGetterName() + ".";
                if (embeddingEntity == null) {
                  embeddingEntity = embeddingRel.getEntity();   // first entity in chain
                }
              }
              refRels.add(rel.createEmbedded(embeddingEntity, pathStr, ""));
            }
          }
          else {
            refRels.add(rel);
          }
        }
      }

      if (!refRels.isEmpty()) {
        out.print(source[541]); // 1922:2 = "  // add referencing classes and their ..."
        if (getEntity().isAbstract()) {
          out.print(source[542]); // 1928:2 = "    @SuppressWarnings("unchecked")"
        }
        out.print(source[543]); // 1932:2 = "    AbstractPersistentObject<?,?> po = (..."
        out.print(pdoName);
        out.print(source[544]); // 1934:30 = ".class).getPersistenceDelegate();"
      // register referencing classes and the methods
      for (Relation rel: refRels) {
        String methodName = "isReferencing" + rel.getClassName() + "By" +
                            StringHelper.firstToUpper(getFirstMethodAttribute(rel).getName());
        if (rel.getEmbeddingEntity() != null) {
          methodName = rel.getPathName() + methodName;
          out.print(source[545]); // 1942:2 = "    po.addReferencingClass("
          out.print(rel.getEmbeddingEntity().getName());
          out.print(source[546]); // 1943:65 = ".class, ""
          out.print(methodName);
          out.print(source[547]); // 1943:88 = "");"
        }
        else {
          for (Entity leaf: rel.getEntity().getLeafEntities()) {
            out.print(source[548]); // 1948:2 = "    po.addReferencingClass("
            out.print(leaf.getName());
            out.print(source[549]); // 1949:45 = ".class, ""
            out.print(methodName);
            out.print(source[550]); // 1949:68 = "");"
          }
        }
      }
      out.print(source[551]); // 1954:2 = "  }"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
