// wurblet generated by Wurbelizer 17.5.1.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to select a list of low-level persistent objects.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DbSelectList
 *     [--private] [--append=&lt;sqltext&gt;] [--classvar=&lt;classvariables&gt;]
 *     [--sort] [--lock] [--resultset] [--bounded] [--limit] [--offset]
 *     &lt;expression&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--private:</em> makes the method private (default is public).</li>
 * <li><em>--append=&lt;sqltext&gt;:</em> appends an sql-string.</li>
 * <li><em>--classvar=&lt;classvariables&gt;:</em> reference to classvariables, if pick the statement-IDs from there.</li>
 * <li><em>--sort:</em> sort according to orderBy()-method.</li>
 * <li><em>--lock:</em> generates SELECT FOR UPDATE.</li>
 * <li><em>--limit:</em> adds a parameter to limit the number of objects.</li>
 * <li><em>--offset:</em> adds a parameter to skip the first objects.</li>
 * <li><em>--resultset:</em> returns the ResultSetWrapper instead of a List.</li>
 * <li><em>--bounded:</em> returns a bounded List&lt;? extends mainClass&gt; instead of List&lt;mainClass&gt;.</li>
 * <li><em>&lt;expression&gt;:</em> see {@link WurbletArgumentParser}.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class DbSelectList extends DbModelWurblet {

  public DbSelectList() {
    setConfiguration("pathAllowed");
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    String className = getClassName();
    String methodName = getMethodName();

    String  scope       = "public";
    String  classVar    = null;
    boolean sort        = false;
    boolean lock        = false;
    String  append      = null;
    boolean limit       = false;
    boolean offset      = false;
    boolean bounded     = false;
    boolean resultSet   = false;

    for (String arg: getOptionArgs())  {
      if (arg.equals("private")) {
        scope = "private";
        setRemote(false);
      }
      else if (arg.equals("sort")) {
        if (isWithDefaultSorting()) {
          if (isWithSorting()) {
            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
          }
          sort = true;
        }
        else {
          throw new WurbelException("no sorting configured in model for " + getEntity());
        }
      }
      else if (arg.equals("lock")) {
        lock = true;
      }
      else if (arg.equals("limit")) {
        limit = true;
      }
      else if (arg.equals("offset")) {
        offset = true;
      }
      else if (arg.equals("bounded")) {
        bounded = true;
      }
      else if (arg.equals("resultset")) {
        resultSet = true;
      }
      else if (arg.startsWith("append=")) {
        append = arg.substring(7);
      }
      else if (arg.startsWith("classvar="))  {
        classVar = arg.substring(9);
      }
    }

    if (resultSet) {
      setRemote(false);     // disable remoting for sure
    }

    if (classVar == null) {
      classVar = "";
    }
    else  {
      classVar += ".";    // add dot to access class var
    }

    String params = buildMethodParameters(limit, offset);
    String iparms = buildInvocationParameters(limit, offset);
    String statementId = createStatementId();

    String listType     = resultSet ? "ResultSetWrapper" :
                            ((isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + className + ">");
    String varListType  = (isTracked() ? "TrackedArrayList" : "List") + "<" + className + ">";
    String rmiListType  = (isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + (isGenerified() ? "P" : className) + ">";

    out.print(source[0]); // 102:2 = "  "
    out.print(scope);
    out.print(source[1]); // 103:11 = " "
    out.print(listType);
    out.print(source[2]); // 103:24 = " "
    out.print(methodName);
    out.print(source[3]); // 103:39 = "("
    out.print(params);
    out.print(source[4]); // 103:50 = ") {    Db db = getSession();"
    if (isRemote()) {
      // create includes
      RemoteIncludes genInc = new RemoteIncludes(this);
      PrintStream implOut      = genInc.getImplStream();
      PrintStream remoteOut    = genInc.getRemoteStream();
      out.print(source[5]); // 111:2 = "    if (db.isRemote())  {      try {"
      remoteOut.print(source[6]); // 114:16 = "  "
      remoteOut.print(rmiListType);
      remoteOut.print(source[7]); // 115:17 = " "
      remoteOut.print(methodName);
      remoteOut.print(source[8]); // 115:32 = "("
      remoteOut.print(params);
      remoteOut.print(source[9]); // 115:43 = ") throws RemoteException;"
      implOut.print(source[10]); // 116:14 = "  @Override  public "
      implOut.print(rmiListType);
      implOut.print(source[11]); // 119:24 = " "
      implOut.print(methodName);
      implOut.print(source[12]); // 119:39 = "("
      implOut.print(params);
      implOut.print(source[13]); // 119:50 = ") throws RemoteException {    try {   ..."
      implOut.print(methodName);
      implOut.print(source[14]); // 121:36 = "("
      implOut.print(iparms);
      implOut.print(source[15]); // 121:47 = ");    }    catch (RuntimeException e) ..."
      out.print(source[16]); // 127:6 = "        "
      out.print(listType);
      out.print(source[17]); // 128:20 = " list = getRemoteDelegate()."
      out.print(methodName);
      out.print(source[18]); // 128:62 = "("
      out.print(iparms);
      out.print(source[19]); // 128:73 = ");        db.applyTo(list);        ret..."
    } // end if remote
     out.print(source[20]); // 138:2 = "    PreparedStatementWrapper st = getPre..."
     out.print(classVar);
     out.print(statementId);
     out.print(source[21]); // 139:82 = ",      b -> {        StringBuilder sql..."
    if (getEntity().getSuperEntity() != null && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
      out.print(source[22]); // genwhere.incl:3:2 = "        sql.append(getSqlClassIdConditio..."
    }
    boolean andPrepended = false;
    if (getContextAttribute() != null) {
        andPrepended = true;
        out.print(source[23]); // genwhere.incl:10:2 = "        sql.append(Backend.SQL_AND)    ..."
        out.print(getColumnNameConstant(getContextAttribute(), 0));
        out.print(source[24]); // genwhere.incl:12:70 = ")           .append(Backend.SQL_EQUAL_P..."
    }

    boolean needParentheses = false;

    if (!getExpressionArguments().isEmpty()) {
      needParentheses = getExpression().needParenthesesAfterAndOperator();
      if (andPrepended || needParentheses) {
        out.print(source[25]); // genwhere.incl:22:2 = "        sql.append(Backend.SQL_AND).appe..."
      }
      else {
        out.print(source[26]); // genwhere.incl:27:2 = "        sql.append(Backend.SQL_AND);"
        if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[27]); // genwhere.incl:31:2 = "        if (classIdRequired) {         ..."
        }
      }

      // not a lambda because reference to instance of codeWriter within itself
      final CodeGenerator<Object> generator = new CodeGenerator<Object>() {

        @Override
        public String generate(Object t) throws WurbelException {
          if (t instanceof WurbletArgumentOperator) {
            return "        sql.append(Backend." + ((WurbletArgumentOperator) t).getSql() + ");\n";
          }
          if (t instanceof WurbletArgumentExpression) {
            StringBuilder buf = new StringBuilder();
            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
            buf.append(((WurbletArgumentExpression) t).toCode(this));
            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            return buf.toString();
          }
          if (t instanceof WurbletArgument) {
            StringBuilder buf = new StringBuilder();
            WurbletArgument arg = (WurbletArgument) t;
            Attribute attr = arg.getAttribute();
            if (arg.isPath()) {
              Set<Relation> existsRels = arg.getExistsRelations();
              if (existsRels != null) {
                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                // (FROM) table1 AS alias1, table2 AS alias 2, ...
                String rightClass;
                String comma = "";
                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(comma).append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableName())\n")
                       .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getTableAlias())\n");
                  }
                }

                for (Relation rel: existsRels) {
                  rightClass = deriveClassNameForEntity(rel.getForeignEntity());
                  buf.append("           .append(").append(comma).append(rightClass)
                     .append(".CLASSVARIABLES.getTableName())\n")
                     .append("           .append(getBackend().sqlAsBeforeTableAlias())\n")
                     .append("           .append(").append(rightClass)
                     .append(".CLASSVARIABLES.getTableAlias())\n");
                  comma = "Backend.SQL_COMMA).append(";
                }

                buf.append("           .append(Backend.SQL_WHERE)\n");

                for (Entity component: arg.getExistsComponents()) {
                  ComponentInfo ci = createComponentInfo(component);
                  rightClass = ci.getRootIdClassName();
                  buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(")
                     .append(ci.getRootIdColumnName()).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");
                  if (ci.isExtraJoinNecessary()) {
                    buf.append("           .append(").append(ci.getRootIdClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n")
                       .append("           .append(").append(ci.getExtraClassName())
                       .append(".CLASSVARIABLES.getColumnName(CN_ID))\n")
                       .append("           .append(Backend.SQL_AND)\n");
                  }
                }

                for (Relation rel: existsRels) {
                  String leftAttribute;
                  String rightAttribute;
                  boolean isEmbeddingRelation = false;
                  if (rel.getRelationType() == RelationType.OBJECT) {
                    if (rel.isEmbedded()) {
                      isEmbeddingRelation = true;
                      leftAttribute = '"' + arg.getEmbeddingColumnPrefix() + rel.getMethodArgs().get(0).getAttribute().getColumnName() + '"';
                    }
                    else {
                      leftAttribute = getColumnNameConstant(rel.getAttribute(), 0);
                    }
                    rightAttribute = "CN_ID";
                  }
                  else {
                    leftAttribute = "CN_ID";
                    rightAttribute = getColumnNameConstant(rel.getForeignAttribute(), 0);
                  }
                  String leftClass = rel.getEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getEntity()) + ".");
                  String leftClassVariables = leftClass.isEmpty() || isEmbeddingRelation ? "" : (leftClass + "CLASSVARIABLES.");
                  rightClass = rel.getForeignEntity().equals(getEntity()) ? "" :
                                                (deriveClassNameForEntity(rel.getForeignEntity()) + ".");
                  buf.append("           .append(").append(leftClassVariables).append("getColumnName(")
                     .append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n")
                     .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                     .append(rightClass).append(rightAttribute).append("))\n")
                     .append("           .append(Backend.SQL_AND)\n");

                  List<MethodArgument> methodArgs = rel.getMethodArgs();
                  for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
                    Attribute mattr = methodArg.getForeignAttribute();
                    buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                       .append(rightClass).append(getColumnNameConstant(mattr, 0)).append("))\n");
                    if (methodArg.isValue()) {
                      buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      for (int columnIndex = 1; columnIndex < getEffectiveDataType(attr).getColumnCount(null); columnIndex++) {
                        buf.append("           .append(Backend.SQL_AND)\n")
                           .append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(")
                           .append(rightClass).append(getColumnNameConstant(attr, columnIndex)).append("))\n")
                           .append("           .append(Backend.SQL_EQUAL_PAR)\n");
                      }
                    }
                    else {
                      buf.append("           .append(Backend.SQL_EQUAL).append(")
                         .append(leftClassVariables).append("getColumnName(").append(leftClassVariables)
                         .append(getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                    }
                    buf.append("           .append(Backend.SQL_AND)\n");
                  }
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(";\n");
              }

              String compKeyClass = deriveClassNameForEntity(attr.getEmbeddingPath() == null ? attr.getEntity() : attr.getEmbeddingPath().get(0));
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(");
                  if (attr.getEmbeddingPath() != null) {
                    try {
                      buf.append('"').append(attr.getColumnName(null, columnIndex)).append("\"))\n");
                    }
                    catch(ModelException mx) {
                      throw new WurbelException("cannot determine embedded column name", mx);
                    }
                  }
                  else {
                    buf.append(compKeyClass).append('.').append(getColumnNameConstant(attr, columnIndex)).append("))\n");
                  }
                  buf.append("           ").append(createRelopCode(arg)).append(";\n");
                }
              }
            }
            else {
              for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(null); columnIndex++) {
                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                  buf.append("        sql.append(Backend.SQL_AND);\n");
                }
                if (arg.getColumnIndex() == null || columnIndex == arg.getColumnIndex()) {
                  if (isPathAllowed()) {
                    if (getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                       buf.append("        sql.append(");
                       buf.append(deriveClassNameForEntity(attr.getEntity()));
                       buf.append(".CLASSVARIABLES.getColumnName(");
                       buf.append(getColumnNameConstant(attr, columnIndex)).append("));\n");
                    }
                    else  {
                      if (isPdo()) {
                        buf.append("        sql.append(getColumnName(");
                        if (attr.isEmbedded()) {
                          buf.append('"').append(attr.getColumnName()).append('"');
                        }
                        else {
                          buf.append(getColumnNameConstant(attr, columnIndex));
                        }
                        buf.append("));\n");
                      }
                      else  {
                        buf.append("        sql.append(").append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                      }
                    }
                  }
                  else  {
                    buf.append("        sql.append(");
                    if (attr.isEmbedded()) {
                      buf.append("getColumnPrefix() + ");
                    }
                    buf.append(getColumnNameConstant(attr, columnIndex)).append(");\n");
                  }
                  buf.append("        sql").append(createRelopCode(arg)).append(";\n");
                }
              }
            }

            if (arg.isEndOfExistsClause()) {
              buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }

            return buf.toString();
          }
          return "        sql.append(" + t + ");\n";
        }
      };

      // generate it!
      String code = getExpression().toCode(generator);
      if (code.endsWith("\n")) {
        code = code.substring(0, code.length() - 1);
      }
      out.print(code);
      out.print(source[28]); // genwhere.incl:245:8 = ""
      if (andPrepended || needParentheses) {
        out.print(source[29]); // genwhere.incl:248:2 = "        sql.append(Backend.SQL_RIGHT_PAR..."
      }
      else if (needParentheses && getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
        out.print(source[30]); // genwhere.incl:253:2 = "        if (classIdRequired) {         ..."
      }
    }

    String orderByStr = createOrderBy();
    if (orderByStr != null) {
      out.print(source[31]); // genwhere.incl:263:2 = "        sql.append(Backend.SQL_ORDERBY)..."
      out.print(orderByStr);
      out.print(source[32]); // genwhere.incl:265:25 = ";"
    }
    out.print(source[33]); // 142:37 = "        b.buildSelectSql(sql, "
    out.print(lock ? "true" : "false");
    out.print(source[34]); // 143:57 = ", "
    out.print(limit ? "limit" : "0");
    out.print(source[35]); // 143:84 = ", "
    out.print(offset ? "offset" : "0");
    out.print(source[36]); // 143:113 = ");"
    if (sort) {
      out.print(source[37]); // 146:2 = "        String orderSuffix = orderBy();..."
    }
    if (append != null)  {
      out.print(source[38]); // 154:2 = "        sql.append(' ').append("
      out.print(append);
      out.print(source[39]); // 155:41 = ");"
    }
    out.print(source[40]); // 158:2 = "        return sql.toString();      } ..."
    if (limit || offset) {
      out.print(source[41]); // 164:2 = "    int ndx = getBackend().setLeadingSel..."
      out.print(limit ? "limit" : "0");
      out.print(source[42]); // 165:83 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[43]); // 165:112 = ");"
    }
    else  {
      out.print(source[44]); // 169:2 = "    int ndx = 1;"
    }
    if (isWithJoins()) {
      out.print(createJoinSetPars());
    }

    if (getContextAttribute() != null) {
      out.print(source[45]); // gensetpar.incl:7:2 = "    st."
      out.print(createJdbcSetterName(getContextAttribute().getDataType()));
      out.print(source[46]); // gensetpar.incl:8:68 = "(ndx++, "
      out.print(getContextAttribute().getName());
      out.print(source[47]); // gensetpar.incl:8:111 = ");"
    }
    for (WurbletArgument par: getMethodArguments())  {
      if (par.isPath()) {
        // check for additional value-args in relations
        Set<Relation> existsRels = par.getExistsRelations();
        if (existsRels != null) {
          for (Relation rel: existsRels) {
            List<MethodArgument> methodArgs = rel.getMethodArgs();
            for (MethodArgument methodArg: methodArgs.subList(1, methodArgs.size())) {
              if (methodArg.isValue()) {
                Attribute attr = methodArg.getForeignAttribute();
                out.print(source[48]); // gensetpar.incl:21:2 = "    "
                out.print(createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                out.print(source[49]); // gensetpar.incl:22:77 = ";"
              }
            }
          }
        }
      }

      if (!par.isValueLiterally()) {
        out.print(source[50]); // gensetpar.incl:31:2 = "    "
        out.print(createWhereSetPars(par));
        out.print(source[51]); // gensetpar.incl:32:31 = ";"
      }
    }
    if (limit || offset) {
      out.print(source[52]); // 177:2 = "    getBackend().setTrailingSelectParame..."
      out.print(limit ? "limit" : "0");
      out.print(source[53]); // 178:79 = ", "
      out.print(offset ? "offset" : "0");
      out.print(source[54]); // 178:108 = ");"
    }

    if (resultSet) {
      out.print(source[55]); // 183:2 = "    return st.executeQuery();"
    }
    else  {
      out.print(source[56]); // 188:2 = "    try (ResultSetWrapper rs = st.execut..."
      if (isTracked())  {
        out.print(source[57]); // 192:2 = "      "
        out.print(varListType);
        out.print(source[58]); // 193:21 = " list = new TrackedArrayList<>();"
      }
      else  {
        out.print(source[59]); // 197:2 = "      "
        out.print(varListType);
        out.print(source[60]); // 198:21 = " list = new ArrayList<>();"
      }

    // optimization: newInstance() is 10 times slower than new BlahObject()
    out.print(source[61]); // 203:2 = "      boolean derived = getClass() != "
    out.print(className);
    out.print(source[62]); // 204:51 = ".class;      while (rs.next()) {      ..."
    out.print(className);
    out.print(source[63]); // 206:21 = " obj = derived ? newInstance() : new "
    out.print(className);
    out.print(source[64]); // 206:71 = "(db);        list.add(obj.readFromResul..."
      if (isTracked())  {
        out.print(source[65]); // 211:2 = "      list.setModified(false);"
      }
      out.print(source[66]); // 215:2 = "      return list;    }"
    }
    out.print(source[67]); // 220:2 = "  }"
    if (classVar.isEmpty()) {
      out.print(source[68]); // 224:2 = "  private static final StatementId "
      out.print(statementId);
      out.print(source[69]); // 226:50 = " = new StatementId();"
    }
  }

  // ----------------- end wurblet code -----------------

  @Override
  public String process(String code) {
    int ref = code.lastIndexOf("ndx");
    int pos = code.lastIndexOf("(ndx++,");
    if (pos >= 0 && ref == pos + 1) {
      // remove unnecessary last ++
      code = code.substring(0, pos + 4) + code.substring(pos + 6);
    }
    else {
      // remove unnecessary last ndx +=
      pos = code.lastIndexOf("ndx += st.set(");   // ndx += st.set(DT_POSITION3D, ndx, dropPosition, false, null);
      if (pos >= 0 && ref > pos) {
        code = code.substring(0, pos) + code.substring(pos + 7);
      }
      else {
        pos = code.lastIndexOf(", ndx++, ");   // st.set(SqlType....., ndx++, value.get...)
        if (pos >= 0 && ref > pos) {
          code = code.substring(0, pos + 5) + code.substring(pos + 7);
        }
      }
    }
    return code;
  }
}
