// wurblet generated by Wurbelizer 17.3.2.1, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk] [--noisroot] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * <li><em>--noisroot:</em> don't generate isRootEntity() method.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    boolean isPdo;
    try {
      pdoClass = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;
    boolean generateIsRoot = true;
    boolean generateMock = false;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
      else if ("noisroot".equals(arg)) {
        generateIsRoot = false;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    boolean generateCreateNormText = false;
    boolean generatePresetVirgin = false;
    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isPartOfNormText())  {
        generateCreateNormText = true;
      }
      if (attr.getOptions().getNewValue() != null) {
        generatePresetVirgin = true;
      }
    }

    if (!generateMock) {
      if (isRemote()) {
        new RemoteIncludes(this);   // create RMI-files if they don't exist yet
        String delegateType = (isPdo() ? pdoClass : mainClass) + "RemoteDelegate";
        if (getEntity().isAbstract()) {
          delegateType += "<T,P>";
        }
        out.print(source[0]); // 72:2 = "  @Override  public "
        out.print(delegateType);
        out.print(source[1]); // 75:25 = " getRemoteDelegate() {    return ("
        out.print(delegateType);
        out.print(source[2]); // 76:28 = ") super.getRemoteDelegate();  }"
      }

      if (getEntity().isAbstract()) {
        if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
          out.print(source[3]); // 83:2 = "  @Override  public boolean isExplicit..."
        }
      }

      if (getEntity().getSuperEntity() != null &&
          (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE || getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI)) {
        List<Entity> leafs = getEntity().getLeafEntities();
        if (!leafs.isEmpty()) {
          int[] classIds = new int[leafs.size()];
          int ndx = 0;
          for (Entity leaf : leafs) {
            classIds[ndx++] = leaf.getClassId();
          }
          Arrays.sort(classIds);    // predictable order
          StringBuilder buf = new StringBuilder();
          boolean needComma = false;
          for (int classId : classIds) {
            if (needComma) {
              buf.append(", ");
            }
            else {
              needComma = true;
            }
            buf.append(classId);
          }
          out.print(source[4]); // 114:2 = "  private static final List<Integer> VA..."
          out.print(buf);
          out.print(source[5]); // 116:70 = ");  @Override  public List<Integer> g..."
        }
      }

      boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

      boolean readOnly = getEntity().getOptions().isReadOnly();
      if (readOnly) {
        out.print(source[6]); // 130:2 = "  @Override  public boolean isImmutabl..."
      }

      if (getEntity().getSuperEntity() == null) {

        if (generateIsRoot && getEntity().getOptions().isRoot()) {
          out.print(source[7]); // 147:2 = "  @Override  public boolean isRootEnti..."
        }

        if (getEntity().getOptions().isTableSerialProvided()) {
          out.print(source[8]); // 157:2 = "  @Override  public boolean isTableSer..."
        }

        if (getEntity().getOptions().isTokenLockProvided()) {
          out.print(source[9]); // 167:2 = "  @Override  public boolean isTokenLoc..."
        }

        if (getEntity().getOptions().isNormTextProvided()) {
          out.print(source[10]); // 177:2 = "  @Override  public boolean isNormText..."
        }

        if (getEntity().getOptions().isRootIdProvided()) {
          out.print(source[11]); // 187:2 = "  @Override  public boolean isRootIdPr..."
        }
        else {
          Attribute rootAttribute = getEntity().getRootAttribute();
          if (rootAttribute != null) {

            out.print(source[12]); // 199:2 = "  @Override  public long getRootId() {..."
            out.print(rootAttribute.getName());
            out.print(source[13]); // 203:38 = ";  }"
          }
        }

        if (getEntity().getOptions().isRootClassIdProvided()) {
          out.print(source[14]); // 210:2 = "  @Override  public boolean isRootClas..."
        }
        else {
          Entity rootEntity = getEntity().getRootEntity();
          if (rootEntity != null) {
            out.print(source[15]); // 221:2 = "  @Override  public int getRootClassId..."
            out.print(rootEntity.getClassId());
            out.print(source[16]); // 225:38 = ";  }"
          }
        }

        if (isTracked())  {
          out.print(source[17]); // 232:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[18]); // 243:2 = "  @Override  public void setModified(b..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute())    {
            if (isFullTracked()) {
              out.print(source[19]); // 253:2 = "      "
              out.print(attr.getName());
              out.print(source[20]); // 254:24 = "Persisted = "
              out.print(attr.getName());
              out.print(source[21]); // 254:54 = ";"
            }
            else {
              out.print(source[22]); // 258:2 = "      "
              out.print(attr.getName());
              out.print(source[23]); // 259:24 = "Modified = false;"
            }
          }
        }
        out.print(source[24]); // 264:2 = "    }  }"
      }


      if (isFullTracked()) {
        out.print(source[25]); // 272:2 = "  @Override  public boolean differsPer..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute() &&
              !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
            if (attr.getDataType().isPrimitive()) {
              out.print(source[26]); // 282:2 = "           || "
              out.print(attr.getName());
              out.print(source[27]); // 283:32 = "Persisted != "
              out.print(attr.getName());
              out.print(source[28]); // 283:63 = ""
            }
            else {
              out.print(source[29]); // 287:2 = "           || !Objects.equals("
              out.print(attr.getName());
              out.print(source[30]); // 288:48 = "Persisted, "
              out.print(attr.getName());
              out.print(source[31]); // 288:77 = ")"
            }
          }
        }
        out.print(source[32]); // 293:2 = "           ;  }  @Override  public b..."
      }

      if (!getEntity().getInheritanceType().isMappingToNoTable()) {
        String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
        if (orderBy != null) {
          out.print(source[33]); // 307:2 = "  @Override  public String orderBy() {..."
          out.print(orderBy);
          out.print(source[34]); // 312:18 = ";    return sql.toString();  }"
        }
        out.print(source[35]); // 317:2 = "  @Override  public void getFields(Res..."
        boolean needConfig = false;
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isMute())  {
            needConfig = true;
            break;
          }
        }
        if (needConfig) {
          out.print(source[36]); // 331:2 = "    if (rs.configureSection(CLASSVARIABL..."
          for (Attribute attr: getEntity().getMappedAttributes())  {
            if (!attr.getOptions().isMute())  {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                out.print(source[37]); // 337:2 = "      rs.configureColumn("
                out.print(getColumnNameConstant(attr, columnIndex));
                out.print(source[38]); // 338:69 = ");"
              }
            }
          }
          out.print(source[39]); // 343:2 = "    }"
        }
        else {
          out.print(source[40]); // 348:2 = "    rs.configureSection(CLASSVARIABLES);..."
        }
        out.print(source[41]); // 352:2 = "    if (rs.getRow() <= 0) {      throw ..."
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isMute())  {
            String name = attr.getName().toUpperCase();
            boolean useSetter = isAttributeDerived(attr);
            DataType<?> dataType = getEffectiveDataType(attr);
            if (dataType.isPredefined()) {
              String getterMethod = createJdbcGetterName(attr);
              if ("Binary".equals(attr.getDataType().getJavaType())) {
                // Binary getter takes additional buffer size argument
                int bufsize = attr.getSize() == null ? 0 : attr.getSize();
                if (useSetter)  {
                  out.print(source[42]); // 368:2 = "    "
                  out.print(attr.getSetterName());
                  out.print(source[43]); // 369:28 = "(rs."
                  out.print(getterMethod);
                  out.print(source[44]); // 369:48 = "("
                  out.print(bufsize);
                  out.print(source[45]); // 369:60 = "));"
                }
                else  {
                  out.print(source[46]); // 373:2 = "    "
                  out.print(attr.getName());
                  out.print(source[47]); // 374:22 = " = rs."
                  out.print(getterMethod);
                  out.print(source[48]); // 374:44 = "("
                  out.print(bufsize);
                  out.print(source[49]); // 374:56 = ");"
                }
              }
              else  {
                String rsGetter = "rs." + getterMethod + "(";
                boolean needComma = false;
                if (attr.getOptions().isWithTimezone()) {
                  rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                  needComma = true;
                }
                if (attr.getOptions().isMapNull()) {
                  if (needComma) {
                    rsGetter += ", ";
                  }
                  rsGetter += "true";
                  needComma = true;
                }
                rsGetter += ")";

                String modelCode = getModelCode(attr, rsGetter);

                if (attr.getOptions().isTrimRead() && attr.getSize() != null) {
                  modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSize() + ")";
                }

                if (useSetter) {
                  modelCode = attr.getSetterName() + "(" + modelCode + ")";
                }
                else  {
                  modelCode = attr.getName() + " = " + modelCode;
                }
                out.print(source[50]); // 406:2 = "    "
                out.print(modelCode);
                out.print(source[51]); // 407:17 = ";"
                if (attr.getOptions().isUTC()) {
                  if (useSetter) {
                    modelCode = attr.getGetterName() + "()";
                  }
                  else  {
                    modelCode = attr.getName();
                  }
                  out.print(source[52]); // 416:2 = "    if ("
                  out.print(modelCode);
                  out.print(source[53]); // 417:21 = " != null) {      "
                  out.print(modelCode);
                  out.print(source[54]); // 418:19 = ".setUTC(true);    }"
                }
              }
            }
            else {    // application specific type
              String rsGetter = "rs.get(" + dataType.getDataTypeConstant() + ", " + attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
              String modelCode = getModelCode(attr, rsGetter);
              if (useSetter) {
                modelCode = attr.getSetterName() + "(" + modelCode + ")";
              }
              else  {
                modelCode = attr.getName() + " = " + modelCode;
              }
              out.print(source[55]); // 433:2 = "    "
              out.print(modelCode);
              out.print(source[56]); // 434:17 = ";"
            }
          }
        }
        out.print(source[57]); // 439:2 = "  }"
        if (!readOnly) {
          if (multiInheritance) {
            out.print(source[58]); // 444:2 = "  /**   * Sets the values of all "
            out.print(pdoClass);
            out.print(source[59]); // 447:40 = "-columns in the given statement.   *  ..."
            out.print(pdoClass);
            out.print(source[60]); // 452:34 = "(PreparedStatementWrapper st) {    int ..."
          }
          else  {
            out.print(source[61]); // 457:2 = "  @Override  public int setFields(Prep..."
          }

          for (Attribute attr: getEntity().getMappedAttributes()) {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly())  {
              boolean useGetter = isAttributeDerived(attr);
              DataType<?> dataType = getEffectiveDataType(attr);
              if (dataType.isPredefined()) {
                String setterName = createJdbcSetterName(dataType);

                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }

                String jdbcCode = getJdbcCode(attr, modelCode);

                if (attr.getOptions().isTrimWrite() && attr.getSize() != null) {
                  jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSize() + ")";
                }

                jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
                if (attr.getOptions().isWithTimezone()) {
                  jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                }
                if (attr.getOptions().isMapNull()) {
                  jdbcCode += ", true)";
                }
                else  {
                  jdbcCode += ")";
                }
                out.print(source[62]); // 496:2 = "    "
                out.print(jdbcCode);
                out.print(source[63]); // 497:16 = ";"

                // for multi column types, such as BMoney or application specific types
                int diff = getEffectiveDataType(attr).getColumnCount() - 1;
                if (diff == 1) {
                  out.print(source[64]); // 503:2 = "    ndx++;"
                }
                else if (diff > 1) {
                  out.print(source[65]); // 508:2 = "    ndx += "
                  out.print(diff);
                  out.print(source[66]); // 509:19 = ";"
                }
              }
              else {    // application specific type
                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }
                String jdbcCode = "ndx += st.set(" + dataType.getDataTypeConstant() + ", ndx + 1, " +
                                  getJdbcCode(attr, modelCode) + ", " +
                                  attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
                                  out.print(source[67]); // 524:2 = "    "
                                  out.print(jdbcCode);
                                  out.print(source[68]); // 525:16 = ";"
              }
            }
          }

          if (multiInheritance && getEntity().getSuperEntity() != null) {
            out.print(source[69]); // 532:2 = "    st.setLong(++ndx, getId());"
          }
          out.print(source[70]); // 536:2 = "    return ndx;  }"
        }
      }

      if (getEntity().getInheritanceType().isMappingToOwnTable()) {

        List<Attribute> attributes = multiInheritance ?
                                        getEntity().getTableAttributes() : getEntity().getAttributesIncludingInherited();
        List<String> names = new ArrayList<>();   // column name constants CN_...

        if (!readOnly) {
          for (Attribute attr: attributes)  {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly()) {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                names.add(getColumnNameConstant(attr, columnIndex));
              }
            }
          }

          if (multiInheritance) {
            out.print(source[71]); // 559:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[72]); // 562:46 = " insert statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[73]); // 566:43 = "() {"
          }
          else  {
            out.print(source[74]); // 570:2 = "  @Override  public String createInser..."
          }
          out.print(source[75]); // 576:2 = "    return Backend.SQL_INSERT_INTO + "
          out.print(multiInheritance ? "CLASSVARIABLES." : "");
          out.print(source[76]); // 577:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."

          int count = 0;
          for (String name: names) {
            String lineSep = count == names.size() - 1 ? " +" : " + Backend.SQL_COMMA +";
            out.print(source[77]); // 583:2 = "           "
            out.print(name);
            out.print(lineSep);
            out.print(source[78]); // 584:30 = ""
            count++;
          }
          out.print(source[79]); // 588:2 = "           Backend.SQL_INSERT_VALUES +"
          while (--count > 0)	{
            out.print(source[80]); // 592:2 = "           Backend.SQL_PAR_COMMA +"
          }
          out.print(source[81]); // 596:2 = "           Backend.SQL_PAR + Backend.SQL..."

          names.clear();
          for (Attribute attr: attributes)  {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                names.add(getColumnNameConstant(attr, columnIndex));
              }
            }
          }

          if (multiInheritance) {
            out.print(source[82]); // 611:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[83]); // 614:46 = " update statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[84]); // 618:43 = "() {"
          }
          else  {
            out.print(source[85]); // 622:2 = "  @Override  public String createUpdat..."
          }
          out.print(source[86]); // 628:2 = "    return Backend.SQL_UPDATE + "
          out.print(multiInheritance ? "CLASSVARIABLES." : "");
          out.print(source[87]); // 629:77 = "getTableName() + Backend.SQL_SET +"
          boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
          int ncnt = 0;
          for (String name: names) {
            ncnt++;
            if (!checkSerial && ncnt == names.size()) {
              out.print(source[88]); // 636:2 = "           "
              out.print(name);
              out.print(source[89]); // 637:19 = " + Backend.SQL_EQUAL_PAR +"
            }
            else {
              out.print(source[90]); // 641:2 = "           "
              out.print(name);
              out.print(source[91]); // 642:19 = " + Backend.SQL_EQUAL_PAR_COMMA +"
            }
          }

          if (ncnt == 0 && !checkSerial) {
            // special case: no attributes and no checkserial
            out.print(source[92]); // 649:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
          }

          if (checkSerial) {
            out.print(source[93]); // 655:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
          }
          else  {
            out.print(source[94]); // 662:2 = "           Backend.SQL_WHERE + CN_ID + B..."
          }
          out.print(source[95]); // 666:2 = "  }"
        }
      }

      if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE && getEntity().getSuperEntity() != null) {
        // for all single table inherited subclasses (not the top one)
        out.print(source[96]); // 674:2 = "  @Override  public StringBuilder crea..."
        // part 1: all entities starting from topmost to me
        Entity topEntity = getEntity().getTopSuperEntity();
        List<Entity> superEntities = topEntity.getInheritanceChain(getEntity());
        for (Entity superEntity : superEntities) {
          out.print(source[97]); // 686:2 = "         names.addAll("
          out.print(deriveClassNameForEntity(superEntity));
          out.print(source[98]); // 687:63 = ".CNS_"
          out.print(superEntity.getName().toUpperCase());
          out.print(source[99]); // 687:107 = ");"
        }
        // part 2: all sub entities of me
        List<Entity> subEntities = getEntity().getAllSubEntities();
        for (Entity subEntity : subEntities) {
          out.print(source[100]); // 693:2 = "         names.addAll("
          out.print(deriveClassNameForEntity(subEntity));
          out.print(source[101]); // 694:61 = ".CNS_"
          out.print(subEntity.getName().toUpperCase());
          out.print(source[102]); // 694:103 = ");"
        }
        out.print(source[103]); // 697:2 = "         return names;       }))      ..."
      }

      else if (multiInheritance) {
        // create joinable sql selects with table aliases
        Entity topEntity = getEntity().getTopSuperEntity();
        List<Entity> chain = topEntity.getInheritanceChain(getEntity());
        List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
        String topImplClass = deriveClassNameForEntity(topEntity);

        if (!readOnly) {
          out.print(source[104]); // 716:2 = "  /**   * Creates the SQL code for the..."
          out.print(pdoClass);
          out.print(source[105]); // 719:46 = " delete statement.   *   * @return the..."
          out.print(pdoClass);
          out.print(source[106]); // 723:43 = "() {"
          if (getEntity().isRootOfInheritanceHierarchy()) {
            out.print(source[107]); // 726:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          else  {
            out.print(source[108]); // 733:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          out.print(source[109]); // 738:2 = "  }"
        }
        out.print(source[110]); // 742:2 = "  @Override  public StringBuilder crea..."
        boolean needComma = false;
        for (Entity entity: chain) {
          String implClass = deriveClassNameForEntity(entity);
          if (isMuteOptionSet(entity)) {
            out.print(source[111]); // 752:2 = "    sql."
            out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
            out.print(source[112]); // 753:57 = "append("
            out.print(implClass);
            out.print(source[113]); // 753:77 = ".CLASSVARIABLES.getColumnNames("
            out.print(implClass);
            out.print(source[114]); // 753:121 = ".CNS_"
            out.print(entity.getName().toUpperCase());
            out.print(source[115]); // 753:160 = "));"
          }
          else {
            out.print(source[116]); // 757:2 = "    sql."
            out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
            out.print(source[117]); // 758:57 = "append("
            out.print(implClass);
            out.print(source[118]); // 758:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
          }
          needComma = true;
          if (entity == topEntity) {
            for (Entity sub: subs) {
              implClass = deriveClassNameForEntity(sub);
              if (isMuteOptionSet(sub)) {
                out.print(source[119]); // 766:2 = "    sql.append(Backend.SQL_COMMA).append..."
                out.print(implClass);
                out.print(source[120]); // 767:54 = ".CLASSVARIABLES.getColumnNames("
                out.print(implClass);
                out.print(source[121]); // 767:98 = ".CNS_"
                out.print(sub.getName().toUpperCase());
                out.print(source[122]); // 767:134 = "));"
              }
              else {
                out.print(source[123]); // 771:2 = "    sql.append(Backend.SQL_COMMA).append..."
                out.print(implClass);
                out.print(source[124]); // 772:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
              }
            }
          }
        }
        out.print(source[125]); // 778:2 = "    sql.append(Backend.SQL_FROM);    sq..."
        out.print(topImplClass);
        out.print(source[126]); // 780:31 = ".CLASSVARIABLES.getTableName()).       ..."
        out.print(topImplClass);
        out.print(source[127]); // 781:76 = ".CLASSVARIABLES.getTableAlias());"
        if (chain.size() > 1) {
          for (Entity entity: chain.subList(1, chain.size())) {
            String implClass = deriveClassNameForEntity(entity);
            out.print(source[128]); // 786:2 = "    sql.append(getBackend().sqlJoin(Join..."
            out.print(implClass);
            out.print(source[129]); // 788:28 = ".CLASSVARIABLES.getTableName(), "
            out.print(implClass);
            out.print(source[130]); // 788:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
            out.print(topImplClass);
            out.print(source[131]); // 789:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
            out.print(implClass);
            out.print(source[132]); // 790:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
          }
        }

        for (Entity sub: subs) {
          String implClass = deriveClassNameForEntity(sub);
          out.print(source[133]); // 797:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[134]); // 799:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[135]); // 799:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[136]); // 800:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[137]); // 801:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
        out.print(source[138]); // 804:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
        String implClass = deriveClassNameForEntity(topEntity);
        out.print(source[139]); // 810:2 = "  @Override  public StringBuilder crea..."
        out.print(implClass);
        out.print(source[140]); // 816:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

        if (getEntity().isRootOfInheritanceHierarchy()) {
          out.print(source[141]); // 823:2 = "  @Override  protected void updateImpl..."
          out.print(pdoClass);
          out.print(source[142]); // 827:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[143]); // 828:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[144]); // 834:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[145]); // 835:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[146]); // 841:158 = ");    st.setLong(1, getId());    st.se..."
        }
        else  {
          out.print(source[147]); // 849:2 = "  @Override  protected void updateImpl..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[148]); // 852:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[149]); // 855:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[150]); // 856:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[151]); // 861:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[152]); // 864:158 = ");    setFields"
          out.print(pdoClass);
          out.print(source[153]); // 865:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[154]); // 870:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[155]); // 872:158 = ");    st.setLong(1, getId());    asser..."
        }
      } // end multiinheritance

      else if (isMuteOptionSet(getEntity())) {
        out.print(source[156]); // 882:2 = "  @Override  public StringBuilder crea..."
        out.print(getEntity().getName().toUpperCase());
        out.print(source[157]); // 887:73 = "))       .append(Backend.SQL_FROM)    ..."
      }

    } // end !mock

    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isMute()) {
        continue;   // skip
      }
      if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr)) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[158]); // 907:2 = "  /*   * no accessor methods for "
          out.print(attr);
          out.print(source[159]); // 910:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[160]); // 911:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[161]); // 923:2 = "  // "
          out.print(attr);
          out.print(source[162]); // 925:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.isHidden()) {
            out.print(source[163]); // 930:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[164]); // 933:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[165]); // 935:48 = "   */"
          }
          else {
            out.print(source[166]); // 940:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[167]); // 948:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[168]); // 949:26 = ""
            }
          }
          out.print(source[169]); // 953:2 = "  "
          out.print(protection);
          out.print(source[170]); // 954:16 = " "
          out.print(type);
          out.print(source[171]); // 954:25 = " "
          out.print(getter);
          out.print(source[172]); // 954:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[173]); // 955:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[174]); // 961:2 = "  // "
          out.print(attr);
          out.print(source[175]); // 963:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[176]); // 976:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[177]); // 979:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[178]); // 981:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[179]); // 981:66 = "   */"
          }
          else {
            out.print(source[180]); // 986:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
              out.print(source[181]); // 994:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[182]); // 995:26 = ""
            }
          }
          out.print(source[183]); // 999:2 = "  "
          out.print(setterProtection);
          out.print(source[184]); // 1000:22 = " void "
          out.print(setter);
          out.print(source[185]); // 1000:38 = "("
          out.print(type);
          out.print(source[186]); // 1000:47 = " "
          out.print(attr.getName());
          out.print(source[187]); // 1000:66 = ") {"
          if (type.equals("Timestamp")) {
            out.print(source[188]); // 1003:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[189]); // 1004:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[190]); // 1004:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[191]); // 1008:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[192]); // 1009:39 = ");"
          }
          if (generateMock) {
            out.print(source[193]); // 1013:2 = "    this."
            out.print(attr.getName());
            out.print(source[194]); // 1014:27 = " = "
            out.print(attr.getName());
            out.print(source[195]); // 1014:48 = ";"
          }
          else {
            if (isTracked())  {
              if (isFullTracked()) {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[196]); // 1021:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[197]); // 1022:31 = " != "
                  out.print(attr.getName());
                  out.print(source[198]); // 1022:53 = ") {      assertMutable();      firePro..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[199]); // 1024:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[200]); // 1024:85 = ", "
                  out.print(attr.getName());
                  out.print(source[201]); // 1024:105 = ");      this."
                  out.print(attr.getName());
                  out.print(source[202]); // 1025:29 = " = "
                  out.print(attr.getName());
                  out.print(source[203]); // 1025:50 = ";    }"
                }
                else {
                  out.print(source[204]); // 1030:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[205]); // 1031:47 = ", "
                  out.print(attr.getName());
                  out.print(source[206]); // 1031:67 = ")) {      assertMutable();      firePr..."
                  out.print(attr.getName().toUpperCase());
                  out.print(source[207]); // 1033:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[208]); // 1033:85 = ", "
                  out.print(attr.getName());
                  out.print(source[209]); // 1033:105 = ");      this."
                  out.print(attr.getName());
                  out.print(source[210]); // 1034:29 = " = "
                  out.print(attr.getName());
                  out.print(source[211]); // 1034:50 = ";    }"
                }
              }
              else {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[212]); // 1041:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[213]); // 1042:31 = " != "
                  out.print(attr.getName());
                  out.print(source[214]); // 1042:53 = ") {      setModified(true);      this...."
                  out.print(attr.getName());
                  out.print(source[215]); // 1044:29 = " = "
                  out.print(attr.getName());
                  out.print(source[216]); // 1044:50 = ";"
                  if (isAttracked()) {
                    out.print(source[217]); // 1047:2 = "      "
                    out.print(attr.getName());
                    out.print(source[218]); // 1048:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase());
                    out.print(source[219]); // 1049:60 = ", this."
                    out.print(attr.getName());
                    out.print(source[220]); // 1049:85 = ", "
                    out.print(attr.getName());
                    out.print(source[221]); // 1049:105 = ");"
                  }
                  out.print(source[222]); // 1052:2 = "    }"
                }
                else  {
                  out.print(source[223]); // 1057:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[224]); // 1058:47 = ", "
                  out.print(attr.getName());
                  out.print(source[225]); // 1058:67 = ")) {      setModified(true);      this..."
                  out.print(attr.getName());
                  out.print(source[226]); // 1060:29 = " = "
                  out.print(attr.getName());
                  out.print(source[227]); // 1060:50 = ";"
                  if (isAttracked()) {
                    out.print(source[228]); // 1063:2 = "      "
                    out.print(attr.getName());
                    out.print(source[229]); // 1064:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase());
                    out.print(source[230]); // 1065:60 = ", this."
                    out.print(attr.getName());
                    out.print(source[231]); // 1065:85 = ", "
                    out.print(attr.getName());
                    out.print(source[232]); // 1065:105 = ");"
                  }
                  out.print(source[233]); // 1068:2 = "    }"
                }
              }
            }
            else {
              out.print(source[234]); // 1075:2 = "    assertMutable();    this."
              out.print(attr.getName());
              out.print(source[235]); // 1077:27 = " = "
              out.print(attr.getName());
              out.print(source[236]); // 1077:48 = ";"
            }
          }
          out.print(source[237]); // 1081:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[238]); // 1086:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[239]); // 1089:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[240]); // 1091:30 = " has been modified   */"
            }
            else {
              out.print(source[241]); // 1096:2 = "  @Override"
            }
            out.print(source[242]); // 1101:2 = "  "
            out.print(protection);
            out.print(source[243]); // 1102:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[244]); // 1102:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[245]); // 1106:2 = "    return "
                out.print(attr.getName());
                out.print(source[246]); // 1107:29 = " != "
                out.print(attr.getName());
                out.print(source[247]); // 1107:51 = "Persisted;"
              }
              else {
                out.print(source[248]); // 1111:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[249]); // 1112:45 = ", "
                out.print(attr.getName());
                out.print(source[250]); // 1112:65 = "Persisted);"
              }
            }
            else {
              out.print(source[251]); // 1117:2 = "    return "
              out.print(attr.getName());
              out.print(source[252]); // 1118:29 = "Modified;"
            }
            out.print(source[253]); // 1121:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[254]); // 1128:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[255]); // 1131:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[256]); // 1138:2 = "  @Override"
            }
            out.print(source[257]); // 1143:2 = "  "
            out.print(protection);
            out.print(source[258]); // 1144:16 = " "
            out.print(attr.getJavaType());
            out.print(source[259]); // 1144:39 = " "
            out.print(getter);
            out.print(source[260]); // 1144:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[261]); // 1145:29 = "Persisted;  }"
          }
        }
      }
    }

    if (!generateMock) {
      if (isPdo && generateSnapshot) {

        // createAttributesInSnapshot isnt necessary anymore since 2.2.x

        boolean needRevertAttributes = false;
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isMute() && !isAttributeDerived(attr) && !attr.getOptions().isShallow()) {
            needRevertAttributes = true;
            break;
          }
        }

        if (needRevertAttributes) {
          out.print(source[262]); // 1167:2 = "  /**   * Copies all attributes from a..."
          out.print(mainClass);
          out.print(getEntity().isAbstract() ? "<T,?>" : "");
          out.print(source[263]); // 1174:100 = " snapshot) {    super.revertAttributesT..."
          for (Attribute attr: getEntity().getAttributes()) {
            if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr) && !attr.getOptions().isShallow() && !attr.getOptions().isMute())    {
              String name = attr.getName();
              out.print(source[264]); // 1180:2 = "    "
              out.print(name);
              out.print(source[265]); // 1181:12 = " = snapshot."
              out.print(name);
              out.print(source[266]); // 1181:32 = ";"
              if (isAttracked()) {
                if (isFullTracked()) {
                  out.print(source[267]); // 1185:2 = "    "
                  out.print(name);
                  out.print(source[268]); // 1186:12 = "Persisted = snapshot."
                  out.print(name);
                  out.print(source[269]); // 1186:41 = "Persisted;"
                }
                else {
                  out.print(source[270]); // 1190:2 = "    "
                  out.print(name);
                  out.print(source[271]); // 1191:12 = "Modified = snapshot."
                  out.print(name);
                  out.print(source[272]); // 1191:40 = "Modified;"
                }
              }
            }
          }
          out.print(source[273]); // 1197:2 = "  }"
        }
      }

      if (generateCreateNormText) {
        out.print(source[274]); // 1204:2 = "  @Override  public StringBuilder crea..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (attr.getOptions().isPartOfNormText())  {
            out.print(source[275]); // 1215:2 = "    buf.append("
            out.print(attr.getGetterName());
            out.print(source[276]); // 1216:39 = "()).append(',');"
          }
        }
        out.print(source[277]); // 1220:2 = "    return buf;  }"
      }

      if (generatePresetVirgin) {
        out.print(source[278]); // 1227:2 = "  @Override  protected void presetVirg..."
        for (Attribute attr: getEntity().getAttributes())  {
          String newValue = attr.getOptions().getNewValue();
          if (newValue != null)  {
            out.print(source[279]); // 1235:2 = "    "
            out.print(attr.getName());
            out.print(source[280]); // 1236:22 = " = "
            out.print(newValue);
            out.print(source[281]); // 1236:37 = ";"
          }
        }
        out.print(source[282]); // 1240:2 = "  }"
      }

      if (generateSelectByUDK) {
        List<Attribute> udk = getEntity().getUniqueDomainKey();
        if (!udk.isEmpty()) {
          List<Attribute> superUdk = null;
          if (getEntity().getSuperEntity() != null) {
            superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
          }
          if (superUdk == null || !udk.equals(superUdk)) {
            Set<Entity> components = getEntity().getAllComponents();
            StringBuilder attribs = new StringBuilder();
            for (Attribute attribute: udk) {
              if (attribs.length() != 0) {
                attribs.append(" ");
              }
              if (components.contains(attribute.getEntity())) {
                attribs.append(attribute.getEntity()).append(".");
              }
              attribs.append(attribute.getName());
            }
            out.print(source[283]); // 1264:2 = "  // selects by unique domain key  // ..."
            out.print(attribs);
            out.print(source[284]); // 1267:66 = ""
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
