// wurblet generated by Wurbelizer 11.3.1.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getters, setters and other methods for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; MethodsImpl [--noif] [--noudk] [--noisroot] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> there is no interface (don't generate @Override).</li>
 * <li><em>--noudk:</em> don't generate selectByUniqueDomainKey wurblet anchor.</li>
 * <li><em>--noisroot:</em> don't generate isRoot method.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class MethodsImpl extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException, ModelException {

    // main class
    String mainClass = getClassName();
    String pdoClass = null;
    boolean isPdo;
    try {
      pdoClass = getPdoClassName();
      isPdo = true;
    }
    catch (WurbelException we) {
      isPdo = false;
    }

    boolean noif = false;
    boolean generateSnapshot = false;
    boolean generateSelectByUDK = true;
    boolean generateIsRoot = true;
    boolean generateMock = false;

    int argcount = 0;
    for (String arg: getOptionArgs())  {
      if ("noif".equals(arg)) {
        noif = true;
      }
      else if ("noudk".equals(arg)) {
        generateSelectByUDK = false;
      }
      else if ("noisroot".equals(arg)) {
        generateIsRoot = false;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    boolean generateCreateNormText = false;
    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isPartOfNormText())  {
        generateCreateNormText = true;
        break;
      }
    }

    if (!generateMock) {
      if (isRemote()) {
        new RemoteIncludes(this);   // create RMI-files if they don't exist yet
        String delegateType = (isPdo() ? pdoClass : mainClass) + "RemoteDelegate";
        if (getEntity().isAbstract()) {
          delegateType += "<T,P>";
        }
        out.print(source[0]); // 69:2 = "  @Override  public "
        out.print(delegateType);
        out.print(source[1]); // 72:25 = " getRemoteDelegate() {    return ("
        out.print(delegateType);
        out.print(source[2]); // 73:28 = ") super.getRemoteDelegate();  }"
      }

      if (getEntity().isAbstract()) {
        if (getEntity().getInheritanceType() == InheritanceType.MULTI) {
          out.print(source[3]); // 80:2 = "  @Override  public boolean isExplicit..."
        }
      }
      else {
        if (getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
          out.print(source[4]); // 91:2 = "  @Override  public boolean isClassIdR..."
        }
      }

      boolean multiInheritance = getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI;

      boolean readOnly = getEntity().getOptions().isReadOnly();
      if (readOnly) {
        out.print(source[5]); // 105:2 = "  @Override  public boolean isImmutabl..."
      }

      if (getEntity().getSuperEntity() == null) {

        if (generateIsRoot && getEntity().getOptions().isRoot()) {
          out.print(source[6]); // 122:2 = "  @Override  public boolean isRootEnti..."
        }

        if (getEntity().getOptions().isTableSerialProvided()) {
          out.print(source[7]); // 132:2 = "  @Override  public boolean isTableSer..."
        }

        if (getEntity().getOptions().isTokenLockProvided()) {
          out.print(source[8]); // 142:2 = "  @Override  public boolean isTokenLoc..."
        }

        if (getEntity().getOptions().isNormTextProvided()) {
          out.print(source[9]); // 152:2 = "  @Override  public boolean isNormText..."
        }

        if (getEntity().getOptions().isRootIdProvided()) {
          out.print(source[10]); // 162:2 = "  @Override  public boolean isRootIdPr..."
        }
        else {
          Attribute rootAttribute = getEntity().getRootAttribute();
          if (rootAttribute != null) {

            out.print(source[11]); // 174:2 = "  @Override  public long getRootId() {..."
            out.print(rootAttribute.getName());
            out.print(source[12]); // 178:38 = ";  }"
          }
        }

        if (getEntity().getOptions().isRootClassIdProvided()) {
          out.print(source[13]); // 185:2 = "  @Override  public boolean isRootClas..."
        }
        else {
          Entity rootEntity = getEntity().getRootEntity();
          if (rootEntity != null) {
            out.print(source[14]); // 196:2 = "  @Override  public int getRootClassId..."
            out.print(rootEntity.getClassId());
            out.print(source[15]); // 200:38 = ";  }"
          }
        }

        if (isTracked())  {
          out.print(source[16]); // 207:2 = "  @Override  public boolean isTracked(..."
        }
      }

      if (isAttracked()) {
        out.print(source[17]); // 218:2 = "  @Override  public void setModified(b..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute())    {
            if (isFullTracked()) {
              out.print(source[18]); // 228:2 = "      "
              out.print(attr.getName());
              out.print(source[19]); // 229:24 = "Persisted = "
              out.print(attr.getName());
              out.print(source[20]); // 229:54 = ";"
            }
            else {
              out.print(source[21]); // 233:2 = "      "
              out.print(attr.getName());
              out.print(source[22]); // 234:24 = "Modified = false;"
            }
          }
        }
        out.print(source[23]); // 239:2 = "    }  }"
      }


      if (isFullTracked()) {
        out.print(source[24]); // 247:2 = "  @Override  public boolean differsPer..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isFromSuper() && !attr.getOptions().isMute() &&
              !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
            if (attr.getDataType().isPrimitive()) {
              out.print(source[25]); // 257:2 = "           || "
              out.print(attr.getName());
              out.print(source[26]); // 258:32 = "Persisted != "
              out.print(attr.getName());
              out.print(source[27]); // 258:63 = ""
            }
            else {
              out.print(source[28]); // 262:2 = "           || !Objects.equals("
              out.print(attr.getName());
              out.print(source[29]); // 263:48 = "Persisted, "
              out.print(attr.getName());
              out.print(source[30]); // 263:77 = ")"
            }
          }
        }
        out.print(source[31]); // 268:2 = "           ;  }  @Override  public b..."
      }

      if (!getEntity().getInheritanceType().isMappingToNoTable()) {
        String orderBy = getEntity().getSorting() != null ? createOrderBy(getDefaultSortKeys()) : null;
        if (orderBy != null) {
          out.print(source[32]); // 282:2 = "  @Override  public String orderBy() {..."
          out.print(orderBy);
          out.print(source[33]); // 287:18 = ";    return sql.toString();  }"
        }
        out.print(source[34]); // 292:2 = "  @Override  public void getFields(Res..."
        boolean needConfig = false;
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isMute())  {
            needConfig = true;
            break;
          }
        }
        if (needConfig) {
          out.print(source[35]); // 306:2 = "    if (rs.configureSection(CLASSVARIABL..."
          for (Attribute attr: getEntity().getMappedAttributes())  {
            if (!attr.getOptions().isMute())  {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                out.print(source[36]); // 312:2 = "      rs.configureColumn("
                out.print(getColumnNameConstant(attr, columnIndex));
                out.print(source[37]); // 313:69 = ");"
              }
            }
          }
          out.print(source[38]); // 318:2 = "    }"
        }
        else {
          out.print(source[39]); // 323:2 = "    rs.configureSection(CLASSVARIABLES);..."
        }
        out.print(source[40]); // 327:2 = "    if (rs.getRow() <= 0) {      throw ..."
        for (Attribute attr: getEntity().getMappedAttributes())  {
          if (!attr.getOptions().isMute())  {
            String name = attr.getName().toUpperCase();
            boolean useSetter = isAttributeDerived(attr);
            DataType<?> dataType = getEffectiveDataType(attr);
            if (dataType.isPredefined()) {
              String getterMethod = createJdbcGetterName(attr);
              if ("Binary".equals(attr.getDataType().getJavaType())) {
                // Binary getter takes additional buffer size argument
                int bufsize = attr.getSize() == null ? 0 : attr.getSize();
                if (useSetter)  {
                  out.print(source[41]); // 343:2 = "    "
                  out.print(attr.getSetterName());
                  out.print(source[42]); // 344:28 = "(rs."
                  out.print(getterMethod);
                  out.print(source[43]); // 344:48 = "("
                  out.print(bufsize);
                  out.print(source[44]); // 344:60 = "));"
                }
                else  {
                  out.print(source[45]); // 348:2 = "    "
                  out.print(attr.getName());
                  out.print(source[46]); // 349:22 = " = rs."
                  out.print(getterMethod);
                  out.print(source[47]); // 349:44 = "("
                  out.print(bufsize);
                  out.print(source[48]); // 349:56 = ");"
                }
              }
              else  {
                String rsGetter = "rs." + getterMethod + "(";
                boolean needComma = false;
                if (attr.getOptions().isWithTimezone()) {
                  rsGetter += "get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                  needComma = true;
                }
                if (attr.getOptions().isMapNull()) {
                  if (needComma) {
                    rsGetter += ", ";
                  }
                  rsGetter += "true";
                  needComma = true;
                }
                rsGetter += ")";

                String modelCode = getModelCode(attr, rsGetter);

                if (attr.getOptions().isTrimRead() && attr.getSize() != null) {
                  modelCode = "StringHelper.trim(" + modelCode + ", " + attr.getSize() + ")";
                }

                if (useSetter) {
                  modelCode = attr.getSetterName() + "(" + modelCode + ")";
                }
                else  {
                  modelCode = attr.getName() + " = " + modelCode;
                }
                out.print(source[49]); // 381:2 = "    "
                out.print(modelCode);
                out.print(source[50]); // 382:17 = ";"
                if (attr.getOptions().isUTC()) {
                  if (useSetter) {
                    modelCode = attr.getGetterName() + "()";
                  }
                  else  {
                    modelCode = attr.getName();
                  }
                  out.print(source[51]); // 391:2 = "    if ("
                  out.print(modelCode);
                  out.print(source[52]); // 392:21 = " != null) {      "
                  out.print(modelCode);
                  out.print(source[53]); // 393:19 = ".setUTC(true);    }"
                }
              }
            }
            else {    // application specific type
              String rsGetter = "rs.get(" + dataType.getDataTypeConstant() + ", " + attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
              String modelCode = getModelCode(attr, rsGetter);
              if (useSetter) {
                modelCode = attr.getSetterName() + "(" + modelCode + ")";
              }
              else  {
                modelCode = attr.getName() + " = " + modelCode;
              }
              out.print(source[54]); // 408:2 = "    "
              out.print(modelCode);
              out.print(source[55]); // 409:17 = ";"
            }
          }
        }
        out.print(source[56]); // 414:2 = "  }"
        if (!readOnly) {
          if (multiInheritance) {
            out.print(source[57]); // 419:2 = "  /**   * Sets the values of all "
            out.print(pdoClass);
            out.print(source[58]); // 422:40 = "-columns in the given statement.   *  ..."
            out.print(pdoClass);
            out.print(source[59]); // 427:34 = "(PreparedStatementWrapper st) {    int ..."
          }
          else  {
            out.print(source[60]); // 432:2 = "  @Override  public int setFields(Prep..."
          }

          for (Attribute attr: getEntity().getMappedAttributes()) {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly())  {
              boolean useGetter = isAttributeDerived(attr);
              DataType<?> dataType = getEffectiveDataType(attr);
              if (dataType.isPredefined()) {
                String setterName = createJdbcSetterName(dataType);

                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }

                String jdbcCode = getJdbcCode(attr, modelCode);

                if (attr.getOptions().isTrimWrite() && attr.getSize() != null) {
                  jdbcCode = "StringHelper.trim(" + jdbcCode + ", " + attr.getSize() + ")";
                }

                jdbcCode = "st." + setterName + "(++ndx, " + jdbcCode;
                if (attr.getOptions().isWithTimezone()) {
                  jdbcCode += ", get" + attr.getMethodNameSuffix() + "TimezoneConfig()";
                }
                if (attr.getOptions().isMapNull()) {
                  jdbcCode += ", true)";
                }
                else  {
                  jdbcCode += ")";
                }
                out.print(source[61]); // 471:2 = "    "
                out.print(jdbcCode);
                out.print(source[62]); // 472:16 = ";"

                // for multi column types, such as BMoney or application specific types
                int diff = getEffectiveDataType(attr).getColumnCount() - 1;
                if (diff == 1) {
                  out.print(source[63]); // 478:2 = "    ndx++;"
                }
                else if (diff > 1) {
                  out.print(source[64]); // 483:2 = "    ndx += "
                  out.print(diff);
                  out.print(source[65]); // 484:19 = ";"
                }
              }
              else {    // application specific type
                String modelCode;
                if (useGetter) {
                  modelCode = attr.getGetterName() + "()";
                }
                else {
                  modelCode = attr.getName();
                }
                String jdbcCode = "ndx += st.set(" + dataType.getDataTypeConstant() + ", ndx + 1, " +
                                  getJdbcCode(attr, modelCode) + ", " +
                                  attr.getOptions().isMapNull() + ", " + attr.getSize() + ")";
                                  out.print(source[66]); // 499:2 = "    "
                                  out.print(jdbcCode);
                                  out.print(source[67]); // 500:16 = ";"
              }
            }
          }

          if (multiInheritance && getEntity().getSuperEntity() != null) {
            out.print(source[68]); // 507:2 = "    st.setLong(++ndx, getId());"
          }
          out.print(source[69]); // 511:2 = "    return ndx;  }"
        }
      }

      if (getEntity().getInheritanceType().isMappingToOwnTable()) {

        List<Attribute> attributes = multiInheritance ?
                                        getEntity().getTableAttributes() : getEntity().getAttributesIncludingInherited();
        List<String> names = new ArrayList<>();   // column name constants CN_...

        if (!readOnly) {
          for (Attribute attr: attributes)  {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly()) {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                names.add(getColumnNameConstant(attr, columnIndex));
              }
            }
          }

          if (multiInheritance) {
            out.print(source[70]); // 534:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[71]); // 537:46 = " insert statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[72]); // 541:43 = "() {"
          }
          else  {
            out.print(source[73]); // 545:2 = "  @Override  public String createInser..."
          }
          out.print(source[74]); // 551:2 = "    return Backend.SQL_INSERT_INTO + "
          out.print(multiInheritance ? "CLASSVARIABLES." : "");
          out.print(source[75]); // 552:82 = "getTableName() + Backend.SQL_LEFT_PARENT..."

          int count = 0;
          for (String name: names) {
            String lineSep = count == names.size() - 1 ? " +" : " + Backend.SQL_COMMA +";
            out.print(source[76]); // 558:2 = "           "
            out.print(name);
            out.print(lineSep);
            out.print(source[77]); // 559:30 = ""
            count++;
          }
          out.print(source[78]); // 563:2 = "           Backend.SQL_INSERT_VALUES +"
          while (--count > 0)	{
            out.print(source[79]); // 567:2 = "           Backend.SQL_PAR_COMMA +"
          }
          out.print(source[80]); // 571:2 = "           Backend.SQL_PAR + Backend.SQL..."

          names.clear();
          for (Attribute attr: attributes)  {
            if (!attr.getOptions().isMute() && !attr.getOptions().isReadOnly() && !isIdOrSerialAttribute(attr)) {
              for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
                names.add(getColumnNameConstant(attr, columnIndex));
              }
            }
          }

          if (multiInheritance) {
            out.print(source[81]); // 586:2 = "  /**   * Creates the SQL code for the..."
            out.print(pdoClass);
            out.print(source[82]); // 589:46 = " update statement.   *   * @return the..."
            out.print(pdoClass);
            out.print(source[83]); // 593:43 = "() {"
          }
          else  {
            out.print(source[84]); // 597:2 = "  @Override  public String createUpdat..."
          }
          out.print(source[85]); // 603:2 = "    return Backend.SQL_UPDATE + "
          out.print(multiInheritance ? "CLASSVARIABLES." : "");
          out.print(source[86]); // 604:77 = "getTableName() + Backend.SQL_SET +"
          boolean checkSerial = !multiInheritance || getEntity().getSuperEntity() == null;
          int ncnt = 0;
          for (String name: names) {
            ncnt++;
            if (!checkSerial && ncnt == names.size()) {
              out.print(source[87]); // 611:2 = "           "
              out.print(name);
              out.print(source[88]); // 612:19 = " + Backend.SQL_EQUAL_PAR +"
            }
            else {
              out.print(source[89]); // 616:2 = "           "
              out.print(name);
              out.print(source[90]); // 617:19 = " + Backend.SQL_EQUAL_PAR_COMMA +"
            }
          }

          if (ncnt == 0 && !checkSerial) {
            // special case: no attributes and no checkserial
            out.print(source[91]); // 624:2 = "           CN_ID + Backend.SQL_EQUAL + C..."
          }

          if (checkSerial) {
            out.print(source[92]); // 630:2 = "           CN_SERIAL + Backend.SQL_EQUAL..."
          }
          else  {
            out.print(source[93]); // 637:2 = "           Backend.SQL_WHERE + CN_ID + B..."
          }
          out.print(source[94]); // 641:2 = "  }"
        }
      }

      if (multiInheritance) {
        // create joinable sql selects with table aliases
        Entity topEntity = getEntity().getTopSuperEntity();
        List<Entity> chain = topEntity.getInheritanceChain(getEntity());
        List<Entity> subs = orderByInheritanceLevelAndClassId(getEntity().getAllSubEntities());
        String topImplClass = deriveClassNameForEntity(topEntity);

        if (!readOnly) {
          out.print(source[95]); // 655:2 = "  /**   * Creates the SQL code for the..."
          out.print(pdoClass);
          out.print(source[96]); // 658:46 = " delete statement.   *   * @return the..."
          out.print(pdoClass);
          out.print(source[97]); // 662:43 = "() {"
          if (getEntity().isRootOfInheritanceHierarchy()) {
            out.print(source[98]); // 665:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          else  {
            out.print(source[99]); // 672:2 = "    return Backend.SQL_DELETE + Backend...."
          }
          out.print(source[100]); // 677:2 = "  }"
        }
        out.print(source[101]); // 681:2 = "  @Override  public StringBuilder crea..."
        boolean needComma = false;
        for (Entity entity: chain) {
          String implClass = deriveClassNameForEntity(entity);
          out.print(source[102]); // 690:2 = "    sql."
          out.print(needComma ? "append(Backend.SQL_COMMA)." : "");
          out.print(source[103]); // 691:57 = "append("
          out.print(implClass);
          out.print(source[104]); // 691:77 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
        needComma = true;
        if (entity == topEntity) {
          for (Entity sub: subs) {
            implClass = deriveClassNameForEntity(sub);
            out.print(source[105]); // 697:2 = "    sql.append(Backend.SQL_COMMA).append..."
            out.print(implClass);
            out.print(source[106]); // 698:54 = ".CLASSVARIABLES.getColumnName(Backend.SQ..."
            }
          }
        }
        out.print(source[107]); // 703:2 = "    sql.append(Backend.SQL_FROM);    sq..."
        out.print(topImplClass);
        out.print(source[108]); // 705:31 = ".CLASSVARIABLES.getTableName()).       ..."
        out.print(topImplClass);
        out.print(source[109]); // 706:76 = ".CLASSVARIABLES.getTableAlias());"
      if (chain.size() > 1) {
        for (Entity entity: chain.subList(1, chain.size())) {
          String implClass = deriveClassNameForEntity(entity);
          out.print(source[110]); // 711:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[111]); // 713:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[112]); // 713:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[113]); // 714:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[114]); // 715:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
          }
        }

        for (Entity sub: subs) {
          String implClass = deriveClassNameForEntity(sub);
          out.print(source[115]); // 722:2 = "    sql.append(getBackend().sqlJoin(Join..."
          out.print(implClass);
          out.print(source[116]); // 724:28 = ".CLASSVARIABLES.getTableName(), "
          out.print(implClass);
          out.print(source[117]); // 724:73 = ".CLASSVARIABLES.getTableAlias(),       ..."
          out.print(topImplClass);
          out.print(source[118]); // 725:31 = ".CLASSVARIABLES.getColumnName(CN_ID) + B..."
          out.print(implClass);
          out.print(source[119]); // 726:28 = ".CLASSVARIABLES.getColumnName(CN_ID)));..."
        }
        out.print(source[120]); // 729:2 = "    sql.append(Backend.SQL_WHEREALL);  ..."
        String implClass = deriveClassNameForEntity(topEntity);
        out.print(source[121]); // 735:2 = "  @Override  public StringBuilder crea..."
        out.print(implClass);
        out.print(source[122]); // 741:28 = ".CLASSVARIABLES.getColumnName(CN_ID)). ..."

        if (getEntity().isRootOfInheritanceHierarchy()) {
          out.print(source[123]); // 748:2 = "  @Override  protected void updateImpl..."
          out.print(pdoClass);
          out.print(source[124]); // 752:122 = ");    setFields"
          out.print(pdoClass);
          out.print(source[125]); // 753:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[126]); // 759:122 = ");    setFields"
          out.print(pdoClass);
          out.print(source[127]); // 760:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(pdoClass);
          out.print(source[128]); // 766:122 = ");    st.setLong(1, getId());    st.se..."
        }
        else  {
          out.print(source[129]); // 774:2 = "  @Override  protected void updateImpl..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[130]); // 777:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[131]); // 780:122 = ");    setFields"
          out.print(pdoClass);
          out.print(source[132]); // 781:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[133]); // 786:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[134]); // 789:122 = ");    setFields"
          out.print(pdoClass);
          out.print(source[135]); // 790:25 = "(st);    assertThisRowAffected(st.execu..."
          out.print(getEntity().isAbstract()?"P":mainClass);
          out.print(source[136]); // 795:93 = "> classVariables,                      ..."
          out.print(pdoClass);
          out.print(source[137]); // 797:122 = ");    st.setLong(1, getId());    asser..."
        }
      }
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (attr.getOptions().isMute()) {
        continue;   // skip
      }
      if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr)) {
        generateSnapshot = true;
      }
      if (attr.getOptions().isNoMethod()) {
        if (!attr.getOptions().isFromSuper()) {
          out.print(source[138]); // 816:2 = "  /*   * no accessor methods for "
          out.print(attr);
          out.print(source[139]); // 819:37 = ".   * "
          out.print(attr.getOptions().getComment());
          out.print(source[140]); // 820:39 = "   */"
        }
      }
      else {
        String protection = attr.getOptions().getAccessScope().toString();
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[141]); // 832:2 = "  // "
          out.print(attr);
          out.print(source[142]); // 834:13 = " is writeonly, no getter."
        }
        else  {
          if (noif || attr.isHidden()) {
            out.print(source[143]); // 839:2 = "  /**   * Gets the attribute "
            out.print(attr.getName());
            out.print(source[144]); // 842:42 = ".   *   * @return "
            out.print(attr.getOptions().getComment());
            out.print(source[145]); // 844:48 = "   */"
          }
          else {
            out.print(source[146]); // 849:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[147]); // 857:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[148]); // 858:26 = ""
            }
          }
          out.print(source[149]); // 862:2 = "  "
          out.print(protection);
          out.print(source[150]); // 863:16 = " "
          out.print(type);
          out.print(source[151]); // 863:25 = " "
          out.print(getter);
          out.print(source[152]); // 863:36 = "()    {    return "
          out.print(attr.getName());
          out.print(source[153]); // 864:29 = ";  }"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[154]); // 870:2 = "  // "
          out.print(attr);
          out.print(source[155]); // 872:13 = " is readonly, no setter."
        }
        else {
          String setterProtection = protection;
          boolean useOverride = !noif && "public".equals(protection) && !attr.isHidden();
          // check to make setter for lazy or eager object relations private
          Relation rel = attr.getRelation();
          if (rel != null && rel.getSelectionType() != SelectionType.ALWAYS) {
            setterProtection = getEntity().isAbstract() ? "protected" : "private";
            useOverride = false;
          }
          if (!useOverride) {
            out.print(source[156]); // 885:2 = "  /**   * Sets the attribute "
            out.print(attr.getName());
            out.print(source[157]); // 888:42 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[158]); // 890:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[159]); // 890:66 = "   */"
          }
          else {
            out.print(source[160]); // 895:2 = "  @Override"
          }
          for (String annotation: attr.getOptions().getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
              out.print(source[161]); // 903:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[162]); // 904:26 = ""
            }
          }
          out.print(source[163]); // 908:2 = "  "
          out.print(setterProtection);
          out.print(source[164]); // 909:22 = " void "
          out.print(setter);
          out.print(source[165]); // 909:38 = "("
          out.print(type);
          out.print(source[166]); // 909:47 = " "
          out.print(attr.getName());
          out.print(source[167]); // 909:66 = ") {"
          if (!generateMock) {
            out.print(source[168]); // 912:2 = "    assertMutable();"
            if (isTracked())  {
              if (isFullTracked()) {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[169]); // 918:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[170]); // 919:31 = " != "
                  out.print(attr.getName());
                  out.print(source[171]); // 919:53 = ") {      firePropertyChange(AN_"
                  out.print(attr.getName().toUpperCase());
                  out.print(source[172]); // 920:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[173]); // 920:85 = ", "
                  out.print(attr.getName());
                  out.print(source[174]); // 920:105 = ");    }"
                }
                else {
                  out.print(source[175]); // 925:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[176]); // 926:47 = ", "
                  out.print(attr.getName());
                  out.print(source[177]); // 926:67 = ")) {      firePropertyChange(AN_"
                  out.print(attr.getName().toUpperCase());
                  out.print(source[178]); // 927:60 = ", this."
                  out.print(attr.getName());
                  out.print(source[179]); // 927:85 = ", "
                  out.print(attr.getName());
                  out.print(source[180]); // 927:105 = ");    }"
                }
              }
              else {
                if (attr.getDataType().isPrimitive()) {
                  out.print(source[181]); // 934:2 = "    if (this."
                  out.print(attr.getName());
                  out.print(source[182]); // 935:31 = " != "
                  out.print(attr.getName());
                  out.print(source[183]); // 935:53 = ") {      setModified(true);"
                  if (isAttracked()) {
                    out.print(source[184]); // 939:2 = "      "
                    out.print(attr.getName());
                    out.print(source[185]); // 940:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase());
                    out.print(source[186]); // 941:60 = ", this."
                    out.print(attr.getName());
                    out.print(source[187]); // 941:85 = ", "
                    out.print(attr.getName());
                    out.print(source[188]); // 941:105 = ");"
                  }
                  out.print(source[189]); // 944:2 = "    }"
                }
                else  {
                  out.print(source[190]); // 949:2 = "    if (!Objects.equals(this."
                  out.print(attr.getName());
                  out.print(source[191]); // 950:47 = ", "
                  out.print(attr.getName());
                  out.print(source[192]); // 950:67 = ")) {      setModified(true);"
                  if (isAttracked()) {
                    out.print(source[193]); // 954:2 = "      "
                    out.print(attr.getName());
                    out.print(source[194]); // 955:24 = "Modified = true;      firePropertyChang..."
                    out.print(attr.getName().toUpperCase());
                    out.print(source[195]); // 956:60 = ", this."
                    out.print(attr.getName());
                    out.print(source[196]); // 956:85 = ", "
                    out.print(attr.getName());
                    out.print(source[197]); // 956:105 = ");"
                  }
                  out.print(source[198]); // 959:2 = "    }"
                }
              }
            }
          }
          out.print(source[199]); // 966:2 = "    this."
          out.print(attr.getName());
          out.print(source[200]); // 967:27 = " = "
          out.print(attr.getName());
          out.print(source[201]); // 967:48 = ";"
          if (type.equals("Timestamp")) {
            out.print(source[202]); // 970:2 = "    Timestamp.setUTC("
            out.print(attr.getName());
            out.print(source[203]); // 971:39 = ", "
            out.print(attr.getOptions().isUTC() ? "true" : "false");
            out.print(source[204]); // 971:89 = ");"
          }
          if (attr.getDataType().isMutable()) {
            out.print(source[205]); // 975:2 = "    Freezable.freeze("
            out.print(attr.getName());
            out.print(source[206]); // 976:39 = ");"
          }
          out.print(source[207]); // 979:2 = "  }"
          if (isAttracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[208]); // 984:2 = "  /**   * Gets the modification state ..."
              out.print(attr.getName());
              out.print(source[209]); // 987:54 = ".   *   * @return true if "
              out.print(attr);
              out.print(source[210]); // 989:30 = " has been modified   */"
            }
            else {
              out.print(source[211]); // 994:2 = "  @Override"
            }
            out.print(source[212]); // 999:2 = "  "
            out.print(protection);
            out.print(source[213]); // 1000:16 = " boolean is"
            out.print(methodSuffix);
            out.print(source[214]); // 1000:43 = "Modified() {"
            if (isFullTracked()) {
              if (attr.getDataType().isPrimitive()) {
                out.print(source[215]); // 1004:2 = "    return "
                out.print(attr.getName());
                out.print(source[216]); // 1005:29 = " != "
                out.print(attr.getName());
                out.print(source[217]); // 1005:51 = "Persisted;"
              }
              else {
                out.print(source[218]); // 1009:2 = "    return !Objects.equals("
                out.print(attr.getName());
                out.print(source[219]); // 1010:45 = ", "
                out.print(attr.getName());
                out.print(source[220]); // 1010:65 = "Persisted);"
              }
            }
            else {
              out.print(source[221]); // 1015:2 = "    return "
              out.print(attr.getName());
              out.print(source[222]); // 1016:29 = "Modified;"
            }
            out.print(source[223]); // 1019:2 = "  }"
          }

          if (isFullTracked()) {
            if (noif || attr.isHidden()) {
              out.print(source[224]); // 1026:2 = "  /**   * Gets the last persisted valu..."
              out.print(attr);
              out.print(source[225]); // 1029:46 = ".   *   * @return the last persisted v..."
            }
            else {
              out.print(source[226]); // 1036:2 = "  @Override"
            }
            out.print(source[227]); // 1041:2 = "  "
            out.print(protection);
            out.print(source[228]); // 1042:16 = " "
            out.print(attr.getJavaType());
            out.print(source[229]); // 1042:39 = " "
            out.print(getter);
            out.print(source[230]); // 1042:50 = "Persisted() {    return "
            out.print(attr.getName());
            out.print(source[231]); // 1043:29 = "Persisted;  }"
          }
        }
      }
    }

    if (!generateMock) {
      if (isPdo && generateSnapshot) {

        // createAttributesInSnapshot isnt necessary anymore since 2.2.x

        boolean needRevertAttributes = false;
        for (Attribute attr: getEntity().getAttributes())  {
          if (!attr.getOptions().isMute() && !isAttributeDerived(attr) && !attr.getOptions().isShallow()) {
            needRevertAttributes = true;
            break;
          }
        }

        if (needRevertAttributes) {
          out.print(source[232]); // 1065:2 = "  /**   * Copies all attributes from a..."
          out.print(mainClass);
          out.print(getEntity().isAbstract() ? "<T,?>" : "");
          out.print(source[233]); // 1072:100 = " snapshot) {    super.revertAttributesT..."
          for (Attribute attr: getEntity().getAttributes()) {
            if (!attr.getOptions().isNoDeclare() && !isAttributeDerived(attr) && !attr.getOptions().isShallow() && !attr.getOptions().isMute())    {
              String name = attr.getName();
              out.print(source[234]); // 1078:2 = "    "
              out.print(name);
              out.print(source[235]); // 1079:12 = " = snapshot."
              out.print(name);
              out.print(source[236]); // 1079:32 = ";"
              if (isAttracked()) {
                if (isFullTracked()) {
                  out.print(source[237]); // 1083:2 = "    "
                  out.print(name);
                  out.print(source[238]); // 1084:12 = "Persisted = snapshot."
                  out.print(name);
                  out.print(source[239]); // 1084:41 = "Persisted;"
                }
                else {
                  out.print(source[240]); // 1088:2 = "    "
                  out.print(name);
                  out.print(source[241]); // 1089:12 = "Modified = snapshot."
                  out.print(name);
                  out.print(source[242]); // 1089:40 = "Modified;"
                }
              }
            }
          }
          out.print(source[243]); // 1095:2 = "  }"
        }
      }

      if (generateCreateNormText) {
        out.print(source[244]); // 1102:2 = "  @Override  public StringBuilder crea..."
        for (Attribute attr: getEntity().getAttributes())  {
          if (attr.getOptions().isPartOfNormText())  {
            out.print(source[245]); // 1113:2 = "    buf.append("
            out.print(attr.getGetterName());
            out.print(source[246]); // 1114:39 = "()).append(',');"
          }
        }
        out.print(source[247]); // 1118:2 = "    return buf;  }"
      }

      if (generateSelectByUDK) {
        List<Attribute> udk = getEntity().getUniqueDomainKey();
        if (!udk.isEmpty()) {
          List<Attribute> superUdk = null;
          if (getEntity().getSuperEntity() != null) {
            superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
          }
          if (superUdk == null || !udk.equals(superUdk)) {
            Set<Entity> components = getEntity().getAllComponents();
            StringBuilder attribs = new StringBuilder();
            for (Attribute attribute: udk) {
              if (attribs.length() != 0) {
                attribs.append(" ");
              }
              if (components.contains(attribute.getEntity())) {
                attribs.append(attribute.getEntity()).append(".");
              }
              attribs.append(attribute.getName());
            }
            out.print(source[248]); // 1143:2 = "  // selects by unique domain key  // ..."
            out.print(attribs);
            out.print(source[249]); // 1146:66 = ""
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
