// wurblet generated by Wurbelizer 11.3.1.0, see https://wurbelizer.org

package org.tentackle.persist.wurblet;

import org.tentackle.wurblet.*;
import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.sql.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to declare the attributes of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Declare [--protected] [--annotations] [--mock]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--protected:</em> makes the fields protected (default is private).</li>
 * <li><em>--annotations:</em> to generate annotations. Default is no generation as they will be generated for the methods.</li>
 * <li><em>--mock:</em> generate code for mock object.</li>
 * </ul>
 * For more options, see {@link DbModelWurblet}.
 */
public class Declare extends DbModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {

    String[] args = getContainer().getArgs();   // cmd line args

    String protection = "private";
    boolean generateAnnotations = false;
    boolean generateMock = false;

    for (String arg: getOptionArgs())  {
      if (arg.equals("protected")) {
        protection = "protected";
      }
      else if (arg.equals("annotations")) {
        generateAnnotations = true;
      }
      else if ("mock".equals(arg)) {
        generateMock = true;
      }
    }

    Map<DataType<?>, String> nonPredefinedDataTypes = new HashMap<>();    // types : attributes

    for (Attribute attr: getEntity().getAttributes()) {
      if (!attr.getOptions().isNoDeclare() && !attr.getOptions().isMute()) {
        out.print(source[0]); // 41:2 = "  /** "
        out.print(attr.getOptions().getComment());
        out.print(source[1]); // 43:40 = ". */"
        DataType<?> dataType = getEffectiveDataType(attr);
        if (!dataType.isPredefined()) {
          String attribNames = nonPredefinedDataTypes.get(dataType);
          if (attribNames == null) {
            attribNames = attr.getName();
          }
          else {
            attribNames += ", " + attr.getName();
          }
          nonPredefinedDataTypes.put(dataType, attribNames);
        }

        if (generateAnnotations) {
          for (String annotation: attr.getOptions().getAnnotations()) {
            out.print(source[2]); // 59:2 = "  "
            out.print(annotation);
            out.print(source[3]); // 60:16 = ""
          }
        }

        if (attr.getOptions().getInitialValue() != null) {
          out.print(source[4]); // 66:2 = "  "
          out.print(protection);
          out.print(source[5]); // 67:16 = " "
          out.print(attr.getJavaType());
          out.print(source[6]); // 67:39 = " "
          out.print(attr.getName());
          out.print(source[7]); // 67:58 = " = "
          out.print(attr.getOptions().getInitialValue());
          out.print(source[8]); // 67:100 = ";"

        }
        else {
          out.print(source[9]); // 72:2 = "  "
          out.print(protection);
          out.print(source[10]); // 73:16 = " "
          out.print(attr.getJavaType());
          out.print(source[11]); // 73:39 = " "
          out.print(attr.getName());
          out.print(source[12]); // 73:58 = ";"
        }
        if (!generateMock && isAttracked()) {
          if (isFullTracked()) {
            out.print(source[13]); // 78:2 = "  /** the last persisted value of "
            out.print(attr);
            out.print(source[14]); // 79:42 = ". */  "
            out.print(protection);
            out.print(source[15]); // 80:16 = " "
            out.print(attr.getJavaType());
            out.print(source[16]); // 80:39 = " "
            out.print(attr.getName());
            out.print(source[17]); // 80:58 = "Persisted;"
          }
          else {
            out.print(source[18]); // 84:2 = "  /** true if "
            out.print(attr);
            out.print(source[19]); // 85:22 = " has been modified. */  "
            out.print(protection);
            out.print(source[20]); // 86:16 = " boolean "
            out.print(attr.getName());
            out.print(source[21]); // 86:43 = "Modified;"
          }
        }
      }
    }

    for (Map.Entry<DataType<?>, String> entry : nonPredefinedDataTypes.entrySet()) {
      DataType<?> dataType = entry.getKey();
      String attribNames = entry.getValue();
      out.print(source[22]); // 96:2 = "  /** application specific datatype for..."
      out.print(attribNames);
      out.print(source[23]); // 98:55 = ". */  public static final DataType<"
      out.print(dataType.getJavaType());
      out.print(source[24]); // 99:57 = "> "
      out.print(dataType.getDataTypeConstant());
      out.print(source[25]); // 99:93 = " = DataTypeFactory.getInstance().get("
      out.print(dataType.getJavaType());
      out.print(source[26]); // 99:156 = ".class);"
    }

  }

  // ----------------- end wurblet code -----------------
}
