/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.tentackle.common.FileHelper;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.common.ToolRunner;
import org.tentackle.maven.JavaToolFinder;
import org.tentackle.maven.plugin.jlink.AbstractJLinkMojo;
import org.tentackle.maven.plugin.jlink.ArtifactCreator;
import org.tentackle.maven.plugin.jlink.JLinkResolver;
import org.tentackle.maven.plugin.jlink.JPackageGenerator;
import org.tentackle.maven.plugin.jlink.ModularArtifact;

@Mojo(name="jpackage", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class JPackageMojo
extends AbstractJLinkMojo {
    public static final String PACKAGE_IMAGE_TEMPLATE = "package-image.ftl";
    public static final String PACKAGE_INSTALLER_TEMPLATE = "package-installer.ftl";
    public static final String PACKAGE_UPDATE_TEMPLATE = "package-update.ftl";
    public static final String OPTIONS_IMAGE = "jpackage-image.options";
    public static final String OPTIONS_INSTALLER = "jpackage-installer.options";
    private static final String CONFIG_EXTENSION = ".cfg";
    private static final String MAC_APPNAME_EXTENSION = ".app";
    private static final String APP_CLASSPATH = "app.classpath=";
    private static final String APP_MAINJAR = "app.mainjar=";
    private static final String JAVA_OPTIONS = "[JavaOptions]";
    private static final String MODS_DIR = "mods";
    private static final String APPDIR_MODS = "java-options=$APPDIR/mods";
    private static final String APPDIR_MODS_WINDOWS = "java-options=$APPDIR\\mods";
    @Parameter(property="jpackageTool")
    private File jpackageTool;
    @Parameter
    private Map<String, String> jpackageToolchain;
    @Parameter(defaultValue="package-image.ftl")
    private String packageImageTemplate;
    @Parameter(defaultValue="package-installer.ftl")
    private String packageInstallerTemplate;
    @Parameter(defaultValue="package-update.ftl")
    private String packageUpdateTemplate;
    @Parameter(defaultValue="${project.build.directory}/jpackage")
    private File packageDirectory;
    @Parameter
    private String mainJar;
    private int jpackageMajorRuntimeVersion;
    private String imagePathPrefix;

    @Override
    public String getImagePathPrefix() {
        if (this.imagePathPrefix == null) {
            String platform = StringHelper.getPlatform();
            this.imagePathPrefix = platform.contains("win") ? "$ROOTDIR/runtime" : (platform.contains("mac") ? "$ROOTDIR/runtime/Contents/Home" : (this.jpackageMajorRuntimeVersion >= 15 ? "$APPDIR/../runtime" : "$ROOTDIR/lib/runtime"));
        }
        return this.imagePathPrefix;
    }

    public String getPackageImageTemplate() {
        return this.packageImageTemplate;
    }

    public String getPackageInstallerTemplate() {
        return this.packageInstallerTemplate;
    }

    public String getPackageUpdateTemplate() {
        return this.isWithUpdater() ? this.packageUpdateTemplate : null;
    }

    public File getPackageDirectory() {
        return this.packageDirectory;
    }

    @Override
    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
        super.prepareExecute();
        if (this.jpackageTool == null) {
            JavaToolFinder toolFinder;
            if (this.jpackageToolchain == null) {
                toolFinder = this.getToolFinder();
            } else if (this.jpackageToolchain.isEmpty()) {
                toolFinder = new JavaToolFinder();
            } else {
                Toolchain toolchain = this.getToolchain("jdk", this.jpackageToolchain);
                if (toolchain == null) {
                    throw new MojoExecutionException("no matching toolchain for the jpackage tool: " + String.valueOf(this.jpackageToolchain));
                }
                toolFinder = new JavaToolFinder(toolchain);
            }
            this.jpackageTool = toolFinder.find("jpackage");
        }
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        super.executeImpl();
        ArtifactCreator.getInstance().attachInstallers(this, startTime);
    }

    @Override
    protected void createImage(JLinkResolver.Result result) throws MojoFailureException, MojoExecutionException {
        if (this.getImageDirectory().exists()) {
            this.getLog().info((CharSequence)("using already existing jlink image in " + this.getImageDirectory().getPath()));
            this.copyResources(result);
        } else {
            super.createImage(result);
        }
    }

    @Override
    protected void generateFiles(JLinkResolver.Result result) throws MojoExecutionException {
        char c;
        String[] names;
        JPackageGenerator generator = new JPackageGenerator(this, result);
        generator.generateOptions();
        String mainJarName = null;
        File cpDir = null;
        ToolRunner jpackageRunner = new ToolRunner(this.jpackageTool);
        jpackageRunner.arg(new Object[]{"--type"}).arg(new Object[]{"app-image"}).arg(new Object[]{"-d"}).arg(new Object[]{this.packageDirectory}).arg(new Object[]{"--runtime-image"}).arg(new Object[]{this.getImageDirectory()});
        if (result.isModular()) {
            ModularArtifact mainArtifact = result.getModuleArtifact(this.getMainModule());
            if (mainArtifact == null) {
                throw new MojoExecutionException("no such main module: " + this.getMainModule());
            }
            if (result.isModulePathRequired() && this.jpackageMajorRuntimeVersion >= 15) {
                jpackageRunner.arg(new Object[]{"-p"}).arg(new Object[]{String.valueOf(this.getImageDirectory()) + "/mp"});
            }
            jpackageRunner.arg(new Object[]{"-m"}).arg(new Object[]{this.getMainModule() + "/" + this.getMainClass()});
        } else {
            mainJarName = StringHelper.isAllWhitespace((String)this.mainJar) ? this.determineMainJar(result) : this.mainJar;
            cpDir = new File(this.getImageDirectory(), "cp");
            jpackageRunner.arg(new Object[]{"--main-jar"}).arg(new Object[]{mainJarName}).arg(new Object[]{"--main-class"}).arg(new Object[]{this.getMainClass()}).arg(new Object[]{"--input"}).arg(new Object[]{cpDir});
        }
        jpackageRunner.arg(new Object[]{"--java-options"}).arg(new Object[]{"-DROOTDIR=$ROOTDIR"}).arg(new Object[]{"--java-options"}).arg(new Object[]{"-DAPPDIR=$APPDIR"}).arg(new Object[]{"--java-options"}).arg(new Object[]{"-DRUNTIMEDIR=" + this.getImagePathPrefix()}).arg(new Object[]{"@" + this.getMavenProject().getBuild().getDirectory() + File.separator + OPTIONS_IMAGE});
        if (this.verbosityLevel.isDebug()) {
            jpackageRunner.arg(new Object[]{"--verbose"});
        }
        this.getLog().debug((CharSequence)jpackageRunner.toString());
        this.getLog().info((CharSequence)"creating application image");
        int errCode = jpackageRunner.run().getErrCode();
        if (errCode != 0) {
            throw new MojoExecutionException("creating application image with jpackage failed: " + errCode + "\n" + jpackageRunner.getErrorsAsString() + "\n" + jpackageRunner.getOutputAsString());
        }
        this.logToolOutput(jpackageRunner);
        String[] imageDirNames = this.getPackageDirectory().list();
        if (imageDirNames == null || imageDirNames.length != 1) {
            throw new MojoExecutionException("cannot locate application image directory in " + this.getPackageDirectory().getPath());
        }
        String applicationName = imageDirNames[0];
        File appImageDir = new File(this.getPackageDirectory(), applicationName);
        this.getLog().debug((CharSequence)("application image found in " + appImageDir.getPath()));
        ArtifactCreator.getInstance().processApplicationImage(this, appImageDir);
        File configDir = this.locateAppDirectory(appImageDir);
        if (cpDir != null && (names = cpDir.list()) != null) {
            for (String name : names) {
                new File(configDir, name).delete();
            }
        }
        if (configDir != null && (result.isClassPathRequired() || result.isModulePathRequired())) {
            File modsDir;
            List<File> configFiles = this.loadConfigFiles(configDir);
            if (configFiles.isEmpty()) {
                throw new MojoExecutionException("no application configuration files found");
            }
            for (File configFile : configFiles) {
                this.patchConfigFile(configFile, result, mainJarName);
            }
            if (this.jpackageMajorRuntimeVersion >= 15 && (modsDir = new File(configDir, MODS_DIR)).isDirectory()) {
                try {
                    this.getLog().debug((CharSequence)("removing " + String.valueOf(modsDir)));
                    FileHelper.removeDirectory((String)modsDir.getPath());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("cannot remove obsolete module directory " + String.valueOf(modsDir));
                }
            }
        }
        jpackageRunner = new ToolRunner(this.jpackageTool);
        if (applicationName.endsWith(MAC_APPNAME_EXTENSION)) {
            applicationName = applicationName.substring(0, applicationName.length() - MAC_APPNAME_EXTENSION.length());
        }
        jpackageRunner.arg(new Object[]{"-n"}).arg(new Object[]{applicationName}).arg(new Object[]{"--app-image"}).arg(new Object[]{appImageDir});
        StringBuilder appVersion = new StringBuilder();
        String projectVersion = this.getMavenProject().getVersion();
        for (int i = 0; i < projectVersion.length() && ((c = projectVersion.charAt(i)) == '.' || Character.isDigit(c)); ++i) {
            appVersion.append(c);
        }
        if (!appVersion.isEmpty()) {
            jpackageRunner.arg(new Object[]{"--app-version"}).arg(new Object[]{appVersion});
        }
        jpackageRunner.arg(new Object[]{"-d"}).arg(new Object[]{this.getMavenProject().getBuild().getDirectory()}).arg(new Object[]{"@" + this.getMavenProject().getBuild().getDirectory() + File.separator + OPTIONS_INSTALLER});
        if (this.verbosityLevel.isDebug()) {
            jpackageRunner.arg(new Object[]{"--verbose"});
        }
        this.getLog().debug((CharSequence)jpackageRunner.toString());
        this.getLog().info((CharSequence)"creating installer");
        errCode = jpackageRunner.run().getErrCode();
        if (errCode != 0) {
            throw new MojoExecutionException("creating installer with jpackage failed: " + errCode + "\n" + jpackageRunner.getErrorsAsString() + "\n" + jpackageRunner.getOutputAsString());
        }
        this.logToolOutput(jpackageRunner);
        if (this.isWithUpdater()) {
            this.getLog().info((CharSequence)"creating updater");
            generator.generateUpdateScript(appImageDir);
            ArtifactCreator.getInstance().createAndAttachArtifact(this, appImageDir);
        }
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.jpackageTool == null) {
                throw new MojoExecutionException("jpackageTool tool not found");
            }
            this.getLog().debug((CharSequence)("using " + String.valueOf(this.jpackageTool)));
            this.jpackageMajorRuntimeVersion = this.getMajorVersion(this.determineJavaToolVersion(this.jpackageTool));
            this.getLog().debug((CharSequence)("major version of jpackage is " + this.jpackageMajorRuntimeVersion));
            if (this.jpackageMajorRuntimeVersion != this.getJavaMajorRuntimeVersion()) {
                this.getLog().warn((CharSequence)("jpackage tool's major version " + this.jpackageMajorRuntimeVersion + " differs from jlink/jdeps version " + this.getJavaMajorRuntimeVersion()));
            }
            if (this.packageImageTemplate == null) {
                throw new MojoExecutionException("packageImageTemplate missing");
            }
            if (this.packageInstallerTemplate == null) {
                throw new MojoExecutionException("packageInstallerTemplate missing");
            }
            if (this.isWithUpdater() && StringHelper.isAllWhitespace((String)this.packageUpdateTemplate)) {
                throw new MojoExecutionException("packageUpdateTemplate missing");
            }
            return true;
        }
        return false;
    }

    @Override
    protected void installTemplates(boolean overwrite) throws MojoExecutionException {
        this.installTemplate(PACKAGE_IMAGE_TEMPLATE, this.packageImageTemplate, overwrite);
        this.installTemplate(PACKAGE_INSTALLER_TEMPLATE, this.packageInstallerTemplate, overwrite);
        if (this.getPackageUpdateTemplate() != null) {
            this.installTemplate(PACKAGE_UPDATE_TEMPLATE, this.packageUpdateTemplate, overwrite);
        }
    }

    private void patchConfigFile(File configFile, JLinkResolver.Result result, String mainJarName) throws MojoExecutionException {
        boolean patchClassPath = result.isClassPathRequired();
        boolean classPathPatched = false;
        boolean patchModulePath = result.isModulePathRequired();
        boolean modulePathPatched = false;
        boolean patchMainJar = !result.isModular();
        boolean mainJarPatched = false;
        this.getLog().debug((CharSequence)("patching configfile " + String.valueOf(configFile)));
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), Settings.getEncodingCharset()));){
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                if (patchClassPath && line.startsWith(APP_CLASSPATH)) {
                    if (classPathPatched && this.jpackageMajorRuntimeVersion >= 15) {
                        this.getLog().debug((CharSequence)("removed line: " + line));
                        buf.setLength(buf.length() - line.length());
                        continue;
                    }
                    this.getLog().debug((CharSequence)("old classpath = " + line.substring(APP_CLASSPATH.length())));
                    buf.setLength(buf.length() - line.length() + APP_CLASSPATH.length());
                    buf.append(result.generateClassPath());
                    classPathPatched = true;
                }
                if (patchMainJar && line.startsWith(APP_MAINJAR)) {
                    if (mainJarPatched) {
                        throw new MojoExecutionException("more than one 'app.mainjar=' found in " + String.valueOf(configFile));
                    }
                    this.getLog().debug((CharSequence)("old mainjar = " + line.substring(APP_MAINJAR.length())));
                    buf.setLength(buf.length() - line.length() + APP_MAINJAR.length());
                    buf.append(this.getImagePathPrefix()).append('/').append("cp").append('/').append(mainJarName);
                    mainJarPatched = true;
                }
                if (patchModulePath) {
                    if (line.equals(JAVA_OPTIONS)) {
                        if (modulePathPatched) {
                            throw new MojoExecutionException("more than one '[JavaOptions]' found in " + String.valueOf(configFile));
                        }
                        if (this.jpackageMajorRuntimeVersion >= 15) {
                            if (patchClassPath && !classPathPatched) {
                                buf.setLength(buf.length() - JAVA_OPTIONS.length() - 2);
                                buf.append('\n').append(APP_CLASSPATH).append(result.generateClassPath()).append("\n\n").append(JAVA_OPTIONS);
                                classPathPatched = true;
                            }
                        } else {
                            buf.append("\n-p\n").append(result.generateModulePath());
                            modulePathPatched = true;
                        }
                    } else if ((line.equals(APPDIR_MODS) || line.equals(APPDIR_MODS_WINDOWS)) && this.jpackageMajorRuntimeVersion >= 15) {
                        if (modulePathPatched) {
                            throw new MojoExecutionException("more than one 'java-options=$APPDIR/mods' found in " + String.valueOf(configFile));
                        }
                        buf.setLength(buf.length() - APPDIR_MODS.length());
                        buf.append("java-options=").append(result.generateModulePath()).append('\n');
                        modulePathPatched = true;
                    }
                }
                buf.append('\n');
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot read from config file " + String.valueOf(configFile), (Exception)e);
        }
        if (patchClassPath && !classPathPatched) {
            throw new MojoExecutionException("could not patch classpath");
        }
        if (patchModulePath && !modulePathPatched) {
            throw new MojoExecutionException("could not patch modulepath");
        }
        try (BufferedWriter configWriter = Files.newBufferedWriter(configFile.toPath(), Settings.getEncodingCharset(), StandardOpenOption.TRUNCATE_EXISTING);){
            configWriter.append(buf);
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not patch config file " + String.valueOf(configFile), (Exception)e);
        }
    }

    private List<File> loadConfigFiles(File configDir) {
        ArrayList<File> configFiles = new ArrayList<File>();
        String[] configNames = configDir.list((d, n) -> n.toLowerCase(Locale.ROOT).endsWith(CONFIG_EXTENSION));
        if (configNames != null) {
            for (String configName : configNames) {
                configFiles.add(new File(configDir, configName));
            }
        }
        return configFiles;
    }

    private File locateAppDirectory(File appImageDir) {
        File appDir = this.loadAppDirectory(appImageDir);
        if (appDir == null && (appDir = this.loadAppDirectory(new File(appImageDir, "lib"))) == null) {
            appDir = this.loadAppDirectory(new File(appImageDir, "Contents"));
        }
        return appDir;
    }

    private File loadAppDirectory(File dir) {
        String[] names = dir.list();
        if (names != null) {
            for (String name : names) {
                if (!"app".equalsIgnoreCase(name)) continue;
                return new File(dir, name);
            }
        }
        return null;
    }

    private String determineMainJar(JLinkResolver.Result result) throws MojoExecutionException {
        String jarName = null;
        if (this.mainJar == null) {
            jarName = result.getClassPath().getFirst().getFile().getName();
        } else {
            for (Artifact artifact : result.getClassPath()) {
                if (!artifact.getFile().getName().contains(this.mainJar)) continue;
                jarName = artifact.getFile().getName();
                break;
            }
        }
        if (jarName == null) {
            throw new MojoExecutionException("cannot determine main jar");
        }
        return jarName;
    }
}

