/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.AbstractGenerator;
import org.tentackle.maven.GeneratedFile;
import org.tentackle.maven.GeneratedString;
import org.tentackle.maven.TemplateModel;
import org.tentackle.maven.plugin.jlink.JLinkMojo;
import org.tentackle.maven.plugin.jlink.JLinkResolver;
import org.tentackle.maven.plugin.jlink.TemplateModelFactory;

public class JLinkGenerator
extends AbstractGenerator {
    private final JLinkMojo mojo;
    private final JLinkResolver.Result result;

    public JLinkGenerator(JLinkMojo mojo, JLinkResolver.Result result) {
        this.mojo = mojo;
        this.result = result;
        this.setTemplateDirectory(mojo.getTemplateDir());
        this.setLogger(mojo.getLog());
    }

    public void generateScripts() throws MojoExecutionException {
        block4: {
            try {
                Configuration cfg = this.createFreemarkerConfiguration();
                TemplateModel model = TemplateModelFactory.getInstance().create(this.mojo, this.result);
                String output = new GeneratedString(cfg, (Map)model, this.mojo.getNameTemplate()).generate();
                StringTokenizer stok = new StringTokenizer(output);
                if (stok.hasMoreTokens()) {
                    String fileName = stok.nextToken();
                    File scriptFile = new File(new File(this.mojo.getImageDirectory(), "bin"), fileName);
                    GeneratedFile generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getRunTemplate(), scriptFile);
                    generatedFile.generate();
                    scriptFile.setExecutable(true);
                    model.putValue("runScript", (Object)fileName);
                    if (this.mojo.getUpdateTemplate() != null) {
                        scriptFile = new File(new File(this.mojo.getImageDirectory(), "bin"), StringHelper.getPlatform().contains("win") ? "update.cmd" : "update.sh");
                        generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getUpdateTemplate(), scriptFile);
                        generatedFile.generate();
                        scriptFile.setExecutable(true);
                    }
                    break block4;
                }
                throw new MojoExecutionException("no valid name for runner script");
            }
            catch (TemplateException | IOException e) {
                throw new MojoExecutionException("generating run script failed", (Exception)e);
            }
        }
    }
}

