/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.maven.plugin.jlink.AbstractJLinkMojo;
import org.tentackle.maven.plugin.jlink.JLinkResolver;

@Mojo(name="init", aggregator=true)
public class InitMojo
extends AbstractJLinkMojo {
    private static final String[] TEMPLATES_ALL = new String[]{"name.ftl", "run.ftl", "update.ftl", "package-image.ftl", "package-installer.ftl", "package-update.ftl"};
    @Parameter(defaultValue="true")
    private boolean copyAll;

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.installTemplates(true);
    }

    @Override
    protected void installTemplates(boolean overwrite) throws MojoExecutionException {
        block5: {
            File templateDir;
            block4: {
                templateDir = this.getTemplateDir();
                if (!this.copyAll) break block4;
                for (String name : TEMPLATES_ALL) {
                    this.installTemplate(name, name, true);
                    this.getLog().info((CharSequence)("template '" + name + "' copied to " + String.valueOf(templateDir)));
                }
                break block5;
            }
            String[] names = templateDir.list();
            if (names == null) break block5;
            for (String name : names) {
                File template = new File(templateDir, name);
                if (!template.isFile()) continue;
                try {
                    this.installTemplate(name, name, true);
                    this.getLog().info((CharSequence)("template '" + name + "' restored to its default"));
                }
                catch (MojoExecutionException mx) {
                    this.getLog().warn((CharSequence)("no default template for '" + name + "' -> skipped"));
                }
            }
        }
    }

    @Override
    protected void createJLinkImage(JLinkResolver.Result result) throws MojoExecutionException, MojoFailureException {
    }

    @Override
    public File getImageDirectory() {
        return null;
    }

    @Override
    protected void generateFiles(JLinkResolver.Result result) throws MojoExecutionException {
    }
}

